$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#formPrincipal",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui se encontra o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui se encontra o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos('ANALISE_COTACAO')
  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"))

  if (colunas == null || colunas.analiseCotacao == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, analiseCotacao: ['id'] })
    )
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"))
  }

  if (colunas == null || colunas.analiseCotacaoUltimasCompras == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, analiseCotacaoUltimasCompras: [] })
    )
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"))
  }

  $("#btnConfirmarColunas").on("click", async function () {
    try {
      $.LoadingOverlay("show")

      const novasColunas = retornaNovasColunasInvisiveis()

      if (AnaliseCotacao.opcaoConfirmarColunas === 'ANALISE_COTACAO') {
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({ ...colunas, analiseCotacao: novasColunas })
        )

        $("#tabelaCotacoes").DataTable().columns().visible(true)

        $("#tabelaCotacoes")
          .DataTable()
          .columns()
          .every(function () {
            if (this.dataSrc() === 'id' || novasColunas.indexOf(this.dataSrc()) != -1) {
              this.visible(false)
            }
          })
      } else {
        localStorage.setItem(
          "colunasInvisiveisRelatorios",
          JSON.stringify({ ...colunas, analiseCotacaoUltimasCompras: novasColunas })
        )

        $("#tabelaUltimasCompras").DataTable().columns().visible(true)

        $("#tabelaUltimasCompras")
          .DataTable()
          .columns()
          .every(function () {
            if (novasColunas.indexOf(this.dataSrc()) != -1) {
              this.visible(false)
            }
          })
      }
    } finally {
      $.LoadingOverlay("hide")
      $("#modal-ColunasVisiveis").modal("hide")
    }
  })

  componenteFiltro('cotacao', true, true, 'Cotacoes')
  componenteFiltro('centroCusto', true, true, 'CentrosCusto')
  componenteFiltro('material', true, true, 'Materiais')
  componenteFiltro('fornecedor', true, true, 'Fornecedores')
  componenteFiltro('cor', true, true, 'Cores')

  $('#btnConsultar').on('click', async function () {
    consultar()
  })

  async function consultar() {
    $.LoadingOverlay('show')
    const filtros = await retornarFiltros()
    const idUsuario = getCookie('id_usuario')
    buscarDados({ filtros, idUsuario }).then((resultado) => {
      if (!resultado) {
        msgErro('Nenhum registro encontrado.')
        return
      }

      const { cotacoes, ultimasCompras } = resultado
      AnaliseCotacao.criarTabelaCotacoes({ data: cotacoes })
      AnaliseCotacao.criarTabelaUltimasCompras({ data: ultimasCompras })
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => {
      $.LoadingOverlay('hide')
    })
  }

  async function buscarDados({ filtros, idUsuario }) {
    const response = await requisicao('GET', `/sisplan/analise_cotacao/v1/analise?`, `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&ID_USUARIO=${idUsuario}`, '', 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  async function retornarFiltros() {
    const cotacoes = $('#txtCotacoes').val()
    const materiais = await formataListas($('#txtMateriais').val().toString())
    const fornecedores = await formataListas($('#txtFornecedores').val().toString())
    const cores = await formataListas($('#txtCores').val().toString())
    const centrosCusto = await formataListas($('#txtCentrosCusto').val().toString())
    const situacao = $('#selectSituacao').val()
    const status = $('#selectStatus').val()
    const nivelLiberacao = $('#selectNivel').val()

    return {
      cotacoes,
      codigos: materiais,
      fornecedores,
      cores,
      centrosCusto,
      situacao,
      status,
      nivelLiberacao,
    }
  }

  const retornarDadosGravar = async () => {
    const cotacoes = $('#tabelaCotacoes').DataTable().data().toArray()

    return {
      cotacoes,
    }
  }

  const gravar = async () => {
    if (!$.fn.DataTable.isDataTable('#tabelaCotacoes')) {
      msgErro('Nenhum registro consultado, impossível continuar.')
      return
    }
    $.LoadingOverlay('show')
    const dados = await retornarDadosGravar()
    enviarDadosGravar({ dados })
      .then(() => {
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      })
      .finally(() => $.LoadingOverlay('hide'))
  }

  const enviarDadosGravar = async ({ dados }) => {
    const response = await requisicao('POST', `/sisplan/analise_cotacao/v1/cotacoes?`, '', JSON.stringify(dados), 3600000)
    const json = await response.json()

    if (json) {
      const { mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }
    }
  }

  $('#tabelaCotacoes').on('click', '#btnAlterar', async function () {
    if (permissaoUsuarioLogado.ALTERA !== 'S') {
      msgErro('Sem permissão para alterar!')
      return
    }
    const datatable = $('#tabelaCotacoes').DataTable()
    const linha = datatable?.row($(this)?.parents('tr'))
    const dados = linha?.data()
    linha?.select()
    ModalManutencaoAnaliseCotacao.carregarModal({ dados })
  })

  $('#tabelaCotacoes').on('click', '#btnBaixarAnexo', async function () {
    const datatable = $('#tabelaCotacoes').DataTable()
    const linha = datatable?.row($(this)?.parents('tr'))
    const dados = linha?.data()
    carregarAnexo({ numero: dados?.numero, codigo: dados?.codigo, cor: dados?.cor })
  })

  $('#tabelaCotacoes').on('click', '#btnDuplicar', async function () {
    if (permissaoUsuarioLogado.ALTERA !== 'S') {
      msgErro('Sem permissão para alterar!')
      return
    }
    const datatable = $('#tabelaCotacoes').DataTable()
    const linha = datatable?.row($(this)?.parents('tr'))
    const dados = linha?.data()
    const dadosTabela = datatable.data().toArray()
    if (!dados || !dadosTabela) {
      return
    }
    duplicarCotacao({ dados, dadosTabela })
  })

  const duplicarCotacao = ({ dados, dadosTabela }) => {
    const { novoNumero, indexInserir } = retornarNovoNumero(dados?.numero)
    const novaLinha = { ...dados, numero: novoNumero, id: 0, corLinha: 'Padrao' }
    dadosTabela.splice(indexInserir, 0, novaLinha)
    AnaliseCotacao.criarTabelaCotacoes({ data: dadosTabela })
  }

  $('#btnGravar').on('click', () => {
    if (permissaoUsuarioLogado.ALTERA !== 'S') {
      msgErro('Sem permissão para alterar!')
      return
    }
    msgAlerta(
      'Deseja realmente gravar os dados?',
      () => { },
      () => { },
      () => gravar(),
    )
  })

  $('#btnLiberarSelecionados').on('click', () => {
    if (permissaoUsuarioLogado.ALTERA !== 'S') {
      msgErro('Sem permissão para alterar!')
      return
    }
    msgAlerta(
      'Deseja realmente liberar os registros selecionados?',
      () => { },
      () => { },
      () => liberarCotacoesSelecionadas(),
    )
  })

  const liberarCotacoesSelecionadas = () => {
    if (!$.fn.DataTable.isDataTable('#tabelaCotacoes')) {
      msgErro('Nenhum registro consultado, impossível continuar.')
      return
    }
    const cotacoesSelecionadas = $('#tabelaCotacoes')?.DataTable()?.data()?.toArray()?.filter((item) => item.sel)
    if (!cotacoesSelecionadas || cotacoesSelecionadas.length === 0) {
      msgErro('Nenhum registro selecionado, impossível continuar.')
      return
    }
    $.LoadingOverlay('show')
    enviarDadosAtualizarStatus({
      cotacoes: cotacoesSelecionadas,
      status: 'L',
    })
      .then(() => {
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      })
      .finally(() => $.LoadingOverlay('hide'))
  }

  const enviarDadosAtualizarStatus = async (dados) => {
    const response = await requisicao('PATCH', `/sisplan/analise_cotacao/v1/status?`, '', JSON.stringify(dados), 3600000)
    const json = await response.json()

    if (json) {
      const { mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }
    }
  }

  $('#btnBloquearSelecionados').on('click', () => {
    if (permissaoUsuarioLogado.ALTERA !== 'S') {
      msgErro('Sem permissão para alterar!')
      return
    }
    msgAlerta(
      'Deseja realmente bloquear os registros selecionados?',
      () => { },
      () => { },
      () => bloquearCotacoesSelecionadas(),
    )
  })

  const bloquearCotacoesSelecionadas = () => {
    if (!$.fn.DataTable.isDataTable('#tabelaCotacoes')) {
      msgErro('Nenhum registro consultado, impossível continuar.')
      return
    }
    const cotacoesSelecionadas = $('#tabelaCotacoes')?.DataTable()?.data()?.toArray()?.filter((item) => item.sel)
    if (!cotacoesSelecionadas || cotacoesSelecionadas.length === 0) {
      msgErro('Nenhum registro selecionado, impossível continuar.')
      return
    }
    $.LoadingOverlay('show')
    enviarDadosAtualizarStatus({
      cotacoes: cotacoesSelecionadas,
      status: 'B',
    })
      .then(() => {
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      })
      .finally(() => $.LoadingOverlay('hide'))
  }

  const carregarAnexo = async ({ numero, codigo, cor }) => {
    $.LoadingOverlay('show')
    baixarAnexo({ numero, codigo, cor })
      .then((resultado) => {
        if (!resultado) {
          msgErro('Anexo não encontrado.')
          return
        }

        const dados = JSON.parse(resultado)
        const base64 = dados.conteudo
        const byteCharacters = atob(base64)
        const byteNumbers = Array.from(byteCharacters).map(c => c.charCodeAt(0))
        const byteArray = new Uint8Array(byteNumbers)
        const blob = new Blob([byteArray], { type: 'application/octet-stream' })
        const link = document.createElement('a')
        link.href = URL.createObjectURL(blob)
        link.download = `${dados.nome}${dados.extensao}`
        document.body.appendChild(link)
        link.click()
        link.remove()
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao carregar o anexo.')
      })
      .finally(() => $.LoadingOverlay('hide'))
  }

  const baixarAnexo = async ({ numero, codigo, cor }) => {
    const filtros = {
      numero,
      codigo,
      cor,
    }
    const response = await requisicao('GET', `/sisplan/analise_cotacao/v1/anexos?`, `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  const retornarNovoNumero = (numeroOriginal) => {
    const numeroSemBarra = numeroOriginal.substring(0, numeroOriginal.indexOf('/'))
    const dadosTabela = $('#tabelaCotacoes')
      .DataTable()
      .data()
      .toArray()
    const {
      sequencial: sequencialMaisAlto,
      index
    } = dadosTabela
      .reduce((original, { numero }, index) => {
        if (numero.substring(0, numeroOriginal.indexOf('/')) !== numeroSemBarra) {
          return original
        }
        const sequencial = Number(numero.substring(numero.indexOf('/') + 1, numero.length))
        if (sequencial > original.sequencial) {
          return {
            sequencial,
            index,
          }
        }
        return original
      }, { sequencial: 0, index: 0 })

    const novoNumero = `${numeroSemBarra}/${String(sequencialMaisAlto + 1)}`

    return {
      novoNumero,
      indexInserir: index + 1,
    }
  }
})

window.AnaliseCotacao = window.AnaliseCotacao || {}

AnaliseCotacao.opcaoConfirmarColunas = 'ANALISE_COTACAO'

AnaliseCotacao.ultimoRegistroSelecionado = {
  codigo: '',
  cor: '',
}

AnaliseCotacao.criarTabelaCotacoes = ({ data }) => {
  if ($.fn.DataTable.isDataTable('#tabelaCotacoes')) {
    $('#tabelaCotacoes').DataTable().destroy()
    $('#tabelaCotacoes').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (data, _type, _row, { row: rowIndex, col: colIndex }) => {
        const checked = data ? 'checked' : ''
        return (
          `<div class="icheck-primary d-inline">
          <input ${checked} type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
        )
      }
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
    {
      data: 'numero',
      title: 'Número',
      render: function (data, _type, row) {
        let corFundo = ''
        switch (row.corLinha) {
          case 'Azul':
            corFundo = 'var(--hover-color)'
            break
          case 'Verde':
            corFundo = '#3CB371'
            break
          default:
            break
        }

        return `<div style="text-align:start;">
                <button
                  class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes"
                  id="tutorialTabela"
                  type="button"
                  data-toggle="dropdown"
                  aria-haspopup="true"
                  aria-expanded="false"
                  ${corFundo && `style="background-color: ${corFundo} !important; border-color: ${corFundo} !important; color: #fff"`}
                >
                  ${data}
                </button>
                <div class="dropdown-menu">
                <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>
                <button class="dropdown-item" type="button" title="Baixar anexo" id="btnBaixarAnexo">Baixar Anexo</button>
                <button class="dropdown-item" type="button" title="Duplicar" id="btnDuplicar">Duplicar</button>
            </div>`
      }
    },
    {
      data: 'solicitacao',
      title: 'Solicitação',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'condicaoPagamento',
      title: 'Condição Pagamento',
    },
    {
      data: 'descricaoCondicaoPagamento',
      title: 'Descrição Condição Pagamento',
    },
    {
      data: 'moeda',
      title: 'Moeda',
    },
    {
      data: 'descricaoMoeda',
      title: 'Descrição Moeda',
    },
    {
      data: 'quantidadeCotada',
      title: 'Quantidade Cotada',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'quantidadeOrdemCompra',
      title: 'Quantidade Ordem Compra',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'precoOriginal',
      title: 'Preço Original',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'percentualDesconto',
      title: 'Percentual Desconto',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'valorDesconto',
      title: 'Valor Desconto',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'frete',
      title: 'Frete',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'codigoFornecedor',
      title: 'Código Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome Fornecedor',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'tipoItem',
      title: 'Tipo',
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'indice',
      title: 'Índice',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'dataEntregaPrevista',
      title: 'Data Entrega Prevista',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true })
      },
    },
    {
      data: 'codigoItemFornecedor',
      title: 'Código Item Fornecedor',
    },
    {
      data: 'descricaoItemFornecedor',
      title: 'Descrição Item Fornecedor',
    },
    {
      data: 'corFornecedor',
      title: 'Cor Fornecedor',
    },
    {
      data: 'fatorConversaoFornecedor',
      title: 'Fator Conversão Fornecedor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data })
      }
    },
    {
      data: 'entregaFornecedor',
      title: 'Entrega Fornecedor',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true })
      },
    },
    {
      data: 'fabricante',
      title: 'Fabricante',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
  ]

  const table = $('#tabelaCotacoes').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: true,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data: data ?? [],
    columns,
    scrollX: true,
    scrollY: '415px',
    select: {
      style: 'single',
      toggleable: false,
    },
    colReorder: true,
  })
  let selectedRowIndex = 0
  AnaliseCotacao.ultimoRegistroSelecionado.codigo = data?.[0]?.codigo ?? ''
  AnaliseCotacao.ultimoRegistroSelecionado.cor = data?.[0]?.cor ?? ''

  function selectRow(index) {
    const row = table.row(index)
    if (row.node()) {
      table.rows().deselect()
      table.row(index).select()
      selectedRowIndex = index
    }
  }
  selectRow(selectedRowIndex)

  table.off('select')
  table.on('select', function (_e, _dt, type, indexes) {
    if (type === 'row') {
      const data = table.rows(indexes[0]).data().toArray()
      const codigo = data?.[0]?.codigo
      const cor = data?.[0]?.cor
      if (codigo === AnaliseCotacao.ultimoRegistroSelecionado.codigo && cor === AnaliseCotacao.ultimoRegistroSelecionado.cor) {
        return
      }

      AnaliseCotacao.ultimoRegistroSelecionado.codigo = codigo
      AnaliseCotacao.ultimoRegistroSelecionado.cor = cor
      selectedRowIndex = indexes[0]
      if (!data || data.length === 0) {
        return
      }
      AnaliseCotacao.carregarUltimasCompras({ codigo, cor })
    }
  })

  const colunasInvisiveis = JSON.parse(
    localStorage.getItem("colunasInvisiveisRelatorios")
  )

  $("#tabelaCotacoes_length").prepend(
    '<button type="button" class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>'
  )
  $("#tabelaCotacoes_length").prepend(
    '<button type="button" class="buttonExcel ml-0" id="buttonExcel"><i class="fas fa-file-excel"></i></button>'
  )

  $("#buttonColVis").on("click", async function () {
    $.LoadingOverlay("show")
    AnaliseCotacao.opcaoConfirmarColunas = 'ANALISE_COTACAO'
    $("#modal-ColunasVisiveis").modal("show")
    $.LoadingOverlay("hide")
  })

  $("#buttonExcel").on("click", async function () {
    const cotacoes = structuredClone($('#tabelaCotacoes').DataTable().data().toArray())
    await exportaCSV(
      '',
      '',
      false,
      null,
      "Relatório de Análise de Cotação",
      "#tabelaCotacoes",
      '',
      999,
      false,
      false,
      cotacoes,
    )
  })

  $("#buttonColVis").prop("title", "Configurar colunas")
  $("#buttonExcel").prop("title", "Exportar CSV")

  $("#tabelaCotacoes")
    .DataTable()
    .columns()
    .every(function () {
      if (
        colunasInvisiveis.analiseCotacao.indexOf(this.dataSrc()) != -1
      ) {
        this.visible(false)
      }
    })

  $('#cbSelAll').off('click')
  $('#cbSelAll').on('click', function () {
    const isChecked = $(this).prop('checked')
    table.rows().every(function () {
      const rowData = this.data()
      const rowIndex = this.index()
      const inputCheckbox = $(this.node()).find('.checkSel')
      $(inputCheckbox).prop('checked', isChecked)
      rowData.sel = isChecked
      table.row(rowIndex).data(rowData)
    })
    table.draw(false)
  })

  $('#tabelaCotacoes').off('change', '.checkSel')
  $('#tabelaCotacoes').on('change', '.checkSel', function () {
    const isChecked = $(this).prop('checked')
    const row = table.row($(this).closest('tr'))
    const rowData = row.data()
    rowData.sel = isChecked
    row.data(rowData).draw(false)
  })

  $("#modal-ColunasVisiveis").on("show.bs.modal", function () {
    const cols = []

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    )
    if (AnaliseCotacao.opcaoConfirmarColunas == 'ANALISE_COTACAO') {
      $("#tabelaCotacoes")
        .DataTable()
        .columns()
        .every(function () {
          if (['sel', 'numero', 'id'].includes(this.dataSrc())) {
            return
          }
          cols.push({
            title: $(this.header()).text(),
            data: this.dataSrc(),
          })
        })
      adicionaColunas(cols, colunasInvisiveis.analiseCotacao ?? [])
    } else {
      $("#tabelaUltimasCompras")
        .DataTable()
        .columns()
        .every(function () {
          cols.push({
            title: $(this.header()).text(),
            data: this.dataSrc(),
          })
        })
      adicionaColunas(cols, colunasInvisiveis.analiseCotacaoUltimasCompras ?? [])
    }
  })
}

AnaliseCotacao.atualizarCotacaoSelecionada = ({ dados, opcoesAtualizar }) => {
  const datatable = $('#tabelaCotacoes').DataTable()
  const [indiceLinhaSelecionada] = datatable.rows({ selected: true }).indexes().toArray()

  if (indiceLinhaSelecionada === undefined && indiceLinhaSelecionada === null) {
    return
  }

  const linhaSelecionada = datatable.row(indiceLinhaSelecionada)
  const dadosAtuais = linhaSelecionada.data()
  const dadosAtualizados = { ...dadosAtuais, ...dados }
  linhaSelecionada.data(dadosAtualizados).draw(false)

  const dadosDatatable = datatable.data().toArray()

  AnaliseCotacao.atualizarCamposTodasAsLinhas({ dadosAtualizar: dados, opcoesAtualizar, dadosDatatable })
}

AnaliseCotacao.atualizarCamposTodasAsLinhas = ({ dadosAtualizar, opcoesAtualizar, dadosDatatable }) => {
  let dadosSofreramAlteracoes = false

  if (opcoesAtualizar.condicao === 'TODOS_REGISTROS') {
    dadosSofreramAlteracoes = true
    dadosDatatable = dadosDatatable.map((item) => ({
      ...item,
      condicaoPagamento: dadosAtualizar.condicaoPagamento,
      descricaoCondicaoPagamento: dadosAtualizar.descricaoCondicaoPagamento,
    }))
  } else if (opcoesAtualizar.condicao === 'REGISTROS_SELECIONADOS') {
    dadosSofreramAlteracoes = true
    dadosDatatable = dadosDatatable.map((item) => {
      if (!item.sel) {
        return item
      }

      return {
        ...item,
        condicaoPagamento: dadosAtualizar.condicaoPagamento,
        descricaoCondicaoPagamento: dadosAtualizar.descricaoCondicaoPagamento,
      }
    })
  }

  if (opcoesAtualizar.moeda === 'TODOS_REGISTROS') {
    dadosSofreramAlteracoes = true
    dadosDatatable = dadosDatatable.map((item) => ({
      ...item,
      moeda: dadosAtualizar.moeda,
      descricaoMoeda: dadosAtualizar.descricaoMoeda,
    }))
  } else if (opcoesAtualizar.moeda === 'REGISTROS_SELECIONADOS') {
    dadosSofreramAlteracoes = true
    dadosDatatable = dadosDatatable.map((item) => {
      if (!item.sel) {
        return item
      }

      return {
        ...item,
        moeda: dadosAtualizar.moeda,
        descricaoMoeda: dadosAtualizar.descricaoMoeda,
      }
    })
  }

  if (dadosSofreramAlteracoes) {
    AnaliseCotacao.criarTabelaCotacoes({ data: dadosDatatable })
  }
}

AnaliseCotacao.carregarUltimasCompras = ({ codigo, cor }) => {
  $.LoadingOverlay('show')
  AnaliseCotacao.retornarUltimasCompras({ codigo, cor })
    .then((resultado) => AnaliseCotacao.criarTabelaUltimasCompras({ data: resultado }))
    .catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar as últimas compras.')
    }).finally(() => $.LoadingOverlay('hide'))
}

AnaliseCotacao.retornarUltimasCompras = async ({ codigo, cor }) => {
  const response = await requisicao('GET', `/sisplan/analise_cotacao/v1/ultimascompras?`, `CODIGO=${encodeURIComponent(codigo)}&COR=${encodeURIComponent(cor)}`, '', 3600000)
  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}

AnaliseCotacao.criarTabelaUltimasCompras = ({ data }) => {
  if ($.fn.DataTable.isDataTable('#tabelaUltimasCompras')) {
    $('#tabelaUltimasCompras').DataTable().destroy()
    $('#tabelaUltimasCompras').empty()
  }

  const columns = [
    {
      data: 'codigoFornecedor',
      title: 'Código Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome Fornecedor',
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0,00'
        }
        return data.toLocaleString('pt-BR', {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      }
    },
    {
      data: 'precoEstoque',
      title: 'Preço Estoque',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0,00'
        }
        return data.toLocaleString('pt-BR', {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      className: 'text-right',
      render: function (data) {
        if (!data) {
          return '0,00'
        }
        return data.toLocaleString('pt-BR', {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
        })
      }
    },
    {
      data: 'data',
      title: 'Data',
      render(data) {
        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23: 59: 59`))
      },
    },
  ]

  $('#tabelaUltimasCompras').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: true,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    autoWidth: true,
    data: data ?? [],
    columns,
    scrollX: true,
    scrollY: '290px',
    colReorder: true,
  })

  const colunasInvisiveis = JSON.parse(
    localStorage.getItem("colunasInvisiveisRelatorios")
  )

  $("#tabelaUltimasCompras_length").prepend(
    '<button type="button" class="buttonColVis" id="buttonColVisUltimasCompras"><i class="fas fa-cogs"></i></button>'
  )
  $("#tabelaUltimasCompras_length").prepend(
    '<button type="button" class="buttonExcel ml-0" id="buttonExcelUltimasCompras"><i class="fas fa-file-excel"></i></button>'
  )

  $("#buttonColVisUltimasCompras").on("click", async function () {
    $.LoadingOverlay("show")
    AnaliseCotacao.opcaoConfirmarColunas = 'ULTIMAS_COMPRAS'
    $("#modal-ColunasVisiveis").modal("show")
    $.LoadingOverlay("hide")
  })

  $("#buttonExcelUltimasCompras").on("click", async function () {
    const ultimasCompras = structuredClone($('#tabelaUltimasCompras').DataTable().data().toArray())
    await exportaCSV(
      '',
      '',
      false,
      null,
      "Relatório de Últimas Compras",
      "#tabelaUltimasCompras",
      '',
      999,
      false,
      false,
      ultimasCompras,
    )
  })

  $("#buttonColVisUltimasCompras").prop("title", "Configurar colunas")
  $("#buttonExcelUltimasCompras").prop("title", "Exportar CSV")

  $("#tabelaUltimasCompras")
    .DataTable()
    .columns()
    .every(function () {
      if (
        colunasInvisiveis.analiseCotacaoUltimasCompras.indexOf(this.dataSrc()) != -1
      ) {
        this.visible(false)
      }
    })

  $('#btnGerarOrdemCompra').on('click', function () {
    const dados = retornarDadosGerarOrdemCompra()
    if (!ModalGerarOrdemCompra.validarDados({ itens: dados.itens })) {
      return
    }
    ModalGerarOrdemCompra.carregar({ itens: dados.itens, fornecedor: dados.fornecedor, entrega: dados.entrega, moeda: dados.moeda })
    ModalGerarOrdemCompra.abrir()
  })

  function retornarDadosGerarOrdemCompra() {
    const cotacoes = $('#tabelaCotacoes').DataTable().data().toArray().filter((item) => !!item.sel)
    const itens = cotacoes.map((item) => ({
      codigo: item.codigo,
      descricao: item.descricao,
      cor: item.cor,
      tam: item.tamanho,
      qtde: item.quantidade,
      preco: item.preco,
      valor: (safeParseFloat(item.quantidade) ?? 0) * (safeParseFloat(item.preco) ?? 0),
      tp_item: item.tipoItem,
      centroCusto: item.centroCusto,
    }))
    const fornecedor = cotacoes?.[0]?.codigoFornecedor ?? ""
    const entrega = retornarDataISOEmYMD({ dataISO: new Date(cotacoes?.[0]?.entregaFornecedor), separadorData: '-' })
    const moeda = {
      codigo: cotacoes?.[0]?.moeda ?? "",
      descricao: cotacoes?.[0]?.descricaoMoeda ?? "",
    }

    return {
      itens,
      fornecedor,
      entrega,
      moeda,
    }
  }
}