<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Funcionário</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2510.7.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2510.7.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.7.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2510.7.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2510.7.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2510.7.1">

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .form-control:disabled,
    .form-control[readonly] {
      background-color: #f7f7f7;
      opacity: 1;
    }

    #msform {
      text-align: start;
      position: relative;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card.card-header {
      border-bottom: 1px dashed #ddd;
      box-shadow: none !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: var(--font-color);
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    #btnRepresentante {
      background-color: #3ca2d3 !important;
    }

    #btnTransportadora {
      background-color: #5F9EA0 !important;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 0 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }
    
    .icheck-primary{
      margin-bottom: 0px !important;
    }
    
  </style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText">Modal body text goes here.</p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary btn-sisp">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary btn-sisp" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

  </div>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6 col-12">
          </div><!-- /.col -->
          <div class="col-sm-6 col-12">
            <!-- <ol class="breadcrumb float-sm-right">
              
              <li class="breadcrumb-item"><a href="../cliente">Funcionários</a></li>
              <li class="breadcrumb-item active">Cadastro</li>
            </ol> -->
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card" style="height:auto;min-height:715px">
              <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                <h2 class="m-0">Cadastro de Funcionário</h2>
                <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                  <i class="fas fa-question-circle"></i>
                </button>
              </div>
              <fieldset>
                <div class="card-body">
                  <form style="text-align:left!important;" id="msform" name="msform">
                    <div class="card card-header" role="tab" id="geral">
                      <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample1" href="#multiCollapseExample1" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="row">
                          <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                            <i class="fas fa-angle-down"></i>
                          </div>
                          <div class="col-11">
                            <h4 class="title-page">
                              Geral
                            </h4>
                          </div>
                        </div>
                      </a>
                    </div>
                    <div class="collapse show" id="multiCollapseExample1">
                      <div class="card card-body">
                        <div class="tab-pane fade show active pt-2" role="tabpanel" aria-labelledby="geral-tab">
                          <div class="form-row">
                            <div class="col-md-6 col-12 form mb-0 pb-0">
                              <fieldset class="form border-Field">
                                <legend class="textoBorda pt-0 mb-0">Opções</legend>
                                <div class="form-row d-flex">
                                  <div class="icheck-primary form-group ml-4 mr-2">
                                    <input type="checkbox" class="form-check-input" id="cbAtivo">
                                    <label class="form-check-label" for="cbAtivo">Ativo</label>
                                  </div>
                                  <div class="icheck-primary form-check mx-2">
                                    <input type="checkbox" class="form-check-input" id="cbAfastado">
                                    <label class="form-check-label" for="cbAfastado">Afastado</label>
                                  </div>
                                  <div class="icheck-primary form-check mx-2">
                                    <input type="checkbox" class="form-check-input" id="cbEPI">
                                    <label class="form-check-label" for="cbEPI">E.P.I</label>
                                  </div>
                                  <div class="icheck-primary form-check mx-2">
                                    <input type="checkbox" class="form-check-input" id="cbValeTransporte">
                                    <label class="form-check-label" for="cbValeTransporte">Vale Transporte</label>
                                  </div>
                                </div>
                              </fieldset>
                            </div>
                            <div class="form-group col-md-6 col-12" id="empresaTour">
                              <label>Empresa</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtEmpresa" name="txtEmpresa" placeholder="Empresa">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnEmpresa" name="btnEmpresa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaEmpresa" name="btnLimpaEmpresa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="form-row pt-0">
                            <div class="col-md-2 col-12 form-group" id="tourcodigo">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodFun">Código *</label>
                              <input type="text" class="input-default focus form-control" id="txtCodFun" aria-describedby="codError" name="txtCodFun" class="form-control" required placeholder="Gerado automaticamente" readonly disabled>
                            </div>
                            <div class="form-group col-md-6" id="nomeTour">
                              <label>Nome *</label>
                              <input type="text" class="input-default focus form-control validate" id="txtNome" name="txtNome" required placeholder="Nome">
                            </div>
                            <div class="form-group col-md-3 col-6" id="CPFTour">
                              <label>CPF *</label>
                              <input type="text" class="input-default focus form-control validate" id="txtCPF" name="txtCPF" required placeholder="CPF" maxlength="18">
                            </div>
                            <div class="form-group col-md-1 col-12">
                              <label>Cadastro</label>
                              <input type="text" class="input-default focus form-control" id="txtCracha" placeholder="Crachá" maxlength="8">
                            </div>
                          </div>
                          <div class="form-row pt-2">
                            <div class="form-group col-md-3 col-6">
                              <label>RG</label>
                              <input type="text" class="input-default focus form-control" name="txtRG" id="txtRG" placeholder="RG" maxlength="15">
                            </div>
                            <div class="form-group col-md-3 col-6">
                              <label>Data de emissão RG</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataEmissaoRG">
                            </div>
                            <div class="form-group col-md-3 col-8" id="nomeTour">
                              <label>Emissor</label>
                              <input type="text" class="input-default focus form-control validate" id="txtEmissor" name="txtEmissor" placeholder="Emissor">
                            </div>
                            <div class="form-group col-md-3 col-4" id="UFCarteiraTour">
                              <label>UF Carteira</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtUFCarteira" name="txtUFCarteira" placeholder="UF" maxlength="2">
                              </div>
                            </div>
                          </div>
                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12" id="TEleitorTour">
                              <label>Título de Eleitor</label>
                              <input type="text" class="input-default focus form-control validate" id="txtTEleitor" name="txtTEleitor" placeholder="Título de Eleitor" maxlength="15">
                            </div>
                            <div class="form-group col-md-4 col-12" id="ZonaTour">
                              <label>Zona</label>
                              <input type="text" class="input-default focus form-control validate" id="txtZona" name="txtZona" placeholder="Zona" maxlength="3">
                            </div>
                            <div class="form-group col-md-4 col-12" id="SecaoTour">
                              <label>Seção</label>
                              <input type="text" class="input-default focus form-control validate" id="txtSecao" name="txtSecao" placeholder="Seção" maxlength="4">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12" id="CarteiraTrabalhoTour">
                              <label>Carteira de Trabalho</label>
                              <input type="text" class="input-default focus form-control validate" id="txtCarteiraTrabalho" name="txtCarteiraTrabalho" placeholder="Carteira de Trabalho" maxlength="20">
                            </div>
                            <div class="form-group col-md-4 col-12" id="SerieTour">
                              <label>Série</label>
                              <input type="text" class="input-default focus form-control validate" id="txtSerie" name="txtSerie" placeholder="Série" maxlength="10">
                            </div>
                            <div class="form-group col-md-4 col-12" id="PISTour">
                              <label>PIS</label>
                              <input type="text" class="input-default focus form-control validate" id="txtPIS" name="txtPIS" placeholder="PIS" maxlength="15">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-6" id="CNHTour">
                              <label>CNH</label>
                              <input type="text" class="input-default focus form-control validate" id="txtCNH" name="txtCNH" placeholder="CNH" maxlength="12">
                            </div>
                            <div class="form-group col-md-3 col-6" id="PrimeiraHabilitacaoTour">
                              <label>Primeira Habilitação</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtPrimeiraHabilitacao" name="txtPrimeiraHabilitacao" placeholder="Primeira Habilitação">
                            </div>
                            <div class="form-group col-md-3 col-6" id="VencimentoHabilitacaoTour">
                              <label>Vencimento Habilitação</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtVencimentoHabilitacao" name="txtVencimentoHabilitacao" placeholder="Vencimento Habilitação">
                            </div>
                            <div class="form-group col-md-2 col-6" id="CategoriaCNHTour">
                              <label>Categoria CNH</label>
                              <input type="text" class="input-default focus form-control validate" id="txtCategoriaCNH" name="txtCategoriaCNH" placeholder="Categoria CNH" maxlength="2">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-1 col-12" id="dddTelefoneTour">
                              <label>DDD *</label>
                              <input type="number" class="input-default focus form-control validate" id="txtDDD" name="txtDDD" required placeholder="DDD" maxlength="3">
                            </div>
                            <div class="form-group col-md-3 col-12" id="telefoneTour">
                              <label>Telefone *</label>
                              <input type="text" class="input-default focus form-control validate" id="txtTelefone" name="txtTelefone" required placeholder="Telefone" maxlength="25">
                            </div>
                            <div class="form-group col-md-8 col-12">
                              <label>Email</label>
                              <input type="email" class="input-default focus form-control" name="txtEmail" id="txtEmail" placeholder="exemplo@exemplo.com" maxlength="80">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-3 col-6" id="NascimentoTour">
                              <label>Nascimento</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtNascimento" name="txtNascimento" placeholder="Nascimento">
                            </div>
                            <div class="form-group col-md-3 col-6" id="CidadeNascimentoTour">
                              <label>Cidade Nascimento</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtCidadeNascimento" name="txtCidadeNascimento" placeholder="Cidade Nascimento" maxlength="50">
                              </div>
                            </div>
                            <div class="form-group col-md-3 col-6" id="EstadoNascimentoTour">
                              <label>Estado Nascimento</label>
                              <div class="input-group">
                                <select style="font-size: 1em" class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="ddSelectUFNascimento" style="border-color: #a9a9a9">
                                  <option class="drilldown-item" selected disabled value="">Selecione uma opção</option>
                                  <option class="drilldown-item" value="AC">AC</option>
                                  <option class="drilldown-item" value="AL">AL</option>
                                  <option class="drilldown-item" value="AM">AM</option>
                                  <option class="drilldown-item" value="AP">AP</option>
                                  <option class="drilldown-item" value="BA">BA</option>
                                  <option class="drilldown-item" value="CE">CE</option>
                                  <option class="drilldown-item" value="DF">DF</option>
                                  <option class="drilldown-item" value="ES">ES</option>
                                  <option class="drilldown-item" value="GO">GO</option>
                                  <option class="drilldown-item" value="MA">MA</option>
                                  <option class="drilldown-item" value="MG">MG</option>
                                  <option class="drilldown-item" value="MS">MS</option>
                                  <option class="drilldown-item" value="MT">MT</option>
                                  <option class="drilldown-item" value="PA">PA</option>
                                  <option class="drilldown-item" value="PB">PB</option>
                                  <option class="drilldown-item" value="PE">PE</option>
                                  <option class="drilldown-item" value="PI">PI</option>
                                  <option class="drilldown-item" value="PR">PR</option>
                                  <option class="drilldown-item" value="RJ">RJ</option>
                                  <option class="drilldown-item" value="RN">RN</option>
                                  <option class="drilldown-item" value="RO">RO</option>
                                  <option class="drilldown-item" value="RR">RR</option>
                                  <option class="drilldown-item" value="RS">RS</option>
                                  <option class="drilldown-item" value="SC">SC</option>
                                  <option class="drilldown-item" value="SE">SE</option>
                                  <option class="drilldown-item" value="SP">SP</option>
                                  <option class="drilldown-item" value="TO">TO</option>
                                </select>
                              </div>
                            </div>
                            <div class="form-group col-md-3 col-6" id="NacionalidadeTour">
                              <label>Nacionalidade</label>
                              <input type="text" class="input-default focus form-control validate" id="txtNacionalidade" name="txtNacionalidade" placeholder="Nacionalidade" maxlength="40">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12">
                              <label>Escolaridade</label>
                              <select class="input-default focus custom-select" id="SelectEscolaridade">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="1º Grau Incompleto">Primeiro Grau Incompleto</option>
                                <option class="drilldown-item" value="1º Grau Completo">Primeiro Grau Completo</option>
                                <option class="drilldown-item" value="2º Grau Incompleto">Segundo Grau Incompleto</option>
                                <option class="drilldown-item" value="2º Grau Completo">Segundo Grau Completo</option>
                                <option class="drilldown-item" value="Superior Incompleto">Superior Incompleto</option>
                                <option class="drilldown-item" value="Superior Completo">Superior Completo</option>
                                <option class="drilldown-item" value="Pós Graduação">Pós Graduação</option>
                                <option class="drilldown-item" value="Mestrado">Mestrado</option>
                              </select>
                            </div>
                            <div class="form-group col-md-4 col-12" id="NomePaiTour">
                              <label>Nome Pai</label>
                              <input type="text" class="input-default focus form-control validate" id="txtNomePai" name="txtNomePai" placeholder="Nome Pai" maxlength="50">
                            </div>
                            <div class="form-group col-md-4 col-12" id="NomeMaeTour">
                              <label>Nome Mãe</label>
                              <input type="text" class="input-default focus form-control validate" id="txtNomeMae" name="txtNomeMae" placeholder="Nome Mãe" maxlength="50">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-6">
                              <label>Sexo</label>
                              <select class="input-default focus custom-select" id="SelectSexo">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="M">Masculino</option>
                                <option class="drilldown-item" value="F">Feminino</option>
                              </select>
                            </div>
                            <div class="form-group col-md-4 col-6">
                              <label>Estado Civil</label>
                              <select class="input-default focus custom-select" id="SelectEstadoCivil">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="Solteiro">Solteiro</option>
                                <option class="drilldown-item" value="União Estável">União Estável</option>
                                <option class="drilldown-item" value="Casado">Casado</option>
                                <option class="drilldown-item" value="Divorciado">Divorciado</option>
                                <option class="drilldown-item" value="Viuvo">Viúvo</option>
                                <option class="drilldown-item" value="Concubinato">Concubinato</option>
                              </select>
                            </div>
                            <div class="form-group col-md-4 col-12" id="ConjugeTour">
                              <label>Cônjuge</label>
                              <input type="text" class="input-default focus form-control validate" id="txtConjuge" name="txtConjuge" placeholder="Cônjuge" maxlength="100">
                            </div>
                          </div>

                        </div>
                      </div>
                    </div>

                    <div class="card card-header" role="tab" id="endereco">
                      <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample2" href="#multiCollapseExample2" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="row">
                          <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                            <i class="fas fa-angle-right"></i>
                          </div>
                          <div class="col-11">
                            <h4 class="title-page">
                              Endereço
                            </h4>
                          </div>
                        </div>
                      </a>
                    </div>
                    <div class="collapse" id="multiCollapseExample2">
                      <div class="card card-body">
                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="endereco-tab">

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12" id="CEPTour">
                              <label>CEP</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtCEP" name="txtCEP" placeholder="CEP" maxlength="15">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCEP" name="btnCEP" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaCEP" name="btnLimpaCEP" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-md-4 col-6" id="CidadeTour">
                              <label>Cidade</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtCidade" disabled name="txtCidade" placeholder="Cidade">
                              </div>
                            </div>

                            <div class="form-group col-md-4 col-6" id="UFEnderecoTour">
                              <label>UF</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtUFEndereco" disabled name="txtUFEndereco" placeholder="UF">
                              </div>
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-10 col-8" id="RuaTour">
                              <label>Rua</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtRua" name="txtRua" placeholder="Rua" maxlength="80">
                              </div>
                            </div>

                            <div class="form-group col-md-2 col-4" id="NumeroTour">
                              <label>Número</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtNumero" name="txtNumero" placeholder="Numero" maxlength="10">
                              </div>
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-8 col-6"  id="ComplementoTour">
                              <label>Complemento</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtComplemento" name="txtComplemento" placeholder="Complemento" maxlength="100">
                              </div>
                            </div>

                            <div class="form-group col-md-4 col-6" id="BairroTour">
                              <label>Bairro</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtBairro" name="txtBairro" placeholder="Bairro" maxlength="40">
                              </div>
                            </div>
                          </div>

                        </div>

                      </div>
                    </div>
                    <div class="card card-header" role="tab" id="dados-contratuais">
                      <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample3" href="#multiCollapseExample3" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="row">
                          <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                            <i class="fas fa-angle-right"></i>
                          </div>
                          <div class="col-11">
                            <h4 class="title-page">
                              Dados Contratuais
                            </h4>
                          </div>
                        </div>
                      </a>
                    </div>
                    <div class="collapse" id="multiCollapseExample3">
                      <div class="card card-body">
                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab">

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12" id="FuncaoTour">
                              <label>Função</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtFuncao" name="txtFuncao" placeholder="Função">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnFuncao" name="btnFuncao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaFuncao" name="btnLimpaFuncao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-md-4 col-12" id="CargoTour">
                              <label>Cargo</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtCargo" name="txtCargo" placeholder="Cargo">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCargo" name="btnCargo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaCargo" name="btnLimpaCargo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-md-4 col-12" id="TurnoTour">
                              <label>Turno</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtTurno" name="txtTurno" placeholder="Turno">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnTurno" name="btnTurno" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaTurno" name="btnLimpaTurno" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12" id="TempoContratoTour">
                              <label>Tempo Contrato</label>
                              <input type="text" class="input-default focus form-control validate" name="txtTempoContrato" id="txtTempoContrato" placeholder="Tempo Contrato" maxlength="30">
                            </div>
                            <div class="form-group col-md-4 col-6" id="AdmissaoTour">
                              <label>Admissão *</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control validate" name="txtAdmissao" required id="txtAdmissao"">
                            </div>
                            <div class=" form-group col-md-4 col-6" id="DemissaoTour">
                              <label>Demissão</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control validate" name="txtDemissao" id="txtDemissao">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-4 col-12" id="Experiencia1Tour">
                              <label>Experiência 1</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate col-md-3" name="txtTextoExp1" id="txtTextoExp1">
                                <input type="date" max="2500-12-31" class="input-default focus form-control validate col-md-8 ml-auto" name="txtDataExp1" id="txtDataExp1">
                              </div>
                            </div>

                            <div class="form-group col-md-4 col-12" id="Experiencia2Tour">
                              <label>Experiência 2</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate col-md-3" name="txtTextoExp2" id="txtTextoExp2">
                                <input type="date" max="2500-12-31" class="input-default focus form-control validate col-md-8 ml-auto" name="txtDataExp2" id="txtDataExp2">
                              </div>
                            </div>

                            <div class="col-md-4 col-12 form mt-4">
                              <fieldset class="form border-Field">
                                <div class="form-row pt-2">
                                  <div class="icheck-primary form-group form-check mx-2">
                                    <input type="checkbox" class="form-check-input" id="cbHorarioPadrao">
                                    <label class="form-check-label" for="cbHorarioPadrao">Horário Padrão</label>
                                  </div>
                                  <div class="icheck-primary form-check mx-2">
                                    <input type="checkbox" class="form-check-input" id="cbHorista">
                                    <label class="form-check-label" for="cbHorista">Horista</label>
                                  </div>
                                </div>
                              </fieldset>
                            </div>

                            <div class="form-group col-md-6">
                              <label>Tipo de Demissão</label>
                              <select class="input-default focus custom-select" id="SelectDemissao">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="R">Pedido de rescisão</option>
                                <option class="drilldown-item" value="C">Por justa causa</option>
                                <option class="drilldown-item" value="S">Sem justa causa</option>
                                <option class="drilldown-item" value="A">Acordo entre partes</option>
                                <option class="drilldown-item" value="N">Demissão consensual</option>
                              </select>
                            </div>

                            <div class="form-group col-md-6">
                              <label>Tipo de Vínculo</label>
                              <select class="input-default focus custom-select" id="SelectVinculo">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="R">Registrado</option>
                                <option class="drilldown-item" value="T">Terceirizado</option>
                                <option class="drilldown-item" value="P">Parceiros</option>
                                <option class="drilldown-item" value="O">Outros/não informado</option>
                              </select>
                            </div>

                          </div>

                        </div>
                      </div>
                    </div>
                    <div class="card card-header" role="tab" id="dados-pagamento">
                      <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample4" href="#multiCollapseExample4" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="row">
                          <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                            <i class="fas fa-angle-right"></i>
                          </div>
                          <div class="col-11">
                            <h4 class="title-page">
                              Dados Pagamento
                            </h4>
                          </div>
                        </div>
                      </a>
                    </div>
                    <div class="collapse" id="multiCollapseExample4">
                      <div class="card card-body">
                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab">
                          <div class="form-row pt-2">

                            <div class="form-group col-md-3 col-12" id="BancoTour">
                              <label>Banco</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control validate" id="txtBanco" name="txtBanco" placeholder="Banco">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaBanco" name="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Agência</label>
                              <input type="text" class="input-default focus form-control" name="txtAgencia" id="txtAgencia" placeholder="Agência" maxlength="7">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Conta</label>
                              <input type="text" class="input-default focus form-control" name="txtConta" id="txtConta" placeholder="Conta" maxlength="13">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Operação</label>
                              <input type="text" class="input-default focus form-control" name="txtOperacao" id="txtOperacao" placeholder="Operação" maxlength="3">
                            </div>
                          </div>

                          <div class="form-row pt-2">

                            <div class="form-group col-md-3 col-12">
                              <label>Salário</label>
                              <input type="number" class="input-default focus form-control" name="txtSalario" id="txtSalario" placeholder="Salário">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Vale Alimentação</label>
                              <input type="number" class="input-default focus form-control" name="txtValeAlimentacao" id="txtValeAlimentacao" placeholder="Vale Alimentação">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Vale Transporte</label>
                              <input type="number" class="input-default focus form-control" name="txtValeTransporte" id="txtValeTransporte" placeholder="Vale Transporte">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Valor Pago</label>
                              <input type="number" class="input-default focus form-control" name="txtValorPago" id="txtValorPago" placeholder="Valor Pago">
                            </div>
                          </div>

                          <div class="form-row pt-2">
                            <div class="form-group col-md-3 col-12">
                              <label>Prêmio Assiduidade</label>
                              <input type="number" class="input-default focus form-control" name="txtPremioAssiduidade" id="txtPremioAssiduidade" placeholder="Prêmio Assiduidade">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Salário Família</label>
                              <input type="number" class="input-default focus form-control" name="txtSalarioFamilia" id="txtSalarioFamilia" placeholder="Salário Família">
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Valor Cobrado</label>
                              <input type="number" class="input-default focus form-control" name="txtValorCobrado" id="txtValorCobrado" placeholder="Valor Cobrado">
                            </div>

                            <div class="form-group col-md-1 col-12 ml-auto">
                              <label>% INSS</label>
                              <input type="number" class="input-default focus form-control" name="txtINSS" id="txtINSS" placeholder="INSS" maxlength="5">
                            </div>

                            <div class="form-group col-md-1 col-12 ml-auto">
                              <label>% FGTS</label>
                              <input type="number" class="input-default focus form-control" name="txtFGTS" id="txtFGTS" placeholder="FGTS" maxlength="5">
                            </div>

                          </div>

                        </div>
                      </div>
                    </div>

                    <div class="card card-header" role="tab" id="outros">
                      <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample5" href="#multiCollapseExample5" aria-expanded="true" aria-controls="collapseOne1">
                        <div class="row">
                          <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                            <i class="fas fa-angle-right"></i>
                          </div>
                          <div class="col-11">
                            <h4 class="title-page">
                              Outros
                            </h4>
                          </div>
                        </div>
                      </a>
                    </div>
                    <div class="collapse" id="multiCollapseExample5">
                      <div class="card card-body pb-4">
                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab">

                          <div class="form-row pt-2">

                            <div class="form-group col-md-3 col-6">
                              
                              <label>Deficiência</label>
                              <select class="input-default focus custom-select" id="SelectDeficiencia">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="0">Nenhuma</option>
                                <option class="drilldown-item" value="1">Física</option>
                                <option class="drilldown-item" value="2">Auditiva</option>
                                <option class="drilldown-item" value="3">Visual</option>
                                <option class="drilldown-item" value="4">Intelectual</option>
                                <option class="drilldown-item" value="5">Múltiplas</option>
                                <option class="drilldown-item" value="6">Reabilitado</option>
                                <option class="drilldown-item" value="7">Mobilidade Reduzida</option>
                                <option class="drilldown-item" value="8">Mental</option>
                              </select>
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Raça</label>
                              <select class="input-default focus custom-select" id="SelectRaca">
                                <option class="drilldown-item" value="" selected disabled>Selecione uma opção</option>
                                <option class="drilldown-item" value="Branca">Branca</option>
                                <option class="drilldown-item" value="Negra">Negra</option>
                                <option class="drilldown-item" value="Mulato">Mulato</option>
                                <option class="drilldown-item" value="Caboclo">Caboclo</option>
                                <option class="drilldown-item" value="Parda">Parda</option>
                                <option class="drilldown-item" value="Indigena">Indígena</option>
                                <option class="drilldown-item" value="Amarela">Amarela</option>
                              </select>
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Data Periódico</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control" name="txtDataPeriodico" id="txtDataPeriodico" placeholder="Data Periódico">
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Data Estabilidade</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control" name="txtDataEstabilidade" id="txtDataEstabilidade" placeholder="Data Estabilidade">
                            </div>
                          </div>

                          <div class="form-row pt-2">

                            <div class="form-group col-md-3 col-6">
                              <label>Número Dep.</label>
                              <input type="number" class="input-default focus form-control" name="txtNumeroDep" id="txtNumeroDep" placeholder="Número Dep.">
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Minutos Trabalhados</label>
                              <input type="number" class="input-default focus form-control" name="txtMinTrabalhados" id="txtMinTrabalhados" placeholder="Minutos Trabalhados">
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Custo Minuto</label>
                              <input type="number" class="input-default focus form-control" name="txtCustoMinuto" id="txtCustoMinuto" placeholder="Custo Minuto">
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Código Contábil</label>
                              <input type="text" class="input-default focus form-control" name="txtCodContabil" id="txtCodContabil" maxlength="5" placeholder="Código Contábil" maxlength="5">
                            </div>

                          </div>

                          <div class="form-row pt-2">

                            <div class="form-group col-md-3 col-6">
                              <label>Nº Armário</label>
                              <input type="text" class="input-default focus form-control" name="txtNumeroArmario" id="txtNumeroArmario" placeholder="Nº Armário" maxlength="20">
                            </div>

                            <div class="form-group col-md-3 col-6">
                              <label>Cartão Siga</label>
                              <input type="text" class="input-default focus form-control" name="txtCartaoSiga" id="txtCartaoSiga" placeholder="Cartão Siga" maxlength="30">
                            </div>

                            <div class="col-md-3 col-12 form pt-4">
                              <fieldset class="form border-Field">
                                <div class="form-row">
                                  <div class="icheck-primary form-group form-check ml-4 pt-2">
                                    <input type="checkbox" class="form-check-input" id="cbCipa">
                                    <label class="form-check-label" for="cbCipa">Cipa</label>
                                  </div>
                                </div>
                              </fieldset>
                            </div>

                            <div class="form-group col-md-3 col-12">
                              <label>Entrada Cipa</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control" name="txtEntradaCipa" id="txtEntradaCipa">
                            </div>

                          </div>
                        </div>
                      </div>
                    </div>
                    <!-- cabo os panel -->
                    <input id="btnGravar" type="submit" style="font-size:15px;" class="btn btn-danger btn-sisp btn-lg action-button float-right" value="Gravar">
                    <button type="button" id="btnVoltar" style="font-size:15px;" class="btn btn-success btn-sisp btn-lg action-button-previous" data-dismiss="modal">Voltar</button>
                  </form>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  </div>

  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_estatisticas_entidade.html');
  include_once('../../loja/modais/modal_cep.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script>
    function formatar(mascara, documento) {
      var i = documento.value.length;
      var saida = mascara.substring(0, 1);
      var texto = mascara.substring(i);

      if (texto.substring(0, 1) != saida) {
        documento.value += texto.substring(0, 1);
      }

    }
  </script>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.2510.7.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2510.7.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.7.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.2510.7.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.2510.7.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.2510.7.1"></script>
  <script src="../utils/funcoes.js?versao=3.2510.7.1"></script>
  <script src="../utils/cookies.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.2510.7.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="../modals/modal_estatisticas_entidade.js?versao=3.2510.7.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('FUNCIONARIO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("FUNCIONARIO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/funcionario`
        });
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split("/");
      const codfun = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        // e.preventDefault();
        e.stopPropagation();
        deletaRegistro("FUNCIONARIO", getCookie("usuario"), codfun);
        return undefined;
      });
      sArquivo = `${BASE_URI}/pages/funcionario/cadastro_funcionario/funcionario.js?versao=3.2510.7.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);

    });
  </script>
</body>

</html>