$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true
        });

        driver.defineSteps([{
            element: '#campostuto',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o Grupo.',
                position: 'top'
            }
        },
        {
            element: '#txtOrdem',
            popover: {
                title: 'Ordem',
                description: 'Este campo, podemos adicionar um número da ordem, ou seguir com o número, que é gerado sequencialmente.',
                position: 'top'
            }
        },
        {
            element: '#check',
            popover: {
                title: 'Ativo e Prioridade',
                description: 'Aqui, especificamos se o grupo será ativo e se tem prioridade.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o grupo.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtTaxaCartao').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let grupo = parametros[parametros.length - 1];

    $('#checkAtivo').attr('checked', true);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('GRUPO', getCookie('usuario'), grupo);
        window.location.href = `${BASE_URI}/grupo`;
    });

    $(document).ready(function () {

        $('#txtCodigo').prop('disabled', true);

        $('#txtMeta').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    try {
        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"grupo_pa", 
                "camposSelect":["count(CODIGO) as CONTAGEM"], 
                "where": ["1 = 1"]}`, null);
        let jsonStr = await response.json();
        $('#txtOrdem').val(jsonStr.RESULT[0][0].CONTAGEM + 1);
    } catch (error) {
        console.error(error);
    }

    if (grupo != '' && grupo != 'create') {
        if (await liberarRegistro('GRUPO', grupo) == false) {
            window.location.href = '../grupo';
        } else {
            try {
                $.LoadingOverlay("show");
                try {
                    let response1 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"grupo_pa", 
                    "camposSelect":["codigo", "descricao", "ativo", "prioridade", "ordem", "permite_consig"], 
                    "where": ["codigo = '${grupo}'"]}`, null);

                    if (!response1) {
                        return;
                    }
                    let jsonStr1 = await response1.json();
                    if (response1.status != 200) {
                        msgErro(jsonStr1.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr1.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr1.RESULT[0][0].DESCRICAO);
                    $('#txtOrdem').val(jsonStr1.RESULT[0][0].ORDEM);

                    if (jsonStr1.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    } else {
                        $('#checkAtivo').prop('checked', false);
                    }

                    if (jsonStr1.RESULT[0][0].PRIORIDADE == '1') {
                        $('#checkPrioridade').prop('checked', true);
                    };

                    if (jsonStr1.RESULT[0][0].PERMITE_CONSIG == 'N') {
                        $('#checkNaoPermiteConsig').prop('checked', true);
                    };

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(

        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    let grupoClasse = {};
                    grupoClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('grupo_pa', 'grupo_pa', 'CODIGO', 3) : $('#txtCodigo').val();
                    grupoClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    grupoClasse.ORDEM = $('#txtOrdem').val();

                    if ($('#checkAtivo').prop('checked')) {
                        grupoClasse.ATIVO = 'S';
                    } else {
                        grupoClasse.ATIVO = 'N';
                    }
                    if ($('#checkPrioridade').prop('checked')) {
                        grupoClasse.PRIORIDADE = '1';
                    } else {
                        grupoClasse.PRIORIDADE = '2';
                    }
                    grupoClasse.PERMITE_CONSIG = $('#checkNaoPermiteConsig').prop('checked') ? 'N' : 'S';

                    let response2 = await requisicao('POST', '/Sisplan/Cadastros/v1/grupo?', `JSON=${encodeURIComponent(JSON.stringify(grupoClasse))}`, null);

                    if (!response2) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr2 = await response2.json();
                    if (response2.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr2.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Grupo: ${grupoClasse.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/grupo`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
                }
            }
        });
});;