<?php  include_once('../../config.php'); ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Venda</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="cache-control" content="max-age=0" />
  <meta http-equiv="cache-control" content="no-cache" />
  <meta http-equiv="expires" content="0" />
  <meta http-equiv="expires" content="Tue, 01 Jan 1980 1:00:00 GMT" />
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/adminlte.min.css?versao=3.2510.7.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/fontawesome-free/css/all.min.css?versao=3.2510.7.1">
  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href='../dist/css/bootstrap.min.css'>
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/custom.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/PesquisaVariosSelect2.css?versao=3.2510.7.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css">
  <link rel="shortcut icon" href="<?php echo BASE_URI; ?>/favicon.ico">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/driver.min.css?versao=3.2510.7.1" />
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/jquery-ui.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/select2/css/select2.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="../dist/css/animate.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/owl/assets/owl.carousel.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/owl/assets/owl.theme.default.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/normalize.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2510.7.1" />
  <link rel="stylesheet" href="../pages/loja/css/venda.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2510.7.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/sisplan.css?versao=3.2510.7.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/sisplan.newColorsButtons.css?versao=3.2510.7.1" />

</head>
<style>
  .barcode-message {
    text-align: center;
  }

  .barcode-canvas {
    position: relative;
    overflow: hidden;
    padding-bottom: 56.25%;
    line-height: 0;
  }

  .barcode-canvas video {
    z-index: 10;
    position: absolute;
    transform: translate(-50%, -50%);
    left: 50%;
    right: 50%;
    top: 50%;
    bottom: 50%;
    background: white;
  }

  .barcode-canvas canvas.drawingBuffer {
    z-index: 20;
    position: absolute;
    left: 0;
    right: 0;
    top: 0;
    bottom: 0;
    width: 100%;
    height: 100%;
  }

  .barcode-canvas br {
    display: none;
  }

  .main-sidebar {
    height: 100% !important;
    overflow-y: hidden;
    z-index: 1038;
  }

  .layout-fixed .wrapper .sidebar {
    height: calc(100% - (3.5rem + 1px));
  }

  .modal-backdrop {
    display: none;
  }

  #labelPrazo {
    margin-right: -36px;
    margin-top: -28px;
  }

  .prazo {
    margin-right: 3px;
  }

  .linha-promocao {
    background-color: var(--linhaDesconto);
  }

  table.dataTable tbody tr.selected.linha-promocao-selected {
    background-color: var(--linhaDescontoSelected) !important;
  }

  .linha-prodRelac {
    border-left: 2px solid var(--linhaProdutoRelac);
  }


  .linhaAzul {
    border-left: 2px solid var(--linhaAzul);
  }

  .linhaDesdobrado {
    border-left: 3px solid RGB(255, 174, 174);
  }

  .bg-desdobrado {
    background: RGB(255, 174, 174);
  }

  .quadrado {
    width: 25px;
    margin-right: 5px;
    height: 25px;
  }

  #colunas {
    background-color: var(--modal-content-color);
    color: var(--font-color);
  }

  #tabelaProdutoMaterial tbody tr td,
  #tabelaMaterial tbody tr td {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 350px;
  }

  #tabelaEstoquePreco tbody tr td {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 250px;
  }

  #tabelaMaterial td,
  #tabelaMaterial th {
    padding: 0.5px .3rem;
  }

  #tabelaProdutoMaterial td,
  #tabelaProdutoMaterial th {
    padding: 0.5px .3rem;
  }


  #tabelaMaterial_length {
    padding-left: 5px;
    padding-bottom: 5px;
  }

  .scrollAnte {
    max-height: 20vh;
    overflow-y: auto;
  }

  .border-Field:not(.modalCliente) .textoBorda {
    font-size: 1.0em !important;
    text-align: left !important;
    width: auto;
    padding: 0 10px;
    border-bottom: none;
  }

  .border-Field:not(.modalCliente) {
    border: 1.0px solid var(--font-color) !important;
    padding: 0 1.0em 1.0em 1.0em !important;
    margin: 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
    padding-bottom: 0px !important;
    border-radius: 3px !important;
  }

  .footer {
    width: calc(99% - 4.6rem) !important;
  }

  .brand-link .brand-image {
    float: left !important;
    line-height: .8 !important;
    margin-left: 0.3rem !important;
    margin-right: 0.5rem !important;
    margin-top: -5px !important;
    max-height: 40px !important;
    width: auto !important;
  }

  #tabelaAcessoBrinde_wrapper .table.dataTable tbody td,
  #tabelaAcessoBrinde_wrapper .table.dataTable thead th {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }

  #tabelaItensBrinde_wrapper .table.dataTable tbody td,
  #tabelaItensBrinde_wrapper .table.dataTable thead th {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }


  .icone.notificacao-ativa {
    color: #b10404;
    animation: shake 0.5s;
    animation-iteration-count: infinite;
    /* Animação repetitiva */
  }

  /* Keyframes para o efeito de chacoalhar */
  @keyframes shake {
    0% {
      transform: translateX(0);
    }

    25% {
      transform: translateX(-5px);
    }

    50% {
      transform: translateX(5px);
    }

    75% {
      transform: translateX(-5px);
    }

    100% {
      transform: translateX(0);
    }
  }

  div.dataTables_wrapper {
    width: 100%;
    margin: 0 auto;
  }

  .dtfc-right-top-blocker {
    background: transparent !important;
  }

  #tabelaMaterial_paginate {
    float: right;
  }

  #tabelaProdutoMaterial_paginate {
    float: right;
  }

  .filtrosAdicionaisMaterial {
    margin-right: 4px;
  }

  #modalMaterial .modal-body {
    max-height: 100% !important;
    padding-top: 6px !important;
  }

  #modalProduto .modal-body {
    overflow-y: hidden !important;
    max-height: 100% !important;
  }


  @media (max-width: 767px) {
    #modalMaterial .modal-body {
      max-height: 100% !important;
    }

    #modalProduto .modal-body {
      overflow-y: auto !important;
      max-height: 100% !important;
    }
  }

  #tabelaTotais td {
    text-align: right;
  }

  #tabelaTotais td h6 {
    margin-right: 25px;
  }

  .btnInfoLimite {
    padding: 0.1rem 0.25rem !important;
    font-size: .700rem !important;
    line-height: 1.5 !important;
    border-radius: 0.2rem !important;
  }
</style>

<div class="main-sidebar sidebar-dark-primary" id="menuVenda">
  <a class="brand-link">
    <img src="<?php echo BASE_URI; ?>/dist/img/icon.png" alt="Logo Sisplan" class="brand-image">
    <span class="brand-text font-weight-light">Pré Venda</span>
  </a>

  <div class="sidebar">
    <div class="menuFlex">
      <nav class="mt-2" id="menuGeral">
        <ul class="nav nav-pills nav-sidebar flex-column nav-compact" style="user-select: none;" data-widget="treeview" role="menu" data-accordion="false" id="menu_esquerda">
          <li class="nav-item" id="abreAjuda">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="nav-icon fas fa-info-circle"></i>
              </div>
              <p>
                Ajuda/Atalhos
              </p>
            </a>
          </li>
          <li class="nav-item" id="abreCadCli">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="nav-icon fas fa-user-plus"></i>
              </div>
              <p>
                Cadastro de Cliente (F2)
              </p>
            </a>
          </li>
          <li class="nav-item" id="abrePreco">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="nav-icon fas fas fa-search-dollar"></i>
              </div>
              <p>
                Consulta de Estoque/Preço
              </p>
            </a>
          </li>
          <li class=" nav-item" id="abreVendas">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="nav-icon fas fa-shopping-cart"></i>
              </div>
              <p>
                Vendas Pendentes
              </p>
            </a>
          </li>
          <li class="nav-item" id="impVendas">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="nav-icon fas fa-upload"></i>
              </div>
              <p>
                Importar
              </p>
            </a>
          </li>
          <li class="nav-item" id="abreCupomTroca">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="nav-icon fas fa-file-invoice"></i>
              </div>
              <p>
                Cupom de Troca
              </p>
            </a>
            <!-- </li>
          <li class="nav-item" id="abreConsultaEstoque">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="m-0 p-0 fas fa-search"></i>
              </div>
              <p>
                Consultar Estoque
              </p>
            </a>
          </li> -->
          <li class="nav-item" id="abreModalOcorrencia">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="mx-1 p-0 far fa-clipboard" style="margin-right: 2px !important;"></i>
              </div>
              <p>
                Cadastrar Ocorrências
              </p>
            </a>
          </li>
          <li class="nav-item" id="btnSolicitaLimiteCredito">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="fas fa-dollar-sign" style="margin-right: 1px !important; width: 25px;"></i>
              </div>
              <p>
                Solicitar Limite Crédito
              </p>
            </a>
          </li>
          <li class="nav-item" id="btnBrinde">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="fas fa-gift" style="margin-right: 1px !important; width: 25px;"></i>
              </div>
              <p>
                Brinde
              </p>
            </a>
          </li>

          <!-- <button id="btnSom" class="d-snone"></button> -->
          <li class="nav-item d-none" id="btnSolicitacaoEstoque">
            <a class="nav-link">
              <div id="buttonLeft">
                <i class="fa fa-bell icone" style="margin-right: 1px !important; width: 25px" class="icone"></i>
              </div>
              <p>
                Solicitação de Estoque
              </p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </div>
</div>

<body class="sidebar-mini layout-fixed sidebar-closed sidebar-collapse" id="conteudo">

  <header>
    <div class="card-header" id="menu_top">
      <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="d-flex">
          <h6 style="color:white!important;margin-top:auto;margin-bottom:auto;margin-right:10px">Pré-Venda</h6>

          <button title="Tutorial" type="button" class="btn btn-info btn-sm" style="color: white;margin-right:10px; height: 40px;" id="tutorial">
            <i class="fas fa-question-circle"></i>
          </button>

        </div>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse " id="navbarSupportedContent">
          <ul class="navbar-nav mr-auto ml-auto">
            <li class="nav-item text-align-center text-center">
              <div class="d-flex justify-content-center" style="margin-left: 0px;">
                <div class="caixa_card" class="row" style="min-width: 80px; max-width: 80px;">
                  <div class="col-12">
                    <h6 style="color:white!important;margin:0;padding:0;">Caixa</h6>
                  </div>
                  <div class="col-12">
                    <h6 style="color:white!important;" id="txt_caixa_logado"></h6>
                  </div>
                </div>
                <div class="caixa_card" style="border-left: 1px solid #CDCDCD; width: 80px; min-width: 80px; max-width: 80px;" class="row">
                  <div class="col-12">
                    <h6 style="color:white!important;margin:0;padding:0;">Venda</h6>
                  </div>
                  <div class="col-12">
                    <h6 style="color:white!important;" id="txt_venda_atual"></h6>
                  </div>
                </div>
                <div class="caixa_card" style="border-left: 1px solid #CDCDCD; min-width: 180px; max-width: 180px;" class="row">
                  <div class="col-12">
                    <h6 style="color:white!important;margin:0;padding:0;">Usuário</h6>
                  </div>
                  <div class="col-12">
                    <h6 style="color:white!important;" id="txt_usuario_logado"></h6>
                  </div>
                </div>

              </div>
            </li>
          </ul>
          <button type="button" class="btn btn-info float-right mr-2" style="color: white;" id="btn-sair">
            <i class="fas fa-sign-out-alt"></i> Sair PDV
          </button>
        </div>
      </nav>
    </div>
  </header>
  <main>
    <div class="wrappers" id="principal">
      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrappers">
        <section class="content">
          <div class="container-fluid">
            <div class="row">
              <div class="col-12">
                <div class="card" style="height:auto;">
                  <div class="card-body">
                    <form id="msform" name="msform">
                      <fieldset id="fieldset_info" style="display:none">
                        <div class="form-card">
                          <div class="card" style="height:auto;">
                            <div class="card-body container-box">
                              <div class="row">
                                <div class="col-sm-4 col-md-4 col-lg-3 col-12">
                                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtTipoVenda">Tipo Venda</label>
                                  <select class="input-default focus form-control col-6" aria-label=".form-select-lg example" id="txtTipoVenda">
                                  </select>
                                </div>
                                <div class="col-sm-4 col-md-4 col-lg-3 col-12 d-flex align-items-center justify-content-center">
                                  <label style="font-size: 0.8rem; padding-top: 25px; min-width: 180px;">
                                    <input type="checkbox" id="vendaMovimentaEstoque" name="vendaMovimentaEstoque" disabled>
                                    <span class="checkmark">Movimenta Estoque</span>
                                  </label>
                                </div>
                                <div class="col-sm-4 col-md-4 col-lg-6 col-12" style="padding-top: 1.5rem;">
                                  <button class="btn btn-secondary btn-block btn-lg" id="btn-informacoes-adicionais" type="button">
                                    Informações Adicionais
                                  </button>
                                </div>
                                <div class="col-sm-3 col-md-3 col-lg-2 col-12 d-none">
                                  <!-- por enquanto nao vai ser usado esse cara entao quando for colocar tem que adicionar essa classe
                              d-flex align-items-center justify-content-center -->
                                  <label style="font-size: 0.8rem; padding-top: 25px; min-width: 180px;">
                                    <input type="checkbox" id="tipoFechaVenda" name="tipoFechaVenda">
                                    <span class="checkmark">Fecha Venda</span>
                                  </label>
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-sm-12 col-md-6 col-12 pt-1" id="divCliente">
                                  <label data-error="wrong" class="mb-0" data-success="right" for="txtCliente">Cliente
                                    <label style="font-size: 83%" data-error="wrong" data-success="right" for="txtCliente">- [F3 - Consulta Cliente]</label>
                                  </label>
                                  <div class="input-group pt-1">
                                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-info-cliente" name="btn-info-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-user"></i></button>
                                      <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-sm-12 col-md-1 col-12 d-none pt-1" id="divSenha">
                                  <label style="font-size: 83%" data-error="wrong" data-success="right" for="txtSenha">Senha</label>
                                  <div class="input-group">
                                    <input type="number" data-selecionado="false" class="input-default focus form-control camposInteiro" id="txtSenha" name="txtSenha" class="form-control" placeholder="Senha">
                                  </div>
                                </div>
                                <div class="col-sm-12 col-md-2 col-12 pt-1" id="divCNPJ">
                                  <label data-error="wrong" data-success="right" for="txtCNPJ">CPF / CNPJ</label>
                                  <div class="input-group">
                                    <input type="text" placeholder="CPF / CNPJ" class="input-default focus form-control" id="txtCNPJ" name="txtCNPJ">
                                  </div>
                                </div>
                                <div class="col-sm-12 col-md-2 col-12 d-none pt-1" id="divCashback">
                                  <label data-error="wrong" data-success="right" for="txtCashbackCli">Cashback Disponível</label>
                                  <div class="input-group">
                                    <input type="text" data-selecionado="false" class="input-default form-control" id="txtCashbackCli" name="txtCashbackCli" class="form-control" placeholder="Cashback" readonly>
                                  </div>
                                </div>
                                <div class="col-sm-12 col-md-2 col-12 pt-1">
                                  <label data-error="wrong" data-success="right" for="txtLimiteCreditoCli">Limite Crédito Disp.</label>
                                  <button type="button" class="btn btn-info mr-l btnInfoLimite" style="color: white;" data-toggle="tooltip" data-placement="top" checked title="Este campo busca o valor do campo (Limite Disponível) do cadastro do Cliente, somente quando: 1- No cadastro de Histórico, o histórico (da duplicata) está com o check (Utiliza no Limite de Crédito) marcado. 2- No cadastro da Moeda, a moeda (da duplicata) está com o check (Controla limite de crédito na venda/faturamento) marcado. Caso contrário, busca o valor do campo (Limite Crédito) do cadastro do Cliente.">
                                    <i class="fas fa-info-circle "></i>
                                  </button>
                                  <div class="input-group">
                                    <input type="number" data-selecionado="false" class="input-default form-control" id="txtLimiteCreditoCli" name="txtLimiteCreditoCli" class="form-control" placeholder="Limite Crédito" readonly title="Este campo busca o valor do campo (Limite Disponível) do cadastro do Cliente, somente quando: 1- No cadastro de Histórico, o histórico (da duplicata) está com o check (Utiliza no Limite de Crédito) marcado. 2- No cadastro da Moeda, a moeda (da duplicata) está com o check (Controla limite de crédito na venda/faturamento) marcado. Caso contrário, busca o valor do campo (Limite Crédito) do cadastro do Cliente.">
                                  </div>
                                </div>
                                <div class="col-sm-12 col-md-2 col-12 pt-1">
                                  <label data-error="wrong" data-success="right" for="txtLimiteCreditoConsignado">Crédito Grupo</label>
                                  <button type="button" class="btn btn-info mr-l btnInfoLimite" style="color: white;" data-toggle="tooltip" data-placement="top" checked title="Este campo busca o valor do campo (Crédito Grupo) do cadastro do Cliente, somente quando: No cadastro de Histórico, o histórico (da duplicata) está com o check (Utiliza Crédito Grupo) marcado. Descontando do (Crédito Grupo) o valor das duplicatas em aberto do Cliente">
                                    <i class="fas fa-info-circle "></i>
                                  </button>
                                  <div class="input-group">
                                    <input type="number" data-selecionado="false" class="input-default form-control" id="txtLimiteCreditoConsignado" name="txtLimiteCreditoConsignado" title="Este campo busca o valor do campo (Crédito Grupo) do cadastro do Cliente, somente quando: No cadastro de Histórico, o histórico (da duplicata) está com o check (Utiliza Crédito Grupo) marcado. Descontando do (Crédito Grupo) o valor das duplicatas em aberto do Cliente" class="form-control" placeholder="Crédito Grupo" readonly>
                                    <input type="number" data-selecionado="false" class="input-default form-control" id="txtConsignadoEmAberto" name="txtConsignadoEmAberto" hidden>
                                    <input type="number" data-selecionado="false" class="input-default form-control" id="txtVendaEmAberto" name="txtVendaEmAberto" hidden>
                                  </div>
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-sm-6 col-md-6 col-12">
                                  <div id="VendedorInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor</label>
                                    <div class="input-group">
                                      <input type="text" data-selecionado="false" class="input-default form-control" id="txtVendedor" name="txtVendedor" class="form-control" placeholder="Vendedor" required>
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-vendedor" name="btn-vendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-vendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="d-none" id="GuiaInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtGuia">Guia</label>
                                    <div class="input-group">
                                      <input type="text" data-selecionado="false" class="input-default focus form-control d-none" id="txtGuia" name="txtGuia" class="form-control" placeholder="Guia" required>
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-guia" name="btn-guia" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-guia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>
                                  <div id="tabelaInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtTabela" id="labelTabela">Tabela</label>
                                    <div class="input-group">
                                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTabela" name="txtTabela" class="form-control" placeholder="Tabela">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-tabela" name="btn-tabela" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-tabela" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                      <div class="input-group-append d-none" id="divRgPrazo">
                                        <label data-error="wrong" data-success="right" for="rgPrazo" id="labelPrazo">Prazo</label>
                                        <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgPrazo" class="custom-select focus">
                                          <option selected value="00">00</option>
                                          <option value="07">07</option>
                                          <option value="14">14</option>
                                          <option value="21">21</option>
                                          <option value="28">28</option>
                                          <option value="35">35</option>
                                          <option value="42">42</option>
                                          <option value="49">49</option>
                                          <option value="56">56</option>
                                          <option value="63">63</option>
                                          <option value="70">70</option>
                                          <option value="77">77</option>
                                          <option value="84">84</option>
                                          <option value="91">91</option>
                                        </select>
                                      </div>
                                    </div>
                                  </div>
                                  <div id="depositoInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtDeposito">Depósito</label>
                                    <div class="input-group">
                                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Deposito">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-deposito" name="btn-deposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        <input type="text" placeholder="Lancamento" class="input-default focus form-control d-none" id="txtLancamento" name="txtLancamento">
                                        <input type="text" placeholder="Venda" class="input-default focus form-control d-none" id="txtCodVen" name="txtCodVen">
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-sm-6 col-md-6 col-12">
                                  <div class="col-12 flex px-0">
                                    <div class="d-none col-4 pl-0" id="statusInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtStatus">Status</label>
                                      <div class="input-group">
                                        <input type="text" data-selecionado="false" class="input-default focus form-control d-none" id="txtStatus" name="txtStatus" class="form-control" placeholder="Status">
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-status" name="btn-status" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-status" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-4 dtEntrega d-none">
                                      <label for="dtEntregaDe">Entrega De:</label>
                                      <div class="relative">
                                        <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="dtEntregaDe" name="dtEntregaDe">
                                      </div>
                                    </div>
                                    <div class="col-4 pr-0 dtEntrega d-none">
                                      <label for="dtEntregaAte">Entrega Até:</label>
                                      <div class="relative">
                                        <input type="date" max="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="dtEntregaAte" name="dtEntregaAte">
                                      </div>
                                    </div>
                                  </div>
                                  <div id="regraPromocaoInfoTour">
                                    <label data-error="wrong" data-success="right" for="txtRegraPromocao">Regra Promoção</label>
                                    <div class="input-group">
                                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtRegraPromocao" name="txtRegraPromocao" class="form-control" placeholder="Regra Promoção">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-RegraPromocao" name="btn-RegraPromocao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-RegraPromocao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        <button type="button" class="btn btn-primary" id="btnRecalcularRegra" style="margin-left: 5px!important;" name="Calcular">Calcular </button>
                                      </div>
                                    </div>
                                    <div class="col-12 d-none">
                                      <table id="tabelaItensRegraPromocao" style="width:100%" width="100%" class="table table-sm table-select d-none">
                                        <thead>
                                          <!-- <tr>
                                            <td>REGRA</td>
                                            <td>SEQ</td>
                                            <td>VALOR</td>
                                            <td>DESCONTO</td>
                                            <td>TIPO</td>
                                            <td>CAMPO</td>
                                            <td>CHAVE</td>
                                            <td>OPERACAO</td>
                                            <td>MODELO</td>
                                          </tr> -->
                                        </thead>
                                        <tbody></tbody>
                                      </table>
                                    </div>
                                    <div class="col-12 d-none">
                                      <table id="tabelaBrindesPromocao" style="width:100%" width="100%" class="table table-sm table-select d-none">
                                        <thead>
                                        </thead>
                                        <tbody></tbody>
                                      </table>
                                    </div>
                                    <div class="col-12 d-none">
                                      <table id="tabelaItensUtilizamRegra" style="width:100%" width="100%" class="table table-sm table-select d-none">
                                        <thead>
                                          <tr>
                                            <td>CODIGO</td>
                                            <td>COR</td>
                                            <td>OPERACAO</td>
                                            <td>REGRA</td>
                                            <td>TAM</td>
                                            <td>TIPO</td>
                                            <td>VALOR</td>
                                            <td>QTDE</td>
                                            <td>APLICOU_REGRA</td>
                                          </tr>
                                        </thead>
                                        <tbody></tbody>
                                      </table>
                                    </div>
                                  </div>
                                  <div id="descricaoVenda">
                                    <label for="textDescricaoVenda">Observação</label>
                                    <div class="input-group">
                                      <input type="text" id="textDescricaoVenda" placeholder="Descrição Venda" class="input-default focus form-control">
                                    </div>
                                    <input type="text" id="txtCodGuiaIntegracao" hidden>
                                  </div>

                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </fieldset>
                      <fieldset id="fieldset_venda" style="display:none">
                        <div class="form-card">
                          <div class="row" id="itensVenda">
                            <div class="col-lg-6 col-md-12 col-sm-12 col-12" id="addProdutoTour">
                              <div class="card" style="height:auto;">
                                <div class="card-body container-box" id="card-prod">
                                  <div class="row mb-2" style="border-bottom: 1px solid #dee2e6">
                                    <div class="col-sm-6">
                                      <h5>Adicionar Itens</h5>
                                    </div>
                                    <div class="col-sm-6 d-flex align-items-center justify-content-end mb-1" title="Integração RFID">
                                      <div class="relative divRFID">
                                        <button type="button" class="btn btn-icon-normal btn-danger d-flex align-items-center justify-content-center" style="border-radius: 4px!important; text-align: center;" id="btn-iniciar-epc" name="btn-iniciar-epc" data-button="absolute" title="Atalho (Alt + 1)">
                                          <i style="font-size: 20px;" class="ph-play-thin"></i>
                                        </button>
                                      </div>
                                      <div class="relative ml-2 divRFID">
                                        <button type="button" class="btn btn-icon-normal btn-danger d-flex align-items-center justify-content-center" style="border-radius: 4px!important;" id="btn-parar-epc" name="btn-parar-epc" data-button="absolute" title="Atalho (Alt + 2)">
                                          <i style="font-size: 20px; " class="ph-pause-circle-thin"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row">
                                    <div class="col-sm-1"></div>
                                    <div class="col-sm-11 d-none divVendedorItem">
                                      <label data-error="wrong" data-success="right" for="txtVendedorItem">Vendedor</label>
                                      <div class="input-group">
                                        <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtVendedorItem" name="txtVendedorItem" class="form-control" placeholder="Vendedor" required>
                                        <div class="input-group-append">
                                          <button class="btn bg-danger" id="btn-vendedor-item" name="btn-vendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                          <button class="btn bg-danger" id="btn-limpa-vendedor-item" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div style="margin-bottom:15px" class="row">

                                    <div id="presente" class="col-1 col-sm-1">
                                      <i id="i_presente" for="cb_presente" style="font-size: 25px;" class="fas fa-gift" title="Marcar item como presente."></i>
                                      <div class="icheck-danger">
                                        <input type="checkbox" name="cb_presente" id="cb_presente" title="Marcar item como presente.">
                                        <label for="cb_presente">
                                        </label>
                                      </div>
                                    </div>

                                    <div class="col-sm-3 col-11 d-none" id="divQualidade">
                                      <div class="group-default form-group">
                                        <label style="margin-top:0.5rem!important;margin-bottom:0!important;" for="txtQualidade">Qualidade
                                        </label>
                                        <div class="relative">
                                          <button type="button" class="btn-icon btn-icon-normal bg-danger" id="btnQualidade" name="btnQualidade" data-button="absolute">
                                            <i style="color: white;font-size:20px;margin-left:-10px;padding:0px" class="fas fa-search"></i>
                                          </button>
                                          <input style="margin-top:9px;" type="text" placeholder="Qualidade" class="input-default form-control validate focus" id="txtQualidade" name="txtQualidade">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-sm-3 d-none" id="divQuantid">
                                      <div class="group-default form-group">
                                        <label title="Quantidade" id="lblQuantid" style="margin-top:0.5rem!important;margin-bottom:0!important;" for="txtQuantid">Quant.
                                          <!-- <small style="font-weight: bold">(CTRL +Q)</small> -->
                                        </label>
                                        <div class="relative">
                                          <input style="margin-top:9px;" title="Quantidade" min="0" type="number" placeholder="Quantidade" class="input-default form-control validate focus d-none" id="txtQuantid" name="txtQuantid">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-11 col-sm-11" id="divBarra">
                                      <div class="group-default form-group">
                                        <label style="margin-top:0.5rem!important;margin-bottom:0!important;display: flex; text-align: center; justify-content: space-between" for="txtCodigo">Código de barras (F4)
                                          <i title='desativar som bipagem' style="font-size: 20px" class="fas fa-volume-up somAtivo d-none"></i>
                                          <i title='ativar som bipagem' style="font-size: 20px" class="fas fa-volume-mute somInativo"></i>
                                        </label>
                                        <div class="input-group">
                                          <div class="input-group-append">
                                            <button style="margin-top:9px;" class="btn bg-danger" id="btnMenosOuMais" type="button" data-estorno="false">
                                              <i class="m-0 p-0 fas fa-plus"></i>
                                            </button>
                                          </div>
                                          <input style="margin-top:9px;" type="text" placeholder="Barra do produto" class="input-default form-control validate focus" id="txtCodigo" name="txtCodigo">
                                          <div class="input-group-append" style="margin-top: 9px;">
                                            <button type="button" class="btn-icon btn-icon-normal bg-danger" id="btn-codigo" name="btn-codigo">
                                              <i style="color: white;font-size:20px;margin-left:-10px;padding:0px" class="fas fa-search"></i>
                                            </button>
                                            <button title="Bipar com câmera" type="button" class="btn-icon btn-icon-normal bg-danger" id="btnCamera">
                                              <i style="color: white;font-size:20px;margin-left:-10px;padding:0px" class="fas fa-camera"></i>
                                            </button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <input type="text" id="txtIdItem" class="d-none" name="txtIdItem">
                                    <input type="text" id="txtDepositoItem" class="d-none" name="txtDepositoItem">
                                    <input type="text" id="txtCodigoEPC" class="d-none" name="txtCodigoEPC">

                                    <div class="col-sm-6 col-12">
                                      <div class="form-group" style="text-align:center">
                                        <label id="labelfotos">Foto</label>
                                        <div class="relative" style="display: flex;justify-content: center;align-items: center;flex-direction: row;flex-wrap: wrap;">
                                          <img class="pop img img-fluid" id="infoprodimagem" style="max-height:230px;max-width:230px;margin-left: auto;margin-right: auto;" src="<?php echo BASE_URI; ?>/dist/img/prod-1.png">
                                          <img class="pop img img-fluid d-none" title="Foto da cor" id="infoprodcorimagem" style="max-height:230px;max-width:230px;margin-left: auto;margin-right: auto;" src="<?php echo BASE_URI; ?>/dist/img/prod-1.png">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-sm-6 col-12">
                                      <div class="row">
                                        <div class="col-sm-8 col-12">
                                          <div class="form-group">
                                            <label for="infoprodcodigo">Produto</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Produto" class="input-default focus form-control" id="infoprodcodigo" name="infoprodcodigo" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-4 col-12">
                                          <div class="form-group">
                                            <label for="infoprodunidade">Unidade</label>
                                            <div class="relative">
                                              <input type="text" placeholder="UN" class="input-default focus form-control" id="infoprodunidade" name="infoprodunidade" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-8 col-12">
                                          <div class="form-group">
                                            <label for="infoprodcor">Cor</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Cor" class="input-default focus form-control" id="infoprodcor" name="infoprodcor" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-4 col-12" id="divTamanho">
                                          <div class="form-group">
                                            <label for="infoprodtam">Tamanho</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Tamanho" class="input-default focus form-control" id="infoprodtam" name="infoprodtam" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-4 col-12" id="divQtdeOrig">
                                          <div class="form-group">
                                            <label for="infoprodtam">Qtde Orig</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Qtde Orig" class="input-default focus form-control" id="infoprodqtdeorig" name="infoprodqtdeorig" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-8 col-12">
                                          <div class="form-group">
                                            <label for="infoprodbarra">Barra</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Barra" class="input-default focus form-control" id="infoprodbarra" name="infoprodbarra" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-4 col-12">
                                          <div class="form-group">
                                            <label for="infoprodpreco">Preço</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Preço" class="input-default focus form-control" id="infoprodpreco" name="infoprodpreco" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-8 col-12" id="divLote">
                                          <div class="form-group">
                                            <label for="infoprodlote">Lote</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Lote" class="input-default focus form-control" id="infoprodlote" name="infoprodlote" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-4 col-12" id="divInfoQualidade">
                                          <div class="form-group">
                                            <label for="infoprodqualidade">Qualidade</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Qualidade" class="input-default focus form-control" id="infoprodqualidade" name="infoprodqualidade" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-8 col-12 d-none" id="divLocal">
                                          <div class="form-group">
                                            <label for="infoprodlocal">Local</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Local" class="input-default focus form-control" id="infoprodlocal" name="infoprodlocal" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-6 col-12 d-none" id="divDeposito">
                                          <div class="form-group">
                                            <label for="infoproddeposito">Deposito</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Deposito" class="input-default focus form-control" id="infoproddeposito" name="infoproddeposito" readonly>
                                            </div>
                                          </div>
                                        </div>
                                        <div class="col-sm-6 col-12 d-none" id="divTabelaPreco">
                                          <div class="form-group">
                                            <label for="infoprodtabelapreco">Tabela de Preço</label>
                                            <div class="relative">
                                              <input type="text" placeholder="Tabela de Preço" class="input-default focus form-control" id="infoprodtabelapreco" name="infoprodtabelapreco" readonly>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-6 col-md-12 col-sm-12 col-12" id="listaProdutoTour">
                              <div class="card" style="min-height:436px;height:auto;">
                                <div class="card-body container-box">
                                  <div class="row mb-1">
                                    <div class="col-6 d-flex align-items-center">
                                      <h5>Lista de Itens</h5>
                                    </div>
                                    <div class="col-6">
                                      <button type="button" class="btn btn-md btn-secondary ml-2 float-right d-none" id="btnDescontoTotal"><i class="fas fa-percentage"></i></button>
                                    </div>
                                    <div class="col-12">
                                      <table id="tabelaItens" style="width:100%" width="100%" class="table table-sm table-select">
                                        <thead>
                                          <tr>
                                            <th class="th-sm">Codigo</th>
                                            <th class="th-sm">Descrição</th>
                                            <th class="th-sm">Qtde</th>
                                            <th class="th-sm">Preço Orig.</th>
                                            <th class="th-sm">Preço</th>
                                            <th class="th-sm">% Desconto</th>
                                            <th class="th-sm">Val. Desc.</th>
                                            <th class="th-sm">Total</th>
                                            <th class="th-sm">Ações</th>
                                            <th class="th-sm">barra</th>
                                            <th class="th-sm">cor</th>
                                            <th class="th-sm">tam</th>
                                            <th class="th-sm">DESC_COR</th>
                                            <th class="th-sm">qualidade</th>
                                            <th class="th-sm">id_estoque</th>
                                            <th class="th-sm">Venda Dev.</th>
                                            <th class="th-sm">Agrupamento Item</th>
                                            <th class="th-sm">Controle.</th>
                                            <th class="th-sm">Lote</th>
                                            <th class="th-sm">Tipo</th>
                                            <th class="th-sm">ValorDescRegraPromo</th>
                                            <th class="th-sm">BaseDescRegraPromo</th>
                                            <th class="th-sm">PercDescRegraPromo</th>
                                            <th class="th-sm">NumeroPedido</th>
                                            <th class="th-sm">OrdemPedido</th>
                                            <th class="th-sm">CaixaPedido</th>
                                            <th class="th-sm">Vendedor Item</th>
                                            <th class="th-sm">Data</th>
                                            <th class="th-sm">Unidade</th>
                                            <th class="th-sm">Promocao</th>
                                            <th class="th-sm">Preço Orig</th>
                                            <th class="th-sm">CodRegraPromo</th>
                                            <th class="th-sm">Observacao</th>
                                          </tr>
                                        </thead>
                                        <tbody></tbody>
                                      </table>
                                    </div>
                                  </div>
                                  <div style="margin: 10px 10px 0px 0px" class="d-flex align-items-center">
                                    <div class="d-flex align-items-center gap-2">
                                      <div class="d-flex align-items-center gap-2">
                                        <div class="quadrado" style="background: var(--linhaDesconto);">
                                        </div>
                                        <span> Item com Preço Promocional </span>
                                      </div>
                                      <div class="d-flex align-items-center gap-2 ml-2 legenda-material d-none">
                                        <div class="quadrado bg-desdobrado">
                                        </div>
                                        <span> Lote desdobrado </span>
                                      </div>
                                      <div class="d-none itemRelacionado align-items-center gap-2">
                                        <div class="quadrado ml-1" style="background: var(--linhaProdutoRelac);">
                                        </div>
                                        <span> Item com Produtos Relacionados </span>
                                        <div class="quadrado ml-1" style="background: var(--linhaAzul);">
                                        </div>
                                        <span> Item Relacionados Completos </span>
                                      </div>
                                    </div>
                                    <span style="margin-right: 10px; margin-left: auto;font-size: 14px; font-weight: bold" id="total_rolos_itens">Rolos: 0</span>
                                    <button id="btn-desdobrar-malha" style="margin-right: 0" class="btn btn-danger btn-sm d-none" type="button"><i class="fas fa-cut"></i> Desdobrar</button>
                                    <button id="btn-imprimir-malha" style="margin-right: 0px" class="btn btn-danger btn-sm ml-2 d-none" type="button"><i class="fas fa-print"></i> Imprimir</button>
                                    <button id="btn-rateiaPesoItens" style="margin-right: 0px" class="btn btn-danger btn-sm ml-2 d-none" type="button"><i class="fas fa-print"></i> Rateia Peso Itens</button>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                              <div class="info-box mb-3" style="background-color: var(--blue-color)!important;justify-content: flex-end;">
                                <div class="row" style="width: 100%">
                                  <div class="col-md-2 col-12">
                                    <div class="flex" style="padding-top:10px;">
                                      <span class="info-box-icon"><i class="fas fa-luggage-cart text-white" style="font-size: 25px;"></i></span>
                                      <div class="info-box-content">
                                        <span class="info-box-text text-white" style="font-size:15px">TOTAL QTDE.</span>
                                        <span id="total_itens" class="info-box-number text-white" style="font-size:17px">0</span>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-md-2 col-12">
                                    <div class="flex" style="padding-top:10px;">
                                      <span class="info-box-icon"><i class="fas fa-dollar-sign text-green" style="font-size: 25px;"></i></span>
                                      <div class="info-box-content">
                                        <span class="info-box-text text-white" style="font-size:15px">TOTAL ORIG.</span>
                                        <span id="total_orig" class="info-box-number text-white" style="font-size:17px">0</span>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-md-2 col-12">
                                    <div class="flex" style="padding-top:10px;">
                                      <span class="info-box-icon"><i class="fas fa-dollar-sign text-red" style="font-size: 25px;"></i></span>
                                      <div class="info-box-content">
                                        <span class="info-box-text text-white" style="font-size:15px">TOTAL DESC.</span>
                                        <span id="total_desc" class="info-box-number text-white" style="font-size:17px">0</span>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-md-2 col-12">
                                    <div class="flex" style="padding-top:10px;">
                                      <span class="info-box-icon"><i class="fas fa-shopping-cart text-white" style="font-size: 25px;"></i></span>
                                      <div class="info-box-content ">
                                        <span class="info-box-text text-white" style="font-size:15px">SUBTOTAL</span>
                                        <span id="subtotal_venda" class="info-box-number text-white" style="font-size:17px">0,00</span>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-md-2 col-12">
                                    <div class="flex">
                                      <span class="info-box-icon credito_cliente"><i class="fas fa-hand-holding-usd text-white" style="font-size: 25px;"></i></span>
                                      <div class="info-box-content credito_cliente">
                                        <span class="info-box-text text-white" style="font-size:15px">CRÉDITO</span>
                                        <span id="credito_cliente" class="info-box-number text-white" style="font-size:17px">0,00</span>
                                        <div class="d-flex">
                                          <span class="info-box-number text-white" style="font-size:13px">Saldo:&nbsp;</span>
                                          <span id="credito_cliente_saldo" class="info-box-number text-green" style="font-size:13px">0,00</span>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-md-2 col-12">
                                    <div class="flex" style="padding-top:10px;">
                                      <span class="info-box-icon"><i class="fas fa-equals text-white" style="font-size: 25px;"></i></span>
                                      <div class="info-box-content">
                                        <span class="info-box-text text-white" style="font-size:15px">SALDO</span>
                                        <span id="saldo_geral" class="info-box-number text-white" style="font-size:17px">0,00</span>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>

                          </div>
                        </div>
                      </fieldset>
                      <fieldset id="fieldset_pagamento" style="display:none">
                        <form>
                          <div class="form-card">
                            <div class="row">
                              <div class="col-lg-6 col-sm-12" id="tour-adicionar-condicoes">
                                <div class="card" style="height:auto;">
                                  <div class="card-body container-box">
                                    <div class="row mb-2">
                                      <div class="col-sm-3 col-3 ml-2 d-none" id="painelFrete">
                                        <label for="txtFrete">Valor Frete</label>
                                        <div class="relative">
                                          <input type="text" class="input-default focus" id="txtFrete" placeholder="Valor Frete" value="0">
                                        </div>
                                      </div>
                                      <div class="col-sm-3 col-3 d-none" id="painelCupomDesconto">
                                        <label data-error="wrong" data-success="right" for="txtCupomDesconto">Cupom de Desconto</label>
                                        <div class="input-group">
                                          <input style="text-transform: uppercase;" type="text" data-selecionado="false" class="input-default focus form-control ui-autocomplete-input" id="txtCupomDesconto" name="txtCupomDesconto" placeholder="Cupom Desconto" autocomplete="off" data-chave="" data-desc="">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-cupom-desconto" name="btn-cupom-desconto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button type="button" class="btn btn-danger" id="btnAplicarCupomDesconto" title="Aplicar" style="margin-left: 5px!important;">
                                              <i class="fas fa-solid fa-check"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="col-sm-3 col-3 d-none" id="painelCashback">
                                        <label data-error="wrong" data-success="right" for="c">Cashback Disp.</label>
                                        <div class="input-group">
                                          <input readonly disabled type="number" data-selecionado="false" class="input-default focus form-control ui-autocomplete-input" id="txtCashbackCliPagto" name="txtCashbackCliPagto" placeholder="Cashback Disponível" autocomplete="off" data-chave="" data-desc="">
                                        </div>
                                      </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                      <button id="btn-simular" title="Simular Condições de Pagamento" type="button" class="btn btn-sm btn-primary ml-2">
                                        <i class="fas fa-dollar-sign"></i>
                                      </button>
                                      <h5 style="margin-bottom: 0.2rem;" class="ml-2">Adicionar Condições</h5>
                                    </div>
                                    <div style="border-top: 1px solid #dee2e6" class="row pl-2 mt-2">
                                      <div class="col-12">
                                        <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtMoeda">Forma de Pagamento</label>
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" placeholder="Forma de Pagamento">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-moeda" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-moeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-3 d-none">
                                        <div class="group-default">
                                          <label for="txtBaixaAntecipacao">Baixa Ant.</label>
                                          <div class="relative">
                                            <input type="text" placeholder="Moeda" class="input-default" id="txtBaixaAntecipacao" name="txtBaixaAntecipacao" readonly>
                                          </div>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-3 d-none">
                                        <div class="group-default">
                                          <label for="txtTipoMoeda">Tipo Moeda</label>
                                          <div class="relative">
                                            <input type="text" placeholder="Moeda" class="input-default" id="txtTipoMoeda" name="txtTipoMoeda" readonly>
                                          </div>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-3 d-none">
                                        <div class="group-default">
                                          <label for="txtCodCondMoeda">Condicao Moeda</label>
                                          <div class="relative">
                                            <input type="text" placeholder="Moeda" class="input-default" id="txtCodCondMoeda" name="txtCodCondMoeda" readonly>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="col-sm-6" style="margin-top:4px">
                                        <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtCondicaoDePagamento">Cond. Pagamento</label>
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control" id="txtCondicaoDePagamento" name="txtCondicaoDePagamento" placeholder="Condição de Pagamento">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btn-CondicaoDePagamento" name="btn-CondicaoDePagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btn-limpa-condicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-6">
                                        <div class="group-default">
                                          <label style="margin-bottom:3px;" for="txtNrParcelas">Nr. Parcelas</label>
                                          <div class="relative">
                                            <input type="text" placeholder="Nr. Parcelas" class="input-default" id="txtNrParcelas" value="1" name="txtNrParcelas" readonly>
                                            <input type="text" placeholder="Nr. Parcelas" class="input-default d-none" id="txtMaxNrParcelasMoeda" name="txtMaxNrParcelasMoeda" readonly>
                                          </div>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-4 bandeira d-none">
                                        <label style="margin-bottom:0px;">Bandeira</label>
                                        <div class="input-group">
                                          <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                            <option value="" selected="selected">Selecione uma bandeira</option>
                                          </select>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-4 nsu d-none">
                                        <div class="group-default">
                                          <label style="margin-bottom:0!important;" for="txtNSU">NSU</label>
                                          <div class="relative">
                                            <input type="text" placeholder="NSU" class="input-default form-control focus" id="txtNSU" name="txtNSU">
                                          </div>
                                        </div>
                                      </div>
                                      <div style="margin-top:4px" class="col-sm-4 autorizacao d-none">
                                        <div class="group-default">
                                          <label style="margin-bottom:0!important;" for="txtAutorizacao">Autorização</label>
                                          <div class="relative">
                                            <input type="text" placeholder="Autorização" class="input-default form-control focus" id="txtAutorizacao" name="txtAutorizacao">
                                          </div>
                                        </div>
                                      </div>

                                      <div style="margin-top:4px" class="col-sm-6" id="painelValorParcela">
                                        <div class="group-default">
                                          <label for="txtValorParcela">Valor</label>
                                          <div class="relative">
                                            <input type="number" min="0" placeholder="Valor" class="input-default focus" id="txtValorParcela" name="txtValorParcela">
                                          </div>
                                        </div>
                                      </div>

                                      <div style="margin-top:4px" class="col-sm-6 d-none">
                                        <div class="group-default">
                                          <label for="txtValorEntrada">Valor</label>
                                          <div class="relative">
                                            <input type="number" min="0" placeholder="Valor" class="input-default focus" id="txtValorEntrada" name="txtValorEntrada">
                                          </div>
                                        </div>
                                      </div>

                                      <div style="margin-top:4px;" class="col-sm-6 d-none" id="PainelAcrescimo">
                                        <div class="row">
                                          <div class="col-sm-6">
                                            <div class="group-default">
                                              <label for="txtPercAcrescMoeda">Acrésc. (%)</label>
                                              <div class="relative">
                                                <input type="text" min="0" value="0" placeholder="% Acrésc." class="input-default focus" id="txtPercAcrescMoeda" name="txtPercAcrescMoeda">
                                              </div>
                                            </div>
                                          </div>
                                          <div class="col-sm-6">
                                            <div class="group-default">
                                              <label for="txtValorAcrescMoeda">Acrésc. (R$)</label>
                                              <div class="relative">
                                                <input type="text" min="0" value="0" placeholder="Valor Acréscimo" class="input-default focus" id="txtValorAcrescMoeda" name="txtValorAcrescMoeda">
                                                <input type="text" min="0" value="0" placeholder="Valor Acréscimo" class="input-default focus d-none" id="txtValorAcrescMoedaSalvo" name="txtValorAcrescMoedaSalvo">
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                      </div>

                                      <div style="margin-top:4px;" class="col-sm-6" id="PainelDesconto">
                                        <div class="row">
                                          <div class="col-sm-6">
                                            <div class="group-default">
                                              <label for="txtPercDescontoMoeda">Desc. (%)</label>
                                              <div class="relative">
                                                <input type="text" min="0" max="99" value="0.00" placeholder="% Desconto" class="input-default focus" id="txtPercDescontoMoeda" name="txtPercDescontoMoeda">
                                              </div>
                                            </div>
                                          </div>
                                          <div class="col-sm-6">
                                            <div class="group-default">
                                              <label for="txtValorDescontoMoeda">Desc. (R$)</label>
                                              <div class="relative">
                                                <input type="text" min="0" value="0.00" placeholder="Valor Desconto" class="input-default focus" id="txtValorDescontoMoeda" name="txtValorDescontoMoeda">
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                      </div>

                                      <div style="margin-top:4px" class="col-sm-6" id="painelValorLiquido">
                                        <div class="group-default">
                                          <label for="txtValorLiquidoMoeda">Val. Líquido</label>
                                          <div class="relative">
                                            <input type="number" min="0" placeholder="Valor Líquido" class="input-default focus" id="txtValorLiquidoMoeda" name="txtValorLiquidoMoeda" readonly>
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-sm-10 mt-2">
                                        <h5 style="width:100%;background-color: var(--blue-color)!important;padding: 5px;border-radius: 3px; padding-top:7px" class="text-white float-left">Saldo à Pagar :
                                          <span id="txtsaldo_a_pagar">R$ 0,00</span>
                                          <button id="btn-calc-suframa" style="margin-bottom: 4px" type="button" class="btn btn-sm btn-primary ml-2 d-none">Calcular Suframa</button>
                                        </h5>
                                      </div>
                                      <div class="col-sm-2 mt-2">
                                        <button type="button" id="btnAddCondicao" style="font-size:15px" class="btn btn-lg btn-secondary float-right focus">Adicionar</button>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-6 col-sm-12" id="tour-condicoes-de-pagamento" style="max-height: 500px;">
                                <div class="card" style="height: 401px;">
                                  <div class="card-body container-box">
                                    <h5>Condições de Pagamento</h5>
                                    <div class="row">
                                      <div class="col-sm-12 table-responsive" style="margin-bottom:13px">
                                        <table id="tabelaCondicoesDePagamento" style="width:100%" width="100%" class="table table-select table-hover">
                                          <thead>
                                            <tr>
                                              <th class="th-sm">Ordem</th>
                                              <th class="th-sm">Forma Pagto.</th>
                                              <th class="th-sm">Condição</th>
                                              <th class="th-sm">Valor</th>
                                              <th class="th-sm">Valor Pago</th>
                                              <th class="th-sm">Valor Parc.</th>
                                              <th class="th-sm">codmoeda</th>
                                              <th class="th-sm">codcondicao</th>
                                              <th class="th-sm">nrparcelas</th>
                                              <th class="th-sm">antecipacoes</th>
                                              <th class="th-sm">perc. desc.</th>
                                              <th class="th-sm">val. desc.</th>
                                              <th class="th-sm">nsu</th>
                                              <th class="th-sm">bandeira</th>
                                              <th class="th-sm">cartao presente</th>
                                              <th class="th-sm">Tipo Moeda</th>
                                              <th class="th-sm">autorizacao</th>
                                              <th class="th-sm">Ações</th>
                                            </tr>
                                          </thead>
                                          <tbody></tbody>
                                        </table>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="col-6">
                              </div>
                              <div class="col-lg-6 col-sm-12">
                                <button type="button" id="btn-informar-cliente" class="btn btn-primary btn-block btn-sisp mb-2 d-none">
                                  <span style="font-size: 20px!important;color: white!important;font-weight: bold;">Informar
                                    Cliente</span>
                                </button>
                              </div>
                              <div id="div-espaco" class="col-lg-6 col-sm-12">
                              </div>
                              <div id="div-antecipacoes" class="col-lg-6 col-sm-12 d-none">
                                <div class="card" style="height:auto;">
                                  <div class="card-body container-box" style="border: 3px dashed green;">
                                    <div class="row">
                                      <div class="col-sm-6">
                                        <h5>Antecipações Cliente</h5>
                                      </div>
                                      <div class="col-sm-6">
                                        <small class="float-right"> (Necessário moeda com a opção baixar
                                          antecipação)</small>
                                      </div>
                                    </div>
                                    <div class="row scrollAnte">
                                      <div class="col-sm-12 table-responsive">
                                        <table style="width:100%" width="100%" id="tabelaAntecipacoes" class="table table-sm table-select table-hover">
                                          <thead>
                                            <tr>
                                              <th class="th-sm">Sel</th>
                                              <th class="th-sm">Duplicata</th>
                                              <th class="th-sm">Emissão</th>
                                              <th class="th-sm">Vencimento</th>
                                              <th class="th-sm">Valor</th>
                                              <th class="th-sm">Val. Pago</th>
                                              <th class="th-sm">Venda</th>
                                              <th class="th-sm">Val. Utilizado</th>
                                              <th class="th-sm emp_ID">Emp_ID</th>
                                              <th class="th-sm">STATUS</th>
                                              <th class="th-sm"></th>
                                            </tr>
                                          </thead>
                                          <tbody></tbody>
                                        </table>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-6 col-sm-12 d-none">
                                <div class="card" style="height:auto;">
                                  <div class="card-body container-box">
                                    <h5>Parcelas de Pagamento</h5>
                                    <div class="row">
                                      <div class="col-sm-12 table-responsive">
                                        <table style="width:100%" width="100%" id="tabelaParcelasGeradas" class="table table-sm">
                                          <thead>
                                            <tr>
                                              <th class="th-sm">Ordem</th>
                                              <th class="th-sm">Nome</th>
                                              <th class="th-sm">CNPJ</th>
                                              <th class="th-sm">Banco</th>
                                              <th class="th-sm">Agencia</th>
                                              <th class="th-sm">Conta</th>
                                              <th class="th-sm">Numero</th>
                                              <th class="th-sm">Vencimento</th>
                                              <th class="th-sm">Valor</th>
                                            </tr>
                                          </thead>
                                          <tbody></tbody>
                                        </table>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-6 col-sm-12" id="tour-totais">
                                <div class="card" style="height:auto;">
                                  <div class="card-body container-box" style="background-color: var(--blue-color)!important">
                                    <h5 class="text-white">Totais</h5>
                                    <div class="table-responsive">
                                      <table style="width:100%;" id="tabelaTotais" class="table table-sm text-white" width="100%">
                                        <tr>
                                          <th class="th-sm">
                                            <h6>Total Venda (Qtde):</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotalQtde">0.00</h6>
                                          </td>
                                          <th class="th-sm">
                                            <h6>Total Venda (Valor):</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotalVenda">0,00</h6>
                                          </td>
                                        </tr>
                                        <tr>
                                          <th class="th-sm">
                                            <h6 id="txtPagamentosTotais">Pagamentos:</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotaisPagamentos">0,00</h6>
                                          </td>
                                          <th class="th-sm">
                                            <h6 id="textDescontos">Descontos:</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotaisDesconto">0,00</h6>
                                          </td>
                                        </tr>
                                        <tr>
                                          <th class="th-sm">
                                            <h6>Troco:</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotaisTroco">0,00</h6>
                                          </td>
                                          <th class="th-sm">
                                            <h6 id="txtTotalTotais">Total:</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotaisTotal">0,00</h6>
                                          </td>
                                        </tr>
                                        <tr id="rowIPI" class="d-none">
                                          <th class="th-sm">
                                            <h6>Total IPI:</h6>
                                          </th>
                                          <td>
                                            <h6 id="txtTotalIPI">0,00</h6>
                                            <input type="text" class="d-none" id="txtTotalRetIva" name="txtTotalRetIva" value="0">
                                          </td>
                                          <td colspan="2"></td> <!-- SERVE PARA DEIXAR UM ESPAÇO VAZIO NA TABLE -->
                                        </tr>
                                      </table>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </form>
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <div class="modal fade" id="imagemodal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <img src="" class="imagepreview" style="width: 100%;">
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalMensagensRFID" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <i class="fas fa-exclamation-triangle text-yellow" style="margin-right: 20px;font-size: 40px;margin-right: 20;"></i>
                <h4 id="modal-warning-titulo" class="modal-title">Atenção</h4>
                <button type="button" class="close" id="btn-warning-close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>              
              <div class="modal-body">
                <div class="row flex justify-content-end">
                  <div class="col-sm-12 table-responsive d-none divItensSemEstoqueRFID">
                    <h5>Estoque insuficiente para os seguintes produtos:</h5>
                    <table style="width:100%" width="100%" id="tabelaItensSemEstoqueRFID" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                  </div>
                  <div class="col-sm-12 table-responsive d-none divItensSemPreco mt-5">
                    <h5>Os seguintes produtos estão sem preço cadastrado:</h5>
                    <table style="width:100%" width="100%" id="tabelaItensSemPrecoAgrupados" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                    <div class="table-responsive mt-3 d-none">
                      <table style="width:100%" width="100%" id="tabelaItensSemPreco" class="table table-sm d-none">
                        <thead>
                          </thead>
                        </table>
                      </div>

                    <div class="row">
                      <div class="d-flex justify-content-end col-sm-12 mt-3 mb-3">
                        <button class="btn btn-primary btn-sisp" id="btnConfirmarPrecoRFID" type="button"> Confirmar Preço </button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12 table-responsive d-none divItensGrupoNaoPermiteConsig mt-5">
                    <h5>Os seguintes produtos não permitem consignado:</h5>
                    <table style="width:100%" width="100%" id="tabelaItensGrupoNaoPermiteConsig" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                  </div>
                  <div class="col-sm-12 table-responsive d-none divItensJaBipados mt-5">
                    <h5>Estas barras já foram bipadas anteriormente:</h5>
                    <table style="width:100%" width="100%" id="tabelaItensJaBipados" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalParcelas" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl" style="max-width: 90%; height: 90%">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalParcelas-titulo" class="modal-title">Crediário / Cheques</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row flex justify-content-end">
                  <div class="col-sm-4">
                    <input type="text" placeholder="Modo" class="input-default d-none" id="txt_cred_modo" name="txt_cred_modo" readonly>
                  </div>
                  <div class="col-sm-2">
                    <div class="group-default">
                      <label for="txtIntervaloDiasPrimeiroVencto">Dias 1º Vencto: </label>
                      <div class="relative flex">
                        <input type="text" placeholder="Dias entre Parcelas" maxlength="3" class="input-default" id="txtIntervaloDiasPrimeiroVencto" name="txtIntervaloDiasPrimeiroVencto">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-2">
                    <div class="group-default">
                      <label for="txtPrimeiroVencimento" class="mr-4">1º Vencto: </label>
                      <label for="txtPrimeiroVencimento" class="mr-1">Manter</label>
                      <input type="checkbox" id="cbManterDiaPrimeiroVencto" class="mb-1">
                      <div class="relative">
                        <input type="date" class="input-default" id="txtPrimeiroVencimento" name="txtPrimeiroVencimento">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-2">
                    <div class="group-default">
                      <label for="txtIntervaloDias">Intervalo de Dias: </label>
                      <div class="relative flex">
                        <input type="text" placeholder="Intervalo de Dias" maxlength="3" class="input-default" id="txtIntervaloDias" name="txtIntervaloDias">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-2 pb-2">
                    <div class="group-default">
                      <label for="txt_cred_valor_total">Valor Total: </label>
                      <div class="relative flex">
                        <input type="text" placeholder="Valor Total" class="input-default" id="txt_cred_valor_total" name="txt_cred_valor_total" readonly>
                        <button type="button" id="btn_dividir_valor" class="btn btn-primary"> Dividir</button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-4 d-none">
                    <div class="group-default">
                      <label for="txt_cred_valor_pago">Valor pago: </label>
                      <div class="relative flex">
                        <input type="text" placeholder="Valor pago" class="input-default" id="txt_cred_valor_pago" name="txt_cred_valor_pago" readonly>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12 table-responsive">
                    <table style="width:100%" width="100%" id="tabelaParcelas" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button id="btn_confirmar_cred" type="button" class="btn btn-danger"> Confirmar </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade"
          id="modalDepositoPreco"
          tabindex="-1"
          style="z-index: 99999"
          role="dialog"
          aria-labelledby="myModalLabel"
          aria-hidden="true"
          data-backdrop="static"
          data-keyboard="false">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Consulta Depósito</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row flex justify-content-end">
                  <div class="col-sm-12 table-responsive">
                    <table style="width:100%" width="100%" id="tabelaDepositosPreco" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalLotesDeposito" tabindex="-1" style="z-index: 9999999" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Lotes</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row flex justify-content-end">
                  <div class="col-sm-12 table-responsive">
                    <table style="width:100%" width="100%" id="tabelaLotesDepositosPreco" class="table table-sm">
                      <thead>
                      </thead>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalPresente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalPresente-titulo" class="modal-title">Cartão Presente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-12 mb-2">
                    <label data-error="wrong" data-success="right" for="txtNumeroCartao">Número Cartão</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control focus" id="txtNumeroCartao" name="txtNumeroCartao" placeholder="Número Cartão Presente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-limpa-NumeroCartao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-sm-3">
                  <label data-error="wrong" data-success="right" for="txtValorCartaoPresente">Valor Cartão</label>
                  <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtValorCartaoPresente" name="txtValorCartaoPresente" class="form-control" placeholder="Valor Cartão Presente" readonly value="0.00">
                </div>
                <div class="col-sm-3">
                  <label data-error="wrong" data-success="right" for="txtValorVendaCartaoPresente">Valor Total
                    Venda</label>
                  <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtValorVendaCartaoPresente" name="txtValorVendaCartaoPresente" class="form-control" placeholder="Valor Total Venda" readonly value="0.00">
                </div>
                <div class="col-sm-3">
                  <label data-error="wrong" data-success="right" for="txtValorAPagarCartaoPresente">Total A
                    Pagar</label>
                  <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtValorAPagarCartaoPresente" name="txtValorAPagarCartaoPresente" class="form-control" placeholder="Total A Pagar" readonly value="0.00">
                </div>
                <div class="col-sm-3">
                  <label data-error="wrong" data-success="right" for="txtValorSaldoCartaoPresente">Saldo</label>
                  <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtValorSaldoCartaoPresente" name="txtValorSaldoCartaoPresente" class="form-control" placeholder="Saldo" readonly value="0.00">
                </div>
                <div class="col-sm-12 table-responsive mt-2">
                  <table style="width:100%" width="100%" id="tabelaPresente" class="table table-sm">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_limpar_presente" class="btn btn-danger btn-sisp"> Limpar Cartões
                    </button>
                    <button type="button" id="btn_confirmar_presente" class="btn btn-primary btn-sisp"> Confirmar
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalCashback" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalCashback-titulo" class="modal-title">Cashback Disponível</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-6">
                    <label data-error="wrong" data-success="right" for="txtValorDisponivelCashback">Valor Cashback</label>
                    <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtValorDisponivelCashback" name="txtValorDisponivelCashback" class="form-control" placeholder="Valor Disponível Cashback" readonly value="0.00">
                  </div>
                  <div class="col-sm-6">
                    <label data-error="wrong" data-success="right" for="txtSaldoAPagarCashback">Saldo à pagar</label>
                    <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtSaldoAPagarCashback" name="txtSaldoAPagarCashback" class="form-control" placeholder="Total A Pagar" readonly value="0.00">
                  </div>
                  <div class="col-sm-6 d-none" id="divTotSemDesconto">
                    <label data-error="wrong" data-success="right" for="txtTotItensSemDesc">Total itens sem desconto</label>
                    <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtTotItensSemDesc" name="txtTotItensSemDesc" class="form-control" readonly value="0.00">
                  </div>
                  <div class="col-sm-6">
                    <label data-error="wrong" data-success="right" for="txtValorAUtilizarCashback" title="Cashback que será aplicado como desconto na condição atual" id="lbValorUtilizar">Valor à utilizar</label>
                    <input type="number" data-selecionado="false" min="0" step="0.1" class="input-default focus form-control" id="txtValorAUtilizarCashback" name="txtValorAUtilizarCashback" placeholder="Total A Pagar" value="0.00">
                  </div>
                  <div class="col-sm-6">
                    <label data-error="wrong" data-success="right" for="txtSaldoCashback" title="Saldo à pagar - desconto aplicado do cashback">Total Restante</label>
                    <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtSaldoCashback" name="txtSaldoCashback" class="form-control" placeholder="Saldo" readonly value="0.00">
                  </div>
                </div>
              </div>
              <div class="modal-footer justify-content-between">
                <button type="button" id="btnConfirmarCashback" class="btn btn-primary btn-sisp"> Confirmar
                </button>
                <button type="button" id="btnCancelarCashback" data-dismiss="modal" class="btn btn-danger btn-sisp"> Cancelar
                </button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modal-cliente-select" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Escolha um cliente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-12">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txt-cliente">Cliente</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txt-cliente" name="txt-cliente" class="form-control" placeholder="Cliente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                    <input type="text" placeholder="CNPJ" class="input-default focus form-control d-none " id="txt-cnpj" name="txt-cnpj">
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" id="btn_novo_cliente" class="btn btn-primary btn-sisp"> + Novo </button>
                <button type="button" id="btn_confirmar_cliente" class="btn btn-success btn-sisp"> Confirmar </button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modal-info-cliente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Informações do Cliente - [<span id="txtCodigoTittle"></span>]</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-12" id="collapseInfoAdicionais">
                    <div class="card card-body p-0">
                      <div class="d-flex">
                        <div class="col-4 pl-0">
                          <label data-error="wrong" data-success="right" for="txtDataCadastroInfo">Data de Cadastro</label>
                          <input type="date" readonly class="input-default focus form-control" id="txtDataCadastroInfo" name="txtDataCadastroInfo">
                        </div>
                        <div class="col-4 pl-0">
                          <label data-error="wrong" data-success="right" for="txtDataNascimentoInfo">Data de Nascimento</label>
                          <input type="date" readonly class="input-default focus form-control" id="txtDataNascimentoInfo" name="txtDataNascimentoInfo">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-4 pl-0">
                          <label data-error="wrong" data-success="right" for="txtCpfInfoCliente">CPF/CNPJ</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtCpfInfoCliente" name="txtCpfInfoCliente">
                        </div>
                        <div class="col-4 pl-0">
                          <label data-error="wrong" data-success="right" for="txtInscricaoInfoCliente">Inscrição</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtInscricaoInfoCliente" name="txtInscricaoInfoCliente">
                        </div>
                        <div class="col-1 pl-0">
                          <label data-error="wrong" data-success="right" for="txtDddInfoCliente">DDD</label>
                          <input type="number" readonly class="input-default focus form-control" id="txtDddInfoCliente" name="txtDddInfoCliente">
                        </div>
                        <div class="col-3 pl-0">
                          <label data-error="wrong" data-success="right" for="txtTelefoneInfoCliente">Telefone</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtTelefoneInfoCliente" name="txtTelefoneInfoCliente">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-12 pl-0">
                          <label data-error="wrong" data-sucess="right" for="txtEmailInfoCliente">E-mail</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtEmailInfoCliente" name="txtEmailInfoCliente">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-2 pl-0">
                          <label data-error="wrong" data-sucess="right" for="txtClassificacaoInfoCliente">Classificação</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtClassificacaoInfoCliente" name="txtClassificacaoInfoCliente">
                        </div>
                        <div class="col-4 pl-0">
                          <label data-error="wrong" data-sucess="right" for="txtGrupoInfoCliente">Grupo</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtGrupoInfoCliente" name="txtGrupoInfoCliente">
                        </div>
                        <div class="col-4 pl-0">
                          <label data-error="wrong" data-sucess="right" for="txtPerfilInfoCliente">Perfil</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtPerfilInfoCliente" name="txtPerfilInfoCliente">
                        </div>
                        <div class="col-2 pl-0">
                          <label data-error="wrong" data-sucess="right" for="txtPercDescontoInfoCliente">% Desconto</label>
                          <input type="text" readonly class="input-default focus form-control text-right" id="txtPercDescontoInfoCliente" name="txtPercDescontoInfoCliente">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-3 pl-0">
                          <label data-error="wrong" data-success="right" for="txtPaisInfoCliente">País</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtPaisInfoCliente" name="txtPaisInfoCliente">
                        </div>
                        <div class="col-2 pl-0">
                          <label data-error="wrong" data-success="right" for="txtCepInfoCliente">CEP</label>
                          <input type="number" readonly class="input-default focus form-control" id="txtCepInfoCliente" name="txtCepInfoCliente">
                        </div>
                        <div class="col-6 pl-0">
                          <label data-error="wrong" data-success="right" for="txtMunicipioInfoCliente">Cidade</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtMunicipioInfoCliente" name="txtMunicipioInfoCliente">
                        </div>
                        <div class="col-1 pl-0">
                          <label data-error="wrong" data-success="right" for="txtEstadoInfoCliente">UF</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtEstadoInfoCliente" name="txtEstadoInfoCliente">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-3 pl-0">
                          <label data-error="wrong" data-success="right" for="txtBairroInfoCliente">Bairro</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtBairroInfoCliente" name="txtBairroInfoCliente">
                        </div>
                        <div class="col-9 pl-0">
                          <label data-error="wrong" data-success="right" for="txtEnderecoInfoCliente">Rua</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtEnderecoInfoCliente" name="txtEnderecoInfoCliente">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-2 pl-0">
                          <label data-error="wrong" data-success="right" for="txtNumeroInfoCliente">Número</label>
                          <input type="number" readonly class="input-default focus form-control" id="txtNumeroInfoCliente" name="txtNumeroInfoCliente">
                        </div>
                        <div class="col-10 pl-0">
                          <label data-error="wrong" data-success="right" for="txtComplementoInfoCliente">Complemento</label>
                          <input type="text" readonly class="input-default focus form-control" id="txtComplementoInfoCliente" name="txtComplementoInfoCliente">
                        </div>
                      </div>
                      <div class="d-flex pt-2">
                        <div class="col-12 pl-0">
                          <label data-error="wrong" data-success="right" for="txtObsInfoCliente">Observação</label>
                          <textarea style="resize: none; border-color: #a9a9a9;" type="text" readonly class="focus form-control" id="txtObsInfoCliente" name="txtObsInfoCliente"></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn btn-danger btn-sisp"> Fechar </button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modal-informacoes-adicionais" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Informações Adicionais</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-12" id="collapseInfoAdicionais">
                    <div class="card card-body p-0">
                      <div id="tranportadoraInfoTour">
                        <label data-error="wrong" data-success="right" for="txtTransportadora">Transportadora</label>
                        <div class="input-group">
                          <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTransportadora" name="txtTransportadora" class="form-control" placeholder="Transportadora">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-transportadora" name="btn-transportadora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-transportadora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                      <div class="">
                        <label data-error="wrong" data-success="right" for="txtVolumes">Volumes</label>
                        <input type="number" class="input-default focus form-control" id="txtVolumes" name="txtVolumes" class="form-control" placeholder="Volumes">
                      </div>
                      <div class="mt-2">
                        <label data-error="wrong" data-success="right" for="rgTransportador">Frete por Conta</label>
                        <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgTransportador" aria-invalid="false">
                          <option value="">Selecione uma opção</option>
                          <option value="0">0 - Contratação do Frete por conta do
                            Remetente
                            (CIF)</option>
                          <option value="1">1 - Contratação do Frete por conta do
                            Destinatário
                            (FOB)</option>
                          <option value="2">2 - Contratação do Frete por conta de
                            Terceiros
                          </option>
                          <option value="3">3 - Transporte Próprio por conta do Remetente
                          </option>
                          <option value="4">4 - Transporte Próprio por conta do
                            Destinatário
                          </option>
                          <option selected="" value="9">9 - Sem Ocorrência de Transporte</option>
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" id="btn_confirmar_informacoes_adicionais" class="btn btn-success btn-sisp"> Confirmar </button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalDescontoTotal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalDesc-titulo" class="modal-title">Alteração de valores em massa</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="form-row">
                  <div class="col-12">
                    <div class="radio-group form-radio icheck-primary">
                      <input type="checkbox" id="cbSemDescontoItensPromocionais">
                      <label for="cbSemDescontoItensPromocionais">Não aplica desconto em itens promocionais</label>
                    </div>
                  </div>
                  <div class="col-6">
                    <div id="infoPercDesconto">
                      <label data-error="wrong" data-success="right" for="txtDesconto">Desconto % por item</label>
                      <div class="input-group">
                        <input type="text" value="0.00" data-selecionado="false" class="input-default focus form-control desconto-em-massa percentual" min="0" max="100" id="txtDesconto" name="txtDesconto" class="form-control" placeholder="Percentual Desconto" title="Esse campo distribuirá o percentual informado individualmente em cada item, por exemplo, se informar 10% cada item receberá um desconto nesse percentual.">
                      </div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div id="infoValorDesconto">
                      <label data-error="wrong" data-success="right" for="txtValDesconto">Desconto R$ por item</label>
                      <div class="input-group">
                        <input type="text" value="0.00" data-selecionado="false" class="input-default focus form-control desconto-em-massa valor" id="txtValDesconto" name="txtValDesconto" class="form-control" placeholder="Valor Desconto" title="Esse campo distribuirá o valor informado individualmente em cada item, por exemplo, se informar R$ 10,00 cada item receberá um desconto nesse valor.">
                      </div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div id="infoPercDescontoRateado">
                      <label data-error="wrong" data-success="right" for="txtPercDescontoRateado">Desconto % rateado</label>
                      <div class="input-group">
                        <input type="text" value="0.00" data-selecionado="false" class="input-default focus form-control desconto-em-massa percentual" id="txtPercDescontoRateado" name="txtPercDescontoRateado" class="form-control" placeholder="Percentual Desconto por item" title="Esse campo distribuirá o percentual informado rateando em cada item. Por exemplo, se informar 10% e houver 2 itens na venda, cada item receberá 5%">
                      </div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div id="infoDescontoRateado">
                      <label data-error="wrong" data-success="right" for="txtValDescontoRateado">Desconto R$ rateado</label>
                      <div class="input-group">
                        <input type="text" value="0.00" data-selecionado="false" class="input-default focus form-control desconto-em-massa valor" id="txtValDescontoRateado" name="txtValDescontoRateado" class="form-control" placeholder="Valor Desconto por item" title="Esse campo distribuirá o valor informado rateando em cada item. Por exemplo, se informar R$ 10,00 e houver 2 itens na venda, cada item receberá R$ 5,00.">
                      </div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div id="infoPrecoItem">
                      <label data-error="wrong" data-success="right" for="txtPrecoItem">Preço do Item</label>
                      <div class="input-group">
                        <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtPrecoItem" name="txtPrecoItem" class="form-control" placeholder="Preço Item">
                      </div>
                    </div>
                  </div>
                  <div class="col-6">
                    <div id="infoValorTotal">
                      <label data-error="wrong" data-success="right" for="txtValorTotal">Valor Total</label>
                      <div class="input-group">
                        <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtValorTotal" name="txtValorTotal" class="form-control" placeholder="Valor Pago" disabled>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Desconto %: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default" id="txtDesconto" min="0" max="100" placeholder="Desconto">
                  </div>
                </div> -->

                <!-- <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Valor Total: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default" id="txtValorTotal" placeholder="Valor Pago" disabled>
                  </div>
                </div> -->
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-12">
                    <button type="button" class="btn btn-danger" id="btnRemoveDesconto">Remover Desc.</button>
                    <button type="button" class="btn btn-primary" id="btnAplicaDesconto">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalPrecos" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modal-simular-titulo" class="modal-title">Info. Estoque e Preço</h4>
                <div>
                  <div class="col-lg-auto col-12 ml-2 mt-2">
                    <div class="form-row">
                      <div class="d-flex">
                        <div class="radio-group form-radio icheck-primary ml-3">
                          <input type="radio" checked id="radioProdutoPreco" name="tipoFat">
                          <label for="radioProdutoPreco" class="container escondeRadio">Produto</label>
                        </div>
                        <div class="radio-group form-radio icheck-primary">
                          <input type="radio" id="radioMaterialPreco" name="tipoFat">
                          <label for="radioMaterialPreco" class="container escondeRadio">Material</label>
                        </div>
                      </div>
                      <div id="divFlagsPreco" class="row">
                        <div class="icheck-primary pl-1">
                          <input type="checkbox" class="form-check-input" name="cbContemEstoquePreco" id="cbContemEstoquePreco">
                          <label class="form-check-label pr-2" for="cbContemEstoquePreco">Somente c/ Estoque</label>
                        </div>
                        <div class="icheck-primary pl-1" title="Com essa opção marcada, o relatório irá buscar as informações de todos os depósitos.">
                          <input type="checkbox" class="form-check-input" id="cbTodosDepositos">
                          <label class="form-check-label pr-2" for="cbTodosDepositos">Todos os Depósitos</label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row" style="margin-right: -15px">

                  <div class="col-12 row pr-0">
                    <div class="col-8">
                      <div class="form-row">
                        <div class="col-6" id="divBarraPreco">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtBarra">Código de Barras: </label>
                          <div class="input-group">
                            <input type="text" autofocus="true" class="input-default form-control pula" id="txtBarra" name="txtBarra" placeholder="Código de barras">
                            <button title="Bipar com câmera" type="button" class="btn-icon btn-icon-normal bg-danger" id="btnCameraPreco">
                              <i style="color: white;font-size:20px;margin-left:-10px;padding:0px" class="fas fa-camera"></i>
                            </button>
                          </div>
                        </div>
                        <div class="col-sm-6 divGeralMaterial">
                          <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="dtFabricacaoDe">Fabricação de/até: </label>
                          <div class="relative">
                            <div class="input-group">
                              <input type="date" class="input-default focus form-control mr-1" id="dtFabricacaoDe" value="1200-01-01" name="dtFabricacaoDe" class="form-control">
                              <input type="date" class="input-default focus form-control" id="dtFabricacaoAte" value="2500-12-31" name="dtFabricacaoAte" class="form-control">
                            </div>
                          </div>
                        </div>
                        <div class="form-group col-lg-6 col-12 col-sm-12">
                          <label data-error="wrong" data-success="right" id="labelMaterial" for="txtCodigoProd">Código: </label>
                          <div class="relative">
                            <div class="input-group">
                              <select class="js-example-programmatic js-states form-control" id="txtCodigoProd" name="txtCodigoProd" multiple="multiple">
                              </select>
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btnCodigoProd" name="btnCodigoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btnLimpaCodigoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="col-sm-6">
                          <label style="margin-bottom: 8px !important;" data-error="wrong" data-success="right" for="txtDescricaoProd">Descrição: </label>
                          <div class="input-group">
                            <input type="text" autofocus="true" class="input-default form-control pula" id="txtDescricaoProd" name="txtDescricaoProd" placeholder="Descrição">
                          </div>
                        </div>

                      </div>
                    </div>

                    <div class="col-2 ml-auto mr-auto">
                      <div class="col-sm-12 col-12">
                        <div class="form-group">
                          <label for="infoprodtam">Foto</label>
                          <div class="relative" style="display: flex; justify-content: space-around;">
                            <img class="pop img img-fluid" id="fotoPrecoProdutoMaterial" style="max-height:100px;max-width:100px;" src="/sisplan_web/dist/img/prod-1.png">
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-12">
                      <div class="divGeralMaterial">
                        <div class="row">
                          <div class="col-sm-4">
                            <label data-error="wrong" data-success="right" for="txtGrupoMA">Grupo: </label>
                            <div class="relative">
                              <div class="input-group">
                                <!-- <input type="text" class="input-default focus form-control" id="txtGrupoMA" name="txtGrupoMA" class="form-control" placeholder="Grupo"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtGrupoMA" name="txtGrupoMA" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnGrupoMA" name="btnGrupoMA" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaGrupoMA" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-4" id="divTamanho">
                            <label data-error="wrong" data-success="right" for="txtSubGrupo">Sub Grupo: </label>
                            <div class="relative">
                              <div class="input-group">
                                <!-- <input type="text" class="input-default focus form-control" id="txtSubGrupo" name="txtSubGrupo" class="form-control" placeholder="Sub Grupo"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtSubGrupo" name="txtSubGrupo" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnSubGrupo" name="btnSubGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaSubGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-4" id="divLinha">
                            <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtLinhaPreco">Linha: </label>
                            <div class="relative" style="margin-top: 5px;">
                              <div class="input-group">
                                <!-- <input type="text" class="input-default focus form-control" id="txtLinhaPreco" name="txtLinhaPreco" class="form-control" placeholder="Linha"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtLinhaPreco" name="txtLinhaPreco" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnLinhaPreco" name="btnLinhaPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaLinhaPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-sm-4">
                            <label data-error="wrong" data-success="right" for="txtQualidade">Qualidade: </label>
                            <div class="relative">
                              <div class="input-group">
                                <!-- <input type="text" class="input-default focus form-control" id="txtQualidadePreco" name="txtQualidadePreco" class="form-control" placeholder="Qualidade"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtQualidadePreco" name="txtQualidadePreco" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnQualidadePreco" name="btnQualidadePreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaQualidadePreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-4">
                            <label data-error="wrong" data-success="right" for="txtLoteInternoPreco">Lote Interno: </label>
                            <div class="relative">
                              <div class="input-group">
                                <!-- <input type="text" class="input-default focus form-control" id="txtLoteInternoPreco" name="txtLoteInternoPreco" class="form-control" placeholder="Lote Interno"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtLoteInternoPreco" name="txtLoteInternoPreco" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnLoteInternoPreco" name="btnLoteInternoPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaLoteInternoPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-4">
                            <label data-error="wrong" data-success="right" for="txtTonalidadePreco">Tonalidade: </label>
                            <div class="relative">
                              <div class="input-group">
                                <!-- <input type="text" class="input-default focus form-control" id="txtTonalidadePreco" name="txtTonalidadePreco" class="form-control" placeholder="Tonalidade"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtTonalidadePreco" name="txtTonalidadePreco" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnTonalidadePreco" name="btnTonalidadePreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaTonalidadePreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-12 row pr-0">
                        <div class="col-sm-6 mt-2 pl-0" style="margin-bottom: 10px;">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtDepositoProd">Depósito: </label>
                          <div class="input-group">
                            <!-- <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtDepositoProd" name="txtDepositoProd" class="form-control" placeholder="Deposito"> -->
                            <select class="js-example-programmatic js-states form-control" id="txtDepositoProd" name="txtDepositoProd" multiple="multiple">
                            </select>
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnDepositoProd" name="btnDepositoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaDepositoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                        <div class="col-sm-6 mt-2 pl-0" style="margin-bottom: 10px;">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtTabelaPrecoProd">Tabela de Preço: </label>
                          <div class="input-group">
                            <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTabelaPrecoProd" name="txtTabelaPrecoProd" class="form-control" placeholder="Tabela de Preço">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnTabelaPrecoProd" name="btnTabelaPrecoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaTabelaPrecoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                            <div class="input-group-append d-none" id="divRgPrazoPrecos">
                              <label data-error="wrong" data-success="right" for="rgPrazoPrecos" id="labelPrazo2" style="margin-top:-22px;margin-right:-34px;">Prazo: </label>
                              <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgPrazoPrecos" class="custom-select focus">
                                <option selected value="00">00</option>
                                <option value="07">07</option>
                                <option value="14">14</option>
                                <option value="21">21</option>
                                <option value="28">28</option>
                                <option value="35">35</option>
                                <option value="42">42</option>
                                <option value="49">49</option>
                                <option value="56">56</option>
                                <option value="63">63</option>
                                <option value="70">70</option>
                                <option value="77">77</option>
                                <option value="84">84</option>
                                <option value="91">91</option>
                              </select>
                            </div>
                            <div style="margin-right: -13px">
                              <button class="btn btn-sisp bg-gradient-secondary ml-1 divGeralMaterial" id="btnAbreModalDepositosPreco">Depósitos</button>
                              <button class="btn btn-sisp btn-primary ml-1" id="btnConsultarPreco">Consultar</button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-12 row" style="margin-left:0.7%">
                    <div class="info-box mb-3 row" style="background-color: var(--blue-color)!important">
                      <span class="info-box-icon"><i class="fas fa-file-alt text-white"></i></span>
                      <div class="info-box-content ">
                        <span class="info-box-text text-white" style="font-size:15px">PRODUTO</span>
                        <span id="txtDescProduto" class="info-box-number text-white" style="font-size:15px">Descrição do
                          produto</span>
                      </div>
                      <span class="info-box-icon"><i class="fas fa-dollar-sign text-white"></i></span>
                      <div class="info-box-content ">
                        <span class="info-box-text text-white" style="font-size:15px">PREÇO DO PRODUTO</span>
                        <span id="txtPrecoProduto" class="info-box-number text-white" style="font-size:20px; color: var(--linhaDesconto) !important;">0,00</span>
                      </div>
                      <span class="info-box-icon"><i class="fas fa-sort-amount-up-alt text-white"></i></span>
                      <div class="info-box-content " style="margin-top: 0.3%;">
                        <span class="info-box-text text-white" style="font-size:15px">QUANTIDADE TOTAL</span>
                        <b style="margin-top: 2.3%;"><span id="txtQtdeProduto" class="info-box-number1 text-white" style="font-size:20px; margin-top: 2%; color: var(--linhaDesconto) !important;">0</span></b>
                      </div>
                    </div>
                  </div>
                </div>

                <input type="number" data-selecionado="false" class="input-default focus form-control d-none" id="txtEstoquePrecoControle" name="txtEstoquePrecoControle" value="1" class="form-control" placeholder="">
                <div id="tabelaEstPrec" class="row d-none" style="margin-left: 2%; margin-right: 2%; margin-bottom: 2%">
                  <div class="col-12 table-responsive">
                    <table id="tabelaEstoquePreco" class="table table-sm table-select table-hover display" width="100%" style="width: 100%">
                      <thead>
                      </thead>
                      <tbody></tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modal-simular" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modal-simular-titulo" class="modal-title">Simulação de Pagamento</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-4">
                    <div class="row">

                      <div class="col-sm-12">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtMoedaSimulacao">Forma de pagamento:</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtMoedaSimulacao" name="txtMoedaSimulacao" class="form-control" placeholder="Forma de pagamento">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnMoedaSimulacao" name="btnMoedaSimulacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btnLimpaMoedaSimulacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-12">
                        <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="CondPagto">Cond. Pagamento</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtCondPagto" name="txtCondPagto" class="form-control" placeholder="Condição de Pagamento">
                          <input id="txtNrParcelasCondPagto" type="text" class="d-none" />

                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-CondPagto" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-CondPagto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txt_val_venda">Valor Venda </label>
                          <input type="text" placeholder="Valor Total" class="input-default" id="txt_val_venda" name="txt_val_venda" readonly>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txt_val_ent">Valor Entrada </label>
                          <input type="text" placeholder="Valor Total" class="input-default" id="txt_val_ent" name="txt_val_ent">
                        </div>
                      </div>
                      <div style="margin-top:4px;" class="col-sm-12" id="PainelDesconto">
                        <div class="row">
                          <div class="col-sm-6">
                            <div class="group-default">
                              <label for="txtPercDescontoSimulacao">Desc. (%)</label>
                              <div class="relative">
                                <input type="text" min="0" max="99" value="0.00" placeholder="% Desconto" class="input-default focus" id="txtPercDescontoSimulacao" name="txtPercDescontoSimulacao">
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="group-default">
                              <label for="txtValorDescontoSimulacao">Desc. (R$)</label>
                              <div class="relative">
                                <input type="text" min="0" value="0" placeholder="Valor Desconto" class="input-default focus" id="txtValorDescontoSimulacao" name="txtValorDescontoSimulacao">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txt_val_liq">Valor Líquido </label>
                          <input type="text" placeholder="Valor Total" class="input-default" id="txt_val_liq" name="txt_val_liq" readonly>
                        </div>
                      </div>
                      <div class="col-12 mt-3">
                        <div class="button-group">
                          <button style="width:47%;" type="button" id="btn-simulacao" class="btn btn-sisp btn-primary">Simular</button>
                          <button style="width:47%;" type="button" id="btn-utilizar" class="btn btn-sisp btn-danger ml-3">Utilizar</button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-8">
                    <label>Parcelas e Valores</label>
                    <div class="table-responsive">
                      <table width="100%" style="width:100%" id="tabela_simula" class="table table-sm table-select table-hover table-condensed">
                        <thead>
                          <tr>
                            <th>Parcela</th>
                            <th>Vencto</th>
                            <th>Valor</th>
                          </tr>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalProdutosRelacionados" tabindex="-1" role="dialog" aria-labelledby="modalProdutosRelacionados" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Produtos Relacionados</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">

                <div class="row">
                  <div class="col-12">
                    <div class="group-default" style="font-size: 16px">
                      <label for="txtProdutoRelacionadoVenda">Produto selecionado:</label>
                      <input type="text" id="txtProdutoRelacionadoVenda" class="input-default" disabled name="txtProdutoRelacionadoVenda"></span>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-12 table-responsive mt-2 px-0">
                    <table style="width:100%; white-space:nowrap " width="100%" id="tabelaProdutosRelacionados" class="table table-sm table-select table-hover table-condensed">
                      <thead></thead>
                      <tbody></tbody>
                    </table>
                  </div>
                </div>

              </div>
              <div class="modal-footer">
                <button class="btn btn-danger btn-sisp" id="btnConfirmarRelacionamento"> Confirmar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalPesoBalanca" tabindex="-1" role="dialog" aria-labelledby="modalPesoBalanca" aria-hidden="true">
          <div class="modal-dialog modal-md">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Busca Peso Balança</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-6">
                    <label for="txtValorTotalBalanca" class="col-sm-12">Valor Total: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="txtValorTotalBalanca" placeholder="Valor Total" disabled>
                      <input type="number" class="form-control input-default d-none" id="txtValorUnitarioBalanca" value="0" placeholder="Valor Total" disabled>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <label for="pesoTotalBalanca" class="col-sm-12">Peso Total: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="pesoTotalBalanca" placeholder="Peso Total">
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button class="btn btn-danger btn-sisp" id="btnConfirmarPesoBalanca"> Confirmar Peso</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalProduto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl" style="max-width: 100%; height: 100%; margin: 0; padding: 0;" role="document">
            <div class="modal-content" style="min-height: 100%; border-radius: 0;">
              <div class="modal-header">
                <h4 id="modalProduto-titulo" class="modal-title">Pesquisa Itens </h4>
                <div>
                  <div class="col-lg-auto col-12 ml-2 mt-2">
                    <div class="form-row">
                      <div class="d-flex">
                        <div class="radio-group form-radio icheck-primary ml-3">
                          <input type="radio" checked id="radioProduto" name="radioPesquisaProduto">
                          <label for="radioProduto" class="container escondeRadio">Produto</label>
                        </div>
                        <div class="radio-group form-radio icheck-primary">
                          <input type="radio" id="radioMaterial" name="radioPesquisaProduto">
                          <label for="radioMaterial" class="container escondeRadio">Material</label>
                        </div>
                        <div class="radio-group form-radio icheck-primary">
                          <input type="checkbox" id="cbContemEstoque">
                          <label for="cbContemEstoque">Somente c/ Estoque</label>
                        </div>
                        <div class="radio-group form-radio icheck-primary d-none ml-3" id="checkDepEcommerce">
                          <input type="checkbox" id="cbDepositoEcommerce">
                          <label for="cbDepositoEcommerce">Depósito e-commerce</label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-2">
                    <label for="">Filtros </label>
                    <div class="relative" id="selectFiltrosProduto">
                      <select class="input-default select2 select2-danger" name="selectFiltros" id="selectFiltros">
                        <option value="CODIGO">CODIGO</option>
                        <option value="CODIGO2">CODIGO2</option>
                        <option value="DESCRICAO">DESCRICAO</option>
                        <option value="COR">COR</option>
                        <option value="DESC_COR">DESC_COR</option>
                        <option value="GRUPO">GRUPO</option>
                        <option value="COLECAO">COLECAO</option>
                        <option value="SUBGRUPO">SUBGRUPO</option>
                        <option value="TAM">TAMANHO</option>
                        <option value="BARRA">BARRA</option>
                        <option value="DESC_ECOMMERCE">DESC_ECOMMERCE</option>
                        <option value="LOTE">LOTE</option>
                        <option value="DESCRICAO2">DESCRICAO2</option>
                        <option value="REFERENCIA">REFERENCIA</option>
                        <option value="BARRA28">BARRA28</option>
                        <option value="LINHA">LINHA</option>
                        <option value="ETIQUETA">ETIQUETA</option>
                        <option value="MARCA">MARCA</option>
                        <option value="COR">COR</option>
                      </select>
                    </div>
                  </div>

                  <div class="col-sm-4">
                    <label for="" id="nomeFiltro">Campo Consulta </label>
                    <div class="relative">
                      <input type="text" placeholder="Campo Consulta" class="input-default focus" id="txtCampoConsulta" name="txtCampoConsulta">
                    </div>
                  </div>
                  <div class="col-sm-3 d-flex align-items-start" style="text-align:center;">
                    <button type="button" style="margin-top: 28px; width: 100%; max-width: 135px; margin-bottom: 12px;" class="btn btn-info focus" id="btnConsultarItens" name="btnConsultarItens">
                      <i class='fas fa-search'></i> Consultar
                    </button>
                  </div>
                  <div class="col-sm-3">
                    <label for="" style="margin-bottom: 0px !important;">Buscar </label>
                    <div class="form-check icheck-primary" style="margin-bottom: 0px !important;">
                      <input class="form-check-input" value="0" type="radio" name="rgPesquisaTipo" id="rgPesquisaTipo1">
                      <label class="form-check-label" for="rgPesquisaTipo1">Iniciando</label>
                    </div>
                    <div class="form-check icheck-primary" style="margin-bottom: 0px !important;">
                      <input class="form-check-input" value="1" type="radio" name="rgPesquisaTipo" id="rgPesquisaTipo2" checked>
                      <label class="form-check-label" for="rgPesquisaTipo2">
                        Contendo a(s) Palavra(s)
                      </label>
                    </div>
                    <div class="form-check icheck-primary" style="margin-bottom: 0px !important;">
                      <input class="form-check-input" value="2" type="radio" name="rgPesquisaTipo" id="rgPesquisaTipo3">
                      <label class="form-check-label" for="rgPesquisaTipo3">
                        Contendo a Expressão
                      </label>
                    </div>
                    <div class="form-check icheck-primary" style="margin-bottom: 0px !important;">
                      <input class="form-check-input" value="3" type="radio" name="rgPesquisaTipo" id="rgPesquisaTipo4">
                      <label class="form-check-label" for="rgPesquisaTipo4">
                        Igual
                      </label>
                    </div>

                  </div>
                  <div class="col-sm-12 table-responsive mt-2 px-0" style="overflow: hidden!important;">
                    <table style="width:100%; white-space:nowrap " width="100%" id="tabelaProdutoMaterial" class="table table-sm-sisp table-select table-hover animate__animated animate__fadeIn">
                      <thead>
                        <tr id="colunas">
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                        </tr>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_produto" class="btn btn-danger"> Confirmar </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>


        <div class="modal fade" id="modalMaterial" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl" style="max-width: 100%; height: 100%; margin: 0; padding: 0;" role="document">
            <div class="modal-content" style="min-height: 100%; border-radius: 0;">
              <div class="modal-header">
                <h4 id="modalMaterial-titulo" class="modal-title">Pesquisa Itens </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body" style="overflow-y: hidden!important;">
                <div class="row" style="padding-left: 16px; padding-right: 16px">
                  <div class="col-sm-5 col-12" style="padding-left:0px">
                    <label for="" id="nomeMaterialFiltro">Consulta </label>
                    <div class="relative">
                      <input type="text" placeholder="Campo Consulta" class="input-default focus" id="txtMaterialCampoConsulta" name="txtMaterialCampoConsulta">
                    </div>
                  </div>
                  <div class="col-12 col-sm-7" style="display: flex;flex-direction: row;justify-content: flex-start;align-items: flex-end;">
                    <div class="">
                      <div class="form-row">
                        <div class="d-flex">
                          <div class="radio-group form-radio icheck-primary" style="margin-bottom: 0px!important">
                            <input type="checkbox" id="cbMaterialContemEstoque" checked="checked">
                            <label for="cbMaterialContemEstoque">Somente c/ Estoque</label>
                          </div>
                        </div>
                      </div>
                      <div class="form-row">
                        <div class="d-flex">
                          <div class="radio-group form-radio icheck-primary" title="Pesquisar malha em todos os depósitos" style="margin-bottom: 0px!important">
                            <input type="checkbox" id="cbMaterialTodosDeposito">
                            <label for="cbMaterialTodosDeposito">Todos os depósitos</label>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="ml-4"><button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button></div>
                  </div>
                  <div class="col-sm-12 table-responsive mt-2 px-0" style="overflow: hidden !important;">
                    <table style="width:100%;" width="100%" id="tabelaMaterial" class="table table-sm-sisp table-select table-hover animate__animated animate__fadeIn">
                      <thead>
                        <tr id="colunas">
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                          <th></th>
                        </tr>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_material" class="btn btn-danger"> Confirmar </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalVendasPendentes" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalProdutos-titulo" class="modal-title">Vendas Pendentes</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-12 table-responsive">
                    <table style="width:100%" width="100%" id="tabelaVendasPendentes" class="table table-sm table-select table-hover table-condensed">
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_venda_pendente" class="btn btn-danger"> Confirmar </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="modalImportarVendas" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header d-flex align-items-center">
                <h4 id="modalImportarVendas-titulo" class="modal-title mr-3">Importação</h4>

                <div id="divImpVen">
                  <fieldset class="form border-Field mb-0 pb-0 d-flex" style="margin: 0px !important;">
                    <legend class="textoBorda mb-0 pb-0">Opções</legend>
                    <div class="icheck-primary"><input type="checkbox" class="checkVendas" id="buscaVendaOutrasEmpresas" name="tipoFat"><label style="font-size: 85%; width: 100%" class="container checkVendas" for="buscaVendaOutrasEmpresas">Pesquisa Venda de Outras Empresas</label></div>
                    <div class="icheck-primary">
                      <input type="checkbox" class="checkManterValor" id="ManterValor" name="tipoFat">
                      <label style="font-size: 85%; width: 100%" class="container checkVendas" for="ManterValor" title="Mantém o valor dos itens da venda original">Manter Valor</label>
                    </div>
                  </fieldset>
                </div>

                <div id="divImpPed" class="d-none">
                  <fieldset class="form border-Field mb-0 pb-0 d-flex" style="margin: 0px !important;">
                    <legend class="textoBorda mb-0 pb-0">Opções</legend>
                    <div class="icheck-primary"><input type="checkbox" class="checkPedidos" id="buscaPedidoOutrasEmpresas" name="bPedido" checked><label style="font-size: 85%; width: 100%" class="container checkPedidos" for="buscaPedidoOutrasEmpresas">Pesquisa Pedido de Outras Empresas</label></div>
                    <div class="icheck-primary"><input type="checkbox" class="checkPedidos" id="cbBuscaPrecoPedido" name="cbBuscaPrecoPedido"> <label style="font-size: 85%; width: 100%" class="container checkPedidos" for="cbBuscaPrecoPedido"> Busca preço do pedido (não da tabela de preço) </label></div>
                  </fieldset>
                </div>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <nav>
                  <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
                    <a class="nav-link abaLink active" id="tabImpVenda" data-toggle="tab" href="#divImportarVenda" role="tab" aria-controls="divImportarVenda" aria-selected="true">Importar Venda</a>
                    <a class="nav-link abaLink" id="tabImpPedido" data-toggle="tab" href="#divImportarPedido" role="tab" aria-controls="divImportarPedido" aria-selected="false">Importar Pedido</a>
                    <a class="nav-link abaLink" id="tabImpArquivo" data-toggle="tab" href="#divImportarArquivo" role="tab" aria-controls="divImportarArquivo" aria-selected="false">Importar Arquivo</a>
                  </div>
                </nav>

                <div class="tab-content" id="nav-tabContent">

                  <div class="tab-pane fade show active" id="divImportarVenda" role="tabpanel" aria-labelledby="tabImpVenda">
                    <div class="col-12">
                      <div class="row" style="margin-top: 11px;">
                        <div class="col-sm-5">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtVenda">Venda</label>
                          <div class="input-group">
                            <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtVenda" name="txtVenda" class="form-control" placeholder="Venda">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btn-venda" name="btn-venda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btn-limpa-venda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                        <div class="col-sm-5">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtTabelaImpVenda">Tabela</label>
                          <div class="input-group">
                            <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTabelaImpVenda" name="txtTabelaImpVenda" class="form-control" placeholder="Tabela">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btn-TabelaImpVenda" name="btn-TabelaImpVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btn-limpa-TabelaImpVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                        <div class="col-sm-2" style="display: flex!important;align-items: flex-end!important;justify-content: flex-end!important;">
                          <button type="button" class="btn btn-primary btn-sisp float-right" id="btn-consulta-imp-vendas">Consultar</button>
                        </div>
                        <div class="col-sm-12 table-responsive" style="margin-top: 5px;">
                          <table style="width:100%" width="100%" id="tabelaImportarVendas" class="table table-sm table-select table-hover table-condensed mt-2">
                            <thead>
                            </thead>
                          </table>
                        </div>
                      </div>
                    </div>
                    <!-- <div class="modal-footer">
                      <div class="row">
                        <div class="col-sm-12">
                          <button type="button" id="btn_confirmar_venda_importada" class="btn btn-danger btn-sisp">Confirmar</button>
                        </div>
                      </div>
                    </div> -->
                  </div>

                  <div class="tab-pane fade" id="divImportarPedido" role="tabpanel" aria-labelledby="tabImpPedido">
                    <div class="col-12 col-sm-12 col-md-12">
                      <div class="row" style="margin-top: 11px;">

                        <div id="divTipoPedido" class="col-sm-auto mb-2 d-none mt-2">
                          <fieldset class="form border-Field mb-0 pb-0 d-flex" style="margin: 0px !important;">
                            <legend class="textoBorda mb-0 pb-0">Tipo de Pedido</legend>
                            <div class="icheck-primary"><input type="radio" id="radioImpPedidoTodos" name="radioImportacao" value="T"><label class="container" for="radioImpPedidoTodos">Todos</label></div>
                            <div class="icheck-primary"><input type="radio" checked id="radioImpPedidoPendentes" name="radioImportacao" value="P"><label class="container" for="radioImpPedidoPendentes">Somente Pendentes</label></div>
                            <div class="icheck-primary"><input type="radio" id="radioImpPedidoFaturados" name="radioImportacao" value="F"><label class="container" for="radioImpPedidoFaturados">Somente Faturados</label></div>
                          </fieldset>
                        </div>

                        <div class="col-sm-10">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtPedido">Pedido</label>
                          <div class="input-group">
                            <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtPedido" name="txtPedido" class="form-control" placeholder="Pedido">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btn-pedido" name="btn-pedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btn-limpa-pedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                        <div class="col-sm-2" style="display: flex!important;align-items: flex-end!important;justify-content: flex-end!important;">
                          <button type="button" class="btn btn-primary btn-sisp float-right" id="btn-consulta-imp-pedidos">Consultar</button>
                        </div>
                        <div class="col-sm-4 mt-2">
                          <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtBarraPedido">Barra</label>
                          <div class="input-group">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnTipo" type="button">
                                <i class="m-0 p-0 fas fa-plus" id="botaoTipo"></i>
                              </button>
                            </div>
                            <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtBarraPedido" name="txtBarraPedido" class="form-control" placeholder="Barra">
                          </div>
                        </div>
                        <div class="col-sm-12 table-responsive" style="margin-top: 5px;">
                          <table style="width:100%" width="100%" id="tabelaImportarPedidos" class="table table-sm table-select table-hover table-condensed mt-2">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="divImportarArquivo" role="tabpanel" aria-labelledby="tabImpArquivo">
                    <div class="form-row col-xl-12 col-12">
                      <div class="form-group col-4">
                        <label data-error="wrong" data-success="right" for="txtArquivoImportar">Arquivo </label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtArquivoImportar" name="txtArquivoImportar" placeholder="Arquivo" disabled>
                          <input type="file" id="mdModalUpload" class="d-none">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btnArquivoImportar" name="btnArquivoImportar" title="arquivo deve ser um .csv de barras únicas (barra_log)" type="file" for="txtArquivoImportar"><i class="m-0 p-0 fas fa-folder-plus"></i> </button>
                          </div>
                        </div>
                      </div>
                      <div class="form-group align-content-end col-2">
                        <button class="btn btn-primary w-100" style="max-width: 120px" id="btnCarregarImportarArquivo"> Ler Arquivo</button>
                      </div>
                      <div class="col-xl-12 col-12">
                        <h5 id="txtArquivoImportarTituloTabela" class="d-none">Itens Importação</h5>
                        <div class="table-responsive">
                          <table id="tabelaImportarArquivo" class="table table-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                      <div class="col-xl-12 col-12">
                        <h6 class="mt-2" id="txtBarrasNaoBipadas"></h6>
                      </div>
                      <div class="d-none">
                        <pre id="fileContent"></pre>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_venda_importada" class="btn btn-danger btn-sisp">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalNFCE" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalNFCE-titulo" class="modal-title">Converter Venda para NFC-e</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">

                  <div class="col-12">
                    <div class="group-default form-group">
                      <label data-error="wrong" data-success="right" for="txtClienteNFCE">Cliente</label>
                      <div class="input-group">
                        <input type="text" placeholder="Cliente" class="input-default" id="txtClienteNFCE" name="txtClienteNFCE" disabled>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnClienteNFCE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="group-default form-group">
                      <label data-error="wrong" data-success="right" for="txtCpfNFCE">CPF/CNPJ</label>
                      <input type="text" placeholder="CPF/CNPJ" class="input-default" id="txtCpfNFCE" name="txtCpfNFCE">
                    </div>
                  </div>
                  <div class="col-12">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNaturezaNFCE">Natureza</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNaturezaNFCE" name="txtNaturezaNFCE" class="form-control" placeholder="Natureza">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-NaturezaNFCE" name="btn-NaturezaNFCE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-NaturezaNFCE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-12" style="margin-top: 13px">
                    <label data-error="wrong" data-success="right" for="txtOperacaoNfce">Operação</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtOperacaoNfce" name="txtOperacaoNfce" placeholder="Operação">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnOperacaoNfce" name="btnOperacaoNfce" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnAOperacaoNfce" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-12" style="margin-top: 13px">
                    <div class="group-default form-group">
                      <label data-error="wrong" data-success="right" for="txtInfoAdicionaisNFCE">Informações
                        Adicionais</label>
                      <textarea type="textarea" style="resize: none" placeholder="Informações Adicionais" class="input-default focus form-control validate" id="txtInfoAdicionaisNFCE" name="txtInfoAdicionaisNFCE" required="required" rows="3"></textarea>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_nfce" class="btn btn-danger"> Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalNFE" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalNFCE-titulo" class="modal-title">Faturar Venda</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-12">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtClienteNFE">Cliente</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtClienteNFE" name="txtClienteNFE" class="form-control" placeholder="Cliente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-ClienteNFE" name="btn-ClienteNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-ClienteNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-12" style="margin-top: 2%">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNaturezaNFE">Natureza</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNaturezaNFE" name="txtNaturezaNFE" class="form-control" placeholder="Natureza">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-NaturezaNFE" name="btn-NaturezaNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-NaturezaNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-12" style="margin-top: 2%">
                    <label data-error="wrong" data-success="right" for="txtOperacaoNota">Operação</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtOperacaoNota" name="txtOperacaoNota" placeholder="Operação">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnOperacaoNota" name="btnOperacaoNota" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnAOperacaoNota" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_nfe" class="btn btn-danger"> Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalBrindeNFE" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="z-index: 2">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalBrindeNFE-titulo" class="modal-title">Faturar Brinde</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-12">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtClienteBrindeNFE">Cliente</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtClienteBrindeNFE" name="txtClienteBrindeNFE" class="form-control" placeholder="Cliente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-ClienteBrindeNFE" name="btn-ClienteBrindeNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-ClienteBrindeNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-12" style="margin-top: 2%">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNaturezaBrindeNFE">Natureza</label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNaturezaBrindeNFE" name="txtNaturezaBrindeNFE" class="form-control" placeholder="Natureza">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-NaturezaBrindeNFE" name="btn-NaturezaBrindeNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-NaturezaBrindeNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-12" style="margin-top: 2%">
                    <label data-error="wrong" data-success="right" for="txtOperacaoBrindeNFE">Operação</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtOperacaoBrindeNFE" name="txtOperacaoBrindeNFE" placeholder="Operação">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnOperacaoBrindeNFE" name="btnOperacaoBrindeNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnAOperacaoBrindeNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_brinde_nfe" class="btn btn-danger"> Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalCadPreco" style="z-index: 999999;" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalCadPreco-titulo" class="modal-title">Cadastrar Preço Manual</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="btnFecharPrecoManual">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-12">
                    <!-- <p>Item <span id="txtTituloPrecoManual"></span> sem preço cadastrado.</p> -->
                    <p><span id="txtTituloPrecoManual"></span></p>
                    <p>Informe o preço final do produto, sem desconto.</p>
                  </div>
                  <div class="col-12">
                    <input type="text" id="txtBarraPrecoManual" class="d-none" />
                    <input type="text" id="txtIdItemPrecoManual" class="d-none" />
                    <div class="group-default form-group">
                      <label data-error="wrong" data-success="right" for="txtPrecoManual">Novo Preço:</label>
                      <input type="number" min=0 placeholder="Preço" class="input-default" id="txtPrecoManual" name="txtPrecoManual">
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button type="button" id="btn_confirmar_preco" class="btn btn-danger"> Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div id="modal-POSTEF" class="modal" data-backdrop="static" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 id="myModalLabel" class="modal-title">Envio Pagamento de POS/TEF MF-e</h5>
                <!-- <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button> -->
              </div>
              <div class="modal-body">
                <fieldset>
                  <div class="card">
                    <div class="card-body">
                      <div class="col-sm-12 table-responsive card-body">
                        <table id="tabelaPOSTEF" class="table table-sm table-select table-hover" width="100%"></table>
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </div>
                    </div>
                  </div>
                </fieldset>
              </div>
              <div class="modal-footer">
                <button class="btn btn-primary btn-sisp" id="btnEnviaPagamento">Enviar Pagamento</button>
                <button class="btn btn-success btn-sisp" id="btnConfirmaPagamento">Confirma Pagamento</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalTroco" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Troco</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Valor da Venda: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default" id="txtValorVendaTroco" placeholder="Valor da Venda" disabled>
                  </div>
                </div>
                <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Valor Pago: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default" id="txtValorPagoVendaTroco" placeholder="Valor Pago" disabled>
                  </div>
                </div>
                <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Valor a Pagar: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default" id="txtValorPagarTroco" placeholder="Valor a Pagar" disabled>
                  </div>
                </div>
                <hr>
                <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Valor Pago: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default focus" id="txtValorPagoTroco" placeholder="Valor Pago">
                  </div>
                </div>
                <div class="row">
                  <label for="colFormLabelLg" class="col-sm-6 col-form-label textTroco">Troco: </label>
                  <div class="col-sm-6">
                    <input type="number" class="form-control input-default" id="txtTroco" placeholder="Troco" disabled>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" id="btnConfirmarTroco" class="btn btn-primary focus">Confirmar</button>
                <button type="button" id="btnConfirmarTrocoNfce" class="btn btn-primary d-none focus">Confirmar</button>
                <button type="button" id="btnConfirmarTrocoNfe" class="btn btn-primary d-none focus">Confirmar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalQuantidade" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Alterar Quantidade</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">

                <div class="row">
                  <div class="col-sm-4">
                    <label for="txtItemQuantidadeAtual" class="col-sm-12">Quantidade Atual: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="txtItemQuantidadeAtual" placeholder="Quantidade do Item" disabled>
                    </div>
                  </div>
                  <div class="col-sm-4">
                    <label for="txtItemQuantidade" min="0" class="col-sm-12">Quantidade Nova: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="txtItemQuantidade" value="0" placeholder="Quantidade do Item">
                    </div>
                  </div>
                  <div class="col-sm-4">
                    <label for="txtItemQuantidadeDiferenca" class="col-sm-12">Quantidade Dif: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="txtItemQuantidadeDiferenca" placeholder="Quantidade do Item" disabled>
                    </div>
                  </div>
                  <input type="text" class="form-control input-default d-none" id="txtBarraQuantidadeNova" placeholder="barra">
                  <input type="text" class="form-control input-default d-none" id="txtDepositoQuantidadeNova" placeholder="deposito">
                  <input type="text" class="form-control input-default d-none" id="txtCodigoAlteraQuantidade" placeholder="codigo">
                  <input type="text" class="form-control input-default d-none" id="txtIdLinhaItemQuantidade" placeholder="linha">
                </div>

                <div class="col-sm-12">
                  <div class="row">
                    <label for="txtItemCodQuantidade" class="col-sm-12">Item: </label>
                    <div class="col-sm-12">
                      <input type="text" class="form-control input-default" id="txtItemCodQuantidade" placeholder="Código" disabled>
                    </div>
                  </div>
                </div>

              </div>
              <div class="modal-footer">
                <button type="button" id="btnConfirmarQuantidades" class="btn btn-primary">Confirmar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalObservacaoItem" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Observação Item - [<span id="txtTituloObservacaoItem"></span>]</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <div class="col-sm-12">
                  <div class="row">
                    <label for="txtObservacaoItem" class="col-sm-12">Observação: </label>
                    <div class="col-sm-12">
                      <textarea id="txtObservacaoItem" style="resize: none;" class="autoExpand forumPost form-control" rows="3" placeholder="Observação"></textarea>
                    </div>
                  </div>
                </div>
                <input type="text" class="form-control input-default d-none" id="txtIdLinha">
              </div>
              <div class="modal-footer">
                <button type="button" id="btnConfirmarObservacaoItem" class="btn btn-primary">Confirmar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalItemPreco" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Alterar Preço</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">

                <div class="row">
                  <div class="col-sm-6">
                    <label for="txtItemPrecoAtual" class="col-sm-12">Preço Atual: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="txtItemPrecoAtual" placeholder="Preço Atual" disabled>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <label for="txtItemPrecoNovo" class="col-sm-12">Preço Novo: </label>
                    <div class="col-sm-12">
                      <input type="number" class="form-control input-default" id="txtItemPrecoNovo" value="0" placeholder="Preço Novo">
                    </div>
                  </div>
                  <input type="text" class="form-control input-default d-none" id="txtIdLinhaItemPreco" placeholder="linha">
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" id="btnConfirmarItemPreco" class="btn btn-primary">Confirmar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalAntecipacoes" data-backdrop="static" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Selecionar Antecipação</h5>
                <button id="closeModalAntecipacoes" type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
              </div>
              <div class="modal-body">
                <div class="card">
                  <div class="card-body">
                    <div class="row d-none">
                      <div class="col-12" style="display: flex; justify-content: flex-end">
                        <p id="txtValorAntecipacao" style="color: red; font-size: 25px; font-weight: 600;"></p>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-12 table-responsive">
                        <table style="width:100%" width="100%" id="tabelaAntecipacoesSelecionadas" class="table table-responsive-sm table-select table-hover">
                          <thead>
                            <tr>
                              <th class="th-sm">Sel</th>
                              <th class="th-sm">Duplicata</th>
                              <th class="th-sm">Emissão</th>
                              <th class="th-sm">Vencimento</th>
                              <th class="th-sm">Valor</th>
                              <th class="th-sm">Val. Pago</th>
                              <th class="th-sm">Venda</th>
                              <th class="th-sm">Val. Utilizado</th>
                              <th class="th-sm emp_ID">Emp_ID</th>
                              <th class="th-sm">Status</th>
                              <th class="th-sm"></th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" id="btnConfirmarAntecipacao" class="btn btn-primary">Confirmar</button>
              </div>
            </div>
          </div>
        </div>

        <div class="modal" id="modalConsultaEstoque" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modalConsultaEstoque-titulo" class="modal-title">Consultar Estoque das Lojas</h4>
                <div class="mt-2">
                  <label style="font-size: 120%" class="container escondeRadio">Produto 
                    <input type="radio" checked="checked" id="radioProdutoC" name="tipoConsulta">
                    <span class="checkmark"></span>
                  </label>
                  <label style="font-size: 120%; margin-left: -2.5%" class="container escondeRadio">Material 
                    <input type="radio" id="radioMaterialC" name="tipoConsulta">
                    <span class="checkmark"></span>
                  </label>
                </div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>

              <div class="modal-body">
                <div class="card">
                  <div class="card-body">
                    <div class="row">
                      <div class="col-6">
                        <label data-error="wrong" data-success="right" for="txtDepositoConsultaEstoque">Depósito</label>
                        <div class="input-group">
                          <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtDepositoConsultaEstoque" name="txtDepositoConsultaEstoque" class="form-control" placeholder="Deposito">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-DepositoConsultaEstoque" name="btn-DepositoConsultaEstoque" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-DepositoConsultaEstoque" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                      <div class="col-6">
                        <label data-error="wrong" data-success="right" id="labelProduto" for="txtProdutoConsultaEstoque">Produto</label>
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtProdutoConsultaEstoque" name="txtProdutoConsultaEstoque" class="form-control" placeholder="Produto">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ProdutoConsultaEstoque" name="btn-ProdutoConsultaEstoque" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ProdutoConsultaEstoque" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-sm-12 d-flex align-items-center justify-content-end" style="margin-top: 15px">
                        <button type="button" id="btnConsultarEstoque" class="btn btn-danger"> Consultar</button>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-12 table-responsive">
                        <table id="tabelaProdutosConsultaEstoque" style="width:100%; margin-top: 20px" width="100%" class="table table-sm table-select table-hover">
                          <thead>
                            <tr>
                            </tr>
                          </thead>
                          <tbody></tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalCamera" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
                <div id="camera">
                  <h1>Leitor Código de Barras</h1>
                  <div>
                    <div data-barcode-canvas class="barcode-canvas" id="cam"></div>
                    <div data-barcode-msg class="barcode-message"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalFiltrosAdicionaisInvisiveis" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Filtros Adicionais Invisíveis - Material</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-sm-12" id="conteudoFiltrosAdicionaisInvisiveis">
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <div class="col-sm-12">
                    <button id="btnConfirmarFiltrosAdicionaisInvisiveis" class="btn btn-danger">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>


        <div class="modal fade" id="modalCampanhasCRMBonus" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Campanhas - CRM&Bônus</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="btnFecharCampanhasCRMBonus">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-lg-6 col-sm-6" style="margin-top: 2%;">
                    <label data-error="wrong" data-success="right" id="lblClienteCampanhasCRMBonus">Cliente: </label>
                    <br>
                    <label data-error="wrong" data-success="right" id="lblEmailCampanhasCRMBonus">E-mail: </label>
                    <br>
                    <label data-error="wrong" data-success="right" id="lblDataNascimentoCampanhasCRMBonus">Data de Nascimento: </label>
                    <br>
                  </div>
                  <div class="col-lg-6 col-sm-6" style="margin-top: 2%;">
                    <label data-error="wrong" data-success="right" id="lblValorCampanhasCRMBonus">Valor: </label>
                    <br>
                    <label data-error="wrong" data-success="right" id="lblCelularCampanhasCRMBonus">Celular: </label>
                    <br>
                  </div>
                  <div class="col-lg-12 col-sm-12" style="margin-top: 2%;">
                    <table style="width:100%" width="100%" id="tabelaCampanhasCRMBonus" class="table table-sm table-select table-hover">
                      <thead>
                        <tr>
                          <th class="th-sm">ID</th>
                          <th class="th-sm">Descrição</th>
                        </tr>
                      </thead>
                      <tbody></tbody>
                    </table>
                  </div>
                </div>
              </div>
              <div class="modal-footer" id="modalFooterCampanhasCRMBonus">
                <div class="row">
                  <div class="col-sm-12">
                    <button id="btnConfirmarCampanhasCRMBonus" class="btn btn-danger">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="modal fade" id="modalReconhecimentoFacialRepresentante" tabindex="-1" role="dialog"
          aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
          <div class="modal-dialog" style="min-width: 850px">
            <div class="modal-content">
              <div class="modal-header" style="border: none !important;">
                <h3 class="modal-title ml-1">Reconhecimento Facial</h3>
              </div>
              <div class="modal-body d-flex align-items-center justify-content-center" style="flex-direction: column;">

                <div style="min-height:350px !important;">
                  <div class="video-wrap ml-auto mr-auto">
                    <video id="videoRepresentante" width="800" height="600" playsinline autoplay>
                      <source src="seu_video.mp4" type="video/mp4">
                    </video>
                    <canvas id="canvasRepresentante" class="d-none" width="800" height="600"></canvas>
                    <div class="flex justify-content-between">
                      <div>
                        <button type="button" class="btn btnVerde btn-sisp d-none" id="btnConfirmarReconhecimentoFacialRepresentante"><i class="fas fa-save"></i> Confirmar</button>
                        <button class="btn btn-secondary foto-button d-none" id="btnTentarNovamenteRepresentante"><i
                        class="m-0 p-0 fas fa-plus foto-icon"></i></button>
                        <button class="btn btn-secondary foto-button" id="btnTiraFotoRepresentante"><i
                        class="m-0 p-0 fas fa-camera foto-icon"></i></button>
                      </div>
                      <div>
                        <button type="button" class="btn btn-danger btn-sisp" id="btnCancelarReconhecimentoFacialRepresentante">Cancelar</button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
      <footer class="footerVenda">
        <div class="row text-center">
          <div class="col-12">
            <div class="btn-group flex-wrap btn-group-justified btn-group-lg mb-5" role="group" aria-label="Basic example">
              <button type="button" id="btnCancelarVenda" class="botoesMenu btn btn-secondary">Cancelar</button>
              <button type="button" id="btnInfo" class="botoesMenu btn btn-secondary">Informações (F5)</button>
              <button type="button" id="btnVenda" class="botoesMenu btn btn-secondary">Itens (F6)</button>
              <button type="button" id="btnPagamento" class="botoesMenu btn btn-secondary">Pagamento (F7)</button>
              <button type="button" id="btnFinalizar" class="botoesMenu divFinalizar btn btn-secondary ultimoBotao" data-original="Deixar Pendente (F8)">Deixar Pendente (F8)</button>
              <button type="button" id="btnCFe" class="botoesMenu divCFE btn btn-secondary d-none">CF-e SAT (F9)</button>
              <button type="button" id="btnNFCE" class="botoesMenu divNFCE btn btn-secondary d-none">NFC-e (F9)</button>
              <button type="button" id="btnNFE" class="botoesMenu divNFE btn btn-secondary d-none">NF-e</button>
            </div>
          </div>
        </div>
      </footer>
  </main>

  <input type="text" class="d-none" id="somaDescontoTotalVenda"></input>
  <input type="text" class="d-none" id="somaValorTotalVenda"></input>

  <script src="<?php echo BASE_URI; ?>/plugins/jquery/jquery.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/sisplan.js?versao=3.2510.7.1"></script>

  <?php
  include_once('../../menu_fiscal.php');
  include_once('modais/modal_cupom_troca.php');
  include_once('modais/modal_conferencia.php');
  include_once('modais/modal_cfe.php');
  include_once('../../modais.php');
  include_once('../../modals/modal_estatisticas_entidade.html');
  include_once('modais/modal_cliente.php');
  include_once('../../modals/modal_consulta_receita.html');
  include_once('../../modals/modal_receberabertos.html');
  include_once('modais/modal_cep.php');
  include_once('modais/modal_crmbonus.php');
  include_once('modais/modal_solicita_limite_credito.php');
  include_once('../../modals/modal_pix.php');
  include_once('../../modals/modal_ocorrencias.html');
  include_once('modais/modal_brinde.php');
  ?>

  <script>
    ipInterno = '<?php echo IP_INTERNO; ?>';
    ipExterno = '<?php echo IP_EXTERNO; ?>';
    basicAuth = '<?php echo BASIC_AUTH; ?>';
  </script>
  <script src="<?php echo BASE_URI; ?>/dist/js/highlight.min.js?versao=3.2510.7.1"></script>
  <script src="https://unpkg.com/phosphor-icons"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/jquery.dataTables.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/dataTables.bootstrap4.min.js?versao=3.2510.7.1">
  </script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/loadingoverlay.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/valida_cpf_cnpj.js?versao=3.2510.7.1"></script>

  <!-- jQuery UI 1.11.4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-ui/jquery-ui.min.js?versao=3.2510.7.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>
  <!-- Bootstrap 4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2510.7.1"></script>
  <!-- AdminLTE App -->
  <script src="<?php echo BASE_URI; ?>/dist/js/adminlte.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/adminltemenu.js?versao=3.2510.7.1"></script>

  <script src="<?php echo BASE_URI; ?>/dist/js/dataTables.keyTable.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/utils/funcoes.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/pages/loja/js/rotinas.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/utils/epc.js?versao=3.2510.7.1"></script>

  <!-- SweetAlert2 -->
  <script src="<?php echo BASE_URI; ?>/plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/sweetalert2/sweetalert2.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.js?versao=3.2510.7.1"></script>
  <!-- jquery-validation -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-validation/jquery.validate.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-validation/additional-methods.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/requisicoes.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/sum().js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/utils/cookies.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.maskMoney.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/driver.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.mask.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/select2/js/select2.full.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/owl/owl.carousel.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/moment/moment.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/pages/cfe/cfe.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.inputmask.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/config.js?versao=3.2510.7.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/datadog-logs-v4.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/modals/modal_estatisticas_entidade.js"></script>
  <script src="<?php echo BASE_URI; ?>/modals/modal_ocorrencias.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/modals/modal_receberabertos.js"></script>
  <script src="<?php echo BASE_URI; ?>/modals/modal_consulta_receita.js"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/quagga.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/instascan.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/qrious.min.js?versao=3.2510.7.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/dataTables.fixedColumns.min.js"></script>
  <script>
    let enviarLogs = true;
    try {
      enviarLogs = ENVIAR_LOGS;
    } catch (error) {
      enviarLogs = true;
    }

    if (enviarLogs) {
      window.DD_LOGS &&
        DD_LOGS.init({
          clientToken: 'pub22c993c7a1e62229227b490bbdc2613f',
          forwardErrorsToLogs: true,
          sampleRate: 100,
          beforeSend: (log) => {
            if (log.http && log.http.status_code === 0) {
              return false;
            }
            log.usuario = {
              usuario: getCookie('usuario') ?? '',
              empresa: sessionStorage.getItem('g_nome_empresa_logada') ?? '',
              ipExterno: '<?php echo IP_EXTERNO; ?>',
              versao: VERSAO,
            }
          },
        })
    }
  </script>

  <script>
    // $('#rodape').addClass('d-none');
    $(document).ready(async function() {
      let bCashBack = false;
      if (!parent.document.querySelector('body').classList.contains('iframe-mode-fullscreen')) {
        parent.$('#abrirTelaCheia').trigger('click');
      }

      await insereJavaScriptTraducoes()
      preencheOrdenacaoTela('AcessoBrinde');

      let ativaBuscaFotosProdMat = false;
      let tabelaItensCupomDesc;
      let tabelaOld = '';
      let condicaoPagto = '';
      let g_CreditoCliente = 0;
      let g_ValorAbertoCliente = 0;
      var idIntervalSolicitacaoEstoque = -1;
      let bDblclickModalProduto = false;
      var parametrosVenda = await BuscaParametrosVenda();
      const bParametroAntecipacaoOutrasEmpresas = parametrosVenda[62] == 1 ?? false;
      const parametroValorIPIVenda = parametrosVenda[102] == 1 ?? false;
      const parametroValorRetIva = parametrosVenda[105] == 1 ?? false;
      let bloqueiaSaida = false;
      const array_cartao_presente = [];
      let itensBipadosEPC = []


      if (parametroValorIPIVenda) {
        $("#rowIPI").removeClass("d-none");
      }

      const empresaTrabalhaComFotoCor = await retornaEmpresaTrabalhaComFotoCor();
      if (empresaTrabalhaComFotoCor) {
        $('#infoprodcorimagem').removeClass('d-none');
        $('#labelfotos').html('Fotos');
      }
      const sDepositoEcommerce = parametrosVenda[94];
      if (sDepositoEcommerce != '') {
        $('#checkDepEcommerce').removeClass('d-none');
      }

      if (parametrosVenda[87] == 1) {
        await deletaReservaProduto();
      }

      if (parametrosVenda[5] == 1) {
        $('#divRgPrazo').addClass('d-none');
        $('#divRgPrazoPrecos').addClass('d-none');
        $('#btn-limpa-tabela').removeClass('prazo');
        // document.querySelector("#labelTabela").innerHTML = `Tabela`;
      } else {
        $('#divRgPrazo').removeClass('d-none');
        $('#divRgPrazoPrecos').removeClass('d-none');
        $('#btn-limpa-tabela').addClass('prazo');
        // document.querySelector("#labelTabela").innerHTML = `Tabela / Prazo`;
      }
      if (parametrosVenda[58] == '5') {
        $('#txtPagamentosTotais').html(await traduzSentenca('Total antecipação:'));
        $('#txtTotalTotais').html(await traduzSentenca('Total à pagar:'));
      }
      var parametrosSistema = await BuscaParametrosSistema('S');
      let quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
      const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
      let fechaF10 = false;
      let fechaCFe = ((parametrosVenda[18] == 1) || (parametrosVenda[18] == 3) || (parametrosVenda[18] == 5) || (parametrosVenda[18] == 6));
      let infoTipoVenda = [];
      let tempoSegundosPix = 300;
      let importaPedido = false;
      let cameraVenda = true;
      let epcVenda = true;
      let bInformacoesCliente = false;
      let bSemDescontoItensPromocionais = false;
      let infoClienteCRMBonus = {};
      let infoCRMBonus = {};
      let bConsultandoProduto = false;
      let todasColunasPesquisaProduto = '';

      async function permissoesTela() {
        $.LoadingOverlay('show')
        try {
            let response = await requisicao("GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"PERMISSOES_TELA",
                        "camposSelect":["PERMISSAO", "ACAO"], 
                        "where": ["USUARIO = '${getCookie("cod_usuario")}' AND EMP_ID = ${getCookie("emp_id")} AND TELA = 'LOJA' AND ACAO = 'ALTERAR_CHECK_DESCONTO_MASSA'"]}`,
                null);

            if (!response || response.status != 200) {
                return;
            }
            let jsonStr = await response.json();

            if (jsonStr.RESULT[0].length > 0) {
                jsonStr.RESULT[0].map(item => {
                    switch (item.ACAO) {
                        case 'ALTERAR_CHECK_DESCONTO_MASSA':
                            $("#cbSemDescontoItensPromocionais").prop("disabled", item.PERMISSAO == "N");
                            break;
                        default:
                            break;
                    }
                })
            }
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }
      await permissoesTela();
      const bloqueiaAbasInfosEItensVenda = parametrosVenda[80] == "1";
      const controleLimiteCredito = await CopiaParametro('ENTIDADE', 4);
      const imageCache = {};

      let listaPesquisaItens = [];
      let ativaBuscaFotosMat = false;
      let ultimoValorConsultado = '';
      let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

      if (colunas == null || colunas.vendaMaterial == undefined) {
        localStorage.setItem("colunasInvisiveisRelatorios", JSON.stringify({
          ...colunas,
          vendaMaterial: []
        }));
        colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
      }

      if (colunas == null || colunas.estoquePreco == undefined) {
        localStorage.setItem("colunasInvisiveisRelatorios", JSON.stringify({
          ...colunas,
          estoquePreco: []
        }));
        colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
      }

      let produtoRelacionado;
      if (controleLimiteCredito == '1') {
        let label = $("label[for='txtLimiteCreditoConsignado']");
        label.text('Limite Crédito Consignado');

        label = $("label[for='txtLimiteCreditoCli']");
        label.text('Limite Crédito Venda');
      }
      await carregaValoresPadroes();
      await verificaSolicitacaoEstoque();
      // $('#txtDiaVencimento').on('keypress', function(event) {
      //   var regex = new RegExp("^[0-9]+$");
      //   var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
      //   if (!regex.test(key)) {
      //     event.preventDefault();
      //     return false;
      //   }
      // });

      $("#txtPercDescontoMoeda").inputmask("numeric", {
        min: 0,
        max: 99,
        positionCaretOnClick: "select"
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });


      $("#txtSolicitaLimiteValor").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select"
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $("#txtValorDescontoMoeda").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select",
        digits: 2
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $("#txtPercDescontoSimulacao").inputmask("numeric", {
        min: 0,
        max: 99,
        positionCaretOnClick: "select"
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $("#txtValorDescontoSimulacao").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select",
        digits: 2
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });
      $("#txtValorAUtilizarCashback").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select",
        digits: 2
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      }).on("blur", function() {
        const saldoAPagar = +$('#txtSaldoAPagarCashback').val();
        const valorMaximoASerUsado = saldoAPagar - 0.01;

        const valorAUtilizar = cashbackCliente.valor < saldoAPagar ? cashbackCliente.valor :
          valorMaximoASerUsado;


        const pontosPorValor = ArredondarValor(cashbackCliente.pontos / cashbackCliente.valor, 2);
        const pontosMaximosASeremUsados = valorMaximoASerUsado * pontosPorValor;
        const pontosAUtilizar = cashbackCliente.valor < saldoAPagar ? cashbackCliente.pontos :
          pontosMaximosASeremUsados;

        const valorAtual = +$(this).val();
        const pontosAtuais = valorAtual * pontosPorValor;
        // const valorUtilizavel = +$('#txtValorDisponivelCashback').val();
        const valorCashBack = (
            (parametrosVenda[72] == '3') &&
            (+((parseFloat($('#txtTotItensSemDesc').val()) / 100) * parseFloat(cashbackCliente.perc_max)).toFixed(2) <= +$('#txtValorDisponivelCashback').val())
          ) ?
          +((parseFloat($('#txtTotItensSemDesc').val()) / 100) * parseFloat(cashbackCliente.perc_max)).toFixed(2) :
          +$('#txtValorDisponivelCashback').val()
        const valorUtilizavel = valorCashBack < saldoAPagar ? valorCashBack : valorMaximoASerUsado;

        if (+valorAtual > +valorUtilizavel) {
          msgAlerta('Valor de cashback informado maior que o disponível para o cliente.');
          $(this).val((valorUtilizavel).toFixed(2));
          return;
        }
        if (valorUtilizavel > valorAUtilizar) {
          msgAlerta('Valor de cashback informado maior que o desconto máximo de 99.99%.');
          $(this).val((valorUtilizavel).toFixed(2));
          return;
        }

        $('#txtSaldoCashback').val((saldoAPagar - valorAtual).toFixed(2));

      });

      $("#txt_val_ent").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select",
        digits: 2
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $("#txtPercAcrescMoeda").inputmask("numeric", {
        min: 0,
        max: 99,
        positionCaretOnClick: "select"
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $("#txtValorAcrescMoeda").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select",
        digits: 2
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $("#txtFrete").inputmask("numeric", {
        min: 0,
        positionCaretOnClick: "select",
        digits: 2
      }).on("focus", function() {
        var that = $(this);
        setTimeout(function() {
          that.select();
        }, 1)
      });

      $('#txtQuantid')
        .on("focus", function() {
          let that = $(this);
          setTimeout(function() {
            that.select();
          }, 1)
        }).on('keydown', function(e) {
          if ((e.key == 'Tab') || (e.key == 'Enter')) {
            e.preventDefault();
            $('#txtCodigo').focus();
            $('#txtCodigo').click();
          }
        });

      $('#txtDesconto').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
      });

      $('#txtPercDescontoRateado').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
      });

      $('#txtValDesconto').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
      });

      $('#txtValDescontoRateado').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
      });

      $('#txtDesconto').on("blur", async function() {
        const bSemDescontoItensPromocionais = $("#cbSemDescontoItensPromocionais").prop("checked");
        const valorTotal = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[7]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(7, {}).data().sum()).toFixed(2));
        if ($(this).val() == "") {
          $(this).val("0.00");
          if (!verificaExisteDescontoEmMassa()) {
            $("#txtValorTotal").val(valorTotal);
          }
        } else {
          $("#txtValDesconto").val("0.00");
          $("#txtPercDescontoRateado").val("0.00");
          $("#txtValDescontoRateado").val("0.00");
          let valorDesconto = 0;
          let soma = 0;
          let somaPreco = 0;
          const percDesconto = parseFloat($(this).val());
          const tabelaItens = $("#tabelaItens").DataTable().data().toArray();

          for (const item of tabelaItens) {
            if ((!bSemDescontoItensPromocionais) || (item[6] == 0 && !item[29])) {
              const valor = item[3];
              const soma = parseFloat(valor) - (parseFloat(valor) * percDesconto) / 100;
              valorDesconto += TruncaDecimaisNova(2, (valor - soma) * item[2]);
            }
          }
          const valorCalculado = parseFloat((valorTotal - valorDesconto).toFixed(2));
          $("#txtValorTotal").val(valorCalculado);

          // $("#txtValDesconto").val("0.00");
          // $("#txtPercDescontoRateado").val("0.00");
          // $("#txtValDescontoRateado").val("0.00");

          // const percentualDesconto = parseFloat($(this).val());
          // const percentualDescontoDecimal = parseFloat(percentualDesconto / 100);
          // const valorDesconto = parseFloat((valorTotal * percentualDescontoDecimal).toFixed(2));
          // const valorCalculado = parseFloat((valorTotal - valorDesconto).toFixed(2));
          // $("#txtValorTotal").val(valorCalculado);
        }
      })

      $('#txtPercDescontoRateado').on("blur", function() {
        const bSemDescontoItensPromocionais = $("#cbSemDescontoItensPromocionais").prop("checked");
        const valorTotal = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[7]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(7, {}).data().sum()).toFixed(2));

        const quantidadeItens = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[2]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(2, {}).data().sum()).toFixed(2));

        if ($(this).val() == "") {
          $(this).val("0.00");
          if (!verificaExisteDescontoEmMassa()) {
            $("#txtValorTotal").val(valorTotal);
          }
        } else {
          $("#txtDesconto").val("0.00");
          $("#txtValDesconto").val("0.00");
          $("#txtValDescontoRateado").val("0.00");

          const percentualDesconto = parseFloat($(this).val());
          const percentualDescontoRateado = parseFloat((percentualDesconto / quantidadeItens).toFixed(2));
          const percentualDescontoDecimal = parseFloat(percentualDescontoRateado / 100);
          const valorDesconto = TruncaDecimaisNova(2, valorTotal * percentualDescontoDecimal)
          const valorCalculado = parseFloat((valorTotal - valorDesconto).toFixed(2));
          $("#txtValorTotal").val(valorCalculado);
        }
      })

      $('#txtValDesconto').on("blur", function() {
        const bSemDescontoItensPromocionais = $("#cbSemDescontoItensPromocionais").prop("checked");
        const valorTotal = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[7]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(7, {}).data().sum()).toFixed(2));

        const quantidadeItens = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[2]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(2, {}).data().sum()).toFixed(2));

        if ($(this).val() == "") {
          $(this).val("0.00");
          if (!verificaExisteDescontoEmMassa()) {
            $("#txtValorTotal").val(valorTotal);
          }
        } else {
          $("#txtDesconto").val("0.00");
          $("#txtPercDescontoRateado").val("0.00");
          $("#txtValDescontoRateado").val("0.00");

          const valorDesconto = parseFloat($(this).val());
          const valorDescontoTotal = parseFloat((valorDesconto * quantidadeItens).toFixed(2));
          const valorCalculado = parseFloat((valorTotal - valorDescontoTotal).toFixed(2));
          $("#txtValorTotal").val(valorCalculado);
        }
      })

      $('#txtValDescontoRateado').on("blur", function() {
        const bSemDescontoItensPromocionais = $("#cbSemDescontoItensPromocionais").prop("checked");
        const valorTotal = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[7]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(7, {}).data().sum()).toFixed(2));
        if ($(this).val() == "") {
          $(this).val("0.00");
          if (!verificaExisteDescontoEmMassa()) {
            $("#txtValorTotal").val(valorTotal);
          }
        } else {
          $("#txtDesconto").val("0.00");
          $("#txtValDesconto").val("0.00");
          $("#txtPercDescontoRateado").val("0.00");

          const valorDesconto = parseFloat($(this).val());
          const valorCalculado = parseFloat((valorTotal - valorDesconto).toFixed(2));
          $("#txtValorTotal").val(valorCalculado);
        }
      })

      $("#cbSemDescontoItensPromocionais").on("change", function() {
        const bSemDescontoItensPromocionais = $(this).prop("checked");
        const total = bSemDescontoItensPromocionais ? parseFloat($("#tabelaItens").DataTable().data().filter(item => item[6] == 0).filter(item => !item[29]).map(item => item[7]).sum().toFixed(2)) :
          parseFloat(($("#tabelaItens").DataTable().column(7, {}).data().sum()).toFixed(2));
        $("#txtValorTotal").val(total);
      })

      function verificaExisteDescontoEmMassa() {
        const campos = $(".desconto-em-massa").toArray();

        return campos.filter(campo => $(campo).val() != "0.00").length > 0;
      }

      $('input[type="radio"][name="radioImportacao"]').change(function() {
        if ($.fn.DataTable.isDataTable("#tabelaImportarPedidos")) {
          $('#tabelaImportarPedidos').DataTable().clear().draw(false);
        }
      });

      if (parametrosVenda[17] != 1) {
        $('#txtQuantid').val('1');
      }
      $('#lblQuantid').tooltip();
      $('#select_bandeira').removeClass('focus');
      $('#txtNSU').removeClass('focus');
      $("#txtAutorizacao").removeClass("focus");

      $('.owl-carousel').owlCarousel({
        loop: true,
        margin: 10,
        responsiveClass: true,
        stagePadding: 30,
        smartSpeed: 450,
        responsive: {
          0: {
            items: 1,
            nav: true
          },
          400: {
            items: 4,
            nav: false
          },
          600: {
            items: 6,
            nav: false
          },
          1000: {
            items: 6,
            nav: true,
            loop: false
          }
        }
      });

      const temAcesso = await temAcessoTela('LOJA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, '<?php echo BASE_URI; ?>');
        return;
      }

      let options = {
        onKeyPress(cpf, ev, el, op) {
          let masks = ["000.000.000-000", "00.000.000/0000-00"];
          $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
          $('#txtCpfNFCE').mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
      };

      // if ($("#txtCNPJ").length > 11) {
      //   $("#txtCNPJ").mask("00.000.000/0000-00", options);
      // } else {
      //   $("#txtCNPJ").mask("000.000.000-00#", options);
      // }

      if ($("#txtCpfNFCE").length > 11) {
        $("#txtCpfNFCE").mask("00.000.000/0000-00", options);
      } else {
        $("#txtCpfNFCE").mask("000.000.000-00#", options);
      }
      var UsuarioPodeGravarCondicoes = await verificaUsuarioPodeGravarCondicoes();
      var utilizaImpressoraFiscal = parametrosVenda[8] == '1';
      var vendaOriginadaDeAgrupamento = false;

      const prioridadeProdutoMaterial = parametrosVenda[17] ?? '0';
      if (prioridadeProdutoMaterial == '0') { // produto
        $('#radioProduto').prop('checked', true);
        $('#radioProdutoPreco').prop('checked', true);
        $('#radioProdutoPreco').trigger('change');
        $('#btn-imprimir-malha').addClass('d-none');
        $('#btn-desdobrar-malha').addClass('d-none');
        $('#total_rolos_itens').addClass('d-none');
        $('.legenda-material').addClass('d-none');
        $('.legenda-material').removeClass('d-flex');
        $('.divGeralMaterial').addClass('d-none')
        $('#divBarraPreco').removeClass('col-6').addClass('col-12')
        $('#divFlagsPreco').addClass('d-none')
      } else {
        $('#radioMaterial').prop('checked', true);
        $('#radioMaterialPreco').prop('checked', true);
        $('#radioProdutoPreco').trigger('change');
        $('#btn-imprimir-malha').removeClass('d-none');
        $('#btn-desdobrar-malha').removeClass('d-none');
        $('#total_rolos_itens').removeClass('d-none');
        $('.legenda-material').removeClass('d-none');
        $('.legenda-material').addClass('d-flex');
        $('.divGeralMaterial').removeClass('d-none')
        $('#divBarraPreco').removeClass('col-12').addClass('col-6')
        $('#divFlagsPreco').removeClass('d-none')
      }

      if (parametrosVenda[29] == 1) {
        $('#regraPromocaoInfoTour').removeClass('d-none');
        $('#txtRegraPromocao').removeClass('d-none');
      } else {
        $('#regraPromocaoInfoTour').addClass('d-none');
        $('#txtRegraPromocao').addClass('d-none');
      }

      verificaSeTemIdNaMaquina();
      const idMaquina = 'JsonVenda-' + getCookie('idMaquina');

      const descontoTotalUsuario = await retornaDescontoMaximoUsuario();
      const bUsaIntegraçãoITAG = parametrosVenda[60] == 1 || parametrosVenda[60] == 2;
      const integracaoEPC = parametrosVenda[60];
      const bCampoQtdeVisivel = parametrosVenda[21] == 1;
      const campoQtdeVisivel2 = parametrosVenda[21] == 2;
      const campoQualidadeVisivel = parametrosVenda[41] == 1;
      if (bCampoQtdeVisivel || campoQtdeVisivel2) {
        $('#divQuantid').removeClass('d-none');
        $('#txtQuantid').removeClass('d-none');
        if (campoQualidadeVisivel) {
          $('#divQualidade').removeClass('d-none');
          $('#divBarra').removeClass('col-sm-11').addClass('col-sm-5');
          $('#divBarra').removeClass('col-11').addClass('col-12');
        } else {
          $('#divBarra').removeClass('col-sm-11').addClass('col-sm-8');
          $('#divBarra').removeClass('col-11').addClass('col-12');
        }
      } else {
        if (!$('#divQuantid').hasClass('d-none')) {
          $('#divQuantid').addClass('d-none');
          $('#txtQuantid').addClass('d-none');
        }
        if (campoQualidadeVisivel) {
          $('#divQualidade').removeClass('d-none');
          $('#divBarra').removeClass('col-sm-11').addClass('col-sm-8');
          $('#divBarra').removeClass('col-11').addClass('col-12');
        }
      }

      bUsaIntegraçãoITAG ? $('.divRFID').removeClass('d-none') : $('.divRFID').addClass('d-none');

      // EPC
      const epc = new EPC({
        barra: '#txtCodigo',
        quantidade: '#txtQuantid',
        deposito: '#txtDeposito',
        codigoEPC: '#txtCodigoEPC',
        idItem: '#txtIdItem',
        integracaoEPC: integracaoEPC,
        listaBarrasBipadasEPC: listaBarrasBipadasEPC,
        buttonEstorna: '#btnMenosOuMais',
        callBackSaidaBarra: async () => {
          console.log('[EPC] Tentando executar RotinaSaidaCodigoEPC...');
          if (bloqueiaSaida) {
            console.warn('[EPC] Aguardando liberação do lock anterior...');
            // espera até que bloqueiaSaida seja falso
            while (bloqueiaSaida) {
              await sleep(100);
            }
          }

          bloqueiaSaida = true;
          try {
            // console.log('[EPC] Iniciando RotinaSaidaCodigoEPC');
            await RotinaSaidaCodigoEPC('P', '', '', '', true);
            // console.log('[EPC] Finalizou RotinaSaidaCodigoEPC');
          } catch (error) {
            console.error('[EPC] Erro na RotinaSaidaCodigoEPC:', error);
            bloqueiaSaida = false;
          } finally {
            bloqueiaSaida = false;
          }
        },
        venda: true,
      });

      $('#btn-iniciar-epc').on('click', () => {
        $('#btn-iniciar-epc').prop('disabled', true);
        $('#btn-parar-epc').prop('disabled', false);
        epc.iniciar()
      });

      $('#btn-parar-epc').on('click', async () => {
        bloqueiaSaida = false;
        $('#btn-iniciar-epc').prop('disabled', false);
        $('#btn-parar-epc').prop('disabled', true);
        await epc.parar()
        listaBarrasBipadasEPC = epc.listaBarrasForamBipadasEPC;
      });


      // EPC
      const epcConferencia = new EPC({
        barra: '#txtCodigo',
        quantidade: '#txtQuantid',
        deposito: '#txtDeposito',
        codigoEPC: '#txtCodigoEPC',
        idItem: '#txtIdItem',
        integracaoEPC: integracaoEPC,
        listaBarrasBipadasEPC: listaBarrasBipadasEPC,
        callBackSaidaBarra: async () => {
          // console.log('[EPC] Tentando executar RotinaSaidaCodigoEPC...');
          if (bloqueiaSaida) {
            // console.warn('[EPC] Aguardando liberação do lock anterior...');
            // espera até que bloqueiaSaida seja falso
            while (bloqueiaSaida) {
              await sleep(100);
            }
          }

          bloqueiaSaida = true;
          try {
            // console.log('[EPC] Iniciando RotinaSaidaCodigoEPC');
            await RotinaSaidaCodigoEPC('P', '', '', '', true);
            // console.log('[EPC] Finalizou RotinaSaidaCodigoEPC');
          } catch (error) {
            console.error('[EPC] Erro na RotinaSaidaCodigoEPC:', error);
          } finally {
            bloqueiaSaida = false;
          }
        }
      });

      $("#btnIniciarEPCConferencia").on("click", async function() {
        try {
          $('#btnIniciarEPCConferencia').prop('disabled', true);
          $('#btnPararEPCConferencia').prop('disabled', false);
          $('#btn-iniciar-epc').prop('disabled', true);
          $('#btn-parar-epc').prop('disabled', true);
          epcVenda = false;

          await epcConferencia.iniciarEPC();
        } catch (error) {
          console.error(error);
        }
      });

      $("#btnPararEPCConferencia").on("click", async function() {
        try {
          $('#btnIniciarEPCConferencia').prop('disabled', false);
          $('#btnPararEPCConferencia').prop('disabled', true);
          $('#btn-iniciar-epc').prop('disabled', false);
          $('#btn-parar-epc').prop('disabled', false);
          await epcConferencia.pararEPC();
        } catch (error) {
          console.error(error);
        }
      });



      await criaSelectTiposVenda();

      $('#btn-imprimir-malha').on('click', async function() {
        if ($('#tabelaItens').DataTable().data().toArray().length == 0) {
          msgAlerta('Nenhum material adicionado, verifique.');
          return;
        }
        try {
          $.LoadingOverlay('show');
          try {
            // alterado a rota
            const url = `/sisplan/impressao/v1/imprimirlotevenda?`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelLoteVenda');
            const itens = $('#tabelaItens').DataTable().data().toArray().filter(item => item[36] == 'DESDOBRADO').map(item => item[14]).toString();
            const arquivo = await GeraRelatorio(`${url}`, "POST", 100000, false, 'RelLoteVenda', `LISTA_ID_MAT_ITEN=${itens}`);
            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
              }
              await limparRelatorios();
            }

          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      async function salvarHistoricoVenda() {
        if ($('#tabelaItens').DataTable().data().toArray().length == 0) {
          // não há pq gravar
          return;
        }
        try {
          try {
            $.LoadingOverlay('show');
            let venda = {};
            venda = await montaJsonVenda(venda, numero_venda, 'P', false);
            const codven = isNaN(numero_venda) ? '-1' : numero_venda;
            const codcli = pegaChave('#txtCliente');
            const response = await requisicao('POST', '/Sisplan/Vendas/V1/salvaHistorico?', `CODVEN=${codven}&CODCLI=${codcli}`, `JSON=${JSON.stringify(venda)}`, 480000);

            if (!response) {
              return false;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return false;
            }

            $('#tabelaItens').DataTable().clear().draw(false);
            await carregaDadosItens(jsonStr.itens, '', false);
          } catch (error) {
            console.error('erro', error);
            msgAlerta('Erro ao salvar histórico, verifique.');
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      };

      $('#btn-rateiaPesoItens').on('click', function() {
        $('#modalPesoBalanca').modal('show');
      })

      async function validaTodosItensRateados() {

        if (!await verificaTabelaPrecoKG()) {
          return;
        }
        const data = $('#tabelaItens').DataTable().rows().data();
        const valorUnitario = parseFloat($('#txtValorUnitarioBalanca').val());
        const ratiou = data.filter((values) => (valorUnitario * values[2]) != values[4]).length > 0;

        return ratiou
      }
      async function retornaPrecoKG() {
        try {
          const json = await retornaJsonPesquisaPadrao(`{ "TABELA":"REGIAO", "camposSelect":["PRECO_KG"], "where": ["REGIAO = '${pegaChave('#txtTabela')}'"] }`);
          if (json) {
            if ((json[0].PRECO_KG) && (json[0].PRECO_KG > 0)) {
              return json[0].PRECO_KG
            }
          }

          return 0
        } catch (error) {
          console.error(error);
        }
      }
      async function preenchePesoKgModal() {
        const precoKg = await retornaPrecoKG();
        const sPeso = await buscaPesoBalanca(parseFloat(parametrosVenda[17]), parametrosVenda[74]);
        $('#pesoTotalBalanca').val(sPeso);
        $('#txtValorTotalBalanca').val(TruncaDecimaisNova(2, precoKg * sPeso));
      }

      $('#pesoTotalBalanca').on('blur', async function() {
        if ($('#pesoTotalBalanca').val() < 0) {
          msgAlerta('Peso não pode ser menor que 0!');
          $('#pesoTotalBalanca').val(0);
          return
        }
        const precoKg = await retornaPrecoKG();
        const sPeso = TruncaDecimaisNova(2, $('#pesoTotalBalanca').val())
        $('#txtValorTotalBalanca').val(TruncaDecimaisNova(2, precoKg * sPeso));
      })

      $('#modalPesoBalanca').on('shown.bs.modal', async function() {
        await preenchePesoKgModal();
      });

      $('#btnConfirmarPesoBalanca').on('click', async function() {
        try {
          let venda = {};
          venda = await montaJsonVenda(venda, numero_venda, 'P', false);
          $.LoadingOverlay('show');
          const total = parseFloat($('#txtValorTotalBalanca').val());
          const qtde = $('#tabelaItens').DataTable().column(2, {}).data().sum();
          const valorUnidade = TruncaDecimaisNova(2, total / qtde);

          if (valorUnidade === 0) {

            msgAlerta('Não ouve retorno da balança, deseja tentar novamente?', async () => {
              await preenchePesoKgModal();
              $('#modalPesoBalanca').modal('show');
            })
            return
          }

          $('#txtValorUnitarioBalanca').val(valorUnidade);
          const itens = venda.itens.map(item => {
            const data = {
              ...item,
              total: valorUnidade,
              total_Liq: TruncaDecimaisNova(2, valorUnidade * item.quantidade),
              preco_Liq: TruncaDecimaisNova(2, valorUnidade * item.quantidade)
            }

            return data;
          })
          $('#tabelaItens').DataTable().clear().draw(false);
          await carregaDadosItens(itens, '', false)
          let venda2 = {}

          venda2 = await montaJsonVenda(venda2, numero_venda, 'P', false);

          await atualizaTotalVenda();
          await atualizaSaldoAPagar();
          await atualizaTotaisPagto();
        } finally {
          $.LoadingOverlay('hide');
          $('#modalPesoBalanca').modal('hide');
        }
      })

      $('#btn-desdobrar-malha').on('click', async function() {
        if ($('#tabelaItens').DataTable().data().toArray().length == 0) {
          msgAlerta('Nenhum material adicionado, verifique.');
          return;
        }
        msgAlerta(`Tem certeza que deseja desdobrar os lotes? (Essa ação é irreversível)`, async () => {
          try {
            try {
              $.LoadingOverlay('show');
              let venda = {};
              venda = await montaJsonVenda(venda, numero_venda, 'P', false);
              const response = await requisicao('POST', '/Sisplan/Vendas/V1/desdobralotes?', ``, `JSON=${encodeURIComponent(JSON.stringify(venda))}`, 480000);

              if (!response) {
                return false;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return false;
              }

              $('#tabelaItens').DataTable().clear().draw(false);
              await carregaDadosItens(jsonStr.itens, '', true);
              let venda2 = {};
              venda2 = await montaJsonVenda(venda2, numero_venda, 'P', false);
              salvaDadosDigitados(venda2);
              const algumLoteDesdobrado = jsonStr.itens.filter(item => item.lote_orig == 'DESDOBRADO').length > 0;
              if (algumLoteDesdobrado) {
                msgSucesso('Lotes desdobrados com sucesso');
              } else {
                msgAlerta('Nenhum lote foi desdobrado');
              }

            } catch (error) {
              console.error('erro', error);
              msgAlerta('Erro ao desdobrar lotes, verifique.');
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        });
      });

      $('.somAtivo').on('click', function() {
        $(this).addClass('d-none');
        localStorage.setItem("@venda.somAtivo", false);
        $('.somInativo').removeClass('d-none');
      });

      $('.somInativo').on('click', function() {
        $(this).addClass('d-none');
        localStorage.setItem("@venda.somAtivo", true);
        $('.somAtivo').removeClass('d-none');
      });

      const somAtivo = localStorage.getItem('@venda.somAtivo') ?? 'false';
      if (somAtivo == 'true') {
        $($('.somInativo')[0]).trigger('click');
      }

      $('#txtTipoVenda').change(async function() {
        if ((numero_venda == 'create') || (numero_venda == 'create#')) {
          $('#txtTabela').val('');
          await preencheTabela();
        }

        if (pegaChave('#txtCliente') != '') {
          await verificaRegrasMontadas(true);
        }

        try {
          const tipos = await BuscaTiposVenda($('#txtTipoVenda').val());
          infoTipoVenda = tipos;
          tipos.map(async (tipo) => {
            if (tipo.ID == $('#txtTipoVenda').val()) {
              if (tipo.FECHA_VENDA == 'S') {
                $('#tipoFechaVenda').prop('checked', true);
                if (!UsuarioPodeGravarCondicoes) {
                  if (bCFEAutomatico != 0) {
                    $('.divCFE').removeClass('d-none');
                  }
                  if (bNFCEAutomatico != 0) {
                    $('.divNFCE').removeClass('d-none');
                  }
                  if (bNFEAutomatico != 0 && bNFEAutomatico != 2) {
                    $('.divNFE').removeClass('d-none');
                  }
                  if ($('#tabelaCondicoesDePagamento').DataTable().data().length > 0) {
                    $('#btnFinalizar').html(await traduzSentenca('Finalizar (F8)'));
                    $('#btnFinalizar').attr('data-original', 'Finalizar (F8)');
                  }
                }
              } else {
                $('#tipoFechaVenda').prop('checked', false);
                $('.divCFE').addClass('d-none');
                $('.divNFCE').addClass('d-none');
                if ((parametrosVenda[110] != '1') || (tipo.CONSIGNADO != 'S')) {
                  $('.divNFE').addClass('d-none');
                } else {
                  $('.divNFE').removeClass('d-none');
                }
                $('#btnFinalizar').html(await traduzSentenca('Deixar Pendente (F8)'));
                $('#btnFinalizar').attr('data-original', 'Deixar Pendente (F8)');
              }
              if (tipo.ESTOQUE == 'S') {
                $('#vendaMovimentaEstoque').prop('checked', true);
              } else {
                $('#vendaMovimentaEstoque').prop('checked', false);
              }

              const bloqueiaTrocarTipo = [1, 2].includes(tipo.EXCLUSAO_ITEM) &&
                ((numero_venda != 'create') && (numero_venda != 'create#'));
              $('#txtTipoVenda').prop('disabled', bloqueiaTrocarTipo);
            }
          });

        } catch (error) {
          console.error(error);
        }
      });

      var sSeparador = "' - '";
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
      $('.select2').select2();
      $('.select2bs4').select2({
        theme: 'bootstrap4'
      });
      history.pushState(null, null, '<?php echo $_SERVER["REQUEST_URI"]; ?>');
      window.addEventListener('popstate', function(event) {
        parent.fechaAbaVendaDevolucao('Venda', numero_venda);
        window.location.href = "<?php echo BASE_URI; ?>/loja";
      });

      $('#txt_val_ent').on('change', function() {
        var total = parseFloat($('#txt_val_venda').val() - $('#txt_val_ent').val()).toFixed(2);
        $('#txtPercDescontoSimulacao').val(0);
        $('#txtValorDescontoSimulacao').val(0);
        $('#txt_val_liq').val(total);
      });

      $('#i_presente').on('click', function() {
        $('#cb_presente').trigger('click');
      });

      $("#txtPercDescontoSimulacao").on("blur", function() {
        const valorVenda = $('#txt_val_venda').val() - $('#txt_val_ent').val();
        const desconto = $("#txtPercDescontoSimulacao").val();
        const percentual = +desconto / 100;
        const valor = +valorVenda * +percentual;
        const valorfinal = +valorVenda - valor;
        const valorDesconto = +valorVenda - valorfinal;
        $('#txt_val_liq').val(TruncaDecimaisNova(2, valorfinal));
        $('#txtValorDescontoSimulacao').val(TruncaDecimaisNova(2, valorDesconto));
      });

      $("#txtValorDescontoSimulacao").on("blur", function() {
        const valorVenda = $('#txt_val_venda').val() - $('#txt_val_ent').val();
        const valorDesconto = $('#txtValorDescontoSimulacao').val();
        const valorfinal = +valorVenda - valorDesconto;
        const calculoPercentual = +valorDesconto * 100;
        const percentualDesconto = +calculoPercentual / +valorVenda;
        $('#txt_val_liq').val(TruncaDecimaisNova(2, valorfinal));
        $('#txtPercDescontoSimulacao').val(TruncaDecimaisNova(2, percentualDesconto));
      });

      $("#txtPercDescontoSimulacao").on("keydown", function() {
        if ((event.key == 'Enter')) {
          const valorVenda = $('#txt_val_venda').val() - $('#txt_val_ent').val();
          const desconto = $("#txtPercDescontoSimulacao").val();
          const percentual = +desconto / 100;
          const valor = +valorVenda * +percentual;
          const valorfinal = +valorVenda - valor;
          const valorDesconto = +valorVenda - valorfinal;
          $('#txt_val_liq').val(TruncaDecimaisNova(2, valorfinal));
          $('#txtValorDescontoSimulacao').val(TruncaDecimaisNova(2, valorDesconto));
        }
      });

      $("#txtValorDescontoSimulacao").on("keydown", function() {
        if ((event.key == 'Enter')) {
          const valorVenda = $('#txt_val_venda').val() - $('#txt_val_ent').val();
          const valorDesconto = $('#txtValorDescontoSimulacao').val();
          const valorfinal = +valorVenda - valorDesconto;
          const calculoPercentual = +valorDesconto * 100;
          const percentualDesconto = +calculoPercentual / +valorVenda;
          $('#txt_val_liq').val(TruncaDecimaisNova(2, valorfinal));
          $('#txtPercDescontoSimulacao').val(TruncaDecimaisNova(2, percentualDesconto));
        }
      });

      $("#txtValorAcrescMoeda").on("keydown", function(e) {
        if ((e.key == 'Enter')) {
          e.preventDefault();
          $(this).trigger('blur');
          if ($('#txtPercDescontoMoeda').prop('disabled') && $('#txtValorDescontoMoeda').prop('disabled')) {
            $('#txtValorLiquidoMoeda').focus();
          } else if (!$('#txtPercDescontoMoeda').prop('disabled')) {
            $('#txtPercDescontoMoeda').focus();
          }
        }
      });

      $("#txtValorParcela").on("keydown", function(e) {
        if ((e.key == 'Enter')) {
          e.preventDefault();
          $(this).trigger('blur');
          if ($('#txtPercAcrescMoeda').prop('disabled') && $('#txtValorAcrescMoeda').prop('disabled')) {
            $('#txtValorLiquidoMoeda').focus();
          } else if (!$('#txtPercAcrescMoeda').prop('disabled')) {
            $('#txtPercAcrescMoeda').focus();
          }
        }
      });

      $('#modal-simular').on('hide.bs.modal', function() {
        $('#txtMoedaSimulacao').val('');
        $('#txtCondPagto').val('');
        $('#txtPercDescontoSimulacao').val('');
      });

      $('#btn-simular').on('click', function() {
        $('#tabela_simula').DataTable().rows()
          .remove()
          .draw(false);
        $('#modal-simular').modal('show');
        var total = parseFloat($('#tabelaItens').DataTable().column(7, {}).data().sum()).toFixed(2);
        $('#txtCondPagto').val($('#txtCondicaoDePagamento').val());
        $('#txtNrParcelasCondPagto').val($('#txtNrParcelas').val());
        $('#txtMoedaSimulacao').val($('#txtMoeda').val())
        $('#txt_val_liq').val($('#txtValorParcela').val());
        $('#txt_val_venda').val($('#txtValorParcela').val());
        $('#txt_val_ent').val(0);
        $('#txt_val_ent').trigger('change');
        if ($('#txtCondPagto').val() != '') {
          $('#btn-simulacao').trigger('click');
        }
        var dataSetCols = [];
        var colunas = ['Parcela', 'Vencto', 'Valor'];
        for (let i = 0; i < colunas.length; i++) {
          dataSetCols.push({
            'title': colunas[i],
            'data': colunas[i]
          });
        }

        $('#btnLimpaMoedaSimulacao').on('click', function() {
          $('#txtMoedaSimulacao').val('');
          $('#txtCondPagto').val('');
          $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelasCondPagto'], ['NRPAR'], ['NRPAR']);
          $('#btn-CondPagto').pesquisa_array(['#txtCondPagto', '#txtNrParcelasCondPagto'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
          $('#txtNrParcelasCondPagto').val('');
        });

        $('#txtMoedaSimulacao').off('blur');
        $('#txtMoedaSimulacao').on('blur', async function() {
          const codmoeda = pegaChave('#txtMoedaSimulacao');
          if ((codmoeda != '') && (await temCondicoesEspecificas(codmoeda))) {
            $('#txtCondPagto').unbind('autocompleta');
            $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${codmoeda})"]}`, ['#txtNrParcelasCondPagto'], ['NRPAR'], ['NRPAR']);
            $('#btn-CondPagto').off();
            $('#btn-CondPagto').unbind('pesquisa_array');
            $('#btn-CondPagto').pesquisa_array(['#txtCondPagto', '#txtNrParcelasCondPagto'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${codmoeda})"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
          }
        });

        $("#btn-utilizar").off("click");
        $('#btn-utilizar').on('click', async function() {
          if ($('#txtMoedaSimulacao').val() == '') {
            msgAlerta('Necessário informar uma forma de pagamento');
            return
          } else if ($('#txtCondPagto').val() == '') {
            msgAlerta('Necessário informar uma confição de pagamento');
            return
          }
          const codmoeda = pegaChave('#txtMoedaSimulacao');
          const condicao = pegaChave('#txtCondPagto');

          const bCondicaoValida = await validaCondicaoMoeda(codmoeda, condicao);
          if (!bCondicaoValida) {
            return;
          }
          const dados = await buscaDadosSimulacao()
          await insereDadosVenda(dados)
          await RotinaSaidaMoeda();
        });

        $('#txtValorParcela').on('blur', async function() {
          const bDescontaFrete = ((bNaoConsiderarFreteDesconto) && ((parseFloat($("#txtPercDescontoMoeda").val()) > 0) || (parseFloat($("#txtValorDescontoMoeda").val()) > 0)));
          const valFrete = isNaN(parseFloat($('#txtFrete').val())) ? 0 : parseFloat($('#txtFrete').val());
          const valorParcela = bDescontaFrete ? (parseFloat($("#txtValorParcela").val()) - valFrete) : $("#txtValorParcela").val();
          const validaDesc = await CalculaDescontoMoeda('txtValorDescontoMoeda', valorParcela, $("#txtPercDescontoMoeda").val(), $("#txtValorDescontoMoeda").val(), $("#txtValorParcela").val(), 1);
          if (validaDesc == false) {
            return;
          }
        });

        async function buscaDadosSimulacao() {
          let obj = new Object();
          obj = {
            formaPagto: $('#txtMoedaSimulacao').val(),
            condPag: $('#txtCondPagto').val(),
            valVenda: $('#txt_val_venda').val(),
            valEntrada: $('#txt_val_ent').val(),
            percDesconto: $('#txtPercDescontoSimulacao').val(),
            valDesconto: $('#txtValorDescontoSimulacao').val(),
            valLiquido: $('#txt_val_liq').val(),
            codCond: pegaChave('#txtCondPagto')
          }
          return obj;
        }

        async function insereDadosVenda(dados) {
          try {
            $('#txtValorEntrada').val(dados.valEntrada)
            $('#txtValorParcela').val((dados.valVenda - dados.valEntrada).toFixed(2))
            // $('#txtMoeda').val(dados.formaPagto)
            insereValor('#txtMoeda', pegaChave(dados.formaPagto), pegaDescricao(dados.formaPagto));
            // $('#txtCondicaoDePagamento').val(dados.condPag);
            insereValor('#txtCondicaoDePagamento', pegaChave(dados.condPag), pegaDescricao(dados.condPag));
            $('#txtPercDescontoMoeda').val(dados.percDesconto);
            $('#txtValorDescontoMoeda').val(dados.valDesconto);
            await buscaParcelas(dados.codCond);
            const tpMoeda = await validaTipoMoeda(pegaChave(dados.formaPagto));
            $('#txtTipoMoeda').val(`[${tpMoeda}] - ${tpMoeda}`);

          } catch (error) {
            console.log(error)
          } finally {
            $('#modal-simular').modal('hide');
            $('#txtValorParcela').trigger('blur')
          }
        }

        async function validaTipoMoeda(sMoeda) {
          let resposta = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"MOEDA", 
              "camposSelect":["TIPO"], 
              "where": ["CODMOE = '${sMoeda}'"]}`,
            null
          );
          let dado = await resposta.json();
          return dado.RESULT[0][0].TIPO
        }

        async function buscaParcelas(condicao) {
          let resposta = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"CONDICAO", 
              "camposSelect":["NRPAR"], 
              "where": ["CODCOND = '${condicao}'"]}`,
            null
          );
          let jsonString = await resposta.json();
          if (jsonString.RESULT[0] != 0) {
            insereValor($("#txtNrParcelas"), jsonString.RESULT[0][0].NRPAR, jsonString.RESULT[0][0].NRPAR);
          }
          return
        }

        dataSetCols[1].type = 'date-br';
        dataSetCols[1].render = function(data, type, row) {
          //alert(navigator['userAgent'])
          var isIE = function() {
            if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                'userAgent']) == true) {
              return true;
            } else {
              return false;
            }
          }
          if (isIE()) {
            x = data.slice(0, 10).split('-');
            return x[2] + "/" + x[1] + "/" + x[0];
          } else {
            x = data.slice(0, 10).split('-');
            return x[2] + "/" + x[1] + "/" + x[0];
            return $.datepicker.formatDate("dd/mm/Y", new Date(data));
          }
        }

        $('#tabela_simula').DataTable({
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          autowidth: true,
          columns: dataSetCols
        });
      });

      $('#abreCadCli').on('click', async function() {
        $('.subatalho').trigger('click');
        $('#modal-cliente').modal('show');
        $('#btnModalNovoCliente').trigger('click');

        $('#modal-cliente').on('shown.bs.modal', function() {
          const linkContato = $('a[data-toggle="collapse"][href="#multiCollapseContato"]');

          if (linkContato.attr('aria-expanded') === 'true') {
            linkContato.trigger('click');
          }
        });
      });

      $('#abrePreco').on('click', async function() {
        await $('.subatalho').trigger('click');
        await $('#modalPrecos').modal('show');
        await insereValor('#txtDepositoProd', pegaChave('#txtDeposito'), pegaDescricao('#txtDeposito'));
        await insereValor('#txtTabelaPrecoProd', pegaChave('#txtTabela'), pegaDescricao('#txtTabela'));
      });

      $('#abreVendas').on('click', async function() {
        $('.subatalho').trigger('click');
        await RetornaVendasPendentes();
        $('#modalVendasPendentes').modal('show');
      });

      $('#abreCupomTroca').on('click', async function() {
        $('.subatalho').trigger('click');
        await abreCupomTroca();
        const ultimaVenda = await getCookie('ultima-venda-finalizada');
        if ((ultimaVenda != undefined) && (ultimaVenda != '')) {
          await insereValor('#venda-cupom-troca', ultimaVenda, ultimaVenda);
          await rotinaSaidaVendaCupomTroca();
          $('#tabela-itens-cupom-troca').focus();
        }
        // await buscaItensCupomTroca(data.VENDA);
      });

      $('#abreConsultaEstoque').on('click', async function() {
        $('.subatalho').trigger('click');
        $('#modalConsultaEstoque').modal('show');
        $("#tabelaProdutosConsultaEstoque").DataTable().columns.adjust().draw(false);

        await insereValor('#txtDepositoConsultaEstoque', pegaChave('#txtDeposito'), pegaDescricao('#txtDeposito'));
      });

      if (parametrosVenda[46] == '3') {
        $('#tabImpVenda').addClass('d-none')
        setTimeout(() => {
          $('#tabImpPedido').trigger('click')
        }, 200)
      }

      $('#impVendas').on('click', async function() {
        if ($('#tabelaItens').DataTable().rows().count() > 0) {
          msgErro(
            'Venda atual já possui itens, necessário remover os itens atuais para utilizar essa opção.');
          return;
        }
        $('.subatalho').trigger('click');
        $('#txtTabelaImpVenda').val($('#txtTabela').val());
        $('#txtTabelaImpVenda').attr('data-selecionado', true);
        $('#txtVenda').val('');
        $('#modalImportarVendas').modal('show');
      });

      controlaECF();
      addBandeira();

      // manter com await...
      var bNFCEAutomatico = parametrosVenda[6];
      var bCFEAutomatico = parametrosVenda[18];
      var bNFEAutomatico = parametrosVenda[20];
      var utilizaGuia = parametrosVenda[12];
      var bUtilizaStatus = parametrosVenda[37];
      var bUtilizaVendedorPorItem = parametrosVenda[39] == '1';
      var somarPedidosPendentesCreditoGrupo = parametrosVenda[108] == '1';
      if (somarPedidosPendentesCreditoGrupo) {
        const titleAtual = $($('.btnInfoLimite')[1]).attr('title');
        $($('.btnInfoLimite')[1]).attr('title', titleAtual + ' mais o valor de Pedidos pendentes.')
      }
      var bUtilizaCashback = ['1', '3', "4"].includes(parametrosVenda[72]);
      const bUtilizaCashbackCRMBonus = parametrosVenda[72] == '2';
      if (parametrosVenda[72] == '3') {
        $('#divTotSemDesconto').removeClass('d-none');
      }
      const bAplicaDescMaxTabPrecoVenda = parametrosVenda[81] == '1';
      const bAplicaDescMaxTabPrecoVendaNotAlterar = parametrosVenda[81] == '2';
      var jaUtilizouCashback = false;
      const cashbackCliente = {
        pontos: 0,
        valor: 0,
        valorUtilizado: 0,
        pontosUtilizados: 0,
        indiceTabelaPagamento: -1,
        perc_max: 0
      }
      valorMinimoCashback = parseFloat((await retornaValorCadPadrao('CASHBACK', 'VAL_MIN')).replace(',', '.')) || 0;
      valorMinimoVendaCashback = parseFloat((await retornaValorCadPadrao('CASHBACK', 'VALOR')).replace(',', '.')) || 0;
      const listaMoedasEmpresa = await retornaMoedasEmpresa();

      if (getCookie('usuario') == "") {
        window.location.href = "<?php echo BASE_URI; ?>/login";
      }

      $('#txt_usuario_logado').text(sessionStorage.getItem('g_usuario_logado').toUpperCase());
      if ((sessionStorage.getItem('g_caixa_logado') != null) && (sessionStorage.getItem('g_caixa_logado') != '') && (
          sessionStorage.getItem('g_caixa_logado') != 'undefined')) {
        var sCaixa = sessionStorage.getItem('g_caixa_logado').substring(1, sessionStorage.getItem('g_caixa_logado')
          .indexOf("]"));
        $('#txt_caixa_logado').text(sCaixa);
      } else {
        toastr.warning(
          'Caixa/Vendedor não informado!',
          'Atenção', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 5000,
            fadeOut: 1000,
            onHidden: function() {
              if (parent.document.querySelector('body').classList.contains('iframe-mode-fullscreen')) {
                parent.document.querySelector("#abrirTelaCheia").click();
              }
              console.log(numero_venda);
              parent.fechaAbaVendaDevolucao('Venda', numero_venda);
              if (!$('body').hasClass('sidebar-mini layout-fixed vsc-initialized iframe-mode-fullscreen')) {
                parent.$('#abrirTelaCheia').trigger('click');
              }
            }
          }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        // window.location.href = "<?php echo BASE_URI; ?>/loja";
      }

      async function RetornaBandeiras(moeda = "") {
        let pesquisa = "";
        if (moeda == "") {
          pesquisa = {
            tabela: 'BANDEIRA',
            camposSelect: ["ID", "DESCRICAO"],
            where: ["ATIVO = 'S'"],
            orderby: ["ORDEM", "DESCRICAO"]
          }
        } else {
          pesquisa = {
            tabela: 'MOEDA',
            camposSelect: ["BANDEIRA.ID", "BANDEIRA.DESCRICAO"],
            leftJoin: [{
                tabela: "ENTIDADE",
                condicao: "ENTIDADE.CODCLI = MOEDA.CODCLI"
              },
              {
                tabela: "TEF_OPERADORA",
                condicao: "TEF_OPERADORA.ID_ENT = ENTIDADE.ID"
              },
              {
                tabela: "TEF_BANDEIRA",
                condicao: "TEF_BANDEIRA.ID_OPERADORA = TEF_OPERADORA.ID AND TEF_OPERADORA.EMP_ID = TEF_BANDEIRA.EMP_ID"
              },
              {
                tabela: "BANDEIRA",
                condicao: "BANDEIRA.DESCRICAO = TEF_BANDEIRA.BANDEIRA"
              }
            ],
            where: [`MOEDA.CODMOE = ${moeda}`, `TEF_OPERADORA.EMP_ID = ${getCookie("emp_id")}`],
            groupBy: ["BANDEIRA.ID", "BANDEIRA.DESCRICAO"]
          }
        }

        try {
          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          if (jsonStr.length == 0 && moeda != "") {
            return await RetornaBandeiras();
          } else if (jsonStr.length > 0) {
            return jsonStr;
          }

          return [];

        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar as bandeiras de cartões');
        }
      }

      function retornaInputQtde(qtde) {
        return `<input type="number" class="input-default focus inputpreco" min=0 value="${qtde}">`;
      }

      async function buscaRepVendaImportada() {
        const codigoVendaImportada = pegaChave('#txtVenda');
        if (codigoVendaImportada == '') {
          return;
        }

        try {
          const pesquisa = {
            camposSelect: ['VENDA.CODREP', 'REPRESEN.NOME NOME_REP'],
            tabela: 'VENDA',
            leftJoin: [{
              tabela: 'REPRESEN',
              condicao: 'REPRESEN.CODREP = VENDA.CODREP'
            }],
            where: [`VENDA.CODVEN = ${codigoVendaImportada}`]
          };

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          if (jsonStr && jsonStr.length > 0) {
            return jsonStr[0];
          }
          return '';
        } catch (e) {
          console.error(e);
          return '';
        }
      }

      async function buscaGuiaVendaImportada() {
        const codigoVendaImportada = pegaChave('#txtVenda');
        if (codigoVendaImportada == '') {
          return;
        }

        try {
          const pesquisa = {
            camposSelect: ['VENDA.CODREP2 GUIA', 'REPRESEN.NOME NOME_GUIA'],
            tabela: 'VENDA',
            leftJoin: [{
              tabela: 'REPRESEN',
              condicao: 'REPRESEN.CODREP = VENDA.CODREP2'
            }],
            where: [`VENDA.CODVEN = ${codigoVendaImportada}`]
          };

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          if (jsonStr && jsonStr.length > 0) {
            return jsonStr[0];
          }
          return '';
        } catch (e) {
          console.error(e);
          return '';
        }
      }

      $('#btnCarregarImportarArquivo').on('click', async function() {
        if ($('#txtArquivoImportar').val() == '') {
          msgAlerta('Nenhum arquivo selecionado para leitura.')
          return;
        }
        const arrNome = $('#txtArquivoImportar').val().split('.');
        if (arrNome.length > 0) {
          const ext = arrNome[arrNome.length - 1];
          if (!['CSV', 'XLS', 'XLSX'].includes(ext.toUpperCase())) {
            msgAlerta('Extensão do arquivo deve ser .csv');
            return;
          }
        }
        await carregaDadosImportacaoArquivo();
      });

      function retornaDadosImportarArquivo() {
        let info = $('#fileContent').text();
        let dados = '';
        dados = info.split('\r\n').filter(i => i != '');
        return dados;
      }

      async function confirmarImportacaoArquivo() {
        const dados = $('#tabelaImportarArquivo').DataTable().data().toArray();
        for (let i = 0; i < dados.length; i++) {
          $("#txtCodigo").attr("informacoesItem", `${dados[i].CODIGO} - ${dados[i].DESCRICAO}`);
          const preco = 0;
          if (dados[i].BARRA != '') {
            $('#txtCodigo').val(dados[i].BARRA);
            await RotinaSaidaCodigo('P', '', '', '', true, '', '', preco);
          }
        };
        $('#modalImportarVendas').modal('hide');
      }


      async function carregaDadosImportacaoArquivo() {
        $('#btnCarregarImportarArquivo').prop('disabled', true);
        $.LoadingOverlay('show');
        try {
          const barrasArquivo = retornaDadosImportarArquivo();
          const listaBarras = await formataListas(barrasArquivo.toString());

          const pesquisa = {
            tabela: 'BARRA_LOG',
            camposSelect: ['BARRA_LOG.BARRA', 'BARRA_LOG.CODIGO', 'PRODUTO.DESCRICAO', 'BARRA_LOG.COR', 'CADCOR.DESCRICAO DESC_COR', 'BARRA_LOG.TAMANHO', 'BARRA_LOG.BARRA'],
            leftJoin: [{
                "tabela": "PRODUTO",
                "condicao": "PRODUTO.CODIGO = BARRA_LOG.CODIGO"
              },
              {
                "tabela": "CADCOR",
                "condicao": "CADCOR.COR = BARRA_LOG.COR"
              }
            ],
            where: [`BARRA_LOG.BARRA IN (${listaBarras})`],
            orderBy: ['BARRA_LOG.CODIGO', 'BARRA_LOG.COR', 'BARRA_LOG.TAMANHO']
          };

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          criaTabelaImportar(jsonStr);

          const barrasEncontradas = $('#tabelaImportarArquivo').DataTable().data().toArray().map(it => it.BARRA);


          const barrasNaoEncontradas = barrasArquivo.filter(b => !barrasEncontradas.includes(b));
          if (barrasNaoEncontradas.length > 0) {
            $('#txtBarrasNaoBipadas').html('Barras não encontradas: <br>' + barrasNaoEncontradas.toString().replaceAll(',', '<br>'))
          } else {
            $('#txtBarrasNaoBipadas').html('');
          }

          $('#btn_confirmar_arquivo_importado').off('click');
          $('#btn_confirmar_arquivo_importado').on('click', async function() {
            if ($('#tabelaImportarArquivo').DataTable().data().toArray().length == 0) {
              msgAlerta('Nenhuma barra para importar, verifique.');
            };
            msgAlerta('Deseja realmente importar as barras?',
              () => {},
              () => {},
              () => {
                confirmarImportacaoArquivo();
              }
            );
          });
        } catch (e) {
          msgErro('Não foi possível realizar a importação.');
          console.log(e);
        } finally {
          $.LoadingOverlay('hide');
          $('#btnCarregarImportarArquivo').prop('disabled', false);
        }
      }

      function criaTabelaImportar(dados) {
        if ($.fn.DataTable.isDataTable('#tabelaImportarArquivo')) {
          $('#tabelaImportarArquivo').DataTable().destroy();
          $('#tabelaImportarArquivo').empty();
        }

        const cols = [{
            data: 'CODIGO',
            title: 'Código'
          },
          {
            data: 'DESCRICAO',
            title: 'Descrição'
          },
          {
            data: 'COR',
            title: 'Cor'
          },
          {
            data: 'DESC_COR',
            title: 'Desc. Cor'
          },
          {
            data: 'TAMANHO',
            title: 'Tamanho'
          },
          {
            data: 'BARRA',
            title: 'Barra'
          }
        ];

        $('#txtArquivoImportarTituloTabela').removeClass('d-none');

        $("#tabelaImportarArquivo").DataTable({
          sort: true,
          paging: false,
          info: false,
          destroy: true,
          lengthChange: false,
          filter: false,
          autoWidth: true,
          data: dados,
          columns: cols
        }).draw(false);
      }




      function leArquivoExcel(reader, file, name) {
        try {
          const extension = (name.split('.')[name.split('.').length - 1]);
          if (extension.toLocaleLowerCase() == 'csv') {
            reader.onload = function(e) {
              $('#fileContent').text(e.target.result);
            };
            reader.readAsText(file);
          } else if (extension == 'xls' || extension == 'xlsx' || extension == 'xlsm' || extension == 'xlt') {
            reader.onload = function(e) {
              const data = new Uint8Array(e.target.result);
              const workbook = XLSX.read(data, {
                type: 'array'
              });
              const sheetName = workbook.SheetNames[0];
              const sheet = workbook.Sheets[sheetName];

              // Get the range of the sheet
              const range = XLSX.utils.decode_range(sheet['!ref']);
              let resultString = '';

              for (let R = range.s.r; R <= range.e.r; ++R) {
                for (let C = range.s.c; C <= range.e.c; ++C) {
                  const cellAddress = {
                    c: C,
                    r: R
                  };
                  const cellRef = XLSX.utils.encode_cell(cellAddress);
                  const cell = sheet[cellRef];
                  let cellValue = cell ? cell.v : null;

                  if (cell && cell.t === 'n' && cell.z === 'm/d/yy') {
                    const serialDate = cellValue;
                    const jsDate = excelSerialToJSDate(serialDate);
                    cellValue = formatDate(jsDate);
                  }

                  resultString += `${cellValue},`;
                }
                resultString = resultString.slice(0, -1); // Remove the trailing comma
                resultString += ';';
              }

              $('#fileContent').text(resultString);
            };
            reader.readAsArrayBuffer(file);

          } else {
            $('#fileContent').text('');
          }
        } catch (e) {
          msgErro(`Não foi possível ler o arquivo: ${e}`);
        }
      }



      async function confirmarImportacaoVenda() {
        $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
        let totImp = 0;
        for (let i = 0; i < $('.inputpreco').length; i++) {
          const input = $('.inputpreco')[i];
          totImp += $(input).val();
        }
        if (totImp == 0) {
          msgErro('Nenhum item com quantidade à importar, verifique.');
          return;
        }

        await $('#txtTabela').val($('#txtTabelaImpVenda').val());
        await $('#txtTabela').attr('data-selecionado', true);

        let clienteImportado = pegaDescricao('#txtVenda');
        clienteImportado = '[' + clienteImportado.substring(clienteImportado.indexOf(' -'), '') + '] - ' + clienteImportado.substring(clienteImportado.indexOf('- '), clienteImportado.length).replace('- ', '');

        await $('#txtCliente').val(clienteImportado);
        $('#txtCliente').trigger('blur');


        const representanteImportado = await buscaRepVendaImportada();
        const guiaImportado = await buscaGuiaVendaImportada();

        if ((representanteImportado) && (representanteImportado.CODREP)) {
          insereValor('#txtVendedor', representanteImportado.CODREP, representanteImportado.NOME_REP);
        }

        if ((guiaImportado) && (guiaImportado.GUIA)) {
          insereValor('#txtGuia', guiaImportado.GUIA, guiaImportado.NOME_GUIA);
        }


        for (let i = 0; i < $('#tabelaImportarVendas').DataTable().rows().count(); i++) {
          const dados = $('#tabelaImportarVendas').DataTable().row(i).data();
          const vQtde = $($('.inputpreco')[i]).val();
          $("#txtCodigo").attr("informacoesItem", `${dados.CODIGO} - ${dados.DESCRICAO}`);
          if (vQtde > 0) {
            const preco = isChecked('#ManterValor') ? dados.PRECO_ORIG : 0;
            if (dados.BARRA != '') {
              await $('#txtCodigo').val(vQtde + '*' + dados.BARRA);
              await RotinaSaidaCodigo(dados.TIPO, '', '', '', true, '', '', preco);
            } else {
              $('#txtQuantid').val(vQtde);
              $('#txtIdItem').val(dados.ID_ESTOQUE);
              await RotinaSaidaCodigo(dados.TIPO, '', '', '', true, '', '', preco);
            }
          }
        };

        await $('#modalImportarVendas').modal('hide');
        // $('#tabelaImportarVendas').DataTable().clear().draw(false);

      }

      async function retornaDescricaoItem(id, tipo) {
        try {
          const url = `/sisplan/funcoes/v1/pesquisa?`;
          let params;
          if (tipo == 'P') {
            params = `JSON={"tabela": "PA_ITEN","camposSelect": ["PA_ITEN.CODIGO","PRODUTO.DESCRICAO","PA_ITEN.ID"],"innerjoin": [{"tabela": "produto","condicao": "PRODUTO.CODIGO = PA_ITEN.CODIGO"}],"where": ["PA_ITEN.ID = ${id}"]}`;
          } else {
            params = `JSON={"tabela": "MAT_ITEN","camposSelect": ["MAT_ITEN.CODIGO","MATERIAL.DESCRICAO","MAT_ITEN.ID"],"innerjoin": [{"tabela": "MATERIAL","condicao": "MATERIAL.CODIGO = MAT_ITEN.CODIGO"}],"where": ["MAT_ITEN.ID = ${id}"]}`;
          }
          const response = await requisicao('GET', url, params, 15000);

          if (!response) {
            return;
          }

          jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          return jsonStr.RESULT[0][0].DESCRICAO;

        } catch (error) {

        }
      }

      async function RetornaItensImportarVenda(iVenda, iTabela) {
        try {
          try {

            const url = `/sisplan/funcoes/v1/pesquisa?`;
            const sDeposito = pegaChave('#txtDeposito');

            const params = `JSON={"tabela": "itvenda","camposSelect": ["itvenda.codigo","'0' AS DESCRICAO", "itvenda.cor","cadcor.descricao desc_cor","itvenda.tam","itvenda.quantidade qtde_orig","itvenda.quantidade qtde_imp","itvenda.preco_liq preco_orig","tabpreco.preco_${pegaValor('#rgPrazo')} preco_novo","itvenda.barra","itvenda.TIPO",  "CASE WHEN ITVENDA.TIPO = 'M' THEN (SELECT ID FROM MAT_ITEN_001 mi WHERE mi.CODIGO = ITVENDA.CODIGO AND mi.COR = ITVENDA.COR AND mi.DEPOSITO = '${sDeposito}' AND mi.LOTE = ITVENDA.LOTE) ELSE (SELECT ID FROM PA_ITEN_001 PA WHERE PA.CODIGO = ITVENDA.CODIGO AND PA.COR = ITVENDA.COR AND PA.DEPOSITO = '${sDeposito}' AND PA.TAM = ITVENDA.TAM AND PA.LOTE = ITVENDA.LOTE AND PA.TIPO = ITVENDA.QUALIDADE) END ID_ESTOQUE"],"leftjoin": [{"tabela": "cadcor","condicao": "cadcor.cor = itvenda.cor"},{"tabela": "tabpreco","condicao": "itvenda.codigo = tabpreco.codigo and tabpreco.regiao='${iTabela}' "}],"where": ["itvenda.codven = ${iVenda}"],"orderby": ["itvenda.codigo","itvenda.cor"]}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
              return;
            }

            jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.mensagem);
            }

            const tipoItem = jsonStr.RESULT[0];

            for (let i in tipoItem) {
              let item = [];
              const descricao = await retornaDescricaoItem(tipoItem[i].ID_ESTOQUE, tipoItem[i].TIPO);
              tipoItem[i].DESCRICAO = descricao != undefined ? descricao : '';

              tipoItem[i].PRECO_NOVO = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(tipoItem[i].PRECO_NOVO, quantidadeCasasDecimaisCampo)) :
                TruncaDecimaisNova(2, tipoItem[i].PRECO_NOVO);
              tipoItem[i].PRECO_ORIG = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(tipoItem[i].PRECO_ORIG, quantidadeCasasDecimaisCampo)) :
                TruncaDecimaisNova(2, tipoItem[i].PRECO_ORIG);
            };

            let dataSet = [];
            let dataSetCols = [];

            if (!$.isEmptyObject(tipoItem)) {
              dataSet = tipoItem;
              let keys = Object.keys(tipoItem[0]);

              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }
              // dataSetCols[7].type = '';
              dataSetCols[6].render = function(data, type, row) {
                return retornaInputQtde(data);
              }
              tabelaImportarVendas = $('#tabelaImportarVendas').DataTable({
                destroy: true,
                select: true,
                keys: false,
                searching: false,
                order: false,
                lengthChange: false,
                scrollY: "300px",
                scrollCollapse: true,
                paging: false,
                "columns": dataSetCols,
                "data": dataSet,
                "columnDefs": [{
                    "render": function(data) {
                      return parseFloat(data).toLocaleString('pt-BR', {
                        maximumFractionDigits: quantidadeCasasDecimaisCampo,
                        minimumFractionDigits: quantidadeCasasDecimaisCampo
                      });
                    },
                    "targets": [7, 8],
                    "className": 'pr-4 text-right'
                  },
                  {
                    "targets": [9],
                    "visible": false
                  },
                  {
                    "targets": [5],
                    "className": 'pr-4 text-right'
                  }
                ],
              });

              $('#btn_confirmar_venda_importada').unbind('click');
              $('#btn_confirmar_venda_importada').on('click', async function() {
                await confirmarImportacaoVenda();
              });
            }
          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os itens da venda.');
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      $('.checkPedidos').addClass('d-none');

      $('#tabImpPedido').on('click', function() {
        $('#btn_confirmar_venda_importada').attr('id', 'btn_confirmar_pedido_importado');
        $('.checkVendas').addClass('d-none');
        $('.checkPedidos').removeClass('d-none');
        $('#divImpPed').removeClass('d-none');
        $('#divTipoPedido').removeClass('d-none');
        $('#divImpVen').addClass('d-none');
      });

      $('#tabImpVenda').on('click', function() {
        $('#btn_confirmar_pedido_importado').attr('id', 'btn_confirmar_venda_importada');
        $('.checkVendas').removeClass('d-none');
        $('.checkPedidos').addClass('d-none');
        $('#divImpPed').addClass('d-none');
        $('#divTipoPedido').addClass('d-none');
        $('#divImpVen').removeClass('d-none');
      });


      $('#tabImpArquivo').on('click', function() {
        $('#btn_confirmar_pedido_importado').attr('id', 'btn_confirmar_arquivo_importado');
        $('#btn_confirmar_venda_importada').attr('id', 'btn_confirmar_arquivo_importado');
        $('#txtArquivoImportar').val('');
        $('#txtBarrasNaoBipadas').html('');

        if ($.fn.DataTable.isDataTable('#tabelaImportarArquivo')) {
          $('#tabelaImportarArquivo').DataTable().destroy();
          $('#tabelaImportarArquivo').empty();
        }


        $('#mdModalUpload').off('change');
        $('#mdModalUpload').on('change', async function() {
          let nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
          $('#txtArquivoImportar').val(nomeAnexo);

          let file = document.getElementById('mdModalUpload').files[0];
          let reader = new FileReader();
          dados = leArquivoExcel(reader, file, nomeAnexo);
        });

        $('#btnArquivoImportar').off('click');
        $('#btnArquivoImportar').on('click', function(e) {
          e.preventDefault();
          $('#mdModalUpload').trigger('click');
        });
      });



      $('#btn_limpar_presente').on('click', async function() {
        if ($('#tabelaPresente tr').length > 0) {
          $('#tabelaPresente').DataTable().clear().draw(false);
        }

        let saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
        $('#txtValorVendaCartaoPresente').val(saldo_a_pagar.toFixed(2));
        $('#txtValorAPagarCartaoPresente').val(saldo_a_pagar.toFixed(2));
        $('#txtValorCartaoPresente').val(0);
        await atualizaSaldoCartaoPresente();
        $('#txtNumeroCartao').trigger('click');
        $('#txtNumeroCartao').focus();
      });

      $('#btn_confirmar_presente').on('click', async function() {
        await RotinaConfirmarCartaoPresente();
      });

      async function RotinaConfirmarCartaoPresente() {
        if ($('#tabelaPresente').DataTable().rows().data()[0] == undefined) {
          msgErro('Nenhum cartão presente utilizado, verifique');
          return;
        }

        $('#modalPresente').modal('hide');
        var valor_utilizado = parseFloat(parseFloat($('#tabelaPresente').DataTable().column(4, {}).data().sum()).toFixed(2));
        $('#txtValorParcela').val(valor_utilizado);
        await RotinaAddCondicaoPagamento();
      }

      $('#closeModalAntecipacoes').on('click', () => {
        $('#btn-limpa-moeda').trigger('click');
        const saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
        $('#txtValorParcela').val(saldo_a_pagar.toFixed(2));
        $('#txtValorLiquidoMoeda').val(saldo_a_pagar.toFixed(2));
      });

      async function buscaCartaoPresente(sCartaoPresente) {
        var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
        var _params = `JSON={ "tabela":"receber", "camposSelect":["numero", "cartao_presente", "valor2 valor", "valor_pago valor_utilizado", "0 valor_a_utilizar"],
                                      "where": ["RECEBER.CARTAO_PRESENTE = '${sCartaoPresente}'"]}`;
        var dataSet = [];
        var dataSetCols = [];
        try {
          try {
            $.LoadingOverlay("show");
            var response = await requisicao('GET', _url, _params, null, 20000);

            if (!response) {
              return;
            }

            var jsonStr = await response.json()
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return;
            }

            if (!$.isEmptyObject(jsonStr['RESULT'][0])) {
              dataSet = jsonStr['RESULT'][0];
              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }

              $('#tabelaPresente').DataTable({
                paging: false,
                filter: false,
                info: false,
                autoWidth: true,
                destroy: true,
                "columns": dataSetCols
              });

              vSaldo = ArredondarValor(parseFloat($('#txtValorSaldoCartaoPresente').val()), 2);

              if ((dataSet[0].VALOR - dataSet[0].VALOR_UTILIZADO) <= 0) {
                msgErro('Cartão presente já baixado, verifique');
                return;
              }

              if ($('#tabelaPresente').DataTable().column(1).data().indexOf(sCartaoPresente) >= 0) {
                msgErro('Cartão presente já adicionado, verifique.');
                return;
              }

              if ((vSaldo > 0) && (vSaldo < ArredondarValor((dataSet[0].VALOR - dataSet[0].VALOR_UTILIZADO), 2))) {
                dataSet[0].VALOR_A_UTILIZAR = vSaldo;
              } else if (vSaldo == 0) {
                msgErro('Não há mais saldo disponível para ser utilizado, verifique');
                return;
              } else {
                dataSet[0].VALOR_A_UTILIZAR = ArredondarValor((dataSet[0].VALOR - dataSet[0].VALOR_UTILIZADO), 2);
              }
              $('#tabelaPresente').DataTable().row.add(dataSet[0]).draw(false);

              $('#txtValorCartaoPresente').val(dataSet[0].VALOR.toFixed(2));
              atualizaSaldoCartaoPresente();

            }
          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar o cartão presente.');
          }
        } finally {
          $.LoadingOverlay("hide");
          $('#txtNumeroCartao').val('');
          $('#txtNumeroCartao').focus();
        }
      }

      async function RetornaVendasPendentes() {
        var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
        var separador = "' - '";
        let iEmp_ID = getCookie('emp_id');
        var _params =
          `JSON={ 
                  "tabela":"venda",
                  "camposSelect":[
                                  "venda.codven venda",
                                  "venda.codcli|| ${separador}||entidade.nome cliente",
                                  "venda.nrcaixa",
                                  "venda.codrep || ${separador}||represen.nome vendedor",
                                  "CAST(VENDA.TIPO_VENDA AS VARCHAR(10)) || ${separador}||venda_tipo.descricao tipo_venda",
                                  "venda.data",
                                  "sum(itvenda.quantidade) qtde_itens",
                                  "venda.valor",
                                  "vendaobs.observacao"
                                 ], 
                "leftjoin": [
                             {"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}, 
                             {"tabela" : "vendaobs", "condicao" : "vendaobs.codven = venda.codven"},
                             {"tabela" : "itvenda", "condicao" : "itvenda.codven = venda.codven and itvenda.emp_id = venda.emp_id"},
                             {"tabela" : "represen", "condicao" : "venda.codrep = represen.codrep"}, 
                             {"tabela" : "venda_tipo", "condicao" : "venda_tipo.id = venda.tipo_venda"}
                            ], 
                "groupby": [
                  "venda.codven",
                  "venda.codcli",
                  "entidade.nome",
                  "venda.fechada",
                  "venda.nrcaixa",
                  "venda.data",
                  "venda.valor",
                  "venda.fechada",
                  "venda.cancelada",
                  "venda.troca",
                  "venda.devolucao",
                  "venda.orcamento",
                  "venda.impresso",
                  "venda.emp_id",
                  "venda.codrep",
                  "represen.nome",
                  "vendaobs.observacao",
                  "venda.tipo_venda",
                  "venda_tipo.descricao"],
                 "orderby": [
                             "venda.codven desc"
                            ],
                 "where": [
                           "VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0 AND VENDA.EMP_ID = ${iEmp_ID}"
                          ], 
                 "CamposBlob": ["vendaobs.observacao"]}`;
        var dataSet = [];
        var dataSetCols = [];
        try {
          try {
            $.LoadingOverlay("show");
            var response = await requisicao('GET', _url, _params, null, 20000);

            if (!response) {
              return;
            }

            var jsonStr = await response.json()
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return;
            }

            if (!$.isEmptyObject(jsonStr['RESULT'][0])) {
              dataSet = jsonStr['RESULT'][0];
              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k]
                });
              }

              dataSetCols[5].type = 'date-br';
              dataSetCols[5].render = function(data, type, row) {
                //alert(navigator['userAgent'])
                var isIE = function() {
                  if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                      'userAgent']) == true) {
                    return true;
                  } else {
                    return false;
                  }
                }
                if (isIE()) {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0];
                } else {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0];
                  return $.datepicker.formatDate("dd/mm/Y", new Date(data));
                }
              }

              tabelaVendasPendentes = $('#tabelaVendasPendentes').DataTable({
                paging: true,
                filter: true,
                info: true,
                order: false,
                autoWidth: true,
                destroy: true,
                key: true,
                "columns": dataSetCols,
                "data": dataSet,
                "columnDefs": [{
                    "render": function(data) {
                      return parseFloat(data).toLocaleString("pt-BR", {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 2
                      })
                    },
                    "targets": [7],
                    "className": 'pr-4 text-right'
                  },
                  {
                    "targets": 6,
                    "className": 'pr-4 text-right'
                  }
                ]
              });

              $('#tabelaVendasPendentes tbody').on('click', 'tr', async function() {
                $("#tabelaVendasPendentes tbody tr td")[0].click();
                tabelaVendasPendentes.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');

                var data = tabelaVendasPendentes.row($(this)).data();
                $('#txtPrecoProduto').text(quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(data['PRECO'], quantidadeCasasDecimaisCampo)) :
                  mostra2Casas(data['PRECO']));
                $('#txtQtdeProduto').text(data['QTDE']);

                $('#btn_confirmar_venda_pendente').unbind('click');
                $('#btn_confirmar_venda_pendente').on('click', async function() {
                  if ($('#tabelaVendasPendentes tr.selected').length == 0) {
                    msgErro('Selecione uma venda pendente para conseguir confirmar.');
                    return;
                  }
                  verificaSaidaVenda(data['VENDA']);
                });

                $('#tabelaVendasPendentes tbody').unbind('dblclick');
                $('#tabelaVendasPendentes tbody').on('dblclick', 'tr', async function() {
                  verificaSaidaVenda(data['VENDA']);
                });

              });


            }
          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as vendas pendentes.');
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      async function verificaSaidaVenda(iVenda) {
        var possuiItens = $('#tabelaItens').DataTable().rows().count();
        var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
        if (possuiItens > 0) {
          msgConfirmacao(
            `${possuiItens ? `Venda <span style="color:green">${$('#txt_venda_atual>span').html()}</span> possui itens.<br>` : ''} Escolha uma das opções abaixo: `,
            [
              async function() {
                if ((numero_venda != 'create') && (numero_venda != 'create#')) {
                  await deletaRegistro('LOJA', getCookie('usuario'), numero_venda);
                }
                await deletaVendaNaoSalva(hostname + '.txt');
                var vendaLiberada = await liberarVenda(iVenda);
                const chave = (numero_venda != 'create') && (numero_venda != 'create#') ? numero_venda : 'NOVA';
                await rotinaGeraLog('VENDA', chave, `USUARIO ${getCookie('usuario')} desistiu da venda ${chave}, para o cliente ${pegaChave('#txtCliente')}, no valor de ${$("#subtotal_venda").html()}.`);
                if (vendaLiberada) {
                  window.location.href = "<?php echo BASE_URI; ?>/venda/" + iVenda;
                } else {
                  msgErro(`Venda ${iVenda} já está em alteração, impossível continuar.`);
                  return;
                }
              }, async function() {
                await RotinaFinalizarVenda(false, false, true);
                await deletaVendaNaoSalva(hostname + '.txt');
                var vendaLiberada = await liberarVenda(iVenda);
                if (vendaLiberada) {
                  window.location.href = "<?php echo BASE_URI; ?>/venda/" + iVenda;
                } else {
                  msgErro(`Venda ${iVenda} já está em alteração, impossível continuar.`);
                  return;
                }
              }
            ]);
        } else {
          await deletaVendaNaoSalva(hostname + '.txt');
          var vendaLiberada = await liberarVenda(iVenda);
          if (vendaLiberada) {
            window.location.href = "<?php echo BASE_URI; ?>/venda/" + iVenda;
          } else {
            msgErro(`Venda ${iVenda} já está em alteração, impossível continuar.`);
            return;
          }
        }
      }

      async function addBandeira(moeda = "") {
        const dados = await RetornaBandeiras(moeda);
        if (dados.length > 0 && $("#select_bandeira").children("option").length > 0) {
          $("#select_bandeira").empty().trigger("change");
          $("#select_bandeira").append(`<option value="">
                                                     Selecione uma bandeira
                                                  </option>`)
        }
        for (const bandeira of dados) {
          const optionText = bandeira.DESCRICAO;
          const optionValue = bandeira.DESCRICAO;
          $('#select_bandeira').append(`<option value="${optionValue}">
                                                     ${optionText}
                                                  </option>`);

        }
      }

      $('#txtBarra').blur(async function() {
        if ($('#txtBarra').val() != '') {
          $('#btnConsultarPreco').trigger('click')
        }
      });

      $('#txtCodigoProd').keydown(function(e) {
        if (e.which === 13) {
          e.preventDefault();
          $('#txtCodigoProd').trigger('blur');
          $('#tabelaItens tbody').trigger('click');
          $('#txtCodigoProd').focus();
        }
      });

      $('#btnConsultarPreco').on('click', async function() {
        if (($("#txtDescricaoProd").val() != "") || ($('#txtCodigoProd').val().toString() != '')) {
          await buscaPreco(false)
          $("#tabelaEstoquePreco tbody tr")[0].click();
        }

        if ($('#txtBarra').val() != '') {
          await buscaPreco(true);
          $('#txtBarra').focus();
        }
      })

      $('#rgPrazo').change(async function() {
        await recalculaPrecoTabela();
      });

      let emp_id = getCookie('emp_id');

      if (listaMoedasEmpresa.length > 0) {
        $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${listaMoedasEmpresa.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND'], callbackSaidaMoeda);
        $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasEmpresa.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
      } else {
        $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND'], callbackSaidaMoeda);
        $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
      }

      // autocompleta

      let sWhere = [];
      const parametroVenda65 = await CopiaParametro('VENDA', 65) == '2';
      if (parametroVenda65) {
        sWhere.push(`ENTIDADE.TIPO_ENTIDADE LIKE '[PERCENTUAL]C[PERCENTUAL]'`);
      }

      const selectTxtCliente = {
        tabela: "ENTIDADE",
        camposSelect: ["CODCLI CHAVE", "NOME ||' - '|| CNPJ DESCRICAO", "CNPJ"],
        where: parametrosVenda[65] == '1' ? ["ENTIDADE.TIPO = '1' AND ENTIDADE.CONS_FINAL = 'Sim'"] : sWhere
      }

      const selectBtnCliente = {
        tabela: "ENTIDADE",
        camposSelect: ["CODCLI", "NOME", "FANTASIA", "CNPJ"],
        where: parametrosVenda[65] == '1' ? ["ENTIDADE.TIPO = '1' AND ENTIDADE.CONS_FINAL = 'Sim'"] : sWhere
      }

      const selectBtnClienteLoja = {
        tabela: "ENTIDADE",
        camposSelect: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME CIDADE", "CADCEP.ESTCEP"],
        leftJoin: [{
            tabela: "CADCEP",
            condicao: "CADCEP.CEP = ENTIDADE.CEP"
          },
          {
            tabela: "CIDADE",
            condicao: "CIDADE.CODIGO = CADCEP.CODMUN"
          }
        ],
        where: parametrosVenda[65] == '1' ? ["ENTIDADE.TIPO = '1' AND ENTIDADE.CONS_FINAL = 'Sim'"] : sWhere,
        camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
      }

      if (parametrosVenda[51] == 1) {
        selectTxtCliente.innerJoin = [{
          tabela: 'EMP_VALOR',
          condicao: `EMP_VALOR.TABELA = 'ENTIDADE' AND EMP_VALOR.VALOR = ENTIDADE.CODCLI AND EMP_VALOR.EMP_ID = ${emp_id}`
        }];

        selectBtnCliente.innerJoin = [{
          tabela: 'EMP_VALOR',
          condicao: `EMP_VALOR.TABELA = 'ENTIDADE' AND EMP_VALOR.VALOR = ENTIDADE.CODCLI AND EMP_VALOR.EMP_ID = ${emp_id}`
        }];

        selectBtnClienteLoja.innerJoin = [{
          tabela: 'EMP_VALOR',
          condicao: `EMP_VALOR.TABELA = 'ENTIDADE' AND EMP_VALOR.VALOR = ENTIDADE.CODCLI AND EMP_VALOR.EMP_ID = ${emp_id}`
        }];

      }
      // AUTOCOMPLETA MODAL CLIENTE => FOI ADICIONADO NESSA PAGE DEVIDO AO IMPORT DA LIB SELECT2 NÃO FUNCIONAR NO MODAL
      $('#txtMoedaModal').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');

      $('#txtTabelaDesc').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
      $('#txtTabela').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
      $('#txtTabPrecoBrinde').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
      $('#txtTabelaImpVenda').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
      $('#txtStatus').autocompleta(1, `JSON={ "tabela":"sitprod", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["((TIPO = 'VEN') or (TIPO IS NULL) or (TIPO = ''))"] }`);
      $('#txtGuia').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S'", "grupo_rep = 'U'"]}`);
      $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"tabtran", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S'"]}`);
      $('#txtVendedorItem').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S'"] }`);
      $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
      $('#txt-cliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": [] }`, ['#txt-cnpj'], ['CNPJ'], ['CNPJ']);
      $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
      $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelasCondPagto'], ['NRPAR'], ['NRPAR']);
      $('#txtNaturezaNFCE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
      $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
      $('#txtNaturezaBrindeNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
      $('#txtClienteNFE').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
      $('#txtClienteBrindeNFE').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
      $('#txtVenda').autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "venda.codven chave", "(venda.codcli || ${sSeparador} ||entidade.nome) descricao" ], "leftjoin":[{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}], "where": ["venda.emp_id = ${emp_id}"]}`);

      const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));
      $("#txtOperacaoNota").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${sWhereOperFiscal} }`);
      $("#txtOperacaoBrindeNFE").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${sWhereOperFiscal} }`);
      $("#txtOperacaoNfce").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${sWhereOperFiscal} }`);

      let casePEmps, caseP, caseFEmps, caseF, offEmps, off;

      casePEmps = {
        tabela: "PEDIDO",
        camposSelect: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        leftJoin: [{
          tabela: "ENTIDADE",
          condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
        }, {
          tabela: "PED_ITEN",
          condicao: "PED_ITEN.NUMERO = PEDIDO.NUMERO"
        }],
        where: ["PED_ITEN.QTDE_F = '0'"],
        groupby: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        camposWhereServerSide: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA"]
      }
      caseP = {
        tabela: "PEDIDO",
        camposSelect: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        leftJoin: [{
          tabela: "ENTIDADE",
          condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
        }, {
          tabela: "PED_ITEN",
          condicao: "PED_ITEN.NUMERO = PEDIDO.NUMERO"
        }],
        where: ["PED_ITEN.QTDE_F = '0'", "PEDIDO.EMP_ID = " + emp_id],
        groupby: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        camposWhereServerSide: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA"]
      }
      caseFEmps = {
        tabela: "PEDIDO",
        camposSelect: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        leftJoin: [{
          tabela: "ENTIDADE",
          condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
        }, {
          tabela: "PED_ITEN",
          condicao: "PED_ITEN.NUMERO = PEDIDO.NUMERO"
        }],
        where: ["PED_ITEN.QTDE_F > '0'"],
        groupby: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        camposWhereServerSide: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA"]
      }
      caseF = {
        tabela: "PEDIDO",
        camposSelect: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        leftJoin: [{
          tabela: "ENTIDADE",
          condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
        }, {
          tabela: "PED_ITEN",
          condicao: "PED_ITEN.NUMERO = PEDIDO.NUMERO"
        }],
        where: ["PED_ITEN.QTDE_F > '0'", "PEDIDO.EMP_ID = " + emp_id],
        groupby: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        camposWhereServerSide: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA"]
      }
      offEmps = {
        tabela: "PEDIDO",
        camposSelect: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        leftJoin: [{
          tabela: "ENTIDADE",
          condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
        }, {
          tabela: "PED_ITEN",
          condicao: "PED_ITEN.NUMERO = PEDIDO.NUMERO"
        }],
        where: [],
        groupby: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        camposWhereServerSide: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA"]
      }
      off = {
        tabela: "PEDIDO",
        camposSelect: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        leftJoin: [{
          tabela: "ENTIDADE",
          condicao: "ENTIDADE.CODCLI = PEDIDO.CODCLI"
        }, {
          tabela: "PED_ITEN",
          condicao: "PED_ITEN.NUMERO = PEDIDO.NUMERO"
        }],
        where: ["PEDIDO.EMP_ID = " + emp_id],
        groupby: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"],
        camposWhereServerSide: ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA"]
      }

      let inputSelecionado = 'P';
      let variasEmp = true;

      // Função para aplicar a lógica com base nas seleções dos radios
      function radioTipoPedido() {
        switch (inputSelecionado) {
          case 'P':
            if (variasEmp) {
              $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(casePEmps), 'Pesquisa Pedido Pendente');
              $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": ["PED_ITEN.QTDE_F = '0'"], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);
            } else {
              $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(caseP), 'Pesquisa Pedido Pendente');
              $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": ["PED_ITEN.QTDE_F = '0'", "PEDIDO.EMP_ID = '${emp_id}'"], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);
            }
            break;
          case 'F':
            if (variasEmp) {
              $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(caseFEmps), 'Pesquisa Pedido Faturado');
              $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": ["PED_ITEN.QTDE_F > '0'"], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);
            } else {
              $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(caseF), 'Pesquisa Pedido Faturado');
              $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": ["PED_ITEN.QTDE_F > '0'", "PEDIDO.EMP_ID = '${emp_id}'"], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);
            }
            break;
          default:
            if (variasEmp) {
              $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(offEmps), 'Pesquisa Pedido');
              $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": [], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);
            } else {
              $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(off), 'Pesquisa Pedido');
              $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": ["PEDIDO.EMP_ID = '${emp_id}'"], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);
            }
        }
      }

      radioTipoPedido();


      $('input[name="radioImportacao"]').change(function() {
        inputSelecionado = $('input[name="radioImportacao"]:checked').val();
        radioTipoPedido();
      });


      $('#buscaPedidoOutrasEmpresas').change(function() {
        variasEmp = $(this).is(':checked');
        radioTipoPedido();
      });

      // pesquisa
      $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], JSON.stringify(off), 'Pesquisa Pedido');
      $('#txtPedido').autocompleta(1, `JSON={"tabela": "PEDIDO", "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"], "innerjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}, {"tabela": "PED_ITEN", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO"}], "where": ["PED_ITEN.QTDE_F = '0'"], "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "ENTIDADE.FANTASIA", "PEDIDO.EMP_ID"]}`);

      $('#btn-Tabela').off();

      $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}`, 'Pesquisa Tabela', 'regiao', '', confirmaAlteracaoTabela);
      $('#btnTabPrecoBrinde').pesquisa('#txtTabPrecoBrinde', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}`, 'Pesquisa Tabela', 'regiao');

      $('#btn-TabelaImpVenda').pesquisa('#txtTabelaImpVenda', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao');
      $('#btn-tabela-desc').pesquisa('#txtTabelaDesc', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao');

      $('#btn-status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"sitprod", "camposSelect":[ "codigo", "descricao"], "where": ["((TIPO = 'VEN') or (TIPO IS NULL) or (TIPO = ''))"]}`, 'Pesquisa Status', 'sitprod');
      $('#btn-guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "represen","camposSelect": ["codrep", "nome"],"where": ["ativo = 'S'", "grupo_rep = 'U'"] }`, 'Pesquisa Representante', 'represen');
      $('#btn-transportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "tabtran","camposSelect": ["codigo", "nome"],"where": ["ativo = 'S'"] }`, 'Pesquisa Transportadora', 'tabtran');
      $('#btn-vendedor-item').pesquisa('#txtVendedorItem', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen","camposSelect": ["codrep", "nome"],"where": ["ativo = 'S'"]}`, 'Pesquisa Representante', 'represen');
      $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null, "orderBy": ["nrpar", "codcond"]}', 'Pesquisa Condição de Pagamento', 'condicao');
      $('#btn-CondPagto').pesquisa_array(['#txtCondPagto', '#txtNrParcelasCondPagto'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
      $('#btn-NaturezaNFCE').pesquisa('#txtNaturezaNFCE', 'NATUREZA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": null}', 'Pesquisa Natureza', 'natureza');
      $('#btn-NaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-NaturezaBrindeNFE').pesquisa('#txtNaturezaBrindeNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-ClienteNFE').pesquisa_serverside(['#txtClienteNFE'], ['CODCLI'], ['NOME'], `${JSON.stringify(selectBtnCliente)}`, 'Pesquisa de Cliente');
      $('#btn-ClienteBrindeNFE').pesquisa_serverside(['#txtClienteBrindeNFE'], ['CODCLI'], ['NOME'], `${JSON.stringify(selectBtnCliente)}`, 'Pesquisa de Cliente');
      $('#btnClienteNFCE').pesquisa_serverside(['#txtClienteNFCE', "#txtCpfNFCE"], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `${JSON.stringify(selectBtnCliente)}`, 'Pesquisa de Cliente', () => {
        $("#txtCpfNFCE").val(pegaChave("#txtCpfNFCE"));
      });
      $('#btnCodigoProduto').pesquisa('#txtBarra', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabpreco", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Preço', 'tabpreco');
      $('#btn-venda').pesquisa('#txtVenda', 'CODVEN', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "VENDA","camposSelect": ["venda.codven", "(venda.codcli || ${sSeparador} ||entidade.nome) CLIENTE"],"leftjoin": [{"tabela": "entidade","condicao": "entidade.codcli = venda.codcli"}],"where": ["venda.emp_id = ${emp_id}"],"orderby": ["venda.codven desc"]}`, 'Pesquisa Venda', 'venda');
      $("#btnOperacaoNota").pesquisa("#txtOperacaoNota", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": ${sWhereOperFiscal}}`, "Pesquisa Operação", "oper_fiscal");
      $("#btnOperacaoBrindeNFE").pesquisa("#txtOperacaoBrindeNFE", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": ${sWhereOperFiscal}}`, "Pesquisa Operação", "oper_fiscal");
      $("#btnOperacaoNfce").pesquisa("#txtOperacaoNfce", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": ${sWhereOperFiscal}}`, "Pesquisa Operação", "oper_fiscal");

      let setores = await verificaSetoresUsuarioLogado(getCookie('cod_usuario'));

      if (setores != '') {
        $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["REPRESEN.CODREP CHAVE, REPRESEN.NOME DESCRICAO"], "leftjoin": [{"tabela": "REPSETORES","condicao": "REPRESEN.CODREP = REPSETORES.CODREP"}], "groupBy": ["REPRESEN.CODREP, REPRESEN.NOME"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP != 'U'", "REPSETORES.SETOR IN (${setores})"] }`);
        $('#btn-vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN","camposSelect": ["REPRESEN.CODREP", "REPRESEN.NOME"], "leftjoin": [{"tabela": "REPSETORES","condicao": "REPRESEN.CODREP = REPSETORES.CODREP"}], "groupBy": ["REPRESEN.CODREP, REPRESEN.NOME"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP != 'U'", "REPSETORES.SETOR IN (${setores})"]}`, 'Pesquisa Representante', 'REPRESEN');
      } else {
        $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ATIVO = 'S'", "GRUPO_REP != 'U'"] }`);
        $('#btn-vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN","camposSelect": ["CODREP", "NOME"],"where": ["ATIVO = 'S'", "GRUPO_REP != 'U'"]}`, 'Pesquisa Representante', 'REPRESEN');
      }

      const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
      const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

      if (depositoUsuario != 'null') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${depositoUsuario}}`);
        $('#btn-deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
      } else if (depositosEmpresaLogada != '') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`);
        $('#btn-deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
      } else {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`);
        $('#btn-deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
      }

      if (setores != '') {
        $('#txtVendendorBrinde').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["REPRESEN.CODREP CHAVE, REPRESEN.NOME DESCRICAO"], "leftjoin": [{"tabela": "REPSETORES","condicao": "REPRESEN.CODREP = REPSETORES.CODREP"}], "groupBy": ["REPRESEN.CODREP, REPRESEN.NOME"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP != 'U'", "REPSETORES.SETOR IN (${setores})"] }`);
        $('#btnVendendorBrinde').pesquisa('#txtVendendorBrinde', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN","camposSelect": ["REPRESEN.CODREP", "REPRESEN.NOME"], "leftjoin": [{"tabela": "REPSETORES","condicao": "REPRESEN.CODREP = REPSETORES.CODREP"}], "groupBy": ["REPRESEN.CODREP, REPRESEN.NOME"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP != 'U'", "REPSETORES.SETOR IN (${setores})"]}`, 'Pesquisa Representante', 'REPRESEN');
        $('#txtAcessoVendendorBrinde').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["REPRESEN.CODREP CHAVE, REPRESEN.NOME DESCRICAO"], "leftjoin": [{"tabela": "REPSETORES","condicao": "REPRESEN.CODREP = REPSETORES.CODREP"}], "groupBy": ["REPRESEN.CODREP, REPRESEN.NOME"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP != 'U'", "REPSETORES.SETOR IN (${setores})"] }`);
        $('#btnAcessoVendendorBrinde').pesquisa('#txtAcessoVendendorBrinde', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN","camposSelect": ["REPRESEN.CODREP", "REPRESEN.NOME"], "leftjoin": [{"tabela": "REPSETORES","condicao": "REPRESEN.CODREP = REPSETORES.CODREP"}], "groupBy": ["REPRESEN.CODREP, REPRESEN.NOME"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP != 'U'", "REPSETORES.SETOR IN (${setores})"]}`, 'Pesquisa Representante', 'REPRESEN');
      } else {
        $('#txtVendendorBrinde').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ATIVO = 'S'", "GRUPO_REP != 'U'"] }`);
        $('#btnVendendorBrinde').pesquisa('#txtVendendorBrinde', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN","camposSelect": ["CODREP", "NOME"],"where": ["ATIVO = 'S'", "GRUPO_REP != 'U'"]}`, 'Pesquisa Representante', 'REPRESEN');
        $('#txtAcessoVendendorBrinde').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ATIVO = 'S'", "GRUPO_REP != 'U'"] }`);
        $('#btnAcessoVendendorBrinde').pesquisa('#txtAcessoVendendorBrinde', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "REPRESEN","camposSelect": ["CODREP", "NOME"],"where": ["ATIVO = 'S'", "GRUPO_REP != 'U'"]}`, 'Pesquisa Representante', 'REPRESEN');
      }

      if (depositoUsuario != 'null') {
        $('#txtDepositoBrinde').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${depositoUsuario}}`);
        $('#btnDepositoBrinde').pesquisa('#txtDepositoBrinde', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
      } else if (depositosEmpresaLogada != '') {
        $('#txtDepositoBrinde').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`);
        $('#btnDepositoBrinde').pesquisa('#txtDepositoBrinde', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
      } else {
        $('#txtDepositoBrinde').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`);
        $('#btnDepositoBrinde').pesquisa('#txtDepositoBrinde', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
      }

      $("#txtVendaBrinde").autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "VENDA.CODVEN DESCRICAO" ], "where": ["VENDA.EMP_ID = ${empId}"]}`);
      $("#btnVendaBrinde").pesquisa("#txtVendaBrinde", "CODVEN", "CODVEN", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "VENDA.CODCLI", "ENTIDADE.NOME"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}], "where": ["VENDA.EMP_ID = ${empId}"], "orderby": ["VENDA.CODVEN DESC"]}`, "Pesquisa Venda", "VENDA");

      $("#txtAcessoVendaBrinde").autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "VENDA.CODVEN DESCRICAO" ], "where": ["VENDA.EMP_ID = ${empId}"]}`);
      $("#btnAcessoVendaBrinde").pesquisa("#txtAcessoVendaBrinde", "CODVEN", "CODVEN", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "VENDA.CODCLI", "ENTIDADE.NOME"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}], "where": ["VENDA.EMP_ID = ${empId}"], "orderby": ["VENDA.CODVEN DESC"]}`, "Pesquisa Venda", "VENDA");

      $("#txtClienteBrinde").autocompleta(2, `JSON={ "tabela":"entidade", "camposSelect":[ "entidade.codcli chave", "entidade.nome descricao" ], "where": null}`);
      $("#txtAcessoClienteBrinde").autocompleta(2, `JSON={ "tabela":"entidade", "camposSelect":[ "entidade.codcli chave", "entidade.nome descricao" ], "where": null}`);

      $("#txtAcessoCodigoBrinde").autocompleta(2, `JSON={ "tabela":"ITVENDA_BRINDE", "camposSelect":[ "DISTINCT ITVENDA_BRINDE.DOCTO CHAVE", "ITVENDA_BRINDE.DOCTO DESCRICAO" ], "where": null}`);
      $('#btnAcessoCodigoBrinde').pesquisa('#txtAcessoCodigoBrinde', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ITVENDA_BRINDE", "camposSelect":[ "DISTINCT DOCTO CODIGO", "DOCTO DESCRICAO"], "where": null}`, 'Pesquisa Brinde', 'ITVENDA_BRINDE');

      // limpa os campos
      $("#btnLimpaVendaBrinde").on("click", function() {
        $("#txtVendaBrinde").val("");
      });
      $("#btnLimpaAcessoVendaBrinde").on("click", function() {
        $("#txtAcessoVendaBrinde").val("");
      });
      $("#btnLimpaClienteBrinde").on("click", function() {
        $("#txtClienteBrinde").val("");
      });
      $("#btnLimpaAcessoClienteBrinde").on("click", function() {
        $("#txtAcessoClienteBrinde").val("");
      });
      $("#btnLimpaDepositoBrinde").on("click", function() {
        $("#txtDepositoBrinde").val("");
      });
      $("#btnLimpaVendendorBrinde").on("click", function() {
        $("#txtVendendorBrinde").val("");
      });
      $("#btnLimpaAcessoCodigoBrinde").on("click", function() {
        $("#txtAcessoCodigoBrinde").val("");
      });
      $("#btnLimpaAcessoVendendorBrinde").on("click", function() {
        $("#txtAcessoVendendorBrinde").val("");
      });
      $('#btnACodigoProduto').on('click', function() {
        $('#txtBarra').val('');
      });
      $('#btn-limpa-condicao').on('click', function() {
        $('#txtCondicaoDePagamento').val('');
        $('#txtNrParcelas').val('1');
      });
      $('#btn-limpa-CondPagto').on('click', function() {
        $('#txtCondPagto').val('');
        $('#txtNrParcelasCondPagto').val('');
      });
      $('#btn-limpa-cliente').on('click', function() {
        $('#txtCliente').val('');
        $('#txtCNPJ').val('');
        $('#txtLimiteCreditoCli').val(0);
        $('#txtLimiteCreditoConsignado').val(0);
        $('#txtCashbackCli').val('');
        $('#txtCashbackCliPagto').val(0);
      });
      $('#btnLimpaCliente').on('click', function() {
        $('#txt-cliente').val('');
        $('#txt-cnpj').val('');
      });
      $('#btn-limpa-deposito').on('click', function() {
        $('#txtDeposito').val('');
      });
      $('#btn-limpa-status').on('click', function() {
        $('#txtStatus').val('');
      });
      $('#btn-limpa-vendedor').on('click', function() {
        $('#txtVendedor').val('');
      });
      $('#btn-limpa-vendedor-item').on('click', function() {
        $('#txtVendedorItem').val('');
      });
      $('#btn-limpa-guia').on('click', function() {
        $('#txtGuia').val('');
      });
      $('#btn-limpa-transportadora').on('click', function() {
        $('#txtTransportadora').val('');
      });
      $('#btn-limpa-tabela').on('click', function() {
        $('#txtTabela').val('');
      });
      $('#btnLimpaTabPrecoBrinde').on('click', function() {
        $('#txtTabPrecoBrinde').val('');
      });
      $('#btn-limpa-TabelaImpVenda').on('click', function() {
        $('#txtTabelaImpVenda').val('');
      });
      $('#btn-limpa-NaturezaNFCE').on('click', function() {
        $('#txtNaturezaNFCE').val('');
      });
      $('#btn-limpa-NaturezaNFE').on('click', function() {
        $('#txtNaturezaNFE').val('');
      });
      $('#btn-limpa-NaturezaBrindeNFE').on('click', function() {
        $('#txtNaturezaBrindeNFE').val('');
      });
      $('#btn-limpa-ClienteNFE').on('click', function() {
        $('#txtClienteNFE').val('');
      });
      $('#btn-limpa-ClienteBrindeNFE').on('click', function() {
        $('#txtClienteBrindeNFE').val('');
      });
      $('#btn-limpa-venda').on('click', function() {
        $('#txtVenda').val('');
      });
      $('#btn-limpa-pedido').on('click', function() {
        $('#txtPedido').val('');
      });
      $("#btnAOperacaoNota").on("click", function() {
        $("#txtOperacaoNota").val("");
      });
      $("#btnAOperacaoBrindeNFE").on("click", function() {
        $("#txtOperacaoBrindeNFE").val("");
      });
      $("#btnAOperacaoNfce").on("click", function() {
        $("#txtOperacaoNfce").val("");
      });

      $('#btn-limpa-moeda').on('click', function() {
        $('#txtMoeda').val('');
        $('#txtTipoMoeda').val('');
        $('#txtBaixaAntecipacao').val();
        $('#txtCodCondMoeda').val();
        $('#txtNrParcelas').val('1');
        $("#txtMaxNrParcelasMoeda").val('');
        $('#txtCondicaoDePagamento').prop('disabled', false);
        limpaValor('#txtCondicaoDePagamento');
        $('#btn-CondicaoDePagamento').prop('disabled', false);
        $('#btn-limpa-condicao').prop('disabled', false);
        limpaValor('#txtCodCondMoeda');
        $('#select_bandeira').val('').change();
      });


      $('#txtVendaBrinde').on('blur', async function() {
        if ($(this).val() == '') {
          return;
        }

        const codigoVenda = pegaChave('#txtVendaBrinde');

        const pesquisa = {
          camposSelect: ['VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.CODREP', 'REPRESEN.NOME NOME_VENDEDOR', 'VENDA.TABELA', 'REGIAO.DESCRICAO DESC_TABELA'],
          tabela: 'VENDA',
          leftJoin: [{
              tabela: 'ENTIDADE',
              condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI'
            },
            {
              tabela: 'REPRESEN',
              condicao: 'REPRESEN.CODREP = VENDA.CODREP'
            },
            {
              tabela: 'REGIAO',
              condicao: 'REGIAO.REGIAO = VENDA.TABELA'
            }
          ],
          where: [`VENDA.CODVEN = ${codigoVenda} AND VENDA.EMP_ID = ${getCookie('emp_id')}`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr && jsonStr.length > 0) {
          insereValor('#txtClienteBrinde', jsonStr[0].CODCLI, jsonStr[0].NOME);
          insereValor('#txtVendendorBrinde', jsonStr[0].CODREP, jsonStr[0].NOME_VENDEDOR);
          const tabelaPrecoAtual = $("#txtTabPrecoBrinde").val();
          if (jsonStr[0].TABELA != "" && tabelaPrecoAtual != "" && pegaChave(tabelaPrecoAtual) != jsonStr[0].TABELA) {
            await msgAguardaConfirmacao(`Tabela de preço da venda selecionada ([${jsonStr[0].TABELA}] - ${jsonStr[0].DESC_TABELA}) difere da atual do brinde (${tabelaPrecoAtual}), deseja alterar?`, () => {
              insereValor('#txtTabPrecoBrinde', jsonStr[0].TABELA, jsonStr[0].DESC_TABELA);
            }, () => {});
          } else {
            insereValor('#txtTabPrecoBrinde', jsonStr[0].TABELA, jsonStr[0].DESC_TABELA);
          }
          // insereValor('#txtDepositoBrinde', jsonStr[0].DEPOSITO, jsonStr[0].DESC_DEPOSITO);
        }

      });

      $('#btn-limpa-NumeroCartao').on('click', function() {
        $('#txtNumeroCartao').val('');
        $('#txtValorCartaoPresente').val(0.00);
        $('#txtValorVendaCartaoPresente').val(0.00);
        $('#txtValorAPagarCartaoPresente').val(0.00);
        $('#txtValorSaldoCartaoPresente').val(0.00);
      });

      $('#buscaVendaOutrasEmpresas').on('change', function() {
        if ($('#buscaVendaOutrasEmpresas').is(':checked')) {
          $("#btn-venda").off();
          $("#txtVenda").off();
          $('#btn-venda').pesquisa('#txtVenda', 'CODVEN', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "VENDA","camposSelect": ["venda.codven", "(venda.codcli || ${sSeparador} ||entidade.nome) CLIENTE"],"leftjoin": [{"tabela": "entidade","condicao": "entidade.codcli = venda.codcli"}],"where": ["${!$('#buscaVendaOutrasEmpresas').is(':checked') ? `'venda.emp_id = ${emp_id}'` : '' }"],"orderby": ["venda.codven desc"]}`, 'Pesquisa Venda', 'venda');
          $('#txtVenda').autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "venda.codven chave", "(venda.codcli || ${sSeparador} ||entidade.nome) descricao" ], "leftjoin":[{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}], "where": ["${!$('#buscaVendaOutrasEmpresas').is(':checked') ? `'venda.emp_id = ${emp_id}'` : '' }"]}`);
        } else {
          $("#btn-venda").off();
          $("#txtVenda").off();
          $('#txtVenda').autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "venda.codven chave", "(venda.codcli || ${sSeparador} ||entidade.nome) descricao" ], "leftjoin":[{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}], "where": ["venda.emp_id = ${emp_id}"]}`);
          $('#btn-venda').pesquisa('#txtVenda', 'CODVEN', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "VENDA","camposSelect": ["venda.codven", "(venda.codcli || ${sSeparador} ||entidade.nome) CLIENTE"],"leftjoin": [{"tabela": "entidade","condicao": "entidade.codcli = venda.codcli"}],"where": ["venda.emp_id = ${emp_id}"],"orderby": ["venda.codven desc"]}`, 'Pesquisa Venda', 'venda');
        }
      });

      // $('#buscaPedidoOutrasEmpresas').on('change', function() {
      //   if ($('#buscaPedidoOutrasEmpresas').is(':checked')) {
      //     $('#btn-pedido').off();
      //     $('#txtPedido').unbind('autocompleta');

      //     $('#btn-pedido').pesquisa('#txtPedido',
      //       'NUMERO', 'CLIENTE',
      //       `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PEDIDO",
      //       "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME CLIENTE", "PEDIDO.EMP_ID"],
      //       "leftjoin": [{"tabela": "ENTIDADE","condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
      //       "where": null}`,
      //       'Pesquisa Pedido', 'pedido');

      //     $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where": null}`);
      //   } else {
      //     $('#btn-pedido').off();
      //     $('#txtPedido').unbind('autocompleta');

      //     $('#btn-pedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'],
      //       `{"tabela":"PEDIDO", 
      //       "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME", "PEDIDO.EMP_ID"], 
      //       "leftjoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}],
      //       "where": ["PEDIDO.EMP_ID = '${emp_id}'"]}`,
      //       'Pesquisa Pedido', 'PEDIDO');

      //     $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":["PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where": ["${!$('#buscaPedidoOutrasEmpresas').is(':checked') ? `PEDIDO.EMP_ID = '${emp_id}'` : '' }"]}`);
      //   }
      // });

      async function atualizaSaldoCartaoPresente() {
        var saldo = parseFloat($('#txtValorVendaCartaoPresente').val()) - parseFloat($('#txtValorCartaoPresente')
          .val());
        $('#txtValorSaldoCartaoPresente').val(saldo.toFixed(2));
        if ($('#tabelaPresente tr td').length > 0) {
          var total_cartao_presente = parseFloat(parseFloat($('#tabelaPresente').DataTable().column(2, {}).data()
            .sum()).toFixed(2));
          var total_cartao_presente_pago = parseFloat(parseFloat($('#tabelaPresente').DataTable().column(3, {})
            .data().sum()).toFixed(2));
          var saldo_cartao_presente = parseFloat($('#txtValorVendaCartaoPresente').val()) - (
            total_cartao_presente - total_cartao_presente_pago);
          if (saldo_cartao_presente < 0) {
            saldo_cartao_presente = 0;
          }
          $('#txtValorSaldoCartaoPresente').val(saldo_cartao_presente.toFixed(2));
        }
      }

      $('#txtNumeroCartao').on('blur', async function() {
        if ($(this).val() != '') {
          await buscaCartaoPresente($(this).val());
        }
      });

      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false,
        onHighlightStarted: (Element) => {
          if ((Element.node.id == 'btnInfo') || (Element.node.id == 'fieldset_info')) {
            if ($('#fieldset_info').css('display') == 'none') {
              RotinaCliqueInfo();
            }
          } else
          if ((Element.node.id == 'btnVenda') || (Element.node.id == 'addProdutoTour')) {
            if ($('#fieldset_venda').css('display') == 'none') {
              RotinaCliqueVenda();
            }
          } else
          if (Element.node.id == 'btnPagamento') {
            if ($('#fieldset_pagamento').css('display') == 'none') {
              RotinaCliquePagamento();
            }
          } else
          if (Element.node.id == 'btn-sair') {
            if (!$('.navbar-toggler').hasClass('collapsed')) {
              $('#abrirTelaCheia').trigger('click');
            }
          }
        },
        onPrevious: (Element) => {
          if (Element.node.id == 'btnPagamento') {
            RotinaCliqueVenda();
          }
        }
      });

      async function buscaPrecoTabelaDesconto(regiao, codigo, cor, tam) {
        const bPrecoCorTam = parametrosVenda[5] == "1";
        const obj = bPrecoCorTam ? {
          tabela: 'PRECO_COR_TAM',
          campo: 'PRECO',
          where: `REGIAO = '${regiao}' AND CODIGO = '${codigo}' AND COR = '${cor}' AND TAM = '${tam}'`
        } : {
          tabela: 'TABPRECO',
          campo: `PRECO_${pegaValor('#rgPrazo')} PRECO`,
          where: `REGIAO = '${regiao}' AND CODIGO = '${codigo}'`
        }

        try {
          const pesquisa = {
            tabela: obj.tabela,
            camposSelect: [obj.campo],
            where: [obj.where]
          }
          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          if (jsonStr[0] != undefined) {
            return jsonStr[0].PRECO;
          } else {
            return ''
          }

        } catch (error) {
          console.error(error);
        }
      }

      $('#txtTabelaDesc').on('blur', async () => {
        if ($('#txtTabelaDesc').val() == '') {
          return;
        }
        const id = $('#txtDadosEmAlteracao').attr('data-id');
        const arrDados = $("#tabelaItens").DataTable().row(id).data();
        const codigo = arrDados[0];
        const cor = arrDados[10];
        const tam = arrDados[11];
        const idMatItem = arrDados[14];
        const tabela = pegaChave('#txtTabelaDesc');
        const precoEncontrado = await buscaPrecoTabelaDesconto(tabela, codigo, cor, '');
        if (precoEncontrado != '') {
          $('#txtPrecoDesc').val(precoEncontrado);
          $('#txtPrecoOrig').val(precoEncontrado);
          $('#txtPrecoDesc').trigger('blur');
        } else {
          // não encontrou preço para a nova tabela selecionada...
          if (parametrosVenda[75] == '0') {
            $('#txtIdItemPrecoManual').val(idMatItem);
            $('#txtBarraPrecoManual').val('');
            const informacoesItem = $("#txtProdutoDesc").val() ?? "";
            $("#txtTituloPrecoManual").html(`${informacoesItem}`);
            $('#modalCadPreco').modal('show');
            $.LoadingOverlay("hide");

            $("#txtCodigo").attr("tipoItem", 'M');
            $("#txtCodigo").attr("semFoco", true);
            await eventoClickConfirmarPrecoTrocaTabela('M');
            await sleep(500);
            return;
          } else if (parametrosVenda[75] == '1') {
            msgAlerta(`Item selecionado não cadastrado na tabela de preço ${tabela}`);
            return;
          } else {
            msgErro(jsonStr.mensagem);
            return;
          }
          // msgAlerta('Preço não encontrado na tabela informada, verifique.');
          // $('#txtTabelaDesc').val('');
        }
      });


      $('#tutorial').on('click', function() {
        $(document).ready(async function() {
          if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
            msgAlerta('Venda já possui pagamento informado, impossível continuar.');
            return;
          }
          driver.defineSteps([{
              element: '#btnCancelarVenda',
              popover: {
                title: 'Botão Cancelar',
                description: 'Aqui você pode cancelar uma venda caso o cliente tenha desistido.',
                position: 'top'
              }
            },
            {
              element: '#btnInfo',
              popover: {
                title: 'Botão Informações',
                description: '<b>Passo 1</b>: Aqui você escolhe algumas informações, como cliente, tabela de preço e depósito.',
                position: 'top'
              }
            },
            {
              element: '#fieldset_info',
              popover: {
                title: 'Dados Informações',
                description: 'Aqui você preenche os dados iniciais referente a sua venda.',
                position: 'bottom'
              }
            },
            {
              element: '#btnVenda',
              popover: {
                title: 'Botão Venda',
                description: '<b>Passo 2</b>: Esse botão habilitará a aba de Venda, onde você adicionará os produtos da venda.',
                position: 'top'
              }
            },
            {
              element: '#addProdutoTour',
              popover: {
                title: 'Adicionar Produtos',
                description: 'Aqui você adiciona os produtos, tendo a opção de bipar por código de barras ou selecioná-los manualmente através da pesquisa.',
                position: 'bottom'
              }
            },
            {
              element: '#listaProdutoTour',
              popover: {
                title: 'Lista de Produtos',
                description: 'Aqui você consegue visualizar os produtos adicionados na sua venda, tendo algumas opções disponíveis no botão <b>Opções</b>.',
                position: 'bottom'
              }
            },
            {
              element: '#btnPagamento',
              popover: {
                title: 'Botão Pagamento',
                description: '<b>Passo 3</b>: Esse botão habilitará a aba de Pagamento, onde você tem a opção de fechar a venda informando os meios de pagamento utilizados.<br> <b>OBS</b>: Para deixar a venda pendente, basta finalizar a venda sem adicionar essas informações de pagamento.',
                position: 'top'
              }
            },
            {
              element: '#tour-adicionar-condicoes',
              popover: {
                title: 'Adicionar Condições',
                description: 'Aqui você informa os meios de pagamento utilizados nessa venda.',
                position: 'bottom'
              }
            },
            {
              element: '#tour-condicoes-de-pagamento',
              popover: {
                title: 'Condições de Pagamento',
                description: 'Aqui você visualiza as condições de pagamento já adicionadas nessa venda, tendo algumas opções disponíveis no botão <b>Opções</b>.',
                position: 'bottom'
              }
            },
            {
              element: '#tour-totais',
              popover: {
                title: 'Totalizadores',
                description: 'Aqui ficam alguns totais para lhe auxiliar no fechamento da venda.',
                position: 'top'
              }
            },
            {
              element: await retornaIdBotaoFinalizar(),
              popover: {
                title: 'Botão Finalizar',
                description: await retornaDescricaoBotaoVenda(),
                position: 'top'
              }
            },
            {
              element: '#btn-sair',
              popover: {
                title: 'Botão Sair',
                description: 'Clicando nesse botão você sairá da tela, sendo direcionado a tela principal do módulo loja.<br><b>OBS</b>: Caso não tiver salvo os dados da venda, você estará desistindo da venda, não sendo mais possível recuperar tais informações.',
                position: 'bottom'
              }
            }
          ]);

          // inicior tuor
          driver.start();
          const activeElement = driver.getHighlightedElement();
          //final tour    
        });
      });

      async function retornaIdBotaoFinalizar() {
        let parametro = parametrosVenda[18];
        if ((parametro == 2) || (parametro == 4)) {
          return '#btnCFe'
        } else {
          return '#btnFinalizar'
        }
      }

      async function retornaDescricaoBotaoVenda() {
        let parametro = parametrosVenda[18];
        if ((parametro == 2) || (parametro == 4)) {
          return '<b>Passo 4</b>: Esse botão irá abrir a tela de enviar e confirmar do MFE..';
        } else {
          return '<b>Passo 4</b>: Esse botão irá finalizar a sua venda, efetuando a gravação dos dados e automaticamente iniciando uma nova venda.';
        }
      }

      $('#btn-simulacao').on('click', async function() {
        if ($('#txtCondPagto').val() == '') {
          msgErro('Informe uma forma de pagamento para simular');
          return;
        }
        const codmoeda = pegaChave('#txtMoedaSimulacao');
        const condicao = pegaChave('#txtCondPagto');
        const bCondicaoValida = await validaCondicaoMoeda(codmoeda, condicao);
        if (!bCondicaoValida) {
          return;
        }
        await criaSimulacao();
        // $('#modal-simular').modal('show');
      });

      async function criaSimulacao() {
        var total_parcelas = pegaChave('#txtNrParcelasCondPagto', total_parcelas);
        var valor = parseFloat($('#txt_val_liq').val()).toFixed(2);
        var iCodCondicao = pegaChave('#txtCondPagto', iCodCondicao);
        var vValor = parseFloat(valor / total_parcelas).toFixed(2);
        var arr_venctos = await RetornaVencimentos(iCodCondicao);
        $('#tabela_simula').DataTable().rows()
          .remove()
          .draw(false);
        var dados = [];
        for (let index = 0; index < total_parcelas; index++) {
          dados = {
            "Parcela": index + 1,
            "Vencto": arr_venctos[index],
            "Valor": vValor
          }; //[index + 1, arr_venctos[index], vValor];
          $('#tabela_simula').DataTable().row.add(dados).draw(false);
        }
        // $('#tabela_simula').DataTable({
        //     paging: false,
        //     filter: false,
        //     info: false,
        //     order: false,
        //     destroy: true,
        //     autowidth: true,
        //     "language": {
        //         "sEmptyTable": "Nenhum registro encontrado",
        //         "sInfo": "_TOTAL_ registros",
        //         "sInfoEmpty": " 0 registros",
        //         "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        //         "sInfoPostFix": "",
        //         "sInfoThousands": ".",
        //         "sLengthMenu": "_MENU_ resultados",
        //         "sLoadingRecords": "Carregando...",
        //         "sProcessing": "Processando...",
        //         "sZeroRecords": "Nenhum registro encontrado",
        //         "sSearch": "Pesquisar",
        //         "oPaginate": {
        //             "sNext": "Próximo",
        //             "sPrevious": "Anterior",
        //             "sFirst": "Primeiro",
        //             "sLast": "Último"
        //         },
        //         "oAria": {
        //             "sSortAscending": ": Ordenar colunas de forma ascendente",
        //             "sSortDescending": ": Ordenar colunas de forma descendente"
        //         }
        //     },
        //     "columns": dataSetCols,
        //     data: dados
        // });
      }

      async function buscaValor(tabela, campoSelect, campoCondicao, valorCondicao) {
        const pesquisaParam = {
          tabela: `${tabela}`,
          camposSelect: [`${campoSelect}`],
          where: [`${campoCondicao} = '${valorCondicao}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        if (jsonStr[0] != undefined) {
          return jsonStr[0][campoSelect]
        } else {
          return ''
        }
      }

      async function buscaAuxiliarMaterial(deposito, tabelaPreco) {
        const pesquisaParam = {
          tabela: `DEPOSITO`,
          camposSelect: ['DEPOSITO.CODIGO', 'DEPOSITO.DESCRICAO', 'REGIAO.REGIAO', 'REGIAO.DESCRICAO DESC_REGIAO'],
          leftJoin: [{
            tabela: 'REGIAO',
            condicao: `REGIAO.REGIAO = '${tabelaPreco}'`
          }],
          where: [`DEPOSITO.CODIGO = '${deposito}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        if (jsonStr[0] != undefined) {
          return jsonStr[0];
        } else {
          return '';
        }
      }

      async function carregaTabelaCliente(codcli) {
        let sTabelaTipoLoja = '';
        let sDescricao = '';
        let sTabelaEntidade = '';
        let sValidaTipoTabela = '';

        if (codcli == '') {
          return;
        }

        sTabelaEntidade = await buscaValor('ENTIDADE', 'TABELA', 'CODCLI', codcli);
        sValidaTipoTabela = await buscaValor('REGIAO', 'TIPO', 'REGIAO', sTabelaEntidade)
        if (sValidaTipoTabela == 'L') {
          sDescricao = await buscaValor('REGIAO', 'DESCRICAO', 'REGIAO', sTabelaEntidade);
          insereValor('#txtTabela', sTabelaEntidade, sDescricao);
          recalculaPrecoTabela();
          return;

        } else {
          try {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
              `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI"
              , "CLI_REGIAO.REGIAO"
              , "REGIAO.DESCRICAO"
              , "REGIAO.TIPO"],
              "leftJoin": [
                {"tabela": "CLI_REGIAO","condicao": "ENTIDADE.CODCLI = CLI_REGIAO.CODCLI"},
                {"tabela": "REGIAO","condicao": "CLI_REGIAO.REGIAO = REGIAO.REGIAO"}
              ],
              "where": ["ENTIDADE.CODCLI = '${codcli}'"]}`,
              null);

            if (!response) {
              return;
            }

            const jsonEntidade = await response.json();
            if (response.status != 200) {
              return;
            }
            for (let i = 0; i < jsonEntidade['RESULT'][0].length; i++) {
              if (jsonEntidade.RESULT[0][i].TIPO == 'L') {
                insereValor('#txtTabela', jsonEntidade.RESULT[0][i].REGIAO, jsonEntidade.RESULT[0][i].DESCRICAO);
                recalculaPrecoTabela();
                return;
              }
            }
          } catch (error) {
            console.error(error);
          }
        }
      };

      async function carregaCashback(codcli) {
        if (codcli == '') {
          $('#txtCashbackCli').val('');
          $('#txtCashbackCliPagto').val('');
          return;
        }

        try {
          const response = await requisicao('GET', '/sisplan/cashback/v1/buscar?', `CODCLI=${codcli}`,
            null);

          if (!response) {
            return;
          }

          const jsonCashback = await response.json();
          if (response.status != 200) {
            return;
          }
          const valor = parseFloat(jsonCashback.valor).toLocaleString('pt-BR', {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          });
          const pontos = parseFloat(jsonCashback.pontos).toLocaleString('pt-BR', {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          });
          cashbackCliente.pontos = jsonCashback.pontos;
          cashbackCliente.valor = jsonCashback.valor;
          cashbackCliente.perc_max = jsonCashback.perc_max
          $('#txtCashbackCli').val('R$ ' + valor);
          $('#txtCashbackCliPagto').val(parseFloat(valor.replaceAll('.', '').replaceAll(',', '.')).toFixed(2));

        } catch (error) {
          console.error(error);
          $('#txtCashbackCli').val(0);
          $('#txtCashbackCliPagto').val(0);
        }
      };

      async function verificaCliente(codcli) {
        if (codcli == '') {
          return;
        }

        try {
          let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
            `JSON={ "tabela":"ENTIDADE", "camposSelect":["ativo", "bloqueio"],"where": ["codcli = '${codcli}'"]}`,
            null);

          if (!response) {
            return;
          }

          let jsonEntidade = await response.json();
          if (response.status != 200) {
            jsonEntidade['RESULT'][0].mensagem;
            return;
          }
          if (jsonEntidade['RESULT'][0][0].BLOQUEIO == 'S') {
            msgAlerta('Cliente bloqueado, deseja desbloquear?', () => {
                senhaSupervisor('Desbloquear cliente', async () => {
                  await alterarBloqueioCliente(codcli, false, "VENDA");
                  $('#txtCliente').focus();
                }, '', false, () => {
                  $('#txtCliente').val(''), $('#txtCNPJ').val('')
                }, () => {
                  $('#txtCliente').val(''), $('#txtCNPJ').val('')
                }, () => {
                  $('#txtCliente').val(''), $('#txtCNPJ').val('')
                }, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0)
              }, () => {
                $('#txtCliente').val(''), $('#txtCNPJ').val('')
              }, undefined,
              () => {
                $('#txtCliente').val(''), $('#txtCNPJ').val('')
              });
            return false;
          } else if (jsonEntidade['RESULT'][0][0].ATIVO == 'N') {
            msgAlerta('Cliente inativo, impossível continuar.');
            $('#txtCliente').val('');
          }
          return true;
        } catch (error) {
          console.error(error);
        }
      };

      async function verificaClientePagamento(codcli) {
        try {
          let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
            `JSON={ "tabela":"ENTIDADE", "camposSelect":["ativo", "bloqueio"],"where": ["codcli = '${codcli}'"]}`,
            null);

          if (!response) {
            return;
          }

          let jsonEntidade = await response.json();
          if (response.status != 200) {
            jsonEntidade['RESULT'][0].mensagem;
            return;
          }
          if (jsonEntidade['RESULT'][0][0].BLOQUEIO == 'S') {
            msgAlerta('Cliente bloqueado, impossível continuar.');
            $('#txt-cliente').val('');
          } else if (jsonEntidade['RESULT'][0][0].ATIVO == 'N') {
            msgAlerta('Cliente inativo, impossível continuar.');
            $('#txt-cliente').val('');
          }
        } catch (error) {
          console.error(error);
        }
      };

      async function BuscaLimiteCreditoOperacional() {
        try {
          $.LoadingOverlay('show')
          let CNPJ = $('#txtCNPJ').val().includes('] -') ? pegaChave('#txtCNPJ') : $('#txtCNPJ').val();
          if (CNPJ.length > 14) {
            CNPJ = CNPJ.replaceAll('.', '')
            CNPJ = CNPJ.slice(0, 8)
          }
          let response = await requisicao('POST',
            '/sisplan/operacional/v1/limitecredito?',
            `CODIGO=${CNPJ}`,
            '',
            300000);

          if (!response) {
            return;
          }

          let json = await response.json();

          if (json.statusCode != 200) {
            throw msgAlerta(json.Message);
            return;
          }

          return {
            json,
            raiz: CNPJ
          }

        } catch (error) {
          console.log(error)
        } finally {
          $.LoadingOverlay('hide')
        }
      }

      async function AtualizaValorCreditoGrupo(ValorCredito, Raiz) {
        // const grupoEntidade = await buscaValor('GRUPO_CLI', 'CODIGO', 'COD_IMPORTADO', Raiz)
        const grupoEntidade = await buscaValor('ENTIDADE', 'GRUPO', 'CODCLI', pegaChave('#txtCliente'))
        const controleLimiteCredito = await buscaValor('GRUPO_CLI', 'LIMITE_GRUPO', 'CODIGO', grupoEntidade)
        // if (!grupoEntidade) {
        //   $('#txtCliente').val('')
        //   throw msgAlerta('Cliente não pertence a nenhum grupo de cliente.')
        // }

        if (controleLimiteCredito === 'S') {
          try {
            let grupoClienteClasse = {};
            grupoClienteClasse.CODIGO = grupoEntidade;
            grupoClienteClasse.VAL_CREDITO = ValorCredito

            let response = await requisicao('PUT', '/Sisplan/Cadastros/v1/grupocliente?', `JSON=${JSON.stringify(grupoClienteClasse)}`, null);

          } catch (error) {
            console.log(error)
          }
        }
      }

      function bVerificaCNPJ() {
        let CNPJ = $('#txtCNPJ').val().includes('] -') ? pegaChave('#txtCNPJ') : $('#txtCNPJ').val();
        if (CNPJ.length <= 14) {
          return false
        } else {
          return true
        }
      }
      async function carregaLimiteCredito(sCodCli) {
        if (await buscaIni('OPERACIONAL', 'SERVIDOR') && bVerificaCNPJ()) {
          try {
            const operacional = await BuscaLimiteCreditoOperacional()
            let valorLimite = operacional.json.data.vllimite < 0 ? 0 : parseFloat(operacional.json.data.vllimite).toFixed(2);
            $('#txtLimiteCreditoConsignado').val(valorLimite);
            await AtualizaValorCreditoGrupo(valorLimite, operacional.raiz)
            console.log(operacional.json.data)
          } catch (error) {
            console.log(error)
            $('#txtLimiteCreditoCli').val(0);
            $('#txtLimiteCreditoConsignado').val(0);
          }
        } else {
          $('#txtLimiteCreditoCli').attr('title', '');
          const iEmpId = getCookie('emp_id');
          const _url = `/sisplan/funcoes/v1/pesquisa?`;
          try {
            if (controleLimiteCredito == '1') {
              const response = await requisicao('GET', _url, encodeURIComponent(
                `JSON={ 
                  "tabela":"ENTIDADE", 
                  "camposSelect":["VENDA_TIPO.CONSIGNADO, ENTIDADE.CREDITO, ENTIDADE.LIMITE_FID, ENTIDADE.DT_VALID_LIMITE, (SUM(RECEBER.VALOR2+RECEBER.JUROS-RECEBER.VALOR_PAGO-RECEBER.VAL_DEV-RECEBER.DESCONTO)) AS ABERTO"], 
                  "leftJoin": [
                    {"tabela" : "RECEBER", "condicao" : "ENTIDADE.CODCLI = RECEBER.CODCLI AND RECEBER.STATUS = 'DUPL' AND RECEBER.SITUACAO <> 'P'"},
                    {"tabela" : "VENDA", "condicao" : "VENDA.CODVEN = RECEBER.NRO_CUPOM AND VENDA.EMP_ID = RECEBER.EMP_ID"},
                    {"tabela" : "VENDA_TIPO", "condicao" : "VENDA_TIPO.ID = VENDA.TIPO_VENDA"},
                    {"tabela" : "MOEDA", "condicao": "MOEDA.CODMOE = RECEBER.MOEDA AND MOEDA.CONT_LIM_FAT = 'S'"}
                  ],  
                  "where": ["ENTIDADE.CODCLI = '${sCodCli}'"], 
                  "groupBy": ["VENDA_TIPO.CONSIGNADO, ENTIDADE.CREDITO, ENTIDADE.LIMITE_FID, ENTIDADE.DT_VALID_LIMITE"]
               }`
              ), null);

              if (!response) {
                return;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }

              const dados = jsonStr['RESULT'][0][0];
              if (!dados) {
                $('#txtLimiteCreditoCli').val(0);
                $('#txtLimiteCreditoConsignado').val(0);
                $('#txtVendaEmAberto').val(0);
                $('#txtConsignadoEmAberto').val(0);
                return;
              }

              let valorConsig = 0;
              let valorVenda = 0;
              jsonStr['RESULT'][0].forEach(item => {
                if (item.CONSIGNADO == 'S') {
                  valorConsig += item.ABERTO;
                } else {
                  valorVenda += item.ABERTO;
                }
              })

              $('#txtLimiteCreditoCli').val(parseFloat(dados.LIMITE_FID - valorVenda).toFixed(2));
              $('#txtLimiteCreditoConsignado').val(parseFloat(dados.CREDITO - valorConsig).toFixed(2));
              $('#txtVendaEmAberto').val(valorVenda.toFixed(2));
              $('#txtConsignadoEmAberto').val(valorConsig.toFixed(2));
              const validade = `Data validade crédito ${formataDataBonita(!dados.DT_VALID_LIMITE ? '1899-12-30' : dados.DT_VALID_LIMITE)}. Este campo busca o valor do campo (Limite Disponível) do cadastro do Cliente, somente quando: 1- No cadastro de Histórico, o histórico (da duplicata) está com o check (Utiliza no Limite de Crédito) marcado. 2- No cadastro da Moeda, a moeda (da duplicata) está com o check (Controla limite de crédito na venda/faturamento) marcado. Caso contrário, busca o valor do campo (Limite Crédito) do cadastro do Cliente.`;
              $('#txtLimiteCreditoCli').attr('title', validade);
            } else {
              var response = await requisicao('GET', _url, encodeURIComponent(
                `JSON={ 
                  "tabela":"entidade", 
                  "camposSelect":["ENTIDADE.CREDITO, ENTIDADE.CRED_CONSIGNADO, COALESCE(GRUPO_CLI.VAL_CREDITO, 0) CREDITO_GRUPO_CLI, PEDIDO.VALOR_PEDIDOS_PENDENTES, HISTCP.CREDITO_GRUPO, ENTIDADE.LIMITE_FID, ENTIDADE.DT_VALID_LIMITE, (SUM(RECEBER.VALOR2+RECEBER.JUROS-RECEBER.VALOR_PAGO-RECEBER.VAL_DEV-RECEBER.DESCONTO)) AS ABERTO"], 
                  "leftJoin": [
                    {"tabela" : "receber", "condicao" : "entidade.codcli = receber.codcli AND RECEBER.STATUS IN ('DUPL', 'CHEQ') AND receber.HISTORICO IN (SELECT HISTCP1.HISTORICO FROM HISTCP_001 HISTCP1 WHERE HISTCP1.LIMITE_CREDITO = 'S')  AND RECEBER.SITUACAO <> 'P'"},
                    {"tabela" : "histcp", "condicao" : "entidade.historico = histcp.historico"},
                    {"tabela" : "MOEDA", "condicao": "MOEDA.CODMOE = RECEBER.MOEDA AND MOEDA.CONT_LIM_FAT = 'S'"},
                    {"tabela" : "GRUPO_CLI", "condicao" : "GRUPO_CLI.CODIGO = ENTIDADE.GRUPO"},
                    {"tabelaSelect" : "(SELECT COALESCE(SUM((CAST(PED_ITEN.QTDE AS NUMERIC(18,3))) * (CAST(PED_ITEN.PRECO AS NUMERIC(18,3)))), 0) VALOR_PEDIDOS_PENDENTES FROM [PED_ITEN] PED_ITEN WHERE PED_ITEN.NUMERO IN (SELECT NUMERO FROM [PEDIDO] PEDIDO WHERE CODCLI = '${sCodCli}') AND COALESCE((PED_ITEN.QTDE) * (PED_ITEN.PRECO),0) > 0) ", "alias": "PEDIDO", "condicao": "1=1 "}
                  ],  
                  "where": ["ENTIDADE.CODCLI = '${sCodCli}'"], 
                  "groupBy": ["ENTIDADE.CREDITO, GRUPO_CLI.VAL_CREDITO, ENTIDADE.CRED_CONSIGNADO, PEDIDO.VALOR_PEDIDOS_PENDENTES, HISTCP.CREDITO_GRUPO, ENTIDADE.LIMITE_FID, ENTIDADE.DT_VALID_LIMITE"]
               }`
              ), null);

              if (!response) {
                return;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }

              const dados = jsonStr['RESULT'][0][0];
              if (!dados) {
                $('#txtLimiteCreditoCli').val(0);
                $('#txtLimiteCreditoConsignado').val(0);
                return;
              }

              const creditoGrupoAConsiderar = dados.CRED_CONSIGNADO == 0 ? dados.CREDITO_GRUPO_CLI : dados.CRED_CONSIGNADO;
              let credConsig = dados.CREDITO_GRUPO == 'S' ? creditoGrupoAConsiderar - dados.ABERTO : creditoGrupoAConsiderar;
              credConsig = ((dados.CREDITO != 0) && ((dados.CREDITO - dados.ABERTO) < credConsig)) ? dados.CREDITO - dados.ABERTO : credConsig;
              credConsig = (dados.CREDITO == 0 && dados.CREDITO_GRUPO != 'S') ? dados.CREDITO : credConsig;
              if ((somarPedidosPendentesCreditoGrupo) && (dados.CREDITO_GRUPO == 'S')) {
                credConsig = credConsig - dados.VALOR_PEDIDOS_PENDENTES
              }

              const validade = `Data validade crédito ${formataDataBonita(!dados.DT_VALID_LIMITE ? '1899-12-30' : dados.DT_VALID_LIMITE)}. Este campo busca o valor do campo (Limite Disponível) do cadastro do Cliente, somente quando: 1- No cadastro de Histórico, o histórico (da duplicata) está com o check (Utiliza no Limite de Crédito) marcado. 2- No cadastro da Moeda, a moeda (da duplicata) está com o check (Controla limite de crédito na venda/faturamento) marcado. Caso contrário, busca o valor do campo (Limite Crédito) do cadastro do Cliente.`;
              $('#txtLimiteCreditoCli').attr('title', validade);

              if (dados.CREDITO == 0) {
                $('#txtLimiteCreditoCli').val(0);
                if (dados.CRED_CONSIGNADO == 0) {
                  $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
                  return;
                } else {
                  $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
                }
                return;
              } else {
                $('#txtLimiteCreditoCli').val(parseFloat(dados.CREDITO - dados.ABERTO).toFixed(2));
              }

              if (dados.CRED_CONSIGNADO == 0) {
                $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
                return;
              } else {
                $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
              }
            }


          } catch (error) {
            console.error(error);
            $('#txtLimiteCreditoCli').val(0);
            $('#txtLimiteCreditoConsignado').val(0);
          }
        }
      }

      async function validaDataValidadeLimite(sCodCli) {
        if (parametrosVenda[22] == '3') {
          return;
        }

        const url = `/sisplan/cliente/v1/validardatavalidadelimitecredito?`;

        try {
          const response = await requisicao('GET', url, `CODCLI=${sCodCli}`);

          if (!response) {
            throw new Error("Não foi possível verificar a validade do limite de crédito.");
          }

          if (response.status != 200) {
            const json = await response.json();
            throw new Error(json.mensagem);
          }

        } catch (error) {
          console.error(error);
          await aguardaMsgAlerta(error.message, () => {});
        }

      }

      function baixaAntecipacaoOrdemVencimento() {
        for (let i = 0; i < $('.campoCheck').length; i++) {
          if (i == 0) {
            saldo = parseFloat($('#txtValorLiquidoMoeda').val()) //alterado para valor liquido pois ao informar desconto estava baixando a antecipação com o valor bruto
          }
          var indice = $('.campoCheck')[i].closest('tr').rowIndex - 1;
          var data_old = $('#tabelaAntecipacoes').DataTable().row(indice).data();

          if ((data_old.VALOR_UTILIZADO == 0) || (data_old.VALOR_UTILIZADO != saldo)) {
            if (saldo == 0) {
              data_old.VALOR_PAGO = 0;
              data_old.VALOR_UTILIZADO = 0;
              $('#tabelaAntecipacoes').DataTable().row(indice).data(data_old);
            } else
            if ((saldo <= data_old.VALOR) && ((saldo <= (data_old.VALOR - data_old.VALOR_PAGO)))) {
              data_old.VALOR_PAGO = +data_old.VALOR_UTILIZADO + +saldo;
              data_old.VALOR_UTILIZADO = data_old.VALOR_PAGO;
              saldo = 0;
              $('#tabelaAntecipacoes').DataTable().row(indice).data(data_old);
            } else {
              data_old.VALOR_PAGO = data_old.VALOR;
              saldo = saldo - (data_old.VALOR_PAGO - data_old.VALOR_UTILIZADO);
              data_old.VALOR_UTILIZADO = data_old.VALOR;
              $('#tabelaAntecipacoes').DataTable().row(indice).data(data_old).draw(false);
            }
          }
        }
      }

      async function carregaTabelaAntecipacaoAutomatica(dataSet, dataSetCols, dataCondicao) {

        if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {

          if (!$.isEmptyObject(dataCondicao)) {
            const dataAntecipacoes = $('#tabelaAntecipacoes').DataTable().rows().data();
            dataAntecipacoes.map((data, i) => {
              if (!$.isEmptyObject(dataCondicao[i])) {
                if (data.DUPLICATA == dataCondicao[i].duplicata) {
                  data.VALOR_PAGO = ArredondarValor(data.VALOR_PAGO - dataCondicao[i].valor, 2);
                  data.VALOR_UTILIZADO = data.VALOR_PAGO;

                  $('#tabelaAntecipacoes').DataTable().row(i).data(data).draw(false);
                }
              }
            });
          }
          return;
        }

        if (!$.isEmptyObject(dataSet[0])) {
          var keys = Object.keys(dataSet[0]);
          for (var k in keys) {
            dataSetCols.push({
              'title': keys[k],
              'data': keys[k]
            });
          }
          var array_colunas_invisiveis = [6, 7];

          dataSetCols[0].render = function(data, type, row, meta) {
            $('.campoCheck').unbind('change');
            var baixaAntecipacao = pegaChave('#txtBaixaAntecipacao', baixaAntecipacao);
            var sProp = ((row.VALOR_PAGO > 0) && (baixaAntecipacao == 'S')) ? 'checked' : '';

            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input ' + sProp + ' disabled style="height:15px" type="checkbox" id="check_col_' + [meta
                .row
              ] + '_row_' + [meta.col] +
              '" class="input-default focus form-control validate campoCheck"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[2].type = 'date-br';
          dataSetCols[2].render = function(data, type, row) {
            //alert(navigator['userAgent'])
            var isIE = function() {
              if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                  'userAgent']) == true) {
                return true;
              } else {
                return false;
              }
            }
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
            } else {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
              return $.datepicker.formatDate("dd/mm/Y", new Date(data));
            }
          }
          dataSetCols[3].type = 'date-br';
          dataSetCols[3].render = function(data, type, row) {
            //alert(navigator['userAgent'])
            var isIE = function() {
              if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                  'userAgent']) == true) {
                return true;
              } else {
                return false;
              }
            }
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
            } else {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
              return $.datepicker.formatDate("dd/mm/Y", new Date(data));
            }
          }

          $('#div-antecipacoes').removeClass('d-none');
          $('#div-espaco').addClass('d-none');

          var tabelaAntecipacoes = $('#tabelaAntecipacoes').DataTable({
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            "columns": dataSetCols,
            "data": dataSet,
            columnDefs: [{
                targets: array_colunas_invisiveis,
                visible: false,
              },
              {
                "render": function(data) {
                  return parseFloat(data).toLocaleString('pt-BR', {
                    maximumFractionDigits: 2,
                    minimumFractionDigits: 2
                  });
                },
                "targets": [4, 5],
                "className": 'pr-4 text-right'
              }
            ],
          });
          var tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoes').DataTable().column(4, {}).data().sum()).toFixed(2));
          var tot_antecipacao_pago = parseFloat(parseFloat($('#tabelaAntecipacoes').DataTable().column(5, {}).data().sum()).toFixed(2));
          var val_total_itens = $('#tabelaItens').DataTable().column(7, {}).data().sum();
          var saldo_antecipacao = tot_antecipacao - tot_antecipacao_pago;
          var saldo_geral = val_total_itens - saldo_antecipacao;
          if (saldo_geral < 0) {
            saldo_geral = 0;
          }

          var total_itens = $('#tabelaItens').DataTable().column(2, {}).data().sum();
          total_itens = ArredondarValor(total_itens, 2);

          const soma = $('#tabelaItens').DataTable().data().toArray().reduce((total, item) => total + parseFloat(item[3] * item[2]), 0);
          const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
          const total_original = utilizaImpressoraFiscal == 1 && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : parseFloat(parseFloat(soma).toFixed(2));
          const total_desconto = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total + parseFloat(item[6])
          }, 0), 2) * -1;

          $("#total_desc").html(
            parseFloat(isNaN(total_desconto) ? 0 : total_desconto).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );

          $("#total_orig").html(
            parseFloat(isNaN(total_original) ? 0 : total_original).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );
          $('#total_itens').html(total_itens);

          $("#credito_cliente").html(parseFloat(saldo_antecipacao).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $("#saldo_geral").html(parseFloat(saldo_geral).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          await atualizaCreditoConformeUltimaDevolucao();

        } else {
          var val_total_itens = $('#tabelaItens').DataTable().column(7, {}).data().sum();
          $('#div-antecipacoes').addClass('d-none');
          $('#div-espaco').removeClass('d-none');

          var total_itens = $('#tabelaItens').DataTable().column(2, {}).data().sum();
          total_itens = ArredondarValor(total_itens, 2);
          const total_original = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total + parseFloat(item[3] * item[2])
          }, 0), 2);

          const total_desconto = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total + parseFloat(item[6])
          }, 0), 2) * -1;

          $("#total_desc").html(
            parseFloat(isNaN(total_desconto) ? 0 : total_desconto).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );

          $("#total_orig").html(
            parseFloat(isNaN(total_original) ? 0 : total_original).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );
          $('#total_itens').html(total_itens);

          $("#credito_cliente").html(parseFloat(0).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $("#saldo_geral").html(parseFloat(val_total_itens).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $('#tabelaAntecipacoes').DataTable().rows().remove().draw(false);
        }
      }

      $('#modalAntecipacoes').on('shown.bs.modal', function() {
        $('#txtValorParcela').val(ArredondarValor($('#txtValorAntecipacao').html(), 2));
        $('#txtValorLiquidoMoeda').val(ArredondarValor($('#txtValorAntecipacao').html(), 2));
        $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().focus();
        $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().unbind("blur");
        $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().on("blur", function() {
          if ($(this).val() != "") {
            const antecipacoes = $("#tabelaAntecipacoesSelecionadas").DataTable().data().toArray();
            const indexRegistroSelecionado = antecipacoes.findIndex(registro => registro.DUPLICATA == $(this).val());
            if (indexRegistroSelecionado >= 0) {
              $(`#check_col_${indexRegistroSelecionado}_row_0`).prop("checked", true);
              $("#tabelaAntecipacoesSelecionadas").DataTable().search("").draw(false);
              $("#btnConfirmarAntecipacao").trigger("click");
            }
          }
        })
        $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().unbind("keydown");
        $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().on("keydown", function(e) {
          if (e.keyCode == 13) {
            $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().trigger("blur");
          }
        })
      });

      async function carregaTabelaAntecipacaoSelecaoManual(dataSet, dataSetCols, dataCondicao = {}) {

        if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {

          if (!$.isEmptyObject(dataCondicao)) {
            const dataAntecipacoes = $('#tabelaAntecipacoesSelecionadas').DataTable().rows().data();
            const linhas = retornaLinhasSelecionadasAntecipacao(dataAntecipacoes);
            dataAntecipacoes.map((data, i) => {

              if (!$.isEmptyObject(dataCondicao[i])) {
                if (data.DUPLICATA == dataCondicao[i].duplicata) {
                  data.VALOR_PAGO = ArredondarValor(data.VALOR_PAGO - dataCondicao[i].valor, 2);
                  data.VALOR_UTILIZADO = data.VALOR_PAGO;

                  $('#tabelaAntecipacoesSelecionadas').DataTable().row(linhas[i]).data(data).draw(false);
                }
              }
            });

          }
          return;
        }

        if (!$.isEmptyObject(dataSet[0])) {
          var keys = Object.keys(dataSet[0]);
          for (var k in keys) {
            dataSetCols.push({
              'title': keys[k],
              'data': keys[k]
            });
          }
          var array_colunas_invisiveis = [6, 7];

          dataSetCols[0].render = function(data, type, row, meta) {
            $('.campoCheckManual').unbind('change');
            var baixaAntecipacao = pegaChave('#txtBaixaAntecipacao', baixaAntecipacao);
            var sProp = ((row.VALOR_PAGO > 0) && (baixaAntecipacao == 'S')) ? 'checked' : '';

            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input ' + sProp + '  style="height:15px" type="checkbox" id="check_col_' + [meta
                .row
              ] + '_row_' + [meta.col] +
              '" class="input-default focus form-control validate campoCheckManual"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[2].type = 'date-br';
          dataSetCols[2].render = function(data, type, row) {
            //alert(navigator['userAgent'])
            var isIE = function() {
              if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                  'userAgent']) == true) {
                return true;
              } else {
                return false;
              }
            }
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
            } else {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
              return $.datepicker.formatDate("dd/mm/Y", new Date(data));
            }
          }
          dataSetCols[3].type = 'date-br';
          dataSetCols[3].render = function(data, type, row) {
            //alert(navigator['userAgent'])
            var isIE = function() {
              if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                  'userAgent']) == true) {
                return true;
              } else {
                return false;
              }
            }
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
            } else {
              x = data.slice(0, 10).split('-');
              return x[2] + "/" + x[1] + "/" + x[0];
              return $.datepicker.formatDate("dd/mm/Y", new Date(data));
            }
          }


          $('#div-antecipacoes').removeClass('d-none');
          $('#div-espaco').addClass('d-none');

          // $('#div-antecipacoes').removeClass('d-none');
          // $('#div-espaco').addClass('d-none');

          var tabelaAntecipacoesSelecionadas = $('#tabelaAntecipacoesSelecionadas').DataTable({
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            searching: true,
            "columns": dataSetCols,
            "data": dataSet,
            columnDefs: [{
                targets: array_colunas_invisiveis,
                visible: false,
              },
              {
                "render": function(data) {
                  return parseFloat(data).toLocaleString('pt-BR', {
                    maximumFractionDigits: 2,
                    minimumFractionDigits: 2
                  });
                },
                "targets": [4, 5],
                "className": 'pr-4 text-right'
              }
            ],
          });

          $("#tabelaAntecipacoesSelecionadas").DataTable().columns.adjust().draw(false);


          dataSetCols[0].render = function(data, type, row, meta) {
            $('.campoCheck').unbind('change');
            var baixaAntecipacao = pegaChave('#txtBaixaAntecipacao', baixaAntecipacao);
            var sProp = ((row.VALOR_PAGO > 0) && (baixaAntecipacao == 'S')) ? 'checked' : '';

            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input ' + sProp + ' disabled style="height:15px" type="checkbox" id="check_col_' + [meta
                .row
              ] + '_row_' + [meta.col] +
              '" class="input-default focus form-control validate campoCheck"> ' +
              '</div>' +
              '</div>';
          }

          $('#tabelaAntecipacoes').DataTable({
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            "columns": dataSetCols,
            "data": dataSet,
            columnDefs: [{
                targets: [0, 5, 6, 7],
                visible: false,
              },
              {
                "render": function(data) {
                  return parseFloat(data).toLocaleString('pt-BR', {
                    maximumFractionDigits: 2,
                    minimumFractionDigits: 2
                  });
                },
                "targets": [4, 5],
                "className": 'pr-4 text-right'
              }
            ],
          });
          var tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(4, {}).data().sum()).toFixed(2));
          var tot_antecipacao_pago = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(5, {}).data().sum()).toFixed(2));
          var val_total_itens = $('#tabelaItens').DataTable().column(7, {}).data().sum();
          var saldo_antecipacao = tot_antecipacao - tot_antecipacao_pago;
          var saldo_geral = val_total_itens - saldo_antecipacao;
          if (saldo_geral < 0) {
            saldo_geral = 0;
          }

          var total_itens = $('#tabelaItens').DataTable().column(2, {}).data().sum();
          total_itens = ArredondarValor(total_itens, 2);

          const soma = $('#tabelaItens').DataTable().data().toArray().reduce((total, item) => total + parseFloat(item[3] * item[2]), 0);
          const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
          const total_original = utilizaImpressoraFiscal == 1 && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : parseFloat(parseFloat(soma).toFixed(2));

          const total_desconto = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total + parseFloat(item[6])
          }, 0), 2) * -1;

          $("#total_desc").html(
            parseFloat(isNaN(total_desconto) ? 0 : total_desconto).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );

          $("#total_orig").html(
            parseFloat(isNaN(total_original) ? 0 : total_original).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );
          $('#total_itens').html(total_itens);

          $("#credito_cliente").html(parseFloat(saldo_antecipacao).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $("#saldo_geral").html(parseFloat(saldo_geral).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          await atualizaCreditoConformeUltimaDevolucao();

        } else {
          var val_total_itens = $('#tabelaItens').DataTable().column(7, {}).data().sum();
          $('#div-antecipacoes').addClass('d-none');
          $('#div-espaco').removeClass('d-none');

          var total_itens = $('#tabelaItens').DataTable().column(2, {}).data().sum();
          total_itens = ArredondarValor(total_itens, 2);
          const total_original = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total + parseFloat(item[3] * item[2])
          }, 0), 2);

          const total_desconto = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total + parseFloat(item[6])
          }, 0), 2) * -1;

          if ($.fn.DataTable.isDataTable("#tabelaAntecipacoes")) {
            $('#tabelaAntecipacoes').DataTable().rows().remove().draw(false);
          }

          $("#total_desc").html(
            parseFloat(isNaN(total_desconto) ? 0 : total_desconto).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );

          $("#total_orig").html(
            parseFloat(isNaN(total_original) ? 0 : total_original).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
              currency: "BRL",
            })
          );

          $('#total_itens').html(total_itens);

          $("#credito_cliente").html(parseFloat(0).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $("#credito_cliente_saldo").html(parseFloat(0).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $("#saldo_geral").html(parseFloat(val_total_itens).toLocaleString('pt-BR', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
            currency: 'BRL'
          }));

          $('#tabelaAntecipacoesSelecionadas').DataTable().rows().remove().draw(false);
        }
      }

      async function carregaAntecipacoes(sCodCli, dataCondicao) {
        if (sCodCli == '') {
          return;
        }

        const bParametroSelecionaAntecipacao = parametrosVenda[49] == 1 | parametrosVenda[49] == 2 ?? false;
        var _url = `/Sisplan/Vendas/v1/Antecipacao?`;
        var dataSetCols = [];
        var dataSet = [];
        try {
          var response = await requisicao('GET', _url, `CLIENTE=${sCodCli}`, null);

          if (!response) {
            return;
          }

          var dataSet = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          if (($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) && (dataCondicao)) {

            if (bParametroSelecionaAntecipacao) {
              if (!$.isEmptyObject(dataCondicao[9])) {
                await carregaTabelaAntecipacaoSelecaoManual(dataSet, dataSetCols, dataCondicao[9]);
                return;
              } else {
                await carregaTabelaAntecipacaoSelecaoManual(dataSet, dataSetCols);
                return;
              }
            } else {

              if (!$.isEmptyObject(dataCondicao[9])) {
                await carregaTabelaAntecipacaoAutomatica(dataSet, dataSetCols, dataCondicao[9]);
                return;
              } else {
                await carregaTabelaAntecipacaoAutomatica(dataSet, dataSetCols);
                return;
              }
            }
          }

          if (bParametroSelecionaAntecipacao) {
            await carregaTabelaAntecipacaoSelecaoManual(dataSet, dataSetCols);
            return;

          } else {
            await carregaTabelaAntecipacaoAutomatica(dataSet, dataSetCols);
            return;
          }

        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar as antecipações.');
        }
      }

      function retornaLinhasSelecionadasAntecipacao(data) {
        const linhas = [];

        data.map((linhasData, i) => {
          if ($($('.campoCheckManual')[i]).is(':checked')) {
            linhas.push(i)
          }
        });
        return linhas;
      };

      $('#btnConfirmarAntecipacao').on('click', async function() {

        function rateiaAntecipacoesSelecionadas(data, linhas) {
          try {
            let valorPagoParcela = 0
            let linhasRateadas = 0;

            data.map((date, i) => {
              if (i == 0) {

                saldo = parseFloat($('#txtValorAntecipacao').html());
                valorPagoParcela = parseFloat($('#txtValorAntecipacao').html())
              }

              if (i == linhas[linhasRateadas]) {
                linhasRateadas++;
                // const data_old = $('#tabelaAntecipacoesSelecionadas').DataTable().row(linhas[i]).data();
                if (date.VALOR == date.VALOR_PAGO) {
                  return;
                }
                if ((date.VALOR_UTILIZADO == 0) || (date.VALOR_UTILIZADO != saldo)) {
                  if (saldo == 0) {
                    date.VALOR_PAGO = 0;
                    date.VALOR_UTILIZADO = 0;
                    $('#tabelaAntecipacoesSelecionadas').DataTable().row(i).data(date).draw(false);
                  } else
                  if ((saldo <= date.VALOR) && ((saldo <= (date.VALOR - date.VALOR_PAGO)))) {
                    // if ((date.VALOR_PAGO == 0) || (date.VALOR_PAGO == '')) {
                    date.VALOR_PAGO = +date.VALOR_UTILIZADO + +saldo;
                    date.VALOR_UTILIZADO = date.VALOR_PAGO;
                    saldo = 0;
                    $('#tabelaAntecipacoesSelecionadas').DataTable().row(i).data(date).draw(false);
                  } else {
                    date.VALOR_PAGO = date.VALOR;
                    saldo = saldo - (date.VALOR_PAGO - date.VALOR_UTILIZADO);
                    date.VALOR_UTILIZADO = date.VALOR;
                    $('#tabelaAntecipacoesSelecionadas').DataTable().row(i).data(date).draw(false);
                  }
                }
                $('#txtValorAntecipacao').html(saldo.toFixed(2));
              } else {
                return;
              }

            });

            return ArredondarValor(parseFloat(valorPagoParcela) - parseFloat(saldo), 2)

          } catch (error) {
            console.error(error)
          }
        }

        function verificaVencimentoAntecipacoesSelcionadas(data, linhas) {
          const dataAtual = formataData(new Date());
          const antecipacoesVencidas = [];

          linhas.forEach(linha => {
            if (data[linha].VENCIMENTO < dataAtual) {
              antecipacoesVencidas.push(data[linha].DUPLICATA);
            }
          });

          return antecipacoesVencidas;
        }

        try {
          if ($($("#tabelaAntecipacoesSelecionadas_filter").children()).children().val() != "") {
            $("#tabelaAntecipacoesSelecionadas").DataTable().search("").draw(false);
            $($("#tabelaAntecipacoesSelecionadas_filter").children()).children().val("");
          }
          const data = $('#tabelaAntecipacoesSelecionadas').DataTable().rows().data();
          const linhas = retornaLinhasSelecionadasAntecipacao(data);
          if (linhas.length == 0) {
            msgAlerta('Selecione uma antecipação para continuar!');
            return;
          }

          if (parametrosVenda[49] == 1) { // não permite selecionar antecipações vencidas
            const antecipacoesVencidas = verificaVencimentoAntecipacoesSelcionadas(data, linhas);
            if (antecipacoesVencidas.length > 0) {
              throw msgAlerta(`Impossível continuar, existem antecipações com o vencimento expirado: \n${antecipacoesVencidas.toString().replaceAll(",", ", ")}`)
            }
          }

          const valorUtilizado = rateiaAntecipacoesSelecionadas(data, linhas);

          // if (parseFloat($('#txtValorAntecipacao').html()) > 0) {
          //   msgAlerta('Tem que ser usado o valor inteiro da parcela nessa antecipação!');
          //   return;
          // }

          $('#modalAntecipacoes').modal('hide');
          $('#txtValorParcela').val(valorUtilizado);
          await validaParamVenda58();
          await RotinaAddCondicaoPagamento(false, true);
        } catch (error) {
          console.error(error)
        }
      });

      function RotinaCliqueInfo() {
        $('#btnVenda').prop('disabled', false);
        $('#btnInfo').prop('disabled', true);
        $('#btnPagamento').prop('disabled', false);

        if ($('#txtRegraPromocao').val() != '') {
          $('#txtTabela').prop('disabled', true);
          $('#btn-tabela').prop('disabled', true);
          $('#btn-limpa-tabela').prop('disabled', true);
        } else {
          desbloqueiaTabela();
        }

        if (numero_venda == 'create' && $('#tabelaItens').DataTable().rows().count() > 0) {
          $('#txtTipoVenda').attr('disabled', true);
          // $('#txtTabela').attr('disabled', true);
          // $('#btn-tabela').attr('disabled', true);
          // $('#btn-limpa-tabela').attr('disabled', true);
          $('#rgPrazo').attr('disabled', true);
        } else {
          desbloqueiaTabela();
          $('#rgPrazo').attr('disabled', false);
          $('#txtTipoVenda').attr('disabled', false);
        }

        fs_venda = $('#fieldset_venda');
        fs_pagamento = $('#fieldset_pagamento');
        fs_info = $('#fieldset_info');

        $("#progressbar li").eq($("fieldset").index(fs_info)).addClass("active");
        fs_info.show();
        fs_pagamento.animate({
          opacity: 0
        }, {
          step: function(now) {
            opacity = 1 - now;
            fs_venda.css({
              'display': 'none',
              'position': 'relative'
            });

            fs_pagamento.css({
              'display': 'none',
              'position': 'relative'
            });

            fs_info.css({
              'opacity': opacity
            });
          },
          duration: 100
        });
        $('#txtCliente').focus();
      }

      if (bNFCEAutomatico != 0) {
        $('#btnNFCE').removeClass('d-none');
        $('.divNFCE').removeClass('d-none');
        if (parametrosVenda[20] == 0 && parametrosVenda[20] != 2) {
          $('.divNFCE').addClass('ultimoBotao');
        }
        $('.divFinalizar').removeClass('ultimoBotao');
      }

      if (bCFEAutomatico != 0) {
        $('#btnCFe').removeClass('d-none');
        $('.divCFE').removeClass('d-none');
        if ((parametrosVenda[20] == 0 && parametrosVenda[20] != 2) && (parametrosVenda[6] == 0)) {
          $('.divCFE').addClass('ultimoBotao');
        }

        $('.divFinalizar').removeClass('ultimoBotao');

        if ((bCFEAutomatico == 1) || (bCFEAutomatico == 3) || (bCFEAutomatico == 5) || (bCFEAutomatico == 6)) {
          $('#btnCFe').html('CF-e SAT (F9)');
        } else if ((bCFEAutomatico == 2) || (bCFEAutomatico == 4)) {
          $('.divFinalizar').addClass('d-none');
          $('.preenchimento-botoes').removeClass('d-none');
          $('#btnCFe').html('CF-e MFE (F9)');
        }
      }

      if (bNFEAutomatico != 0 && bNFEAutomatico != 2) {
        $('#btnNFE').removeClass('d-none');
        $('.divNFE').removeClass('d-none');
        $('.divFinalizar').removeClass('ultimoBotao');
      }

      if (UsuarioPodeGravarCondicoes) {
        $('.divCFE').addClass('d-none');
        $('.divNFCE').addClass('d-none');
        $('.divNFE').addClass('d-none');
      }

      async function RotinaModalConferencia(callback) {
        const paramConferencia = parametrosVenda[25];
        const possuiItens = $('#tabelaItens').DataTable().rows().count();
        const possuiPagamento = $('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0;
        var sCliente = $('#txtCliente').val();
        const usuarioPodeGravar = UsuarioPodeGravarCondicoes;
        if ((!UsuarioPodeGravarCondicoes) && (!bConferido) && ((paramConferencia == '1') || (paramConferencia == '2')) && (possuiItens > 0) && (numero_venda != 'create') && (numero_venda != 'create#')) {
          $('#modal-conferencia').modal('show');
          $("html,body").css({
            "overflow": "hidden"
          });
          insereValor('#txtClienteConferencia', sCliente);
          insereValor('#txtVendaConferencia', numero_venda);
          $('#txtVendaConferencia').trigger('blur');
          if (callback) {
            $('#btnConfirmar').unbind('click');
            $('#btnConfirmar').on('click', async function() {
              var dataOld = $('#tabelaImportacao').DataTable().rows().data().toArray();
              for (let i = 0; i < dataOld.length; i++) {
                if (dataOld[i][5] != dataOld[i][6]) {
                  if (paramConferencia == '2') {
                    senhaSupervisor(`Necessário bipar todos os itens da venda.`, async () => {
                      bConferido = true;
                      await rotinaGeraLog('TVENDALOJA', numero_venda, `Informou a senha supervisor para não fazer a conferência da venda`, 'Alteração');
                      $('#modal-conferencia').modal('hide');
                      callback();
                    }, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
                  } else {
                    msgErro('Necessário bipar todos os itens da venda.');
                  }
                  return;
                }
                $('#modal-conferencia').modal('hide');
                bConferido = true;
                callback();
              }
              await rotinaGeraLog('TVENDALOJA', numero_venda, 'Realizada conferência dos itens da venda ' + numero_venda + ' pelo usuário ' + getCookie('usuario'))
            })
          }
          return true;
        }
        return false;
      }

      $('#modal-conferencia').on('shown.bs.modal', function() {
        $('#txtBarraConferencia').focus();
      });

      $('#modal-conferencia').on('hidden.bs.modal', function() {
        $("html,body").css({
          "overflow": "auto"
        });
      });

      async function RotinaCFE() {
        try {

          if ($('#btnCFe').prop('disabled')) {
            return;
          }
          const paramNatureza = parametrosVenda[19];
          const paramOperacao = parametrosVenda[67];
          $('#txtNaturezaCFe').val(paramNatureza);
          $('#txtOperacaoCFe').val(paramOperacao);
          $('#txtCpfCFe').val($('#txtCNPJ').val());
          $('#txtClienteCFE').val($('#txtCliente').val());
          if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
            var bAutomatico = parametrosVenda[18];
            if (bAutomatico == 3 || bAutomatico == 6) {
              $('#btn_confirmar_cfe').trigger('click');
            } else if ((bAutomatico == 2) || (bAutomatico == 4)) {
              if ((numero_venda == 'create') || (numero_venda == 'create#')) {
                await RotinaFinalizarVenda(false, true, false, true);
              }
              await verificaMfePagamento();
            } else {
              $('#modalCFe').modal('show');
            }
          } else {
            msgAlerta('Não é possível gerar CF-e sem condição de pagamento, verifique.');
            return;
          }
        } finally {
          $('#btnCFe').prop('disabled', false);
        }
      }

      async function RotinaNFCE() {
        try {
          if ($('#btnNFCE').prop('disabled')) {
            return;
          }
          const paramNatureza = parametrosVenda[7];
          const paramOperacaoNfce = parametrosVenda[57];
          insereValor('#txtNaturezaNFCE', paramNatureza);
          insereValor('#txtOperacaoNfce', paramOperacaoNfce);

          $('#txtCpfNFCE').val($('#txtCNPJ').val());
          $('#txtCpfNFCE').trigger('keyup');
          $('#txtClienteNFCE').val($('#txtCliente').val());

          if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
            $('#modalTroco').modal('hide');
            var bAutomatico = parametrosVenda[6];
            if (await RotinaFinalizarVenda(true, false)) {
              if (bAutomatico == 2) {
                $('#btn_confirmar_nfce').trigger('click');
              } else {
                $('#modalNFCE').modal('show');
              }
            }
          } else {
            msgAlerta('Não é possível gerar NFC-e sem condição de pagamento, verifique.');
            return;
          }
        } finally {
          $('#btnNFCE').prop('disabled', false);
        }
      }

      async function TemSaldoAPagar() {
        var total = $('#tabelaItens').DataTable().column(7, {}).data().sum();
        var total_pagto = $('#tabelaCondicoesDePagamento').DataTable().column().data().count();
        var saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
        if (total <= 0) {
          msgAlerta('Venda sem nenhum item, impossível finalizar.');
          $('#btnFinalizar').prop('disabled', false);
          return true;
        }
        if ((total_pagto > 0) && (saldo_a_pagar > 0)) {
          msgAlerta('Existe saldo a pagar nas condições de pagamento, verifique.');
          $('#btnFinalizar').prop('disabled', false);
          return true;
        }
        return false;
      }

      async function validaValorMaximo() {
        try {
          if (parametrosVenda[101] == 0) {
            return false;
          }

          const pesquisa = await buscaValoresPadroes('LOJA')
          const jsonStr = pesquisa.filter((item) => item.CAMPO == 'VALOR_MAX_NFCE')

          const valor = isNaN(parseFloat(jsonStr[0]?.VALOR.replace(',', '.'))) ? 0 : parseFloat(jsonStr[0]?.VALOR.replace(',', '.'));
          if (valor > 0) {
            const total = $("#tabelaCondicoesDePagamento").DataTable().column(3, {}).data().sum();
            if (total > valor) {
              await aguardaMsgAlerta(`Venda com valor total superior a ${valor.toFixed(2)} (Valor definido nos valores padrões). Impossível emitir NFC-e!`, () => {});
              return true;
            }
          }

          return false;
        } catch (error) {
          console.log(error);
        }
      }

      async function RotinaNFE() {
        try {
          if (parametrosVenda[47] != '') {
            $('#txtOperacaoNota').val(parametrosVenda[47]);
          }
          if (await TemSaldoAPagar()) {
            return;
          }

          if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
            $('#txtClienteNFE').val($('#txtCliente').val());
            $('#modalNFE').modal('show');
            $('#modalTroco').modal('hide');
          } else {
            msgAlerta('Não é possível gerar NF-e sem condição de pagamento, verifique.');
            return;
          }
        } finally {
          $('#btnNFE').prop('disabled', false);
        }

      }

      async function BaixaAntecipacaoAutomatica() {
        try {
          var moedaAntecipacao = parametrosVenda[14];
          if ((moedaAntecipacao != '') && (moedaAntecipacao != undefined) && ($('#tabelaAntecipacoes').DataTable()
              .rows().count() > 0
            )) { //arrumar aqui para não deixar incluir automatico sem ter antecipacao e se for undefined) {
            $('#txtMoeda').val(moedaAntecipacao);
            $('#txtMoeda').attr('data-selecionado', true);
            var dadosMoeda = await RetornaDadosMoeda(pegaChave(moedaAntecipacao));
            if (dadosMoeda.RESULT[0][0].DESC_CONDI == '') {
              msgErro('Moeda antecipação sem condição de pagamento!')
              return;
            }

            if (dadosMoeda.RESULT[0][0].ATIVO == 'N') {
              msgErro('Moeda Inativa, verificar no cadastro de moeda!')
              return;
            }

            if ((dadosMoeda != '') && (dadosMoeda != undefined)) {
              await insereValor('#txtCodCondMoeda', dadosMoeda['RESULT'][0][0].CDCONDI, dadosMoeda['RESULT'][0][0]
                .DESC_CONDI);
              await insereValor('#txtCondicaoDePagamento', dadosMoeda['RESULT'][0][0].CDCONDI, dadosMoeda[
                'RESULT'][0][0].DESC_CONDI);
              await insereValor('#txtNrParcelas', dadosMoeda['RESULT'][0][0].NRPAR, dadosMoeda['RESULT'][0][0]
                .NRPAR);
              await insereValor('#txtBaixaAntecipacao', dadosMoeda['RESULT'][0][0].BAIXA_ANTE, dadosMoeda[
                'RESULT'][0][0].BAIXA_ANTE);
              await RotinaSaidaMoeda();
              await RotinaAddCondicaoPagamento();
            }
          }
        } finally {
          await $('#txtMoeda').focus();
        }
      }

      async function lancaMoedaConsumidorFinal(funcaoCallback = () => {}) {
        try {
          const paramLancaMoeda = parametrosVenda[28];
          const bloquearLancamento = paramLancaMoeda == '1';
          const perguntarSeDesejaLancar = paramLancaMoeda == '2';
          const naoControlaLancamento = paramLancaMoeda == '0' || '';

          if (naoControlaLancamento) {
            return true;
          }

          const tipoMoeda = pegaChave('#txtTipoMoeda');
          const clienteAtual = pegaChave('#txtCliente');
          const clienteParam = pegaChave(parametrosVenda[3]);
          const moedaCrediarioOuCheque = ((tipoMoeda == '1') || (tipoMoeda == '2'));
          const clienteConsumidorFinal = clienteAtual == clienteParam

          if (clienteConsumidorFinal && moedaCrediarioOuCheque) {
            if (perguntarSeDesejaLancar) {
              msgAlerta('Deseja lançar moeda do tipo crediário/cheque para Consumidor Final?', funcaoCallback);
              return false;
            }
            // bloqueia
            msgAlerta(`Não é possível lançar moeda do tipo crediário/cheque para Consumidor Final.`);
            return false;
          }
          return true;

        } catch (error) {
          msgErro('Erro ao validar se lança moeda do tipo crediário/cheque para Consumidor Final.');
          console.error(error);
          return false;
        } finally {
          // $.LoadingOverlay('hide');
        }
      }


      async function callbackSaidaMoeda() {
        const codmoeda = $('#txtMoeda').attr('data-chave');
        if ((codmoeda != '') && (await temCondicoesEspecificas(codmoeda))) {
          $('#txtCondicaoDePagamento').unbind('autocompleta');
          $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${codmoeda})"]}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
          $('#btn-CondicaoDePagamento').off();
          $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
          $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar", "cond_moeda.valor_minimo", "cond_moeda.restricao"], "leftJoin": [{"tabela": "cond_moeda", "condicao": "condicao.codcond = cond_moeda.codcond"}], "where": ["COND_MOEDA.moeda=${codmoeda}"], "orderBy": ["condicao.nrpar", "condicao.codcond"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
        } else {
          // volta as condições normais
          $('#txtCondicaoDePagamento').unbind('autocompleta');
          $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
          $('#btn-CondicaoDePagamento').off();
          $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
          $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar"], "where": null, "orderBy": ["nrpar", "codcond"]}', 'Pesquisa Condição de Pagamento', 'condicao');

        }
      }


      async function verificaLimiteCreditoCliente() {
        try {
          try {
            $.LoadingOverlay('show');
            const paramLimiteCredito = parametrosVenda[22] ?? '';
            if ((paramLimiteCredito == '') || (paramLimiteCredito == '3')) {
              return false;
            }
            const permitirFinalizacao = paramLimiteCredito == '0';
            const bloquearFinalizacao = paramLimiteCredito == '1';
            const solicitarSenhaSupervisor = paramLimiteCredito == '2';
            const clienteParam = pegaChave(parametrosVenda[3]);
            const clienteAtual = pegaChave('#txtCliente');
            const tipoMoeda = pegaChave('#txtTipoMoeda');

            if (clienteAtual == clienteParam) {
              return false;
            }

            if (tipoMoeda == '1' || tipoMoeda == '2') {

              const empId = getCookie('emp_id');
              const url = `/sisplan/cliente/v1/buscarlimitecreditocliente?`;
              var response = await requisicao('GET', url, `CODCLI=${clienteAtual}`, null, 20000);

              if (!response) {
                return false;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return false;
              }

              if (jsonStr.length == 0) {
                return false;
              }

              const dados = jsonStr[0];
              let creditoCliente = Number(dados.CREDITO);
              let valorEmAberto = Number(dados.ABERTO);
              if (dados.CREDITO_GRUPO == 'S') {
                await carregaLimiteCredito(clienteAtual);
                creditoCliente = Number($('#txtLimiteCreditoCli').val());
                valorEmAberto = 0;
              }
              g_CreditoCliente = creditoCliente;
              const dadosPagamento = $('#tabelaCondicoesDePagamento').DataTable().rows().data().toArray();
              const dadosPagamentoFiltrados = dadosPagamento.filter((pagto) => pagto[15] == '1' || pagto[15] == '2');
              let valorJaLancado = 0;
              if (dadosPagamentoFiltrados.length > 0) {
                for (let i = 0; i < dadosPagamentoFiltrados.length; i++) {
                  const pagto = dadosPagamentoFiltrados[i];
                  valorJaLancado += pagto[3];
                }
              }

              const valorMoeda = parseFloat($('#txtValorLiquidoMoeda').val());
              const percUsuario = await buscaValor('ACESSO_USUARIOS', 'PERC_LIMITE', 'CODIGO', getCookie('cod_usuario'));
              if (percUsuario > 0) {
                creditoCliente += creditoCliente * (percUsuario / 100);
              }

              async function rotinaFinalizacaoSemValidacao() {
                await rotinaGeraLog('VENDA/LIBERA_CREDITO', clienteAtual, `VENDA ${numero_venda == 'create' ? 'nova' : numero_venda}, DO CLIENTE ${clienteAtual}. USUARIO ${getCookie('usuario')} INFORMOU SENHA SUPERVISOU, POIS O CRÉDITO DO CLIENTE FOI EXCEDIDO. Crédito do cliente excedido, crédito: ${creditoCliente.toFixed(2).replace('.', ',')}, valor disponível: ${(creditoCliente - valorEmAberto).toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda+valorEmAberto).toFixed(2).replace('.', ',')}`, 'Alteração');
                await sleep(1000);
                await RotinaAddCondicaoPagamento(true, false, true);
              }

              g_ValorAbertoCliente = valorJaLancado + valorMoeda + valorEmAberto;

              if ((valorJaLancado + valorMoeda + valorEmAberto) > creditoCliente) {
                if (permitirFinalizacao) {
                  msgAlerta(`Crédito do cliente excedido, crédito: ${creditoCliente.toFixed(2).replace('.', ',')}, valor disponível: ${(creditoCliente - valorEmAberto).toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda+valorEmAberto).toFixed(2).replace('.', ',')}`);
                  return false;
                } else
                if (bloquearFinalizacao) {
                  msgAlerta(`Crédito do cliente excedido, crédito: ${creditoCliente.toFixed(2).replace('.', ',')}, valor disponível: ${(creditoCliente - valorEmAberto).toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda+valorEmAberto).toFixed(2).replace('.', ',')}`);
                  return true;
                } else
                if (solicitarSenhaSupervisor) {
                  await senhaSupervisor(
                    `Crédito do cliente excedido, crédito: ${creditoCliente.toFixed(2).replace('.', ',')}, valor disponível: ${(creditoCliente - valorEmAberto).toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda+valorEmAberto).toFixed(2).replace('.', ',')}`,
                    verificaLimiteCredMaximoSupervisor, rotinaFinalizacaoSemValidacao, true, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
                }
                return true;
              }
              return false;
            }
            return false;
          } catch (error) {
            msgErro('Erro ao validar limite de crédito cliente');
            console.error(error);
            return false;
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      async function verificaLimiteCreditoGrupo() {
        try {
          $.LoadingOverlay('show');

          const paramLimiteCredito = parametrosVenda[22] ?? '';
          if ((paramLimiteCredito == '') || (paramLimiteCredito == '3')) {
            return false;
          }
          const permitirFinalizacao = paramLimiteCredito == '0';
          const bloquearFinalizacao = paramLimiteCredito == '1';
          const solicitarSenhaSupervisor = paramLimiteCredito == '2';
          const clienteParam = pegaChave(parametrosVenda[3]);
          const clienteAtual = pegaChave('#txtCliente');
          const tipoMoeda = pegaChave('#txtTipoMoeda');

          if (clienteAtual == clienteParam) {
            return false;
          }

          if (tipoMoeda == '1' || tipoMoeda == '2') {
            if (await verificaCreditoGrupoHistoricoMoeda()) {
              await carregaLimiteCredito(pegaChave('#txtCliente'));
              const creditoGrupo = Number($('#txtLimiteCreditoConsignado').val());
              let limiteDisponivel;
              const creditoCliente = Number($('#txtLimiteCreditoCli').val());
              const dadosPagamento = $('#tabelaCondicoesDePagamento').DataTable().rows().data().toArray();
              const dadosPagamentoFiltrados = dadosPagamento.filter((pagto) => pagto[15] == '1' || pagto[15] == '2');
              let valorJaLancado = 0;
              if (dadosPagamentoFiltrados.length > 0) {
                for (let i = 0; i < dadosPagamentoFiltrados.length; i++) {
                  const pagto = dadosPagamentoFiltrados[i];
                  valorJaLancado += pagto[3];
                }
              }

              const valorMoeda = parseFloat($('#txtValorLiquidoMoeda').val());

              function rotinaFinalizacaoSemValidacao() {
                RotinaAddCondicaoPagamento(true, false, true);
              }

              if ((valorJaLancado + valorMoeda) > creditoGrupo) {
                limiteDisponivel = creditoGrupo > (creditoCliente - valorJaLancado) ? creditoGrupo : (creditoCliente - valorJaLancado);
                if (permitirFinalizacao) {
                  msgAlerta(`Crédito do grupo excedido, crédito: ${creditoGrupo}, valor disponível: ${limiteDisponivel.toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda).toFixed(2).replace('.', ',')}`);
                  rotinaFinalizacaoSemValidacao();
                  return true;
                } else
                if (bloquearFinalizacao) {
                  msgAlerta(`Crédito do grupo excedido, crédito: ${creditoGrupo}, valor disponível: ${limiteDisponivel.toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda).toFixed(2).replace('.', ',')}`);
                  return true;
                } else
                if (solicitarSenhaSupervisor) {
                  await senhaSupervisor(
                    `Crédito do grupo excedido, crédito: ${creditoGrupo}, valor disponível: ${limiteDisponivel.toFixed(2).replace('.', ',')}, valor utilizado: ${(valorJaLancado+valorMoeda).toFixed(2).replace('.', ',')}`,
                    rotinaFinalizacaoSemValidacao, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
                }
                return true;
              } else {
                await rotinaFinalizacaoSemValidacao();
                return true;
              }
            }
          }

          return false;

        } catch (error) {
          msgErro('Não foi possível validar limite de crédito grupo');
          console.error(error);
          return false;
        } finally {
          $.LoadingOverlay('hide');
        }

      }

      async function verificaCreditoGrupoHistoricoMoeda() {
        try {
          const moeda = pegaChave('#txtMoeda');
          const url = `/sisplan/funcoes/v1/pesquisa?`;

          const response = await requisicao('GET', url, encodeURIComponent(
            `JSON={ "tabela":"MOEDA", 
                "camposSelect":["HISTCP.CREDITO_GRUPO"], 
                "leftJoin": [{"tabela" : "HISTCP", "condicao" : "MOEDA.HISTORICO = HISTCP.HISTORICO"}], 
                "where": ["MOEDA.CODMOE = '${moeda}'"]}`
          ), null, 20000);

          if (!response) {
            return false;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return false;
          }

          if (jsonStr['RESULT'][0].length == 0) {
            return false;
          }

          if (jsonStr['RESULT'][0][0].CREDITO_GRUPO == 'S') {
            return true;
          }

          return false;
        } catch (error) {
          console.log(error);
          msgAlerta('Não foi possível verificar crédito grupo no histórico da moeda!');
          return false;
        }
      }

      async function ImprimirCupomTrocaAutomatico() {
        const empresa = sessionStorage.getItem('emp_id');
        const pesquisaParam = {
          tabela: 'VENDA',
          camposSelect: ['VENDA.FECHADA'],
          where: [`VENDA.CODVEN = '${numero_venda}' AND VENDA.EMP_ID = '${empresa}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr && jsonStr.length > 0) {
          if (jsonStr[0].FECHADA != 1) {
            return;
          }

          const existeLayoutCookie = getCookie("serie_ecf");
          if (existeLayoutCookie == "") {
            await imprimirCupomTrocaSemECF(numero_venda, $('#tabelaItens').DataTable().data(), true);
          } else {
            let lista = "";
            const tabela = $('#tabelaItens').DataTable().data();
            const tipo = 'UNICO';
            for (let i = 0; i < $("#tabelaItens").DataTable().rows().count(); i++) {
              let data = $("#tabelaItens").DataTable().row(i).data();
              if (tabela[i][17] == true) {
                lista += `${i+1},`;
              }
            }
            lista = lista.substr(0, lista.length - 1);
            if (lista.length != 0) {
              await ImprimirCupomTroca(numero_venda, tipo, lista);
            }
          };
        }

      }

      async function verificaGravarRFID() {
        try {
          const url = '/sisplan/epc/v1?';
          const response = await requisicao('PUT', url, '', ``, );

          if (!response) {
            return;
          }

          if (response.status != 200) {
            return;
          }

        } catch (error) {
          console.error(error);
        }
      }

      async function RotinaFinalizarVenda(bNFCE, bECFF10, bSaiuPDV = false, bMfe = false, bNfe = false, bCfe = false, bNfeAut = false) {
        try {
          let bUsaMFe = parametrosVenda[18];
          const bUsaCFe = parametrosVenda[18] > 0 && bCfe;
          if ((bUsaMFe == 2) || (bUsaMFe == 4)) {
            // $('#btn_confirmar_cfe').prop('disabled', true);
            // por enquanto nada acontece feijoada
          } else {
            if ($('#btnFinalizar').prop('disabled') && ($('#btnFinalizar').attr('data-original') != 'Deixar Pendente (F8)')) {
              return;
            }
          }
          $('#btnFinalizar').prop('disabled', true);
          const tipoFechaVenda = $('#tipoFechaVenda').prop('checked');
          const bAbreTelaCamapanhasCRMBonus = $('#btnFinalizar').attr('data-original') == "Finalizar (F8)" && bUtilizaCashbackCRMBonus && infoCRMBonus.valid_pin;
          const bChamaVendasTotaisCRMBonus = $('#btnFinalizar').attr('data-original') == "Finalizar (F8)" && bUtilizaCashbackCRMBonus;

          var total = $('#tabelaItens').DataTable().column(7, {}).data().sum();
          var total_pagto = $('#tabelaCondicoesDePagamento').DataTable().column().data().count();
          var saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
          if (await TemSaldoAPagar()) {
            return;
          }

          if (total <= 0) {
            msgAlerta('Venda sem nenhum item, impossível finalizar.');
            $('#btnFinalizar').prop('disabled', false);
            return;
          } else {
            try {
              $.LoadingOverlay("show");
              let bUsaMFe = parametrosVenda[18];
              var bUsaECF = parametrosVenda[8];
              const NrSerie = getCookie('serie_ecf');
              const finalizouSemDocumentoFiscal = (bECFF10) ||
                ((!bNFCE) &&
                  (!bNfe) &&
                  (!bMfe) &&
                  (bUsaECF != '1') &&
                  (!bSaiuPDV) &&
                  $('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0);
              const usuarioGravaCondicoes = UsuarioPodeGravarCondicoes;
              let venda = {};

              if (finalizouSemDocumentoFiscal && await RetornaSeAlgumaMoedaObrigaDocumentoFiscal()) {
                msgErro('Moeda configurada para obrigar emissão de documento fiscal, verifique.');
                return;
              }

              if ((numero_venda) && (finalizouSemDocumentoFiscal && await RetornaSeVendaAgrupadaEFaturada(numero_venda))) {
                msgErro('Venda originada de agrupamento com nota já emitida, necessário finalizar com documento fiscal.');
                return;
              }

              if ((numero_venda == 'create') || (numero_venda == 'create#')) {
                numero_venda = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
              }

              if ((bSaiuPDV) && ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) && (!usuarioGravaCondicoes)) {
                $('#tabelaCondicoesDePagamento').DataTable().clear().draw(false);
              }

              // feito por conta de não poder deixar pendente antes de gerar todo o MFE
              if (!bMfe) {
                // se usa ecf so salva pendente, pois pode usar tef, ai tem que validar dados do tef antes de finalizar

                const moedas = $('#tabelaCondicoesDePagamento').DataTable().rows().data();
                let retornoInfoMoeda;
                let condicaoUsaTEF = [];
                let bUsaTef = false;

                for (let i = 0; i < moedas.length; i++) {
                  retornoInfoMoeda = await RetornaInformacoesMoeda(moedas[i][6]);
                  if (retornoInfoMoeda[0] == 'S' && moedas[i][15] == 3) {
                    condicaoUsaTEF.push(moedas[i]);
                    bUsaTef = true;
                  }
                }

                if ($("#tabelaItens").DataTable().row().data()[23] != '') {
                  importaPedido = true;
                }

                const bPix = utilizaPix();
                venda = await montaJsonVenda(venda, numero_venda, 'P', (!bNFCE) && (!bNfe) && (!bUsaCFe) && ((!usuarioGravaCondicoes) && (bUsaECF != '1') || (bECFF10)) && (!bUsaTef) && (!bPix), (bUsaECF == '1' || bNfe || bNFCE || bUsaTef || bPix));
                salvarBackupVenda(venda);
                const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
                const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
                var response = await requisicao(venda.codVen != null ? 'PUT' : 'POST', '/Sisplan/Vendas/V1/Venda?', `PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&FECHAF10=${bECFF10}&NRSERIE=${NrSerie}&VERIFICA_CAIXA=${$('#btnFinalizar').html() != 'Deixar Pendente (F8)'}&IMPORTA_PEDIDO=${importaPedido}&NFCE=${bNFCE}`, `JSON=${encodeURIComponent(JSON.stringify(venda))}`, 480000);

                if (!response) {
                  return false;
                }

                var jsonStr = await response.json();
                if (response.status != 200) {
                  msgErro(jsonStr.mensagem);
                  return false;
                }
                venda.codVenda = jsonStr.codVenda;
                salvaDadosDigitados(venda);
                var venda_gerada = jsonStr.codVenda;
                $('#txtCodVen').val(jsonStr.codVenda);
                await setCookie('ultima-venda-finalizada', venda_gerada);

                if (bNFCE) {
                  await rotinaGeraLog('TVENDALOJA', jsonStr.codVenda, `Usado F9 - NFCE para fechar a venda ${jsonStr.codVenda}`, 'Inclusão');
                } else if ((bNfe) && (!bECFF10) && (!finalizouSemDocumentoFiscal)) {
                  await rotinaGeraLog('TVENDALOJA', jsonStr.codVenda, `Usado NFe para fechar a venda ${jsonStr.codVenda}`, 'Inclusão');
                } else if ((bECFF10) && ((finalizouSemDocumentoFiscal) && (!bNfe))) {
                  await rotinaGeraLog('TVENDALOJA', jsonStr.codVenda, `Usado F10 para fechar a venda ${jsonStr.codVenda}`, 'Inclusão');
                } else if ((bUsaCFe) && (!bCfe)) {
                  await rotinaGeraLog('TVENDALOJA', numero_venda, `Usado F9 - CFe para fechar a venda ${numero_venda}`, 'Inclusão');
                } else {
                  await rotinaGeraLog('TVENDALOJA', jsonStr.codVenda, `Usado F8 para fechar a venda ${jsonStr.codVenda}`, 'Inclusão');
                }

                await gravaLogsVenda(jsonStr.codVenda);

                if (bUsaTef && finalizouSemDocumentoFiscal && !bNFCE && !bNfe && !bMfe && bUsaECF != '1') {
                  if (await chamaTefNFCE(JSON.stringify(jsonStr), jsonStr)) {
                    const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
                    const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
                    var response = await requisicao('POST', '/Sisplan/Vendas/V1/FinalizaVenda?', `CASHBACK=1&PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&CODVENDA=${venda.codVen}&NRSERIE=${''}`, 900000);
                    if (!response) {
                      return false;
                    }
                    if (response.status != 200) {
                      msgErro('Erro ao finalizar venda.');
                      return false;
                    }
                  } else {
                    return false;
                  }
                }

              } else {
                $('#txtCodVen').val(numero_venda);
                venda = await montaJsonVenda(venda, numero_venda, 'P', false, (bUsaECF == '1'));
                salvarBackupVenda(venda);
              }
              $('#txt_venda_atual').html(`<span style="color:green">${$('#txtCodVen').val()}</span>`);

              if (bAbreTelaCamapanhasCRMBonus) {
                if (await campanhaDisponivel(venda.valor.toFixed(2).replace('.', ','))) {
                  // NAO TIRAR OS LOADINGS, PRECISA DE DOIS PARA FUNCIONAR NO CRM&BONUS
                  $.LoadingOverlay("hide");
                  $.LoadingOverlay("hide");
                  await eventoClickConfirmarCampanhasCRMBonus();
                  return callBack();
                } else {
                  if (bChamaVendasTotaisCRMBonus) {
                    await vendasTotaisCRMBonus(venda.valor.toFixed(2).replace('.', ','));
                  }
                  return await callBack();
                }
              } else {
                if (bChamaVendasTotaisCRMBonus) {
                  await vendasTotaisCRMBonus(venda.valor.toFixed(2).replace('.', ','));
                }
                return await callBack();
              }

              async function callBack() {
                // NAO TIRAR OS LOADINGS, PRECISA DE DOIS PARA FUNCIONAR NO CALLBACK DPS DO CRM&BONUS
                $.LoadingOverlay("show");
                $.LoadingOverlay("show");
                try {
                  //cupom fiscal
                  if ((!bNfe) &&
                    (((bUsaECF == '1') && (!bECFF10)) || (bNFCE)) &&
                    ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) &&
                    (!usuarioGravaCondicoes) &&
                    (tipoFechaVenda)) {
                    // tenta imprimir cupom fiscal e se tiver, imprimir cupom gerencial também...
                    if (bNFCE) {
                      const bUtilizaPix = utilizaPix();

                      if (await chamaTefNFCE(JSON.stringify(jsonStr), jsonStr)) {
                        var bAutomatico = parametrosVenda[6];
                        $('#btnFinalizar').prop('disabled', false);

                        var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                        await deletaVendaNaoSalva(hostname + '.txt');
                        if (!bUtilizaPix) {
                          if (bAutomatico == 2) {
                            $('#btn_confirmar_nfce').trigger('click');
                          } else {
                            $('#modalNFCE').modal('show');
                          }
                          return false;
                        }
                      } else {
                        return false;
                      }

                      if (bUtilizaPix) {
                        if (await rotinaPagamentoPix(jsonStr)) {
                          var bAutomatico = parametrosVenda[6];
                          $('#btnFinalizar').prop('disabled', false);
                          $('#btnFinalizar').html(await traduzSentenca('Deixar Pendente (F8)'));
                          $('#btnFinalizar').attr('data-original', 'Deixar Pendente (F8)');
                          const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
                          const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
                          var response = await requisicao('POST', '/Sisplan/Vendas/V1/FinalizaVenda?', `CASHBACK=1&PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&CODVENDA=${jsonStr.codVenda}&NRSERIE=${''}&NFCE=${bNFCE}`, 900000);
                          if (!response) {
                            return false;
                          }
                          if (response.status != 200) {
                            msgErro('Erro ao finalizar venda.');
                            return false;
                          }
                          var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                          await deletaVendaNaoSalva(hostname + '.txt');
                          if (bAutomatico == 2) {
                            $('#btn_confirmar_nfce').trigger('click');
                          } else {
                            $('#modalNFCE').modal('show');
                          }
                          return false;
                        } else {
                          return false;
                        }
                      }
                    } else {
                      jsonStr.ValorTroco = parseFloat($('#txtTroco').val());
                      if (['Requer Z', 'Bloqueada'].includes($('#txtEstadoECF').html())) {
                        msgErro('Impressora fiscal bloqueada ou com Redução Z pendente, verifique.');
                        return false;
                      }
                      if (utilizaPix()) {
                        if (!await rotinaPagamentoPix(jsonStr)) {
                          return false;
                        }
                      }
                      await ImprimirCupomGerencial(jsonStr.codVenda, jsonStr.nrCupom);
                      if (await ImprimirCupomFiscal(JSON.stringify(jsonStr), jsonStr)) {
                        var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                        await deletaVendaNaoSalva(hostname + '.txt');
                        await toastr.success(
                          'Cupom Impresso com sucesso!',
                          'Confirmação', {
                            toastClass: 'alert',
                            iconClasses: {
                              error: 'alert-error',
                              info: 'alert-info',
                              success: 'alert-success',
                              warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                          }
                        ).css({
                          "margin-top": "0%",
                          "width": "500px",
                          "max-width": "500px"
                        });
                      } else {

                        await estornaReceberErroCupom(jsonStr);
                        await toastr.error(
                          'Erro ao imprimir Cupom: ' + getCookie('erro_impressao_cupom'),
                          'Atenção', {
                            toastClass: 'alert',
                            iconClasses: {
                              error: 'alert-error',
                              info: 'alert-info',
                              success: 'alert-success',
                              warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden: async function() {
                              $('#btnConfirmarTroco').prop('disabled', false);
                            }
                          }
                        ).css({
                          "margin-top": "0%",
                          "width": "500px",
                          "max-width": "500px"
                        });
                        return false; //para o processo...
                      }

                    }
                  }

                  //imprime romaneio automaticamente...
                  if (!bNFCE && !bMfe) {
                    var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                    let bRotinaPix = true;
                    if ((bNfe) && (!bUsaCFe) && (!bCfe) && ($('#tipoFechaVenda').prop('checked'))) {
                      if (!await chamaTefNFCE(JSON.stringify(jsonStr), jsonStr)) {
                        return false;
                      }
                      bRotinaPix = false;
                      if (utilizaPix()) {
                        if (!await rotinaPagamentoPix(jsonStr)) {
                          return false;
                        }
                      }
                      const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
                      const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
                      const response = await requisicao('POST', '/Sisplan/Vendas/V1/FinalizaVenda?', `CASHBACK=1&PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&CODVENDA=${venda_gerada}&NRSERIE=${''}`, 900000);
                      if (!response) {
                        return;
                      }
                      if (response.status != 200) {
                        msgErro('Erro ao finalizar venda.');
                        return;
                      }
                    }

                    if ((bUsaCFe) && (bCfe) && (!bMfe)) {
                      if (!await chamaTefNFCE(JSON.stringify(jsonStr), jsonStr)) {
                        return false;
                      }
                      bRotinaPix = false;
                      if (utilizaPix()) {
                        if (!await rotinaPagamentoPix(jsonStr)) {
                          return false;
                        }
                      }

                      const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
                      const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
                      const response = await requisicao('POST', '/Sisplan/Vendas/V1/FinalizaVenda?', `CASHBACK=1&PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&CODVENDA=${venda_gerada}&NRSERIE=${''}`, 900000);
                      if (!response) {
                        return;
                      }
                      if (response.status != 200) {
                        msgErro('Erro ao finalizar venda.');
                        return;
                      }
                    }

                    if ((bRotinaPix) && (utilizaPix())) {
                      if (!await rotinaPagamentoPix(jsonStr)) {
                        return false;
                      }
                      const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
                      const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
                      const response = await requisicao('POST', '/Sisplan/Vendas/V1/FinalizaVenda?', `CASHBACK=1&PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&CODVENDA=${venda_gerada}&NRSERIE=${''}`, 900000);
                    }

                    await deletaVendaNaoSalva(hostname + '.txt');

                    var tem_pagto = $('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0;
                    const redirectUrl = '<?php echo BASE_URI; ?>/venda/create';
                    if (venda_gerada && venda_gerada != '') {
                      numero_venda = venda_gerada;
                    } else {
                      venda_gerada = Number(numero_venda);
                    }

                    await geraVendaNetShopping(numero_venda, pegaChave('#txtCodGuiaIntegracao'));
                    await geraVendaIShopp(numero_venda);

                    const bUsaIntegraçãoITAG = parametrosVenda[60] == 1 || parametrosVenda[60] == 2;
                    if (bUsaIntegraçãoITAG) {
                      await verificaGravarRFID();
                    }

                    const mensagem = tem_pagto && !usuarioGravaCondicoes ? `Venda <b>${venda_gerada}</b> gravada, status: Finalizada!` :
                      `Venda <b>${venda_gerada}</b>, status: Pendente!`;
                    if (!bNfeAut && ((tem_pagto && !usuarioGravaCondicoes) && (((bUsaECF == '1') && (bECFF10)) || ((bUsaECF != '1'))))) {
                      if ((bUsaMFe == 1) || (bUsaMFe == 2) || (bUsaMFe == 4) || (bUsaMFe == 3) || (bUsaMFe == 5) || (bUsaMFe == 6) && (!bCfe)) {
                        // aqui Deus nao deixa
                        const parametroImprimirRomaneio = parametrosVenda[34];
                        if (!parametroImprimirRomaneio || parametroImprimirRomaneio == '0') {
                          await imprimirRomaneio(venda_gerada, "<?php echo BASE_URI; ?>");
                          await toastrFinalizarVenda(mensagem, async () => {
                            await ImprimirCupomTrocaAutomatico();
                          });
                          if ((!bSaiuPDV) && (!bCfe) && (!bNfe)) {
                            window.location.href = redirectUrl;
                          }
                        } else if (parametroImprimirRomaneio == '2') {
                          msgAlerta('Deseja imprimir a venda?', async () => {
                            await imprimirRomaneio(venda_gerada, "<?php echo BASE_URI; ?>");
                            await toastrFinalizarVenda(mensagem, async () => {
                              await ImprimirCupomTrocaAutomatico();
                            });
                          }, async () => {
                            await toastrFinalizarVenda(mensagem, async () => {
                              await ImprimirCupomTrocaAutomatico();
                            });
                          })
                          if ((!bSaiuPDV) && (!bCfe) && (!bNfe)) {
                            window.location.href = redirectUrl;
                          }
                        } else {
                          await toastrFinalizarVenda(mensagem, async () => {
                            await ImprimirCupomTrocaAutomatico();
                          });
                          if ((!bSaiuPDV) && (!bCfe) && (!bNfe)) {
                            window.location.href = redirectUrl;
                          }
                        }
                      } else {
                        const parametroImprimirRomaneio = parametrosVenda[34];
                        if (!parametroImprimirRomaneio || parametroImprimirRomaneio == '0') {
                          await imprimirRomaneio(venda_gerada, "<?php echo BASE_URI; ?>");
                          await toastrFinalizarVenda(mensagem, async () => {
                            await ImprimirCupomTrocaAutomatico();
                            if ((!bSaiuPDV) && (!bCfe) && (!bNfe)) {
                              window.location.href = redirectUrl;
                            }
                          });
                        } else if (parametroImprimirRomaneio == '2') {
                          msgAlerta('Deseja imprimir a venda?', async () => {
                            await imprimirRomaneio(venda_gerada, "<?php echo BASE_URI; ?>");
                            await toastrFinalizarVenda(mensagem, async () => {
                              await ImprimirCupomTrocaAutomatico();
                              if ((!bSaiuPDV) && (!bCfe)) {
                                window.location.href = redirectUrl;
                              }
                            });
                          }, async () => {
                            await toastrFinalizarVenda(mensagem, async () => {
                              await ImprimirCupomTrocaAutomatico();
                              if ((!bSaiuPDV) && (!bCfe)) {
                                window.location.href = redirectUrl;
                              }
                            });
                          })
                        } else {
                          await toastrFinalizarVenda(mensagem, async () => {
                            await ImprimirCupomTrocaAutomatico();
                            if ((!bSaiuPDV) && (!bCfe)) {
                              window.location.href = redirectUrl;
                            }
                          });
                        }
                      }
                    } else if (!bNfeAut) {
                      const parametro = parametrosVenda[27];
                      if (!parametro || parametro == '0') {
                        await imprimirRomaneio(venda_gerada, "<?php echo BASE_URI; ?>");
                        await toastrFinalizarVenda(mensagem, async () => {
                          await ImprimirCupomTrocaAutomatico();
                          if (!bSaiuPDV) {
                            window.location.href = redirectUrl;
                          }
                        });
                      } else if (parametro == '2') {
                        msgAlerta('Deseja imprimir a venda?', async () => {
                          await imprimirRomaneio(venda_gerada, "<?php echo BASE_URI; ?>");
                          await toastrFinalizarVenda(mensagem, async () => {
                            await ImprimirCupomTrocaAutomatico();
                            if (!bSaiuPDV) {
                              window.location.href = redirectUrl;
                            }
                          });
                        }, async () => {
                          await toastrFinalizarVenda(mensagem, async () => {
                            await ImprimirCupomTrocaAutomatico();
                            if (!bSaiuPDV) {
                              window.location.href = redirectUrl;
                            }
                          });
                        })
                      } else {
                        await toastrFinalizarVenda(mensagem, async () => {
                          await ImprimirCupomTrocaAutomatico();
                          if (!bSaiuPDV) {
                            window.location.href = redirectUrl;
                          }
                        });
                      }
                    }
                  } else if (!bMfe) {
                    const hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                    await deletaVendaNaoSalva(hostname + '.txt');
                    await ImprimirCupomTrocaAutomatico();
                  }

                  let arrayMoedas = []
                  for (let i = 0; i < $('#tabelaCondicoesDePagamento').DataTable().rows().count(); i++) {
                    arrayMoedas.push($('#tabelaCondicoesDePagamento').DataTable().row(i).data()[1].split(' - ')[0])
                  }

                  if (arrayMoedas.length > 0) {
                    if (await verificaMoedaCarne(arrayMoedas)) {
                      let url = `/sisplan/impressao/v1/carne?CODVEN=${numero_venda}`;
                      const bImprimeAutomatico = await verificaImprimirAutomatico('Carne');
                      let arquivo = await GeraRelatorio(`${url}&`, 'GET', 15000, false, 'Carne');
                      if (arquivo != undefined) {
                        if (!bImprimeAutomatico) {
                          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                        }
                        await limparRelatorios();
                      }
                    }
                  }
                  await verificaVendaFinalizadaEEnviaWhatsApp(BASE_URI, numero_venda, "VENDA");
                  await deletaRegistro('LOJA', getCookie('usuario'), numero_venda, 'SISTEMA');
                  await geraLogDesconto(numero_venda)

                  await ajustaSolicitacaoSupervisorVenda(localStorage.getItem(`SEQUENCIALVENDAPENDENTE`), numero_venda, async () => {
                    localStorage.removeItem(`SEQUENCIALVENDAPENDENTE`)
                  })

                  return true;
                } finally {
                  $.LoadingOverlay("hide");
                  $.LoadingOverlay("hide");
                }
              }

            } finally {
              $('#btnFinalizar').prop('disabled', false);
              $.LoadingOverlay("hide");
            }
          }
        } catch (error) {
          console.error(error);
          $.LoadingOverlay("hide");
          msgErro('Erro ao gravar a venda.');
          $('#btnConfirmarTroco').prop('disabled', false);
          $('#btnFinalizar').prop('disabled', false);
          return false;
        }
      }

      async function RotinaCliquePagamento() {

        if (await validaTodosItensRateados()) {
          msgAlerta('Alguns itens foram adicionados após a pesagem, favor pesar novamente.', () => {
            $('#modalPesoBalanca').modal('show');
          });
          return;
        }

        if (bloqueiaAbasInfosEItensVenda && await validaVendaGerouDeConsignado(numero_venda)) {
          $('#btnVenda').prop('disabled', true);
          $('#btnInfo').prop('disabled', true);
        } else {
          $('#btnVenda').prop('disabled', false);
          $('#btnInfo').prop('disabled', false);
        }
        $('#btnPagamento').prop('disabled', true);
        fs_venda = $('#fieldset_venda');
        fs_pagamento = $('#fieldset_pagamento');
        fs_info = $('#fieldset_info');

        $("#progressbar li").eq($("fieldset").index(fs_pagamento)).addClass("active");
        fs_pagamento.show();
        fs_venda.animate({
          opacity: 0
        }, {
          step: function(now) {
            opacity = 1 - now;
            fs_venda.css({
              'display': 'none',
              'position': 'relative'
            });

            fs_info.css({
              'display': 'none',
              'position': 'relative'
            });

            fs_pagamento.css({
              'opacity': opacity
            });
          },
          duration: 100
        });

        const parametroUsaAcrescimo = parametrosVenda[26];
        if ((parametroUsaAcrescimo == '1')) {
          $('#PainelAcrescimo').removeClass('d-none');
        } else {
          $('#PainelAcrescimo').addClass('d-none');
          $('#painelValorParcela').removeClass('col-sm-6');
          $('#painelValorParcela').addClass('col-sm-4');
          $('#PainelDesconto').removeClass('col-sm-6');
          $('#PainelDesconto').addClass('col-sm-4');
          $('#painelValorLiquido').removeClass('col-sm-6');
          $('#painelValorLiquido').addClass('col-sm-4');
        }

        if (parametroValorIPIVenda) {
          await rotinaAplicaValorIPI(false);
        }

        if (parametroValorRetIva) {
          await rotinaAplicaValorRetencaoIva();
        }

        var sCodCli = pegaChave('#txtCliente', sCodCli);
        await carregaAntecipacoes(sCodCli);
        await atualizaSaldoAPagar();
        await atualizaTotaisPagto();


        if (bUtilizaCashbackCRMBonus && !jaUtilizouCashback) {
          $("#modalCRMBonus").modal("show");
        }
        $("#txtMoeda").focus();
        $('#tabelaCondicoesDePagamento').DataTable().columns.adjust().draw(false);

        const pesquisaParam = {
          tabela: 'CUPOMDESCONTO',
          camposSelect: ['*'],
          where: [`CODCLI <> '' AND CODCLI IS NOT NULL`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        const dtAt = retornaDataAtual();

        if (jsonStr.length > 0) {
          $('#btn-cupom-desconto').pesquisa('#txtCupomDesconto',
            'CODIGO',
            'DESCRICAO',
            `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CUPOMDESCONTO","camposSelect": ["CODIGO", "DESCRICAO", "CODCLI", "PERC_DESC", "QUANTIDADE", "VALOR", "(select COUNT(*) from [VENDA] VENDA where VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO) QTDE_UTILIZADA", "(QUANTIDADE -  (select COUNT(*) from [VENDA] VENDA where VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO)) SALDO"], "where": ["CODCLI = '${sCodCli}' AND (QUANTIDADE - (select COUNT(*) from [VENDA] VENDA where VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO)) > 0 AND (CUPOMDESCONTO.DT_INICIO <= '${dtAt}' AND CUPOMDESCONTO.DT_FINAL >= '${dtAt}')"]}`,
            'Pesquisa Cupom Desconto',
            'CUPOMDESCONTO',
            true);
        } else {
          $('#btn-cupom-desconto').pesquisa('#txtCupomDesconto',
            'CODIGO',
            'DESCRICAO',
            `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CUPOMDESCONTO","camposSelect": ["CODIGO", "DESCRICAO", "CODCLI", "PERC_DESC", "QUANTIDADE", "VALOR", "(select COUNT(*) from [VENDA] VENDA where VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO) QTDE_UTILIZADA", "(QUANTIDADE -  (select COUNT(*) from [VENDA] VENDA where VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO)) SALDO"], "where": ["(QUANTIDADE -  (select COUNT(*) from [VENDA] VENDA where VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO)) > 0 AND (CUPOMDESCONTO.DT_INICIO <= '${dtAt}' AND CUPOMDESCONTO.DT_FINAL >= '${dtAt}')"]}`,
            'Pesquisa Cupom Desconto',
            'CUPOMDESCONTO',
            true);
        }
      }

      function RotinaCliqueVenda() {
        $('#btnVenda').prop('disabled', true);
        $('#btnInfo').prop('disabled', false);
        $('#btnPagamento').prop('disabled', false);

        fs_venda = $('#fieldset_venda');
        fs_pagamento = $('#fieldset_pagamento');
        fs_info = $('#fieldset_info');

        $("#progressbar li").eq($("fieldset").index(fs_venda)).addClass("active");
        fs_venda.show();
        fs_info.animate({
          opacity: 0
        }, {
          step: function(now) {
            opacity = 1 - now;
            fs_pagamento.css({
              'display': 'none',
              'position': 'relative'
            });

            fs_info.css({
              'display': 'none',
              'position': 'relative'
            });

            fs_venda.css({
              'opacity': opacity
            });
          },
          duration: 100
        });
        focaCampo();
        $('#tabelaItens').DataTable().columns.adjust().draw(false);
      }

      var queryString = window.location.href;
      var parametros = queryString.split('/');
      var numero_venda = parametros[parametros.length - 1];
      var storageVendaPendente = `SEQ${Math.floor(1000000 + Math.random() * 9000000)}`
      if ((numero_venda != 'create') && (numero_venda != 'create#')) {
        $('#txt_venda_atual').html(`<span style="color:green">${numero_venda}</span>`);
      } else {
        $('#txt_venda_atual').html('<span style="color:green">Nova</span>');
        localStorage.setItem(`SEQUENCIALVENDAPENDENTE`, storageVendaPendente)
      }

      if (parametrosVenda[26] == '1') {
        $('#PainelAcrescimo').removeClass('d-none');
      } else {
        $('#PainelAcrescimo').addClass('d-none');
      }
      var tabelaProdutoMaterial = $('#tabelaProdutoMaterial').dataTable({
        paging: true,
        lengthChange: false,
        filter: true,
        info: true,
        order: true,
        autoWidth: true,
        destroy: true,
      });
      var tabelaMaterial = $('#tabelaMaterial').dataTable({
        scrollY: 'calc(100vh - 350px)', // Definindo a altura máxima da tabela com rolagem vertical
        scrollX: true, // Habilitando a rolagem horizontal
        scrollCollapse: true,
        fixedColumns: {
          leftColumns: 0 // Define zero colunas fixas à esquerda (desativa a fixação horizontal)
        },
        paging: true,
        lengthChange: false,
        info: true,
        pageLength: 100,
        autoWidth: true,
        destroy: true,
        colReorder: true,
        ordering: false,
        order: false,
        filter: true,
      });

      var tabelaItens = $('#tabelaItens').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: [],
        ordering: true,
        destroy: true,
        scrollX: '250px',
        scrollY: '290px',
        "columnDefs": [{
            "targets": [0, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33],
            "visible": false
          },
          {
            "targets": [1],
            "width": '250px'
          },
          {
            targets: 4,
            render: function(data, type, row, meta) {
              const percDesconto = ArredondarValor(Number(row[5]), 2);
              const valDesconto = ArredondarValor(Number(row[6]), 2);
              if ((parseFloat(row[6]) != 0) && ($(`#tabelaItens tbody>tr:eq(${meta.row}) td:eq(3)`).length > 0)) {
                // $(`#tabelaItens tbody>tr:eq(${meta.row}) td:eq(3)`).addClass('textDesconto');
                $($(`#tabelaItens`).DataTable().row(meta.row).node()).find('td:eq(3)').addClass('textDesconto');
              } else {
                // $(`#tabelaItens tbody>tr:eq(${meta.row}) td:eq(3)`).removeClass('textDesconto');
                $($(`#tabelaItens`).DataTable().row(meta.row).node()).find('td:eq(3)').removeClass('textDesconto');
              }

              $($(`#tabelaItens`).DataTable().row(meta.row).node()).find('td:eq(3)').prop('data-toggle', 'tooltip');
              $($(`#tabelaItens`).DataTable().row(meta.row).node()).find('td:eq(3)').prop('data-placement', 'bottom');
              $($(`#tabelaItens`).DataTable().row(meta.row).node()).find('td:eq(3)').prop('title', `Valor Desconto: R$ ${valDesconto} \n Percentual Desconto: ${percDesconto} %`);
              // $(`#tabelaItens tbody>tr:eq(${meta.row}) td:eq(3)`).prop('data-toggle', 'tooltip');
              // $(`#tabelaItens tbody>tr:eq(${meta.row}) td:eq(3)`).prop('data-placement', 'bottom');
              // $(`#tabelaItens tbody>tr:eq(${meta.row}) td:eq(3)`).prop('title', `Valor Desconto: R$ ${valDesconto} \n Percentual Desconto: ${percDesconto} %`);
              $('[data-toggle="tooltip"]').tooltip();
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: quantidadeCasasDecimaisCampo,
                minimumFractionDigits: quantidadeCasasDecimaisCampo
              });

            },
            "className": 'pr-4 text-right'
          },
          {
            "render": function(data) {
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: quantidadeCasasDecimaisCampo,
                minimumFractionDigits: quantidadeCasasDecimaisCampo
              });
            },
            "targets": [3],
            "className": 'pr-4 text-right'
          },
          {
            "render": function(data) {
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            "targets": [7],
            "className": 'pr-4 text-right'
          },
          {
            "targets": [2],
            "className": 'pr-4 text-right'
          }
        ],
      });

      $('#tabelaDuplicatasEmAberto').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
      });

      $('[data-toggle="tooltip"]').tooltip();

      var tabelaParcelasGeradas = $('#tabelaParcelasGeradas').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
      });

      var tabelaCondicoes = $('#tabelaCondicoesDePagamento').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '300px',
        "columnDefs": [{
            "targets": [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16],
            "visible": false
          },
          {
            "render": function(data) {
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            "targets": [3, 4, 5],
            "className": 'pr-4 text-right'
          }
        ],
      });


      let tabelaItensRegraPromocao = $('#tabelaItensRegraPromocao').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
      });

      let tabelaBrindesPromocao = $('#tabelaBrindesPromocao').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
      });

      let tabelaItensUtilizamRegra = $('#tabelaItensUtilizamRegra').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
      });

      if ((utilizaGuia != "0")) {
        $('#GuiaInfoTour').removeClass('d-none');
        $('#txtGuia').removeClass('d-none');
      }

      if ((bUtilizaStatus == '1')) {
        $('#statusInfoTour').removeClass('d-none');
        $('#txtStatus').removeClass('d-none');
        $('.dtEntrega').removeClass('d-none')
      }

      if (bUtilizaVendedorPorItem) {
        $('.divVendedorItem').removeClass('d-none');
      }

      if (bUtilizaCashback) {
        $('#divCliente').removeClass('col-md-6').addClass('col-md-4');
        $('#divCashback').removeClass('d-none');
        $('#painelCashback').removeClass('d-none');
      }

      async function verificaTabelaEmpresaLogada() {
        const tabelaParam = parametrosVenda[2];
        if (tabelaParam != '') {
          const tabela = 'REGIAO'
          const chaveTabela = pegaChave(tabelaParam);
          const temRegistroNaEmpValor = await fazSelectNaEmpValor('', tabela);
          if (temRegistroNaEmpValor.length > 0) {
            for (let i = 0; i < temRegistroNaEmpValor.length; i++) {
              const dados = temRegistroNaEmpValor[i];
              const encontrouCodigo = dados.VALOR == chaveTabela
              if (encontrouCodigo) {
                return true;
              }
            }
            return false
          }
          return true;
        } else {
          return false
        }
      }

      async function preencheTabela() {
        const dadosTipoVenda = await BuscaTiposVenda($('#txtTipoVenda').val());
        const tabelaParam = parametrosVenda[2];
        const tabela = await verificaTabelaEmpresaLogada();
        const tabelaVendedorCaixa = sessionStorage.getItem('g_tabpreco_vendedor_caixa');
        if (dadosTipoVenda[0].TABELA) {
          insereValor('#txtTabela', dadosTipoVenda[0].TABELA, {
            tabela: 'REGIAO',
            campoBusca: 'DESCRICAO',
            campoWhere: 'REGIAO',
            valorWhere: dadosTipoVenda[0].TABELA
          });
          $('#btn-Tabela').off();
          $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": ["REGIAO = '${dadosTipoVenda[0].TABELA}'"]}`, 'Pesquisa Tabela', 'regiao', '', confirmaAlteracaoTabela);
          $('#txtTabela').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": ["REGIAO = '${dadosTipoVenda[0].TABELA}'"]}`);
          if ($("#txtTabPrecoBrinde").val() == "") {
            insereValor('#txtTabPrecoBrinde', dadosTipoVenda[0].TABELA, {
              tabela: 'REGIAO',
              campoBusca: 'DESCRICAO',
              campoWhere: 'REGIAO',
              valorWhere: dadosTipoVenda[0].TABELA
            });
          }
          $('#btnTabPrecoBrinde').off();
          $('#btnTabPrecoBrinde').pesquisa('#txtTabPrecoBrinde', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": ["REGIAO = '${dadosTipoVenda[0].TABELA}'"]}`, 'Pesquisa Tabela', 'regiao', '', confirmaAlteracaoTabela);
          $('#txtTabPrecoBrinde').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": ["REGIAO = '${dadosTipoVenda[0].TABELA}'"]}`);
        } else if (tabela) {
          $('#btn-Tabela').off();
          $('#txtTabela').val(tabelaParam);
          $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao', '', confirmaAlteracaoTabela);
          $('#btn-TabelaImpVenda').pesquisa('#txtTabelaImpVenda', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao');
          $('#btnTabPrecoBrinde').off();
          if ($("#txtTabPrecoBrinde").val() == "") {
            $('#txtTabPrecoBrinde').val(tabelaParam);
          }
          $('#btnTabPrecoBrinde').pesquisa('#txtTabPrecoBrinde', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao', '');
        } else if (tabelaParam == '' && tabelaVendedorCaixa != '') {
          $('#txtTabela').val(tabelaVendedorCaixa)
        } else {
          $('#txtTabela').val('');
        }
        $('#txtTabela').attr('data-selecionado', true);
      }

      let selectBtnClienteUltimoMovimento;

      if ((numero_venda != 'create') && (numero_venda != 'create#')) {
        if (localStorage.getItem('emitiuNotaConsignado')) {
          if (parent.document.querySelectorAll(`[id^="tab--sisplan_web-venda-"]`)[0]) {
            const numVenda = parent.document.querySelectorAll(`[id^="tab--sisplan_web-venda-"]`)[0].id.split('venda-')[1]
            let abaAtiva = numVenda != 'create' ? numVenda : 'create'
            if (parent.document.querySelectorAll(`[id^="tab--sisplan_web-venda-${abaAtiva}"]`)[0].id) {
              parent.document.querySelectorAll(`#tab--sisplan_web-venda-${abaAtiva}`)[0].click()
            }
          }
          localStorage.removeItem('emitiuNotaConsignado')
        }

        await carregaDadosVenda();
        await telaInicial();
        pesquisaCliente();
      } else {
        // try {
        //   var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
        //   response = await carregaVendaNaoSalva(hostname);
        // } catch (error) {}

        // if (response.status == 200) {
        //   await carregaDadosVenda();
        //   await telaInicial();
        // } else {

        // PREENCHE DEPÓSITO
        const depositoParam = parametrosVenda[1];
        const depositoVendedorCaixa = sessionStorage.getItem('g_deposito_vendedor_caixa');
        if (depositoParam == '' && depositoVendedorCaixa != '') {
          $('#txtDeposito').val(depositoVendedorCaixa);
        } else {
          $('#txtDeposito').val(depositoParam);
        }
        $('#txtDeposito').attr('data-selecionado', true);
        // PREENCHE TABELA DE PREÇO
        await preencheTabela()
        // PREENCHE VENDEDOR
        const vendedor = sessionStorage.getItem('g_vendedor_logado');
        $('#txtVendedor').val(vendedor);
        if ($('#txtVendedor').val() == '') {
          await buscaVendedorCliente(pegaChave('#txtCliente'));
        }

        if (parametrosVenda[77] == '1') {
          const vendedor = await buscaVendedorUsuario();
          insereValor('#txtVendedor', vendedor.CODREP, vendedor.NOME);
          $("#txtVendedor").prop('disabled', true);
          $("#btn-vendedor").prop('disabled', true);
          $("#btn-limpa-vendedor").prop('disabled', true);
          const deposito = await buscaDepositoUltimoMovimento(vendedor.CODREP);
          insereValor('#txtDeposito', deposito.DEPOSITO, deposito.DESCRICAO);
          $("#txtDeposito").prop('disabled', true);
          $("#btn-deposito").prop('disabled', true);
          $("#btn-limpa-deposito").prop('disabled', true);
          selectBtnClienteUltimoMovimento = {
            tabela: "ENTIDADE",
            camposSelect: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME CIDADE", "CADCEP.ESTCEP"],
            leftJoin: [{
                tabela: "CADCEP",
                condicao: "CADCEP.CEP = ENTIDADE.CEP"
              },
              {
                tabela: "CIDADE",
                condicao: "CIDADE.CODIGO = CADCEP.CODMUN"
              }
            ],
            where: [`ENTIDADE.REG_ESTADO = '${deposito.REGIAO}'`],
            camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
          }
          const selectTxtClienteMovimento = {
            tabela: "ENTIDADE",
            camposSelect: ["CODCLI CHAVE", "NOME ||' - '|| CNPJ DESCRICAO", "CNPJ"],
            where: [`ENTIDADE.REG_ESTADO = '${deposito.REGIAO}'`]
          }
          $('#txtCliente').unbind('autocompleta');
          $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtClienteMovimento)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);

          if (bloqueiaAbasInfosEItensVenda) {
            const ultimoClienteVenda = await buscaClienteUltimaVenda(deposito.REGIAO);
            if (ultimoClienteVenda != "") {
              insereValor("#txtCliente", ultimoClienteVenda.CODCLI, ultimoClienteVenda.NOME);
            }
          }

        }

        // AUTOCOMPLETA MODAL CLIENTE => FOI ADICIONADO NESSA PAGE DEVIDO AO IMPORT DA LIB SELECT2 NÃO FUNCIONAR NO MODAL
        $('#txtMoedaModal').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');
        $('#txtVendedor').attr('data-selecionado', true);

        rotinaSaidaVendedor();

        // PREENCHE CLIENTE
        if (getCookie('cliente_devolucao')) {
          $('#txtCliente').val(getCookie('cliente_devolucao'));
          deleteCookie('cliente_devolucao');
          codven_devolucao = getCookie('codven_devolucao') ?? '';
          const sCodCli = pegaChave('#txtCliente');
          carregaAntecipacoes(sCodCli);
          msgSucesso('Crédito criado a partir da devolução anterior, estará disponível nos pagamentos da venda atual.');
        } else {
          const clienteParam = parametrosVenda[3];
          if (clienteParam != "" && $("#txtCliente").val() == "") {
            $('#txtCliente').val(clienteParam);
          }
          const sCodCli = pegaChave('#txtCliente');
          await habilitaCampoDescricao(sCodCli);
          carregaAntecipacoes(sCodCli);
        }
        $('#txtCliente').attr('data-selecionado', true);
        if ($('#txtCliente').val() != '') {
          const sCNPJ = await RetornaCNPJ(pegaChave('#txtCliente'));
          $('#txtCNPJ').val(sCNPJ);
        }

        const vendedorGuia = pegaChave('#txtVendedor');
        await preencheVendedorGuia(vendedorGuia);
        await telaInicial();
        // }
      }

      async function preencheVendedorGuia(sCodigo, bValidaGuia = false) {

        if (bValidaGuia) {
          if ($('#txtGuia').val() != '') {
            return;
          }
        }
        let pesquisaVendedorGuia = {};
        const emp_id = sessionStorage.getItem('emp_id');

        if (await ExisteGuiaVendedor(sCodigo)) {
          pesquisaVendedorGuia = {
            tabela: 'REP_GUIA',
            camposSelect: ['REP_GUIA.GUIA CODREP', 'REPRESEN.NOME'],
            leftjoin: [{
              "tabela": "REPRESEN",
              "condicao": "REPRESEN.CODREP = REP_GUIA.GUIA"
            }],
            where: [`REP_GUIA.CODREP = '${sCodigo}'`]
          };
        } else {
          pesquisaVendedorGuia = {
            tabela: 'REPRESEN',
            camposSelect: ['CODREP', 'NOME'],
            innerjoin: [{
              "tabela": "EMP_VALOR",
              "condicao": `EMP_VALOR.TABELA = 'REPRESEN' AND EMP_VALOR.VALOR = REPRESEN.CODREP AND EMP_VALOR.EMP_ID = ${emp_id}`
            }],
            where: ["ATIVO = 'S'"]
          }
        };

        let contagemGuias = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaVendedorGuia));

        if (!contagemGuias) {
          return;
        }

        if (contagemGuias.length == 1) {
          insereValor('#txtGuia', contagemGuias[0].CODREP, contagemGuias[0].NOME)
          // $('#txtGuia').val('[' + contagemGuias[0].CODREP + '] - ' + contagemGuias[0].NOME);
          $('#txtGuia').focus();
          return;
        } else {
          return;
        }

      }

      $('#btn-limpa-tabela-desc').on('click', function() {
        $('#txtTabelaDesc').val('');
      });

      async function carregaVendaNaoSalva(sNomeMaquina) {
        let response;
        let myHeaders = new Headers();
        myHeaders.append('pragma', 'no-cache');
        myHeaders.append('cache-control', 'no-cache');
        try {
          response = await fetch(`<?php echo BASE_URI; ?>/${sNomeMaquina}.txt`, {
            headers: myHeaders,
            method: 'GET',
            body: null,
          }, );
        } catch (error) {
          return;
        }
        return response;
      }

      $('#txtCliente').on('blur', async function() {
        await blurCliente();
      });

      $('#txtCliente').on('keydown', function(e) {
        if (e.key == 'Enter') {
          e.preventDefault();
          $('#txtCNPJ').focus();
        }
      });

      $('#txtCNPJ').on('keydown', function(e) {
        if (e.key == 'Enter') {
          e.preventDefault();
          if ($(this).val() != ''){
            $('#txtVendedor').focus();
          }
        }
      });
      
      $('#txtVendedor').on('keydown', function(e) {
        if (e.key == 'Enter') {
          e.preventDefault();
          if ($(this).val() != ''){
            if (!$('#GuiaInfoTour').hasClass('d-none')) {
              $('#txtGuia').focus();
            } else {
              $('#txtTabela').focus();   
            }
          }
        }
      });

      $('#txtGuia').on('keydown', function(e) {
        if (e.key == 'Enter') {
          e.preventDefault();
          $('#txtTabela').focus();
        }
      });

      $('#txtTabela').on('keydown', function(e) {
        if (e.key == 'Enter') {
          e.preventDefault();
          if ($(this).val() != ''){
            $('#txtDeposito').focus();
          }
        }
      });

      $('#txtCliente').on('change', async function() {
        await changeCliente();
      });

      async function callbackDuplicatasAtraso() {
        localStorage.setItem('@venda.cliente', $('#txtCliente').val());
        $('#btnVenda').attr('disabled', true);
        $('#btnPagamento').attr('disabled', true);
        $('#btnFinalizar').attr('disabled', true);

        await msgAguardaConfirmacao("Cliente possui duplicatas em atraso, necessário efetuar a negociação antes de iniciar nova venda.",
          () => {
            const estaEmOutraAba = $('#fieldset_info').css('display') == 'none';
            $('#btnVenda').attr('disabled', false);
            $('#btnPagamento').attr('disabled', false);
            $('#btnFinalizar').attr('disabled', false);
            if (estaEmOutraAba) {
              $('#btnInfo').trigger('click');
            }
            $('#textDescricaoVenda').focus();
            setTimeout(() => {
              $('#txtCliente').focus();
            }, 2000);
            window.open(`${BASE_URI}/receber`, "_blank");
          },
          () => {
            $('#btnVenda').attr('disabled', false);
            $('#btnPagamento').attr('disabled', false);
            $('#btnFinalizar').attr('disabled', false);
            $('#txtCliente').focus();
            const estaEmOutraAba = $('#fieldset_info').css('display') == 'none';
            if (estaEmOutraAba) {
              $('#btnInfo').trigger('click');
            }
          }
        );
        $('#btn-msg-alerta').html('Abrir Receber (ALT+S)');
      }

      async function changeCliente() {
        const codCli = pegaChave("#txtCliente");
        await carregaTabelaCliente(codCli);
      }

      async function blurCliente() {
        if ($('#txtCliente').val() != '') {
          try {
            const bloqueiaSeTiverConsignadoPendente = parametrosVenda[76] == '1';
            const bloqueiaDuplicatasAtrasoMes = parametrosVenda[23] == '4';
            if (bloqueiaSeTiverConsignadoPendente && bloqueiaDuplicatasAtrasoMes) {
              $('#modal-warning-conteudo').val('');
              $('#btnVenda').attr('disabled', true);
              $('#btnPagamento').attr('disabled', true);
              $('#btnFinalizar').attr('disabled', true);
            }
            const sCodCli = pegaChave('#txtCliente');
            const sNome = pegaDescricao('#txtCliente');
            if ((parametrosVenda[76] == '1') && (await validaVendaPendente(sCodCli, sNome))) {
              return;
            }
            if (!await verificaCliente(sCodCli)) {
              return;
            };
            await validaDataValidadeLimite(sCodCli);
            await carregaDuplicatas(sCodCli, 'VENDA', callbackDuplicatasAtraso);

            if (parametrosVenda[85] == '1') {
              $('#btn-info-cliente').trigger('click');
            }

            await habilitaCampoDescricao(sCodCli);
            await carregaAntecipacoes(sCodCli);
            await recalCredCliente(sCodCli, controleLimiteCredito == '1');
            await carregaLimiteCredito(sCodCli);

            await verificaRegrasMontadas(true);
            await carregaCashback(sCodCli);
            if (!["3", "4"].includes(utilizaGuia)) {
              await buscaVendedorCliente(sCodCli);
            }
            await buscaGuiaCliente(sCodCli, utilizaGuia);
            if ($("#txtCNPJ").val().substring(0, 1) == '[') {
              $("#txtCNPJ").val(pegaChave("#txtCNPJ"));
            }
            if ((parametrosVenda[68] == 1) || (parametrosVenda[68] == 2)) {
              await buscaDadosIShopp($("#txtCNPJ").val(), sCodCli);
            } else if (parametrosVenda[69] == 1) {
              await buscaDadosClienteNetShopping($("#txtCNPJ").val(), sCodCli);
            }
            if (bInformacoesCliente) {
              $("#btn-info-cliente").trigger("click");
            }

            await buscaCupomDesconto(sCodCli);
            g_DescCliente = await buscaValor('ENTIDADE', 'DESCONTO', 'CODCLI', sCodCli);
            g_DescCliente = !g_DescCliente ? 0 : g_DescCliente;
          } finally {
            $('#btnVenda').attr('disabled', false);
            $('#btnPagamento').attr('disabled', false);
            $('#btnFinalizar').attr('disabled', false);

            $('#btnNFCE').prop('disabled', (parametrosVenda[112] == '1') && ($('#txtCNPJ').val().length > 14));
          }
        }
      }

      async function buscaDadosIShopp(sCNPJ, sCodcli) {
        const sIntegra = await buscaValor('ENTIDADE', 'INTEGRA_SHOPP', 'CODCLI', sCodcli);

        if (sIntegra == 'N') {
          return;
        }
        let response;
        let mensagem;
        let valor;
        $.LoadingOverlay("show");
        try {
          response = await requisicao_ecf('GET', '/ishopp/buscadados?', `CNPJ=${sCNPJ}`);

          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }
          response = await response.json();
          if (response.retorno != '') {
            valor = response.limite == '' ? 0 : response.limite;
            mensagem = `
            Cliente da Agencia: ${response.agencia}
            Tem o prazo do dia: ${response.prazo.substring(0,2)}/${response.prazo.substring(2,4)}/${response.prazo.substring(4,8)}
            Com o Limite: ${parseFloat(valor).toFixed(2)}
            Este cliente tem cheque Liberado: ${response.cheque}
            Restrição para compra: ${response.restrCompra}`;
            if (response.codErro.trim() == 'ERRO') {
              mensagem = `Erro na Consulta iBasi, Mensagem: ${response.msgErro}`
            }

            msgAlerta(mensagem);
          }
        } catch (error) {
          console.error(error);
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      async function buscaDadosClienteNetShopping(sCNPJ, sCodCli) {
        const sIntegra = await buscaValor('ENTIDADE', 'INTEGRA_SHOPP', 'CODCLI', sCodCli);

        if (sIntegra == 'N') {
          return;
        }
        let response;
        let mensagem;
        let valor;
        $.LoadingOverlay("show");
        try {
          const url = "/sisplan/vendas/v1/netshopping?";
          let response = await requisicao(
            "GET",
            url,
            `CNPJ=${sCNPJ}`,
            null
          );

          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }
          let jsonStr = await response.json();
          if (jsonStr.situacao == 'RESTRICAO') {
            valor = jsonStr.limite == '' ? 0 : jsonStr.limite;
            mensagem =
              `Restrição: ${jsonStr.situacao}\nDescrição: ${jsonStr.ds_situacao}`;
          } else {
            mensagem =
              `Guia: ${jsonStr.cd_guia}\nNome guia: ${jsonStr.nm_guia}\nLiberado compra cheque: ${jsonStr.fl_liberado_compra_cheque}\nLiberado para compra: ${jsonStr.fl_bloqueado_para_compra}\nSaldo: ${jsonStr.saldo.replaceAll('.',',')}`;
              insereValor('#txtCodGuiaIntegracao', jsonStr.cd_guia, jsonStr.nm_guia);
            }
          msgAlerta(mensagem);
          $.LoadingOverlay("hide");
        } catch (error) {
          console.error(error);
          $.LoadingOverlay("hide");
        }
      }

      // $('#modal-receberabertos').on('hidden.bs.modal', function() {
      //   $('#txtCNPJ').focus();
      // });

      $('#modal-receberabertos').on('hidden.bs.modal', async function() {
        let bAtraso = parametrosVenda[23];
        if ($('#txtValDupVencida').html() > 0) {
          if (bAtraso == 0) {
            msgAlerta('Cliente possui duplicatas em atraso.');
            setTimeout(() => {
              $('#txtVendedor').focus();
            }, 100);
          } else if (bAtraso == 1) {
            msgAlerta('Cliente possui duplicatas em atraso, impossível continuar.');
            $('#txtCliente').val('');
            setTimeout(() => {
              $('#txtCliente').focus()
            }, 100);
          } else if (bAtraso == 2) {
            let senha = await senhaSupervisor('Cliente possui duplicatas em atraso.', callbackSenha, $('#txtCliente').val(), false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
            $('#txtCliente').val('');
          }
        }
      })

      function callbackSenha(cliente) {
        $('#txtCliente').val(cliente);
        setTimeout(() => {
          $('#txtVendedor').focus();
        }, 100);
      }

      async function habilitaCampoDescricao(codigo) {
        try {
          const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["CONS_FINAL"],"where": ["CODCLI = '${codigo}'"]}`, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }

          // if ((jsonStr.RESULT[0][0].CONS_FINAL == 'Sim')) {
          //   $('#descricaoVenda').removeClass('d-none');
          // } else {
          //   $('#descricaoVenda').addClass('d-none');
          // }
        } catch (error) {

        }
      }

      $('#txt-cliente').on('blur', async function() {
        if ($(this).val() != '') {
          var sCodCli = pegaChave('#txt-cliente', sCodCli);
          await verificaClientePagamento(sCodCli);
        }
      });

      async function verificaEPreencheUnicaRegra() {
        try {
          const json = await retornaJsonPesquisaPadrao(`{ "TABELA":"REGRA_PROMOCAO", "camposSelect":["REGRA", "DESC_REGRA"], "where": ["REGIAO = '${pegaChave('#txtTabela')}'"], "groupBy": ["REGRA", "DESC_REGRA"] }`);

          if (json) {
            if (json.length == 1) {
              insereValor('#txtRegraPromocao', json[0].REGRA, json[0].DESC_REGRA);
              $('#btnRecalcularRegra').trigger('click');
            }
          }
        } catch (error) {
          console.error(error);
        }
      }

      async function verificaTabelaPrecoKG() {
        try {
          if (pegaChave('#txtTabela') === '') {
            return;
          }

          const json = await retornaJsonPesquisaPadrao(`{ "TABELA":"REGIAO", "camposSelect":["PRECO_KG"], "where": ["REGIAO = '${pegaChave('#txtTabela')}'"] }`);

          if (json) {
            if (json.length == 1) {
              if ((json[0].PRECO_KG) && (json[0].PRECO_KG > 0)) {
                $('#btn-rateiaPesoItens').removeClass('d-none');
                return true
              } else {
                $('#btn-rateiaPesoItens').addClass('d-none');
                return false;
              }
            }
          }
        } catch (error) {
          console.error(error);
        }
      }

      function vendaOriginadaDeUmAgrupamento() {
        if (vendaOriginadaDeAgrupamento) {
          msgAlerta('Venda originada de um agrupamento, impossível executar ação.');
          return true;
        }
        return false;
      }

      async function verificaSeVeioDeAgrupamento(codVen) {
        try {
          if ((codVen) && (codVen != 'create') && (codVen != 'create#') && (codVen != 'vendapendente') && (codVen != 'vendapendente#')) {
            const pesquisa = {
              tabela: 'VENDA',
              camposSelect: ['CDAGRUPADA', 'TIPO_VENDA'],
              where: [`CDAGRUPADA = ${codVen}`]
            }
            //adicionar where dos filtros
            const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (json.length > 0) {
              if (json[0].TIPO_VENDA == 1) { // apenas se for agrupamento de vendas comuns, pois esse campo depois bloqueia algumas ações na tela.
                vendaOriginadaDeAgrupamento = true;
              }
              // if (!bloqueiaAbasInfosEItensVenda) {
              //   $("#txtTipoVenda option[value=2]").prop('disabled', true)
              // }
            }
          }

        } catch (error) {

        }
      }

      async function verificaVendaFechada(venda) {
        try {
          if ((venda) && (venda != 'create') && (venda != 'create#') && (venda != 'vendapendente') && (venda != 'vendapendente#')) {
            const pesquisa = {
              tabela: 'VENDA',
              camposSelect: ['FECHADA'],
              where: [`CODVEN = ${venda} AND EMP_ID = ${getCookie('emp_id')}`]
            }
            //adicionar where dos filtros
            const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            return json[0].FECHADA == 1;
          }
          return false;

        } catch (error) {
          console.error(error)
        }
      }

      async function carregaDadosVenda() {
        try {
          let origem = '';
          let response;

          const utilizaBarraLog = parametrosVenda[46] != '0';
          $.LoadingOverlay("show");
          try {
            let hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
            response = await carregaVendaNaoSalva(hostname);
            if ((typeof(response) === 'object') && (response.status == 200)) {
              origem = 'arquivo';
              msgAlerta('Recuperado venda não salva (possível queda de energia, desligamento da máquina, fechamento do navegador, etc...). Necessário validar os dados carregados.')
            }
          } catch (error) {

          }

          if (response.status != 200) {
            response = await requisicao('GET', '/Sisplan/Vendas/v1/Venda?', `codvenda=${numero_venda}`, null, 600000);
            origem = 'database';
          }

          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }
          const jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          //preenche aba informações...
          const vendaJson = jsonStr;
          vendaJson.fechada = await verificaVendaFechada(jsonStr.codVen);
          if (vendaJson.fechada) {
            let hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
            await deletaVendaNaoSalva(hostname + '.txt');
          }

          if ((vendaJson.fechada == true) || (vendaJson.cancelada == true)) {
            window.location.href = '<?php echo BASE_URI; ?>/loja';
          }
          const scodCli = jsonStr.codCli;
          await PreencheNomeECNPJ(scodCli);
          carregaAntecipacoes(scodCli);
          await carregaCashback(scodCli);
          const sTabela = jsonStr.tabela;
          if (sTabela != "") {
            await PreencheDescTabela(sTabela);
          }
          const prazo = jsonStr.prazo.toString().length == 1 ? '0' + jsonStr.prazo.toString() : jsonStr.prazo;
          $('#rgPrazo').val(prazo).change();

          if (sTabela != "999") {
            $('#txtTabela').trigger('blur');
          }
          
          try {
            const sDeposito = jsonStr.itens[0].deposito;
            await PreencheDescDeposito(sDeposito);
          } catch {
            const depositoParam = parametrosVenda[1];
            $('#txtDeposito').val(depositoParam);
            $('#txtDeposito').attr('data-selecionado', true);
          }
          const sTransportadora = jsonStr.transportadora;
          await PreencheDescTransportadora(sTransportadora);
          const sVendedor = jsonStr.codRep;
          await PreencheDescVendedor(sVendedor);

          const sStatus = jsonStr.status;
          if (sStatus && sStatus !== '') {
            await PreencheDescStatus(sStatus);
          }

          // so ira preencher se o usuario estiver o campo habilitado!
          const sCondicoes = jsonStr.condicao;
          // if (sCondicoes )
          if (sCondicoes != undefined) {
            if (sCondicoes.length != 0) {
              await carregaDescricaoCondicaoEMoeda(sCondicoes);
              await carregaDadosCondicoesPagamento(sCondicoes);
            }
          }

          if (!$('#GuiaInfoTour').hasClass('d-none')) {
            const sGuia = jsonStr.codRep2;
            await PreencheDescGuia(sGuia);
          }
          const iLancamento = jsonStr.lancamento;
          const iTipoVenda = jsonStr.Venda_Tipo ? jsonStr.Venda_Tipo : jsonStr.venda_Tipo;
          $('#txtTipoVenda').val(String(iTipoVenda));
          infoTipoVenda = await BuscaTiposVenda($('#txtTipoVenda').val());
          const vendaEmAlteracao = ((numero_venda != 'create') && (numero_venda != 'create#'));
          const bloqueiaExcluirItem = infoTipoVenda[0].EXCLUSAO_ITEM === 2 && vendaEmAlteracao;
          const pedeSenhaSupervisaoExclusaoItem = infoTipoVenda[0].EXCLUSAO_ITEM === 1 && vendaEmAlteracao;
          const bloqueiaTrocarTipo = [1, 2].includes(infoTipoVenda[0].EXCLUSAO_ITEM && vendaEmAlteracao);
          $('#txtTipoVenda').prop('disabled', bloqueiaTrocarTipo);
          $('#txtLancamento').val(iLancamento);
          $('#textDescricaoVenda').val(jsonStr.observacao);
          $('#dtEntregaDe').val(jsonStr.dataEntregaDe.split('T')[0]);
          $('#dtEntregaAte').val(jsonStr.dataEntregaAte.split('T')[0]);
          $('#txtVolumes').val(jsonStr.volumes ?? 0);
          $('#txtCupomDesconto').val(jsonStr.cupomDesconto);
          $('#txtFrete').val(jsonStr.valor_Frete);
          if (jsonStr.cupomDesconto !== '') {
            $('#btnAplicarCupomDesconto>i').removeClass('fa-check').addClass('fa-trash');
            $('#txtCupomDesconto').prop('disabled', true);
            $('#btnAplicarCupomDesconto').attr('title', 'Remover Cupom');
            await atualizaSaldoAPagar();
            await atualizaTotaisPagto();
            await atualizaTotalVenda();
          }

          $('#rgTransportador').val(jsonStr.fretePor).change();

          // if (jsonStr.fretePor && jsonStr.fretePor == '1') {
          //   $('#radioFreteEmp').prop('checked', true);
          // } else {
          //   $('#radioFreteCli').prop('checked', true);
          // }
          // $('#txtFretePor').val(jsonStr.volumes ?? 0);
          if (parametrosVenda[29] == 1) {
            if (jsonStr.regra) {
              await PreencheDescRegra(jsonStr.regra);
            }
          }
          // preenche aba venda
          await carregaDadosItens(vendaJson.itens, '', origem == 'arquivo');


          if ((utilizaBarraLog) && (vendaJson.listaBarraLog)) {
            vendaJson.listaBarraLog.forEach(async barra => {
              await adicionaBarraBipada(barra);
            });
          }

          if ((utilizaBarraLog) && (vendaJson.listaBarraLogEstorno)) {
            vendaJson.listaBarraLogEstorno.forEach(async barra => {
              listaBarrasRemovidas.push(barra);
              listaBarrasRemovidasTemp.push(barra);
            });
          }


          if (jsonStr.codVen) {
            await verificaSeVeioDeAgrupamento(jsonStr.codVen);
          }

          // atualiza totais
          atualizaTotalVenda();
          atualizaSaldoAPagar();
          atualizaTotaisPagto();
          const fechaVenda = await BuscaTiposVenda($('#txtTipoVenda').val());
          if (($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) && (!UsuarioPodeGravarCondicoes) && (fechaVenda[0].FECHA_VENDA == 'S')) {
            $('#btnFinalizar').html(await traduzSentenca('Finalizar (F8)'));
            $('#btnFinalizar').attr('data-original', 'Finalizar (F8)');

            async function executaBotaoPagamento() {
              await alteraPesquisaMoeda();
              if (!$('#menu_fiscal').hasClass('d-none')) {
                var bUsaECF = parametrosVenda[8];
                setCookie('enviando_comando', 'false');

                if (bUsaECF == '1') {
                  if (($('#txtStatusECF').html() == " Offline ") || ($('#txtEstadoECF').html() == "Desconectado")) {
                    if (await maquinaTemImpressora()) {
                      await habilitaPanelImpressora(true);
                      await buscaStatusImpressora();
                      if (($('#txtStatusECF').html() == " Offline ") || ($('#txtEstadoECF').html() ==
                          "Desconectado")) {
                        conectaECF(ipInterno, ipExterno, basicAuth);
                      }
                      if ($('#txtEstadoECF').html() == 'Requer Z') {
                        msgAlerta(
                          'Impressora com Redução Z pendente, para emitir, utilize o menu fiscal localizado a direita.'
                        );
                      }
                    }
                  }
                }
              }

              if ((($('#txtCliente').val() == '') || ($('#txtDeposito').val() == '') || ($('#txtTabela').val() == '') || ($('#txtVendedor').val() == ''))) {
                msgAlerta('Necessário informar os campos Cliente, Deposito, Vendedor e Tabela de Preço.');
                $('#btnInfo').trigger('click');
              } else if ((!["2", "4"].includes(utilizaGuia)) && (!$('#GuiaInfoTour').hasClass('d-none')) && ($('#txtGuia').val() == '')) {
                msgAlerta('Necessário informar um guia para continuar.');
                $('#btnInfo').trigger('click');
              } else
              if ($('#tabelaItens').DataTable().column(7, {}).data().sum() <= 0) {
                const estaComMensagensBloqueio = ($('#modal-warning-conteudo').val().indexOf('Cliente já possui consignado pendente') > -1) ||
                  ($('#modal-warning-conteudo').val() == 'Cliente possui duplicatas em atraso, necessário efetuar a negociação antes de iniciar nova venda.');
                if (estaComMensagensBloqueio) {
                  $('#btnInfo').trigger('click');
                  return;
                }

                msgAlerta('Venda sem nenhum item, verifique. ');
                $('#btnVenda').trigger('click');
              } else {
                await regraPromocao();
                await RotinaCliquePagamento();
                await BaixaAntecipacaoAutomatica();
              }
            };
            const abriuModalConferencia = await RotinaModalConferencia(executaBotaoPagamento);
          }

          if (parametrosVenda[69] == 1) {
            await buscaDadosClienteNetShopping($("#txtCNPJ").val(), scodCli);
          }
          $.LoadingOverlay("hide");
        } catch (error) {
          console.error(error);
          $.LoadingOverlay("hide");
          msgErro('Não foi possível buscar os dados da venda: ' + error)
        }
      };

      function pesquisaCliente() {
        selectBtnClienteUltimoMovimento = {
          tabela: "ENTIDADE",
          camposSelect: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME CIDADE", "CADCEP.ESTCEP"],
          leftJoin: [{
              tabela: "CADCEP",
              condicao: "CADCEP.CEP = ENTIDADE.CEP"
            },
            {
              tabela: "CIDADE",
              condicao: "CIDADE.CODIGO = CADCEP.CODMUN"
            }
          ],
          where: parametrosVenda[65] == '1' ? ["ENTIDADE.TIPO = '1' AND ENTIDADE.CONS_FINAL = 'Sim'"] : [],
          camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
        }
        if (parametrosVenda[51] == 1) {
          selectTxtCliente.innerJoin = [{
            tabela: 'EMP_VALOR',
            condicao: `EMP_VALOR.TABELA = 'ENTIDADE' AND EMP_VALOR.VALOR = ENTIDADE.CODCLI AND EMP_VALOR.EMP_ID = ${emp_id}`
          }];

          selectBtnCliente.innerJoin = [{
            tabela: 'EMP_VALOR',
            condicao: `EMP_VALOR.TABELA = 'ENTIDADE' AND EMP_VALOR.VALOR = ENTIDADE.CODCLI AND EMP_VALOR.EMP_ID = ${emp_id}`
          }];
        }
      }

      $('#btn_novo_cliente').on('click', function() {
        $('#modal-cliente').modal('show');
        $('#txtCNPJModalCli').focus();
      });

      $('#btn_confirmar_cliente').on('click', async function() {
        if ($('#txt-cliente').val() != '') {
          insereValor('#txtCliente', $('#txt-cliente').val());
          var sCodCli = pegaChave('#txtCliente', sCodCli);
          if (sCodCli != '') {
            var sCNPJ = await RetornaCNPJ(sCodCli);
            $('#txtCNPJ').val(sCNPJ);
          }
          carregaAntecipacoes(sCodCli)
        }
        $('#modal-cliente-select').modal('hide');
      });

      function validarDataValidaVencimentoCheques() {
        const validacao = $(".campoVencimento").toArray().filter(input => input.validity.badInput);

        return validacao.length > 0
      }

      $("#btn_confirmar_cred").on('click', async function() {
        const crediario = $('#modalParcelas-titulo').text() == 'Manutenção Crediário';
        if (($("#modalParcelas").hasClass("show")) && (crediario)) {
          await rotinaGeraLog("TVENDALOJA", 'VENDA', "Alteração nas parcelas da forma de pagamento", "Alteração");
          callBack()
        } else {
          callBack();
        }

        function callBack() {
          var bEmAlteracao = $('#txt_cred_modo').val() == 'alteracao';
          var nr_parcelas = pegaChave('#txtNrParcelas', nr_parcelas);
          var codmoeda = pegaChave("#txtMoeda", codmoeda);
          var descmoeda = pegaDescricao("#txtMoeda", descmoeda);
          var codcondpagto = pegaChave("#txtCondicaoDePagamento", codcondpagto);
          var desccondpagto = pegaDescricao("#txtCondicaoDePagamento", desccondpagto);
          var valor = parseFloat($("#txt_cred_valor_total").val().replace(',', '.'));
          var valor_pago = parseFloat($("#txt_cred_valor_pago").val());
          var saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
          var tipoMoeda = pegaChave('#txtTipoMoeda', tipoMoeda);
          var codCondMoeda = pegaChave('#txtCodCondMoeda', codCondMoeda);
          var perc_desconto = parseFloat($("#txtPercDescontoMoeda").val());
          var valor_desconto = parseFloat($("#txtValorDescontoMoeda").val());
          var bandeira = $('#select_bandeira').val();
          var nsu = $('#txtNSU').val();
          const autorizacao = $("#txtAutorizacao").val();

          if ((codcondpagto == '') && (!bEmAlteracao)) {
            return;
          }

          if (validarDataValidaVencimentoCheques()) {
            msgAlerta("Necessário informar uma data válida nos vencimentos do cheque.");
            return;
          }

          if ((tipoMoeda == '1') || (tipoMoeda == '2')) //se for cheque ou crediário
          {
            var possuiBanco = true;
            var possuiAgencia = true;
            var possuiConta = true;
            var possuiNumero = true;
            for (let i = 0; i < $('.campoBanco').length; i++) {
              possuiBanco = (($($('.campoBanco')[i]).val() != 'undefined') && ($($('.campoBanco')[i]).val() != ''));
              possuiAgencia = (($($('.campoAgencia')[i]).val() != 'undefined') && ($($('.campoAgencia')[i]).val() != ''));
              possuiConta = (($($('.campoConta')[i]).val() != 'undefined') && ($($('.campoConta')[i]).val() != ''));
              possuiNumero = (($($('.campoNumero')[i]).val() != 'undefined') && ($($('.campoNumero')[i]).val() != ''));
            }

            if (possuiBanco == false) {
              msgAlerta('Necessário informar o campo Banco, verifique');
              return;
            }
            if (possuiAgencia == false) {
              msgAlerta('Necessário informar o campo Agência, verifique');
              return;
            }
            if (possuiConta == false) {
              msgAlerta('Necessário informar o campo Conta, verifique');
              return;
            }
            if (possuiNumero == false) {
              msgAlerta('Necessário informar o campo Número, verifique');
              return;
            }
          }
          if ((!bEmAlteracao) && (valor_pago > saldo_a_pagar)) {
            valor = saldo_a_pagar;
          }

          var valorParcelas = 0;
          const bParametroSelecionaAntecipacao = parametrosVenda[49] == 1 | parametrosVenda[49] == 2 ?? false;

          for (let i = 0; i < $('.campoValor').length; i++) {
            valorParcelas = parseFloat(valorParcelas.toFixed(2)) + parseFloat(parseFloat($($('.campoValor')[i]).val()).toFixed(2));
          }
          if (Math.round(parseFloat($("#txt_cred_valor_total").val().replace(',', '.'))) == Math.round(valorParcelas)) {
            var array_antecipacoes = [];
            var baixaAntecipacao = pegaChave('#txtBaixaAntecipacao', baixaAntecipacao);
            var baixaPresente = $('#tabelaPresente tr').length > 0 && $('#tabelaPresente').DataTable().rows().data()[0] != undefined;
            const dataCondicao = $('#tabelaCondicoesDePagamento').DataTable().rows().data();
            if (baixaAntecipacao == 'S') {
              if (bParametroSelecionaAntecipacao) {
                for (let i = 0; i < $('.campoCheckManual').length; i++) {
                  if ($($('.campoCheckManual')[i]).is(':checked')) {
                    let newData = $('#tabelaAntecipacoesSelecionadas').DataTable().row(i).data();
                    const valorUtilizado = dataCondicao.reduce((total, antecipacao) => {
                        total += +antecipacao[9]?.map((total) => {
                          if ((newData.DUPLICATA == total.duplicata)) {
                            return total.valor;
                          } else {
                            return 0
                          };
                        }).reduce((total, valor) => {
                          return total += valor;
                        }, 0);
                        return total;
                      },
                      0
                    );
                    if (($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0)) {
                      const valorPago = (valorUtilizado == 0) ? 0 : ArredondarValor(newData.VALOR_PAGO - valorUtilizado, 2);
                      if ((valorPago < 0) && (!valorPago == 0) && (valorUtilizado > 0)) {
                        array_antecipacoes.push({
                          'duplicata': newData.DUPLICATA,
                          'valor': valorPago < 0 ? newData.VALOR_PAGO : valorPago
                        });
                      } else {
                        if ((newData.VALOR_PAGO > 0) && (!valorUtilizado > 0)) {
                          array_antecipacoes.push({
                            'duplicata': newData.DUPLICATA,
                            'valor': ArredondarValor(newData.VALOR_PAGO, 2)
                          });
                        } else {
                          if (valorPago != 0) {
                            array_antecipacoes.push({
                              'duplicata': newData.DUPLICATA,
                              'valor': valorPago < 0 ? newData.VALOR_PAGO : valorPago
                            });
                          }
                        }
                      }
                    } else {
                      if (newData.VALOR_PAGO > 0) {
                        array_antecipacoes.push({
                          'duplicata': newData.DUPLICATA,
                          'valor': ArredondarValor(newData.VALOR_PAGO, 2)
                        });
                      }
                    }
                  }
                }
              } else {
                for (let i = 0; i < $('.campoCheck').length; i++) {
                  var indice = $('.campoCheck')[i].closest('tr').rowIndex - 1;
                  let newData = $('#tabelaAntecipacoes').DataTable().row(indice).data();
                  const valorUtilizado = dataCondicao.reduce((total, antecipacao) => {
                      total += +antecipacao[9]?.map((total) => {
                        if ((newData.DUPLICATA == total.duplicata)) {
                          return total.valor;
                        } else {
                          return 0
                        };
                      }).reduce((total, valor) => {
                        return total += valor;
                      }, 0);
                      return total;
                    },
                    0
                  );
                  if (($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0)) {
                    const valorPago = (valorUtilizado == 0) ? 0 : ArredondarValor(newData.VALOR_PAGO - valorUtilizado, 2);
                    if ((valorPago < 0) && (!valorPago == 0) && (valorUtilizado > 0)) {
                      array_antecipacoes.push({
                        'duplicata': newData.DUPLICATA,
                        'valor': valorPago < 0 ? newData.VALOR_PAGO : valorPago
                      });
                    } else {
                      if ((newData.VALOR_PAGO > 0) && (!valorUtilizado > 0)) {
                        array_antecipacoes.push({
                          'duplicata': newData.DUPLICATA,
                          'valor': ArredondarValor(newData.VALOR_PAGO, 2)
                        });
                      } else {
                        if (valorPago != 0) {
                          array_antecipacoes.push({
                            'duplicata': newData.DUPLICATA,
                            'valor': valorPago < 0 ? newData.VALOR_PAGO : valorPago
                          });
                        }
                      }
                    }
                  } else {
                    if (newData.VALOR_PAGO > 0) {
                      array_antecipacoes.push({
                        'duplicata': newData.DUPLICATA,
                        'valor': ArredondarValor(newData.VALOR_PAGO, 2)
                      });
                    }
                  }
                }
              }
            }
            if (baixaPresente) {
              for (let i = 0; i < $('#tabelaPresente').DataTable().rows().count(); i++) {
                const dadosPresente = $('#tabelaPresente').DataTable().row(i).data();
                array_cartao_presente.push({
                  'duplicata': dadosPresente.NUMERO,
                  'valor': parseFloat(dadosPresente.VALOR_A_UTILIZAR)
                });
              }
              $('#tabelaPresente').DataTable().clear().draw(false);
            }

            if (bEmAlteracao) {
              let ordemCondicaoPagto = $('#tabelaCondicoesDePagamento tr.selected')[0].rowIndex - 1;
              let dadosAtuais = $('#tabelaCondicoesDePagamento').DataTable().row(ordemCondicaoPagto).data();
              let ordemAtual = $('#tabelaCondicoesDePagamento').DataTable().row(ordemCondicaoPagto).data()[0];
              //apaga da tabela de parcelas e cria novamente...  
              tabelaParcelasGeradas
                .rows(function(idx, data, node) {
                  return data[0] === ordemAtual;
                })
                .remove()
                .draw(false);

              CriaRegistrosTabelaParcelas();
            } else {
              let indice = tabelaCondicoes.rows().count();
              while ($('#tabelaCondicoesDePagamento').DataTable().column(0).data().indexOf(indice) >= 0) {
                indice = indice + 1;
              }
              tabelaCondicoes.row.add([
                indice,
                codmoeda + ' - ' + descmoeda,
                codcondpagto + ' - ' + desccondpagto,
                valor,
                valor_pago,
                valor / nr_parcelas,
                codmoeda,
                codcondpagto,
                nr_parcelas,
                array_antecipacoes,
                perc_desconto,
                valor_desconto,
                bandeira,
                nsu,
                array_cartao_presente,
                tipoMoeda,
                autorizacao,
                retornaBotaoOpcoesCondicao(tipoMoeda)
              ]).draw(false);

              CriaRegistrosTabelaParcelas();

              $("#txtMoeda").val('');
              $('#txtBaixaAntecipacao').val('');
              $('#txtTipoMoeda').val('');
              $('#txtCodCondMoeda').val('');
              $("#txtCondicaoDePagamento").val('');
              $("#txtValorParcela").val('');
              $("#txtNrParcelas").val('1');
              $("#txtMaxNrParcelasMoeda").val('');
              $("#btn-moeda").focus();
              $("#txtPercDescontoMoeda").val(0);
              $("#txtValorDescontoMoeda").val(0);
              $("#txtValorLiquidoMoeda").val('0');
            }

            atualizaSaldoAPagar();
            atualizaTotaisPagto();
            $('#modalParcelas').modal("hide");
          } else {
            msgAlerta('Valor das parcelas diferente do total, verifique');
            $('#modalParcelas').modal("show");
          }
          limpaCamposPagamento();
          $('#tabelaCondicoesDePagamento tr').removeClass('selected');
        }
      });

      $('#btn-informacoes-adicionais').on('click', function() {
        $('#modal-informacoes-adicionais').modal('show');
      });

      $('#btn_confirmar_informacoes_adicionais').on('click', function() {
        $('#modal-informacoes-adicionais').modal('hide');
      });

      async function limpaCamposPagamento() {
        $("#txtMoeda").val('');
        $("#txtCondicaoDePagamento").val('');
        $('#txtBaixaAntecipacao').val('');
        $('#txtTipoMoeda').val('');
        $('#txtCodCondMoeda').val('');
        $("#txtValorParcela").val('');
        $("#txtNrParcelas").val('1');
        $("#txtMaxNrParcelasMoeda").val('');
        $("#txtPercDescontoMoeda").val(0);
        $("#txtValorDescontoMoeda").val(0);
        $("#txtPercAcrescMoeda").val(0);
        $("#txtValorAcrescMoeda").val(0);
        $("#txtValorLiquidoMoeda").val('0');
        $('#txtNSU').val('');
        $("#txtAutorizacao").val("");
        $('#select_bandeira').val('').trigger('change');
        if (!$('.nsu').hasClass('d-none')) {
          $('.nsu').addClass('d-none');
          $('.autorizacao').addClass('d-none');
          $('.bandeira').addClass('d-none');
          $('#select_bandeira').removeClass('focus');
          $('#txtNSU').removeClass('focus');
        }
        // ajustaCamposIntegracaoTeiaCard(false);
      }

      $('#btn_dividir_valor').on('click', function() {
        var qtdeParcelas = $('.campoValor').length;
        var valorTotal = parseFloat(parseFloat($('#txt_cred_valor_total').val().replace(',', '.')).toFixed(2));
        var valorParcela = parseFloat((valorTotal / qtdeParcelas).toFixed(2));
        var guardaValor = valorParcela;

        if (valorTotal > (valorParcela * qtdeParcelas) || valorTotal < (valorParcela * qtdeParcelas)) {
          var diferenca = parseFloat(parseFloat((valorTotal - (valorParcela * qtdeParcelas)).toFixed(2)));
        }

        for (let i = 0; i < qtdeParcelas; i++) {
          $($('.campoValor')[i]).removeClass('alterado');
          if ((diferenca > 0) && (i == 0)) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
            diferenca = 0
          } else {
            valorParcela = guardaValor;
          }
          if ((diferenca < 0) && (i == (qtdeParcelas - 1))) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
          }
          $($('.campoValor')[i]).val(valorParcela);
        }
      });

      async function calculaDiasVencimentoCheque(){
        if ($('#cbManterDiaPrimeiroVencto').prop('checked')) {
          $('#txtIntervaloDias').prop('disabled', true);
          const dateText = $('#txtPrimeiroVencimento').val();
          const dateParts = dateText.split('-');
          const ano = parseInt(dateParts[0]);
          const mes = parseInt(dateParts[1]) - 1;
          let dia = parseInt(dateParts[2]);
          const dataPrimeiroVencto = new Date(ano, mes, dia);
          const diaPrimeiroVencto = dia;
          const arrayDataPreenchidas = []

          if (diaPrimeiroVencto != '') {
            let diaVencimento;
            let dataMaxima;
            let maiorDia;
            const arrayVencto = await RetornaVencimentosParcelas(pegaChave('#txtCondicaoDePagamento') == '' ? condicaoPagto : pegaChave('#txtCondicaoDePagamento'), ano, mes, dia);
            $('.campoVencimento').map(async (index) => {
              diaVencimento = dia;
              if (index == 0) {
                $($('.campoVencimento')[index]).val(arrayVencto[index]);
                arrayDataPreenchidas.push(arrayVencto[index])
              } else {
                let dataComDiaPrimeiroVencto = arrayVencto[index].split('-');
                dataMaxima = new Date(dataComDiaPrimeiroVencto[0], dataComDiaPrimeiroVencto[1], 0);
                maiorDia = dataMaxima.getDate();
                if (diaVencimento == '0') {
                  diaVencimento = '1';
                };
                if (diaVencimento > maiorDia) {
                  diaVencimento = maiorDia;
                };

                let anoAtual = parseInt(dataComDiaPrimeiroVencto[0]);
                let mesAtual = parseInt(dataComDiaPrimeiroVencto[1]);

                while (arrayDataPreenchidas.some(d => {
                  const [a, m] = d.split('-').map(Number);
                  return a === anoAtual && m === mesAtual;
                })) {
                  mesAtual++;
                  if (mesAtual > 12) {
                    mesAtual = 1;
                    anoAtual++;
                  }
                  
                  dataMaxima = new Date(anoAtual, mesAtual, 0);
                  maiorDia = dataMaxima.getDate();
                  if (diaVencimento > maiorDia) {
                    diaVencimento = maiorDia;
                  }
                }

                const diaFormatado = diaVencimento > 9 ? String(diaVencimento) : '0' + String(diaVencimento);
                const mesFormatado = mesAtual > 9 ? String(mesAtual) : '0' + String(mesAtual);
                const novaData = `${anoAtual}-${mesFormatado}-${diaFormatado}`;

                $($('.campoVencimento')[index]).val(novaData);
                arrayDataPreenchidas.push(novaData)
              }
            });
          };
        } else {
          $('#txtIntervaloDias').prop('disabled', false);
          const dateText = $('#txtPrimeiroVencimento').val();
          const dateParts = dateText.split('-');
          const ano = parseInt(dateParts[0]);
          const mes = parseInt(dateParts[1]) - 1;
          const dia = parseInt(dateParts[2]);
          const arrayVencimentos = await RetornaVencimentosParcelas(pegaChave('#txtCondicaoDePagamento') == '' ? condicaoPagto : pegaChave('#txtCondicaoDePagamento'), ano, mes, dia, parseInt($('#txtIntervaloDias').val() == '' ? '0' : $('#txtIntervaloDias').val()));

          const camposVencimento = $('.campoVencimento');

          for (let i = 0; i < arrayVencimentos.length; i++) {
            $($('.campoVencimento')[i]).val(arrayVencimentos[i]);
          };
        }
      }

      $('#txtPrimeiroVencimento').on('blur', async function() {
        await calculaDiasVencimentoCheque()
      })

      $('#cbManterDiaPrimeiroVencto').on('change', async function() {
        await calculaDiasVencimentoCheque()
      });

      $('#txtIntervaloDias').on('blur', async function() {
        const dateText = $('#txtPrimeiroVencimento').val();
        const dateParts = dateText.split('-');
        const ano = parseInt(dateParts[0]);
        const mes = parseInt(dateParts[1]) - 1;
        const dia = parseInt(dateParts[2]);
        const arrayVencimentos = await RetornaVencimentosParcelas(pegaChave('#txtCondicaoDePagamento') == '' ? condicaoPagto : pegaChave('#txtCondicaoDePagamento'), ano, mes, dia, parseInt($('#txtIntervaloDias').val() == '' ? '0' : $('#txtIntervaloDias').val()));

        const camposVencimento = $('.campoVencimento');

        for (let i = 0; i < arrayVencimentos.length; i++) {
          $($('.campoVencimento')[i]).val(arrayVencimentos[i]);
        };
      });

      $('#txtIntervaloDiasPrimeiroVencto').on('blur', async function() {
        const valueDate = $('#txtIntervaloDiasPrimeiroVencto').val();

        if (valueDate != '') {
          let hoje = new Date();
          hoje.setDate(hoje.getDate() + parseInt(valueDate));
          const diaCalculado = String(hoje.getDate()).padStart(2, '0');
          const mesCalculado = String(hoje.getMonth() + 1).padStart(2, '0');
          const anoCalculado = hoje.getFullYear();
          const dataMontada = `${anoCalculado}-${mesCalculado}-${diaCalculado}`

          $('#txtPrimeiroVencimento').val(dataMontada);
          $('#txtPrimeiroVencimento').trigger('blur');
        }
      });

      $('#modalParcelas').on('hidden.bs.modal', function() {
        // $('#txtDiaVencimento').val('');
        $('#tabelaCondicoesDePagamento tr').removeClass('selected');
      });

      $('#modalParcelas').on('shown.bs.modal', function() {
        // $('#txtDiaVencimento').val('');
        setarDataAtual('txtPrimeiroVencimento');
        const valorTotal = $('#txt_cred_valor_total').val();
        $('#txt_cred_valor_total').val(`${parseFloat(valorTotal).toFixed(2).replace('.', ',')}`);
      });

      $('#tabelaParcelas tbody').on('change', 'tr', function(e) {
        var rowArray = tabelaParcelas.row(this).data();

        if (rowArray) {
          rowArray['VALOR'] = rowArray['VALOR'].toFixed(2);
        }
      });

      //validação do passo 1 nos campos
      $.validator.setDefaults({
        submitHandler: function() {

        }
      });

      $('#msform').validate({
        debug: false,
        rules: {
          txtCliente: {
            required: true
          },
          txtVendedor: {
            required: true
          },
          txtDeposito: {
            required: true
          },
          txtTabela: {
            required: true
          }
        },
        messages: {
          txtCliente: {
            required: "Informe um cliente válido."
          },
          txtVendedor: {
            required: "Informe um vendedor válido."
          },
          txtDeposito: {
            required: "Informe um depósito válido."
          },
          txtTabela: {
            required: "Informe uma tabela de preço válida."
          }
        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
          error.addClass('invalid-feedback');
          element.closest('.input-group').append(error);
        },
        highlight: function(element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function(element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });

      $('#btnInfo').on('click', function() {
        // if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
        //     msgAlerta('Venda já possui pagamento informado, impossível continuar.');
        //     return;
        // }
        if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
          $('#txtTabela').prop('disabled', true);
          $('#btn-tabela').prop('disabled', true);
          $('#btn-limpa-tabela').prop('disabled', true);
          $('#txtTabela').prop('title', 'Pagamento já informado, impossível alterar tabela de preço.');
          $('#btn-tabela').prop('title', 'Pagamento já informado, impossível alterar tabela de preço.');
          $('#btn-limpa-tabela').prop('title', 'Pagamento já informado, impossível alterar tabela de preço.');
        } else {
          desbloqueiaTabela();
          $('#txtTabela').prop('title', 'Tabela de preço');
          $('#btn-tabela').prop('title', 'Tabela de preço');
          $('#btn-limpa-tabela').prop('title', 'Tabela de preço');
        }
        if ($('#tabelaItens').DataTable().rows().count() > 0) {
          $('#txtDeposito').prop('disabled', true);
          $('#btn-deposito').prop('disabled', true);
          $('#btn-limpa-deposito').prop('disabled', true);
        } else if (parametrosVenda[77] != '1') {
          $('#txtDeposito').prop('disabled', false);
          $('#btn-deposito').prop('disabled', false);
          $('#btn-limpa-deposito').prop('disabled', false);
        }
        RotinaCliqueInfo();
      });

      $('#btnVenda').on('click', async function() {
        if ($(this).attr('disabled')) {
          return;

        }
        const estaComMensagensBloqueio = ($('#modal-warning-conteudo').val().indexOf('Cliente já possui consignado pendente') > -1) ||
          ($('#modal-warning-conteudo').val() == 'Cliente possui duplicatas em atraso, necessário efetuar a negociação antes de iniciar nova venda.') ||
          ($('#modal-warning-conteudo').val().indexOf('Necessário finalizar o atendimento dos consignados') > -1);
        if (estaComMensagensBloqueio) {
          $('#btnInfo').trigger('click');
          return;
        }

        if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() > 0) {
          msgAlerta('Venda já possui pagamento informado, impossível continuar.');
          return;
        }

        // if ($('#txtCupomDesconto').val() !== '') {
        if ($('#txtCupomDesconto').prop('disabled')) {
          msgAlerta("Venda com cupom de Desconto aplicado, impossível alterar os itens.");
          return;
        }

        if (($('#fieldset_info').css('display') == 'none') && (($('#txtCliente').val() == '') || ($(
            '#txtDeposito').val() == '') || ($('#txtTabela').val() == '') || ($('#txtVendedor').val() == ''))) {
          msgAlerta('Necessário informar os campos Cliente, Deposito, Vendedor e Tabela de Preço.');
          $('#btnInfo').trigger('click');
          return;
        }
        if ((!["2", "4"].includes(utilizaGuia)) && ($('#fieldset_info').css('display') == 'none') && (!$('#GuiaInfoTour').hasClass('d-none')) && ($('#txtGuia').val() == '')) {
          msgAlerta('Necessário informar um guia para continuar.');
          $('#btnInfo').trigger('click');
          return;
        }

        const camposObrigatorios = await retornaCamposObrigatorios(nomeTela);
        const camposAbaInformacoes = $("#fieldset_info").find("input").toArray();
        if (camposObrigatorios != undefined) {
          camposObrigatorios.forEach(campo => {
            if (camposAbaInformacoes.findIndex(campoInformacoes => campoInformacoes == $(`#${campo}`)[0]) >= 0) {
              if (!$("#msform").validate().element(`#${campo}`)) {
                throw new Error(`O campo ${campo} é obrigatório (regra da empresa)`);
              }
            }
          })
        }
        if (($("#msform").validate().element("#txtCliente")) &&
          ($("#msform").validate().element("#txtTabela")) &&
          ($("#msform").validate().element("#txtVendedor")) &&
          ($("#msform").validate().element("#txtDeposito"))) {
          if ((!["2", "4"].includes(utilizaGuia)) && !$('#GuiaInfoTour').hasClass('d-none')) {
            if ($("#msform").validate().element("#txtGuia")) {
              RotinaCliqueVenda();
            }
          } else {
            RotinaCliqueVenda();
          }

        }
      });

      async function deletaVendaNaoSalva(sNomeMaquina) {
        var response;
        try {
          response = await fetch(`<?php echo BASE_URI; ?>/deletar_arquivo.php?nomedoarquivo=${sNomeMaquina}`, {
            method: 'GET',
            body: null,
          }, );
        } catch (error) {
          return;
        }
        return response;
      }

      $("#txtCpfNFCE").on('keyup', function() {
        let cnpj = formata_cpf_cnpj($("#txtCpfNFCE").val());
        if (cnpj != false) {
          $("#txtCpfNFCE").val(cnpj);
        }
      });

      $('#btnNFCE').on('click', async function() {
        const numlinhas = $('#tabelaCondicoesDePagamento').DataTable().rows()[0].length;
        let algumaMoedaUsaTroco = false;

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFCE')) return;


        if ($('#txtCliente').val() == '') {
          msgAlerta('Cliente não informado, verifique.');
          return;
        }

        if ($('#txtVendedor').val() == '') {
          msgAlerta('Vendedor não informado, verifique.');
          return;
        }

        if ((!["2", "4"].includes(utilizaGuia)) && (!$('#GuiaInfoTour').hasClass('d-none')) && ($('#txtGuia').val() == '')) {
          msgAlerta('Necessário informar um guia para continuar.');
          return;
        }

        if (await TemSaldoAPagar()) {
          return;
        }

        if (await validaValorMaximo()) {
          return;
        }

        for (let i = 0; i < numlinhas; i++) {
          const dado = $('#tabelaCondicoesDePagamento').DataTable().row(i).data();
          const iMoeda = dado[6];
          const possuiTroco = await moedaPossuiTroco(iMoeda);

          if (algumaMoedaUsaTroco == true) { // se não possuir troco
            break;
          } else {
            algumaMoedaUsaTroco = possuiTroco;
          }
        }

        const nenhumItemDeVenda = $('#tabelaItens').DataTable().data().toArray().filter(item => item[19] != 'E').length == 0;
        if (nenhumItemDeVenda) {
          msgErro('Nenhum item de Venda incluído, impossível continuar.');
          return;
        }


        if ((algumaMoedaUsaTroco == true) && (!UsuarioPodeGravarCondicoes)) {
          $('#btnConfirmarTroco').addClass('d-none');
          $('#btnConfirmarTrocoNfce').removeClass('d-none');
          await verificaEAbreTroco();
        } else {
          await RotinaNFCE();
        }
      });

      $('#btnConfirmarTrocoNfce').on('click', async function() {
        await RotinaNFCE();
        $('#btnConfirmarTroco').removeClass('d-none');
        $('#btnConfirmarTrocoNfce').addClass('d-none');
      });

      // $('#btnNFE').on('click', async function() {
      //   await RotinaNFE();
      // });

      $('#btnNFE').on('click', async function() {

        if (!await verificaEmpresaKubernetesExisteArquivoIni('NFE')) return;

        const numlinhas = $('#tabelaCondicoesDePagamento').DataTable().rows()[0].length;
        let algumaMoedaUsaTroco = false;

        if ($('#txtCliente').val() == '') {
          msgAlerta('Cliente não informado, verifique.');
          return;
        }

        if ($('#txtVendedor').val() == '') {
          msgAlerta('Cliente não informado, verifique.');
          return;
        }

        if ((!["2", "4"].includes(utilizaGuia)) && (!$('#GuiaInfoTour').hasClass('d-none')) && ($('#txtGuia').val() == '')) {
          msgAlerta('Necessário informar um guia para continuar.');
          return;
        }

        if (await TemSaldoAPagar()) {
          return;
        }

        for (let i = 0; i < numlinhas; i++) {
          const dado = $('#tabelaCondicoesDePagamento').DataTable().row(i).data();
          const iMoeda = dado[6];
          const possuiTroco = await moedaPossuiTroco(iMoeda);

          if (algumaMoedaUsaTroco == true) { // se não possuir troco
            break;
          } else {
            algumaMoedaUsaTroco = possuiTroco;
          }
        }
        if ((algumaMoedaUsaTroco == true) && (!UsuarioPodeGravarCondicoes)) {
          $('#btnConfirmarTroco').addClass('d-none');
          $('#btnConfirmarTrocoNFCe').addClass('d-none');
          $('#btnConfirmarTrocoNfe').removeClass('d-none');
          await verificaEAbreTroco();
        } else {
          await RotinaNFE();
        }
      });

      $('#btnConfirmarTrocoNfe').on('click', async function() {
        await RotinaNFE();
        $('#btnConfirmarTroco').removeClass('d-none');
        $('#btnConfirmarTrocoNFCe').addClass('d-none');
        $('#btnConfirmarTrocoNfe').addClass('d-none');
      });

      $('#btnCFe').on('click', async function() {
        await RotinaCFE();
      });

      $('#txtCpfCFe').on('change', function() {
        let validaCNPJ = formata_cpf_cnpj($('#txtCpfCFe').val());
        if (validaCNPJ != false) {
          $("#txtCpfCFe").val(validaCNPJ)
        }

        if (!valida_cpf_cnpj($('#txtCpfCFe').val())) {
          msgAlerta('CPF/CNPJ inválido, verifique.');
          $('#txtCpfCFe').val('');
          $('#txtCpfCFe').focus();
        }
      });

      $('#btn-informar-cliente').on('click', async function() {
        if ($('.campoCheck:checked').length == 0) {
          insereValor('#txt-cliente', $('#txtCliente').val());
          $('#modal-cliente-select').modal('show');
        } else {
          msgErro(
            'Venda atual possui antecipações utilizadas como pagamento, necessário estornar os pagamentos para conseguir trocar o cliente.'
          );
        }
      });

      $('#btn_confirmar_cfe').off();
      $('#btn_confirmar_cfe').on('click', async function() {
        try {
          $('#btn_confirmar_cfe').prop('disabled', true);
          var bErro = false;
          var sErro = [];
          const bAutomatico = parametrosVenda[18];

          if ($('#txtCpfCFe').val() == '') {
            if ((bAutomatico == 3) || (bAutomatico == 4) || (bAutomatico == 6)) {
              bErro = true;
              sErro.push('Necessário informar um CPF/CNPJ.');
            } else {
              msgAlerta('Necessário informar um CPF/CNPJ.');
              return;
            }
          }

          if ($('#txtNaturezaCFe').val() == '' && $('#txtOperacaoCFe').val() == '') {
            if ((bAutomatico == 3) || (bAutomatico == 4) || (bAutomatico == 6)) {
              bErro = true;
              sErro.push('Necessário informar uma natureza ou operação fiscal.');
            } else {
              msgAlerta('Necessário informar uma natureza ou operação fiscal.');
              return;
            }
          }

          if (!await RotinaFinalizarVenda(false, false, false, false, true, true)) {
            return;
          }

          async function retornaObjetoCfe(sId) {
            try {
              var objeto = await buscaCFEVenda(sId);
              return objeto[0];
            } catch (error) {
              msgErro('Erro ao retornar objeto ');
            }
          }

          $.LoadingOverlay("show");
          //finaliza venda
          if (!await testeConexao()) {
            msgAlerta('Não está conectado a Api Local!');
            return;
          }
          var _natureza = pegaChave('#txtNaturezaCFe');
          var _cpf = $('#txtCpfCFe').val();
          var _obs = $('#txtInfoAdicionaisCFe').val();
          var _caixa = $('#txt_caixa_logado').text();
          var _codven = $('#txtCodVen').val();
          var _codcli = pegaChave('#txtClienteCFE');
          var _url = '/Sisplan/cfe/v1/converterVenda?';
          const operacao = pegaChave('#txtOperacaoCFe');
          var _params =
            `CNPJ=${_cpf}&NATUREZA=${_natureza}&MENSAGEM=${_obs}&COD_VEN=${_codven}&CAIXA=${_caixa}&CODCLI=${_codcli}&OPERACAO=${operacao}`;
          var response = await requisicao('POST', _url, _params, '', 30000);

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }
          //pega o objeto para enviar para o sat
          var objeto = await retornaObjetoCfe(jsonStr);

          // transmite pro sat e gera chave
          let bSucesso = await TransmiteCfe(objeto);

          if (bSucesso) {
            setTimeout(async () => {
              $.LoadingOverlay("show");
              await RotinaFinalizarVenda();
              if (bAutomatico != 5 && bAutomatico != 6) {
                parent.abrirEmNovaAbaIFrame('Impressão CF-e', `<?php echo BASE_URI; ?>/cfe`)
              }
              window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
            }, 10000);
          } else {
            toastr.error(
              `Erro ao gerar CFe, gerar manualmente na tela de Impressão CF-e`,
              'Erro', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                async onHidden() {
                  await RotinaFinalizarVenda();
                  if (bAutomatico != 5 && bAutomatico != 6) {
                    parent.abrirEmNovaAbaIFrame('Impressão CF-e', `<?php echo BASE_URI; ?>/cfe`)
                  }
                  window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          }
        } catch (error) {
          console.error(error);
        } finally {
          $('#btn_confirmar_cfe').prop('disabled', false);
          $.LoadingOverlay("hide");
        }
      });

      async function retornoDadosTEF(codven) {
        const url = '/sisplan/nfce/v1/retornadadostef?';
        const params = `CODVEN=${codven}`;
        const response = await requisicao('GET', url, params, 60000);

        if (!response) {
          return;
        }

        const jsonRetorno = await response.json();
        if (response.status != 200) {
          msgErro(jsonRetorno.mensagem);
          return false;
        }

        return jsonRetorno;
      }

      function montaJsonPix(json, valor) {
        const documento = $('#txtCNPJ').val().replaceAll('.', '').replace('-', '').replace('/', '');
        return {
          calendario: {
            expiracao: 290
          },
          devedor: {
            [documento.length === 14 ? 'cnpj' : 'cpf']: documento,
            nome: json.nome
          },
          valor: {
            original: parseFloat(valor).toFixed(2)
          },
          chave: "",
          solicitacaoPagador: "Venda " + json.codVenda
        }

      }

      function utilizaPix() {
        const dadosPix = $('#tabelaCondicoesDePagamento').DataTable().data().toArray().filter(condicao => condicao[15] == '5');
        return dadosPix.length > 0;
      }

      const aguardaPagamentoPix = async (txid, moeda) => {
        const url = '/sisplan/pix/v1/consultar?';
        let status = 'ATIVA';
        let tentativasComErro = 0;
        while ((tempoSegundosPix > 0) && (status === 'ATIVA') && (tentativasComErro < 6)) {
          try {
            const response = await requisicao('GET', url, `TXID=${txid}&MOEDA=${moeda}`, '', 10000);
            if (response.status == '200') {
              const jsonRetorno = await response.json();
              const parsedJson = JSON.parse(jsonRetorno.mensagem);
              status = parsedJson.status;
            }
            await aguardarXSegundos(10000);
          } catch (error) {
            tentativasComErro = tentativasComErro + 1;
            console.error(error);
          }
        }
        return status;
        // return new Promise(function(resolve) {
        //   setTimeout((resolve), tempo * 60 * 1000);
        // });
      }

      function aguardarXSegundos(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
      }

      const atualizaContador = () => {
        return setInterval(() => {
          tempoSegundosPix = tempoSegundosPix - 1;
          $('#contadorPix').html(tempoSegundosPix > 0 ? tempoSegundosPix : 0);
        }, 1000)
      }

      async function rotinaPagamentoPix(json) {
        let retorno = '';
        try {
          $.LoadingOverlay('hide');
          const dadosPix = $('#tabelaCondicoesDePagamento').DataTable().data().toArray().filter(condicao => condicao[15] == '5');
          const codigoMoeda = dadosPix[0][6];
          const valor = dadosPix[0][4];

          const url = '/sisplan/pix/v1/criar?';
          const pixObject = montaJsonPix(json, valor);
          const response = await requisicao('POST', url, `JSON=${encodeURIComponent(JSON.stringify(pixObject))}&MOEDA=${codigoMoeda}`, '', 300000);

          if (!response) {
            msgErro('Erro ao tentar realizar pagamento via pix.');
            return false;
          }
          const jsonRetorno = await response.json();
          if (response.status != 200) {
            msgErro('Erro ao tentar realizar pagamento via pix. ' + jsonRetorno.mensagem);
            return false;
          } else {
            tempoSegundosPix = 300;
            const parsedJson = JSON.parse(jsonRetorno.mensagem);
            retorno = parsedJson;
            const txid = parsedJson.cob.txid;
            if (!parsedJson.base64) {
              var qrcodjs = new QRious({
                value: parsedJson.cob.brcode
              });
              parsedJson.base64 = qrcodjs.toDataURL().replace("data:image/png;base64,", "");
            }

            const pixBase64 = parsedJson.base64;
            $('#txtPixCopiaCola').val(parsedJson.cob.brcode);
            const codCli = pegaChave('#txtCliente');
            const numero = await getWhatsapp(codCli);
            $('#txtNumeroCelular').val(numero);
            $('#modalPix').modal({
              backdrop: 'static',
              keyboard: false
            })
            // $('#modalPix').modal('show');

            const idTimer = atualizaContador();
            try {
              $('#modalPixBody').html(`<img style="width: 200px" src="data:image/png;base64,${pixBase64}" alt="pix code" />`);
              $('#modalPixBody').append('<br/><h4>Aguardando pagamento...</h4>');
              $('#modalPixBody').append(`<br/><h3 id="contadorPix">${tempoSegundosPix}</h3>`);
              $('#btn-cancelar-pix').off();
              $('#btn-cancelar-pix').on('click', function() {
                clearInterval(idTimer);
                tempoSegundosPix = 0;
                $.LoadingOverlay('hide');
              });

              $('#btn-imprimir-pix').off();
              $('#btn-imprimir-pix').on('click', async function() {
                try {
                  $.LoadingOverlay('show');
                  try {
                    // alterado a rota
                    const url = `/sisplan/impressao/v1/imprimirrelpix?`;
                    const bImprimeAutomatico = await verificaImprimirAutomatico('RelPix');
                    const objeto = {
                      VALOR: valor,
                      QRCODE: parsedJson.cob.brcode
                    }
                    const arquivo = await GeraRelatorio(`${url}`, "POST", 100000, false, 'RelPix', `JSON=[${JSON.stringify(objeto)}]`);
                    if (arquivo != undefined) {
                      if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                      }
                      await limparRelatorios();
                    }

                  } catch (error) {
                    console.error(error);
                  }
                } finally {
                  $.LoadingOverlay('hide');
                }
              });

              const retornoPix = await aguardaPagamentoPix(txid, codigoMoeda);
              if (retornoPix === 'CONCLUIDA') {
                await gravaIdPix(txid, json.codVenda, codigoMoeda);
              }
              return retornoPix === 'CONCLUIDA'
            } finally {
              $('#modalPix').modal('hide');
              $.LoadingOverlay('hide');
              clearInterval(idTimer);
              tempoSegundosPix = 0;
            }
          }
        } catch (error) {
          msgErro('Erro ao tentar realizar pagamento via pix. ' + retorno.message);
          console.error(error);
          return false;
        }
      }

      async function chamaTefNFCE(json, jsonParametros) {
        try {
          let bUsaTef;
          let objetoParametro = jsonParametros;
          const codVen = $("#txtCodVen").val();
          for (let i = 0; i < objetoParametro.formaPagamento.length; i++) {
            if (objetoParametro.formaPagamento[i].usaTEF) {
              bUsaTef = true;
            }
          }
          if (bUsaTef) {
            await rotinaGeraLog("TVENDALOJA", codVen, "Iniciou Rotina TEF NFCe", "Inclusão");
            const url = '/tef/vendamanualtef?';
            const response = await requisicao_ecf('POST', url, '', json, 300000);

            if (!response) {
              msgErro('Erro ao comunicar com a API Local, verifique.');
              await rotinaGeraLog("TVENDALOJA", codVen, "Erro ao comunicar com a API Local - TEF NFCe", "Inclusão");
              return false;
            }

            if (response.status != 200) {
              const mensagem = await response.text();
              if (codVen != "") {
                await rotinaGeraLog("TVENDALOJA", codVen, "Erro ao comunicar com a API Local - TEF NFCe", "Inclusão");
                msgAlerta(`${mensagem}\nOperação foi interrompida no gerenciador da TEF, deseja cancelar a venda?`,
                  async () => {
                      await cancelaVendaPelaOperadoraTEF();
                    },
                    undefined,
                    undefined,
                    undefined,
                    true);
              } else {
                msgErro(mensagem);
              }
              return false;
            }
            const jsonRetorno = await response.json();
            await AtualizarDadosTef(jsonRetorno, "VENDA");
            return true;
          }
          return true;
        } catch (error) {
          console.error(error);
          return false;
        }
      }

      async function retornaInformacaoEmpresa() {
        try {
          let url = `/sisplan/funcoes/v1/pesquisa?`;
          let response = await requisicao('GET', url, `JSON={ 
            "tabela":"empresa", 
            "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert", "emp_crt", "emp_cnpj"], 
            "where": ["emp_id = ${getCookie('emp_id')}"] 
          }`, null);
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }
          return jsonStr.RESULT[0][0];
        } catch (error) {
          console.error(error);
          msgErro('Erro ao retornar dados da empresa, Erro: ');
        }
      }

      $("#btnWppPix").on("click", async function() {
        $.LoadingOverlay("show");
        try {
          const codCli = pegaChave('#txtCliente');
          const nomeCliente = pegaDescricao('#txtCliente');
          const celular = $('#txtNumeroCelular').val();
          const pixCopiaCola = $('#txtPixCopiaCola').val();
          await enviaWhatsAppPix(codCli, nomeCliente, celular, pixCopiaCola, 'VENDA_PIX')
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#btn_confirmar_nfce').on('click', async function() {
        $.LoadingOverlay("show");
        try {
          $('#btn_confirmar_nfce').prop('disabled', true);
          var bErro = false;
          var sErro = [];
          var bAutomatico = parametrosVenda[6];
          const infoEmpresa = await retornaInformacaoEmpresa();
          const codcli = pegaChave('#txtClienteNFCE');
          const clienteExterior = await clienteDoExterior(codcli);
          if ((clienteExterior) && (parametrosVenda[3].VALOR === '')) {
            msgErro('Necessário definir o parametro de cliente padrão da venda para cliente do exterior. ');
            return;
          }

          if (clienteExterior) {
            insereValor('#txtCpfNFCE', '000.000.000-00');
          }

          if ((pegaDescricao('#txtClienteNFCE').substring(0, 16).toUpperCase() != 'CONSUMIDOR FINAL') &&
            ((infoEmpresa.EMP_ESTADO != 'MG') ||
              (infoEmpresa.EMP_ESTADO != 'RS')) &&
            (!valida_cpf_cnpj($('#txtCpfNFCE').val()))) {
            if (!((infoEmpresa.EMP_ESTADO == 'RS') && ($('#txtCpfNFCE').val() == ''))) {
              if (bAutomatico == 2) {
                bErro = true;
                sErro.push('CPF/CNPJ inválido, verifique.');
              } else {
                msgAlerta('CPF/CNPJ inválido, verifique.');
                $('#txtCpfNFCE').val('');
                $('#txtCpfNFCE').focus();
                return;
              }
            }
          }

          if ($('#txtCpfNFCE').val() == '') {
            if (!((infoEmpresa.EMP_ESTADO == 'RS') && ($('#txtCpfNFCE').val() == ''))) {
              if (bAutomatico == 2) {
                bErro = true;
                sErro.push('Necessário informar um CPF/CNPJ.');
              } else {
                msgAlerta('Necessário informar um CPF/CNPJ.');
                return;
              }
            }
          }

          if (($('#txtNaturezaNFCE').val() == '') && ($('#txtOperacaoNfce').val() == '')) {
            if (bAutomatico == 2) {
              bErro = true;
              sErro.push('Natureza ou Operação não informadas.');
            } else {
              msgAlerta('Natureza ou Operação não informadas.');
              return;
            }
          }

          if (await validaCpfEValorMaximo($('#txtCpfNFCE').val())) {
            return;
          }

          await contemBaixaReceberVenda($('#txtCodVen').val());

          const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2);

          //faz a requisição na api passando os dados..
          const natureza = pegaChave('#txtNaturezaNFCE');
          const cpf = $('#txtCpfNFCE').val();
          const obs = $('#txtInfoAdicionaisNFCE').val();
          const codven = $('#txtCodVen').val();
          const operacao = pegaChave('#txtOperacaoNfce');
          const url = '/Sisplan/NFCE/v1/ConverteGeraNFCE?';
          const params = `CNPJ=${cpf}&NATUREZA=${natureza}&OBSERVACAO=${obs}&CODVEN=${codven}&CODOPERACAO=${operacao}&CERTA3=${usaCertificadoA3}&CODCLI=${codcli}`;

          try {
            const valorCashBackUtilizadoComoDesconto = String(cashbackCliente.valorUtilizado).replaceAll('.', ',');
            const pontosCashBackUtilizadoComoDesconto = String(cashbackCliente.pontosUtilizados).replaceAll('.', ',');
            const condicao = {};
            condicao.antecipacoesPresente = array_cartao_presente;
            var response = await requisicao('POST', '/Sisplan/Vendas/V1/FinalizaVenda?', `CASHBACK=1&PONTOS_CASHBACK=${pontosCashBackUtilizadoComoDesconto}&VALOR_CASHBACK=${valorCashBackUtilizadoComoDesconto}&CODVENDA=${codven}&NRSERIE=${''}&NFCE=${true}`, `&ANTECIPACOES_PRESENTE=${JSON.stringify(condicao)}`, 900000);            
            if (!response) {
              return false;
            }
            if (response.status != 200) {
              msgErro('Erro ao finalizar venda.');
              return false;
            }
            await verificaVendaFinalizadaEEnviaWhatsApp('<?php echo BASE_URI; ?>', codven, "VENDA");
            const bImprimeAutomatico = await verificaImprimirAutomatico('NFCE');

            if (usaCertificadoA3 == '1') {
              const responseNfceFat = await requisicao('POST', url, params, null);
              const jsonStrNfceFat = await responseNfceFat.json();

              if (responseNfceFat.status == 200) {
                const xml = jsonStrNfceFat.mensagem;

                //transmite a nfce na apilocal
                const responseLocal = await requisicao_ecf('POST', '/nfce/emitir?', `EMPRESA=${JSON.stringify(infoEmpresa)}`, xml, 120000);
                if (responseLocal.status != 200) {
                  const mensagemErro = await responseLocal.text();
                  msgErro(mensagemErro);
                  return;
                }

                const retornoNota = await responseLocal.json();
                const faturaNfce = retornoNota.fatura;
                const serieNfce = retornoNota.serie;
                const tipoNfce = 0;

                // termina de transmitir na api web, da os updates etc
                const reponseApiWeb = await requisicao(
                  'POST',
                  '/sisplan/nfce/v1/finalizanfce?',
                  `FATURA=${faturaNfce}&SERIE=${serieNfce}&TIPO=${tipoNfce}`,
                  JSON.stringify(retornoNota),
                  60000
                );
                if (!response) {
                  return;
                }
                if (reponseApiWeb.status != 200) {
                  const mensagemRetorno = await reponseApiWeb.json();
                  msgErro(mensagemRetorno.mensagem);
                  return;
                };

                const urlImprimir = `/sisplan/nfce/v1/imprimirnfce?FATURA=${faturaNfce}&SERIE=${serieNfce}&CODVEN=${codven}`;
                if (bImprimeAutomatico) {
                  // ADICIONADO SLEEP POIS FICOU MUITO RÁPIDO O PROCESSO E PODE SE PERDER AO IMPRIMIR AUTOMÁTICO (INTERNO NÃO OCORRE)
                  await sleep(3000);
                  GeraRelatorio(`${urlImprimir}&`, 'GET', 15000, false, 'NFCE');
                } else {
                  const arquivo = await GeraRelatorio(`${urlImprimir}&`, 'GET', 15000, false, 'NFCE');
                  if (arquivo != undefined) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    await limparRelatorios();
                  }
                }
              };
            } else {
              if (bImprimeAutomatico) {
                // ADICIONADO SLEEP POIS FICOU MUITO RÁPIDO O PROCESSO E PODE SE PERDER AO IMPRIMIR AUTOMÁTICO (INTERNO NÃO OCORRE)
                await sleep(3000);
                await GeraRelatorio(url + params + '&', 'POST', 60000, false, 'NFCE', null, "VENDA");
              } else {
                const arquivo = await GeraRelatorio(url + params + '&', 'POST', 60000, false, 'NFCE');
                if (arquivo != undefined) {
                  window.open('<?php echo BASE_URI; ?>/relatorios_api/pdf/' + arquivo, '_blank');
                  await limparRelatorios();
                } else {
                  bErro = true;
                }
              }
            }
          } catch (error) {
            bErro = true;
            sErro.push('Erro ao gerar NFC-e');
            console.error(error);
          }

          await enviaWhatsNFCE(undefined, undefined, undefined, undefined, codven);

          let arrayMoedas = []
          for (let i = 0; i < $('#tabelaCondicoesDePagamento').DataTable().rows().count(); i++) {
            arrayMoedas.push($('#tabelaCondicoesDePagamento').DataTable().row(i).data()[1].split(' - ')[0])
          }

          if (arrayMoedas.length > 0) {
            if (await verificaMoedaCarne(arrayMoedas)) {
              let url = `/sisplan/impressao/v1/carne?CODVEN=${numero_venda}`;
              const bImprimeAutomatico = await verificaImprimirAutomatico('Carne');
              let arquivo = await GeraRelatorio(`${url}&`, 'GET', 15000, false, 'Carne');
              if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                  window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
              }
            }
          }
          const hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
          if (!bErro) {
            toastr.success(
              'NFC-e gerada com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 2000,
                fadeOut: 1000,
                onHidden: async function() {
                  await ImprimirCupomTrocaAutomatico();
                  await deletaVendaNaoSalva(hostname + '.txt');
                  window.location.href = '<?php echo BASE_URI; ?>/venda/create';
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          } else {
            toastr.error(
              'Erro ao transmitir NFC-e, necessário gerar manualmente na aba que será aberta.<br>' +
              'Lista de problemas:<br>' + sErro
              .toString(),
              'Erro', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 12000,
                fadeOut: 6000,
                onHidden: async function() {
                  await ImprimirCupomTrocaAutomatico();
                  window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
                  parent.abrirEmNovaAbaIFrame('Impressão NFC-e', '<?php echo BASE_URI; ?>/nfce')
                  parent.document.querySelector("#abrirTelaCheia").click()
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          }
        } finally {
          $('#btn_confirmar_nfce').prop('disabled', false);
          $.LoadingOverlay("hide");
        }
      });

      $('#btn_confirmar_nfe').on('click', async function() {
        try {
          $.LoadingOverlay("show");

          let validacao = ''

          if ($('#txtOperacaoNota').val() != '') {
            validacao = $('#txtClienteNFE').val() != '';
          } else {
            validacao = $('#txtNaturezaNFE').val() != '' && $('#txtClienteNFE').val() != '';
          }

          if (validacao) {
            if (!await RotinaFinalizarVenda(false, false, false, false, true, false, bNFEAutomatico == 3)) {
              return false;
            }

            let nota = {};
            nota.NATUREZA = $('#txtNaturezaNFE').val();
            nota.CLIENTE = $('#txtClienteNFE').val();
            nota.CODVEN = $('#txtCodVen').val();
            nota.OPERACAO = $('#txtOperacaoNota').val();

            const jsonNota = JSON.stringify(nota);

            numero_venda = nota.CODVEN;

            if (bNFEAutomatico == 3) {
              const faturarVenda = await RotinaFaturarVenda(nota.CODVEN, pegaChave('#txtNaturezaNFE'), pegaChave('#txtClienteNFE'), pegaChave('#txtOperacaoNota'));
              if (faturarVenda.regraAplicada) {
                const transmiteNota = await rotinaTransmiteNota(faturarVenda.fatura, faturarVenda.serie);
                if (transmiteNota[0]) {
                  await imprimirNfe(faturarVenda.fatura, faturarVenda.serie);
                  window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
                } else {
                  if (parametrosVenda[111] == '') {
                    msgAlerta(`${transmiteNota[1]}\nRedirecionando a tela de impressão de nota.`, null, null, () => {
                      window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
                      parent.abrirEmNovaAbaIFrame('Impressão NFe', `<?php echo BASE_URI; ?>/nfeimpressao`);
                    });
                  } else {
                    msgAlerta(transmiteNota[1], null, null, () => {
                      window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
                    });
                  }
                }
              } else {
                parent.abrirEmNovaAbaIFrame('Faturamento Geral', `<?php echo BASE_URI; ?>/faturamento/`, btoa(jsonNota));
                window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
              }
              await toastrFinalizarVenda(`Venda <b>${nota.CODVEN}</b> gravada, status: Finalizada!`, async () => {await ImprimirCupomTrocaAutomatico();});
            } else {
              parent.abrirEmNovaAbaIFrame('Faturamento Geral', `<?php echo BASE_URI; ?>/faturamento/`, btoa(jsonNota))
              window.location.href = `<?php echo BASE_URI; ?>/venda/create`;
            }
          } else {
            msgAlerta('Favor preencher os campos para continuar.')
          }

        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#btnRecalcularRegra').on('click', async function() {
        await eventoClickBtnRecalcularRegra();
      });

      async function eventoClickBtnRecalcularRegra(estorno = false) {
        try {
          if ((parametrosVenda[29] != 1) && (parametrosVenda[29] != 2)) {
            return;
          }

          $.LoadingOverlay('show');
          try {

            if ($('#txtRegraPromocao').val() != '') {
              $('#txtTabela').prop('disabled', true);
              $('#btn-tabela').prop('disabled', true);
              $('#btn-limpa-tabela').prop('disabled', true);
            }
            const regra = pegaChave('#txtRegraPromocao');
            if ((regra) || (parametrosVenda[29] == 2)) {
              await RecalculaRegraPromocao(regra, estorno);

              let venda = {};
              venda = await montaJsonVenda(venda, numero_venda, 'P', false);
              salvaDadosDigitados(venda);
            } else {
              let itens = $('#tabelaItens').DataTable().rows().data();
              itens.each((item, i) => {
                item[4] = item[3];
                item[5] = 0;
                item[6] = 0;
                item[7] = ArredondarValor(item[3] * item[2], 2);
                item[20] = 0;
                item[21] = 0;
                item[22] = 0;
                item[31] = 0;
                $('#tabelaItens').DataTable().row(i).data(item);
              });
              let venda = {};
              venda = await montaJsonVenda(venda, 'create', 'P', false);
              salvaDadosDigitados(venda);
              atualizaTotalVenda();
              return;
            }
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      $('#btnFinalizar').on('click', async function() {
        if ($('#btnFinalizar').prop('disabled')) {
          return;
        }

        try {

          $('#btnFinalizar').prop('disabled', true);

          const rotina = async () => {
            try {


              if ($('#txtCliente').val() == '') {
                msgAlerta('Cliente não informado, verifique.');
                return;
              }

              if ($('#txtVendedor').val() == '') {
                msgAlerta('Vendedor não informado, verifique.');
                return;
              }

              if ((!["2", "4"].includes(utilizaGuia)) && (!$('#GuiaInfoTour').hasClass('d-none')) && ($('#txtGuia').val() == '')) {
                msgAlerta('Necessário informar um guia para continuar.');
                return;
              }

              const estaComMensagensBloqueio = ($('#modal-warning-conteudo').val().indexOf('Cliente já possui consignado pendente') > -1) ||
                ($('#modal-warning-conteudo').val() == 'Cliente possui duplicatas em atraso, necessário efetuar a negociação antes de iniciar nova venda.') ||
                ($('#modal-warning-conteudo').val().indexOf('Necessário finalizar o atendimento dos consignados') > -1);
              if (estaComMensagensBloqueio) {
                $('#btnInfo').trigger('click');
                return;
              }

              var total = $('#tabelaItens').DataTable().column(7, {}).data().sum();
              var total_pagto = $('#tabelaCondicoesDePagamento').DataTable().column().data().count();
              var saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
              if (await TemSaldoAPagar()) {
                return;
              }

              let algumaMoedaUsaTroco = false;
              for (let i = 0; i < numlinhas; i++) {
                const dado = $('#tabelaCondicoesDePagamento').DataTable().row(i).data();
                const iMoeda = dado[6];
                const possuiTroco = await moedaPossuiTroco(iMoeda);

                if (algumaMoedaUsaTroco == true) { // se não possuir troco
                  break;
                } else {
                  algumaMoedaUsaTroco = possuiTroco;
                }
              }

              if ((algumaMoedaUsaTroco == true) && (!UsuarioPodeGravarCondicoes)) {
                fechaCFe = false;
                await verificaEAbreTroco();
              } else {
                $('#btnFinalizar').prop('disabled', false);
                await RotinaFinalizarVenda(false, false);
              }

            } finally {
              $('#btnFinalizar').prop('disabled', false);
            }
          }

          const numlinhas = $('#tabelaCondicoesDePagamento').DataTable().rows()[0].length;
          const dadosTipo = await BuscaTiposVenda($('#txtTipoVenda').val());
          const bloqueiaVendaPendente = dadosTipo[0].VENDA_PENDENTE == 2;
          const permiteVendaPendenteSenhaSupervisor = dadosTipo[0].VENDA_PENDENTE == 1;

          if ((bloqueiaVendaPendente) && (numlinhas == 0)) {
            msgAlerta('Tipo de venda não permite deixar venda pendente. ');
            return;
          } else if ((controleLimiteCredito == '1') && (dadosTipo[0].CONSIGNADO == 'S')) {
            await carregaLimiteCredito(pegaChave('#txtCliente'));
            if (!await verificaLimiteCredito(true, true)) {
              return;
            }
          } else if ((permiteVendaPendenteSenhaSupervisor) && (numlinhas == 0)) {
            await senhaSupervisor(
              `Tipo de venda não permite deixar venda pendente.`,
              rotina, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
            return;
          }
          await rotina();
        } finally {
          $('#btnFinalizar').prop('disabled', false);
        }
      });

      $('#btnConfirmar').on('click', async function() {
        var dataOld = $('#tabelaImportacao').DataTable().rows().data().toArray();
        for (let i = 0; i < dataOld.length; i++) {
          if (dataOld[i][5] != dataOld[i][6]) {
            msgErro('Necessário bipar todos os itens da venda.');
            return;
          }
        }
        await rotinaGeraLog('TVENDALOJA', numero_venda, 'Realizada conferência dos itens da venda ' + numero_venda + ' pelo usuário ' + getCookie('usuario'))
      });

      function intersecao(arr1, arr2) {
        return arr1.filter(item => arr2.includes(item));
      }

      async function alteraPesquisaMoeda() {
        try {
          const listaMoedasCliente = await verificaMoedasCliente(pegaChave('#txtCliente'));
          const listaMoedasTipoVenda = await verificaMoedasTipoVenda($('#txtTipoVenda').val());
          let whereMoeda = [];
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"REGIAO",
                  "camposSelect":["moeda_vinc"],
                  "where": ["REGIAO = '${pegaChave('#txtTabela')}'"]}`, null);

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            return;
          } else if ((jsonStr.RESULT[0][0].MOEDA_VINC == null) || (jsonStr.RESULT[0][0].MOEDA_VINC ==
              undefined) || jsonStr.RESULT[0][0].MOEDA_VINC == '') {
            if (listaMoedasTipoVenda.length > 0) {
              $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasTipoVenda.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND'], callbackSaidaMoeda);
              $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasTipoVenda.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
              $('#txtMoedaSimulacao').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${listaMoedasTipoVenda.toString()})"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND']);
              $('#btnMoedaSimulacao').pesquisa_array(['#txtMoedaSimulacao'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasTipoVenda.toString()})"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
            } else if (listaMoedasCliente.length > 0) {
              //se tiver moeda no cliente, mas tiver moeda na empresa tambem, deve filtrar apenas moedas que ambos tem em comum.
              const listaMoedasClienteEmpresa = listaMoedasEmpresa.length > 0 ?
                intersecao(listaMoedasCliente, listaMoedasEmpresa) :
                listaMoedasCliente;
              $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${listaMoedasClienteEmpresa.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND'], callbackSaidaMoeda);
              $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasClienteEmpresa.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
              $('#txtMoedaSimulacao').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${listaMoedasClienteEmpresa.toString()})"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND']);
              $('#btnMoedaSimulacao').pesquisa_array(['#txtMoedaSimulacao'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasClienteEmpresa.toString()})"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
            } else if (listaMoedasEmpresa.length > 0) {
              $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${listaMoedasEmpresa.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND'], callbackSaidaMoeda);
              $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasEmpresa.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
              $('#txtMoedaSimulacao').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${listaMoedasEmpresa.toString()})"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND']);
              $('#btnMoedaSimulacao').pesquisa_array(['#txtMoedaSimulacao'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${listaMoedasEmpresa.toString()})"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
            } else {
              $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND'], callbackSaidaMoeda);
              $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
              $('#txtMoedaSimulacao').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": null}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND']);
              $('#btnMoedaSimulacao').pesquisa_array(['#txtMoedaSimulacao'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": null}`, 'Pesquisa Forma de Pagamento', 'moeda');
            }
          } else {
            let moedasRegiao = jsonStr.RESULT[0][0].MOEDA_VINC.split(',');
            if (listaMoedasEmpresa.length > 0) {
              for (let i = 0; i < moedasRegiao.length; i++) {
                if (listaMoedasEmpresa.includes(parseInt(moedasRegiao[i]))) {
                  whereMoeda.push(moedasRegiao[i]);
                }
              }
            } else {
              whereMoeda = jsonStr.RESULT[0][0].MOEDA_VINC.split(',');
            }
            if (!whereMoeda.includes(pegaChave('#txtMoeda'))) {
              $('#txtMoeda').val('')
            }
            $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${whereMoeda.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND']);
            $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${whereMoeda.toString()}) AND COALESCE(MOEDA.UTILIZA,'0') <> '1'"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
            $('#txtMoedaSimulacao').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) CDCONDI", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["moeda.codmoe in (${whereMoeda.toString()})"], "orderBy": ["moeda.codmoe"]}`, ['#txtBaixaAntecipacao', '#txtTipoMoeda', '#txtCodCondMoeda'], ['BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['BAIXA_ANTE', 'TIPO', 'DESC_COND']);
            $('#btnMoedaSimulacao').pesquisa_array(['#txtMoedaSimulacao'], ['CODMOE', 'BAIXA_ANTE', 'TIPO', 'CDCONDI'], ['DESCRICAO', 'BAIXA_ANTE', 'TIPO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) cdcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe in (${whereMoeda.toString()})"], "orderBy": ["moeda.codmoe"]}`, 'Pesquisa Forma de Pagamento', 'moeda');
          }

        } catch (error) {
          console.error(error);
        }
      }

      $('#txtRegraPromocao').autocompleta(1, `JSON={ "tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA chave", "DESC_REGRA descricao"], "where": null, "groupby": ["REGRA", "DESC_REGRA"]}`, '', '', '');
      $('#btn-RegraPromocao').pesquisa('#txtRegraPromocao', 'REGRA', 'DESC_REGRA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA", "DESC_REGRA"], "where": null, "groupby": ["REGRA", "DESC_REGRA"]}`, 'Pesquisa Regra', 'regra_promocao', '');

      $('#txtRegraPromocao').blur(async function() {
        if ($(this).val() != '') {
          SaidaCampoRegra();
        }
      });

      $('#btn-limpa-RegraPromocao').on('click', function() {
        $('#txtRegraPromocao').val('');
        SaidaCampoRegra();
        desbloqueiaTabela();
      });

      $('#btnPagamento').on('click', async function() {
        if ($(this).attr('disabled')) {
          return;
        }
        let tipoVendaEhConsig = await buscaValor('VENDA_TIPO', 'CONSIGNADO', 'ID', $('#txtTipoVenda').val());
        if (tipoVendaEhConsig == 'S') {
          await verificaPermiteConsig()
        }
        async function verificaPermiteConsig() {
          let table = $("#tabelaItens").DataTable();

          for (let i = 0; i < $("#tabelaItens").DataTable().data().length; i++) {
            arrayData = table.row(i).data();
            let grupo = await buscaValor('PRODUTO', 'GRUPO', 'CODIGO', arrayData[0]);
            let permiteConsig = await buscaValor('GRUPO_PA', 'PERMITE_CONSIG', 'CODIGO', grupo);
            if (permiteConsig == 'N') {
              throw msgAlerta(`O grupo do produto: ${arrayData[1]} está marcado para não permitir consignado, impossível continuar!`)
            }
          }
        }

        async function executaBotaoPagamento() {
          await alteraPesquisaMoeda();
          /* REMOVIDO ESSE BLUR POIS JA EXISTE UM EVENTO FOCUSOUT DECLARADO NO ESCOPO DO DOCUMENT
           $('#txtMoeda').blur(async function() {
             await RotinaSaidaMoeda();
           }); */

          if (!$('#menu_fiscal').hasClass('d-none')) {
            var bUsaECF = parametrosVenda[8];
            setCookie('enviando_comando', 'false');

            if (bUsaECF == '1') {
              if (($('#txtStatusECF').html() == " Offline ") || ($('#txtEstadoECF').html() == "Desconectado")) {
                if (await maquinaTemImpressora()) {
                  await habilitaPanelImpressora(true);
                  await buscaStatusImpressora();
                  if (($('#txtStatusECF').html() == " Offline ") || ($('#txtEstadoECF').html() ==
                      "Desconectado")) {
                    conectaECF(ipInterno, ipExterno, basicAuth);
                  }
                  if ($('#txtEstadoECF').html() == 'Requer Z') {
                    msgAlerta(
                      'Impressora com Redução Z pendente, para emitir, utilize o menu fiscal localizado a direita.'
                    );
                  }
                }
              }
            }
          }

          if ((($('#txtCliente').val() == '') || ($('#txtDeposito').val() == '') || ($('#txtTabela').val() == '') || ($('#txtVendedor').val() == ''))) {
            msgAlerta('Necessário informar os campos Cliente, Deposito, Vendedor e Tabela de Preço.');
            $('#btnInfo').trigger('click');
          } else if ((!["2", "4"].includes(utilizaGuia)) && (!$('#GuiaInfoTour').hasClass('d-none')) && ($('#txtGuia').val() == '')) {
            msgAlerta('Necessário informar um guia para continuar.');
            $('#btnInfo').trigger('click');
          } else
          if ($('#tabelaItens').DataTable().column(7, {}).data().sum() <= 0) {
            const estaComMensagensBloqueio = ($('#modal-warning-conteudo').val().indexOf('Cliente já possui consignado pendente') > -1) ||
              ($('#modal-warning-conteudo').val() == 'Cliente possui duplicatas em atraso, necessário efetuar a negociação antes de iniciar nova venda.');
            if (estaComMensagensBloqueio) {
              $('#btnInfo').trigger('click');
              return;
            }

            msgAlerta('Venda sem nenhum item, verifique. ');
            $('#btnVenda').trigger('click');
          } else {
            await regraPromocao();
            // removido condição abaixo pois quando é adicionado desconto aos itens, já passa por essa questão da validação de desconto, pedindo senha de supervisor.
            // então se chegou aqui com desconto, quer dizer que já passou e não deve solicitar novamente a senha de supervisor ...
            await RotinaCliquePagamento();
            await BaixaAntecipacaoAutomatica();
            // if ((descontoTotalUsuario) && (parseFloat(descontoTotalUsuario) > 0)) {
            //   await verificaDescontoTotalItens(async () => {
            //     await RotinaCliquePagamento();
            //     await BaixaAntecipacaoAutomatica();
            //   });
            // } else {
            //   await RotinaCliquePagamento();
            //   await BaixaAntecipacaoAutomatica();
            // }
          }
        }
        const abriuModalConferencia = await RotinaModalConferencia(executaBotaoPagamento);
        if (abriuModalConferencia) {
          return;
        }
        await executaBotaoPagamento();
        await validaClienteSuframa(pegaChave('#txtCliente'));

        if (($('#txtCupomDesconto').val() != '') && ($('#txtCupomDesconto').prop('disabled') == false)) {
          $('#btnAplicarCupomDesconto').trigger('click')
        }
      });

      $('#btn-calc-suframa').on('click', async function() {
        if ($('#txtMoeda').val() == '') {
          msgAlerta('Informar a forma e condição de pagamento antes de calcular o valor de Suframa.')
          return;
        }

        await calculaSuframaVenda();
      });

      async function verificaDescontoTotalItens(funcao) {
        try {
          await retornaValoresDesconto();
          const valorBrutoVenda = $('#somaValorTotalVenda').val();
          const descontoTotalUsuario = await retornaDescontoMaximoUsuario();
          const valorLiquido = parseFloat($('#subtotal_venda').html().split(';')[1].replaceAll('.', '').replace(',', '.'));
          const temDescontoRegraPromocao = $('#tabelaItens').DataTable().data().toArray().filter(data => data[22] > 0).length > 0;
          const valorLiquidoSemRegraPromocao = $('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            if (item[22] > 0) {
              return total + parseFloat(item[7] + (item[20] * item[2]))
            } else {
              return total + parseFloat(item[7])
            }
          }, 0);
          const percentualDescontoTotal = ((parseFloat(valorBrutoVenda) - parseFloat(temDescontoRegraPromocao ? valorLiquidoSemRegraPromocao : valorLiquido)) / parseFloat(valorBrutoVenda)) * 100;

          if (descontoTotalUsuario > 0) {
            if (percentualDescontoTotal > parseFloat(descontoTotalUsuario)) {
              await senhaSupervisor(
                `Desconto de ${percentualDescontoTotal.toFixed(2)}% nos Itens, máximo do usuário é de ${descontoTotalUsuario}%.`, funcao, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
            } else {
              funcao();
            }
          } else {
            funcao();
          }

        } catch (error) {
          console.error(error);
        }
      }

      async function buscaRestricaoCondicao() {
        const Moeda = pegaChave('#txtMoeda');
        const Condicao = pegaChave('#txtCondicaoDePagamento');
        if (!Condicao) {
          return
        }

        if (!Moeda) {
          return
        }

        const pesquisaParam = {
          tabela: "COND_MOEDA",
          camposSelect: [
            "RESTRICAO",
          ],
          where: [`MOEDA = ${Moeda} AND CODCOND = ${Condicao} `]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(pesquisaParam)));

        return jsonStr[0].RESTRICAO === 'S';
      }

      async function RotinaSaidaMoeda() {
        if (!$('#txtMoeda').val().includes('[')) {
          return ""
        }
        var codmoeda = pegaChave("#txtMoeda", codmoeda);

        // $('#txtCondicaoDePagamento').off();
        async function verificaMoedaAtiva() {
          const pesquisa = {
            tabela: 'MOEDA',
            camposSelect: ['ATIVO', 'BANDEIRA'],
            where: [`CODMOE = ${codmoeda}`]
          }
          //adicionar where dos filtros
          const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          if (json[0].ATIVO == 'N') {
            $('#txtMoeda').val('');
            msgAlerta('Moeda Inativa, verificar no cadastro de moeda!');
            return;
          }

          if (json[0].BANDEIRA == '01') {
            $('#select_bandeira').val('VISA').change();
          } else if (json[0].BANDEIRA == '02') {
            $('#select_bandeira').val('MASTERCARD').change();
          } else if (json[0].BANDEIRA == '03') {
            $('#select_bandeira').val('AMERICANEXPRESS').change();
          } else if (json[0].BANDEIRA == '04') {
            $('#select_bandeira').val('SOROCRED').change();
          } else if (json[0].BANDEIRA == '05') {
            $('#select_bandeira').val('DINERS').change();
          } else if (json[0].BANDEIRA == '06') {
            $('#select_bandeira').val('ELO').change();
          } else if (json[0].BANDEIRA == '07') {
            $('#select_bandeira').val('HIPERCARD').change();
          } else if (json[0].BANDEIRA == '08') {
            $('#select_bandeira').val('AURA').change();
          } else if (json[0].BANDEIRA == '09') {
            $('#select_bandeira').val('CABAL').change();
          }
        }

        if (codmoeda != '') {
          await verificaMoedaAtiva();
        }
        if ((codmoeda != '') && (await temCondicoesEspecificas(codmoeda))) {
          $('#txtCondicaoDePagamento').unbind('autocompleta');
          $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${codmoeda})"]}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
          $('#btn-CondicaoDePagamento').off();
          $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
          $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar", "cond_moeda.valor_minimo", "cond_moeda.restricao"], "leftJoin": [{"tabela": "cond_moeda", "condicao": "condicao.codcond = cond_moeda.codcond"}], "where": ["COND_MOEDA.MOEDA=${codmoeda}"], "orderBy": ["condicao.nrpar", "condicao.codcond"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
          $('#txtCondicaoDePagamento').on('blur', async function() {
            const bRestricao = await buscaRestricaoCondicao()
            if (bRestricao) {
              senhaSupervisor('Condição de pagamento está bloqueada',
                async () => {
                    const validaCond = await validaCondPagto(pegaChave('#txtCondicaoDePagamento'));
                    if (!validaCond) {
                      return;
                    }
                    $('#txtValorParcela').trigger('change');
                    if (!$('.bandeira').hasClass('d-none')) {
                      $('#select_bandeira').select2('open');
                    }
                  },
                  '',
                  false,
                  () => {
                    $('#txtCondicaoDePagamento').val('')
                    $('#txtNrParcelas').val(1)
                    return false
                  },
                  () => {
                    $('#txtCondicaoDePagamento').val('')
                    $('#txtNrParcelas').val(1)
                    return false
                  }, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0)
            } else {
              const validaCond = await validaCondPagto(pegaChave('#txtCondicaoDePagamento'));
              if (!validaCond) {
                return;
              }
              $('#txtValorParcela').trigger('change');
              if (!$('.bandeira').hasClass('d-none')) {
                $('#select_bandeira').select2('open');
              }
            }
            const validaCond = await validaCondPagto(pegaChave('#txtCondicaoDePagamento'));
            if (!validaCond) {
              return;
            }
          });
        } else {
          // volta condições padrões
          $('#txtCondicaoDePagamento').unbind('autocompleta');
          $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
          $('#btn-CondicaoDePagamento').off();
          $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
          $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null, "orderBy": ["nrpar", "codcond"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
        }
        var baixaAntecipacao = pegaChave('#txtBaixaAntecipacao', baixaAntecipacao);
        var codCondMoeda = $('#txtCodCondMoeda').val();
        var chaveCondMoeda = pegaChave("#txtCodCondMoeda", chaveCondMoeda);
        var sCodCli = pegaChave('#txtCliente', sCodCli);
        var tipoMoeda = pegaChave('#txtTipoMoeda', tipoMoeda);
        var bUsaTef = false;
        let retornoInfoMoeda = [];
        const bIntegracaoTeiaCard = parametrosVenda[70] == "1";

        if (codmoeda != '') {
          $("#txtPercDescontoMoeda").val(0);
          retornoInfoMoeda = await RetornaInformacoesMoeda(codmoeda);
          const maxNrParcelas = retornoInfoMoeda[2] ?? 0;
          $('#txtMaxNrParcelasMoeda').val(maxNrParcelas);
          var descAuto = retornoInfoMoeda[1];
          if ((descAuto > 0) && (parseFloat($("#txtPercDescontoMoeda").val()) == 0)) {
            $("#txtPercDescontoMoeda").val(descAuto);
          }
          $('#txtPercDescontoMoeda').trigger('blur');
        }

        if (tipoMoeda == 3) {
          bUsaTef = retornoInfoMoeda[0] == 'S';
        }

        if ((tipoMoeda == 3) && (!bUsaTef)) {
          await addBandeira(codmoeda);
          $('.nsu').removeClass('d-none');
          $('.bandeira').removeClass('d-none');
          $('.autorizacao').removeClass('d-none');
          $('#select_bandeira').addClass('focus');
          $('#txtNSU').addClass('focus');
          $('#txtAutorizacao').addClass('focus');
          ajustaCamposIntegracaoTeiaCard(true);
          await buscaBandeira(codmoeda);
        } else {
          if (!$('.nsu').hasClass('d-none')) {
            $('.nsu').addClass('d-none');
            $('.autorizacao').addClass('d-none');
            $('.bandeira').addClass('d-none');
            $('#select_bandeira').removeClass('focus');
            $('#txtNSU').removeClass('focus');
            $('#txtAutorizacao').removeClass('focus');
            // if (bIntegracaoTeiaCard) {
            //   ajustaCamposIntegracaoTeiaCard(false);
            // }
          }
        }
        if (bAplicaDescMaxTabPrecoVendaNotAlterar) {
          $("#PainelDesconto input").attr("disabled", true);
        } else {
          $("#PainelDesconto input").attr("disabled", false);
        }
        if (codmoeda == '0') {
          if ((codCondMoeda == '') || (codCondMoeda == '[] - ')) {
            msgAlerta('Necessário definir uma condição de pagamento no cadastro da moeda.');
            return;
          } else {
            $("#txtCondicaoDePagamento").prop('disabled', true);
            $("#btn-CondicaoDePagamento").prop('disabled', true);
            $("#btn-limpa-condicao").prop('disabled', true);
            if (codCondMoeda != '') {
              insereValor("#txtCondicaoDePagamento", codCondMoeda);
            }
            $("#txtNrParcelas").val('1');
          }
        } else {
          $("#txtCondicaoDePagamento").prop('disabled', false);
          $("#btn-CondicaoDePagamento").prop('disabled', false);
          $("#btn-limpa-condicao").prop('disabled', false);
          if (codCondMoeda != '' && codmoeda != '') {
            insereValor("#txtCondicaoDePagamento", codCondMoeda);
            var dadosMoeda = await RetornaDadosMoeda(codmoeda);
            insereValor('#txtNrParcelas', dadosMoeda['RESULT'][0][0].NRPAR, dadosMoeda['RESULT'][0][0].NRPAR);
          }
        }

        if (codmoeda == '0') {
          $("#txtValorParcela").focus();
          // $("#txtValorParcela").select();
        }
        // if ($('.bandeira').hasClass('d-none')) {
        //
        // } else {
        //     $('#select_bandeira').select2('open');
        // }
        var tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoes').DataTable().column(4, {}).data().sum()).toFixed(2));
        var tot_antecipacao_pago = parseFloat(parseFloat($('#tabelaAntecipacoes').DataTable().column(5, {}).data().sum()).toFixed(2));
        var saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
        var saldo_antecipacao = tot_antecipacao - tot_antecipacao_pago;
        if (((baixaAntecipacao == 'S') || (parametrosVenda[14] == pegaValor('#txtMoeda'))) && (saldo_antecipacao > 0)) {
          if (saldo_antecipacao <= saldo_a_pagar) {
            $("#txtValorParcela").val(saldo_antecipacao);
          } else {
            $('#txtValorParcela').val(saldo_a_pagar);
          }
        }
        // if ((codmoeda != '') && (await moedaPresente(codmoeda) == 'S')) {
        //   $('#modalPresente').modal('show');
        //   if ($('#tabelaPresente tr').length > 0) {
        //     $('#tabelaPresente').DataTable().clear().draw(false);
        //   }
        // }
        const validaCond = await validaCondPagto(pegaChave('#txtCondicaoDePagamento'));
        if (!validaCond) {
          return;
        }
      }

      $('#txtValorParcela').on('focus', function() {
        $(this).select();
      });

      $('#txtValorParcela').on('blur', async function() {
        const valorParcela = parseFloat($('#txtValorParcela').val());
        const saldoAPagar = parseFloat($("#txtsaldo_a_pagar").html().replaceAll(".", "").replace(",", "."));
        if (valorParcela > 0) {
          if (($('#txtValorDescontoMoeda').val() == '') && ($('#txtValorAcrescMoeda').val() == '') && ($('#txtFrete').val() == '0')) {
            $('#txtValorLiquidoMoeda').val(valorParcela);
          }
        }

        if (parametroValorIPIVenda && valorParcela != saldoAPagar) {
          atualizaExisteValorIPISaldoAPagar(false);
        }

      });

      $('#txtValorParcela').on('keydown', async function(e) {
        const parametroUsaAcrescimo = parametrosVenda[26];
        if (e.which == 13) {
          if ((parametroUsaAcrescimo == '1') && (!$('#txtPercAcrescMoeda').prop('disabled'))) {
            $('#txtPercAcrescMoeda').focus();
          } else {
            $('#txtPercDescontoMoeda').focus();
          }
        }
      });

      $('#btnConfirmarTroco').on('click', async function() {
        if (parseFloat($('#txtValorPagoTroco').val()) < parseFloat($('#txtValorPagarTroco').val())) {
          msgAlerta('Valor do pagamento não pode ser menor que o valor a pagar!');
          $('#txtValorPagoTroco').val(0);
          return;
        }
        $('#btnConfirmarTroco').prop('disabled', true);
        if (fechaF10 == true) {
          await RotinaFinalizarVenda(false, true);
        } else {
          await RotinaFinalizarVenda(false, false, false, false, false, fechaCFe);
        }
        $('#btnConfirmarTroco').prop('disabled', false);
      });

      //ve no blur o valor q foi pago e informa o troco
      $('#txtValorPagoTroco').on('change', async function() {
        var troco = 0
        if (parseFloat($('#txtValorPagoTroco').val()) < parseFloat($('#txtValorPagarTroco').val())) {
          msgAlerta('Valor do pagamento não pode ser menor que o valor a pagar!');
          $('#txtValorPagoTroco').val(0)
          return;
        }
        troco = parseFloat($('#txtValorPagoTroco').val()) - parseFloat($('#txtValorPagarTroco').val());

        $('#txtTroco').val(parseFloat(troco).toFixed(2));
      });

      async function rotinaSaidaVendedor() {
        const Vendedor = pegaChave('#txtVendedor');
        if (Vendedor != '') {
          $('#btn-guia').off();
          if (await ExisteGuiaVendedor(Vendedor)) {
            $('#txtGuia').autocompleta(1, `JSON={ "tabela":"REP_GUIA", "camposSelect":[ "rep_guia.guia chave", "represen.nome descricao" ], "leftjoin":[{"tabela" : "represen", "condicao" : "represen.codrep = rep_guia.guia"}], "where": ["rep_guia.codrep = '${Vendedor}'"]}`);
            $('#btn-guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "rep_guia","camposSelect": ["rep_guia.guia codrep", "represen.nome"],"leftjoin": [{"tabela": "represen","condicao": "represen.codrep = rep_guia.guia"}],"where": ["rep_guia.codrep = '${Vendedor}'"]}`, 'Pesquisa Representante', 'rep_guia');
          } else {
            $('#txtGuia').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S'", "grupo_rep = 'U'"] }`);
            $('#btn-guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "represen","camposSelect": ["codrep", "nome"],"where": ["ativo = 'S'", "grupo_rep = 'U'"] }`, 'Pesquisa Representante', 'represen');
          }
        }
      }

      $('#txtVendedor').on('blur', async function() {
        rotinaBlurVendedor();
      });

      function rotinaBlurVendedor() {
        rotinaSaidaVendedor();
        preencheVendedorGuia(pegaChave('#txtVendedor'), true);
        AtualizaVendedorItens();
      }

      $('#txtValorParcela').on('change', async function() {
        const valorParcela = parseFloat($('#txtValorParcela').val());
        const saldoAPagar = parseFloat($("#txtsaldo_a_pagar").html().replaceAll(".", "").replace(",", "."));
        if (valorParcela > 0) {
          if (($('#txtValorDescontoMoeda').val() == 0) && ($('#txtValorAcrescMoeda').val() == 0) && ($('#txtFrete').val() == '0')) {
            $('#txtValorLiquidoMoeda').val(valorParcela);
          }
          var saldo = 0;
        }

        if (parametroValorIPIVenda && valorParcela != saldoAPagar) {
          atualizaExisteValorIPISaldoAPagar(false);
        }

      });

      $('#txtValorLiquidoMoeda').on('blur', function() {
        $('#btnAddCondicao').focus();
      });


      $('#btnAddCondicao').on('keypress', async function() {
        $('#btnAddCondicao').trigger('click');
      });

      $('#txtNSU').on('keypress', function(event) {
        var regex = new RegExp("^[a-zA-Z0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
          event.preventDefault();
          return false;
        }
      });

      $('#txtFrete').keydown(function(e) {
        if (e.which === 13) {
          e.preventDefault();
          $('#txtFrete').trigger('blur');
          $('#txtMoeda').focus();
        }
      });

      async function moedaPossuiTroco(moeda) {
        try {
          $.LoadingOverlay('show');
          try {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"MOEDA", "camposSelect":["GERA_TROCO"],"where": ["CODMOE = '${moeda}'"]}`, null);

            if (!response) {
              return;
            }

            let jsonMoeda = await response.json();
            if (response.status != 200) {
              jsonMoeda['RESULT'][0].mensagem;
              return;
            }
            if (jsonMoeda['RESULT'][0][0]['GERA_TROCO'] == 'S') {
              return true;
            } else {
              return false;
            }

          } catch (error) {
            console.error(error);
            msgErro('Erro ao buscar os dados da moeda!' + error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      async function salvaDadosDigitados(objeto) {
        try {
          const response = await fetch(`<?php echo BASE_URI; ?>/salvar_arquivo.php?id_aba=${sessionStorage.getItem('g_idAba')}&tipoVenda=V`, {
            method: 'POST',
            body: `${JSON.stringify(objeto)}`,
          });

          return response;
        } catch (error) {
          msgAlerta('Erro ao salvar dados digitados!');
        }
      }

      async function verificaDescontoTotalNaVenda(addCondicao = false) {
        try {
          await retornaValoresDesconto();
          const valorBrutoVenda = parseFloat($('#somaValorTotalVenda').val());
          const descontoTotalUsuario = await retornaDescontoMaximoUsuario();
          const valorDescontoMoedas = parseFloat($('#tabelaCondicoesDePagamento').DataTable().column(11, {}).data().sum());
          const valorDescontoDosItens = (parseFloat($('#somaDescontoTotalVenda').val())) + parseFloat($('#txtValorDescontoMoeda').val()) + valorDescontoMoedas;
          const valorLiquido = valorDescontoDosItens;
          // const percentualDescontoTotal = (valorLiquido / valorBrutoVenda) * 100;
          const percentualDescontoTotal = $("#txtPercDescontoMoeda").val();

          function verificaDescSupervisorEAplica(userSupervisor) {
            verificaDescontoMaximoSupervisor(userSupervisor, adicionarCondicaoPagamento);
          }

          if ((parseFloat($('#txtValorDescontoMoeda').val()) > 0) && (parseFloat($('#txtPercDescontoMoeda').val()) > 0) && (descontoTotalUsuario > 0)) {
            if ((percentualDescontoTotal > parseFloat(descontoTotalUsuario)) && (!bCashBack)) {
              await senhaSupervisor(
                `Desconto de ${percentualDescontoTotal}% na venda, máximo do usuário é de ${descontoTotalUsuario}%.`,
                verificaDescSupervisorEAplica,
                () => {
                  adicionarCondicaoPagamento(addCondicao);
                }, true, undefined, undefined, undefined, false,
                'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'),
                parseFloat($('#txtValorParcela').val().replace(',', '.')) || 0, parseFloat($('#txtValorLiquidoMoeda').val().replace(',', '.')) || 0, parseFloat($('#txtPercDescontoMoeda').val().replace(',', '.')) || 0, parseFloat($('#txtValorDescontoMoeda').val().replace(',', '.')) || 0, pegaChave('#txtVendedor'));
            } else {
              await adicionarCondicaoPagamento(addCondicao);
            }
          } else {
            await adicionarCondicaoPagamento(addCondicao);
          }
          bCashBack = false;
        } catch (error) {
          console.error(error);
        }
      }

      async function verificaValorMinimoParcelaMoedaNaoAtingido(codmoeda, codcondicao, descMoeda, descCondicao) {
        // select VALOR_MINIMO from COND_MOEDA_001 cm  where moeda=4 and codcond=1
        const pesquisa = {
          camposSelect: ['VALOR_MINIMO'],
          tabela: 'COND_MOEDA',
          where: [`MOEDA = ${codmoeda} AND CODCOND = ${codcondicao}`]
        }
        try {
          const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON=${JSON.stringify(pesquisa)}`, null);

          if (!response) {
            return;
          }

          const jsonMoeda = await response.json();
          const valorMinimo = +jsonMoeda['RESULT'][0][0]['VALOR_MINIMO'];
          const valorCondicao = +$('#txtValorParcela').val();
          if (valorMinimo > valorCondicao) {
            msgAlerta(`Valor mínimo de R$ ${valorMinimo} exigido para a moeda ${descMoeda} na condição de pagamento ${descCondicao} não atingido.`);
            return true;
          }
          return false;

        } catch (error) {
          console.error(error);
          return false;
        }
      }

      async function verificaLimiteCredMaximoSupervisor(nome, callBack) {
        try {

          const json = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["PERC_LIMITE"], "where": ["NOME = '${nome}'"] }`);
          if (!json[0].PERC_LIMITE > 0) {
            return callBack();
          }
          const limiteUsuario = g_CreditoCliente + (parseFloat(g_CreditoCliente) * (json[0].PERC_LIMITE / 100));
          if (json) {
            if ((parseFloat(g_ValorAbertoCliente) > limiteUsuario)) {
              msgAlerta('Crédito aplicado é maior que o permitido para o supervisor!');
              return false;
            }

            adicionaLogVenda('TVENDALOJA', '', `Autorizado liberar crédito pelo usuario ${nome}, com o percentual de ${json[0].PERC_LIMITE} do seu usuário`, 'Inclusão')
            return callBack();
          }

        } catch (error) {
          console.error(error);
        }
      }

      async function buscaBandeira(moeda) {
        try {
          const pesquisa = {
            tabela: 'MOEDA',
            camposSelect: ['BANDEIRA.DESCRICAO'],
            leftJoin: [{
              tabela: 'BANDEIRA',
              condicao: 'MOEDA.ID_BANDEIRA = BANDEIRA.ID'
            }],
            where: [`MOEDA.CODMOE = ${moeda}`]
          }

          const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          if (json.length > 0) {
            $('#select_bandeira').val(json[0].DESCRICAO).change();
          }
        } catch (error) {
          console.log(error);
        }
      }

      async function adicionarCondicaoPagamento(passouAntecipacao = false) {
        $.LoadingOverlay('show');
        try {

          const bParametroSelecionaAntecipacao = parametrosVenda[49] == 1 | parametrosVenda[49] == 2 ?? false;
          const baixaAntecipacao = pegaChave('#txtBaixaAntecipacao');
          if ((baixaAntecipacao == 'S') && (bParametroSelecionaAntecipacao)) {
            $('#txtValorAntecipacao').html($('#txtValorParcela').val());
          }

          if (parseFloat($('#txtValorDescontoMoeda').val()) > parseFloat($('#txtValorParcela').val())) {
            msgErro('Valor de Desconto não pode ser maior que o valor a pagar.');
            return;
          }

          if (parseFloat($('#txtPercDescontoMoeda').val()) > 99.99) {
            msgErro('Percentual de Desconto não pode ser maior que o valor a pagar.');
            return;
          }

          $('#txtValorParcela').trigger('change');
          if ($('#txtCondicaoDePagamento').val() == '') {
            await RotinaSaidaMoeda();
          }

          const codcondpagto = pegaChave("#txtCondicaoDePagamento");
          const desccondpagto = pegaDescricao("#txtCondicaoDePagamento");
          const nr_parcelas = pegaChave('#txtNrParcelas');
          const codmoeda = pegaChave("#txtMoeda");
          const descmoeda = pegaDescricao("#txtMoeda");

          // if (await moedaPossuiTroco(codmoeda)) {
          //     var valor_pago = parseFloat($("#txtValorParcela").val());
          // } else {
          //     var valor_pago = parseFloat($("#txtValorLiquidoMoeda").val());
          // }
          const saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().replaceAll('.', '')).replace(',', '.'));
          const valorMaisDescontoAplicado = await verificaMoedaAplicaDescontoPag(codmoeda) ? parseFloat($('#txtValorParcela').val()) != saldo_a_pagar ? parseFloat($("#txtValorParcela").val()) + parseFloat($('#txtValorDescontoMoeda').val()) : 0 : 0;
          if (valorMaisDescontoAplicado > 0) {
            $("#txtValorParcela").val(valorMaisDescontoAplicado);
            await saidaCampoValorDesconto();
          }
          const valor_pago = parseFloat($("#txtValorLiquidoMoeda").val());
          const valor = parseFloat($("#txtValorLiquidoMoeda").val());
          $("#txtValorAcrescMoedaSalvo").val($("#txtValorAcrescMoeda").val());
          const inputValorParcela = parseFloat($("#txtValorParcela").val());

          const sCNPJ = $('#txtCNPJ').val();
          const sNome = pegaDescricao('#txtCliente');
          const tipoMoeda = pegaChave('#txtTipoMoeda');
          const codCondMoeda = pegaChave('#txtCodCondMoeda');
          const NSU = $("#txtNSU").val();
          const bandeira = $("#select_bandeira").val();
          const nsuVisivel = !$('.nsu').hasClass('d-none');
          const autorizacao = $("#txtAutorizacao").val();
          const bIntegracaoTeiaCard = parametrosVenda[70] == "1";

          if (inputValorParcela > saldo_a_pagar) {
            msgAlerta('Valor pago não pode ser maior que o saldo a pagar, verifique.');
            $('#txtValorDescontoMoeda').val(0);
            $('#txtPercDescontoMoeda').val(0);
            return;
          }

          // Verificar se o campo bandeira está visivel
          // Se estiver visivel, verificar se os campos bandeira e NSU estão preenchidos
          if (bIntegracaoTeiaCard) {
            if ((nsuVisivel) && ((NSU == '') || (bandeira == '') || (autorizacao == ""))) {
              msgAlerta('Campos obrigatórios [bandeira, NSU e autorização] não informados, verifique.');
              return;
            }
          } else {
            if ((nsuVisivel) && ((NSU == '') || (bandeira == ''))) {
              msgAlerta('Campos obrigatórios [bandeira e NSU] não informados, verifique.');
              return;
            }
          }
          if ((codmoeda == '') || (descmoeda == '') || (codcondpagto == '') || (desccondpagto == '') || (parseFloat($("#txtValorLiquidoMoeda").val()) <= 0)) {
            if ((parametrosVenda[58] != '4') || (!passouAntecipacao)) {
              msgAlerta('Campos obrigatórios [moeda, condição de pagamento e valor] não informados, verifique.');
              return;
            }
          }

          if (saldo_a_pagar == 0) {
            msgAlerta('Não há saldo a pagar, impossível adicionar nova condição de pagamento.');
            return;
          }

          if ((codmoeda != '') && (codcondpagto != '')) {
            if (await verificaValorMinimoParcelaMoedaNaoAtingido(codmoeda, codcondpagto, descmoeda, desccondpagto)) {
              return;
            }
          }
          const indexMoeda = $('#tabelaCondicoesDePagamento').DataTable().column(6).data().indexOf(codmoeda);
          let tot_antecipacao;
          let bTemAntecipacao;

          if (bParametroSelecionaAntecipacao) {
            tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(4, {}).data().sum()).toFixed(2));
            bTemAntecipacao = $('#tabelaAntecipacoesSelecionadas').DataTable().rows().count() > 0;
          } else {
            tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoes').DataTable().column(4, {}).data().sum()).toFixed(2));
            bTemAntecipacao = $('#tabelaAntecipacoes').DataTable().rows().count() > 0;
          }

          if ((baixaAntecipacao == 'S') && (indexMoeda >= 0)) {
            msgErro('Moeda que baixa antecipação não pode ser utilizada mais que uma vez na venda, verifique.');
            return;
          }

          if ((baixaAntecipacao == 'S') && (!bTemAntecipacao)) {
            msgErro('Não há nenhuma antecipação para ser utilizada com essa moeda de troca, verifique.');
            return;
          }
          // abre modal para selecionar as antecipações
          if ((bParametroSelecionaAntecipacao) && (baixaAntecipacao == 'S') && (!passouAntecipacao)) {
            $('#modalAntecipacoes').modal('show');
            return;
          }

          if (baixaAntecipacao == 'S') {
            if (!bParametroSelecionaAntecipacao) {
              baixaAntecipacaoOrdemVencimento();

            }
          }

          if ((baixaAntecipacao == 'S') && (parseFloat(parseFloat($("#txtValorLiquidoMoeda").val()).toFixed(2)) > tot_antecipacao)) {
            msgErro('Valor líquido não pode ser maior que o valor das antecipações em uma moeda de troca, verifique.');
            return;
          }
          const fechaVenda = await BuscaTiposVenda($('#txtTipoVenda').val());
          if (tipoMoeda == '1') {
            await MontaTabelaParcelas('cheque', sNome, sCNPJ, nr_parcelas, valor, valor_pago, codcondpagto, 'inclusao', true, '', codmoeda);

            if ((!UsuarioPodeGravarCondicoes) && (fechaVenda[0].FECHA_VENDA == 'S')) {
              $('#btnFinalizar').html(await traduzSentenca('Finalizar (F8)'));
              $('#btnFinalizar').attr('data-original', 'Finalizar (F8)');
            }

            return;
          }
          if ((tipoMoeda == '2')) {
            await MontaTabelaParcelas('crediario', sNome, sCNPJ, nr_parcelas, valor, valor_pago, codcondpagto, 'inclusao', false, '', codmoeda);
            if ((!UsuarioPodeGravarCondicoes) && (fechaVenda[0].FECHA_VENDA == 'S')) {
              $('#btnFinalizar').html(await traduzSentenca('Finalizar (F8)'));
              $('#btnFinalizar').attr('data-original', 'Finalizar (F8)');
            }
            return;
          }

          await MontaTabelaParcelas('outro', sNome, sCNPJ, nr_parcelas, valor, valor_pago, codcondpagto, 'inclusao', false, '', codmoeda);

          if ((!UsuarioPodeGravarCondicoes) && (fechaVenda[0].FECHA_VENDA == 'S')) {
            $('#btnFinalizar').html(await traduzSentenca('Finalizar (F8)'));
            $('#btnFinalizar').attr('data-original', 'Finalizar (F8)');
          }

          $('#txtMoeda').focus();
          return;

        } finally {
          $.LoadingOverlay('hide');
          atualizaSaldoAPagar();
          atualizaTotaisPagto();

          if ($("#txtValorAcrescMoeda").val() == 0 || $("#txtValorAcrescMoeda").val() == '') {
            // desabilita campos de acrescimo pois só é possível um acréscimo por venda
            $("#txtPercAcrescMoeda").prop('disabled', true);
            $("#txtValorAcrescMoeda").prop('disabled', true);
          }
        }
      }

      async function RetornaSeVendaAgrupadaEFaturada(codven) {
        try {
          try {
            if ((codven.toString().toUpperCase() == 'CREATE') || codven.toString().toUpperCase() == 'VENDAPENDENTE' || (codven == '')) {
              return false;
            }

            const pesquisa = {
              tabela: "NOTA",
              camposSelect: ["FATURA"],
              where: [`CODVEN IN (SELECT CODVEN FROM [VENDA] WHERE CDAGRUPADA = ${codven})`,
                ` IMPRESSO NOT IN ('C','D')`,
                ` ((PROTOCOLO_NFE IS NOT NULL) AND (PROTOCOLO_NFE <> ''))`,
                ` EMP_ID = ${getCookie('emp_id')}`
              ]
            }
            const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (response && response.length > 0) {
              return true;
            }
            return false;
          } catch (error) {
            console.error(error);
            return false;
          }
        } finally {}
      }

      async function RetornaSeAlgumaMoedaObrigaDocumentoFiscal() {
        try {
          try {
            if ($('#btnFinalizar').html() == 'Deixar Pendente (F8)') return false; //quando a venda ficar pendente não deve validar

            const moedasUtilizadas = $('#tabelaCondicoesDePagamento').DataTable().data().toArray().map(condicao => condicao[6]).toString();
            if (moedasUtilizadas == '') {
              return false;
            }

            const pesquisa = {
              tabela: "MOEDA",
              camposSelect: ["OBRIGA_DOC_FISCAL"],
              where: [`CODMOE IN (${moedasUtilizadas}) AND OBRIGA_DOC_FISCAL = 'S'`]
            }
            const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (response && response.length > 0) {
              return true;
            }
            return false;
          } catch (error) {
            console.error(error);
            return false;
          }
        } finally {}
      }

      async function RotinaAddCondicaoPagamento(bPularValidacaoCreditoCliente = false, passouAntecipacao = false, bPularValidacaoCreditoGrupo = false) {

        if (controleLimiteCredito == '1') {
          const dadosTipo = await BuscaTiposVenda($('#txtTipoVenda').val());
          await carregaLimiteCredito(pegaChave('#txtCliente'));
          if (!await verificaLimiteCredito(dadosTipo[0].CONSIGNADO == 'S')) {
            return;
          }
        } else {
          if (!bPularValidacaoCreditoGrupo) {
            if (await verificaLimiteCreditoGrupo()) {
              return;
            }
          }

          if (!bPularValidacaoCreditoCliente) {
            if (await verificaLimiteCreditoCliente()) {
              return;
            }
          }
        }

        if (!await lancaMoedaConsumidorFinal(adicionarCondicaoPagamento)) {
          return;
        }

        const bDescontaFrete = ((bNaoConsiderarFreteDesconto) && ((parseFloat($("#txtPercDescontoMoeda").val()) > 0) || (parseFloat($("#txtValorDescontoMoeda").val()) > 0)));
        const valFrete = isNaN(parseFloat($('#txtFrete').val())) ? 0 : parseFloat($('#txtFrete').val());
        const valorParcela = bDescontaFrete ? (parseFloat($("#txtValorParcela").val()) - valFrete) : $("#txtValorParcela").val();
        if (!await CalculaDescontoMoeda('txtPercDescontoMoeda', valorParcela, $("#txtPercDescontoMoeda").val(), $("#txtValorDescontoMoeda").val(), $("#txtValorParcela").val(), 1)) {
          return;
        }
        if ((descontoTotalUsuario) && (parseFloat(descontoTotalUsuario) > 0)) {
          await verificaDescontoTotalNaVenda(passouAntecipacao);
          return;
        }

        await adicionarCondicaoPagamento(passouAntecipacao);
      }

      $('#modalTroco').on('shown.bs.modal', function() {
        $('#txtValorPagoTroco').focus();
      });

      $('#modalCashback').on('shown.bs.modal', function() {
        $('#txtValorAUtilizarCashback').focus();
      });

      $('#modalCadPreco').on('shown.bs.modal', function() {
        $('#txtPrecoManual').val('');
        $('#txtPrecoManual').focus();
        $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
      });

      $('#btnConfirmarCashback').on('click', async function() {
        bCashBack = true;
        const valorAUtilizar = +$('#txtValorAUtilizarCashback').val();
        const valorDisponivel = parametrosVenda[72] == '3' ? +((parseFloat($('#txtTotItensSemDesc').val()) / 100) * parseFloat(cashbackCliente.perc_max)).toFixed(2) : +$('#txtValorDisponivelCashback').val();

        if (valorAUtilizar > valorDisponivel) {
          msgAlerta('Valor de cashback informado maior que o disponível para o cliente.', undefined, undefined, () => {
            $('#txtValorAUtilizarCashback').focus();
          });
          return;
        }

        if (valorAUtilizar <= 0) {
          msgAlerta('Valor de cashback informado menor ou igual a 0, impossível continuar.', undefined, undefined, () => {
            $('#txtValorAUtilizarCashback').focus();
          });
          return;
        }

        const valorDesconto = +$('#txtValorDescontoMoeda').val();
        $('#txtValorDescontoMoeda').val(valorAUtilizar + valorDesconto);
        cashbackCliente.valorUtilizado = +valorAUtilizar;
        // cashbackCliente.pontosUtilizados = +pontosAUtilizar;
        cashbackCliente.ordemTabelaPagamento = $("#tabelaCondicoesDePagamento").DataTable().rows().count();
        $('#modalCashback').modal('hide');
        await saidaCampoValorDesconto();
        $('#btnAddCondicao').trigger('click');
      });

      $('#btnAddCondicao').on('click', async function() {
        const moeda = pegaChave("#txtMoeda");
        const condicao = pegaChave("#txtCondicaoDePagamento");
        const nrMaxParcelas = $('#txtMaxNrParcelasMoeda').val();
        const nrParcelas = pegaChave('#txtNrParcelas');
        const percentualDesconto = $("#txtPercDescontoMoeda").val();
        const valorDesconto = $("#txtValorDescontoMoeda").val();
        condicaoPagto = condicao;

        if (moeda == '' || condicao == '') {
          msgAlerta('Necessário informar uma moeda e sua condição de pagamento para prosseguir!');
          return;
        }

        const bCondicaoValida = await validaCondicaoMoeda(moeda, condicao);
        const moedaTipoPresente = await moedaPresente(moeda) == 'S';

        const moedaPresenteJaCadastrada = moedaTipoPresente &&
          $('#tabelaCondicoesDePagamento')
          .DataTable()
          .data()
          .toArray()
          .filter(cond => cond[6] == moeda)
          .length > 0;

        if (moedaPresenteJaCadastrada) {
          msgAlerta('Moeda que utiliza Cartão Presente já utilizada na venda.');
          return;
        }

        if (!bCondicaoValida) {
          return;
        }

        if ((moeda != '') && (moedaTipoPresente)) {
          $('#modalPresente').modal('show');
          if ($('#tabelaPresente tr').length > 0) {
            $('#tabelaPresente').DataTable().clear().draw(false);
          }
          return;
        }

        const totalVenda = parseFloat(($("#txtTotalVenda").html().replaceAll('.', '')).replace(',', '.'));
        if ((bUtilizaCashback) && (cashbackCliente.valor > 0) && (cashbackCliente.valor >= valorMinimoCashback) && (cashbackCliente.valorUtilizado == 0) && (totalVenda >= valorMinimoVendaCashback)) {
          msgAlerta(`Cliente possui cashback disponível, deseja utilizar?`, () => {
            const saldoAPagar = +$('#txtValorLiquidoMoeda').val();
            const valorMaximoASerUsado = saldoAPagar - 0.01;
            const pontosPorValor = ArredondarValor(cashbackCliente.pontos / cashbackCliente.valor, 2);
            const pontosMaximosASeremUsados = valorMaximoASerUsado * pontosPorValor;
            const valorAUtilizar = cashbackCliente.valor < saldoAPagar ? cashbackCliente.valor :
              valorMaximoASerUsado;
            const pontosAUtilizar = cashbackCliente.valor < saldoAPagar ? cashbackCliente.pontos :
              pontosMaximosASeremUsados;
            $('#txtSaldoAPagarCashback').val(saldoAPagar);
            $('#txtValorDisponivelCashback').val(cashbackCliente.valor);
            $('#txtValorAUtilizarCashback').val(valorAUtilizar.toFixed(2));
            $('#txtValorAUtilizarCashback').attr('max', valorAUtilizar.toFixed(2));
            $('#txtSaldoCashback').val((saldoAPagar - valorAUtilizar).toFixed(2));
            if (parametrosVenda[72] == '3') {
              const itensSemDesc = buscaItensSemDescontoPromocao();
              const valorUtilizavel = +((parseFloat(itensSemDesc) / 100) * parseFloat(cashbackCliente.perc_max)).toFixed(2) > cashbackCliente.valor ?
                cashbackCliente.valor :
                +((parseFloat(itensSemDesc) / 100) * parseFloat(cashbackCliente.perc_max)).toFixed(2);
              $('#txtTotItensSemDesc').val(itensSemDesc.toFixed(2));
              $('#lbValorUtilizar').html(`Valor à utilizar <span style="color: #04943e;">${cashbackCliente.perc_max}%</span>`);
              $('#txtValorAUtilizarCashback').val(valorUtilizavel.toFixed(2));
              $('#txtValorAUtilizarCashback').attr('max', valorUtilizavel.toFixed(2));
            }
            $('#modalCashback').modal('show');
          }, () => {
            Rotina();
          });
          return;
        }

        if (bUtilizaCashbackCRMBonus && infoCRMBonus.utilizaSaldo && cashbackCliente.valorUtilizado == 0) {
          const valorPagar = parseFloat($("#txtValorParcela").val());
          const valorCashback = parseFloat($('#txtCashbackCliPagto').val());
          if (valorPagar < valorCashback) {
            throw msgAlerta("O valor do cashback é maior que o valor à pagar! Verifique.");
          } else if (valorPagar == valorCashback) {
            throw msgAlerta("O valor do cashback não pode ser igual ao valor à pagar! Verifique.");
          } else {
            $("#txtValorDescontoMoeda").val(valorCashback);
            cashbackCliente.valorUtilizado = valorCashback;
          }

        }

        async function Rotina() {
          await RotinaAddCondicaoPagamento();

          if (UsuarioPodeGravarCondicoes) {
            let venda = {};
            venda = await montaJsonVenda(venda, numero_venda, 'P', false);
            salvaDadosDigitados(venda);
          }
        }

        if ((+nrMaxParcelas > 0) && (+nrParcelas > +nrMaxParcelas)) {
          await senhaSupervisor(
            `Número de parcelas (${nrParcelas}) maior que o permitido para essa moeda (${nrMaxParcelas}).`,
            Rotina, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
          return;
        }

        const brinde = await buscaValor('MOEDA', 'CONT_ITEM_BRINDE', 'CODMOE', moeda);

        if (brinde == 'S') {
          await senhaSupervisor(
            `Moeda está cadastrada para passar brindes.`,
            Rotina, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0
          );
          return;
        }

        if (validarItensPromocao() && await restricaoCondicaoPagamentoItemPromocioal(moeda, condicao)) {
          await senhaSupervisor("Condição de pagamento informada está bloqueada para vendas com itens promocionais.", Rotina, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'));
          return;
        }

        if (percentualDesconto > 0 && valorDesconto == 0) {
          await saidaCampoPercentualDesconto();
        } else if (valorDesconto > 0 && percentualDesconto == 0) {
          await saidaCampoValorDesconto();
        }

        await Rotina();

      });

      async function restricaoCondicaoPagamentoItemPromocioal(codigoMoeda, codigoCondicao) {

        try {

          const response = await requisicao("GET", '/sisplan/vendas/v1/restricaoitempromocondicaopagamento?', `CODIGO_MOEDA=${codigoMoeda}&CODIGO_CONDICAO=${codigoCondicao}`, null);

          if (!response) {
            throw new Error("Não foi possível validar a restrição da condição de pagamento em itens de promoção.")
          }

          const retorno = await response.text();
          if (response.status != 200) {
            const erro = await response.json();
            throw new Error("Não foi possível validar a restrição da condição de pagamento em itens de promoção.")
          }

          return JSON.parse(retorno);

        } catch (error) {
          console.error(error);
          return false;
        }

      }

      function validarItensPromocao() {
        const itens = $("#tabelaItens").DataTable().data().toArray();

        itensPrecoPromocional = itens.filter(item => item[29] || item[31] != "0");

        return itensPrecoPromocional.length > 0;

      }

      // Eventos com DataTable
      $('#tabelaItens').DataTable().columns.adjust().draw(false);

      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnExcluir', async function() {
        event.preventDefault();
        const bUsaIntegraçãoITAG = parametrosVenda[60] == 1 || parametrosVenda[60] == 2;
        const vendaEmAlteracao = ((numero_venda != 'create') && (numero_venda != 'create#'));
        const bloqueiaExcluirItem = infoTipoVenda[0].EXCLUSAO_ITEM === 2 && vendaEmAlteracao;
        const pedeSenhaSupervisaoExclusaoItem = infoTipoVenda[0].EXCLUSAO_ITEM === 1 && vendaEmAlteracao;

        if (bloqueiaExcluirItem) {
          msgAlerta('Não é possível excluir o item para o tipo de venda: ' + infoTipoVenda[0].DESCRICAO);
          return;
        }

        if (bUsaIntegraçãoITAG) {
          msgAlerta('Empresa com parâmetro EPC ativo, para estornar o item é necessário bipar a barra com o "-" antes da barra.\nExemplo: -9999999999999');
          return;
        }

        if (vendaOriginadaDeUmAgrupamento()) {
          return;
        }

        async function removeItemVenda(object) {
          const itemPosicionado = $('#tabelaItens').DataTable().row($(object).parents('tr')).data();
          // await removeItemListaBarra(); // no momento não sabemos se podemos remover a barralog ou não,
          $('#tabelaItens').DataTable().row($(object).parents('tr')).remove().draw(false);
          if (!$('#btn-desdobrar-malha').hasClass('d-none')) {
            $('#total_rolos_itens').html('Rolos: ' + $('#tabelaItens').DataTable().rows().count());
          }

          const tabela = $(`#tabelaItens`).DataTable().data().toArray();
          tabela.forEach((item, index) => {
            if (item[6] > 0) {
              $(`#tabelaItens tbody>tr:eq(${index}) td:eq(3)`).addClass('textDesconto');
            } else {
              $(`#tabelaItens tbody>tr:eq(${index}) td:eq(3)`).removeClass('textDesconto');
            }
          });

          let venda = {};
          venda = await montaJsonVenda(venda, numero_venda, 'P', false);
          salvaDadosDigitados(venda);
          atualizaTotalVenda();
          removeRegraPromocao();
          await eventoClickBtnRecalcularRegra(true);
          if (bAplicaDescMaxTabPrecoVenda || bAplicaDescMaxTabPrecoVendaNotAlterar) {
            await reaplicaDescMax();
          }
          await validaItensRelacionados()
        }

        if (pedeSenhaSupervisaoExclusaoItem) {
          var props = this;
          await senhaSupervisor('Exclusão de item da venda', removeItemVenda, props, false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
        } else {
          await removeItemVenda(this);
        }
      });

      $('#btn-sair').on('click', async function() {
        event.preventDefault();

        let parametroMfe = parametrosVenda[18];
        var possuiItens = $('#tabelaItens').DataTable().rows().count();
        if (possuiItens > 0) {
          msgConfirmacao(
            `${possuiItens ? `Venda <span style="color:green">${$('#txt_venda_atual>span').html()}</span> possui itens.<br>` : ''} Escolha uma das opções abaixo: `,
            [
              async function() {
                var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                if ((numero_venda != 'create') && (numero_venda != 'create#')) {
                  await deletaRegistro('LOJA', getCookie('usuario'), numero_venda);
                  await rotinaGeraLog('TVENDALOJA', numero_venda, `Abandonado venda ${numero_venda}`, 'Inclusão');
                }
                await salvarHistoricoVenda();
                await deletaVendaNaoSalva(hostname + '.txt');
                const chave = (numero_venda != 'create') && (numero_venda != 'create#') ? numero_venda : 'NOVA';
                await rotinaGeraLog('VENDA', chave, `USUARIO ${getCookie('usuario')} desistiu da venda ${chave}, para o cliente ${pegaChave('#txtCliente')}, no valor de ${$("#subtotal_venda").html()}.`);
                if (parametrosVenda[87] == 1) {
                  await deletaReservaProduto();
                }
                if (!$('body').hasClass('sidebar-mini layout-fixed vsc-initialized iframe-mode-fullscreen')) {
                  parent.$('#abrirTelaCheia').trigger('click');
                }
                parent.removerTelaCheia(true);
                parent.fechaAbaVendaDevolucao('Venda', numero_venda);
                if (!$('body').hasClass('sidebar-mini layout-fixed vsc-initialized iframe-mode-fullscreen')) {
                  parent.$('#abrirTelaCheia').trigger('click');
                }
                window.location.href = "<?php echo BASE_URI; ?>/loja";
              }, async function() {
                $('#btnFinalizar').html(await traduzSentenca('Deixar Pendente (F8)'));
                $('#btnFinalizar').attr('data-original', 'Deixar Pendente (F8)');
                const rotina = async () => {
                  const finalizouVenda = await RotinaFinalizarVenda(false, false, true);
                  if (finalizouVenda) {
                    var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
                    await deletaVendaNaoSalva(hostname + '.txt');
                    if (parametrosVenda[87] == 1) {
                      await deletaReservaProduto();
                    }
                    window.parent.$('#abrirTelaCheia').trigger('click');
                    parent.fechaAbaVendaDevolucao('Venda', numero_venda);
                    if (!$('body').hasClass('sidebar-mini layout-fixed vsc-initialized iframe-mode-fullscreen')) {
                      parent.$('#abrirTelaCheia').trigger('click');
                    }
                    window.location.href = "<?php echo BASE_URI; ?>/loja";
                  }
                }

                const numlinhas = $('#tabelaCondicoesDePagamento').DataTable().rows()[0].length;
                const dadosTipo = await BuscaTiposVenda($('#txtTipoVenda').val());
                const bloqueiaVendaPendente = dadosTipo[0].VENDA_PENDENTE == 2;
                const permiteVendaPendenteSenhaSupervisor = dadosTipo[0].VENDA_PENDENTE == 1;

                if ((bloqueiaVendaPendente) && (numlinhas == 0)) {
                  msgAlerta('Tipo de venda não permite deixar venda pendente. ');
                  return;
                } else if ((controleLimiteCredito == '1') && (dadosTipo[0].CONSIGNADO == 'S')) {
                  await carregaLimiteCredito(pegaChave('#txtCliente'));
                  if (!await verificaLimiteCredito(true, true)) {
                    return;
                  }
                } else if ((permiteVendaPendenteSenhaSupervisor) && (numlinhas == 0)) {
                  await senhaSupervisor(
                    `Tipo de venda não permite deixar venda pendente.`,
                    rotina, '', false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
                  return;
                }
                rotina();
              }
            ]);
        } else {
          msgAlerta(
            `${possuiItens ? `Venda <span style="color:green">${$('#txt_venda_atual>span').html()}</span> possui itens.<b> Caso confirmar você irá perder a venda. </b> ` : ''} Deseja realmente cancelar?`,
            async function() {
              const seletor = BASE_URI == '' ? `#tab-${BASE_URI.substring(1)}-loja` : `#tab--${BASE_URI.substring(1)}-loja`;
              if (parent.$(seletor).length == 0) {
                const link = `${BASE_URI}/loja`
                parent.$('.content-wrapper').IFrame('createTab', 'Loja Principal', `${BASE_URI}/loja`, '-' + link.substr(1).replaceAll('/', '-'), false);
              }
              var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
              if ((numero_venda != 'create') && (numero_venda != 'create#')) {
                await deletaRegistro('LOJA', getCookie('usuario'), numero_venda);
              }
              await deletaVendaNaoSalva(hostname + '.txt');
              if (parametrosVenda[87] == 1) {
                await deletaReservaProduto();
              }
              const chave = (numero_venda != 'create') && (numero_venda != 'create#') ? numero_venda : 'NOVA';
              await rotinaGeraLog('VENDA', chave, `USUARIO ${getCookie('usuario')} desistiu da venda ${chave}, para o cliente ${pegaChave('#txtCliente')}, no valor de ${$("#subtotal_venda").html()}.`);
              parent.removerTelaCheia(true);
              if (!$('.navbar-toggler').hasClass('collapsed')) {
                parent.$('#abrirTelaCheia').trigger('click');
              }
              parent.fechaAbaVendaDevolucao('Venda', numero_venda);
              if (!$('body').hasClass('sidebar-mini layout-fixed vsc-initialized iframe-mode-fullscreen')) {
                parent.$('#abrirTelaCheia').trigger('click');
              }

              // window.location.href = "<?php echo BASE_URI; ?>/loja";
            });
        }
        if ((parametroMfe == '2') || (parametroMfe == '4')) {
          $('#btn-cfm-pendente').addClass('d-none');
        } else {
          $('#btn-cfm-pendente').removeClass('d-none');
        }

      });

      async function criaTabelaProdutosRelacionados(data) {

        if ($.fn.DataTable.isDataTable("#tabelaProdutosRelacionados")) {
          $('#tabelaProdutosRelacionados').DataTable().destroy();
          $('#tabelaProdutosRelacionados').empty();
        }

        let objetoTabela = {
          paging: true,
          filter: true,
          info: true,
          order: true,
          autoWidth: true,
          destroy: true,

        }
        const dataSetCols = []
        if ((data) && (data.length > 0)) {
          let keys = Object.keys(data[0]);
          for (let k in keys) {
            dataSetCols.push({
              title: keys[k],
              data: keys[k],
            });
          }
          objetoTabela = {
            ...objetoTabela,
            data: data,
            columns: dataSetCols,
            createdRow: function(row, data, dataIndex) {
              const descricaoValue = data.DESCRICAO;
              $(row).find('td:eq(1)').attr('title', descricaoValue);
            },
            columnDefs: [{
                "targets": [7, 8],
                "className": 'pr-4 text-right'
              },
              {
                targets: [6, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                visible: false
              },
              {
                targets: [3],
                render: function(data, type, row, meta) {
                  const codigo = row[0];
                  const tipo = row[15];
                  if (false) {
                    buscaFotoProduto(codigo, tipo, imageCache);
                  }
                  const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + tipo);
                  return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="30" width="30"/>`
                }
              },
              {
                targets: [10],
                render: function(data, type, row, meta) {
                  return '<div class="d-flex align-items-center justify-content-center">' +
                    `<i class="m-0 p-0 fas fa-minus subtraiQtdePesquisaItens" style="margin-right: 12px !important" id="subtraiQtdePesquisaItens${meta.row}"></i>` +
                    `<input type="number" id="qtdeAdicionar${meta.row}` +
                    `" class="input-default focus form-control validate inputQtdeAdicionar mr-2" style="width: 50px" value="${data}"> ` +
                    `<i class="m-0 p-0 fas fa-plus adicionaQtdePesquisaItens" id="adicionaQtdePesquisaItens${meta.row}"></i>` +
                    '</div>';
                }
              }
            ]
          }
        } else {
          msgAlerta('Não foi encontrado nenhum item no depósito informado!');
          return;
        }

        $('#tabelaProdutosRelacionados').DataTable(objetoTabela)

        $('#tabelaProdutosRelacionados_wrapper .row div:eq(0)').css('display', 'flex');
        $('#tabelaProdutosRelacionados_wrapper .row div:eq(0)').css('align-items', 'flex-end');
        $('#tabelaProdutosRelacionados thead tr:eq(1)').html('');
        $('#tabelaProdutosRelacionados thead th').each(function(i) {
          listaCamposPesquisaColuna = [0, 1, 2, 3, 4, 5];
          listaWidths = [5, 15, 5, 7, 7, 7];
          if (listaCamposPesquisaColuna.includes($(this).index())) {
            const posicaoEncontrada = listaCamposPesquisaColuna.indexOf($(this).index());
            const title = $('#tabelaProdutosRelacionados thead tr:eq(2) th').eq($(this).index()).text();
            $('#tabelaProdutosRelacionados thead tr:eq(1)').append('<th><input placeholder="' + title + '" style="min-width: ' + listaWidths[posicaoEncontrada] + 'rem" class="form-control form-control-sm" type="text" data-index="' + i + '" /></th>');
          } else {
            $('#tabelaProdutosRelacionados thead tr:eq(1)').append('<th></th>');
          }
          $('#tabelaProdutosRelacionados thead tr:eq(1)').addClass('d-none');
        });
        $('#tabelaProdutosRelacionados thead tr:eq(1) th').css('border', 'none');

        $('#tabelaProdutosRelacionados thead input').on('keyup', function() {
          $('#tabelaProdutosRelacionados').DataTable()
            .column($(this).data('index'))
            .search(this.value.toUpperCase())
            .draw();
        });

        $('#tabelaProdutosRelacionados tbody').on('click', 'tr', function(e) {
          const target = e.target;
          const qtdeEstoque = parseFloat($("#tabelaProdutosRelacionados").DataTable().rows($(this).closest('tr')).data().toArray()[0].QTDE_EST);
          const data = $("#tabelaProdutosRelacionados").DataTable().row($(this).closest("tr")).data()
          const indexRow = $("#tabelaProdutosRelacionados").DataTable().row($(this)).index();
          if ($(target).is(".adicionaQtdePesquisaItens") || $(target).is(".subtraiQtdePesquisaItens") || $(target).is(".inputQtdeAdicionar")) {
            return;
          }
          if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            $(`#qtdeAdicionar${indexRow}`).val(1);
            $(`#subtraiQtdePesquisaItens${indexRow}`).trigger("click");
            $(`#qtdeAdicionar${indexRow}`).val(data.QUANTIDADE);
          } else {
            if (data.QUANTIDADE == $(`#qtdeAdicionar${indexRow}`).val()) {
              $(`#qtdeAdicionar${indexRow}`).val(data.QUANTIDADE - 1);
              $(`#adicionaQtdePesquisaItens${indexRow}`).trigger("click");
            } else {
              $(`#adicionaQtdePesquisaItens${indexRow}`).trigger("click");
            }
          }
        });

        // duplo click faz escolher o registro e fechar a pesquisa
        $('#tabelaProdutosRelacionados tbody').on('dblclick', 'tr', function(e) {
          const target = e.target;
          if ($(target).is(".adicionaQtdePesquisaItens") || $(target).is(".subtraiQtdePesquisaItens") || $(target).is(".inputQtdeAdicionar")) {
            return;
          }
          // event.preventDefault();
          document.firstElementChild.style.zoom = "reset";
          $("#tabelaProdutosRelacionados").DataTable().$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
          $("#btn_confirmar_produto").click();
        });

        $('#tabelaProdutosRelacionados').off('click', '.adicionaQtdePesquisaItens');
        $("#tabelaProdutosRelacionados").on("click", ".adicionaQtdePesquisaItens", function() {
          const paramEstoque = parametrosVenda[4];
          const qtdeAtual = parseFloat($(this).siblings(".inputQtdeAdicionar").val());
          const qtdeEstoque = $("#tabelaProdutosRelacionados").DataTable().rows($(this).closest("tr")).data().toArray()[0].QTDE_EST;
          const data = $("#tabelaProdutosRelacionados").DataTable().rows($(this).closest("tr")).data().toArray()[0];
          const qtdeAtualizada = qtdeAtual + 1;
          const bTipoVendaMovimentaEstoque = $("#vendaMovimentaEstoque").prop("checked");
          if (!bTipoVendaMovimentaEstoque || paramEstoque != "0" || qtdeAtualizada <= qtdeEstoque) {
            const item = [
              data.CODIGO,
              data.DESCRICAO,
              data.FOTO,
              data.COR,
              data.DESC_COR,
              data.UNIDADE,
              data.TAM,
              data.PRECO,
              data.QTDE_EST,
              qtdeAtualizada,
              data.BARRA,
              data.CODIGO2,
              data.ID,
              data.QUALIDADE,
              data.LOTE,
              data.TIPO,
              data.DESC_ECOMMERCE,
              data.DESCRICAO2,
              data.REFERENCIA,
              data.GRUPO,
              data.COLECAO,
            ]
            $(this).siblings(".inputQtdeAdicionar").val(qtdeAtualizada);
            adicionaListaPesquisaItens(item, qtdeAtualizada);
            $($(this).closest("tr")).addClass("selected");
            if (bTipoVendaMovimentaEstoque && paramEstoque == "1" && qtdeAtualizada > qtdeEstoque) {
              msgAlerta("Quantidade maior que a disponível no estoque.");
            }
          } else {
            msgAlerta("Não é possível selecionar uma quantidade superior à disponível no estoque.");
          }
        })

        $('#tabelaProdutosRelacionados').off('click', '.subtraiQtdePesquisaItens');
        $("#tabelaProdutosRelacionados").on("click", ".subtraiQtdePesquisaItens", function() {
          const qtdeAtual = $(this).siblings(".inputQtdeAdicionar").val();
          const data = $("#tabelaProdutosRelacionados").DataTable().rows($(this).closest("tr")).data().toArray()[0];

          if (qtdeAtual > 0) {
            const qtdeAtualizada = (qtdeAtual - 1) < 0 ? 0 : (qtdeAtual - 1);

            $(this).siblings(".inputQtdeAdicionar").val(qtdeAtualizada);
            const itemArray = [
              data.CODIGO,
              data.DESCRICAO,
              data.FOTO,
              data.COR,
              data.DESC_COR,
              data.UNIDADE,
              data.TAM,
              data.PRECO,
              data.QTDE_EST,
              qtdeAtualizada,
              data.BARRA,
              data.CODIGO2,
              data.ID,
              data.QUALIDADE,
              data.LOTE,
              data.TIPO,
              data.DESC_ECOMMERCE,
              data.DESCRICAO2,
              data.REFERENCIA,
              data.GRUPO,
              data.COLECAO,
            ]

            adicionaListaPesquisaItens(itemArray, qtdeAtualizada);
            if (qtdeAtualizada == 0) {
              $($(this).closest("tr")).removeClass("selected");
            }
          }
        })


        $('#modalProdutosRelacionados').modal('show');
      }

      async function criaTelaProdutosRelacionados(data) {
        try {
          $.LoadingOverlay('show');
          const codigo = data[0]
          const cor = data[10]
          const faixaTam = data[11]
          const deposito = data[33]
          const regiao = data[34]
          $('#txtProdutoRelacionadoVenda').val(data[1])
          const url = '/sisplan/produto/v1/retorna_filho_venda?';
          const response = await requisicao('GET', url, `CODIGO=${codigo}&COR=${cor}&TAM=${faixaTam}&REGIAO=${regiao}&DEPOSITO=${deposito}`, '', 30000);

          if (!response) {
            return;
          };

          if (response.status != 200) {
            await criaTabelaProdutosRelacionados();
            return;
          }

          const jsonStr = await response.json();

          if (!jsonStr) {
            await criaTabelaProdutosRelacionados();
            return;
          }

          await criaTabelaProdutosRelacionados(jsonStr)

        } finally {
          $.LoadingOverlay('hide');
        }
      }


      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnInfoAdc', async function() {
        event.preventDefault();
        const index = $('#tabelaItens').DataTable().row(this.closest('tr')).index();
        const tipoItem = $("#tabelaItens").DataTable().row(index).data()[19];

        if (tipoItem == 'M') {
          await criaTelaInfoAdcMaterial(index);
        } else {
          await criaTelaInfoAdc(index);
        }
      });

      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnProdutosRelacionados', async function() {
        event.preventDefault();
        await criaTelaProdutosRelacionados($('#tabelaItens').DataTable().row(this.closest('tr')).data());
      });

      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnDesconto', async function() {
        event.preventDefault();
        if (vendaOriginadaDeUmAgrupamento()) {
          return;
        }
        const bTipoMaterial = parametrosVenda[17] != '0';
        const id = $('#tabelaItens').DataTable().row(this.closest('tr')).index();
        await criaTelaDesconto(id, true, bTipoMaterial);
      });

      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnQuantidade', async function() {
        event.preventDefault();
        if (vendaOriginadaDeUmAgrupamento()) {
          return;
        }
        const id = $('#tabelaItens').DataTable().row(this.closest('tr')).index();
        const arrDados = $("#tabelaItens").DataTable().row(id).data();
        const bloqueiaVendaLoteFracionado = await VerificaSeDepositoBloqueiaLoteFracionado(arrDados[33]);
        if (bloqueiaVendaLoteFracionado) {
          msgAlerta(`Depósito ${arrDados[33]} não permite lote fracionado, verifique.`);
          $(this).val(0);
          return;
        }
        if (parametrosVenda[46] != '3') {
          await criaTelaQuantidade(id);
        } else {
          msgAlerta('Empresa trabalha com barra única, não é possível alterar a quantidade.');
          return;
        }
      });

      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnAlterarPreco', async function() {
        event.preventDefault();
        if (vendaOriginadaDeUmAgrupamento()) {
          return;
        }
        await criaTelaAlterarPreco($('#tabelaItens').DataTable().row(this.closest('tr')).index());
      });

      $('#tabelaItens tbody').on('click', 'td>div>div>div a.btnObservacaoItem', async function() {
        event.preventDefault();
        await criaTelaObservacaoItem($('#tabelaItens').DataTable().row(this.closest('tr')).index());
      });

      $('#tabelaItens tbody').on('dblclick', 'tr', async function() {
        event.preventDefault();
        if (bAplicaDescMaxTabPrecoVendaNotAlterar) {
          return;
        }
        if (vendaOriginadaDeUmAgrupamento()) {
          return;
        }
        await criaTelaDesconto($('#tabelaItens').DataTable().row(this.closest('tr')).index());
      });

      $('#btnConfirmarRelacionamento').on('click', async function() {
        const itens = $('#tabelaProdutosRelacionados').DataTable().rows(".selected").data().toArray();
        const qtdeAtual = parseFloat($(this).siblings(".inputQtdeAdicionar").val());

        const item = itens.map((it) => {
          return [
            it.CODIGO,
            it.DESCRICAO,
            it.FOTO,
            it.COR,
            it.DESC_COR,
            it.UNIDADE,
            it.TAM,
            it.PRECO,
            it.QTDE_EST,
            qtdeAtual == 0 ? it.QUANTIDADE : qtdeAtual,
            it.BARRA,
            it.CODIGO2,
            it.ID,
            it.QUALIDADE,
            it.LOTE,
            it.TIPO,
            it.DESC_ECOMMERCE,
            it.DESCRICAO2,
            it.REFERENCIA,
            it.GRUPO,
            it.COLECAO,
          ]

        })
        adicionaListaPesquisaItens(item, qtdeAtual);
        $("#btn_confirmar_produto").click();

        $('#tabelaProdutosRelacionados').DataTable().$('tr.selected').removeClass('selected')
      })

      $('#txtCondicaoDePagamento').on('blur', async function() {
        console.log('passou')
        // const validaCond = await validaCondPagto(pegaChave('#txtCondicaoDePagamento'));
        // if (!validaCond) {
        //   return;
        // }
        // $('#txtValorParcela').trigger('change');
        // if (!$('.bandeira').hasClass('d-none')) {
        //   $('#select_bandeira').select2('open');
        // }
      });

      $('#tabelaCondicoesDePagamento tbody').on('click', 'td>div>div>div a.btnExcluir', async function() {
        event.preventDefault();
        $('#txtBaixaAntecipacao').val('');
        var data_old = tabelaCondicoes.row($(this).parents('tr')).data();
        const bParametroSelecionaAntecipacao = parametrosVenda[49] == 1 | parametrosVenda[49] == 2 ?? false;
        var sCodCli = pegaChave('#txtCliente', sCodCli);
        var ordem = data_old[0];
        let venda = {};
        if (!$.isEmptyObject(data_old[9])) {
          carregaAntecipacoes(sCodCli, data_old);
        }
        tabelaCondicoes.row($(this).parents('tr')).remove().draw(false);
        tabelaParcelasGeradas.rows(function(idx, data, node) {
          return data[0] === ordem;
        }).remove().draw(false);

        if (((bUtilizaCashback) && (cashbackCliente.ordemTabelaPagamento == ordem)) || (bUtilizaCashbackCRMBonus && ordem == 0)) {
          cashbackCliente.valorUtilizado = 0;
          cashbackCliente.pontosUtilizados = 0;
          cashbackCliente.ordemTabelaPagamento = -1;
        }

        if (parametrosVenda[58] == "4") {
          const moedaBaixaAntecipacao = await buscaValor('MOEDA', 'BAIXA_ANTE', 'CODMOE', data_old[6])
          if (moedaBaixaAntecipacao == 'S') {
            removeDescontoItens();
            const totalLiquido = parseFloat($("#tabelaItens").DataTable().column(7, {}).data().sum());
            $("#subtotal_venda").html(
              parseFloat(totalLiquido).toLocaleString("pt-BR", {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
                currency: "BRL",
              })
            );
          }
        } else {
          const moedaBaixaAntecipacao = await buscaValor('MOEDA', 'BAIXA_ANTE', 'CODMOE', data_old[6]);
          insereValor('#txtBaixaAntecipacao', moedaBaixaAntecipacao, moedaBaixaAntecipacao);
        }

        venda = await montaJsonVenda(venda, numero_venda, 'P', false);
        salvaDadosDigitados(venda);
        atualizaSaldoAPagar();
        atualizaTotaisPagto();

        if ($('#tabelaCondicoesDePagamento').DataTable().rows().count() == 0) {
          $('#btnFinalizar').html(await traduzSentenca('Deixar Pendente (F8)'));
          $('#btnFinalizar').attr('data-original', 'Deixar Pendente (F8)');
          // habilitar novamente os campos de acrescimo
          $('#txtPercAcrescMoeda').prop('disabled', false);
          $('#txtValorAcrescMoeda').prop('disabled', false);
        }
      });

      $('#tabelaCondicoesDePagamento tbody').on('click', 'td>div>div>div a.btn-alterar-parcelas', async function() {
        event.preventDefault();
        //tabelaCondicoes.$('tr.selected').removeClass('selected');
        $(this).closest('tr').addClass('selected');
        const recNo = this.closest('tr').rowIndex - 1;
        const nr_parcelas = $('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[8];
        const valor = $('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[3];
        const valor_pago = $('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[4];
        const codigoMoeda = $('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[6];
        const codcondpagto = $('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[7];

        if ($('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[6] == 1) {
          sTipo = 'cheque';
        } else {
          sTipo = 'crediario';
        }
        const ordem = $('#tabelaCondicoesDePagamento').DataTable().row(recNo).data()[0];
        const sCNPJ = $('#txtCNPJ').val()
        const sNome = pegaDescricao('#txtCliente');
        async function callBack() {
          await MontaTabelaParcelas(sTipo, sNome, sCNPJ, nr_parcelas, valor, valor_pago, codcondpagto, 'alteracao', true, ordem, codigoMoeda);
        }
        if (await moedaContemValorMinimo(codcondpagto)) {
          const codVen = $('#txt_venda_atual>span').html();
          await senhaSupervisor('Moeda configurada com valor mínimo.', async () => {
            await callBack();
            await rotinaGeraLog('VENDA', codVen, `INFORMADO SENHA SUPERVISOR PARA ALTERAR CONDIÇÃO DE PAGAMENTO DE MOEDA CONFIGURADA COM VALOR MÍNIMO. VENDA ${codVen}, CLIENTE ${pegaChave('#txtCliente')}`, 'Alteração');
          }, '', false, undefined, undefined, undefined, false, 'VENDA', codVen, pegaChave('#txtCliente'));
          return;
        }
        await callBack();
      });

      $('#btn-codigo').on('click', function() {
        const prioridadeProdutoMaterial = parametrosVenda[17] ?? '0';
        if (prioridadeProdutoMaterial == 1) {
          $('#cbMaterialContemEstoque').attr('checked', true);
          $('#modalMaterial').modal('show');
          setTimeout(() => {
            $('#tabelaMaterial').DataTable().columns.adjust().draw(false);
          }, 500);
        } else {
          $('#modalProduto').modal("show");
          setTimeout(() => {
            $("#tabelaProdutoMaterial").DataTable().columns.adjust().draw(false);
          }, 1000);
          if (!$('#tabelaProdutoMaterial thead tr:eq(1)').hasClass('d-none')) {
            $('#filtrosAdicionaisTabela').trigger('click');
          }
          $('#txtProdutoCodigo').val('');
          $('#txtItensDescricao').val('');
        }


      });

      $('#btn-codigo-brinde').on('click', function() {
        const prioridadeProdutoMaterial = parametrosVenda[17] ?? '0';
        if (prioridadeProdutoMaterial == 1) {
          $('#cbMaterialContemEstoque').attr('checked', true);
          $('#modalMaterial').modal('show');
        } else {
          $('#modalProduto').modal("show");
          if (!$('#tabelaProdutoMaterial thead tr:eq(1)').hasClass('d-none')) {
            $('#filtrosAdicionaisTabela').trigger('click');
          }
          $('#txtProdutoCodigo').val('');
          $('#txtItensDescricao').val('');
        }
      });

      $('#modalProduto').on('shown.bs.modal', async function() {
        $('#txtCampoConsulta').focus();
      });

      $('#txtProdutoCodigo').on('change', async function() {
        if ($('#txtProdutoCodigo').val().length > 2) {
          $('#btnConsultarItens').trigger('click');
        }
      });

      $('#textDescricaoVenda').on('keydown', function(e) {
        if ([13, 9].includes(e.keyCode)) {
          e.preventDefault();
          $('#btnVenda').trigger('click');
        }
      });

      $('#modalPresente').on('shown.bs.modal', async function() {
        const saldo_a_pagar = +$('#txtValorLiquidoMoeda').val();
        $('#txtValorVendaCartaoPresente').val(saldo_a_pagar.toFixed(2));
        $('#txtValorAPagarCartaoPresente').val(saldo_a_pagar.toFixed(2));
        $('#txtValorCartaoPresente').val(0);
        await atualizaSaldoCartaoPresente();
        $('#txtNumeroCartao').trigger('click');
        $('#txtNumeroCartao').focus();
      });

      $('#modalImportarVendas').on('shown.bs.modal', function() {
        $('#txtVenda').focus();
      });

      $('#modalImportarVendas').on('hide.bs.modal', function() {
        $('#txtVenda').val('');
        importaPedido = false;
      });

      $('#modalPrecos').on('shown.bs.modal', async function() {
        if (!$('#txtDepositoProd').val().toString() && $('#txtDeposito').val()) {
          const deposito = []
          deposito.push({
            CODIGO: pegaChave('#txtDeposito'),
            DESCRICAO: pegaDescricao('#txtDeposito')
          })
          await insereValorPesquisaVarios('txtDepositoProd', 'CODIGO', 'DESCRICAO', deposito);
        }
        $('#txtBarra').focus();
      });

      $('#pesquisaDesconto').on('hide.bs.modal', async function() {
        let venda = {};
        venda = await montaJsonVenda(venda, numero_venda, 'P', false);
        salvaDadosDigitados(venda);
      });
      
      $('#modalDescontoTotal').on('shown.bs.modal', function () {
        $("#cbSemDescontoItensPromocionais").prop("checked", bSemDescontoItensPromocionais);
      });

      $('#modalDescontoTotal').on('hide.bs.modal', async function() {
        let venda = {};
        venda = await montaJsonVenda(venda, numero_venda, 'P', false);
        salvaDadosDigitados(venda);
      });

      $('#txtItensDescricao').on('focusout', function() {
        $('#btnConsultarItens').focus();
      });

      $('#btnConsultarItens').on('keypress', function() {
        $('#btnConsultarItens').trigger('click');
      });

      $('#modalProduto').on('hidden.bs.modal', async function() {
        $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
        await RotinaSaidaCodigo();
      });

      async function focaCampo2() {
        $('#txtCampoConsulta').focus();
      }

      selectPadrao()

      function selectPadrao() {
        $('#select2-selectFiltros-container').text(localStorage.getItem("@venda.selectFiltros") ?? 'CODIGO')
        $('#selectFiltros').val(localStorage.getItem("@venda.selectFiltros") ?? 'CODIGO')
      }

      function retornaWhere(campo, valor) {
        const tipoConsulta = localStorage.getItem("@venda.rgPesquisaTipo") ?? '1';

        const valorSeparado = valor.split(' ');
        const efetuaConsulta = {
          '0': () => {
            return `${campo} LIKE ('${valor}[PERCENTUAL]')`;
          },
          '1': () => {
            return '(' + valorSeparado.map((valor, i) => {
              return `${campo} LIKE ('[PERCENTUAL]${valorSeparado[i]}[PERCENTUAL]')`
            }).toString().replaceAll(',', ' AND ') + ')';
          },
          '2': () => {
            return `${campo} LIKE ('[PERCENTUAL]${valor}[PERCENTUAL]') `
          },
          '3': () => {
            return `${campo} = ('${valor}') `
          }
        }
        return efetuaConsulta[tipoConsulta]();
      }

      $("#btnConsultarItens").on("click", async function() {
        await consultaItensVenda();
      });

      async function consultaItensVenda() {
        const sDeposito = pegaChave('#txtDeposito');
        const sTabela = pegaChave('#txtTabela');
        const sFiltros = $('#txtCampoConsulta').val();
        try {
          try {
            $.LoadingOverlay("show");
            bConsultandoProduto = true;
            const CampoConsulta = $("#txtCampoConsulta").val();
            const TabelaDePreco = pegaChave("#txtTabela");
            const CampoDeposito = isChecked('#cbDepositoEcommerce') ? sDepositoEcommerce.substring(1, sDepositoEcommerce.indexOf("]")) : pegaChave('#txtDeposito');
            const bUsaPrecoCorTam = parametrosVenda[5] == 1;
            const bDescontaPedReserva = parametrosVenda[87] == 1;
            const tabelaEstoque = `"pa_iten"`;
            let ligacaoTabelaPreco = "";
            let ligacaoGrupoMat = "";
            let reserva = '';
            let Alias = "";
            const colunaOrdenacao = $("#tabelaProdutoMaterial").prop("colunaOrdenacao") ?? "";

            if (bUsaPrecoCorTam) {
              ligacaoTabelaPreco = ` {"tabela": "preco_cor_tam", "condicao": "preco_cor_tam.codigo = pa_iten.codigo and preco_cor_tam.cor = pa_iten.cor and preco_cor_tam.tam = pa_iten.tam and preco_cor_tam.regiao = '${TabelaDePreco}'"}`
              Alias = "preco_cor_tam";
            } else {
              ligacaoTabelaPreco = ` {"tabela": "tabpreco", "condicao": "tabpreco.codigo = pa_iten.codigo and tabpreco.regiao = '${TabelaDePreco}'"}`
              Alias = "tabpreco";
            }

            if (bDescontaPedReserva) {
              reserva = `, "(SELECT SUM(PED_RESERVA.QTDE) FROM [PED_RESERVA] PED_RESERVA WHERE PED_RESERVA.CODIGO = PA_ITEN.CODIGO AND PED_RESERVA.COR = PA_ITEN.COR AND PED_RESERVA.TAM = PA_ITEN.TAM AND PED_RESERVA.DEPOSITO = PA_ITEN.DEPOSITO AND PED_RESERVA.QUAL = PA_ITEN.TIPO AND PED_RESERVA.QTDE > 0) QTDE_RESERVA", ` +
                `"(PA_ITEN.QUANTIDADE - (SELECT SUM(PED_RESERVA.QTDE) FROM [PED_RESERVA] PED_RESERVA WHERE PED_RESERVA.CODIGO = PA_ITEN.CODIGO AND PED_RESERVA.COR = PA_ITEN.COR AND PED_RESERVA.TAM = PA_ITEN.TAM AND PED_RESERVA.DEPOSITO = PA_ITEN.DEPOSITO AND PED_RESERVA.QUAL = PA_ITEN.TIPO AND PED_RESERVA.QTDE > 0)) SALDO" `
            }

            let camposSelect = `["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.IMAGEM4 FOTO", "PA_ITEN.COR", ` +
              ` "CADCOR.DESCRICAO DESC_COR", "PRODUTO.UNI_VENDA UNIDADE", "PA_ITEN.TAM", "${Alias}${bUsaPrecoCorTam ? '.PRECO' : `.PRECO_${pegaValor('#rgPrazo')}`} PRECO", "PA_ITEN.QUANTIDADE QTDE_EST", "'' AS QUANTIDADE", ` +
              ` "CASE WHEN PA_ITEN.BARRA <> '' THEN PA_ITEN.BARRA WHEN PA_ITEN.BARRA28 <> '' THEN PA_ITEN.BARRA28 ELSE PA_ITEN.BARRACLI END BARRA", ` +
              ` "PRODUTO.CODIGO2", "PA_ITEN.ID", "PA_ITEN.TIPO QUALIDADE", "PA_ITEN.LOTE", "'P' TIPO", "CADCOR.DESC_ECOMMERCE", "PRODUTO.DESCRICAO2", "PRODUTO.REFERENCIA", ` +
              ` "PRODUTO.GRUPO", "PRODUTO.COLECAO" ${reserva}]`;

            // camposSelect = retornaNovosCamposSelectOrdenacaoUsuario(JSON.parse(camposSelect));

            const camposWhereServerSide = `["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PRODUTO.CODIGO2"]`;
            const LigacaoProdutoMaterial = '{"tabela": "produto","condicao": "produto.codigo = pa_iten.codigo"}';
            const ligacaoTabelaCor = '{"tabela": "cadcor", "condicao": "cadcor.cor = pa_iten.cor"}';
            let Where = `pa_iten.deposito = '${CampoDeposito}'`;
            let orderby;

            if (campoQualidadeVisivel && pegaChave(('#txtQualidade')) != '') {
              Where += ` AND ${retornaWhere("PA_ITEN.TIPO", pegaChave(('#txtQualidade')))}`;
            }

            if (CampoConsulta != "") {
              switch ($('#selectFiltros').val()) {
                case 'CODIGO':
                  Where += ` AND ${retornaWhere("PA_ITEN.CODIGO", CampoConsulta)}`;
                  orderby = "PA_ITEN.CODIGO";
                  break;
                case 'CODIGO2':
                  Where += ` AND ${retornaWhere("PRODUTO.CODIGO2", CampoConsulta.toUpperCase())}`;
                  orderby = "PRODUTO.CODIGO2";
                  break;
                case 'DESCRICAO':
                  Where += ` AND ${retornaWhere("UPPER(PRODUTO.DESCRICAO)", CampoConsulta.toUpperCase())}`;
                  orderby = "PRODUTO.DESCRICAO";
                  break;
                case 'DESC_COR':
                  Where += ` AND ${retornaWhere("CADCOR.DESCRICAO", CampoConsulta)}`;
                  orderby = "CADCOR.DESCRICAO";
                  break;
                case 'COR':
                  Where += ` AND ${retornaWhere("PA_ITEN.COR", CampoConsulta)}`;
                  orderby = "PA_ITEN.COR";
                  break;
                case 'TAM':
                  Where += ` AND ${retornaWhere("PA_ITEN.TAM", CampoConsulta)}`;
                  orderby = "PA_ITEN.TAM";
                  break;
                case 'GRUPO':
                  Where += ` AND ${retornaWhere("PRODUTO.GRUPO", CampoConsulta)}`;
                  orderby = "PRODUTO.GRUPO";
                  break;
                case 'COLECAO':
                  Where += ` AND ${retornaWhere("PRODUTO.COLECAO", CampoConsulta)}`;
                  orderby = "PRODUTO.COLECAO";
                  break;
                case 'BARRA':
                  Where += ` AND (PA_ITEN.BARRA = '${CampoConsulta}' OR PA_ITEN.BARRA28 = '${CampoConsulta}' OR PA_ITEN.BARRACLI = '${CampoConsulta}')`;
                  orderby = "PA_ITEN.BARRA";
                  break;
                case 'DESC_ECOMMERCE':
                  Where += ` AND ${retornaWhere("CADCOR.DESC_ECOMMERCE", CampoConsulta)}`;
                  orderby = "CADCOR.DESC_ECOMMERCE";
                  break;
                case 'LOTE':
                  Where += ` AND ${retornaWhere("PA_ITEN.LOTE", CampoConsulta)}`;
                  orderby = "PA_ITEN.LOTE";
                  break;
                case 'DESCRICAO2':
                  Where += ` AND ${retornaWhere("PRODUTO.DESCRICAO2", CampoConsulta)}`;
                  orderby = "PRODUTO.DESCRICAO2";
                  break;
                case 'REFERENCIA':
                  Where += ` AND ${retornaWhere("PRODUTO.REFERENCIA", CampoConsulta)}`;
                  orderby = "PRODUTO.REFERENCIA";
                  break;
                case 'BARRA28':
                  Where += ` AND ${retornaWhere("PA_ITEN.BARRA28", CampoConsulta)}`;
                  orderby = "PA_ITEN.BARRA28";
                  break;
                case 'LINHA':
                  Where += ` AND ${retornaWhere("PRODUTO.LINHA", CampoConsulta)}`;
                  orderby = "PRODUTO.LINHA";
                  break;
                case 'ETIQUETA':
                  Where += ` AND ${retornaWhere("PRODUTO.ETIQUETA", CampoConsulta)}`;
                  orderby = "PRODUTO.ETIQUETA";
                  break;
                case 'MARCA':
                  Where += ` AND ${retornaWhere("PRODUTO.MARCA", CampoConsulta)}`;
                  orderby = "PRODUTO.MARCA";
                  break;
                case 'COR':
                  Where += ` AND ${retornaWhere("PA_ITEN.COR", CampoConsulta)}`;
                  orderby = "PA_ITEN.COR";
                  break;
                default:
                  break;
              }
            } else {
              switch ($('#selectFiltros').val()) {
                case 'CODIGO':
                  orderby = "PA_ITEN.CODIGO";
                  break;
                case 'CODIGO2':
                  orderby = "PRODUTO.CODIGO2";
                  break;
                case 'DESCRICAO':
                  orderby = "PRODUTO.DESCRICAO";
                  break;
                case 'DESC_COR':
                  orderby = "CADCOR.DESCRICAO";
                  break;
                case 'COR':
                  orderby = "PA_ITEN.COR";
                  break;
                case 'TAM':
                  orderby = "PA_ITEN.TAM";
                  break;
                case 'GRUPO':
                  orderby = "PRODUTO.GRUPO";
                  break;
                case 'COLECAO':
                  orderby = "PRODUTO.COLECAO";
                  break;
                case 'BARRA':
                  orderby = "PA_ITEN.BARRA";
                  break;
                case 'DESC_ECOMMERCE':
                  orderby = "CADCOR.DESC_ECOMMERCE";
                  break;
                case 'LOTE':
                  orderby = "PA_ITEN.LOTE";
                  break;
                case 'DESCRICAO2':
                  orderby = "PRODUTO.DESCRICAO2";
                  break;
                case 'REFERENCIA':
                  orderby = "PRODUTO.REFERENCIA";
                  break;
                case 'LINHA':
                  orderby = "PRODUTO.LINHA";
                  break;
                case 'ETIQUETA':
                  orderby = "PRODUTO.ETIQUETA";
                  break;
                case 'MARCA':
                  orderby = "PRODUTO.MARCA";
                  break;
                default:
                  break;
              }
            }

            if (colunaOrdenacao != "" && colunaOrdenacao.NOME && colunaOrdenacao.NOME != $('#selectFiltros').val() && !colunaOrdenacao.NOME.includes("input")) {
              retornaAliasOrdenacaoClickColunaPesquisaItens(JSON.parse(camposSelect), colunaOrdenacao, true);
              orderby += `, ${colunaOrdenacao.NOME} ${colunaOrdenacao.ORDENACAO}`;
            }

            Where += ` AND PRODUTO.ATIVO = 'S' AND PA_ITEN.ATIVO IN ('S', 'R') `;
            Where += $('#cbContemEstoque').prop('checked') != false ? ` AND PA_ITEN.QUANTIDADE > 0` : '';

            let colunas = []
            let dataSetCols = [];
            colunas = bDescontaPedReserva ? ["CODIGO", "DESCRICAO", "FOTO", "COR", "DESC_COR", "UNIDADE", "TAM", "PRECO", "QTDE_EST", "QUANTIDADE",
              "BARRA", "CODIGO2", "ID", "QUALIDADE", "LOTE", "TIPO", "DESC_ECOMMERCE", "DESCRICAO2", "REFERENCIA", "GRUPO", "COLECAO", "QTDE_RESERVA", "SALDO",
            ] : ["CODIGO", "DESCRICAO", "FOTO", "COR", "DESC_COR", "UNIDADE", "TAM", "PRECO", "QTDE_EST", "QUANTIDADE",
              "BARRA", "CODIGO2", "ID", "QUALIDADE", "LOTE", "TIPO", "DESC_ECOMMERCE", "DESCRICAO2", "REFERENCIA"
            ];

            let ordemColunasRelatorio = localStorage.getItem('ordemColunasDataTable')
            ordemColunasRelatorio = JSON.parse(ordemColunasRelatorio);
            let keys;

            if (ordemColunasRelatorio != null && ordemColunasRelatorio.pesquisaProdutoVenda != undefined) {
              const colunasRel = ordemColunasRelatorio.pesquisaProdutoVenda;
              keys = colunasRel.length > 0 ? colunasRel[0].colunas : colunas;
              if (colunasRel.length > 0) {
                colunas = colunasRel[0].colunas;
              }
            } else {
              keys = colunas;
            }

            for (let k in keys) {
              dataSetCols.push({
                'title': keys[k],
                'data': k
              });
            }

            // for (let i = 0; i < colunas.length; i++) {
            //   dataSetCols.push({
            //     'title': colunas[i],
            //     'data': i
            //   });
            // }

            const ajaxData = {
              "EMPRESA": getCookie('empresa'),
              "JSON": encodeURIComponent(`{"tabela":${tabelaEstoque}, "camposWhereServerSide": ${camposWhereServerSide}, "camposSelect": ${camposSelect}, "leftJoin": [${LigacaoProdutoMaterial}, ${ligacaoTabelaCor}, ${ligacaoTabelaPreco} ${ligacaoGrupoMat == '' ? '' : (', '+ligacaoGrupoMat)}], "where": ["${Where}"], "orderby": ["${orderby}"]}`),
              "CLIENTE": 'N'
            };

            let tabelaProdutoMaterial = $('#tabelaProdutoMaterial').DataTable({
              scrollY: 'calc(100vh - 420px)',
              scrollX: true,
              scrollCollapse: true,
              fixedColumns: true,
              paging: true,
              responsive: true,
              fixedColumns: {
                leftColumns: 0
              },
              serverSide: true,
              processing: true,
              lengthChange: false,
              info: true,
              pageLength: 20,
              autoWidth: false,
              destroy: true,
              colReorder: true,
              order: false,
              sort: false,
              filter: true,
              ajax: {
                url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                type: "GET",
                headers: {
                  'Authorization': BASIC_AUTH
                },
                data: ajaxData,
              },
              columns: dataSetCols,
              createdRow: function(row, data, dataIndex) {
                const descricaoValue = data[1];
                $(row).find('td:eq(1)').attr('title', descricaoValue);
              },
              columnDefs: [{
                  "targets": [6, 7],
                  "className": 'pr-4 text-right'
                }, {
                  targets: [2],
                  render: function(data, type, row, meta) {
                    const codigo = row[0];
                    const tipo = row[15];
                    if (ativaBuscaFotosProdMat) {
                      setTimeout(() => {
                        buscaFotoProduto(codigo, tipo, imageCache);
                      }, 300);
                    }
                    const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + tipo);
                    return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="30" width="30"/>`
                  }
                }, {
                  targets: [4],
                  render: function(data, type, row, meta) {
                    if (empresaTrabalhaComFotoCor) {
                      const codigo = row[0];
                      const cor = row[3];
                      const tipo = row[15];
                      if (ativaBuscaFotosProdMat) {
                        setTimeout(() => {
                          buscaFotoCorProduto(codigo, cor, tipo, imageCache);
                        }, 300);
                      }
                      const codigoCriptografado = criptografaCodigo('img_prod_cor_' + codigo + '_' + cor + '_' + tipo);
                      return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="30" width="30"/> ${row[4]} `;
                    } else {
                      return row[4];
                    }
                  }
                },
                {
                  targets: [9],
                  render: function(data, type, row, meta) {
                    return '<div class="d-flex align-items-center justify-content-center">' +
                      `<i class="m-0 p-0 fas fa-minus subtraiQtdePesquisaItens" style="margin-right: 12px !important" id="subtraiQtdePesquisaItens${meta.row}"></i>` +
                      `<input type="number" id="qtdeAdicionar${meta.row}` +
                      `" class="input-default focus form-control validate inputQtdeAdicionar mr-2" style="height: 30px; width: 50px" value="0"> ` +
                      `<i class="m-0 p-0 fas fa-plus adicionaQtdePesquisaItens" id="adicionaQtdePesquisaItens${meta.row}"></i>` +
                      '</div>';
                  }
                }
              ]
            });

            tabelaProdutoMaterial.columns.adjust().draw();
            $("#tabelaProdutoMaterial_wrapper > .row > .col-sm-12 > .dataTables_scroll > .dataTables_scrollHead > .dataTables_scrollHeadInner > table").removeClass("table-sm-sisp").addClass("table-sm");

            // function moverElemento(lista, de, para) {
            //   // Remove o elemento da posição "de"
            //   const elementoRemovido = lista.splice(de, 1)[0];

            //   // Insere o elemento na posição "para"
            //   lista.splice(para, 0, elementoRemovido);

            //   return lista;
            // }


            // $('#tabelaProdutoMaterial').on('column-reorder.dt', function(e, settings, details) {
            //   if (bConsultandoProduto) {
            //     return;
            //   }
            //   const newColumnOrder = [];

            //   const listaTodasColunasPesquisaProduto = JSON.parse(todasColunasPesquisaProduto);
            //   const column = listaTodasColunasPesquisaProduto[details.from];
            //   moverElemento(listaTodasColunasPesquisaProduto, details.from, details.to);
            //   // for (let i = 0; i < listaTodasColunasPesquisaProduto.length; i++) {
            //   //   const indice = settings.aoColumns[i].mData;
            //   //   const column = $('#tabelaProdutoMaterial thead tr#colunas th').eq(indice).text();
            //   //   $('#tabelaProdutoMaterial thead tr#colunas th').eq(i).text()
            //   //   newColumnOrder.push(column)
            //   // }

            //   let ordemColunas = localStorage.getItem('ordemColunasDataTable')
            //   ordemColunas = JSON.parse(ordemColunas)
            //   if (ordemColunas == null || ordemColunas.pesquisaProdutoVenda == undefined) {
            //     localStorage.setItem('ordemColunasDataTable', JSON.stringify({
            //       ...ordemColunas,
            //       pesquisaProdutoVenda: [{
            //         colunas: newColumnOrder
            //       }]
            //     }));
            //   } else {
            //     const ordensSalvas = JSON.parse(localStorage.getItem('ordemColunasDataTable'));
            //     const newObj = {
            //       colunas: newColumnOrder
            //     }
            //     ordensSalvas.pesquisaProdutoVenda[0] = newObj;
            //     localStorage.setItem('ordemColunasDataTable', JSON.stringify(ordensSalvas));
            //   }
            // });

            $('#tabelaProdutoMaterial_filter').addClass('d-none');
            if ($('.filtrosAdicionaisTabela').length == 0) {
              $('#tabelaProdutoMaterial_wrapper .row:eq(1)').prepend(`
                        <div class="col-12 d-flex mb-1">
                        <input placeholder="CODIGO" style="max-width: 6rem" class="form-control form-control-sm filtrosAdicionaisTabela mr-1" type="text" data-index="0">
                        <input placeholder="DESCRICAO" style="max-width: 22rem" class="form-control form-control-sm filtrosAdicionaisTabela mr-1" type="text" data-index="1">
                        <input placeholder="COR" style="max-width: 6rem" class="form-control form-control-sm filtrosAdicionaisTabela mr-1" type="text" data-index="3">
                        <input placeholder="DESC_COR" style="max-width: 10rem" class="form-control form-control-sm filtrosAdicionaisTabela mr-1" type="text" data-index="4">
                        <input placeholder="UNIDADE" style="max-width: 6rem" class="form-control form-control-sm filtrosAdicionaisTabela mr-1" type="text" data-index="5">
                        <input placeholder="TAM" style="max-width: 6rem" class="form-control form-control-sm filtrosAdicionaisTabela mr-1" type="text" data-index="6">
                        <button id="limparFiltrosAdicionaisTabela" title="Limpar Filtros" class="btn btn-danger btn-sm ml-2 mr-2"><i class="fas fa-trash"></i></button>
                        <button class="buttonColVisProduto btn btn-primary btn-sm" id="buttonColVisProduto"><i class="fas fa-cogs"></i></button>
                        </div>`);
            }


            $('#limparFiltrosAdicionaisTabela').off();
            $('#limparFiltrosAdicionaisTabela').on('click', async function() {
              $('.filtrosAdicionaisTabela').val('');
              await consultaItensVenda();
            });
            $('#tabelaProdutoMaterial_wrapper input.filtrosAdicionaisTabela').off('keyup');
            $('#tabelaProdutoMaterial_wrapper input.filtrosAdicionaisTabela').on('keyup', function() {
              $('#tabelaProdutoMaterial').DataTable()
                .column($(this).data('index'))
                .search(this.value.toUpperCase())
                .draw();
            });

            $('.dataTables_scrollHeadInner table[aria-describedby="tabelaProdutoMaterial_info"] th').off("click");
            $('.dataTables_scrollHeadInner table[aria-describedby="tabelaProdutoMaterial_info"] th').on('click', async function(e) {
              if ($(e.target).is('input')) {
                return;
              }
              const nomeColuna = $(this).html();
              const colunaOrdenacao = $("#tabelaProdutoMaterial").prop("colunaOrdenacao") ?? "";
              $("#tabelaProdutoMaterial").prop("colunaOrdenacao", {
                ORDENACAO: colunaOrdenacao.ORDENACAO == "ASC" ? "DESC" : "ASC",
                NOME: nomeColuna
              });
              await consultaItensVenda();
            });

            $('#tabelaProdutoMaterial').on('click', 'tr td', async function() {
              if ($(this).index() == 2) {
                $('.imagepreview').attr('src', $(this).find('img').attr('src'));
                $('#imagemodal').modal('show');
                $('#imagemodal').css('z-index', '999999')
              }
            });

            $('#tabelaProdutoMaterial').on('click', 'tr td img', async function() {
              if ($(this).closest('td').index() == 4) {
                $('.imagepreview').attr('src', $(this).attr('src'));
                $('#imagemodal').modal('show');
                $('#imagemodal').css('z-index', '999999')
              }
            });

            $('#tabelaProdutoMaterial').off('click', '.adicionaQtdePesquisaItens');
            $("#tabelaProdutoMaterial").on("click", ".adicionaQtdePesquisaItens", function() {
              const paramEstoque = parametrosVenda[4];
              const qtdeAtual = formataNumerico($(this).siblings(".inputQtdeAdicionar").val());
              const qtdeEstoque = formataNumerico($("#tabelaProdutoMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][8]);
              const item = $("#tabelaProdutoMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
              const qtdeAtualizada = qtdeAtual + 1;
              const bTipoVendaMovimentaEstoque = $("#vendaMovimentaEstoque").prop("checked");

              if (!bTipoVendaMovimentaEstoque || paramEstoque != "0" || qtdeAtualizada <= qtdeEstoque) {
                $(this).siblings(".inputQtdeAdicionar").val(qtdeAtualizada);
                adicionaListaPesquisaItens(item, qtdeAtualizada);
                $($(this).closest("tr")).addClass("selected");
                if (bTipoVendaMovimentaEstoque && paramEstoque == "1" && qtdeAtualizada > qtdeEstoque) {
                  msgAlerta("Quantidade maior que a disponível no estoque.");
                }
              } else {
                msgAlerta("Não é possível selecionar uma quantidade superior à disponível no estoque.");
              }
            })

            $('#tabelaProdutoMaterial').off('click', '.subtraiQtdePesquisaItens');
            $("#tabelaProdutoMaterial").on("click", ".subtraiQtdePesquisaItens", function() {
              const qtdeAtual = formataNumerico($(this).siblings(".inputQtdeAdicionar").val());
              const item = $("#tabelaProdutoMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
              if (qtdeAtual > 0) {
                const qtdeAtualizada = (qtdeAtual - 1) < 0 ? 0 : (qtdeAtual - 1);
                $(this).siblings(".inputQtdeAdicionar").val(qtdeAtualizada);
                adicionaListaPesquisaItens(item, qtdeAtualizada);
                if (qtdeAtualizada == 0) {
                  $($(this).closest("tr")).removeClass("selected");
                }
              }
            });

            $("#buttonColVisProduto").on("click", async function() {
              $.LoadingOverlay("show");
              $('#txtEstoquePrecoControle').val(0); // nao sei porque serve, mas coloquei aqui tambem.
              $("#modal-ColunasVisiveis").modal("show");
              $.LoadingOverlay("hide");
            });

            const colunasInvisiveis = JSON.parse(
              localStorage.getItem("colunasInvisiveisRelatorios")
            );

            const totaisColunas = $('.dataTables_scrollHeadInner table[aria-describedby="tabelaProdutoMaterial_info"] th').length;
            const arraytodasColunasPesquisaProduto = [];
            for (let y = 0; y < totaisColunas; y++) {
              arraytodasColunasPesquisaProduto.push($('.dataTables_scrollHeadInner table[aria-describedby="tabelaProdutoMaterial_info"] th').eq(y).text())
            }
            todasColunasPesquisaProduto = JSON.stringify(arraytodasColunasPesquisaProduto);

            $("#tabelaProdutoMaterial")
              .DataTable()
              .columns()
              // eslint-disable-next-line array-callback-return
              .every(function() {
                const colAtual = String(this.dataSrc());
                if (colunasInvisiveis.vendaProduto && colunasInvisiveis.vendaProduto.indexOf(colAtual) != -1) {
                  this.visible(false);
                }
              });

            eventoKeydownFilterTabelaProdutoMaterial();
            eventoKeydownHeadFiltersTabelaProdutoMaterial();
            // $('.filtrosAdicionaisTabela[data-index="0"]').css('width', $('#tabelaProdutoMaterial th[data-column-index="0"]').width()+5);
            // $('.filtrosAdicionaisTabela[data-index="1"]').css('width', $('#tabelaProdutoMaterial th[data-column-index="1"]').width()+5);
            // $('.filtrosAdicionaisTabela[data-index="3"]').css('width', $('#tabelaProdutoMaterial th[data-column-index="3"]').width()+5);
            // $('.filtrosAdicionaisTabela[data-index="4"]').css('width', $('#tabelaProdutoMaterial th[data-column-index="4"]').width()+5);
            // $('.filtrosAdicionaisTabela[data-index="5"]').css('width', $('#tabelaProdutoMaterial th[data-column-index="5"]').width()+5);
            // $('.filtrosAdicionaisTabela[data-index="6"]').css('width', $('#tabelaProdutoMaterial th[data-column-index="6"]').width()+5);

          } catch (error) {
            bConsultandoProduto = false;
            console.error(error);
            msgErro('Não foi possível buscar os dados dos itens.');
          }
        } finally {
          bConsultandoProduto = false;
          $.LoadingOverlay("hide");
        }
      };

      function limpaPesquisaItens() {
        $("#tabelaProdutoMaterial").DataTable().draw(false);
        listaPesquisaItens = [];
      }

      $("#tabelaProdutoMaterial").on('draw.dt', function() {
        const registros = $("#tabelaProdutoMaterial").DataTable().data().toArray();

        listaPesquisaItens.forEach(item => {
          registros.forEach((registro, i) => {
            if (registro[0] == item[0] && registro[3] == item[3] && registro[6] == item[6] && registro[13] == item[13] && registro[14] == item[14]) {
              $(`#qtdeAdicionar${i}`).val(item[9]);
              $($("#tabelaProdutoMaterial tbody tr")[i]).addClass("selected");
            }
          })
        })

      });

      $("#tabelaProdutoMaterial").on("blur", ".inputQtdeAdicionar", function() {
        const paramEstoque = parametrosVenda[4];
        const qtdeAtual = formataNumerico($(this).val());
        const qtdeEstoque = formataNumerico($("#tabelaProdutoMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][8]);
        const item = $("#tabelaProdutoMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
        const bTipoVendaMovimentaEstoque = $("#vendaMovimentaEstoque").prop("checked");
        if (qtdeAtual > 0) {
          if (!bTipoVendaMovimentaEstoque || paramEstoque != "0" || qtdeAtual <= qtdeEstoque) {
            adicionaListaPesquisaItens(item, qtdeAtual);
            $($(this).closest("tr")).addClass("selected");
            if (bTipoVendaMovimentaEstoque && paramEstoque == "1" && qtdeAtual > qtdeEstoque) {
              msgAlerta("Quantidade maior que a disponível no estoque.");
            }
          } else {
            $(this).val(0);
            $($(this).closest("tr").removeClass("selected"));
            msgAlerta("Não é possível selecionar uma quantidade superior à disponível no estoque.");
          }
        } else {
          $(this).val(0);
          $($(this).closest("tr").removeClass("selected"));
        }
      })

      $("#tabelaProdutoMaterial").on("focus", ".inputQtdeAdicionar", function() {
        $(this).val("");
      })

      function adicionaListaPesquisaItens(item, qtde) {
        const indexItem = listaPesquisaItens.findIndex(itemLista => item[0] == itemLista[0] && item[3] == itemLista[3] && item[6] == itemLista[6] && item[13] == itemLista[13] && item[14] == itemLista[14]);
        if (indexItem > -1 && qtde == 0) {
          listaPesquisaItens.splice(indexItem, 1);
        } else if (indexItem > -1) {
          listaPesquisaItens[indexItem][9] = qtde;
        } else if (indexItem == -1 && qtde > 0) {
          listaPesquisaItens.push(item);
          item[9] = qtde;
        }
      }

      $('#tabelaProdutoMaterial tbody').on('click', 'tr', function(e) {
        const target = e.target;
        const qtdeEstoque = formataNumerico($("#tabelaProdutoMaterial").DataTable().rows($(this).closest('tr')).data().toArray()[0][8]);
        const indexRow = $("#tabelaProdutoMaterial").DataTable().row($(this)).index();
        if ($(target).is(".adicionaQtdePesquisaItens") || $(target).is(".subtraiQtdePesquisaItens") || $(target).is(".inputQtdeAdicionar")) {
          return;
        }
        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
          $(`#qtdeAdicionar${indexRow}`).val(1);
          $(`#subtraiQtdePesquisaItens${indexRow}`).trigger("click");
        } else {
          $(`#adicionaQtdePesquisaItens${indexRow}`).trigger("click");
        }
      });

      // duplo click faz escolher o registro e fechar a pesquisa
      $('#tabelaProdutoMaterial tbody').on('dblclick', 'tr', async function(e) {
        const target = e.target;
        if ($(target).is(".adicionaQtdePesquisaItens") || $(target).is(".subtraiQtdePesquisaItens") || $(target).is(".inputQtdeAdicionar")) {
          return;
        }
        // event.preventDefault();
        document.firstElementChild.style.zoom = "reset";
        tabelaProdutoMaterial.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        await rotinaConfirmaProduto();
        bDblclickModalProduto = true;
      });
      // botão selecionar
      $("#btn_confirmar_produto").click(async function() {
        await rotinaConfirmaProduto();
      });

      async function rotinaConfirmaProduto() {
        try {
          if ($('#modal-brinde').is(':visible')) {
            await confirmaBrinde();
            return;
          }

          $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');

          async function buscaQualidade(codigo) {
            try {
              const json = await retornaJsonPesquisaPadrao(`{"tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO = '${codigo}'"] }`);
              if (json) {
                return json;
              }
            } catch (error) {
              console.error(error);
            }
          }

          const paramTipoItem = parametrosVenda[17];

          if (listaPesquisaItens.length > 0) {
            listaPesquisaItens.sort(function(a, b) {
              if (a[7] == "" && b[7] != "") {
                return 1;
              } else if (a[7] != "" && b[7] == "") {
                return -1;
              } else {
                return 0;
              }
            })
            for (let i = 0; i < listaPesquisaItens.length; i++) {
              const qualidade = await buscaQualidade(listaPesquisaItens[i][13]);
              insereValor("#txtQualidade", qualidade[0].CODIGO, qualidade[0].DESCRICAO);

              if (await produtoComStatusBloqueioVenda(listaPesquisaItens[i][0])) {
                msgAlerta(`Produto ${listaPesquisaItens[i][0]} com Status de bloqueio para digitação de venda.`);
                continue;
              }

              if (listaPesquisaItens[i][12] > 0) {
                $('#txtQuantid').val(listaPesquisaItens[i][9]);
                $('#txtIdItem').val(listaPesquisaItens[i][12]);
              } else if (listaPesquisaItens[i][10] != '') {
                $('#txtCodigo').val(listaPesquisaItens[i][9] + '*' + listaPesquisaItens[i][10]);
              } else {
                $('#txtQuantid').val(listaPesquisaItens[i][9]);
                $('#txtIdItem').val(listaPesquisaItens[i][12]);
              }
              $("#txtCodigo").attr("informacoesItem", `${listaPesquisaItens[i][0]} - ${listaPesquisaItens[i][1]}`);
              $("#txtCodigo").attr("quantidadeItem", listaPesquisaItens[i][9]);
              await RotinaSaidaCodigo(listaPesquisaItens[i][15], '', '', '', true);
            }
          } else {
            const data = tabelaProdutoMaterial.api().row('.selected').data();
            if (data == undefined) {
              throw msgAlerta("Nenhum item selecionado.");
            }
            const qualidade = await buscaQualidade(data[13]);
            insereValor('#txtQualidade', qualidade[0].CODIGO, qualidade[0].DESCRICAO);
            $("#txtCodigo").attr("informacoesItem", `${data[0]} - ${data[1]}`);
            if (data[15] == 'P') {
              if (data[10] != '') {
                $('#txtIdItem').val(data[12]);
                $('#txtCodigo').val($('#txtCodigo').val() + data[10]);
              } else {
                if (data[12] != '') {
                  $('#txtIdItem').val(data[12]);
                  $('#txtCodigo').val('');
                  await RotinaSaidaCodigo();
                } else {
                  $('#txtIdItem').val('');
                  msgAlerta("O Item selecionado não contém Barra, Lote e ID.");
                }
              }
            } else {
              if ((data[14] != '') && (data[14] != '000000')) {
                $('#txtIdItem').val(data[12]);
              } else {
                if (data[12] != '') {
                  $('#txtIdItem').val(data[12]);
                  $('#txtCodigo').val(data[14]);
                } else {
                  $('#txtIdItem').val('');
                  msgAlerta("O item selecionado não contém Barra, Lote e ID.");
                }
              }
            }
          }
        } catch (error) {
          console.log(error);
        } finally {
          $("#modalProduto").modal("hide");
          limpaPesquisaItens();
          $("#txtCodigo").attr("quantidadeItem", 0);
          bDblclickModalProduto = false;
        }
      }

      async function RotinaConfirmarPrecoTrocaTabela(sTabela, sBarra, pPreco, pIdItem) {
        try {
          try {
            $.LoadingOverlay("show");
            const url = `/Sisplan/Vendas/V1/PrecoTabela?`;
            const tipoItem = "M";

            const params = `tabela=${sTabela}&barra=${encodeURIComponent(sBarra)}&idItem=${pIdItem}&TIPO=M&PRECO=${pPreco}&PRAZO=${pegaValor('#rgPrazo')}`;
            const response = await requisicao("POST", url, params, null);
            if (!response) {
              msgErro("Erro ao gravar preço");
              return;
            }

            if (response.status != 200) {
              msgErro("Erro ao gravar preço");
              return false;
            }

            $('#txtPrecoDesc').val(pPreco).trigger('change');
            $("#modalCadPreco").modal("hide");
            // ALTERA O PREÇO DA TABELA ITENS TAMBEM...
          } catch (error) {
            console.error(error);
            msgErro("Erro ao gravar preço");
            return;
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
      async function eventoClickConfirmarPrecoTrocaTabela() {
        return new Promise(async (resolve) => {
          async function handleClick() {
            if ($('#txtPrecoManual').val() <= 0) {
              msgErro('Preço inválido, verifique');
              return;
            }
            if ($('#txtTabelaDesc').val() == '') {
              msgErro('Tabela de preço não informada, verifique');
              return;
            }

            const sTabelaPreco = pegaChave('#txtTabelaDesc');
            if (parametrosVenda[32] == '1') {
              // só altera o preço direto na tabelaItens
              $('#txtPrecoDesc').val($('#txtPrecoManual').val()).trigger('change');
              await sleep(500);
              $('#pesquisaDescontoConfirmar').trigger('click');
            } else {
              await RotinaConfirmarPrecoTrocaTabela(sTabelaPreco, $('#txtBarraPrecoManual').val(), $('#txtPrecoManual').val().replace('.', ','), $('#txtIdItemPrecoManual').val());
            }
            $("#modalCadPreco").modal("hide");
            resolve();
          }

          async function handleClose(e) {
            $("#modalCadPreco").modal("hide");
            resolve();
          }

          $("#btn_confirmar_preco").off("click");
          $("#btn_confirmar_preco").on("click", async function() {
            await handleClick();
          });

          $("#btnFecharPrecoManual").off("click");
          $("#btnFecharPrecoManual").on("click", async function() {
            await handleClose();
          });

        })
      }

      async function eventoClickConfirmarPreco(tipoItem = 'P') {
        return new Promise(async (resolve) => {
          async function handleClick() {
            if ($('#txtPrecoManual').val() <= 0) {
              msgErro('Preço inválido, verifique');
              return;
            }
            if ($('#txtTabela').val() == '') {
              msgErro('Tabela de preço não informada, verifique');
              return;
            }

            var sTabelaPreco = pegaChave('#txtTabela', sTabelaPreco);
            if (parametrosVenda[32] == '1') {
              $('#txtCodigo').val($('#txtBarraPrecoManual').val())
              await RotinaSaidaCodigo(tipoItem, '', '', '', tipoItem == 'M', '', '');
            } else {
              await RotinaConfirmarPrecoManual(sTabelaPreco, $('#txtBarraPrecoManual').val(), $('#txtPrecoManual').val().replace('.', ','), $('#txtIdItemPrecoManual').val());
            }
            $("#modalCadPreco").modal("hide");
            $("#txtCodigo").removeAttr("semFoco");
            resolve();
          }

          async function handleClose(e) {
            $("#modalCadPreco").modal("hide");
            resolve();
          }

          $("#btn_confirmar_preco").off("click");
          $("#btn_confirmar_preco").on("click", async function() {
            await handleClick();
          });

          $("#btnFecharPrecoManual").off("click");
          $("#btnFecharPrecoManual").on("click", async function() {
            await handleClose();
          });

        })
      }

      if (parametrosVenda[77] == '1') {
        $('#btn-cliente').pesquisa_serverside(
          ['#txtCliente', '#txtCNPJ'],
          ['ENTIDADE.CODCLI', 'ENTIDADE.CNPJ'],
          ['ENTIDADE.NOME', 'ENTIDADE.CNPJ'],
          JSON.stringify(selectBtnClienteUltimoMovimento),
          'Pesquisa Cliente',
          async () => {
              await carregaTabelaCliente(pegaChave('#txtCliente'))
            },
            undefined,
            '',
            'S'
        );
      } else {
        $('#btn-cliente').pesquisa_serverside(
          ['#txtCliente', '#txtCNPJ'],
          ['ENTIDADE.CODCLI', 'ENTIDADE.CNPJ'],
          ['ENTIDADE.NOME', 'ENTIDADE.CNPJ'],
          JSON.stringify(selectBtnClienteLoja),
          'Pesquisa Cliente',
          async () => {
              await carregaTabelaCliente(pegaChave('#txtCliente'))
            },
            undefined,
            '',
            'S');

        $('#btnClienteBrinde').pesquisa_serverside(
          ['#txtClienteBrinde'],
          ['ENTIDADE.CODCLI', 'ENTIDADE.CNPJ'],
          ['ENTIDADE.NOME', 'ENTIDADE.CNPJ'],
          JSON.stringify(selectBtnClienteLoja),
          'Pesquisa Cliente',
          undefined,
          undefined,
          '',
          'S');

        $('#btnAcessoClienteBrinde').pesquisa_serverside(
          ['#txtAcessoClienteBrinde'],
          ['ENTIDADE.CODCLI', 'ENTIDADE.CNPJ'],
          ['ENTIDADE.NOME', 'ENTIDADE.CNPJ'],
          JSON.stringify(selectBtnClienteLoja),
          'Pesquisa Cliente',
          undefined,
          undefined,
          '',
          'S');
      }


      $('#btnCliente').pesquisa_array(['#txt-cliente', '#txt-cnpj'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(selectBtnCliente)}`, 'Pesquisa Cliente', 'entidade');

      async function confirmaBrinde(bMaterial = false) {
        $.LoadingOverlay('show');
        try {
          if (listaPesquisaItens.length > 0) {
            listaPesquisaItens.sort(function(a, b) {
              if (a[7] == "" && b[7] != "") {
                return 1;
              } else if (a[7] != "" && b[7] == "") {
                return -1;
              } else {
                return 0;
              }
            })
            for (let i = 0; i < listaPesquisaItens.length; i++) {
              if (bMaterial) {
                await saidaBarraBrinde('', false, listaPesquisaItens[i].id_estoque, listaPesquisaItens[i].qualidade, listaPesquisaItens[i].qtde, listaPesquisaItens[i].deposito);
              } else {
                await saidaBarraBrinde(listaPesquisaItens[i][10], false, listaPesquisaItens[i][12], listaPesquisaItens[i][13], listaPesquisaItens[i][9]);
              }
            }
          } else {
            if (bMaterial) {
              const data = $('#tabelaMaterial').dataTable().api().row('.selected').data();
              if (data == undefined) {
                throw msgAlerta("Nenhum item selecionado.");
              }
              await saidaBarraBrinde(data[16], false, data[14], data[15], data[6], data[17]);
            } else {
              const data = tabelaProdutoMaterial.api().row('.selected').data();
              if (data == undefined) {
                throw msgAlerta("Nenhum item selecionado.");
              }
              await saidaBarraBrinde(data[14], false, data[16], data[17], data[13]);
            }
          }
          limpaPesquisaItensMaterial();
        } catch (error) {
          console.log(error);
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      async function saidaBarraBrinde(sBarra, bEstorno, ID = '', qualidade = '1', qtde = 1, deposito = '') {
        $.LoadingOverlay('show');
        try {
          let sDeposito = ''
          const estorno = bEstorno ? 'S' : 'N';
          const sTabela = pegaChave("#txtTabPrecoBrinde");
          if (deposito == '') {
            sDeposito = pegaChave("#txtDepositoBrinde");
          } else {
            sDeposito = deposito
          }
          const bBarraLog = await retornaBarraLogLida(sBarra) == "barra_log"

          if (sDeposito == '') {
            msgAlerta('Necessário informar um depósito.');
            return;
          }

          if (sTabela == '') {
            msgAlerta('Necessário informar uma tabela.');
            return;
          }

          if (bEstorno) {
            if (!$.fn.DataTable.isDataTable('#tabelaItensBrinde')) {
              msgAlerta('Nenhum registro encontrado para estornar.', undefined, undefined, () => {
                $('#txtBarraBrinde').focus();
              });
              return;
            }
            const barra = sBarra.substring(0, 1).indexOf("-") >= 0 ? sBarra.substring(1) : sBarra;
            const index = $('#tabelaItensBrinde').DataTable().data().toArray().findIndex((item) => {
              return item.BARRA === barra
            });

            if (index >= 0) {
              $('#tabelaItensBrinde').DataTable().row(index).remove().draw(false);
            } else {
              msgAlerta('Nenhum registro encontrado para estornar.', undefined, undefined, () => {
                $('#txtBarraBrinde').focus();
              });
            }
            return;
          }

          if (bBarraLog && $.fn.DataTable.isDataTable('#tabelaItensBrinde')) {
            const index = $('#tabelaItensBrinde').DataTable().data().toArray().findIndex((item) => {
              return item.BARRA === sBarra
            });

            if (index >= 0) {
              await msgAlerta(`Barra ${sBarra} já lida, verifique.`, undefined, undefined, () => {
                $('#txtBarraBrinde').focus();
              });
              return;
            }
          }

          const url = `/Sisplan/Estoque/v1/barra?`;
          const tipoItem = $('#radioMaterial').is(':checked') ? 'M' : 'P';



          const params = `barra=${encodeURIComponent(sBarra)}&tabpreco=${sTabela}&tipo=${tipoItem}&deposito=${sDeposito}&prazo=00&ESTORNO=${estorno}&IDITEM=${ID}&QUALIDADE=${qualidade}`;
          const response = await requisicao('GET', url, params);

          if (!response) {
            return false;
          }

          const jsonStr = await response.json();

          if (response.status != 200) {
            SomAlerta('<?php echo BASE_URI; ?>', true);
            if (jsonStr.mensagem.substr(jsonStr.mensagem, 20) == 'Preço não Cadastrado') {
              msgAlerta(`Item selecionado não cadastrado na tabela de preço ${sTabela}`, undefined, undefined, () => {
                $('#txtBarraBrinde').focus();
              });
              return;
            } else {
              msgErro(jsonStr.mensagem);
              return;
            }
          }

          let vQtde = qtde;
          if ($.fn.DataTable.isDataTable('#tabelaItensBrinde')) {
            $('#tabelaItensBrinde').DataTable().data().toArray().forEach((item) => {
              if (item.ID_ESTOQUE === jsonStr[0].ID_ESTOQUE) {
                vQtde++;
              }
            })
          }

          if ((jsonStr[0].ESTOQUE < (vQtde)) || (jsonStr[0].ESTOQUE <= 0)) {
            switch (parametrosVenda[4]) {
              case '0':
                await msgAlerta(`Estoque insuficiente para o produto: ${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}, cor: ${jsonStr[0].COR} - ${jsonStr[0].DESC_COR}, tamanho: ${jsonStr[0].TAM}`, undefined, undefined, () => {
                  $('#txtBarraBrinde').focus();
                });
                return;
                break;
              case '1':
                await msgAlerta(`Estoque insuficiente para o produto: ${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}, cor: ${jsonStr[0].COR} - ${jsonStr[0].DESC_COR}, tamanho: ${jsonStr[0].TAM}`, undefined, undefined, () => {
                  $('#txtBarraBrinde').focus();
                });
                break;
              case '2':
                break;
            }
          }

          const obj = {
            CODIGO: jsonStr[0].CODIGO,
            DESCRICAO: jsonStr[0].DESCRICAO,
            COR: jsonStr[0].COR,
            DESC_COR: jsonStr[0].DESC_COR,
            TAM: jsonStr[0].TAM,
            QTDE: tipoItem == 'P' ? qtde : tipoItem == 'M' && qtde != 0 ? qtde : jsonStr[0].ESTOQUE,
            PRECO: jsonStr[0].PRECO,
            ID_ESTOQUE: jsonStr[0].ID_ESTOQUE,
            DEPOSITO: jsonStr[0].DEPOSITO,
            BARRA_LOG: bBarraLog ? sBarra : '',
            ID_PRO: jsonStr[0].ID_PRO,
            ID_COR: jsonStr[0].ID_COR,
            ID_DEPOSITO: jsonStr[0].ID_DEPOSITO,
            TABELA: sTabela,
            EMP_ID: getCookie('emp_id'),
            QUALIDADE: jsonStr[0].QUALIDADE,
            LOTE: jsonStr[0].LOTE,
            BARRA: sBarra,
            TIPO: jsonStr[0].TIPO
          };

          if ($.fn.DataTable.isDataTable('#tabelaItensBrinde')) {
            $('#tabelaItensBrinde').DataTable().row.add(obj).draw(false);
            return;
          }

          const titulos = [{
              title: "Código",
              data: "CODIGO"
            },
            {
              title: "Descrição",
              data: "DESCRICAO"
            },
            {
              title: "Cor",
              data: "COR"
            },
            {
              title: "Desc. Cor",
              data: "DESC_COR"
            },
            {
              title: "Tam",
              data: "TAM"
            },
            {
              title: "Qtde",
              data: "QTDE"
            },
            {
              title: "Preço",
              data: "PRECO"
            },
            {
              title: "ID Estoque",
              data: "ID_ESTOQUE"
            },
            {
              title: "Depósito",
              data: "DEPOSITO"
            },
            {
              title: "Barra log",
              data: "BARRA_LOG"
            },
            {
              title: "ID Item",
              data: "ID_PRO"
            },
            {
              title: "ID Cor",
              data: "ID_COR"
            },
            {
              title: "ID Depósito",
              data: "ID_DEPOSITO"
            },
            {
              title: "Tabela",
              data: "TABELA"
            },
            {
              title: "Emp ID",
              data: "EMP_ID"
            },
            {
              title: "Qualidade",
              data: "QUALIDADE"
            },
            {
              title: "Lote",
              data: "LOTE"
            },
            {
              title: "Barra",
              data: "BARRA"
            },
            {
              title: "Tipo",
              data: "TIPO"
            },
          ];

          $('#tabelaItensBrinde').DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            autoWidth: true,
            columnDefs: [{
                render(data) {
                  return parseFloat(data).toLocaleString("pt-BR", {
                    maximumFractionDigits: 2,
                    minimumFractionDigits: 2
                  });
                },
                targets: [6],
                "className": 'pr-4 text-right'
              },
              {
                "targets": [7, 8, 9, 10, 11, 12, 13, 14, 17, 18],
                "visible": false
              },
              {
                "targets": [5],
                "className": 'pr-4 text-right'
              }
            ],
            columns: titulos,
            data: [obj],
          });
        } catch (error) {
          console.log(error);
        } finally {
          $.LoadingOverlay('hide');
          $('#txtBarraBrinde').val('');
          $('#txtBarraBrinde').focus();
        }
      }

      $('#txtBarraBrinde').focusout(async () => {
        const value = $('#txtBarraBrinde').val().trim();
        const bEstorno = value.substring(0, 1).indexOf("-") >= 0 || $('#btnMenosOuMaisBrinde>i.fa-minus').length > 0;
        if (value != '') {
          await saidaBarraBrinde(value, bEstorno);
        }
      });

      async function retornaPrecoItens(listaItens) {
        try {
          $.LoadingOverlay("show");
          try {
            const sTabela = $("#txtTabela").val().indexOf("[") != -1 ? pegaChave("#txtTabela") : $("#txtTabela").val();
            const url = `/sisplan/funcoes/v1/pesquisa?`;
            // verificar futuramente para olhar cor/tam também.
            // mock itens
            const itens = listaItens.map((item) => {
              return `'${item}'`;
            }).join();

            const params = `JSON={ "tabela":"tabpreco", "camposSelect":[ "codigo", "preco_${pegaValor('#rgPrazo')} preco", "preco_promo", "dt_promofim", "dt_promoini"], "where": ["regiao = '${sTabela}' and codigo in (${itens})"] }`;

            const response = await requisicao('GET', url, params, null);

            if (!response) {
              throw new Error("Erro na rotina retornaPrecoItens()");
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return false;
            }

            const dados = jsonStr.RESULT[0];

            for (let i = 0; i < listaItens.length; i++) {
              const itemLista = listaItens[i]; //codigo
              const posicaoItem = dados.findIndex(obj => {
                return obj.CODIGO == itemLista;
              });
              if (posicaoItem < 0) {
                msgErro('Produto de código: ' + itemLista + ' sem preço cadastrado para essa tabela, impossível continuar.');
                return false;
              }
            }

            const dataAtual = new Date();

            for (let i = 0; i < $('#tabelaItens').DataTable().rows().count(); i++) {
              const itemTabela = $('#tabelaItens').DataTable().row(i).data();
              const posicaoItemRetorno = dados.findIndex(obj => {
                return obj.CODIGO == itemTabela[0];
              });

              const dataPromocaoIni = new Date(dados[posicaoItemRetorno].DT_PROMOINI);
              const dataPromocaoFim = new Date(dados[posicaoItemRetorno].DT_PROMOFIM);

              if ((dataPromocaoIni <= dataAtual) && (dataPromocaoFim >= dataAtual) && (dados[posicaoItemRetorno].PRECO_PROMO > 0)) {
                itemTabela[3] = TruncaDecimaisNova(2, dados[posicaoItemRetorno].PRECO_PROMO); // preço orig
                itemTabela[4] = TruncaDecimaisNova(2, dados[posicaoItemRetorno].PRECO_PROMO); // novo preço
              } else {
                itemTabela[3] = TruncaDecimaisNova(2, dados[posicaoItemRetorno].PRECO); // preço orig
                itemTabela[4] = TruncaDecimaisNova(2, dados[posicaoItemRetorno].PRECO); // novo preço
              }
              itemTabela[5] = 0;
              itemTabela[6] = 0;
              itemTabela[31] = '';
              itemTabela[7] = TruncaDecimaisNova(2, parseFloat(itemTabela[4] * itemTabela[2])); // novo total
              $('#tabelaItens').DataTable().row(i).data(itemTabela).draw(false);
            }
            venda = await montaJsonVenda(venda, numero_venda, 'P', false);
            salvaDadosDigitados(venda);
            atualizaTotalVenda();
            return true;
          } catch (error) {
            msgErro('Erro ao buscar preço dos itens!');
            console.error(error);
            return false;
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      async function retornaPrecoCorTamItens(listaItens) {
        $.LoadingOverlay("show");
        try {
          const sTabela = $("#txtTabela").val().indexOf("[") != -1 ? pegaChave("#txtTabela") : $("#txtTabela").val();
          const url = `/sisplan/vendas/v1/retornaprecocortamitensvenda?`;
          const dataAtual = new Date();
          const tabelaItens = $("#tabelaItens").DataTable().data().toArray();
          const itens = `ITENS=${JSON.stringify(listaItens)}`;
          const response = await requisicao('POST', url, `TABELA_PRECO=${sTabela}`, itens, 60000);

          if (!response) {
            throw new Error("Erro ao buscar preço dos itens!");
          }

          const jsonStr = await response.json();

          if (response.status != 200) {
            throw new Error(jsonStr.mensagem);
          }

          jsonStr.forEach(itemJson => {
            const index = tabelaItens.findIndex(item => item[0] == itemJson.CODIGO && item[10] == itemJson.COR && item[11] == itemJson.TAM);

            if (index != -1) {
              const dataPromocaoIni = formataDataComTraco(itemJson.DT_PROMOINI);
              const dataPromocaoFim = formataDataComTraco(itemJson.DT_PROMOFIM);

              if (itemJson.PRECO_PROMO > 0 && dataPromocaoIni <= dataAtual && dataPromocaoFim >= dataAtual) {
                tabelaItens[index][3] = TruncaDecimaisNova(2, itemJson.PRECO_PROMO); // preço orig
                tabelaItens[index][4] = TruncaDecimaisNova(2, itemJson.PRECO_PROMO); // novo preço
              } else {
                tabelaItens[index][3] = TruncaDecimaisNova(2, itemJson.PRECO); // preço orig
                tabelaItens[index][4] = TruncaDecimaisNova(2, itemJson.PRECO); // novo preço
              }
              tabelaItens[index][5] = 0;
              tabelaItens[index][6] = 0;
              tabelaItens[index][31] = '';
              tabelaItens[index][7] = parseFloat(parseFloat(tabelaItens[index][4] * tabelaItens[index][2]).toFixed(2)); // novo total
              $('#tabelaItens').DataTable().row(index).data(tabelaItens[index])
            }
          })
          venda = await montaJsonVenda(venda, numero_venda, 'P', false);
          $('#tabelaItens').DataTable().draw(false);
          salvaDadosDigitados(venda);
          atualizaTotalVenda();
          return true;
        } catch (error) {
          console.error(error);
          msgAlerta(error.message);
          return false;
        } finally {
          $.LoadingOverlay("hide");
        }

      }

      async function recalculaPrecoTabela() {
        const bPrecoCorTam = parametrosVenda[5] == "1";
        const itens = $("#tabelaItens").DataTable().data().toArray();
        let listaItensFormatados = [];
        try {
          if (itens.length > 0) {
            if (bPrecoCorTam) {
              listaItensFormatados = itens.map(item => {
                return {
                  CODIGO: item[0],
                  COR: item[10],
                  TAM: item[11]
                }
              });
              if (!await retornaPrecoCorTamItens(listaItensFormatados)) {
                throw new Error("Erro na rotina retornaPrecoCorTamItens()");
              }
            } else {
              listaItensFormatados = itens.map(item => {
                return item[0]
              })
              if (!await retornaPrecoItens(listaItensFormatados)) {
                throw new Error("Erro na rotina retornaPrecoItens()");
              }
            }
            msgSucesso('Preços recalculados com sucesso.');
          }
        } catch (error) {
          limpaValor('#txtTabela');
          console.error(error);
        }
      }

      async function confirmaAlteracaoTabela() {
        if ($('#tabelaItens').DataTable().rows().count() > 0) {
          $('#txtTabela').off('focusout');
          await msgAguardaConfirmacao('Os preços serão recalculados e os descontos removidos. Deseja continuar?', recalculaPrecoTabela, () => {
            $('#txtTabela').val(tabelaOld)
          });
          saidaTabela();
          tabelaOld = $('#txtTabela').val();
        } else {
          await recalculaPrecoTabela();
        }
      }

      $('#txtCodigo').keyup(function(e) {
        if (e.keyCode == 115) {
          $('#btn-codigo').click();
          e.preventDefault();
          e.stopPropagation();
        }
      });

      $('#txtBarraBrinde').keyup(function(e) {
        if (e.keyCode == 115) {
          $('#btn-codigo').click();
          e.preventDefault();
          e.stopPropagation();
        }
      });

      $('#btnTipo').on('click', function() {
        if ($('#botaoTipo').prop('class') == 'm-0 p-0 fas fa-plus') {
          $('#botaoTipo').removeClass('m-0 p-0 fas fa-plus');
          $('#botaoTipo').addClass('m-0 p-0 fas fa-minus');
        } else {
          $('#botaoTipo').removeClass('m-0 p-0 fas fa-minus');
          $('#botaoTipo').addClass('m-0 p-0 fas fa-plus');
        }
      });

      $('#btn-consulta-imp-vendas').on('click', async function() {
        if ($('#txtVenda').val() == '') {
          msgErro('Necessário informar uma venda para consultar.');
          return;
        }
        if ($('#txtTabelaImpVenda').val() == '') {
          msgErro('Necessário informar uma tabela de preço para consultar.');
          return;
        }

        var iVenda = pegaChave('#txtVenda', iVenda);
        var sTabela = pegaChave('#txtTabelaImpVenda', sTabela);
        RetornaItensImportarVenda(iVenda, sTabela);
      });

      $('#btn-consulta-imp-pedidos').on('click', async function() {
        if ($('#txtPedido').val() == '') {
          msgErro('Necessário informar um pedido para consultar.');
          return;
        }
        if ($('#txtDeposito').val() == '') {
          msgErro('Necessário informar um depósito para consultar.');
          return;
        }
        const bloqueioComercial = await buscaValor('PEDIDO', 'BLOQUEIO', 'NUMERO', pegaChave('#txtPedido'));
        const bloqueioFinanceiro = await buscaValor('PEDIDO', 'FINANCEIRO', 'NUMERO', pegaChave('#txtPedido'));

        if (bloqueioComercial == '0') {
          msgAlerta('Pedido bloqueado no setor comercial, favor verificar.');
          return;
        }

        if (bloqueioFinanceiro == '0') {
          msgAlerta('Pedido bloqueado no setor financeiro, favor verificar.');
          return;
        }

        RetornaItensImportarPedido(pegaChave('#txtPedido'), pegaChave('#txtDeposito'));
      });

      $('#select2-selectFiltros-container').on('click', function() {
        if ($('#radioMaterial').is(':checked')) {
          $('li:contains("SUBGRUPO")').removeClass('d-none');
          $('li:contains("COLECAO")').addClass('d-none');
          $('li:contains("REFERENCIA")').addClass('d-none');
        }
        if ($('#radioProduto').is(':checked')) {
          $('li:contains("SUBGRUPO")').addClass('d-none');
          $('li:contains("COLECAO")').removeClass('d-none');
          $('li:contains("REFERENCIA")').removeClass('d-none');
        }
      });

      $('.select2-selection__arrow').on('click', function() {
        if ($('#radioMaterial').is(':checked')) {
          $('li:contains("SUBGRUPO")').removeClass('d-none');
          $('li:contains("COLECAO")').addClass('d-none');
          $('li:contains("REFERENCIA")').addClass('d-none');
        }
        if ($('#radioProduto').is(':checked')) {
          $('li:contains("SUBGRUPO")').addClass('d-none');
          $('li:contains("COLECAO")').removeClass('d-none');
          $('li:contains("REFERENCIA")').removeClass('d-none');
        }
      });

      async function retornaDadosBarra(codigo, idItem, codigoMat = '', corMat = '', tipoItemImportado = '', bEstorno = false, sDepositoParam) {
        try {
          $.LoadingOverlay("show");
          try {
            const bDepositoEcommerce = isChecked('#cbDepositoEcommerce') && $('#modalProduto').is(':visible');
            const estorno = bEstorno ? 'S' : 'N';
            const sTabela = pegaChave("#txtTabela");
            const sDeposito = bDepositoEcommerce ? sDepositoEcommerce.substring(1, sDepositoEcommerce.indexOf("]")) : sDepositoParam != '' ? sDepositoParam : pegaChave("#txtDeposito");
            const iLancamento = $('#txtLancamento').val() != '' ? $('#txtLancamento').val() : 0;
            const sQualidade = pegaChave('#txtQualidade');
            const url = `/Sisplan/Estoque/v1/barra?`;
            let tipoItem = '';

            if ($('#radioMaterial').is(':checked') || $("#modalMaterial").hasClass("show")) {
              tipoItem = 'M'
            } else if ($('#radioProduto').is(':checked')) {
              tipoItem = 'P'
            }

            const params = `lancamento=${iLancamento}&barra=${encodeURIComponent(codigo)}&iditem=${idItem}&tabpreco=${sTabela}&qualidade=${sQualidade}&tipo=${importaPedido == true && codigoMat != '' && corMat != '' ? tipoItemImportado : tipoItem }&deposito=${sDeposito}${ parametrosVenda[32] == '1' ? `&precosemcadastro=${$('#txtPrecoManual').val().replace('.', ',')  != '' ? $('#txtPrecoManual').val().replace('.', ',') : '' }` : ''}&importapedido=${importaPedido}&numero=${pegaChave('#txtPedido')}&prazo=${pegaValor('#rgPrazo')}&codigomaterial=${codigoMat}&cormaterial=${corMat}&ESTORNO=${estorno}`;

            const response = await requisicao('GET', url, params, null);

            if (!response) {
              return;
            }

            const jsonStr = await response.json();

            if (tipoItem == 'M' && response.status != 400) {
              if (!await permiteVenda(jsonStr[0].GRUPO)) {
                msgAlerta(`O grupo cadastrado no material ${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO} não permite venda, verifique!`);
                return;
              }
            }

            if (response.status != 200) {
              SomAlerta('<?php echo BASE_URI; ?>', true);
              //se preço não cadastrado necessário ou só passar mensagem ou abrir modal ...
              if (jsonStr.mensagem.substr(jsonStr.mensagem, 20) == 'Preço não Cadastrado' && parametrosVenda[75] == '0') {
                $('#txtIdItemPrecoManual').val(idItem);
                $('#txtBarraPrecoManual').val(codigo);
                const informacoesItem = $("#txtCodigo").attr("informacoesItem") ?? "";
                // $("#txtTituloPrecoManual").html(`${informacoesItem}`);
                $("#txtTituloPrecoManual").html(jsonStr.mensagem);
                $('#modalCadPreco').modal('show');
                $.LoadingOverlay("hide");

                if (tipoItem == 'M') { // testado isso só em material, se necessário remover o if futuramente
                  $("#txtCodigo").attr("tipoItem", tipoItem);
                  $("#txtCodigo").attr("semFoco", true);
                }
                await eventoClickConfirmarPreco(tipoItem);
                await sleep(500);
                return;
              } else if (jsonStr.mensagem.substr(jsonStr.mensagem, 20) == 'Preço não Cadastrado' && parametrosVenda[75] == '1') {
                msgAlerta(`Item selecionado não cadastrado na tabela de preço ${sTabela}`);
                return;
              } else {
                msgErro(jsonStr.mensagem);
                return;
              }
            }

            if ((parametrosVenda[32] == '1') && (!jsonStr[0].PRECO > 0)) {
              jsonStr[0].PRECO = $('#txtPrecoManual').val().replace(',', '.');
              $('#txtPrecoManual').val('');
            }


            return jsonStr;
          } catch (error) {
            msgErro('Erro ao buscar dados da barra!');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      rotinaBlurCodigo();

      $('#txtBarraPedido').unbind('blur');
      $('#txtBarraPedido').blur(async function() {
        const bEstorno = $('#botaoTipo').prop('class') != 'm-0 p-0 fas fa-minus';
        await conferePedido(bEstorno, $(this).val());
      });

      $('#txtBarraPedido').on('keydown', async function(event) {
        if ((event.key == 'Enter')) {
          $('#txtBarraPedido').trigger('blur');
          $('#txtBarraPedido').focus();
        }
      });

      $('#tabelaImportarPedidos tbody').on('click', 'tr', async function() {
        $("#tabelaImportarPedidos tbody tr td")[0].click();
        $('#tabelaImportarPedidos tbody tr.selected').removeClass('selected');
        $(this).addClass('selected');
      });

      function rotinaBlurCodigo() {
        $('#txtCodigo').unbind('blur');
        $('#txtCodigo').blur(async function() {
          const tipoItem = $("#txtCodigo").attr("tipoItem");
          const semFoco = $("#txtCodigo").attr("semFoco");

          if ($(this).val().trim() != '' && $('#radioProduto').is(':checked') && await validaBarraDuplicada($(this).val(), pegaChave('#txtDeposito'))) {
            $('#modalProduto').modal('show');
            $('#cbContemEstoque').prop('checked', false);
            $('#selectFiltros').val('BARRA').change();
            $('#txtCampoConsulta').val($(this).val());
            $('#btnConsultarItens').trigger('click');
            $(this).val('');
            return;
          }

          if (!semFoco) {
            if ($('#txtCodigo').val().substr(0, 1) == '9') {
              if (!await verificaKit()) {
                await RotinaSaidaCodigo();
              }
            } else {
              await RotinaSaidaCodigo();
            }
          } else {
            await RotinaSaidaCodigo(tipoItem, "", "", "", true, "", "");
          }
        });
      }

      async function produtoAtivo(codigo, tipo) {
        try {
          let pesquisaParam = '';
          if (tipo == 'P') {
            pesquisaParam = {
              tabela: 'PRODUTO',
              camposSelect: ['ATIVO'],
              where: [`CODIGO = '${codigo}'`]
            }
          } else {
            pesquisaParam = {
              tabela: 'MATERIAL',
              camposSelect: ['ATIVO'],
              where: [`CODIGO = '${codigo}'`]
            }
          }
          const produtoAtivo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

          if (produtoAtivo == '') {
            return true
          }

          const resultado = produtoAtivo[0].ATIVO == 'N' ? false : true;
          return resultado;

        } catch {
          console.error(error);
        }
      }

      async function bipaKit(itensKit) {

        async function retornaBarrasKit(itens) {
          const sTabela = pegaChave("#txtTabela");
          const sDeposito = pegaChave("#txtDeposito");
          const iLancamento = $('#txtLancamento').val() != '' ? $('#txtLancamento').val() : 0;
          const sQualidade = pegaChave('#txtQualidade');
          const url = `/Sisplan/Estoque/v1/barra?`;
          const arrayBarras = [];
          await Promise.all(itens.filter((it) => it.QTDE && it.QTDE > 0).map(async (item) => {

            const dadosBarraKit = {
              tabela: "PA_ITEN",
              camposSelect: [
                "BARRA",
                "BARRACLI",
                "BARRA28",
                "ID"
              ],
              where: [`CODIGO = '${item.CODIGO}' AND COR = '${item.COR}' AND TAM = '${item.TAM}' AND DEPOSITO = '${sDeposito}' `],
            };

            const json = await retornaJsonPesquisaPadrao(JSON.stringify(dadosBarraKit));
            if (json) {
              if (json[0].BARRA != '') {
                arrayBarras.push({
                  QUANTIDADE: item.QTDE,
                  BARRA: json[0].BARRA,
                  IDITEM: json[0].ID
                });
              } else if (json[0].BARRACLI != '') {
                arrayBarras.push({
                  QUANTIDADE: item.QTDE,
                  BARRA: json[0].BARRACLI,
                  IDITEM: json[0].ID
                });
              } else if (json[0].BARRA28 != '') {
                arrayBarras.push({
                  QUANTIDADE: item.QTDE,
                  BARRA: json[0].BARRA28,
                  IDITEM: json[0].ID
                });
              } else {
                arrayBarras.push({
                  QUANTIDADE: item.QTDE,
                  BARRA: '',
                  IDITEM: json[0].ID
                });
              }
            }
          }));

          return arrayBarras
        }

        try {
          const barrasKit = await retornaBarrasKit(itensKit);
          $('#txtCodigo').prop('disabled', true)
          for (const barra of barrasKit) {
            $('#txtQuantid').val(barra.QUANTIDADE);
            $('#txtCodigo').val(barra.BARRA);
            $('#txtIdItem').val(barra.IDITEM);

            await RotinaSaidaCodigo();
          }
        } catch (error) {
          console.error(error);
        } finally {
          $('#txtCodigo').prop('disabled', false)
        }

      }

      async function verificaKit() {
        try {
          const dadosPesquisaKit = {
            tabela: "KIT_ITEM",
            camposSelect: [
              "NUMERO",
              "CODIGO",
              "COR",
              "TAM",
              "DESCRICAO",
              "QTDE",
              "ATIVO",
            ],
            where: [`NUMERO = '${$('#txtCodigo').val()}'`],
          };

          const json = await retornaJsonPesquisaPadrao(JSON.stringify(dadosPesquisaKit));

          if (json && json.length > 0) {
            bipaKit(json);
            return true;
          } else {
            return false;
          }

        } catch (error) {
          console.error(error);
        }
      }

      async function RotinaSaidaCodigo(tipo = 'P', numeroPed = '', ordemPed = 0, caixaPed = '', semFoco = false, codigoMaterial = '', corMaterial = '', vBrinde = 0, codigoRegra = 0) {
        let vQtde = ''
        let mostrouAlerta = false;
        const utilizaBarraLog = parametrosVenda[46] != '0';
        const bUsaIntegraçãoITAG = parametrosVenda[60] == 1 || parametrosVenda[60] == 2;
        if ((($('#txtCodigo').val().trim() == "") || ($('#txtCodigo').val() == "-")) && ($('#txtIdItem').val().trim() == "")) {
          return;
        }

        if ($('#txtCodigo').val().substr($('#txtCodigo').val().length - 1) == '*') {
          return;
        }

        let bEstorno = false;
        let bJaEstornou = false;
        let emptyStr = "'";
        const vendaEmAlteracao = ((numero_venda != 'create') && (numero_venda != 'create#'));
        const bloqueiaExcluirItem = infoTipoVenda[0].EXCLUSAO_ITEM === 2 && vendaEmAlteracao;
        const pedeSenhaSupervisaoExclusaoItem = infoTipoVenda[0].EXCLUSAO_ITEM === 1 && vendaEmAlteracao;
        const bDepositoEcommerce = isChecked('#cbDepositoEcommerce') && ($('#modalProduto').is(':visible') || bDblclickModalProduto);
        const bAgrupaItens = sDepositoEcommerce != '' ? false : parametrosVenda[61] != 0;
        if (bDepositoEcommerce) {
          $('#txtDepositoItem').val(sDepositoEcommerce.substring(1, sDepositoEcommerce.indexOf("]")));
        }

        try {
          if ($("#txtCodigo").val().substring(0, 1).indexOf("-") >= 0) {
            if (bloqueiaExcluirItem) {
              msgAlerta('Não é possível excluir o item para o tipo de venda: ' + infoTipoVenda[0].DESCRICAO);
              SomAlerta('<?php echo BASE_URI; ?>', true);
              return;
            }
            $("#txtCodigo").val($("#txtCodigo").val().substring(1, $("#txtCodigo").val().length));
            bEstorno = true;
            // $("#txtQuantid").val(1);
          }

          if ($('#btnMenosOuMais>i.fa-minus').length > 0) {
            if (bloqueiaExcluirItem) {
              msgAlerta('Não é possível excluir o item para o tipo de venda: ' + infoTipoVenda[0].DESCRICAO);
              SomAlerta('<?php echo BASE_URI; ?>', true);
              return;
            }
            bEstorno = true;
          }

          if ($('#txtCodigo').val().indexOf("*") > 0) {
            $("#txtQuantid").val($("#txtCodigo").val().substring(0, $('#txtCodigo').val().indexOf("*")));
            $("#txtCodigo").val($("#txtCodigo").val().substring($('#txtCodigo').val().indexOf("*") + 1, $('#txtCodigo').val().length));
          }
          if ($('#txtCodigo').val().length > 50) {
            msgAlerta('Código de barras não pode ter mais de 50 digitos, verifique.');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            return;
          }

          var sTabela = pegaChave("#txtTabela", sTabela);

          let indexItem = -1;
          let sCodigo = $('#txtCodigo').val().trim();
          let sIdItem = $('#txtIdItem').val();
          const sDeposito = $('#txtDepositoItem').val() != '' ? $('#txtDepositoItem').val() : pegaChave('#txtDeposito');
          let sCodigoEPC = $('#txtCodigoEPC').val();
          const dataItensRelacionados = $('#tabelaItens').DataTable().rows(".linha-prodRelac").data().toArray().length > 0;
          const parametroQtdeMaximaItens = parametrosVenda[106] ?? 0;

          if (utilizaBarraLog) {
            if (parametrosSistema[3] != 0) {
              let sBarraLogEPC = await retornaBarraLogEPC(sCodigo);
              if (sBarraLogEPC !== '') {
                sCodigo = sBarraLogEPC
              }
            }
          }

          if (formataNumerico($("#txtCodigo").attr("quantidadeItem") ?? "0") == 0) {
            vQtde = formataNumerico($('#txtQuantid').val()); // parseFloat($('#txtQuantid').val().toString());
          } else {
            vQtde = formataNumerico($("#txtCodigo").attr("quantidadeItem"));
          }

          if (isNaN(vQtde)) {
            vQtde = 1;
          }

          if (vQtde < 0) {
            msgErro('Quantidade deve ser maior que zero');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            return;
          }

          if ((!bEstorno) && (parametroQtdeMaximaItens != '') && (parametroQtdeMaximaItens > 0)) {
            const totalRegistrosTabela = $('#tabelaItens').DataTable().data().toArray().length;
            if (totalRegistrosTabela == parametroQtdeMaximaItens) {
              msgAlerta(`Venda atingiu o limite máximo de itens permitidos (${parametroQtdeMaximaItens}), conforme configurado para a Empresa.`);
              return;
            }
          }


          if (retornaQtdeCasasDecimais(vQtde) > 3) {
            msgErro('Quantidade de casas decimais ultrapassada, máximo 3. (Ex: 12,125)');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            return;
          }

          if ($('#tabelaItens').DataTable().rows().count() === 0) {
            await verificaTabelaPrecoKG()
          }

          let vQtdeGrid = 0;

          let jsonStr = await retornaDadosBarra(sCodigo, sIdItem, tipo == 'M' ? codigoMaterial : '', tipo == 'M' ? corMaterial : '', tipo, bEstorno, sDeposito);

          if (!jsonStr) {
            return;
          }

          // await sleep(500);
          let tipoVendaEhConsig = await buscaValor('VENDA_TIPO', 'CONSIGNADO', 'ID', $('#txtTipoVenda').val());
          if (tipoVendaEhConsig == 'S') {
            let permiteConsig = '';
            const grupo = await buscaValor('PRODUTO', 'GRUPO', 'CODIGO', jsonStr[0].CODIGO);
            permiteConsig = await buscaValor('GRUPO_PA', 'PERMITE_CONSIG', 'CODIGO', grupo);
            if (permiteConsig == 'N') {
              throw msgAlerta('Grupo do produto não permite consignado, verifique!');
            }
          }

          if (jsonStr[0].TIPO == 'M' && $("#txtQuantid").val() == '' && formataNumerico($("#txtCodigo").attr("quantidadeItem") ?? "0") == 0) {
            vQtde = jsonStr[0].ESTOQUE == 0 ? 1 : jsonStr[0].ESTOQUE;
          }

          let vEstoque = Number(jsonStr[0].ESTOQUE.toString());
          let paramEstoque = parametrosVenda[4]; //0 - bloqueia // 1 - permite //2 - permite sem mensagem;

          let vBarraUtilizada = jsonStr[0].BARRA != '' ? jsonStr[0].BARRA : jsonStr[0].BARRA28;
          let qualidade = jsonStr[0].QUALIDADE;
          vBarraUtilizada = vBarraUtilizada != '' ? vBarraUtilizada : jsonStr[0].BARRACLI;
          const vendedorItem = $('#txtVendedorItem').val() !== '' ? pegaChave('#txtVendedorItem') : pegaChave('#txtVendedor');
          let sCodigoValidacao = jsonStr[0].TIPO != 'M' ? jsonStr[0].CODIGO + ' - ' + jsonStr[0].COR + ' - ' + jsonStr[0].TAM + ' - ' + qualidade :
            jsonStr[0].CODIGO + ' - ' + jsonStr[0].COR + ' - ' + jsonStr[0].TAM + ' - ' + qualidade + ' - ' + jsonStr[0].LOTE;
          indexItem = $('#tabelaItens').DataTable().column(16).data().indexOf(sCodigoValidacao);
          const arrayItensIguais = $('#tabelaItens').DataTable().data().toArray().filter((item) => {
            return item[19] != 'M' ? item[0] == jsonStr[0].CODIGO && item[10] == jsonStr[0].COR && item[11] == jsonStr[0].TAM :
              item[0] == jsonStr[0].CODIGO && item[10] == jsonStr[0].COR && item[11] == jsonStr[0].TAM && item[18] == jsonStr[0].LOTE && jsonStr[0].DEPOSITO == item[33]
          })
          arrayItensIguais.forEach((item => {
            vQtdeGrid = vQtdeGrid + item[2];
          }));

          if (!await produtoAtivo(jsonStr[0].CODIGO, jsonStr[0].TIPO)) {
            await aguardaMsgAlerta('Item não esta ativo. Impossivel continuar', () => {});
            SomAlerta('<?php echo BASE_URI; ?>', true);
            return;
          };

          if (utilizaBarraLog) {
            if (!bEstorno) {
              if (await barraJaEstaBipada(sCodigo)) {
                return;
              } else {
                if (await adicionaBarraBipada(sCodigo)) {
                  vQtde = 1;
                }
              }
            }
          }

          // if (bUsaIntegraçãoITAG) {
          //   const item = {
          //     codigo: jsonStr[0].CODIGO,
          //     cor: jsonStr[0].COR,
          //     tam: jsonStr[0].TAM,
          //     barra: sCodigoEPC
          //   }
          //   if (bEstorno) {
          //     await estornaBarraBipadaEPC(sCodigoEPC);
          //   } else {
          //     if (await adicionaBarraBipadaEPC(sCodigoEPC)) {
          //       vQtde = 1;
          //     }
          //   }
          // }

          const movimentaEstoque = await BuscaTiposVenda($('#txtTipoVenda').val());
          if (movimentaEstoque[0].ESTOQUE == 'S') {
            if (((vEstoque < (vQtde + vQtdeGrid)) || (vEstoque <= 0)) && (!bEstorno)) {
              switch (paramEstoque) {
                case '0':
                  await aguardaMsgAlerta(`Estoque insuficiente para o produto: ${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}, cor: ${jsonStr[0].COR} - ${jsonStr[0].DESC_COR}, tamanho: ${jsonStr[0].TAM}`, () => {});
                  await estornaBarraBipada(sCodigo, 'create');
                  SomAlerta('<?php echo BASE_URI; ?>', true);
                  $('#txtCodigoEPC').val('');
                  return;
                  break;
                case '1':
                  if (!semFoco) {
                    await aguardaMsgAlerta(`Estoque insuficiente para o produto: ${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}, cor: ${jsonStr[0].COR} - ${jsonStr[0].DESC_COR}, tamanho: ${jsonStr[0].TAM}`, focaCampo);
                  } else {
                    await aguardaMsgAlerta(`Estoque insuficiente para o produto: ${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}, cor: ${jsonStr[0].COR} - ${jsonStr[0].DESC_COR}, tamanho: ${jsonStr[0].TAM}`, () => {});
                  }
                  $('#txtCodigo').val('');
                  $('#txtIdItem').val('');
                  $('#txtCodigoEPC').val('');
                  mostrouAlerta = true;
                  break;
                case '2':
                  break;
              }
            }
          }

          if (!bEstorno) {
            if ((sCodigo != emptyStr + emptyStr) && (sTabela != emptyStr + emptyStr)) {
              try {
                const sProduto = '[' + jsonStr[0].CODIGO + '] - ' + jsonStr[0].DESCRICAO;
                const sCor = '[' + jsonStr[0].COR + '] - ' + jsonStr[0].DESC_COR;
                const sTam = '[' + jsonStr[0].TAM + '] - ' + jsonStr[0].TAM;

                let sPreco = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(jsonStr[0].PRECO, quantidadeCasasDecimaisCampo)) :
                  TruncaDecimaisNova(2, jsonStr[0].PRECO);
                let sPrecoOrig = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(jsonStr[0].PRECO, quantidadeCasasDecimaisCampo)) :
                  TruncaDecimaisNova(2, jsonStr[0].PRECO);
                let sPrecoOrigOld = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(jsonStr[0].PRECO, quantidadeCasasDecimaisCampo)) :
                  TruncaDecimaisNova(2, jsonStr[0].PRECO);

                if (vBrinde != 0) {
                  sPreco = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(vBrinde, quantidadeCasasDecimaisCampo)) :
                    TruncaDecimaisNova(2, vBrinde);
                  sPrecoOrig = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(vBrinde, quantidadeCasasDecimaisCampo)) :
                    TruncaDecimaisNova(2, vBrinde);
                  sPrecoOrigOld = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(vBrinde, quantidadeCasasDecimaisCampo)) :
                    TruncaDecimaisNova(2, vBrinde);
                }

                if (await produtoComStatusBloqueioVenda(jsonStr[0].CODIGO)) {
                  msgAlerta(`Produto ${jsonStr[0].CODIGO} com Status de bloqueio para digitação de venda.`);
                  return;
                }

                $('#txtProduto').val(sProduto);
                $('#txtCor').val(sCor);
                $('#txtTamanho').val(sTam);
                $('#txtPreco').val(sPreco);
                $('#txtQuantid').val(vQtde);

                let itemUsaRegraPromocaoIgualdade = false
                if (indexItem != -1) {
                  itemUsaRegraPromocaoIgualdade = await verificaRegraIgualdadeAplicadaNoItem(indexItem)
                  if (itemUsaRegraPromocaoIgualdade) {
                    indexItem = $('#tabelaItens').DataTable().data().toArray().map(item => item[16] + ' - ' + item[31]).indexOf(sCodigoValidacao + ' - 0');
                  }
                }
                if ((indexItem >= 0) && (bAgrupaItens)) {
                  let dataOld = $('#tabelaItens').DataTable().row(indexItem).data();
                  dataOld[2] = parseFloat((dataOld[2] + vQtde).toFixed(2));
                  dataOld[7] = parseFloat(dataOld[2] * dataOld[4]).toFixed(2);
                  $('#tabelaItens').DataTable().row(indexItem).data(dataOld);
                  SomAlerta();
                } else {
                  const soma = +(sPreco * vQtde).toFixed(4);

                  const itemTemProductoRelacionado = jsonStr[0].TIPO != 'M' ? await retornaSeProdutoTemRelacionamento(jsonStr[0].CODIGO) : false;
                  if (itemTemProductoRelacionado) {
                    $('.itemRelacionado').removeClass('d-none')
                    $('.itemRelacionado').addClass('d-flex')
                  }
                  const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
                  const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : TruncaDecimaisNova(2, parseFloat(soma));
                  let valorDesc = 0;
                  if (numeroPed != '') {
                    const somaPrecoOrig = +(sPrecoOrig * vQtde).toFixed(4);
                    const calculoTotalPrecoOrig = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(somaPrecoOrig, 3) : TruncaDecimaisNova(2, parseFloat(somaPrecoOrig));
                    valorDesc = calculoTotalPrecoOrig - calculoTotal;
                    if (valorDesc < 0) {
                      valorDesc = 0;
                    }
                  }
                  const agrupamentoItem = jsonStr[0].TIPO != 'M' ? jsonStr[0].CODIGO + ' - ' + jsonStr[0].COR + ' - ' + jsonStr[0].TAM + ' - ' + qualidade :
                    jsonStr[0].CODIGO + ' - ' + jsonStr[0].COR + ' - ' + jsonStr[0].TAM + ' - ' + qualidade + ' - ' + jsonStr[0].LOTE;

                  const descricaoItem = jsonStr[0].CODIGO + ' - ' + jsonStr[0].DESCRICAO + ' - ' +
                    jsonStr[0].COR + ' - ' + jsonStr[0].DESC_COR + ' - ' + jsonStr[0].TAM
                  SomAlerta();
                  adicionaItens([
                    jsonStr[0].CODIGO,
                    descricaoItem,
                    vQtde,
                    sPrecoOrig,
                    sPreco,
                    0,
                    valorDesc,
                    calculoTotal,
                    await retornaBotaoOpcoes(),
                    vBarraUtilizada,
                    jsonStr[0].COR,
                    jsonStr[0].TAM,
                    jsonStr[0].DESC_COR,
                    jsonStr[0].QUALIDADE,
                    jsonStr[0].ID_ESTOQUE,
                    0,
                    agrupamentoItem,
                    $('#cb_presente:checked').length > 0,
                    jsonStr[0].LOTE,
                    bDepositoEcommerce ? 'E' : jsonStr[0].TIPO,
                    0,
                    0,
                    0,
                    numeroPed,
                    ordemPed,
                    caixaPed,
                    vendedorItem,
                    `${formataData(new Date())}T00:00:00Z`,
                    jsonStr[0].UNIDADE,
                    jsonStr[0].PROMOCAO == 'S',
                    sPrecoOrigOld,
                    codigoRegra,
                    codigoRegra == 0 ? "" : "Brinde",
                    sDeposito,
                    pegaChave('#txtTabela'),
                    itemTemProductoRelacionado,
                    '', //lote orig
                    jsonStr[0].TIPO == 'M' ? jsonStr[0].QTDE_ORIG : 0,
                    0 // Valor de IPI do item
                  ]);

                  if (bAplicaDescMaxTabPrecoVenda || bAplicaDescMaxTabPrecoVendaNotAlterar) {
                    const descMaxTabPreco = await retornaDescMaxTabPreco(jsonStr[0].CODIGO, sTabela);
                    if (descMaxTabPreco > 0) {
                      const indexItem = $("#tabelaItens").DataTable().data().toArray().findIndex(registro => {
                        return registro[1] == descricaoItem
                      })
                      const idRow = $("#tabelaItens tbody tr")[indexItem];
                      await criaTelaDesconto(idRow, false);
                      $("#txtPercDesconto").val(descMaxTabPreco.toLocaleString("pt-BR", {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2,
                      }));
                      $("#txtPercDesconto").trigger("blur");
                      await eventoClickPesquisaDescontoConfirmar(idRow);
                    }
                  } else if (g_DescCliente > 0) {
                    const indexItem = $("#tabelaItens").DataTable().data().toArray().findIndex(registro => {
                      return registro[1] == descricaoItem
                    })
                    const idRow = $("#tabelaItens tbody tr")[indexItem];
                    await criaTelaDesconto(idRow, false);
                    $("#txtPercDesconto").val(g_DescCliente.toLocaleString("pt-BR", {
                      minimumFractionDigits: 2,
                      maximumFractionDigits: 2,
                    }));
                    $("#txtPercDesconto").trigger("blur");
                    await eventoClickPesquisaDescontoConfirmar(idRow, false); // 304531 - quando o desconto for do cliente não deve solicitar senha supervisor
                  }

                  $('[data-toggle="tooltip"]').tooltip();
                }
                if (((parametrosVenda[29] == 1) && (pegaChave('#txtRegraPromocao') != '')) || (parametrosVenda[29] == 2)) {
                  await eventoClickBtnRecalcularRegra();
                }

                if (dataItensRelacionados) {
                  await validaItensRelacionados();
                }

                let venda = {};
                venda = await montaJsonVenda(venda, numero_venda, 'P', false);
                salvaDadosDigitados(venda);
                $('#txtCodigo').val('');
                $('#txtIdItem').val('');
                $('#txtCodigoEPC').val('');
                if (!semFoco) {
                  focaCampo();
                }
                $.LoadingOverlay("hide");
              } catch (error) {
                SomAlerta('<?php echo BASE_URI; ?>', true);
                $.LoadingOverlay("hide");
                console.error(error);
                await aguardaMsgAlerta('Não foi possível buscar os dados da barra.', () => {});
              }

              if ((parametrosVenda[87] == 1) && (jsonStr[0].TIPO == 'P')) {
                await reservaProduto(jsonStr[0].ID_ESTOQUE, vQtde);
              }
            }
          } else {
            async function estornaItem(vCodigo) {

              const itens = $("#tabelaItens").DataTable().data().toArray();
              const indexItemTabela = itens.findIndex(registro => {
                return registro[16] == vCodigo
              });

              if (indexItemTabela == -1) {
                msgAlerta('Barra não encontrada para estorno, verifique.');
                return;
              }

              const barraJaFoiRemovida = listaBarrasRemovidasTemp.filter(item => item == sCodigo).length > 0;
              if (barraJaFoiRemovida) {
                msgAlerta('Barra já foi estornada, verifique.');
                return;
              }

              if (utilizaBarraLog) {
                const retornoBarraLog = await retornaBarraLogLida(sCodigo);
                if (['barra_log'].includes(retornoBarraLog)) {
                  const barraNaoFoiBipada = listaBarrasBipadas.filter(item => item == sCodigo).length == 0;
                  if (barraNaoFoiBipada) {
                    msgAlerta('Barra não encontrada para estorno, verifique.');
                    return;
                  }
                }
              }

              await estornaBarraBipada(sCodigo, numero_venda);

              if (itens[indexItemTabela][2] === vQtde) {
                $("#tabelaItens").DataTable().row(indexItemTabela).remove().draw(false);
              } else {
                dataOld = $("#tabelaItens").DataTable().row(indexItemTabela).data();
                dataOld[2] = dataOld[2] - vQtde;
                dataOld[7] = parseFloat(dataOld[2] * dataOld[4]).toFixed(2);
                if (dataOld[2] < formataNumerico($("#txtQuantid").val())) {
                  $("#tabelaItens").DataTable().row(indexItemTabela).remove().draw(false);
                } else {
                  $("#tabelaItens").DataTable().row(indexItemTabela).data(dataOld);
                }
              }

              SomAlerta();
              $('#txtCodigo').val('');
              $('#txtIdItem').val('');
              $('#txtCodigoEPC').val('');
              if (!semFoco) {
                focaCampo();
              }
              if (((parametrosVenda[29] == 1) && (pegaChave('#txtRegraPromocao'))) || (parametrosVenda[29] == 2)) {
                removeRegraPromocao();
                await eventoClickBtnRecalcularRegra(true);
                if (bAplicaDescMaxTabPrecoVenda || bAplicaDescMaxTabPrecoVendaNotAlterar) {
                  await reaplicaDescMax();
                }
              }
              let venda = {};
              venda = await montaJsonVenda(venda, 'create', 'P', false);
              salvaDadosDigitados(venda);
              atualizaTotalVenda();
            }

            if (pedeSenhaSupervisaoExclusaoItem) {
              var vCodigo = $('#txtCodigo').val();
              await senhaSupervisor('Exclusão de item da venda', estornaItem, vCodigo, false, undefined, undefined, undefined, false, 'VENDA', numero_venda == 'create' || numero_venda == 'create#' ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda, pegaChave('#txtCliente'), parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0);
            } else {
              await estornaItem(sCodigoValidacao);
            }
          }

          if ((indexItem >= 0) && (bAgrupaItens)) {
            if (!$(`#tabelaItens tbody tr:eq(${indexItem})`).hasClass('selected')) {
              $(`#tabelaItens tbody tr:eq(${indexItem})`).trigger('click');
              $('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
            }
          } else {
            if (!$('#tabelaItens tbody tr:last-child').hasClass('selected')) {
              $('#tabelaItens tbody tr:last-child').trigger('click');
              $('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
            }
          }
          // $('#txtQuantid').val(1);
        } finally {
          if ($("#radioMaterial").prop("checked")) {
            $('#txtQuantid').val('');
          } else {
            $('#txtQuantid').val(1);
          }
          if ($('#cb_presente:checked').length > 0) {
            $('#cb_presente').trigger('click')
          }
          $('#txtCodigo').val('');
          $('#txtIdItem').val('');
          $('#txtCodigoEPC').val('');
          bDblclickModalProduto = false;
          $('[data-toggle="tooltip"]').tooltip();
          if (!semFoco) {
            focaCampo();
          }
          atualizaTotalVenda();
          if (!$('#btn-desdobrar-malha').hasClass('d-none')) {
            $('#total_rolos_itens').html('Rolos: ' + $('#tabelaItens').DataTable().rows().count());
          }
          if (bDepositoEcommerce) {
            $('#txtDepositoItem').val('');
          }
        }
      }

      async function validaCupomDeDesconto(codigoCupom) {
        try {
          const empId = getCookie('emp_id');
          const validaNumeroVenda = numero_venda && typeof(numero_venda) == 'number' ? `AND CODVEN <> ${numero_venda}` : '';
          const dadosItens = $('#tabelaItens').DataTable().data().toArray();
          const dadosCondicoes = $('#tabelaCondicoesDePagamento').DataTable().data().toArray();
          let percDescJaAplicado = $('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total += parseFloat(item[5])
          }, 0);
          const valorDescJaAplicado = $('#tabelaItens').DataTable().data().toArray().reduce((total, item) => {
            return total += (parseFloat(item[3]) - parseFloat(item[4])) * parseFloat(item[2])
          }, 0);

          if (codigoCupom == '') {
            msgErro('Informe um cupom para aplicar.');
            $('#txtCupomDesconto').val('');
            return false;
          }

          if (dadosItens.length === 0) {
            msgErro('Nenhum item na venda, impossível aplicar cupom.');
            $('#txtCupomDesconto').val('');
            return false;
          }

          if (dadosCondicoes.length > 0) {
            msgErro('Condições de Pagamento já informadas, impossível aplicar cupom.');
            $('#txtCupomDesconto').val('');
            return false;
          }

          // if (percDescJaAplicado > 0) {
          //   msgErro('Venda já possui desconto, impossível aplicar cupom.');
          //   $('#txtCupomDesconto').val('');
          //   return false;
          // }

          const pesquisa = {
            tabela: 'CUPOMDESCONTO',
            camposSelect: ['PERC_DESC', 'VALOR', 'DESCRICAO'],
            where: [`CODIGO IN (SELECT VALOR FROM [EMP_VALOR] WHERE TABELA = 'CUPOMDESCONTO' AND CAMPO = 'CODIGO' AND EMP_ID = ${empId} AND VALOR = '${codigoCupom}')`,
              `((DT_INICIO <= CURRENT_DATE) AND (DT_FINAL >= CURRENT_DATE))`,
              `QUANTIDADE > (SELECT COUNT(*) FROM [VENDA] WHERE CUPOM_DESCONTO = '${codigoCupom}' ${validaNumeroVenda})`,
              `((CODCLI = '') or (CODCLI IS NULL) or (CODCLI = '${pegaChave('#txtCliente')}'))`
            ],
          }

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          if (jsonStr.length > 0) {
            let bValor = false;
            let descontoCadastrado = jsonStr[0].PERC_DESC;
            if ((descontoCadastrado > 0) && (percDescJaAplicado > 0)) {
              const valorLiq = parseFloat($('#txtValorLiquidoMoeda').val());
              const valorBruto = parseFloat($('#txtValorLiquidoMoeda').val()) + valorDescJaAplicado;
              const valorDesc = valorLiq * (descontoCadastrado / 100);
              percDescJaAplicado = (100 - (((valorBruto - (valorDescJaAplicado + valorDesc)) / valorBruto) * 100));
              descontoCadastrado = parseFloat(percDescJaAplicado);
            }
            const valorDesconto = jsonStr[0].VALOR;
            if (valorDesconto > 0) {
              bValor = true;
              const valorLiq = parseFloat($('#txtValorLiquidoMoeda').val()) + valorDescJaAplicado;
              descontoCadastrado = (100 - (((valorLiq - (valorDesconto + valorDescJaAplicado)) / valorLiq) * 100));
            }
            tabelaItensCupomDesc = JSON.parse(JSON.stringify($("#tabelaItens").DataTable().rows().data().toArray()));
            await AplicaDescontoVenda(descontoCadastrado, false, false);
            const msg = bValor ? `R$ ${valorDesconto.toFixed(2).replaceAll('.',',')}` : `${jsonStr[0].PERC_DESC}%`;
            msgSucesso(`Cupom de Desconto de ${msg} aplicado com sucesso.`);
            await atualizaSaldoAPagar();
            await atualizaTotaisPagto();
            await atualizaTotalVenda();
            return true;
          }
          msgAlerta('Cupom de desconto inválido.');
          $('#txtCupomDesconto').val('');
          return false;
        } catch (err) {
          msgErro('Erro ao validar cupom de Desconto.');
          $('#txtCupomDesconto').val('');
          console.error(err);
          return false;
        }
      }

      $('#btnAplicarCupomDesconto').on('click', async function() {
        const naoSelecionado = !$('#txtCupomDesconto').prop('disabled');
        const cupomDesconto = $("#txtCupomDesconto").val().toUpperCase();

        if ($('#tabelaCondicoesDePagamento').DataTable().data().toArray().length > 0) {
          msgErro('Condições de pagamento já informadas, impossível continuar.');
          if (naoSelecionado) {
            $('#txtCupomDesconto').val('');
          }
          return;
        }

        if (naoSelecionado) {
          if (await validaCupomDeDesconto(cupomDesconto)) {
            $('#btnAplicarCupomDesconto>i').removeClass('fa-check').addClass('fa-trash');
            $('#txtCupomDesconto').prop('disabled', true);
            $('#btnAplicarCupomDesconto').attr('title', 'Remover Cupom');
            let venda = {};
            venda = await montaJsonVenda(venda, numero_venda, 'P', false);
            salvaDadosDigitados(venda);
          }
        } else {
          $('#btnAplicarCupomDesconto>i').removeClass('fa-trash').addClass('fa-check');
          $('#txtCupomDesconto').prop('disabled', false);
          $('#txtCupomDesconto').val('');
          $('#btnAplicarCupomDesconto').attr('title', 'Aplicar Cupom');
          if (tabelaItensCupomDesc) {
            $("#tabelaItens").DataTable().clear().rows.add(tabelaItensCupomDesc).draw(false);
          } else {
            await AplicaDescontoVenda(0, false, false);
          }
          await atualizaTotalVenda();
          await atualizaSaldoAPagar();
          await atualizaTotaisPagto();
          msgSucesso(`Cupom de Desconto removido com sucesso.`);
        }
      });

      $('#modal-warning').on('shown.bs.modal', function() {
        $('#btn-msg-alerta').focus();
      });

      $('#modalProduto').on('show.bs.modal', function() {
        ativaBuscaFotosProdMat = true;
      });

      $('#modalProduto').on('hide.bs.modal', function() {
        ativaBuscaFotosProdMat = false;
      });

      $('#cb_presente').on('click', function() {
        focaCampo();
      });

      $('#abreAjuda').on('click', function() {
        $('.subatalho').trigger('click');
        criaTelaAjuda();
      });

      $('#btnCancelarVenda').on('click', function() {
        msgAlerta(
          `Ao clicar em Confirmar você irá perder os dados que não foram salvos. Deseja realmente cancelar ? `,
          async function() {
            var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}-V`;
            if ((numero_venda != 'create') && (numero_venda != 'create#')) {
              await deletaRegistro('LOJA', getCookie('usuario'), numero_venda);
            }
            await deletaVendaNaoSalva(hostname + '.txt');
            const chave = (numero_venda != 'create') && (numero_venda != 'create#') ? numero_venda : 'NOVA';
            await rotinaGeraLog('VENDA', chave, `USUARIO ${getCookie('usuario')} desistiu da venda ${chave}, para o cliente ${pegaChave('#txtCliente')}, no valor de ${$("#subtotal_venda").html()}.`);
            if (parametrosVenda[87] == 1) {
              await deletaReservaProduto();
            }
            window.location.href = "<?php echo BASE_URI; ?>/venda/create";
          });
      });

      //eventos combinação de teclas
      $('#btnConfirmarTrocoNfce, #btnConfirmarTrocoNfe, #btnConfirmarTroco').on('keydown', (e) => {
        const keyCode = e.keyCode || e.which;
        if (keyCode == 13) {
          $(e.target).trigger('click');
        }
      });


      $("body").keydown(async function(e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode == 112) {
          e.preventDefault();
        } else
        if (keyCode == 113) {
          e.preventDefault();
          let cnpjClientePadrao = pegaChave(parametrosVenda[3]) != '' ? await RetornaCNPJ(pegaChave(parametrosVenda[3])) : '';
          $('#modal-cliente').modal('show');
          if ($('#txtCNPJ').val() == '') {
            $('#btnModalNovoCliente').trigger('click');
            $('#cbTipoCliente').prop('checked', true);
          } else if (cnpjClientePadrao != formata_cpf_cnpj($('#txtCNPJ').val())) {
            $('#txtCNPJModalCli').val($('#txtCNPJ').val());
            $('#txtCNPJModalCli').change();
          } else {
            $('#btnModalNovoCliente').trigger('click');
            $('#cbTipoCliente').prop('checked', true);
          }
        } else
        if (keyCode == 114) {
          e.preventDefault();
          $('#btn-info-cliente').focus();
          $('#btn-info-cliente').trigger('click');
        } else if (keyCode == 115) {
          e.preventDefault();
          if ($('#fieldset_venda').css('display') != 'none') {
            $('#btn-codigo').trigger('click');
          }
        } else if (keyCode == 116) {
          e.preventDefault();
          $("#btnInfo").trigger('click');
        } else
        if (keyCode == 117) {
          e.preventDefault();
          if (window.event.altKey) {
            await $('#modalPrecos').modal('show');
          } else {
            $("#btnVenda").trigger('click');
          }
        } else
        if (keyCode == 118) {
          e.preventDefault();
          $("#btnPagamento").trigger('click');
        } else
        if ((!e.ctrlKey) && ((keyCode == 119)) && (!$('#btnFinalizar').prop('disabled')) && (!$('#modal-supervisor').hasClass('show'))) {
          e.preventDefault();
          $("#btnFinalizar").click();
          //$('#btnFinalizar').prop('disabled', true);
        } else
        if (keyCode == 120) {
          e.preventDefault();
          if ((parametrosVenda[112] == '1') && ($('#txtCNPJ').val().length > 14)) {
            return;
          }
          if (!$('#btnNFCE').hasClass('d-none')) {
            $("#btnNFCE").trigger('click');
          } else if (!$('#btnCFe').hasClass('d-none')) {
            $("#btnCFe").trigger('click');
          }
        } else if ((keyCode == 121) && (!$('#btnFinalizar').prop('disabled'))) {
          e.preventDefault();
          fechaF10 = true;

          if (!UsuarioPodeGravarCondicoes) {
            const numlinhas = $('#tabelaCondicoesDePagamento').DataTable().rows()[0].length;
            let algumaMoedaUsaTroco = false;

            for (let i = 0; i < numlinhas; i++) {
              const dado = $('#tabelaCondicoesDePagamento').DataTable().row(i).data();
              const iMoeda = dado[6];
              const possuiTroco = await moedaPossuiTroco(iMoeda);

              if (algumaMoedaUsaTroco == true) { // se não possuir troco
                break;
              } else {
                algumaMoedaUsaTroco = possuiTroco;
              }
            }

            if ((algumaMoedaUsaTroco == true)) {
              await verificaEAbreTroco();
            } else {
              await RotinaFinalizarVenda(false, true);
            }
          }

          // $('#btnFinalizar').prop('disabled', true);
        } else if (keyCode == 123) {
          e.preventDefault();
          //nada acontece... não ver o fonte
        } else if (e.which === 66 && e.altKey) {
          e.preventDefault();
          let parametrosVenda = await BuscaParametrosVenda();
          let sPeso = await buscaPesoBalanca(parseFloat(parametrosVenda[17]), parametrosVenda[74]);
          if ($('#modalQuantidade').hasClass('show')) {
            $('#txtItemQuantidade').val(sPeso);
          } else {
            $('#txtQuantid').val(sPeso);
          }
          //nada acontece... não ver o fonte
        } else if ((e.altKey && keyCode == 49) && (bUsaIntegraçãoITAG) && (!$('#btn-iniciar-epc').prop('disabled'))) { //Alt + 1 inicia leitura rfid
          e.preventDefault();
          $('#btn-iniciar-epc').trigger('click');
        } else if ((e.altKey && keyCode == 50) && (bUsaIntegraçãoITAG) && (!$('#btn-parar-epc').prop('disabled'))) { //Alt + 2 para leitura rfid
          e.preventDefault();
          $('#btn-parar-epc').trigger('click');
        }
      });

      async function verificaEAbreTroco() {
        let totalVenda = parseFloat(($("#txtTotalVenda").html().replaceAll('.', '')).replace(',', '.'));
        let valorPago = 0;
        let valorDesconsiderar = 0;
        const numlinhas = $('#tabelaCondicoesDePagamento').DataTable().rows()[0].length;
        for (let i = 0; i < numlinhas; i++) {
          const dado = $('#tabelaCondicoesDePagamento').DataTable().row(i).data();
          const iMoeda = dado[6];
          const possuiTroco = await moedaPossuiTroco(iMoeda);

          if (possuiTroco == false) { // se não possuir troco
            valorPago = valorPago + parseFloat(dado[4]);
          } else {
            valorDesconsiderar = valorDesconsiderar + parseFloat(dado[4]);
          }
        }
        $('#modalTroco').modal('show');
        $('#txtValorVendaTroco').val(parseFloat(totalVenda).toFixed(2));
        $('#txtValorPagoVendaTroco').val(parseFloat(valorPago).toFixed(2));
        $('#txtValorPagarTroco').val(parseFloat(valorDesconsiderar).toFixed(2));
        $('#txtValorPagoTroco').val(parseFloat(valorDesconsiderar).toFixed(2));
        $('#txtTroco').val(0);
        $('#txtValorPagoTroco').select();
      }

      async function buscaFoto(codigo) {
        try {
          const _url = '/Sisplan/Funcoes/v1/FotoVenda?';
          const response = await requisicao('GET', _url, 'codigo=' + codigo, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
            return;
          }

          if (jsonStr.codigo == '400') {
            $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
            return;
          }

          const sBase64 = jsonStr;
          if ($('#tabelaItens').DataTable().rows().count() == 0) {
            $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
          } else {
            $("#infoprodimagem").attr('src', 'data:image/png;base64,' + sBase64.mensagem);
          }

        } catch (error) {
          console.error(error);
          $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
        }
      }

      async function buscaFotoCor(codigo, cor) {
        try {
          const _url = '/Sisplan/Funcoes/v1/FotoCorVenda?';
          const response = await requisicao('GET', _url, `codigo=${codigo}&cor=${cor}`, null);

          if (!response) {
            return;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            $("#infoprodcorimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
            return;
          }

          if (jsonStr.codigo == '400') {
            $("#infoprodcorimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
            return;
          }

          const sBase64 = jsonStr;
          if ($('#tabelaItens').DataTable().rows().count() == 0) {
            $("#infoprodcorimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
          } else {
            $("#infoprodcorimagem").attr('src', 'data:image/png;base64,' + sBase64.mensagem);
          }

        } catch (error) {
          console.error(error);
          $("#infoprodcorimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
        }
      }

      $('#tabelaItens tbody').on('click', 'tr', async function() {
        if ($(this).hasClass('selected')) {
          $(this).removeClass('selected');
          if ($(this).hasClass("linha-promocao")) {
            $(this).removeClass('linha-promocao-selected');
          }
        } else {
          $('#tabelaItens').DataTable().$('tr.selected').removeClass('selected');
          $(this).addClass('selected');
          if ($(this).hasClass("linha-promocao")) {
            $(this).addClass('linha-promocao-selected');
          }
          if ($('#tabelaItens').DataTable().rows().count() == 0) {
            $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
            $("#infoprodcodigo").val('');
            $("#infoprodcor").val('');
            $("#infoprodtam").val('');
            $("#infoprodpreco").val('');
            $("#infoprodbarra").val('');
            $("#infoprodlote").val('');
            $('#infoprodtabelapreco').val('');
            $('#infoproddeposito').val('');
            $("#infoprodlocal").val('');
            $("#infoprodunidade").val('');
            $("#infoprodqualidade").val('');
          } else {
            const id = $('#tabelaItens').DataTable().row(this.closest('tr')).index();
            const data = $('#tabelaItens').DataTable().row(id).data();
            const codigo = data[0];
            const cor = data[10];
            $("#infoprodcodigo").val(`${data[1]}`);
            $("#infoprodpreco").val(data[4]);
            $("#infoprodbarra").val(data[9]);
            $("#infoprodlote").val(data[18]);
            $("#infoprodcor").val(data[10] + ' - ' + data[12]);
            $("#infoprodtam").val(data[11]);
            $("#infoprodunidade").val(data[28]);
            $('#infoprodqualidade').val(`${data[13]} - ${(await buscaValor('TABQUL', 'DESCRICAO', 'CODIGO', data[13])) ?? ''}`);
            await buscaFoto(codigo);
            if (empresaTrabalhaComFotoCor) {
              await buscaFotoCor(codigo, cor);
            }
            if (data[19] == 'P') {
              $("#divLocal").removeClass('d-none');
              $('#divDeposito').addClass('d-none');
              $('#divTabelaPreco').addClass('d-none');
              $('#divTamanho').removeClass('d-none');
              $('#divQtdeOrig').addClass('d-none');
              // $("#divLote").removeClass('col-sm-12 col-12');
              // $("#divLote").removeClass('col-sm-6 col-12');
              // $("#divLote").addClass('col-sm-6 col-12');
              const local = await buscaLocal(data[0]);
              $("#infoprodlocal").val(local);
            } else {
              // se for material
              $("#divLocal").addClass('d-none');
              // $('#divTamanho').addClass('d-none');
              $('#divDeposito').removeClass('d-none');
              $('#divTabelaPreco').removeClass('d-none');
              $('#divQtdeOrig').removeClass('d-none');
              $('#divTamanho').addClass('d-none');

              const dadosAuxiliares = await buscaAuxiliarMaterial(data[33], data[34]);
              const deposito = dadosAuxiliares.CODIGO;
              const tabelaPreco = dadosAuxiliares.REGIAO;
              const descDeposito = dadosAuxiliares.DESCRICAO;
              const descTabelaPreco = dadosAuxiliares.DESC_REGIAO;

              $("#infoproddeposito").val(`${deposito} - ${descDeposito}`);
              $("#infoprodtabelapreco").val(`${tabelaPreco} - ${descTabelaPreco}`);
              $("#infoprodqtdeorig").val(data[37]);
              // $("#divLote").removeClass('col-sm-12 col-12');
              // $("#divLote").removeClass('col-sm-6 col-12');
              // $("#divLote").addClass('col-sm-12 col-12');
            }
          }
        }
      });

      var keytable = new $.fn.dataTable.KeyTable($('#tabelaItens').DataTable());
      // se precionar enter executa duplo click
      keytable.event.action(null, null, function(node) {
        $(node).click();
      });
      // posiciona a navegacao via teclas no primeiro registro
      $('#tabelaItens tbody')[0].click();
      $('#tabelaItens').DataTable().$('tr.selected').removeClass('selected');

      document.addEventListener("keydown", function(event) {
        if (event.ctrlKey && event.key == "b") {
          $("#txtCodigo").focus();
        }
        if (event.ctrlKey && event.key == "q") {
          $("#txtQuantid").focus();
        }
      });

      document.querySelector('#txtMoeda').addEventListener("keydown", function(event) {
        if ((event.key == "Enter") && ($('#txtCondicaoDePagamento').prop('disabled'))) {
          $("#txtValorParcela").focus();
        }
      });

      $('.pop').on('click', function() {
        $('.imagepreview').attr('src', $(this).attr('src'));
        $('#imagemodal').modal('show');
        $('#imagemodal').css('z-index', '999999')
      });

      // window.onbeforeunload = confirmExit;

      $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
        $.fn.dataTable.tables({
          visible: true,
          api: true
        }).columns.adjust();
      });

      $('#btnDescontoMoeda').on('click', function() {
        if ($($($($('#txtPercDescontoMoeda').parent()).parent()).parent()).hasClass('d-none')) {
          $($($($('#txtPercDescontoMoeda').parent()).parent()).parent()).removeClass('d-none');
        } else {
          $($($($('#txtPercDescontoMoeda').parent()).parent()).parent()).addClass('d-none');
        }

        if ($($($($('#txtValorDescontoMoeda').parent()).parent()).parent()).hasClass('d-none')) {
          $($($($('#txtValorDescontoMoeda').parent()).parent()).parent()).removeClass('d-none');
        } else {
          $($($($('#txtValorDescontoMoeda').parent()).parent()).parent()).addClass('d-none');
        }

        if ($($($($('#txtValorLiquidoMoeda').parent()).parent()).parent()).hasClass('d-none')) {
          $($($($('#txtValorLiquidoMoeda').parent()).parent()).parent()).removeClass('d-none');
        } else {
          $($($($('#txtValorLiquidoMoeda').parent()).parent()).parent()).addClass('d-none');
        }
      });

      $("#txtPercDescontoMoeda").on('blur', async function() {
        await saidaCampoPercentualDesconto();
      });

      $("#txtValorDescontoMoeda").on('blur', async function() {
        await saidaCampoValorDesconto();
      });

      $('#txtValorAcrescMoeda').on('blur', async function() {
        let baixaAntecipacao = pegaChave('#txtBaixaAntecipacao');
        if ($('#txtValorAcrescMoeda').val() != '0') {
          $('#txtValorAcrescMoeda').trigger('change');
        } else if ((parseFloat($('#txtPercDescontoMoeda').val()) > 0) || (parseFloat($('#txtValorDescontoMoeda').val()) > 0)) {
          // feito aplicar o desconto direto, pois apenas triggando, não aguarda o retorno da aplicação de desconto
          const bDescontaFrete = ((bNaoConsiderarFreteDesconto) && ((parseFloat($("#txtPercDescontoMoeda").val()) > 0) || (parseFloat($("#txtValorDescontoMoeda").val()) > 0)));
          const valFrete = isNaN(parseFloat($('#txtFrete').val())) ? 0 : parseFloat($('#txtFrete').val());
          const valorParcela = bDescontaFrete ? (parseFloat($("#txtValorParcela").val()) - valFrete) : $("#txtValorParcela").val();
          const validaDesc = await CalculaDescontoMoeda('txtValorDescontoMoeda', valorParcela, $("#txtPercDescontoMoeda").val(), $("#txtValorDescontoMoeda").val(), $("#txtValorParcela").val(), 1);
          if (validaDesc == false) {
            return;
          }
        }

        if ((parseFloat($('#txtValorAcrescMoeda').val()) == 0 || $('#txtValorAcrescMoeda').val() == "") && ($('#txtFrete').val() == '0')) {
          $('#txtPercAcrescMoeda').val(0);
          $('#txtValorLiquidoMoeda').val($('#txtValorParcela').val());
          if (bAplicaDescMaxTabPrecoVendaNotAlterar) {
            $("#PainelDesconto input").attr("disabled", true);
          } else {
            $("#PainelDesconto input").attr("disabled", false);
          }
          return;
        }

        await calculaAcrescimoVenda('txtValorAcrescMoeda', parseFloat($("#txtValorAcrescMoeda").val()), parseFloat($("#txtPercAcrescMoeda").val()), $("#txtValorParcela").val());
      });

      $('#txtPercAcrescMoeda').on('blur', async function() {
        let baixaAntecipacao = pegaChave('#txtBaixaAntecipacao');
        if (parseFloat($('#txtPercAcrescMoeda').val()) == 0 || $('#txtPercAcrescMoeda').val() == "") {
          $('#txtValorAcrescMoeda').val(0);
          $('#txtValorLiquidoMoeda').val(parseFloat($('#txtValorParcela').val()));
          if (bAplicaDescMaxTabPrecoVendaNotAlterar) {
            $("#PainelDesconto input").attr("disabled", true);
          } else {
            $("#PainelDesconto input").attr("disabled", false);
          }
          return;
        }
        await calculaAcrescimoVenda('txtPercAcrescMoeda', parseFloat($("#txtValorAcrescMoeda").val()), parseFloat($("#txtPercAcrescMoeda").val()), $("#txtValorParcela").val());
      });

      $('#tabelaCondicoesDePagamento').DataTable().columns.adjust().draw(false);

      $('#modalTroco').on('shown.bs.tab', async function() {
        $('#btnConfirmarTroco').prop('disabled', false);
      });

      async function retornaInput() {
        let options = await preencheOption();
        return ` <select class="form-control select2 select2-danger focus selectPOSS" id="selectPOS" name="selectPOS" data-dropdown-css class="select2-danger" style="width: 100%;">
                  ${options}
                </select>`;
      }

      async function preencheOption() {
        let url = '/Sisplan/Funcoes/v1/pesquisa?';

        try {
          let response = await requisicao('GET', url, `JSON={ "tabela":"maquina_cartao", "camposSelect":["nrserie"], "where": ["1=1"] }`);
          let arrayOption = [];
          if (!response) {
            return;
          }

          if (response.status != 200) {
            return error;
          }

          jsonMaquina = await response.json();

          for (let j = 0; j < jsonMaquina.RESULT[0].length; j++) {
            arrayOption.push(
              `<option value="${jsonMaquina.RESULT[0][j].NRSERIE}">${jsonMaquina.RESULT[0][j].NRSERIE}</option>`
            );
          }

          return arrayOption;
        } catch (error) {
          console.error(error);
        }
      }

      $('#modal-POSTEF').on('hidden.bs.modal', function(e) {
        $('#tabelaPOSTEF').DataTable().rows().remove().draw(false)
      });

      $('#btnConfirmaPagamento').on('click', async function() {
        try {
          $.LoadingOverlay('show');
          try {
            let response;
            let jsonStr;
            let objeto = {};
            let pagamento = {};
            let arrayPagamentos = [];
            let parametro = parametrosVenda[18];

            let table = $('#tabelaPOSTEF').DataTable();

            for (let i = 0; i < table.rows()[0].length; i++) {
              pagamento = {};
              pagamento.VALOR = $('#tabelaPOSTEF').DataTable().rows([i]).data()[0].VALOR;

              pagamento.IDPAGAMENTO = $('#tabelaPOSTEF').DataTable().rows([i]).data()[0].ID_PAGAMENTO;

              if ($($('#tabelaPOSTEF').find('.selectPOSS')[i]).val() != 'Selecionar') {
                pagamento.MAQUINAPOS = $($('#tabelaPOSTEF').find('.selectPOSS')[i]).val();
              } else {
                msgAlerta('Campo MAQUINA_POS está vázio!');
                return;
              }
              arrayPagamentos.push(pagamento);
            }

            objeto.PAGAMENTOS = arrayPagamentos;
            objeto.EMPRESADAO = await retornaInformacaoEmpresa();

            response = await requisicao_ecf('POST', '/cfe/confirmapagamento?', `PARAMETRO=${parametro}`,
              `${JSON.stringify(objeto)}`, 30000);

            if (!response) {
              return;
            }

            jsonStr = await response.json();
            if (response.status == 200) {
              toastr.success(
                'Pagamento confirmado com sucesso!',
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden() {
                    if (parametro == 4) {
                      $('#txtCpfCFe').val($('#txtCNPJ').val());
                      $('#btn_confirmar_cfe').trigger('click');
                    } else {
                      $('#modal-POSTEF').modal('hide');
                      $('#modalCFe').modal('show');
                      $('#txtCpfCFe').val($('#txtCNPJ').val());
                    }
                  }
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });

            } else {
              toastr.warning(
                `${jsonStr.mensagem.mensagem}`,
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden() {}
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });
            }
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      })

      $('#btnEnviaPagamento').on('click', async function() {
        try {
          $.LoadingOverlay('show');
          try {
            let objeto = {};
            let pagamento = {};
            let arrayPagamentos = [];
            const parametro = parametrosVenda[18];

            let table = $('#tabelaPOSTEF').DataTable();

            objeto.CODVENDA = numero_venda;

            if (table.rows()[0].length > 1) {
              objeto.MULTIPAGAMENTOS = true;
            } else {
              objeto.MULTIPAGAMENTOS = false;
            }

            for (let i = 0; i < table.rows()[0].length; i++) {
              pagamento = {};
              pagamento.VALOR = $('#tabelaPOSTEF').DataTable().rows([i]).data()[0].VALOR;

              if ($($('#tabelaPOSTEF').find('.selectPOSS')[i]).val() != 'Selecionar') {
                pagamento.MAQUINAPOS = $($('#tabelaPOSTEF').find('.selectPOSS')[i]).val();
              } else {
                msgAlerta('Campo MAQUINA_POS está vázio!');
                return;
              }
              arrayPagamentos.push(pagamento);
            }

            objeto.PAGAMENTOS = arrayPagamentos;
            objeto.EMPRESADAO = await retornaInformacaoEmpresa();

            const response = await requisicao_ecf('POST', '/cfe/enviapagamento?', `PARAMETRO=${parametro}`,
              `${JSON.stringify(objeto)}`, 30000);

            if (!response) {
              return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
              toastr.warning(
                `${jsonStr.mensagem.mensagem}`,
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden() {

                  }
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });
            }

            let tabelaPOS = $('#tabelaPOSTEF').DataTable();
            let arrayRow = [];
            for (let i = 0; i < tabelaPOS.rows()[0].length; i++) {
              arrayRow = $('#tabelaPOSTEF').DataTable().row(i).data();
              arrayRow.MAQUINA_POS = arrayRow.MAQUINA_POS;
              arrayRow.ID_PAGAMENTO = jsonStr.idPagamentoRetorno[i];
              tabelaPOS.row(i).data(arrayRow);
            }

            toastr.success(
              'Pagamento enviado com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                  $('#btnEnviaPagamento').prop('disabled', true);
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });

          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      async function verificaMfePagamento() {
        try {
          $.LoadingOverlay('show');
          try {
            let table = $('#tabelaCondicoesDePagamento').DataTable().rows().data();
            bUsaMFe = parametrosVenda[18];
            let response;
            let jsonStr;
            let colunas = {
              MOEDA: table[0][6],
              DESCRICAO_MOEDA: table[0][1],
              VALOR: '',
              MAQUINA_POS: await retornaInput(),
              ID_PAGAMENTO: '',
              NRPARCELA: table[0][8],
            }

            let dataColuna = [];
            let dataSet = [];

            dataSet = colunas;
            var keys = Object.keys(colunas);
            for (let k in keys) {
              dataColuna.push({
                'title': keys[k],
                'data': keys[k]
              });
            }

            tabelaPOSTEF = $('#tabelaPOSTEF').dataTable({
              paging: true,
              filter: false,
              info: true,
              order: false,
              autoWidth: true,
              destroy: true,
              "columns": dataColuna,
              "data": dataSet,
              "columnDefs": [{
                targets: 5,
                visible: false,
              }]
            });

            for (let j = 0; j < $('#tabelaCondicoesDePagamento').DataTable().rows().count(); j++) {
              let url = '/Sisplan/Funcoes/v1/pesquisa?';
              let params =
                `JSON={ "tabela":"moeda", "camposSelect":["codmoe", "descricao", "TIPO"], "where": ["CODMOE = '${table[j][6]}'"]}`;

              response = await requisicao('GET', url, params);

              if (!response) {
                return;
              }

              if (response.status != 200) {
                cosnsole.log(response.mensagem);
                return;
              }

              jsonStr = await response.json();

              if (jsonStr.RESULT[0][0].TIPO == '3') {
                let qtdeParcelas = parseFloat(table[j][8]);
                let valorTotal = parseFloat(table[j][3]);
                let valorParcela = parseFloat((valorTotal / qtdeParcelas).toFixed(2));

                for (let i = 0; i < parseFloat(table[j][8]); i++) {
                  $('#tabelaPOSTEF').DataTable().row.add({
                    MOEDA: table[j][6],
                    DESCRICAO_MOEDA: table[j][1],
                    VALOR: valorParcela,
                    MAQUINA_POS: await retornaInput(),
                    ID_PAGAMENTO: '',
                    NRPARCELA: table[j][8]
                  }).draw(false);
                  await preencheOption();
                }
              } else {
                if (bUsaMFe == 4) {
                  $('#btn_confirmar_cfe').trigger('click');
                }
              }
            }

            if ($('#tabelaPOSTEF').DataTable().rows().count() > 0) {
              $('#modalCFe').modal('show');
              // $('#modal-POSTEF').modal('show');
            } else {
              $('#modalCFe').modal('show');
            }

          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      }


      $('#txtFrete').blur(async function() {
        if ($('#txtFrete').val() == '') {
          $('#txtFrete').val(0)
        }
        $.LoadingOverlay('show');
        try {

          if (parametroValorIPIVenda) {
            rotinaRemoveValorIPI();
          }

          const valorFrete = parseFloat($('#txtFrete').val());
          const saldoItens = parseFloat(($("#subtotal_venda").html().replaceAll('.', '')).replace(',', '.'));
          const valPagtos = $('#tabelaCondicoesDePagamento').DataTable().column(3, {}).data().sum();
          const valDesconto = $('#tabelaCondicoesDePagamento').DataTable().column(11, {}).data().sum() + parseFloat($('#txtValorDescontoMoeda').val());
          const valorAcrescimo = parseFloat($('#txtValorAcrescMoeda').val());
          let saldo = saldoItens + valorAcrescimo - (valPagtos + valDesconto);
          saldo = TruncaDecimaisNova(2, saldo + valorFrete);

          if ((parseFloat($('#txtValorParcela').val()) > 0) && (!isNaN(valorFrete)) && (valorFrete > 0)) {
            $('#txtValorLiquidoMoeda').val(saldo);
          }

          if (parametroValorIPIVenda) {
            await rotinaAplicaValorIPI(false);
          }

          if (parametroValorRetIva) {
            await rotinaAplicaValorRetencaoIva();
          }

          atualizaSaldoAPagar();

        } catch (error) {
          console.error(error);
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      $('#txtCNPJ').on('change', async function() {
        let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
        if (validaCNPJ) {
          $("#txtCNPJ").val(validaCNPJ);
          if (await apenasClientesVinculadosAoRepresentante()) {
            return;
          }
          var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
          var _params = `JSON={ "tabela":"entidade", "camposSelect":["ENTIDADE.codcli","ENTIDADE.NOME"], "where": ["CNPJ = '${ $("#txtCNPJ").val()}'"]}`;

          try {
            var response = await requisicao('GET', _url, _params, null);

            if (!response) {
              return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }
            if (jsonStr['RESULT'][0].length > 0) {
              insereValor("#txtCliente", jsonStr['RESULT'][0][0].CODCLI, jsonStr['RESULT'][0][0].NOME);
            }
            $('#txtCliente').trigger('blur');
          } catch (error) {
            console.error(error);
          }
        }
      });

      $('#txtMoeda').focusout(async function() {
        await RotinaSaidaMoeda();
      });

      $('#txtCliente').focus();

      async function habilitaCupomDesconto() {
        const empId = getCookie('emp_id');
        const pesquisa = {
          tabela: 'EMP_VALOR',
          camposSelect: ["VALOR"],
          where: ["TABELA = 'CUPOMDESCONTO'", "CAMPO = 'CODIGO'", `EMP_ID = ${empId}`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length > 0) {
          $('#painelCupomDesconto').removeClass('d-none');
        }
      }

      async function habilitaCampoCidade() {
        let uf;
        $.LoadingOverlay('show');
        setTimeout(() => {

          if ($("#txtUfCEPCadastro").val() != "") {
            uf = pegaChave("#txtUfCEPCadastro", uf);

            $("#txtCidadeCEPCadastro").prop("readonly", false);
            $("#btnCidade").removeClass("d-none");
            $("#btnACidade").removeClass("d-none");
            $("#txtCidadeCEPCadastro").prop("disabled", false);

            $("#txtCidadeCEPCadastro").off();
            $("#txtCidadeCEPCadastro").autocompleta(1, `JSON={ "tabela":"cidade", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["cod_uf = '${uf}'"]}`);
            $("#btnCidade").pesquisa("#txtCidadeCEPCadastro", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cidade", "camposSelect":[ "CODIGO", "NOME"], "where": ["cod_uf = '${uf}'"]}`, "Pesquisa Cidade", "cidade");
          } else {
            $("#txtCidadeCEPCadastro").prop("readonly", true);
            $("#btnCidade").addClass("d-none");
            $("#btnACidade").addClass("d-none");
            $("#txtCidadeCEPCadastro").prop("disabled", true);
            $("#txtCidadeCEPCadastro").off();
          }
        }, 2000);
        $.LoadingOverlay('hide');
      }

      $('#txtUfCEPCadastro').blur(async function() {
        await habilitaCampoCidade();
      });

      $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $("#txtPaisCEPCadastro").autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
      $("#txtUfCEPCadastro").autocompleta(1, `JSON={ "tabela":"tabuf", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, '', '', '', habilitaCampoCidade);
      $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);

      $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
      $("#btnPais").pesquisa("#txtPaisCEPCadastro", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cadpais", "camposSelect":[ "CODIGO", "NOME"]}`, "Pesquisa País", "cadpais");
      $("#btnUf").pesquisa("#txtUfCEPCadastro", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"tabuf", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa UF", "tabuf", '', habilitaCampoCidade);
      $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');

      $('#btn-limpa-Classe').on('click', function() {
        $('#txtClasse').val('');
      });
      $("#btnACidade").on("click", function() {
        $("#txtCidadeCEPCadastro").val("");
      });
      $("#btnAPais").on("click", function() {
        $("#txtPaisCEPCadastro").val("");
      });
      $("#btnAUf").on("click", async function() {
        $("#txtUfCEPCadastro").val("");
        $("#txtCidadeCEPCadastro").val("");
        $("#txtCidadeCEPCadastro").prop("readonly", true);
        $("#btnCidade").addClass("d-none");
        $("#btnACidade").addClass("d-none");
        $("#txtCidadeCEPCadastro").prop("disabled", true);
        $("#txtCidadeCEPCadastro").off();
      });

      if (parametrosVenda[31] == '1') {
        $('#painelFrete').removeClass('d-none');
      }

      habilitaCupomDesconto()

      $('#txtItemQuantidade').blur(async function() {
        try {
          if ($(this).val() <= 0) {
            msgAlerta('A Quantidade deve ser maior que zero.');
            $(this).val('');
            return;
          }
          const quantidadeNova = $('#txtItemQuantidade').val();
          const quantidadeAntiga = $('#txtItemQuantidadeAtual').val();

          $('#txtItemQuantidadeDiferenca').val(ArredondarValor(parseFloat(quantidadeNova) - parseFloat(quantidadeAntiga), 3));
        } catch (error) {
          console.error(error);
        }
      });

      $('#btnConfirmarQuantidades').on('click', async function() {
        try {
          $.LoadingOverlay('show');
          try {
            if (+$('#txtItemQuantidade').val() <= 0) {
              msgAlerta('Quantidade deve ser maior que zero.');
              return;
            }

            const dadosEmEdicao = $('#tabelaItens').DataTable().row($('#txtIdLinhaItemQuantidade').val()).data();
            const percDesconto = Number(dadosEmEdicao[5]);

            const funcaoRepassaItemComNovaQuantidade = async () => {
              $('#tabelaItens').DataTable().row($('#txtIdLinhaItemQuantidade').val()).remove().draw(false);
              $('#txtQuantid').val($('#txtItemQuantidade').val());
              $('#txtIdItem').val($('#txtBarraQuantidadeNova').val());
              $('#txtDepositoItem').val($('#txtDepositoQuantidadeNova').val());
              $('#txtCodigo').val('');
              $('#txtCodigo').trigger('blur');

              let venda = {};
              venda = await montaJsonVenda(venda, numero_venda, 'P', false);
              salvaDadosDigitados(venda);
              atualizaTotalVenda();
              $('#modalQuantidade').modal('hide');
            }
            if (percDesconto > 0) {
              msgAlerta(`Deseja manter o desconto de ${percDesconto}% aplicado?`, async () => {
                const preco = Number(dadosEmEdicao[3]); // trabalha sempre com preço orig..
                const quantidade = Number($('#txtItemQuantidade').val())
                dadosEmEdicao[2] = quantidade;
                dadosEmEdicao[6] = ArredondarValor((percDesconto / 100) * preco * quantidade, 2).toLocaleString("en-US", { // valor total desconto dados[6]
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });

                precoLiq = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(preco - dadosEmEdicao[6] / dadosEmEdicao[2], quantidadeCasasDecimaisCampo)) : ArredondarValor(preco - dadosEmEdicao[6] / dadosEmEdicao[2], 2);

                dadosEmEdicao[4] = precoLiq.toLocaleString("en-US", {
                  maximumFractionDigits: quantidadeCasasDecimaisCampo,
                  minimumFractionDigits: quantidadeCasasDecimaisCampo
                });

                const soma = +(preco) * parseFloat(dadosEmEdicao[2]).toFixed(4);
                const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
                const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : ArredondarValor(parseFloat(soma), 2);


                totalLiq = ArredondarValor(ArredondarValor(parseFloat(calculoTotal), 2) - ArredondarValor(dadosEmEdicao[6], 2), 2);
                dadosEmEdicao[7] = totalLiq;

                $('#tabelaItens').DataTable().row($('#txtIdLinhaItemQuantidade').val()).data(dadosEmEdicao).draw(false);

                let venda = {};
                venda = await montaJsonVenda(venda, numero_venda, 'P', false);
                salvaDadosDigitados(venda);
                atualizaTotalVenda();
                $('#modalQuantidade').modal('hide');

              }, async () => {
                await funcaoRepassaItemComNovaQuantidade();
              });
            } else {
              await funcaoRepassaItemComNovaQuantidade();
            }


          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      $('#btnConfirmarItemPreco').on('click', async function() {
        try {
          $.LoadingOverlay('show');
          const id = $('#txtIdLinhaItemPreco').val();
          const itemTabela = $('#tabelaItens').DataTable().row(id).data();
          const precoOld = itemTabela[3];
          const precoNovo = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda($('#txtItemPrecoNovo').val(), quantidadeCasasDecimaisCampo)) : TruncaDecimaisNova(2, $('#txtItemPrecoNovo').val());

          if (parseFloat(precoNovo) <= 0) {
            msgAlerta('Informe um preço válido para continuar.');
            return;
          }

          // const rotina = async () => {
          await rotinaGeraLog('TVENDALOJA', numero_venda, `Preço Alterado de ${precoOld} para ${precoNovo} no item ${itemTabela[1]}`, 'Inclusão');
          itemTabela[3] = precoNovo; // preço orig
          itemTabela[4] = precoNovo; // novo preço
          itemTabela[5] = 0;
          itemTabela[6] = 0;
          itemTabela[7] = TruncaDecimaisNova(2, parseFloat(itemTabela[4] * itemTabela[2])); // novo total
          $('#tabelaItens').DataTable().row(id).data(itemTabela).draw(false);

          venda = await montaJsonVenda(venda, numero_venda, 'P', false);
          salvaDadosDigitados(venda);
          atualizaSaldoAPagar();
          atualizaTotaisPagto();
          atualizaTotalVenda();
          $('#modalItemPreco').modal('hide');
          // }

          // await senhaSupervisor(`Preço Alterado de ${precoOld} para ${TruncaDecimaisNova(2, $('#txtItemPrecoNovo').val())} no item ${itemTabela[1]}`, rotina);

        } finally {
          $.LoadingOverlay('hide');
        }
      });

      // $('#txtVendedor').on('blur', async function() {
      //   const Vendedor = pegaChave('#txtVendedor');
      //   if (Vendedor != '') {
      //     $('#btn-guia').off();
      //     if (await ExisteGuiaVendedor(Vendedor)) {
      //       $('#txtGuia').autocompleta(1, `JSON={ "tabela":"REP_GUIA", "camposSelect":[ "rep_guia.guia chave", "represen.nome descricao" ], "leftjoin":[{"tabela" : "represen", "condicao" : "represen.codrep = rep_guia.guia"}], "where": ["rep_guia.codrep = '${Vendedor}'"]}`);
      //       $('#btn-guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "rep_guia","camposSelect": ["rep_guia.guia codrep", "represen.nome"],"leftjoin": [{"tabela": "represen","condicao": "represen.codrep = rep_guia.guia"}],"where": ["rep_guia.codrep = '${Vendedor}'"]}`, 'Pesquisa Representante', 'rep_guia');
      //     } else {
      //       $('#txtGuia').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S'", "grupo_rep = 'U'"] }`);
      //       $('#btn-guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "represen","camposSelect": ["codrep", "nome"],"where": ["ativo = 'S'", "grupo_rep = 'U'"] }`, 'Pesquisa Representante', 'represen');
      //     }
      //   }
      //   preencheVendedorGuia(pegaChave(this), true);
      // });

      $('#txtTipoVenda').trigger('change');

      // $('#txtDepositoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
      // $('#txtProdutoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

      // $('#btn-DepositoConsultaEstoque').pesquisa('#txtDepositoConsultaEstoque', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"], "where": null}`, 'Pesquisa Depósito', 'deposito');
      // $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');

      // $('#btn-limpa-DepositoConsultaEstoque').on('click', function() {
      //   $('#txtDepositoConsultaEstoque').val('');
      // });

      // $('#btn-limpa-ProdutoConsultaEstoque').on('click', function() {
      //   $('#txtProdutoConsultaEstoque').val('');
      // });

      if (parametrosVenda[29] == 1) {
        await verificaEPreencheUnicaRegra();
      } else if ((parametrosVenda[29] == 2) && ($('#txtTabela').val() != '')) {
        $('#btnRecalcularRegra').trigger('click');
      }

      saidaTabela();

      function saidaTabela() {
        $('#txtTabela').focusout(async function() {
          if ((parametrosVenda[29] == 1) && ($(this).val() != '')) {
            await verificaEPreencheUnicaRegra();
          } else if ((parametrosVenda[29] == 2) && ($(this).val() != '')) {
            $('#btnRecalcularRegra').trigger('click');
          }
          if ($(this).val().includes('[')) {
            tabelaOld = $(this).val();
          }

          verificaTabelaPrecoKG();
        })
      }

      criaDataTablePadrao('#tabelaProdutosConsultaEstoque', false, false, false, false, true, true, '200px');

      $('#modalConsultaEstoque').on('hidden.bs.modal', function() {
        $('#tabelaProdutosConsultaEstoque').DataTable().rows().remove().draw(false);
        $('#txtProdutoConsultaEstoque').val('');
      });

      $('#radioProdutoC, #radioMaterialC').on('change', async function() {

        $('#btn-ProdutoConsultaEstoque').unbind();
        $('#txtProdutoConsultaEstoque').val('');

        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        if (tipoConsulta == 'M') {
          $("#txtProdutoConsultaEstoque").attr("placeholder", "Material");
          $("#labelProduto").text("Material");
          $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Material');
          $('#txtProdutoConsultaEstoque').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
        } else {
          $("#txtProdutoConsultaEstoque").attr("placeholder", "Produto");
          $("#labelProduto").text("Produto");
          $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Produto');
          $('#txtProdutoConsultaEstoque').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
        }
      });

      $('#txtProdutoProd').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
      $('#txtTabelaPrecoProd').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
      $('#btnTabelaPrecoProd').pesquisa('#txtTabelaPrecoProd', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null, "orderBy": ["REGIAO", "DESCRICAO"]}', 'Pesquisa Tabela de Preço', 'regiao');

      $('#btnAbreModalDepositosPreco').on('click', function() {
        $('#modalDepositoPreco').modal('show')
      })

      $('#modalDepositoPreco').on('shown.bs.modal', async function() {
        await buscaDepositos()
      })

      async function buscaDepositos() {
        if ($.fn.DataTable.isDataTable('#tabelaDepositosPreco')) {
          $('#tabelaDepositosPreco').DataTable().destroy();
          $('#tabelaDepositosPreco').empty();
        };

        try {
          const where = await montaWherePesquisaDeposito();
          const campos = await montaCamposSelectDeposito();

          let dataSetCols = [];

          $.LoadingOverlay("show");

          for (let i = 0; i < campos.colunas.length; i++) {
            dataSetCols.push({
              'title': campos.colunas[i],
              'data': i
            });
          }

          const ajaxData = {
            EMPRESA: getCookie('empresa'),
            JSON: encodeURIComponent(`{
                "tabela":"MAT_ITEN", "camposSelect": ${campos.camposSelect},
                "leftJoin": [
                    {"tabela": "MATERIAL", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"},
                    {"tabela": "DEPOSITO", "condicao": "MAT_ITEN.DEPOSITO = DEPOSITO.CODIGO"}
                ],
                "where": ["1=1 ${where}"],
                "groupBy": ["MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO"]
            }`),
            CLIENTE: 'N',
          };

          dataSetCols[0].render = function(data, type, row, meta) {
            return '<div style="text-align:start;"> ' +
              '    <button class="btn btn-info btn-sm btnVerificaOpcoes btnMostrarLotes" type="button" >Mostrar Lotes</button> ' +
              '</div>'
          };

          $('#tabelaDepositosPreco').DataTable({
            paging: true,
            lengthChange: false,
            filter: false,
            info: true,
            order: false,
            autoWidth: true,
            destroy: true,
            serverSide: true,
            processing: true,
            ajax: {
              url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
              type: "GET",
              headers: {
                'Authorization': BASIC_AUTH
              },
              data: ajaxData,
            },
            columns: dataSetCols,
            columnDefs: []
          });

        } catch (error) {
          console.log(error)
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      let clickLoteDeposito = '';

      $('#tabelaDepositosPreco').on('click', '.btnMostrarLotes', async function() {
        if ($('#modalDepositoPreco').hasClass('show') && $('#tabelaDepositosPreco').DataTable().rows().count() > 0) {
          clickLoteDeposito = $('#tabelaDepositosPreco').DataTable().row($(this).closest('tr')).data()[1];
        }
        $('#modalLotesDeposito').modal('show')
      });


      $('#modalLotesDeposito').on('shown.bs.modal', async function() {
        await buscaLotesDepositos(clickLoteDeposito);
      })

      $('#modalDepositoPreco').on('hidden.bs.modal', function() {
        clickLoteDeposito = '';
      });

      async function montaWherePesquisaDeposito(dep = '') {
        let where = ''
        let filtroDeposito = ''
        if (!$("#cbTodosDepositos").prop("checked")) {
          filtroDeposito = await buscaDepositoEmpresaUsuario();
        } else {
          if (clickLoteDeposito !== '') {
            filtroDeposito = clickLoteDeposito;
          } else {
            filtroDeposito = await verificaTodosDepositos();
          }
        }

        let deposito = await formataListas($('#txtDepositoProd').val().toString());

        if (deposito == '') {
          deposito = filtroDeposito;
        }

        if (dep != '') {
          deposito = dep;
        };

        where += deposito != '' ? ` AND MAT_ITEN.DEPOSITO IN (${deposito})` : '';
        where += $('#txtCodigoProd').val() != '' ? ` AND MATERIAL.CODIGO IN (${await formataListas($('#txtCodigoProd').val().toString())})` : '';
        where += $('#txtDescricaoProd').val() != '' ? ` AND MATERIAL.DESCRICAO LIKE '%${$('#txtDescricaoProd').val()}%'` : '';
        where += $('#txtGrupoMA').val() != '' ? ` AND MATERIAL.GRUPO IN (${await formataListas($('#txtGrupoMA').val().toString())})` : '';
        where += $('#txtSubGrupo').val() != '' ? ` AND MATERIAL.SUB_GRUPO IN (${await formataListas($('#txtSubGrupo').val().toString())})` : '';
        where += $('#txtLinhaPreco').val() != '' ? ` AND MATERIAL.LINHA IN (${await formataListas($('#txtLinhaPreco').val().toString())})` : '';
        where += $('#txtQualidadePreco').val() != '' ? ` AND MAT_ITEN.QUALIDADE IN (${await formataListas($('#txtQualidadePreco').val().toString())})` : '';
        where += $('#txtLoteInternoPreco').val() != '' ? ` AND MAT_ITEN.LOTE_INTERNO IN (${await formataListas($('#txtLoteInternoPreco').val().toString())})` : '';
        where += $('#txtTonalidadePreco').val() != '' ? ` AND MAT_ITEN.TONALIDADE IN (${await formataListas(('#txtTonalidadePreco').val().toString())})` : '';
        if ($('#cbContemEstoquePreco').is(':checked')) {
          where += ` AND MAT_ITEN.QTDE > 0`
        }

        return where;
      }

      async function montaCamposSelectDeposito() {
        let camposSelect = [];
        let colunas = [];

        camposSelect = `["'' ACOES", "MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "SUM(MAT_ITEN.QTDE) QUANTIDADE"]`;
        colunas = ["ACOES", "DEPOSITO", "DESC_DEPOSITO", "QUANTIDADE"];

        return objeto = {
          camposSelect: camposSelect,
          colunas: colunas
        };
      }

      async function buscaLotesDepositos(dep = '') {
        if ($.fn.DataTable.isDataTable('#tabelaLotesDepositosPreco')) {
          $('#tabelaLotesDepositosPreco').DataTable().destroy();
          $('#tabelaLotesDepositosPreco').empty();
        };

        try {
          let camposSelect = [];
          let colunas = [];
          camposSelect = `["MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "MATERIAL.CODIGO2", "MATERIAL.CODIGO", "MATERIAL.DESCRICAO DESC_MATERIAL", "MAT_ITEN.LOTE", "MAT_ITEN.LOTE_INTERNO", "SUM(MAT_ITEN.QTDE) QUANTIDADE", "MAT_ITEN.QUALIDADE", "MAT_ITEN.TONALIDADE", "MAT_ITEN.DT_FAB"]`;
          colunas = ["DEPOSITO", "DESC_DEPOSITO", "CODIGO2", "CODIGO", "DESC_MATERIAL", "LOTE", "LOTE_INTERNO", "QUANTIDADE", "QUALIDADE", "TONALIDADE", "DT_FAB"];

          let campos = {
            camposSelect: camposSelect,
            colunas: colunas
          };

          const where = await montaWherePesquisaDeposito(dep);

          let dataSetCols = [];

          $.LoadingOverlay("show");

          for (let i = 0; i < campos.colunas.length; i++) {
            dataSetCols.push({
              'title': campos.colunas[i],
              'data': i
            });
          }

          const ajaxData = {
            EMPRESA: getCookie('empresa'),
            JSON: encodeURIComponent(`{
                "tabela":"MAT_ITEN", "camposSelect": ${campos.camposSelect},
                "leftJoin": [
                    {"tabela": "MATERIAL", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"},
                    {"tabela": "DEPOSITO", "condicao": "MAT_ITEN.DEPOSITO = DEPOSITO.CODIGO"}
                ],
                "where": ["1=1 ${where}"],
                "groupBy": ["MAT_ITEN.DEPOSITO", "DEPOSITO.DESCRICAO", "MATERIAL.CODIGO2", "MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MAT_ITEN.LOTE", "MAT_ITEN.QUALIDADE", "MAT_ITEN.LOTE_INTERNO", "MAT_ITEN.TONALIDADE", "MAT_ITEN.DT_FAB"]
            }`),
            CLIENTE: 'N',
          };

          $('#tabelaLotesDepositosPreco').DataTable({
            paging: true,
            lengthChange: false,
            filter: false,
            info: true,
            order: false,
            autoWidth: true,
            destroy: true,
            serverSide: true,
            processing: true,
            ajax: {
              url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
              type: "GET",
              headers: {
                'Authorization': BASIC_AUTH
              },
              data: ajaxData,
            },
            columns: dataSetCols,
            columnDefs: []
          });

        } catch (error) {
          console.log(error)
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      $('#radioProdutoPreco, #radioMaterialPreco').on('change', function() {
        const bProduto = $('#radioProdutoPreco').is(":checked")
        if (bProduto) {
          // $('#btnCodigoProd').off();
          componenteFiltro('produto', true, true, 'CodigoProd');
          $('#divBarraPreco').removeClass('col-6').addClass('col-12')
          $('.divGeralMaterial').addClass('d-none')
          $('#divFlagsPreco').addClass('d-none')
        } else {
          // $('#btnCodigoProd').off();
          $('.divGeralMaterial').removeClass('d-none')
          $('#divBarraPreco').removeClass('col-12').addClass('col-6')
          componenteFiltro('material', true, true, 'CodigoProd');
          $('#divFlagsPreco').removeClass('d-none')
        }
      });

      componenteFiltro('depositoUsuario', true, true, 'DepositoProd');
      componenteFiltro('linha', true, true, 'LinhaPreco');
      componenteFiltro('subGrupo', true, true);
      componenteFiltro('grupoMA', true, true);
      componenteFiltro('qualidade', true, true, 'QualidadePreco');
      componenteFiltro('loteInterno', true, true, 'LoteInternoPreco');
      componenteFiltro('tonalidade', true, true, 'TonalidadePreco');
      $('#radioProdutoPreco').trigger('change')

      $("#cbTodosDepositos").on("change", function() {
        bTodosDepositos = $("#cbTodosDepositos").prop("checked");
        if (bTodosDepositos) {
          componenteFiltro('deposito', true, true, 'DepositoProd')
        } else {
          componenteFiltro('depositoUsuario', true, true, 'DepositoProd')
        }
        // $("#txtDepositoProd").val('');
        // $("#txtDepositoProd").prop("disabled", bTodosDepositos)
        // $("#btnDepositoProd").prop("disabled", bTodosDepositos)
        // $("#btnLimpaDepositoProd").prop("disabled", bTodosDepositos)
      })

      $('#btnLimpaDepositoProd').on('click', function() {
        $('#txtDepositoProd').val('');
      });

      $('body').on('mouseover', function() {
        if ((idIntervalSolicitacaoEstoque == -1) && ($('.icone').hasClass('notificacao-ativa'))) {
          idIntervalSolicitacaoEstoque = setInterval(() => {
            SomDemanda();
          }, 3000);
        }
      });

      $("#btnLimpaTabelaPrecoProd").on("click", function() {
        $("#txtTabelaPrecoProd").val("");
      })

      $('#btnAbrirConsultaEstoque').on('click', function() {
        $('#modalConsultaEstoque').modal('show');
        $("#tabelaProdutosConsultaEstoque").DataTable().columns.adjust().draw(false);
      });
      $('#txtDepositoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
      $('#txtProdutoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

      $('#btn-DepositoConsultaEstoque').pesquisa('#txtDepositoConsultaEstoque', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"], "where": null}`, 'Pesquisa Depósito', 'deposito');
      $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');

      $('#btn-limpa-DepositoConsultaEstoque').on('click', function() {
        $('#txtDepositoConsultaEstoque').val('');
      });

      $('#btn-limpa-ProdutoConsultaEstoque').on('click', function() {
        $('#txtProdutoConsultaEstoque').val('');
      });

      async function buscaEstoque(sTipo) {
        try {
          const where = await montaWherePesquisa(sTipo);
          const campos = await montaCamposSelect(sTipo);
          const tabela = await montaTabela(sTipo);

          let dataSetCols = [];
          const indiceQtde = [];

          $.LoadingOverlay("show");

          for (let i = 0; i < campos.colunas.length; i++) {
            dataSetCols.push({
              'title': campos.colunas[i],
              'data': i
            });
            if ((campos.colunas[i] == 'QTDE') || (campos.colunas[i] == 'QUANTIDADE')) {
              indiceQtde.push(i)
            }
          }

          // const ajaxData = {
          //   "EMPRESA": getCookie('empresa'),
          //   "JSON": `{"tabela":"${tabela}", "camposSelect": ${campos.camposSelect}, "where": ["1=1 ${where}"]}`,
          //   "CLIENTE": 'N',
          // };

          const ajaxData = {
            EMPRESA: getCookie('empresa'),
            JSON: encodeURIComponent(`{
                "tabela":"${tabela}", "camposSelect": ${campos.camposSelect},
                "leftJoin": [
                    {"tabela": "CADCOR","condicao": "CADCOR.COR = ${sTipo == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.COR"},
                    {"tabela": "${sTipo == 'P' ? 'PRODUTO' : 'MATERIAL'}", "condicao": "${sTipo == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.CODIGO = ${sTipo == 'P' ? 'PRODUTO' : 'MATERIAL'}.CODIGO"}
                    ${sTipo == 'P' ? ',{"tabela": "FAIXA_ITEN","condicao": "FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND PA_ITEN.TAM = FAIXA_ITEN.TAMANHO"}' : ''}
                ],
                "where": ["1=1 ${where}"]
                ${sTipo == 'P' ? ',"orderby": ["PA_ITEN.CODIGO, PA_ITEN.COR, FAIXA_ITEN.POSICAO"]' : ''}
            }`),
            CLIENTE: 'N',
          };

          $('#tabelaProdutosConsultaEstoque').DataTable({
            paging: true,
            lengthChange: false,
            filter: false,
            info: true,
            order: false,
            autoWidth: true,
            destroy: true,
            serverSide: true,
            processing: true,
            ajax: {
              url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
              type: "GET",
              headers: {
                'Authorization': BASIC_AUTH
              },
              data: ajaxData,
            },
            columns: dataSetCols,
            columnDefs: [{
              "targets": indiceQtde,
              "className": 'pr-4 text-right'
            }]
          });
        } catch (error) {
          console.log(error)
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      $('#btnConsultarEstoque').on('click', async function() {
        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        if ($('#tabelaProdutosConsultaEstoque')[0].rows.length > 0) {
          await limpaTabela();
        }
        await buscaEstoque(tipoConsulta);

      });

      async function montaWherePesquisa(tipo) {
        let where = '';
        let tabela = tipo == 'P' ? `PA_ITEN` : `MAT_ITEN`
        where += pegaChave('#txtDepositoConsultaEstoque') != '' ? ` AND ${tabela}.DEPOSITO = '${pegaChave('#txtDepositoConsultaEstoque')}'` : '';
        where += pegaChave('#txtProdutoConsultaEstoque') != '' ? ` AND ${tabela}.CODIGO = '${pegaChave('#txtProdutoConsultaEstoque')}'` : '';

        return where;
      }

      async function montaTabela(tipo) {
        let tabela = '';

        if (tipo == 'M') {
          tabela = `MAT_ITEN`
        } else {
          tabela = `PA_ITEN`
        }

        return tabela;
      }

      async function montaCamposSelect(tipo) {
        let camposSelect = [];
        let colunas = [];

        if (tipo == 'M') {

          camposSelect = `["MAT_ITEN.CODIGO", "MATERIAL.DESCRICAO DESC_MATERIAL", "MAT_ITEN.BARRA", "MAT_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "MAT_ITEN.QTDE"]`;

          colunas = ["CODIGO", "DESC_MATERIAL", "BARRA", "COR", "DESC_COR", "QTDE"];


        } else {

          camposSelect = `["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO DESC_PRODUTO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.QUANTIDADE"]`;

          colunas = ["CODIGO", "DESC_PRODUTO", "COR", "DESC_COR", "TAM", "BARRA", "BARRA28", "BARRACLI", "QUANTIDADE"];

        }

        return objeto = {
          camposSelect: camposSelect,
          colunas: colunas
        };

      }

      // async function atualizaQtde(tipo) {
      //     if (tipo == 'M') {
      //         qtde_estoque = 0;
      //         qtde_estoque += $('#tabelaProdutosConsultaEstoque').DataTable().column(3, {}).data().sum();
      //         $('#txtQuantidadeItem').val(qtde_estoque);

      //     } else {
      //         qtde_estoque = 0;
      //         qtde_estoque += $('#tabelaProdutosConsultaEstoque').DataTable().column(6, {}).data().sum();
      //         $('#txtQuantidadeItem').val(qtde_estoque);
      //     }
      // }

      async function limpaTabela() {
        $('#tabelaProdutosConsultaEstoque').DataTable().destroy().draw(false);
        $('#tabelaProdutosConsultaEstoque').html('<thead></thead><tbody></tbody>');
      }

      $('#btnCamera').on('click', function() {
        if (getCookie('protocolo') == 'http') {
          msgAlerta('Funcionalidade não habilitada, entre em contato com o Suporte da Sisplan!');
          return;
        }
        cameraVenda = true;
        $('#modalCamera').modal('show');
        iniciaCamera();
      });

      $('#btnCameraPreco').on('click', function() {
        if (getCookie('protocolo') == 'http') {
          msgAlerta('Funcionalidade não habilitada, entre em contato com o Suporte da Sisplan!');
          return;
        }
        cameraVenda = false;
        $('#modalCamera').modal('show');
        iniciaCamera();
      });

      if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
        console.log("enumerateDevices() not supported.");
      } else {
        encontraCamera();
      }

      var backCamID;

      function encontraCamera() {
        navigator.mediaDevices.enumerateDevices()
          .then(function(devices) {
            devices.forEach(function(device) {
              if (device.kind == "videoinput" && device.label.match(/back/) != null) {
                backCamID = device.deviceId;
              }
            });
          })
          .catch(function(err) {
            console.log(err.name + ": " + err.message);
          });

        if (typeof(backCamID) == "undefined") {
          console.log("back camera not found.");
        }
      }

      function iniciaCamera() {
        if (!navigator.mediaDevices) {
          navigator.mediaDevices.getUserMedia({
            video: true
          }.then(function(stream) {
            console.log('forçado inicio da câmera')
          }))
        }
        Quagga.init({
          locate: false,
          numOfWorkers: 2,
          inputStream: {
            name: "Live",
            type: "LiveStream",
            target: document.querySelector('#cam'),
            constraints: {
              //  width: '100%',
              //  height: '100%',
              //  facingMode: "environment"
              deviceId: backCamID
            },
            area: {
              // update area if its small mobile
              top: "32%",
              right: "10%",
              left: "10%",
              bottom: "32%"
            }
          },
          decoder: {
            readers: ["code_128_reader"]
          },
        }, function(err) {
          if (err) {
            msgAlertaSemConfirmacao('Nenhum dispositivo com câmera encontrado para realizar a bipagem, verifique!', 'modalCamera');
            return;
          } else {

            fixiOSVideo();

            if (typeof resolve === "function") {
              resolve.call(this);
            }
          }
          console.log("Initialization finished. Ready to start");
          Quagga.start();
        });

      }

      Quagga.onDetected(({
        codeResult
      }) => {
        const regexBarra = /[^/\\a-zA-Z0-9]/;
        if (regexBarra.test(codeResult.code)) {
          return;
        }

        if (isValidCode(codeResult)) {
          Quagga.stop();
          if (cameraVenda) {
            $('#txtCodigo').val(codeResult.code).trigger('blur');
          } else {
            $('#txtBarra').val(codeResult.code).trigger('blur');
          }

          $('#modalCamera').modal('hide');
        }

        Quagga.lastScannedCode = codeResult.code;

      });

      Quagga.onProcessed((result) => {
        const drawingCtx = Quagga.canvas.ctx.overlay;

        clearDrow();

        if (result) {
          if (result.boxes) {
            if (!Quagga.drowBox) {
              Quagga.drowBox = result.boxes[0];
            }

            Quagga.ImageDebug.drawPath(Quagga.drowBox, {
              x: 0,
              y: 1
            }, drawingCtx, {
              color: "green",
              lineWidth: 3
            });
          }

          const currentTime = Date.now();

          if (!Quagga.lastDetectingTime) {
            Quagga.lastDetectingTime = currentTime;
          }

          if (result.codeResult) {
            Quagga.lastDetectingTime = currentTime;
          } else if ((currentTime - Quagga.lastDetectingTime) / 1000 >= 2) {
            Quagga.lastDetectingTime = currentTime;
          }

          if (result.codeResult && result.codeResult.code) {
            Quagga.ImageDebug.drawPath(
              result.line, {
                x: "x",
                y: "y"
              },
              drawingCtx, {
                color: "red",
                lineWidth: 3
              }
            );
          }
        }
      });

      function clearDrow() {
        const drawingCtx = Quagga.canvas.ctx.overlay;
        const drawingCanvas = Quagga.canvas.dom.overlay;

        drawingCtx.clearRect(0, 0, parseInt(drawingCanvas.width), parseInt(drawingCanvas.height));
      }

      function fixiOSVideo() {
        const videoElement = Quagga.canvas.dom.overlay.parentElement.querySelector("video");

        setTimeout(() => {
          videoElement.play();
        }, 10);
      }

      function isValidCode({
        decodedCodes
      }) {
        const errors = decodedCodes.filter((x) => x.error !== undefined).map((y) => y.error); // TODO: use reduce
        const median = getMedian(errors);

        return median < 0.8;
      }

      function getMedian(arr) {
        const sorted = [...arr].sort((a, b) => a - b);
        const half = Math.floor(sorted.length / 2);

        if (arr.length % 2 === 1) {
          return arr[half];
        }

        return (arr[half - 1] + arr[half]) / 2;
      }

      $('#modalCamera').on('hidden.bs.modal', function() {
        Quagga.stop();
      });

      async function informacoesCliente(sChave) {
        const pesquisaParam = {
          tabela: "ENTIDADE",
          camposSelect: [
            "ENTIDADE.CODCLI",
            "ENTIDADE.NOME",
            "ENTIDADE.CNPJ",
            "ENTIDADE.EMAIL",
            "ENTIDADE.DDD_FONE",
            "ENTIDADE.TELEFONE",
            "ENTIDADE.COD_PAIS",
            "ENTIDADE.CEP",
            "CIDADE.NOME CIDADE",
            "CIDADE.COD_UF ESTADO",
            "ENTIDADE.BAIRRO",
            "ENTIDADE.ENDERECO",
            "ENTIDADE.NUMERO",
            "ENTIDADE.COMPLEMENTO",
            "ENTIDADE.OBS",
            "ENTIDADE.INSCRICAO",
            "ENTIDADE.DATA_CAD",
            "ENTIDADE.CLASSIFICA",
            "ENTIDADE.PERFIL",
            "PERFIL.DESCRICAO AS DESC_PERFIL",
            "ENTIDADE.GRUPO",
            "GRUPO_CLI.DESCRICAO AS DESC_GRUPO",
            "ENTIDADE.DESCONTO",
            "ENTIDADE.DT_NASC"
          ],
          leftjoin: [{
              tabela: "CADCEP",
              condicao: "ENTIDADE.CEP = CADCEP.CEP"
            },
            {
              tabela: "CIDADE",
              condicao: "CADCEP.CODMUN = CIDADE.CODIGO"
            },
            {
              tabela: "GRUPO_CLI",
              condicao: "ENTIDADE.GRUPO = GRUPO_CLI.CODIGO"
            },
            {
              tabela: "PERFIL",
              condicao: "ENTIDADE.PERFIL = PERFIL.CODIGO"
            }
          ],
          where: [`ENTIDADE.CODCLI = '${sChave}'`],
          camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        $('#txtDataCadastroInfo').val(jsonStr[0].DATA_CAD.slice(0, 10));
        $('#txtDataNascimentoInfo').val(jsonStr[0].DT_NASC?.slice(0, 10));
        $('#txtCpfInfoCliente').val(jsonStr[0].CNPJ);
        $('#txtEmailInfoCliente').val(jsonStr[0].EMAIL);
        $('#txtDddInfoCliente').val(jsonStr[0].DDD_FONE);
        $('#txtTelefoneInfoCliente').val(jsonStr[0].TELEFONE);
        await concatenaPais(jsonStr[0].COD_PAIS);
        $('#txtCepInfoCliente').val(jsonStr[0].CEP);
        $('#txtMunicipioInfoCliente').val(jsonStr[0].CIDADE);
        $('#txtEstadoInfoCliente').val(jsonStr[0].ESTADO);
        $('#txtBairroInfoCliente').val(jsonStr[0].BAIRRO);
        $('#txtEnderecoInfoCliente').val(jsonStr[0].ENDERECO);
        $('#txtNumeroInfoCliente').val(jsonStr[0].NUMERO);
        $('#txtComplementoInfoCliente').val(jsonStr[0].COMPLEMENTO);
        $('#txtObsInfoCliente').val(jsonStr[0].OBS);
        $('#txtInscricaoInfoCliente').val(jsonStr[0].INSCRICAO);
        const classificacaoEntidadeInfo = jsonStr[0].CLASSIFICA.replace('    ', '');
        if (classificacaoEntidadeInfo != '' && classificacaoEntidadeInfo != 'null' && classificacaoEntidadeInfo != null) {
          $('#txtClassificacaoInfoCliente').val(classificacaoEntidadeInfo);
        }
        if (jsonStr[0].GRUPO != '' && jsonStr[0].GRUPO != null) {
          $('#txtGrupoInfoCliente').val(`[${jsonStr[0].GRUPO}] - ${jsonStr[0].DESC_GRUPO}`);
        };
        if (jsonStr[0].PERFIL != '' && jsonStr[0].PERFIL != null) {
          $('#txtPerfilInfoCliente').val(`[${jsonStr[0].PERFIL}] - ${jsonStr[0].DESC_PERFIL}`);
        };
        $('#txtPercDescontoInfoCliente').val(jsonStr[0].DESCONTO);
      }

      async function concatenaPais(sPais) {
        let retorno = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"CADPAIS",
            "camposSelect":["NOME"],
            "where": ["CODIGO = '${sPais}'"]}`,
          null
        );
        let jsonString = await retorno.json();
        if (jsonString.RESULT[0] != 0) {
          insereValor($("#txtPaisInfoCliente"), sPais, jsonString.RESULT[0][0].NOME);
        }
        return
      }

      $('#btn-info-cliente').on('click', async function() {
        const tipoMsgRegraVenda = await verificaTipoMsgRegraVenda(pegaChave('#txtCliente'));
        if (tipoMsgRegraVenda == 'A' || !tipoMsgRegraVenda) {
          const infoCliente = $('#txtCliente').val();
          if (infoCliente === '') {
            msgAlertaSemConfirmacao('Favor informar um cliente para utilizar este botão!');
          } else {
            const clienteTitulo = $('#txtCliente').val().replace('[', '').replace(']', '').split('-');
            await informacoesCliente(pegaChave("#txtCliente"));
            $('#modal-info-cliente').modal('show');
            $('#txtCodigoTittle').html(`${clienteTitulo[0]}-${clienteTitulo[1]}`);
          }
        }
      });

      async function verificaTipoMsgRegraVenda(sCodcli) {
        const tipoVenda = $('#txtTipoVenda').val();
        const url = '/sisplan/regrasmontadasvenda/v1/regrasmontadasvenda?';
        const params = `CODCLI=${sCodcli}&TIPOVENDA=${tipoVenda}`;
        const response = await requisicao("GET", url, params, null);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          return;
        }

        const jsonStr = await response.json();
        2
        if (jsonStr) {
          return jsonStr.tipo_msg;
        }
      }

      async function conferePedido(biparEstornar, barra) {
        try {
          function bipaBarra(arrIndices) {
            const indice = arrIndices[0];
            const qtde = 1;
            let retorno = 0;
            const dadosItem = $('#tabelaImportarPedidos').DataTable().row(indice).data();
            if (((dadosItem.qtde_conf + (qtde)) <= dadosItem.qtde) && biparEstornar) {
              dadosItem.qtde_conf += qtde;
              if (dadosItem.qtde_conf == dadosItem.qtde) {
                dadosItem.codigo = dadosItem.codigo.replace('times-circle', 'check-circle').replace('#EEAD2D', 'green');
              }
              retorno = 0;
            } else if (biparEstornar && (dadosItem.qtde_conf < dadosItem.qtde)) {
              retorno = 1;
            } else if (biparEstornar) {
              retorno = 2;
            } else if (!biparEstornar && ((dadosItem.qtde_conf - qtde) >= 0)) {
              dadosItem.codigo = dadosItem.codigo.replace('check-circle', 'times-circle').replace('green', '#EEAD2D');
              dadosItem.qtde_conf -= qtde;
              retorno = 0;
            } else if (!biparEstornar && ((dadosItem.qtde_conf - qtde) < 0) && (qtde > 1)) {
              retorno = 3;
            } else {
              retorno = 4;
            }

            $('#tabelaImportarPedidos').DataTable().row(indice).data(dadosItem).draw(false);
            $($('#tabelaImportarPedidos tbody tr')[indice]).click();

            if ((arrIndices.length > 1) && (retorno != 0)) {
              arrIndices.shift();
              return bipaBarra(arrIndices);
            } else {
              return retorno;
            }
          }
          if (barra == '') {
            return;
          }
          const barralog = await extraiBarra28(barra);
          const dados = $('#tabelaImportarPedidos').DataTable().rows().data();
          let indices = [];
          dados.map((item, idx) => {
            if (item.barra == barra || item.barra28 == barra || item.barraCli == barra || (barralog != '' && item.barra28 == barralog)) {
              indices.push(idx)
            }
          });
          if (indices.length == 0) {
            msgAlerta('Nenhuma barra localizada');
            SomAlerta(BASE_URI, true);
            return;
          }

          const retorno = bipaBarra(indices);
          switch (retorno) {
            case 0: {
              SomAlerta();
              break;
            }
            case 1: {
              msgAlerta('Impossível bipar quantidade maior do que há de pendente.');
              SomAlerta(BASE_URI, true);
              break;
            }
            case 2: {
              msgAlerta('Quantidade total do item já conferida');
              SomAlerta(BASE_URI, true);
              break;
            }
            case 3: {
              msgAlerta('Impossível estornar quantidade maior do que a conferida.');
              SomAlerta(BASE_URI, true);
              break;
            }
            case 4: {
              msgAlerta('Toda a quantidade já foi estornada.');
              SomAlerta(BASE_URI, true);
              break;
            }
          }
        } finally {
          $(`#txtBarraPedido`).val('');
          $(`#txtBarraPedido`).focus();
        }
      };

      async function RetornaItensImportarPedido(iPedido, iDeposito) {
        $.LoadingOverlay('show');
        if ($.fn.DataTable.isDataTable("#tabelaImportarPedidos")) {
          if ($('#tabelaImportarPedidos').DataTable().rows().count() > 0) {
            $("#tabelaImportarPedidos").DataTable().destroy();
            $("#tabelaImportarPedidos").empty();
          }
        }

        try {
          let iQtde = $('input[name="radioImportacao"]:checked').val();
          let quantidadeCasasDecimaisParametro = await CopiaParametro('SISTEMA', 1);
          let quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
          const campos = ['codigo', 'descricao', 'cor', 'descCor', 'tam', 'qtde', 'qtde_f', 'qtde_conf', 'preco', 'tipo', 'id_Estoque', 'barra', 'barra28', 'barraCli', 'ordem', 'qtde_orig', 'zero', 'qualidade'];
          let camposInvisiveis = [10, 11, 12, 13, 14, 15, 16];

          if (iQtde == 'P') {
            camposInvisiveis = [6, 11, 12, 13, 14, 15, 16, 17];
          } else if (iQtde == 'F') {
            camposInvisiveis = [5, 11, 12, 13, 14, 15, 16, 17];
          } else {
            camposInvisiveis = [11, 12, 13, 14, 15, 16, 17];
          }

          const url = `/sisplan/vendas/v1/importapedido?`;
          const params = `PEDIDO=${iPedido}&DEPOSITO=${iDeposito}&QTDE=${iQtde}&PRECOPEDIDO=${isChecked('#cbBuscaPrecoPedido') ? 'S' : 'N'}`;
          const response = await requisicao('GET', url, params, '', 900000);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.mensagem);
            $('#txtPedido').val('');
            return;
          }

          const itens = await corrigeCamposPedido(jsonStr.itens, iQtde);

          if (itens.length == 0) {
            msgAlerta('Pedido não possui itens para importar.');
            return;
          }

          let dataSetCols = [];

          let keys = Object.keys(itens[0]);

          for (var k in keys) {
            if (jQuery.inArray(keys[k], campos) > -1) {
              dataSetCols.push({
                'title': keys[k].toUpperCase(),
                'data': keys[k]
              });
            }
          }

          tabelaImportarPedidos = $('#tabelaImportarPedidos').DataTable({
            destroy: true,
            select: true,
            keys: false,
            searching: false,
            lengthChange: false,
            scrollCollapse: true,
            paging: false,
            filter: false,
            info: false,
            order: false,
            scrollx: true,
            "columns": dataSetCols,
            "data": itens,
            columnDefs: [{
                targets: camposInvisiveis,
                visible: false,
              },
              {
                "render": function(data) {
                  return parseFloat(data).toLocaleString("pt-BR", {
                    maximumFractionDigits: quantidadeCasasDecimaisCampo,
                    minimumFractionDigits: quantidadeCasasDecimaisCampo
                  })
                },
                "targets": [5, 6],
              }
            ],
          });

          $('#btn_confirmar_pedido_importado').unbind('click');
          $('#btn_confirmar_pedido_importado').on('click', async function() {
            importaPedido = true;
            insereValor('#txtTabela', jsonStr.tab_pre, jsonStr.desc_regiao);
            insereValor('#txtCliente', jsonStr.codcli, jsonStr.nome);
            $('#txtFrete').val(jsonStr.frete);
            $('#txtCNPJ').val(jsonStr.cnpj);
            await confirmarImportacaoPedido();
          });

        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar os itens do pedido.');
        } finally {
          $.LoadingOverlay("hide");
        }
      };

      async function confirmarImportacaoPedido() {
        $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
        const qtde = $('#radioImpPedidoPendentes').is(':checked') ? 'qtde' : $('#radioImpPedidoFaturados').is(':checked') ? 'qtde_f' : 'qtde';
        const qtde_conf = $("#tabelaImportarPedidos").DataTable().column(10, {}).data().sum();
        if (qtde_conf > 0) {
          await importaItensPedido('qtde_conf');
        } else {
          msgAlerta('Pedido sem quantidades conferidas, deseja importar todo o pedido?', async function() {
            await importaItensPedido(qtde);
          }, async function() {
            return;
          });
        }
        await importaCondicaoPagamentoPedido()
      };

      async function importaCondicaoPagamentoPedido() {
        const pesquisa = {
          tabela: 'COND_PAGTO',
          camposSelect: ['COND_PAGTO.CODCOND', 'CONDICAO.DESCRICAO DESC_CONDICAO', 'COND_PAGTO.MOEDA', 'MOEDA.DESCRICAO DESC_MOEDA'],
          where: [`NUMERO = '${pegaChave('#txtPedido')}'`],
          leftJoin: [{
            tabela: 'CONDICAO',
            condicao: 'CONDICAO.CODCOND = COND_PAGTO.CODCOND'
          }, {
            tabela: 'MOEDA',
            condicao: 'MOEDA.CODMOE = COND_PAGTO.MOEDA'
          }]
        }
        const listaMoedasEmpresa = await retornaMoedasEmpresa();

        listaMoedasEmpresa.length > 0 && pesquisa.where.push(`COND_PAGTO.MOEDA IN (${listaMoedasEmpresa.toString()})`);

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        if (jsonStr.length > 0) {
          insereValor('#txtCondicaoDePagamento', jsonStr[0].CODCOND, jsonStr[0].DESC_CONDICAO);
          insereValor('#txtMoeda', jsonStr[0].MOEDA, jsonStr[0].DESC_MOEDA);
          insereValor('#txtCodCondMoeda', jsonStr[0].CODCOND, jsonStr[0].DESC_CONDICAO);
          await RotinaSaidaMoeda()
        }
      }

      async function importaItensPedido(sCampo = 'qtde') {
        for (let i = 0; i < $('#tabelaImportarPedidos').DataTable().rows().count(); i++) {
          await sleep(100);
          const dados = $('#tabelaImportarPedidos').DataTable().row(i).data();
          insereValor('#txtQualidade', dados.qualidade, dados.qualidade);
          $("#txtCodigo").attr("informacoesItem", `${dados.codigo} - ${dados.descricao}`);
          if ((dados.barra != '') && (dados[sCampo] > 0)) {
            await $('#txtCodigo').val(dados[sCampo] + '*' + dados.barra);
            await RotinaSaidaCodigo(dados.tipo, pegaChave('#txtPedido'), dados.ordem, dados.caixa, false, (dados.tipo == 'M' ? (dados.codigo.substring(dados.codigo.indexOf('</div'))).replace('</div>  ', '') : ''), dados.tipo == 'M' ? dados.cor : '');
          } else if (dados[sCampo] > 0) {
            $("#txtQuantid").val(dados[sCampo]);
            $('#txtIdItem').val(dados.id_Estoque);
            await RotinaSaidaCodigo(dados.tipo, pegaChave('#txtPedido'), dados.ordem, dados.caixa);
          }
        }
        $('#txtQualidade').val('');
        await $('#modalImportarVendas').modal('hide');
        await blurCliente();
        await changeCliente();
        if (((parametrosVenda[29] == 1) && (pegaChave('#txtRegraPromocao') != '')) || (parametrosVenda[29] == 2)) {
          await eventoClickBtnRecalcularRegra();
        }
      };

      $("#radioProduto, #radioMaterial").on("change", function() {
        if ($("#radioProduto").prop("checked")) {
          $("#txtQuantid").val(1);
        } else {
          $('#modalProduto').modal('hide');
          $('#modalMaterial').modal('show');
          $("#radioProduto").prop("checked", true);
          $("#txtQuantid").val('');
        }
      });

      function ajustaCamposIntegracaoTeiaCard(bAtiva) {
        $(".autorizacao").removeClass("d-none");
        $("#txtAutorizacao").addClass("focus");
      }

      async function verificaSolicitacaoEstoque() {
        try {
          const pesquisa = {
            tabela: 'DEMANDA_RECEBER',
            camposSelect: ['COUNT(*) QTDE'],
          }
          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          if (jsonStr[0].QTDE > 0) {
            $('#btnSolicitacaoEstoque').removeClass('d-none');
            await verificaSolicitacaoParaLojaAtual();
          }

        } catch (error) {

        }
      }

      async function verificaSolicitacaoParaLojaAtual() {
        try {
          const depositosEmp = getCookie('depositos_empresa');
          if (depositosEmp != '') {
            const pesquisa = {
              tabela: 'DEMANDA_ENVIAR',
              camposSelect: ['COUNT(*) QTDE'],
              where: [`DEMANDA_ENVIAR.DEPOSITO IN (${depositosEmp}) AND DEMANDA_ENVIAR.STATUS = 'PENDENTE' AND DEMANDA_ENVIAR.QTDE_SOLICITADA > DEMANDA_ENVIAR.QTDE_ENVIADA`]
            }
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
            if (jsonStr[0].QTDE > 0) {
              // $('#btnSom').trigger("click");
              $('.icone').addClass('notificacao-ativa');
            } else {
              $('.icone').removeClass('notificacao-ativa');
            }
          }
        } catch (error) {

        }
      }

      async function carregaValoresPadroes() {
        const jsonStr = await buscaValoresPadroes('LOJA')

        jsonStr.map(async (item) => {
          switch (item.CAMPO) {
            case 'INFORMACOES_CLIENTE': {
              if (item.VALOR == 'S') {
                bInformacoesCliente = true;
              }
              break;
            }
            case "BUSCA_PRECO_PEDIDO": {
              $("#cbBuscaPrecoPedido").prop("checked", item.VALOR == "Sim");
              break;
            }
            case "QUALIDADE": {
              if (parametrosVenda[41] == 1) {
                if (await Existe('TABQUL', ['CODIGO'], [item.VALOR])) {
                  insereValor('#txtQualidade', item.VALOR, {
                    tabela: 'TABQUL',
                    campoBusca: 'DESCRICAO',
                    campoWhere: 'CODIGO',
                    valorWhere: item.VALOR
                  })
                }
              }
              break;
            }
            case "TAB_PRECO_BRINDE": {
              if (item.VALOR != '') {
                insereValor('#txtTabPrecoBrinde', item.VALOR, {
                  tabela: 'REGIAO',
                  campoBusca: 'DESCRICAO',
                  campoWhere: 'REGIAO',
                  valorWhere: item.VALOR
                })
              }
              break;
            }
            case "DESCONTO_ITENS_PROMOCIONAIS": {
              if (item.VALOR == 'S') {
                bSemDescontoItensPromocionais = true;
              }
              break;
            }
          }
        });
      };

      $("#txtCelular").mask("(00) 90000-0000");

      $("#modalCRMBonus").on("show.bs.modal", async function() {
        resetaModalCRMBonus();
        await preencheModalCRMBonus(pegaChave("#txtCliente"));
      })

      $("#btnIniciarCRMBonus").on("click", async function() {
        $.LoadingOverlay("show");
        try {
          await iniciarCRMBonus();
        } finally {
          $.LoadingOverlay("hide");
        }

      })

      $("#btnReenviarPIN").on("click", async function() {
        $.LoadingOverlay("show");
        try {
          await reenviarPIN();
        } finally {
          $.LoadingOverlay("hide");
        }
      })

      $("#btnConfirmarPIN").on("click", async function() {
        $.LoadingOverlay("show");
        try {
          await validarPIN();
        } finally {
          $.LoadingOverlay("hide");
        }
      })

      $("#btnConfirmarCRMBonus").on("click", function() {
        infoCRMBonus.utilizaSaldo = $("#checkUtilizarSaldo").prop("checked");
        if (infoCRMBonus.utilizaSaldo) {
          $('#painelCashback').removeClass('d-none');
          $("#txtCashbackCliPagto").val(infoCRMBonus.saldo_bonus.toFixed(2));
        } else {
          infoCRMBonus.ids_bonus = " ";
          infoCRMBonus.saldo_bonus = 0;
        }
        jaUtilizouCashback = true;
        $("#modalCRMBonus").modal("hide");
      })

      $("#btnFecharCRMBonus").on("click", function(e) {
        if (Object.keys(infoCRMBonus).length > 0) {
          if (!infoCRMBonus.flag_acumular_bonus) {
            e.stopPropagation();
            msgAlerta("Opção de acumular bônus está desativada, o desconto do cashback será aplicado como desconto!", () => {
              $("#btnConfirmarCRMBonus").trigger("click");
            });
          } else if (infoCRMBonus.valid_pin) {
            e.stopPropagation();
            msgAlerta("Tem certeza que deseja cancelar? O saldo de cashback não será aplicado como desconto!", () => {
              $("#modalCRMBonus").modal("hide");
              infoCRMBonus.utilizaSaldo = false;
              infoCRMBonus.ids_bonus = " ";
              infoCRMBonus.saldo_bonus = 0;
              jaUtilizouCashback = true;
            });
          }
        }
      })

      $("#modalCampanhasCRMBonus").on("shown.bs.modal", function() {
        $("#tabelaCampanhasCRMBonus").DataTable().columns.adjust().draw(false);
      })

      async function preencheModalCRMBonus() {
        const codCli = pegaChave("#txtCliente");
        try {
          const pesquisa = {
            tabela: 'ENTIDADE',
            camposSelect: ['NOME', 'EMAIL', 'DT_NASC', 'DDD_FONE AS DDD', 'TELEFONE'],
            where: [`CODCLI = '${codCli}'`]
          };

          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          if (jsonStr.length > 0) {
            $("#lblCliente").html(`Cliente: ${jsonStr[0].NOME}`);
            $("#lblCliente").val(jsonStr[0].NOME);
            $("#lblEmail").html(`E-mail: ${jsonStr[0].EMAIL}`);
            $("#lblEmail").val(jsonStr[0].EMAIL);
            $("#lblDataNascimento").html(`Data de Nascimento: ${jsonStr[0].DT_NASC == '1899-12-30' ? "" : formataDataBonita(jsonStr[0].DT_NASC)}`);
            $("#lblDataNascimento").val(jsonStr[0].DT_NASC == '1899-12-30' ? "" : formataDataBonita(jsonStr[0].DT_NASC));
            $("#txtCelular").val(`${jsonStr[0].DDD}${jsonStr[0].TELEFONE}`);
            $("#txtCelular").trigger("input");
          }

        } catch (error) {
          console.error(error);
        }

      }

      async function iniciarCRMBonus() {
        const celular = replaceVarios($("#txtCelular").val(), ['(', ')', ' ', '-'], '');
        const cliente = $("#lblCliente").val();
        const dataNascimento = $("#lblDataNascimento").val();
        const email = $("#lblEmail").val();

        if (celular == "") {
          throw msgAlerta("Necessário informar um número de celular para prosseguir.");
        }

        if (cliente == "") {
          throw msgAlerta("Não foi possível prosseguir com a operação, nome do cliente não informado! Verifique.");
        }

        try {
          const response = await requisicao('GET', '/sisplan/crmbonus/v1/iniciar?', `CLIENTE=${cliente}&CELULAR=${celular}&EMAIL=${email}&DT_NASCIMENTO${dataNascimento}`);

          if (!response) {
            throw msgAlerta("Não foi possível iniciar o CRM&Bônus.");
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            throw msgAlerta(jsonStr.mensagem);
          }

          infoClienteCRMBonus = jsonStr.data;

          $("#txtCelular").prop("disabled", true);
          $("#btnIniciarCRMBonus").prop("disabled", true);
          $("#btnReenviarPIN").removeClass("d-none");
          if (jsonStr.data.solicita_pin) {
            $("#divInfoPIN").removeClass("d-none");
            $("#divPIN").removeClass("d-none");
          } else {
            await bonusDisponivel(celular);
            infoCRMBonus.pin_master = false;
            infoCRMBonus.valid_pin = true;
            infoClienteCRMBonus.sms = " ";
            $("#divSaldo").removeClass("d-none");
            if (infoCRMBonus.flag_acumular_bonus) {
              $("#divUtilizarSaldo").removeClass("d-none");
            }
            $("#modalFooterCRMBonus").removeClass("d-none");
          }


        } catch (error) {
          console.error(error);
        }

      }

      function eventoClickConfirmarCampanhasCRMBonus(callBack) {
        return new Promise((resolve) => {
          const botaoConfirmar = $("#btnConfirmarCampanhasCRMBonus");
          const botaoFechar = $("#btnFecharCampanhasCRMBonus");


          async function handleClick() {
            const registroSelecionado = $("#tabelaCampanhasCRMBonus").DataTable().rows(".selected").data().toArray();

            if (registroSelecionado.length <= 0) {
              msgAlerta("Necessário selecionar uma das Campanhas disponíveis no grid.");
            } else {
              infoCRMBonus.campanhaSelecionada = registroSelecionado[0][0];
              await finalizarCRMBonus();
              botaoConfirmar.off("click", handleClick);
              botaoFechar.off("click", handleClose);
              $("#modalCampanhasCRMBonus").modal("hide");
              resolve();
            }

          }

          async function handleClose(e) {
            e.stopPropagation();

            msgAlerta("Tem certeza que deseja fechar a tela? O cliente não será bonificado caso não informe uma campanha.",
              async () => {
                infoCRMBonus.campanhaSelecionada = -1;
                await finalizarCRMBonus();
                botaoConfirmar.off("click", handleClick);
                botaoFechar.off("click", handleClose);
                $("#modalCampanhasCRMBonus").modal("hide");
                resolve();
              });

          }

          botaoConfirmar.on("click", handleClick);
          botaoFechar.on("click", handleClose);

        })

      }

      async function reenviarPIN() {
        const celular = replaceVarios($("#txtCelular").val(), ['(', ')', ' ', '-'], '');

        if (celular == "") {
          throw msgAlerta("Necessário informar um número de celular para prosseguir.");
        }

        try {
          const response = await requisicao("GET", "/sisplan/crmbonus/v1/reenviar?", `ID_CLIENTE=${infoClienteCRMBonus.customer_id}&CELULAR=${celular}`);

          if (!response) {
            throw msgAlerta("Não foi possível reenviar o PIN.");
          }

          if (response.status != 200) {
            const jsonStr = await response.json();
            throw msgAlerta(jsonStr.mensagem);
          }

        } catch (error) {
          console.error(error);
        }
      }

      async function validarPIN() {
        const celular = replaceVarios($("#txtCelular").val(), ['(', ')', ' ', '-'], '');
        const pin = $("#txtPIN").val();

        if (pin == "") {
          throw msgAlerta("Necessário informar o PIN para prosseguir.");
        }

        if (celular == "") {
          throw msgAlerta("Necessário informar um número de celular para prosseguir.");
        }

        try {
          const response = await requisicao("GET", "/sisplan/crmbonus/v1/validar?", `ID_CLIENTE=${infoClienteCRMBonus.customer_id}&CELULAR=${celular}&PIN=${pin}`);

          if (!response) {
            throw msgAlerta("Não foi possível validar o PIN.");
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            throw msgAlerta(jsonStr.mensagem);
          }

          if (jsonStr.data.valid_pin) {
            await bonusDisponivel(celular);
            infoCRMBonus.pin_master = jsonStr.data.pin_master;
            infoCRMBonus.valid_pin = jsonStr.data.valid_pin;
            $("#txtPIN").prop("disabled", true);
            $("#btnPIN").prop("disabled", true);
            $("#divSaldo").removeClass("d-none");
            $("#divPINValido").removeClass("d-none");
            if (infoCRMBonus.flag_acumular_bonus) {
              $("#divUtilizarSaldo").removeClass("d-none");
            }
            $("#modalFooterCRMBonus").removeClass("d-none");
            $("#btnConfirmarPIN").prop("disabled", true);
            $("#divPINInvalido").addClass("d-none");
            $("#btnReenviarPIN").prop("disabled", true);
          } else {
            $("#divPINInvalido").removeClass("d-none");
          }

        } catch (error) {
          console.error(error);
        }
      }

      function resetaModalCRMBonus() {
        $("#txtCelular").prop("disabled", false);
        $("#btnIniciarCRMBonus").prop("disabled", false);
        $("#btnReenviarPIN").addClass("d-none");
        $("#btnReenviarPIN").prop("disabled", false);
        $("#divInfoPIN").addClass("d-none");
        $("#divPIN").addClass("d-none");
        $("#divPINValido").addClass("d-none");
        $("#divPINInvalido").addClass("d-none");
        $("#divUtilizarSaldo").addClass("d-none");
        $("#modalFooterCRMBonus").addClass("d-none");
      }

      async function bonusDisponivel(celular) {
        const valorBruto = $("#txtValorLiquidoMoeda").val().replace('.', ',');
        infoClienteCRMBonus.valorBruto = valorBruto;
        try {

          const response = await requisicao("GET", "/sisplan/crmbonus/v1/bonusdisponivel?", `ID_CLIENTE=${infoClienteCRMBonus.customer_id}&CELULAR=${celular}&VALOR_BRUTO=${valorBruto}`);

          if (!response) {
            throw msgAlerta("Não foi possível consultar o cashback disponível.");
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            throw msgAlerta(jsonStr.mensagem);
          }

          infoCRMBonus = jsonStr.data;

          if (infoCRMBonus.saldo_bonus > 0) {
            $("#lblSaldo").html(`Saldo: R$ ${infoCRMBonus.saldo_bonus.toFixed(2).replace('.', ',')}`);
          }

        } catch (error) {
          console.error(error);
        }
      }

      async function campanhaDisponivel(totalLiquido) {
        try {
          const response = await requisicao("GET", "/sisplan/crmbonus/v1/campanhadisponivel?", `TOTAL_LIQUIDO=${totalLiquido}`);

          if (!response) {
            msgAlerta("Não foi possível consultar as campanhas disponíveis.");
            return false;
          }

          const jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.mensagem);
            return false;
          }

          montaModalCampanhas(jsonStr.data.campanhas, totalLiquido);
          $("#modalCampanhasCRMBonus").modal("show");
          return true;

        } catch (error) {
          console.error(error);
        }
      }

      function montaModalCampanhas(campanhas, valor) {

        $("#lblClienteCampanhasCRMBonus").html($("#lblCliente").html());
        $("#lblEmailCampanhasCRMBonus").html($("#lblEmail").html());
        $("#lblDataNascimentoCampanhasCRMBonus").html($("#lblDataNascimento").html());
        $("#lblValorCampanhasCRMBonus").html(`Valor: R$${valor}`);
        $("#lblValorCampanhasCRMBonus").val(valor);
        $("#lblCelularCampanhasCRMBonus").html(`Celular: ${$("#txtCelular").val()}`);

        criaDataTablePadrao('#tabelaCampanhasCRMBonus', false, false, false, false, true, false, '200px');
        campanhas.forEach(campanha => {
          $("#tabelaCampanhasCRMBonus").DataTable().row.add([campanha.id, campanha.texto]).draw(false);
        })

        $('#tabelaCampanhasCRMBonus tbody').unbind('click');
        $('#tabelaCampanhasCRMBonus tbody').on('click', 'tr', async function() {
          if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
          } else {
            $('#tabelaCampanhasCRMBonus').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
          }
        });

      }

      async function finalizarCRMBonus() {
        $.LoadingOverlay("show");
        try {

          const response = await requisicao("GET", "/sisplan/crmbonus/v1/finalizar?", montaParamsFinalizarCRMBonus());

          if (!response) {
            throw msgAlerta("Não foi possível finalizar o CRMBonus.");
          }

          if (response.status != 200) {
            const jsonStr = await response.json();
            throw msgAlerta(jsonStr.mensagem);
          }

        } catch (error) {
          console.error(error);
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      async function vendasTotaisCRMBonus(valorLiquido) {
        try {

          const response = await requisicao("GET", "/sisplan/crmbonus/v1/vendastotais?", montaParamsVendasTotais() + `&VALOR_LIQUIDO=${valorLiquido}`);

          if (!response) {
            throw msgAlerta("Não foi possível salvar as vendas no CRMBonus.");
          }

          if (response.status != 200) {
            const jsonStr = await response.json();
            throw msgAlerta(jsonStr.mensagem);
          }

        } catch (error) {
          console.error(error);
        }
      }

      function montaParamsFinalizarCRMBonus() {
        const vendedor = pegaDescricao("#txtVendedor");
        const caixa = pegaChave(sessionStorage.getItem("g_caixa_logado"));
        const codVen = $('#txtCodVen').val();
        const celular = replaceVarios($("#txtCelular").val(), ['(', ')', ' ', '-'], '');
        const qtdeItens = $('#tabelaItens').DataTable().column(2, {}).data().sum();
        const valorLiquido = $("#lblValorCampanhasCRMBonus").val();
        const cliente = pegaDescricao("#txtCliente");

        const params = `RESTRICAO_HORARIO=${infoCRMBonus.restricao_horario}` +
          `&UTILIZAR_BONUS=${infoCRMBonus.utilizaSaldo}` +
          `&IDS_BONUS=${infoCRMBonus.ids_bonus}` +
          `&ID_CLIENTE=${infoClienteCRMBonus.customer_id}` +
          `&VALOR_BRUTO=${infoClienteCRMBonus.valorBruto}` +
          `&BONUS_RESGATADO=${infoCRMBonus.saldo_bonus.toFixed(2).replace('.', ',')}` +
          `&ID_CAMPANHA=${infoCRMBonus.campanhaSelecionada}` +
          `&SMS=${infoClienteCRMBonus.sms}` +
          `&PIN_MASTER=${infoCRMBonus.pin_master}` +
          `&VENDEDOR=${vendedor}` +
          `&CAIXA=${caixa}` +
          `&CODVEN=${codVen}` +
          `&CELULAR=${celular}` +
          `&QTDE_ITENS=${qtdeItens}` +
          `&VALOR_LIQUIDO=${valorLiquido}` +
          `&CLIENTE=${cliente}`

        return params;
      }

      function montaParamsVendasTotais() {
        const vendedor = pegaDescricao("#txtVendedor");
        const codVen = $('#txtCodVen').val();
        const celular = replaceVarios($("#txtCelular").val(), ['(', ')', ' ', '-'], '');
        const qtdeItens = $('#tabelaItens').DataTable().column(2, {}).data().sum();
        const cliente = pegaDescricao("#txtCliente");

        const params = `VENDEDOR=${vendedor}` +
          `&CODVEN=${codVen}` +
          `&CELULAR=${celular}` +
          `&QTDE_ITENS=${qtdeItens}` +
          `&CLIENTE=${cliente}`

        return params;
      }

      if (bloqueiaAbasInfosEItensVenda) {
        $.LoadingOverlay("show");
        try {
          if (await validaVendaGerouDeConsignado(numero_venda)) {
            $("#btnPagamento").trigger("click");
          }
        } finally {
          $.LoadingOverlay("hide");
        }

      }

      async function regraPromocaoModelo6(regra) {
        if (regra.length === 0) return;

        $.LoadingOverlay('show');
        try {
          $("#tabelaItensUtilizamRegra").DataTable().clear();
          const itens = $("#tabelaItens").DataTable().rows().data();
          const itensRegra = $("#tabelaItensRegraPromocao").DataTable().rows().data();
          const brindesRegra = $("#tabelaBrindesPromocao").DataTable().rows().data();
          let itensUtilizamRegra = $("#tabelaItensUtilizamRegra").DataTable().rows().data();
          const indice = [];
          const recordCount = regra.length;
          for (let j = 0; j < recordCount; j++) {
            $("#tabelaItensUtilizamRegra").DataTable().clear();
            itensUtilizamRegra = [];

            const itensRegraAtual = itensRegra[0].filter(
              (itemRegra) => itemRegra.REGRA === regra[j].REGRA
            );

            const brindesRegraAtual = brindesRegra.filter(
              (brindeRegra) => brindeRegra.REGRA === regra[j].REGRA
            );

            const qtde = regra[j].VALOR;

            itensRegraAtual.forEach((itemRegra) => {
              const itemExists = itens.toArray().some(item =>
                item[31] === 0
              );

              if (!itemExists) {
                return;
              }

              for (let index = 0; index < qtde; index++) {
                itens.each((item, i) => {
                  if (item[0] == itemRegra.CODIGO && item[31] == 0 && !indice.includes(i)) {
                    indice.push(i);
                    $("#tabelaItensUtilizamRegra")
                      .DataTable()
                      .row.add([
                        itemRegra.CODIGO,
                        itemRegra.COR,
                        itemRegra.OPERACAO,
                        itemRegra.REGRA,
                        itemRegra.TAM,
                        itemRegra.TIPO,
                        itemRegra.VALOR,
                        item[2],
                        item[3],
                        i
                      ])
                      .draw(false);
                  }
                });
              }
            });

            async function callBackBrinde(j) {
              try {
                const tr = $('#tabelaSelecionar tr.selected')[0];
                const brinde = $('#tabelaSelecionar').DataTable().row($(tr)).data();
                const barra = brinde.BARRA;
                $('#txtCodigo').val(barra);
                await RotinaSaidaCodigo('P', '', 0, '', false, '', '', brinde.PRECO, regra[j].REGRA);

                if (j === 0) {
                  for (let I = 0; I < qtde; I++) {
                    const index = itensUtilizamRegraAux[0][9];
                    const data = $("#tabelaItens").DataTable().row(index).data();
                    data[31] = regra[j].REGRA;
                    data[32] = 'Item Utilizado para Brinde Ref. Regra: ' + regra[j].REGRA;
                    $("#tabelaItens").DataTable().row(index).data(data);
                    itensUtilizamRegraAux.splice(0, 1);
                  }
                }
              } catch (error) {
                console.log(error);
              }
            }

            itensUtilizamRegra = $("#tabelaItensUtilizamRegra").DataTable().rows().data().toArray();
            let itensUtilizamRegraAux = $("#tabelaItensUtilizamRegra").DataTable().rows().data().toArray();
            const iQtde = parseInt(itensUtilizamRegra.length / qtde);

            for (let index = 0; index < iQtde; index++) {
              for (let j = 0; j < brindesRegraAtual[0].VALOR; j++) {
                await msgAguardaSelecionar('Brinde', 'Brindes Promocionais', () => {
                  callBackBrinde(j)
                }, () => {}, brindesRegraAtual);
              }
            }

            await atualizaTotalVenda();
          }
        } catch (error) {
          console.log(error);
        } finally {
          $.LoadingOverlay('hide');
        }
      }


      async function regraPromocao() {
        if (parametrosVenda[29] != 2) return;

        const regra4 = g_regra.filter(item => item.MODELO === 4);
        const regra6 = g_regra.filter(item => item.MODELO === 6);
        await regraPromocaoModelo4(regra4);
        await regraPromocaoModelo6(regra6);
      }

      async function regraPromocaoModelo4(regra) {
        if (regra.length === 0) return;

        $.LoadingOverlay('show');
        try {
          $("#tabelaItensUtilizamRegra").DataTable().clear();
          const itens = $("#tabelaItens").DataTable().rows().data();
          const itensRegra = $("#tabelaItensRegraPromocao").DataTable().rows().data();
          let itensUtilizamRegra = $("#tabelaItensUtilizamRegra").DataTable().rows().data();
          const indice = [];
          const recordCount = regra.length;
          for (let j = 0; j < recordCount; j++) {
            let percDesconto = 0;
            let valorDesconto = 0;
            $("#tabelaItensUtilizamRegra").DataTable().clear();
            itensUtilizamRegra = [];

            let itensRegraAtual = itensRegra[0].filter(
              (itemRegra) => itemRegra.REGRA === regra[j].REGRA
            );

            itensRegraAtual.forEach((itemRegra) => {
              const itemExists = itens.toArray().some(item =>
                item[31] === 0
              );

              if (!itemExists) {
                return;
              }

              for (let index = 0; index < itemRegra.VALOR; index++) {
                itens.each((item, i) => {
                  if (item[0] === itemRegra.CODIGO && item[31] == 0 && !indice.includes(i)) {
                    indice.push(i);
                    $("#tabelaItensUtilizamRegra")
                      .DataTable()
                      .row.add([
                        itemRegra.CODIGO,
                        itemRegra.COR,
                        itemRegra.OPERACAO,
                        itemRegra.REGRA,
                        itemRegra.TAM,
                        itemRegra.TIPO,
                        itemRegra.VALOR,
                        item[2],
                        item[3],
                        i
                      ])
                      .draw(false);
                  }
                });
              }
            });

            const qtde = itensRegraAtual[0].VALOR;

            itensUtilizamRegra = $("#tabelaItensUtilizamRegra").DataTable().rows().data().toArray();
            let itensUtilizamRegraAux = $("#tabelaItensUtilizamRegra").DataTable().rows().data().toArray();

            while (itensUtilizamRegraAux.length >= qtde) {
              const indices = [];
              let I = 1;
              let menorPreco = 0;
              let index = -1;

              while (I <= qtde && itensUtilizamRegraAux.length > 0) {
                const item = itensUtilizamRegraAux[0];
                if (I <= qtde) {
                  if (I === 1) {
                    menorPreco = item[8];
                    index = item[9];
                  } else if (menorPreco > item[8]) {
                    menorPreco = item[8];
                    index = item[9];
                  }
                  indices.push(item[9])
                  itensUtilizamRegraAux.splice(0, 1);
                  I++;
                } else {
                  return;
                }
              };

              if (index != -1) {
                const data = $("#tabelaItens").DataTable().row(index).data();
                const dataRegra = itensUtilizamRegra.filter(item => item[9] == index);

                if (regra[j].TIPO == 'V') {
                  valorDesconto = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(regra[j].VALOR, quantidadeCasasDecimaisCampo)) : ArredondarValor(regra[j].VALOR, 2);
                  percDesconto = (regra[j].VALOR / dataRegra[0][8]) * 100;
                } else if (regra[j].TIPO == 'P') {
                  percDesconto = regra[j].VALOR;
                  valorDesconto = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda((dataRegra[0][8] * (percDesconto / 100)), quantidadeCasasDecimaisCampo)) : ArredondarValor(dataRegra[0][8] * (percDesconto / 100), 2);
                } else {
                  valorDesconto = dataRegra[0][8] - regra[j].VALOR;
                  percDesconto = (valorDesconto / dataRegra[0][8]) * 100;
                }

                // pega % desconto
                data[5] = ArredondarValor(percDesconto, 2);
                data[6] = valorDesconto * data[2];
                // ajusta o preco do item
                data[4] = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(data[3] - valorDesconto, quantidadeCasasDecimaisCampo)) :
                  ArredondarValor(data[3] - valorDesconto, 2);
                // ajusta valor total dos itens
                data[7] = ArredondarValor(data[4] * data[2], 2);
                data[20] = valorDesconto;
                data[21] = data[3];
                data[22] = percDesconto;
                data[31] = dataRegra[0][3];
                data[32] = 'Desconto Ref. Regra: ' + dataRegra[0][3];

                $("#tabelaItens").DataTable().row(index).data(data);

                indices.forEach(item => {
                  if (item != index) {
                    const data = $("#tabelaItens").DataTable().row(item).data();
                    data[31] = dataRegra[0][3];
                    $("#tabelaItens").DataTable().row(item).data(data);
                  }
                });
                percDesconto = 0;
              }
            }
            await atualizaTotalVenda();
          }
        } catch (error) {
          console.log(error);
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      $('#modalMaterial').on('shown.bs.modal', async function() {
        $('#txtMaterialCampoConsulta').focus();
      });


      $('#modalMaterial').on('show.bs.modal', function() {
        ativaBuscaFotosMat = true;
      });

      $('#modalMaterial').on('hide.bs.modal', function() {
        ativaBuscaFotosMat = false;
      });

      $('#txtMaterialCampoConsulta').on('blur', async function() {
        // se já tiver algum filtro da consulta anterior, mantem os filtros, pois cliente pode querer usar mesmo lote em quantidade diferente para separação
        if ($('.filtrosAdicionaisMaterial').filter((i, comp) => $($('.filtrosAdicionaisMaterial')[i]).val() != '').length > 0) {
          return;
        }

        if ((ultimoValorConsultado != $(this).val()) || (ultimoValorConsultado == '')) {
          await consultaItensMaterial();
        }
      });


      $('#txtMaterialCampoConsulta').on('keydown', async function(e) {
        if (e.currentTarget.value.length > 1) {
          setTimeout(function() {
            $('#txtMaterialCampoConsulta').trigger('blur');
            $('#txtMaterialCampoConsulta').focus();
          }, 500);
        }
      });


      function limpaPesquisaItensMaterial() {
        $("#tabelaMaterial").DataTable().draw(false);
        listaPesquisaItens = [];
      }

      $('#cbMaterialTodosDeposito').on('change', async function() {
        ultimoValorConsultado = '';
        $('#txtMaterialCampoConsulta').trigger('blur');
      });

      $('#cbMaterialContemEstoque').on('change', async function() {
        ultimoValorConsultado = '';
        $('#txtMaterialCampoConsulta').trigger('blur');
      });

      async function consultaItensMaterial() {
        const deposito = $('#modal-brinde').is(':visible') ? pegaChave('#txtDepositoBrinde') : pegaChave('#txtDeposito');
        const tabela = pegaChave('#txtTabela');
        const campoFiltro = $('#txtMaterialCampoConsulta').val();
        const somenteComEstoque = $('#cbMaterialContemEstoque').prop('checked');
        const todosDepositos = $('#cbMaterialTodosDeposito').prop('checked');

        try {
          try {
            const pesquisaPorDescricoes = campoFiltro.split('#').length > 1;

            const descricao = pesquisaPorDescricoes ? campoFiltro.split('#')[0] : '';
            const descCor = pesquisaPorDescricoes ? campoFiltro.split('#')[1] : '';
            const descDeposito = pesquisaPorDescricoes ? campoFiltro.split('#')[2] : '';

            const ajaxData = {
              EMPRESA: getCookie('empresa'),
              FILTRO: campoFiltro,
              TABELA: tabela,
              DEPOSITO: deposito,
              SOMENTE_COM_ESTOQUE: somenteComEstoque,
              TODOS_DEPOSITOS: todosDepositos,
              USUARIO: getCookie('cod_usuario'),
              DESCRICAO: descricao,
              DESC_COR: descCor,
              DESC_DEPOSITO: descDeposito
            };

            const colunasDataTable = [
              "CODIGO",
              "DESCRICAO",
              "FOTO",
              "COR",
              "DESC_COR",
              "PRECO",
              "QTDE_EST",
              "UNIDADE",
              "QUANTIDADE",
              "UNIDADE_AUX",
              "RENDIMENTO",
              "QUANTIDADE_AUX",
              "BARRA",
              "CODIGO2",
              "ID",
              "QUALIDADE",
              "LOTE",
              "DEPOSITO",
              "DESC_DEPOSITO",
              "DESCRICAO2",
              "REFERENCIA",
              "GRUPO",
              "SUB_GRUPO",
              "TAMANHO",
              "DESC_QUALIDADE",
              "LOTE_INTERNO",
              "DT_FAB",
              "TONALIDADE",
              "DESC_GRUPO",
              "LINHA",
              "DESC_LINHA"
            ];

            const dataSetCols = [];

            for (let i = 0; i < colunasDataTable.length; i++) {
              dataSetCols.push({
                'title': colunasDataTable[i],
                'data': i
              });
            }

            $('#tabelaMaterial').DataTable({
              scrollY: 'calc(100vh - 350px)', // Definindo a altura máxima da tabela com rolagem vertical
              scrollX: true, // Habilitando a rolagem horizontal
              scrollCollapse: true,
              fixedColumns: true,
              paging: true,
              responsive: true,
              fixedColumns: {
                leftColumns: 0 // Define zero colunas fixas à esquerda (desativa a fixação horizontal)
              },
              serverSide: true,
              processing: true,
              lengthChange: false,
              info: true,
              pageLength: 100,
              autoWidth: false,
              destroy: true,
              colReorder: true,
              ordering: false,
              order: false,
              filter: true,
              ajax: {
                url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/vendas/v1/pesquisamaterial`,
                type: "GET",
                headers: {
                  'Authorization': BASIC_AUTH
                },
                data: ajaxData,
              },
              columns: dataSetCols,
              columnDefs: [
                // {
                //   targets: [5, 10],
                //   visible: false,
                // },
                {
                  targets: [2],
                  render(data, type, row) {
                    const codigo = row[0];
                    if ((ativaBuscaFotosMat) && (colunasInvisiveis.vendaMaterial.indexOf('2') == -1)) {
                      setTimeout(() => {
                        buscaFotoProduto(codigo, 'M', imageCache);
                      }, 300);
                    }
                    const codigoCriptografado = criptografaCodigo(`img_prod_${codigo}_M`);
                    return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="30" width="30"/>`;
                  }
                },
                {
                  targets: [8],
                  render(data, type, row, meta) {
                    return '<div class="d-flex align-items-center justify-content-center">' +
                      `<input type="number" id="qtdeAdicionarMaterial${meta.row}` +
                      `" class="input-default focus text-right form-control validate inputMaterialQtdeAdicionar mr-2" style="height: 30px; width: 70px" value="0" data-row="${meta.row}"> ` +
                      `<i class="m-0 p-0 fas fa-check adicionaQtdePesquisaMaterial" id="adicionaQtdePesquisaMaterial${meta.row}" style="font-size: 18px"></i>` +
                      '</div>';
                  }
                },
                {
                  targets: [11],
                  render(data, type, row, meta) {
                    return '<div class="d-flex align-items-center justify-content-center">' +
                      `<input type="number" id="qtdeAuxAdicionarMaterial${meta.row}` +
                      `" class="input-default text-right focus form-control validate inputMaterialQtdeAuxAdicionar mr-2" style="width: 70px; height: 30px" value="0" data-row="${meta.row}"> ` +
                      '</div>';
                  }
                },
                {
                  "targets": [5, 6, 10],
                  "className": 'pr-4 text-right'
                }
              ],
            });

            $("#tabelaMaterial_wrapper > .row > .col-sm-12 > .dataTables_scroll > .dataTables_scrollHead > .dataTables_scrollHeadInner > table").removeClass("table-sm-sisp").addClass("table-sm");

            $('#tabelaMaterial_filter').addClass('d-none');
            if ($('.filtrosAdicionaisMaterial').length == 0) {
              $('#tabelaMaterial_wrapper .row:eq(1)').prepend(`
                <div class="col-12 d-flex">
                <input title="Código" placeholder="CODIGO" style="max-width: 6rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text";l data-index="0">
                <input title="Descrição" placeholder="DESCRICAO" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="1">
                <input title="Cor" placeholder="COR" style="max-width: 6rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="3">
                <input title="Desc. Cor" placeholder="DESC_COR" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="4">
                <input title="Desc. Depósito" placeholder="DESC. DEPOSITO" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="18">
                <input title="Desc. Qualidade" placeholder="DESC. QUALIDADE" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="24">
                <input title="Tonalidade" placeholder="TONALIDADE" style="max-width: 8rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="27">
                <input title="Código 2" placeholder="CÓDIGO 2" style="max-width: 8rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="11">
                <input title="Desc. Grupo" placeholder="DESC. GRUPO" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="28">
                <input title="Desc. Linha" placeholder="DESC. LINHA" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="30">
                <input title="Lote" placeholder="LOTE" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="16">
                <input title="Lote Interno" placeholder="LOTE INTERNO" style="max-width: 14rem" class="form-control form-control-sm filtrosAdicionaisMaterial" type="text" data-index="25">
                <button id="configurarFiltrosAdicionaisMaterial" title="Configurar Filtros" class="btn btn-primary btn-sm ml-2"><i class="fas fa-cog"></i></button>
                <button id="limparFiltrosAdicionaisMaterial" title="Limpar Filtros" class="btn btn-danger btn-sm ml-2"><i class="fas fa-trash"></i></button>
                </div>`);
            }

            const filtrosInvisiveis = JSON.parse(localStorage.getItem('filtrosAdicionaisInvisiveis')) ?? [];
            for (let i = 0; i < filtrosInvisiveis.length; i++) {
              $(`.filtrosAdicionaisMaterial[data-index="${filtrosInvisiveis[i]}"]`).addClass('d-none');
            }

            $('#configurarFiltrosAdicionaisMaterial').off();
            $('#configurarFiltrosAdicionaisMaterial').on('click', function() {
              // esvaziar html para garantir
              $('#conteudoFiltrosAdicionaisInvisiveis').html('');
              const listaFiltrosAdicionais = $('.filtrosAdicionaisMaterial').toArray().map(filtro => {
                return {
                  title: $(filtro).attr('title'),
                  placeholder: $(filtro).attr('placeholder'),
                  index: $(filtro).attr('data-index')
                }
              });

              const invisiveis = JSON.parse(localStorage.getItem('filtrosAdicionaisInvisiveis')) ?? [];

              listaFiltrosAdicionais.forEach(filtro => {
                $('#conteudoFiltrosAdicionaisInvisiveis').append(`
                <label htmlFor="txtConfigFiltroAdicional${filtro.placeholder}" class="col-3 labelColunasInvisiveis icheck-primary" title='Filtro ${filtro.title}'>
                  <input type="checkbox" value=${filtro.index} name="txt${filtro.placeholder}" id="txtConfigFiltroAdicional${filtro.placeholder}" />
                  <label for="txtConfigFiltroAdicional${filtro.placeholder}">${filtro.title}</label>
                </label>
              `);

                if (invisiveis.length > 0) {
                  if (invisiveis.filter((invisivel) => invisivel == filtro.index)[0] == filtro.index) {
                    $(`.labelColunasInvisiveis input[value="${filtro.index}"]`).attr('checked', true);
                  }
                }

              });

              $('#btnConfirmarFiltrosAdicionaisInvisiveis').off();
              $('#btnConfirmarFiltrosAdicionaisInvisiveis').on('click', function() {
                const idsInvisiveis = $('.labelColunasInvisiveis input:checked').toArray().map(filtroSel => $(filtroSel).val());
                localStorage.setItem('filtrosAdicionaisInvisiveis', JSON.stringify(idsInvisiveis));
                $('#modalFiltrosAdicionaisInvisiveis').modal('hide');
                $('#txtMaterialCampoConsulta').trigger('blur');
              });

              // abrir modal vazio
              $('#modalFiltrosAdicionaisInvisiveis').modal('show');
              // inserir listagem de possíveis filtros
              // verificar se já tem gravado no localstorage pra ver se deve trazer checado ou não
              // ao confirmar deve gravar no localstorage
              // na rotina acima, deve percorrer no localstorage se tiver invisivel la e adicionar d-none ao input...
            });

            $('#limparFiltrosAdicionaisMaterial').off();
            $('#limparFiltrosAdicionaisMaterial').on('click', function() {
              $('.filtrosAdicionaisMaterial').val('');
              $('#txtMaterialCampoConsulta').trigger('blur');
            });

            $('#tabelaMaterial_wrapper input.filtrosAdicionaisMaterial').off('keyup');
            $('#tabelaMaterial_wrapper input.filtrosAdicionaisMaterial').on('keyup', function() {
              $('#tabelaMaterial').DataTable()
                .column($(this).data('index'))
                .search(this.value.toUpperCase())
                .draw();
            });

            ultimoValorConsultado = campoFiltro;

            $('select[name="tabelaMaterial_length"]').parent().addClass('d-none');
            $('select[name="tabelaMaterial_length"]').addClass('d-none');

            $("#buttonColVis").on("click", async function() {
              $.LoadingOverlay("show");
              $('#txtEstoquePrecoControle').val(0)
              $("#modal-ColunasVisiveis").modal("show");
              $.LoadingOverlay("hide");
            });

            const colunasInvisiveis = JSON.parse(
              localStorage.getItem("colunasInvisiveisRelatorios")
            );

            $("#tabelaMaterial")
              .DataTable()
              .columns()
              // eslint-disable-next-line array-callback-return
              .every(function() {
                const colAtual = String(this.dataSrc());
                if (colunasInvisiveis.vendaMaterial.indexOf(colAtual) != -1) {
                  this.visible(false);
                }
              });

            eventoKeydownHeadFiltersTabelaMaterial();
            eventoKeydownFilterTabelaMaterial();
          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados dos materiais.');
          }
        } finally {
          //
        }
      }
      $("#btnConfirmarColunas").off();
      $("#btnConfirmarColunas").on("click", async function() {
        try {
          $.LoadingOverlay("show");

          const novasColunas = retornaNovasColunasInvisiveis();
          if ($('#modalProduto').hasClass('show')) {
            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({
                ...colunas,
                vendaProduto: novasColunas
              })
            );

            $("#tabelaProdutoMaterial").DataTable().columns().visible(true);

            $("#tabelaProdutoMaterial")
              .DataTable()
              .columns()
              // eslint-disable-next-line array-callback-return
              .every(function() {
                const colAtual = String(this.dataSrc());
                if (novasColunas.indexOf(colAtual) != -1) {
                  this.visible(false);
                }
              });
          } else if ($('#txtEstoquePrecoControle').val() == 1) {
            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({
                ...colunas,
                estoquePreco: novasColunas
              })
            );

            $("#tabelaEstoquePreco").DataTable().columns().visible(true);

            $("#tabelaEstoquePreco")
              .DataTable()
              .columns()
              // eslint-disable-next-line array-callback-return
              .every(function() {
                const colAtual = String(this.dataSrc());
                if (novasColunas.indexOf(colAtual) != -1) {
                  this.visible(false);
                }
              });
          } else {
            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({
                ...colunas,
                vendaMaterial: novasColunas
              })
            );

            $("#tabelaMaterial").DataTable().columns().visible(true);

            $("#tabelaMaterial")
              .DataTable()
              .columns()
              // eslint-disable-next-line array-callback-return
              .every(function() {
                const colAtual = String(this.dataSrc());
                if (novasColunas.indexOf(colAtual) != -1) {
                  this.visible(false);
                }
              });
          }

        } finally {
          $.LoadingOverlay("hide");
          $("#modal-ColunasVisiveis").modal("hide");
        }
      });

      $("#modal-ColunasVisiveis").on("show.bs.modal", function() {
        const cols = [];

        let colunasInvisiveis = JSON.parse(
          localStorage.getItem("colunasInvisiveisRelatorios")
        );

        if ($('#modalProduto').hasClass('show')) {
          $("#tabelaProdutoMaterial")
            .DataTable()
            .columns()
            // eslint-disable-next-line array-callback-return
            .every(function() {
              cols.push({
                title: $(this.header()).text(),
                data: this.dataSrc(),
              });
            });
          adicionaColunas(cols, colunasInvisiveis.vendaProduto ?? [], ['CODIGO', 'DESCRICAO', 'COR', 'DESC_COR', 'TAM', 'QTDE_EST', 'QUANTIDADE']);
        } else if ($('#txtEstoquePrecoControle').val() == 1) {
          $("#tabelaEstoquePreco")
            .DataTable()
            .columns()
            // eslint-disable-next-line array-callback-return
            .every(function() {
              cols.push({
                title: $(this.header()).text(),
                data: this.dataSrc(),
              });
            });
          adicionaColunas(cols, colunasInvisiveis.estoquePreco ?? []);
        } else {
          $("#tabelaMaterial")
            .DataTable()
            .columns()
            // eslint-disable-next-line array-callback-return
            .every(function() {
              cols.push({
                title: $(this.header()).text(),
                data: this.dataSrc(),
              });
            });
          adicionaColunas(cols, colunasInvisiveis.vendaMaterial ?? [], ['QTDE_EST', 'QUANTIDADE']);
        }
      });

      $("#tabelaMaterial").on("click", ".inputMaterialQtdeAdicionar", function() {
        let that = $(this);
        setTimeout(function() {
          that.select();
        }, 1);
      });

      $("#tabelaMaterial").on("keydown", ".inputMaterialQtdeAdicionar", function(e) {
        const index = +($(this).attr('data-row')) + 1;
        if ((e.key == 'Tab') || (e.key == 'Enter')) {
          $($('.inputMaterialQtdeAdicionar')[index]).focus().click();
        }
      });

      $("#tabelaMaterial").on("click", ".adicionaQtdePesquisaMaterial", async function() {
        const qtdeEstoque = formataNumerico($("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][6]);
        const item = $("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
        if (qtdeEstoque > 0) {
          $(this).siblings(".inputMaterialQtdeAdicionar").val(qtdeEstoque);
          adicionaListaPesquisaItensMaterial(item, qtdeEstoque);
          $($(this).closest("tr")).addClass("selected");
        }
      });

      $('#tabelaMaterial tbody').on('click', 'tr', function(e) {
        const {
          target
        } = e;
        const indexRow = $(this)[0].sectionRowIndex;
        if ($(target).is(".adicionaQtdePesquisaMaterial") || $(target).is(".inputMaterialQtdeAdicionar") || $(target).is(".inputMaterialQtdeAuxAdicionar")) {
          return;
        }
        if (indexRow) {
          $(`#qtdeAdicionarMaterial${indexRow}`).focus();
          $(`#qtdeAdicionarMaterial${indexRow}`).select();
        }
      });

      // duplo click faz escolher o registro e fechar a pesquisa
      $('#tabelaMaterial tbody').on('dblclick', 'tr', function(e) {
        const {
          target
        } = e;
        const indexRow = $(this)[0].sectionRowIndex;
        if ($(target).is(".adicionaQtdePesquisaMaterial") || $(target).is(".inputMaterialQtdeAdicionar")) {
          return;
        }
        // event.preventDefault();
        const item = $("#tabelaMaterial").DataTable().rows($(this)).data().toArray()[0];
        const qtdeEstoque = formataNumerico(item[6]);
        if ($(`#qtdeAdicionarMaterial${indexRow}`).val() === '') {
          $(`#qtdeAdicionarMaterial${indexRow}`).val(qtdeEstoque);
        }
        document.firstElementChild.style.zoom = "reset";
        $("#tabelaMaterial").DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        $("#btn_confirmar_material").click();
      });


      $("#tabelaMaterial").on('draw.dt', function() {
        const registros = $("#tabelaMaterial").DataTable().data().toArray();

        listaPesquisaItens.forEach(item => {
          registros.forEach((registro, i) => {
            if (registro[0] == item.codigo &&
              registro[3] == item.cor &&
              registro[11] == item.qualidade &&
              registro[13] == item.deposito &&
              registro[12] == item.lote &&
              registro[10] == item.id_estoque) {
              $(`#qtdeAdicionarMaterial${i}`).val(item.qtde);
              $($("#tabelaMaterial tbody tr")[i]).addClass("selected");
            }
          });
        });

      });


      async function VerificaSeDepositoBloqueiaLoteFracionado(deposito) {
        try {
          if (deposito == '') {
            return false;
          }

          const pesquisa = {
            tabela: "DEPOSITO",
            camposSelect: ["LOTE_FRACIONADO"],
            where: [`CODIGO = '${deposito}'`]
          }
          const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          return json && json[0] && json[0].LOTE_FRACIONADO == 'S';
        } catch (e) {
          console.error(e);
          return false;
        }
      }

      $("#tabelaMaterial").on("blur", ".inputMaterialQtdeAdicionar", async function() {
        const paramEstoque = parametrosVenda[4];
        const item = $("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
        const qtdeAtual = formataNumerico($(this).val());
        const qtdeEstoque = formataNumerico($("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][6]);
        const bTipoVendaMovimentaEstoque = $("#vendaMovimentaEstoque").prop("checked");
        const bloqueiaVendaLoteFracionado = await VerificaSeDepositoBloqueiaLoteFracionado(item[17]);
        if ((qtdeAtual > 0) && (qtdeAtual < qtdeEstoque) && (bloqueiaVendaLoteFracionado)) {
          msgAlerta(`Depósito ${item[17]} não permite lote fracionado, verifique.`);
          $(this).val(0);
          return;
        }
        if (qtdeAtual > 0) {
          if (!bTipoVendaMovimentaEstoque || paramEstoque != "0" || qtdeAtual <= qtdeEstoque) {
            adicionaListaPesquisaItensMaterial(item, qtdeAtual);
            $($(this).closest("tr")).addClass("selected");
            if (bTipoVendaMovimentaEstoque && paramEstoque == "1" && qtdeAtual > qtdeEstoque) {
              msgAlerta("Quantidade maior que a disponível no estoque.");
            }
          } else {
            $(this).val(0);
            $($(this).closest("tr").removeClass("selected"));
            msgAlerta("Não é possível selecionar uma quantidade superior à disponível no estoque.");
          }
        } else {
          $(this).val(0);
          $($(this).closest("tr").removeClass("selected"));
        }
      });



      $("#tabelaMaterial").on("blur", ".inputMaterialQtdeAuxAdicionar", function() {
        const paramEstoque = parametrosVenda[4];
        const qtdeAtual = formataNumerico($(this).val());
        const qtdeEstoque = formataNumerico($("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][6]);
        const rendimento = formataNumerico($("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][10]);
        const item = $("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
        const bTipoVendaMovimentaEstoque = $("#vendaMovimentaEstoque").prop("checked");

        const qtdeNova = qtdeAtual * rendimento
        if (qtdeNova > 0) {
          if (!bTipoVendaMovimentaEstoque || paramEstoque != "0" || qtdeNova <= qtdeEstoque) {
            adicionaListaPesquisaItensMaterial(item, qtdeNova);
            if (bTipoVendaMovimentaEstoque && paramEstoque == "1" && qtdeNova > qtdeEstoque) {
              msgAlerta('Quantidade maior que a disponível no estoque.')
            }
            $(`#qtdeAdicionarMaterial${$(this)[0].dataset.row}`).val(qtdeNova)
            $($(this).closest("tr")).addClass("selected");
            $(this).val(0)
          } else {
            $(`#qtdeAdicionarMaterial${$(this)[0].dataset.row}`).val(0)
            $(this).val(0)
            $($(this).closest("tr").removeClass("selected"));
            msgAlerta("Não é possível selecionar uma quantidade superior à disponível no estoque.");
          }
        } else {
          $(this).val(0);
          $($(this).closest("tr").removeClass("selected"));
        }
      });

      // $("#tabelaMaterial").on("focus", ".inputMaterialQtdeAdicionar", function () {
      //   $(this).val(0);
      // });

      function adicionaListaPesquisaItensMaterial(item, qtde) {

        const itemAtual = {
          codigo: item[0],
          cor: item[3],
          qualidade: item[15],
          lote: item[16],
          deposito: item[17],
          id_estoque: item[14],
          qtde,
          preco: item[5],
          descricao: item[1]
        };

        const indexItem = listaPesquisaItens.findIndex(itemLista => itemAtual.codigo == itemLista.codigo &&
          itemAtual.cor == itemLista.cor &&
          itemAtual.qualidade == itemLista.qualidade &&
          itemAtual.lote == itemLista.lote &&
          itemAtual.deposito == itemLista.deposito &&
          itemAtual.id_estoque == itemLista.id_estoque
        );
        if (indexItem > -1 && qtde == 0) {
          listaPesquisaItens.splice(indexItem, 1);
        } else if (indexItem > -1) {
          listaPesquisaItens[indexItem].qtde = qtde;
        } else if (indexItem == -1 && qtde > 0) {
          listaPesquisaItens.push(itemAtual);
        }
      }

      // botão selecionar
      $("#btn_confirmar_material").click(async function() {
        try {
          if ($('#modal-brinde').is(':visible')) {
            await confirmaBrinde(true);
            return;
          }

          $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');

          async function buscaQualidade(codigo) {
            try {
              const json = await retornaJsonPesquisaPadrao(`{"tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO = '${codigo}'"] }`);
              if (json.length > 0) {
                return json;
              } else {
                throw new Error(`Não foi possível buscar as informações da qualidade ${codigo}. Verifique se existe uma qualidade com este código cadastrada no sistema.`)
              }
            } catch (error) {
              console.error(error);
              msgAlerta(error.message);
            }
          }

          if (listaPesquisaItens.length > 0) {
            listaPesquisaItens.sort(function(a, b) {
              if (a.preco == "" && b.preco != "") {
                return 1;
              }
              if (a.preco != "" && b.preco == "") {
                return -1;
              }
              return 0;

            });

            for (let i = 0; i < listaPesquisaItens.length; i++) {
              const qualidade = await buscaQualidade(listaPesquisaItens[i].qualidade);
              insereValor("#txtQualidade", qualidade[0].CODIGO, qualidade[0].DESCRICAO);
              $('#txtQuantid').val(listaPesquisaItens[i].qtde);
              $('#txtIdItem').val(listaPesquisaItens[i].id_estoque);
              $('#txtDepositoItem').val(listaPesquisaItens[i].deposito);
              $("#txtCodigo").attr("informacoesItem", `${listaPesquisaItens[i].codigo} - ${listaPesquisaItens[i].descricao}`);
              $("#txtCodigo").attr("quantidadeItem", listaPesquisaItens[i].qtde);
              // $("#txtCodigo").trigger('blur');
              await RotinaSaidaCodigo('M', '', '', '', true, listaPesquisaItens[i].codigo, listaPesquisaItens[i].cor);
            }
          } else {
            const data = $('#tabelaMaterial').dataTable().api().row('.selected').data();
            if (data == undefined) {
              throw msgAlerta("Nenhum item selecionado.");
            }
            const qualidade = await buscaQualidade(data[15]);
            insereValor('#txtQualidade', qualidade[0].CODIGO, qualidade[0].DESCRICAO);
            $("#txtCodigo").attr("informacoesItem", `${data[0]} - ${data[1]}`);
            if ((data[16] != '') && (data[16] != '000000')) {
              $('#txtIdItem').val(data[14]);
              $('#txtDepositoItem').val(data[17]);
              await RotinaSaidaCodigo('M', '', '', '', true);
            } else if (data[10] != '') {
              $('#txtIdItem').val(data[14]);
              $('#txtCodigo').val(data[16]);
              $('#txtDepositoItem').val(data[17]);
              await RotinaSaidaCodigo('M', '', '', '', true);
            } else {
              $('#txtIdItem').val('');
              $('#txtDepositoItem').val('');
              msgAlerta("O item selecionado não contém Barra, Lote e ID.");
            }
          }
          limpaPesquisaItensMaterial();
          $("#txtCodigo").attr("quantidadeItem", 0);
        } catch (error) {
          console.log(error);
        } finally {
          $("#modalMaterial").modal("hide");
        }
      });

      $('#btnSolicitacaoEstoque').on('click', function() {
        if (idIntervalSolicitacaoEstoque != -1) {
          clearInterval(idIntervalSolicitacaoEstoque);
        }
        parent.abrirEmNovaAbaIFrame('Demanda E-commerce', '<?php echo BASE_URI; ?>/demanda_ecommerce');
      });


      // fonte que estava separado no arquivo venda_material.js


      async function saidaCampoPercentualDesconto() {

        if (parseFloat($("#txtPercDescontoMoeda").val()) == 0) {
          $("#txtValorDescontoMoeda").val('0');
          $('#txtValorLiquidoMoeda').val(parseFloat($('#txtValorParcela').val()));
          $('#txtValorAcrescMoeda').prop('disabled', false);
          $('#txtPercAcrescMoeda').prop('disabled', false);
          return;
        }
        $('#txtValorDescontoMoeda').val('');
        $('#txtValorDescontoMoeda').off('change');
        const bDescontaFrete = ((bNaoConsiderarFreteDesconto) && ((parseFloat($("#txtPercDescontoMoeda").val()) > 0) || (parseFloat($("#txtValorDescontoMoeda").val()) > 0)));
        const valFrete = isNaN(parseFloat($('#txtFrete').val())) ? 0 : parseFloat($('#txtFrete').val());
        const valorParcela = bDescontaFrete ? (parseFloat($("#txtValorParcela").val()) - valFrete) : $("#txtValorParcela").val();
        const validaDesc = await CalculaDescontoMoeda('txtPercDescontoMoeda', valorParcela, $("#txtPercDescontoMoeda").val(), $("#txtValorDescontoMoeda").val(), $("#txtValorParcela").val(), 1, false);
        if (validaDesc == false) {
          return;
        }
        // await verificaDescontoTotalNaVenda(); // removido para validar apenas no botão adicionar
      }

      async function saidaCampoValorDesconto() {

        if (parametroValorIPIVenda && $("#txtsaldo_a_pagar").prop("bExisteValorIPI")) {
          rotinaRemoveValorIPI();
        }

        if (parseFloat($("#txtValorDescontoMoeda").val()) == 0) {
          $("#txtPercDescontoMoeda").val('0');
          $('#txtValorLiquidoMoeda').val(parseFloat($('#txtValorParcela').val()));
          $('#txtValorAcrescMoeda').prop('disabled', false);
          $('#txtPercAcrescMoeda').prop('disabled', false);
        } else {
          const bDescontaFrete = ((bNaoConsiderarFreteDesconto) && ((parseFloat($("#txtPercDescontoMoeda").val()) > 0) || (parseFloat($("#txtValorDescontoMoeda").val()) > 0)));
          const valFrete = isNaN(parseFloat($('#txtFrete').val())) ? 0 : parseFloat($('#txtFrete').val());
          const valorParcela = bDescontaFrete ? (parseFloat($("#txtValorParcela").val()) - valFrete) : $("#txtValorParcela").val();
          const validaDesc = await CalculaDescontoMoeda('txtValorDescontoMoeda', valorParcela, $("#txtPercDescontoMoeda").val(), $("#txtValorDescontoMoeda").val(), $("#txtValorParcela").val(), 1, false);
          if (validaDesc == false) {
            return;
          }
          // await verificaDescontoTotalNaVenda(); // removido para validar apenas no botão adicionar
        }

        if (parametroValorIPIVenda && $("#txtsaldo_a_pagar").prop("bExisteValorIPI")) {
          await rotinaAplicaValorIPI(true);
        }

        if (parametroValorRetIva) {
          await rotinaAplicaValorRetencaoIva();
        }

      }

        /*************************************************
         * ROTINA SAÍDA CÓDIGO — REFACTORED
         * Mantém a lógica original, com melhor organização.
       **************************************************/

        /* ===========================
        * Utilitários de leitura/DOM
        =========================== */

      function getCodigo()         { return $('#txtCodigo').val().trim(); }
      function setCodigo(v = '')   { $('#txtCodigo').val(v); }
      function getIdItem()         { return $('#txtIdItem').val().trim(); }
      function setIdItem(v = '')   { $('#txtIdItem').val(v); }
      function getCodigoEPC()      { return $('#txtCodigoEPC').val().trim(); }
      function setCodigoEPC(v='')  { $('#txtCodigoEPC').val(v); }
      function getQuantidadeRaw()  { return $('#txtQuantid').val(); }
      function setQuantidade(v=1)  { $('#txtQuantid').val(v); }
      function getDepositoTela()   { return $('#txtDepositoItem').val(); }
      function setDepositoTela(v)  { $('#txtDepositoItem').val(v); }
      function getDepositoVenda()  { return pegaChave('#txtDeposito'); }
      function getTabela()         { return pegaChave('#txtTabela'); }
      function vendaEmAlteracao()  { return ((numero_venda != 'create') && (numero_venda != 'create#')); }
      function usaBarraLog()       { return parametrosVenda[46] != '0'; }
      function usaITAG()           { return (parametrosVenda[60] == 1 || parametrosVenda[60] == 2); }
      function agrupaItens()       { return sDepositoEcommerce != '' ? false : parametrosVenda[61] != 0; }
      function bloqueiaExcluirItem() { return infoTipoVenda[0].EXCLUSAO_ITEM === 2 && vendaEmAlteracao(); }
      function pedeSenhaExclusao() { return infoTipoVenda[0].EXCLUSAO_ITEM === 1 && vendaEmAlteracao(); }
      function paramEstoqueModo()  { return parametrosVenda[4]; } // '0', '1' ou '2'
      function limiteItensVenda()  { return parametrosVenda[106] ?? 0; }
      function usaPrecoCorTam()  { return parametrosVenda[5] == 1; }
      const tipos = await BuscaTiposVenda($('#txtTipoVenda').val());
      infoTipoVenda = tipos;
      const vendaConsig = infoTipoVenda.filter((tipo) => tipo.ID == $('#txtTipoVenda').val())[0].CONSIGNADO == 'S'
      const tipoMovimentaEstoque = infoTipoVenda.filter((tipo) => tipo.ID == $('#txtTipoVenda').val())[0].ESTOQUE == 'S'
      let naoPermiteConsig = []

      /* ===========================
        Validações e parsing
        =========================== */
      function validaCamposIniciais() {
        const codigo = getCodigo();
        const idItem = getIdItem();

        if ((codigo === "" || codigo === "-") && idItem === "") return false;
        if (codigo.endsWith('*')) return false;
        if (codigo.length > 50) {
          msgAlerta('Código de barras não pode ter mais de 50 digitos, verifique.');
          SomAlerta('<?php echo BASE_URI; ?>', true);
          return false;
        }
        return true;
      }

      function aplicaDepositoEcommerceSeNecessário() {
        const bDepositoEcommerce = isChecked('#cbDepositoEcommerce') && ($('#modalProduto').is(':visible') || bDblclickModalProduto);
        if (bDepositoEcommerce) {
          setDepositoTela(sDepositoEcommerce.substring(1, sDepositoEcommerce.indexOf("]")));
        }
        return bDepositoEcommerce;
      }

      function detectaEstornoOuExclusao() {
        let bEstorno = false;

        // código começando com "-" indica estorno
        if (getCodigo().startsWith("-")) {
          if (bloqueiaExcluirItem()) {
            msgAlerta('Não é possível excluir o item para o tipo de venda: ' + infoTipoVenda[0].DESCRICAO);
            SomAlerta('<?php echo BASE_URI; ?>', true);
            return { cancelado: true, bEstorno: false };
          }
          setCodigo(getCodigo().substring(1));
          bEstorno = true;
        }

        // botão de menos ativo
        if ($('#btnMenosOuMais>i.fa-minus').length > 0) {
          if (bloqueiaExcluirItem()) {
            msgAlerta('Não é possível excluir o item para o tipo de venda: ' + infoTipoVenda[0].DESCRICAO);
            SomAlerta('<?php echo BASE_URI; ?>', true);
            return { cancelado: true, bEstorno: false };
          }
          bEstorno = true;
        }

        return { cancelado: false, bEstorno };
      }

      function extraiQuantidadeDoCodigoSeVierNoFormatoMultiplicador() {
        // formato: "3*123456"
        const codigo = getCodigo();
        if (codigo.indexOf("*") > 0) {
          const qtd = codigo.substring(0, codigo.indexOf("*"));
          const barra = codigo.substring(codigo.indexOf("*") + 1);
          setQuantidade(qtd);
          setCodigo(barra);
        }
      }

      function resolveDepositoParaSaida() {
        return getDepositoTela() !== '' ? getDepositoTela() : getDepositoVenda();
      }

      async function resolveQuantidadeDigitada() {
        let vQtde;
        const attrQtde = $("#txtCodigo").attr("quantidadeItem") ?? "0";
        if (formataNumerico(attrQtde) == 0) {
          vQtde = formataNumerico(getQuantidadeRaw());
        } else {
          vQtde = formataNumerico(attrQtde);
        }
        if (isNaN(vQtde)) vQtde = 1;
        if (vQtde < 0) {
          msgErro('Quantidade deve ser maior que zero');
          SomAlerta('<?php echo BASE_URI; ?>', true);
          return { ok: false, vQtde: 1 };
        }
        if (retornaQtdeCasasDecimais(vQtde) > 3) {
          msgErro('Quantidade de casas decimais ultrapassada, máximo 3. (Ex: 12,125)');
          SomAlerta('<?php echo BASE_URI; ?>', true);
          return { ok: false, vQtde: 1 };
        }
        return { ok: true, vQtde };
      }

      function checaLimiteMaximoDeItens(bEstorno) {
        const limite = limiteItensVenda();
        if (!bEstorno && limite > 0) {
          const total = $('#tabelaItens').DataTable().data().toArray().length;
          if (total === limite) {
            msgAlerta(`Venda atingiu o limite máximo de itens permitidos (${limite}), conforme configurado para a Empresa.`);
            return false;
          }
        }
        return true;
      }

      /* ===========================
        Funções auxiliares de negócio
        =========================== */

      async function validaConsignadoSeNecessário(jsonStr) {
        if (vendaConsig) {
          if (jsonStr.PERMITE_CONSIG == 'N') {
            naoPermiteConsig.push(jsonStr);
            return false
          }
        }
        return true
      }

      async function retornaPrecoCadastrado(jsonStr) {
        if (!jsonStr.PRECO > 0) {
          return false
        } 
        return true
      }

      function coletaInfoAgrupamentoEIndex(jsonStr, qualidade) {
        const sCodigoValidacao = jsonStr.TIPO != 'M'
          ? `${jsonStr.CODIGO} - ${jsonStr.COR} - ${jsonStr.TAM} - ${qualidade}`
          : `${jsonStr.CODIGO} - ${jsonStr.COR} - ${jsonStr.TAM} - ${qualidade} - ${jsonStr.LOTE}`;

        let indexItem = $('#tabelaItens').DataTable().column(16).data().indexOf(sCodigoValidacao);
        let vQtdeGrid = 0

        const iguais = $('#tabelaItens').DataTable().data().toArray().filter(item => {
          return (item[19] != 'M')
            ? (item[0] == jsonStr.CODIGO && item[10] == jsonStr.COR && item[11] == jsonStr.TAM)
            : (item[0] == jsonStr.CODIGO && item[10] == jsonStr.COR && item[11] == jsonStr.TAM && item[18] == jsonStr.LOTE);
        });

        iguais.forEach(item => { vQtdeGrid += item[2]; });

        return { sCodigoValidacao, indexItem, vQtdeGrid };
      }

      async function barraLogControleEntradaSaida(sCodigo, bEstorno, ehBarraLog) {
        if (!usaBarraLog()) return { ok: true, vQtdeForcada: null };
        if (!bEstorno) {
          if (listaBarrasBipadas.find(barra => barra === sCodigo)) {
            return { ok: false, vQtdeForcada: null }; // já bipada → não prossegue
          } else {
            listaBarrasBipadas.push(sCodigo);
            if (listaBarrasRemovidasTemp.includes(sCodigo)) {
              listaBarrasRemovidasTemp = listaBarrasRemovidasTemp.filter(it => it != sCodigo);
              listaBarrasRemovidas = listaBarrasRemovidas.filter(it => it != sCodigo);
            }
          }
        }
        
        return { ok: true, vQtdeForcada: null };
      }

      async function checaProdutoAtivo(jsonStr) {
        const ativo = await produtoAtivo(jsonStr[0].CODIGO, jsonStr[0].TIPO);
        if (!ativo) {
          await aguardaMsgAlerta('Item não esta ativo. Impossivel continuar', () => {});
          SomAlerta('<?php echo BASE_URI; ?>', true);
          return false;
        }
        return true;
      }

      async function checaEstoqueENotificaSeNecessario(jsonStr, vQtde, vQtdeGrid, bEstorno) {
        if (!tipoMovimentaEstoque) return true;

        const vEstoque = Number(jsonStr.ESTOQUE.toString());
        const param = paramEstoqueModo();

        if (((vEstoque < (vQtde + vQtdeGrid)) || (vEstoque <= 0)) && (!bEstorno)) {
          switch (param) {
            case '0':
              return false;
            case '1':
              {
                return false;
              }
            case '2':
              // permite sem mensagem
              return true;
          }
        }
        return true;
      }

      /* ===========================
        Inclusão de item
        =========================== */

      function preencheCamposItemUI(jsonStr, vQtde, sPreco, sPrecoOrig, sPrecoOrigOld) {
        const sProduto = `[${jsonStr.CODIGO}] - ${jsonStr.DESCRICAO}`;
        const sCor     = `[${jsonStr.COR}] - ${jsonStr.DESC_COR}`;
        const sTam     = `[${jsonStr.TAM}] - ${jsonStr.TAM}`;

        $('#txtProduto').val(sProduto);
        $('#txtCor').val(sCor);
        $('#txtTamanho').val(sTam);
        $('#txtPreco').val(sPreco);
        setQuantidade(vQtde);
      }

      async function calculaPrecos(vBrinde, precoBase) {
        // respeita quantidadeCasasDecimaisCampo, mantido como no código original
        const ajusta = (v) => (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(v, quantidadeCasasDecimaisCampo)) : TruncaDecimaisNova(2, v);

        if (vBrinde != 0) {
          const vb = ajusta(vBrinde);
          return { sPreco: vb, sPrecoOrig: vb, sPrecoOrigOld: vb };
        }
        const p = ajusta(precoBase);
        return { sPreco: p, sPrecoOrig: p, sPrecoOrigOld: p };
      }

      function montaDescricaoAgrupamento(jsonStr, qualidade) {
        return (jsonStr.TIPO != 'M')
          ? `${jsonStr.CODIGO} - ${jsonStr.COR} - ${jsonStr.TAM} - ${qualidade}`
          : `${jsonStr.CODIGO} - ${jsonStr.COR} - ${jsonStr.TAM} - ${qualidade} - ${jsonStr.LOTE}`;
      }

      function calculaTotaisItem(sPreco, vQtde, utilizaImpressoraFiscal) {
        const soma = +(sPreco * vQtde).toFixed(4);
        const maisDe2Dec = String(soma).includes('.') && (String(soma).split('.')[1].length > 2);
        const total = utilizaImpressoraFiscal && maisDe2Dec ? mantemDuasCasasDecimais(soma, 3) : TruncaDecimaisNova(2, parseFloat(soma));
        return { soma, total, maisDe2Dec };
      }

      async function aplicaDescontoAutoSeHouver(descricaoItem) {
        if (bAplicaDescMaxTabPrecoVenda || bAplicaDescMaxTabPrecoVendaNotAlterar) {
          const descMaxTabPreco = await retornaDescMaxTabPreco($('#txtCodigo').attr('codigo') ?? '', getTabela());
          if (descMaxTabPreco > 0) {
            const idx = $("#tabelaItens").DataTable().data().toArray().findIndex(r => r[1] == descricaoItem);
            const row = $("#tabelaItens tbody tr")[idx];
            await criaTelaDesconto(row, false);
            $("#txtPercDesconto").val(descMaxTabPreco.toLocaleString("pt-BR", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
            $("#txtPercDesconto").trigger("blur");
            await eventoClickPesquisaDescontoConfirmar(row);
            return;
          }
        }
        if (g_DescCliente > 0) {
          const idx = $("#tabelaItens").DataTable().data().toArray().findIndex(r => r[1] == descricaoItem);
          const row = $("#tabelaItens tbody tr")[idx];
          await criaTelaDesconto(row, false);
          $("#txtPercDesconto").val(g_DescCliente.toLocaleString("pt-BR", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
          $("#txtPercDesconto").trigger("blur");
          await eventoClickPesquisaDescontoConfirmar(row, false); // 304531
        }
      }

      async function incluirOuAgruparItemNaTabela(params) {
        const {
          jsonStr, vQtde, indexItem, sCodigoValidacao, bAgrupa, utilizaImpressoraFiscal,
          numeroPed, ordemPed, caixaPed, vendedorItem, vBrinde, codigoRegra, bDepositoEcommerce, sDeposito
        } = params;

        const qualidade = jsonStr.QUALIDADE;
        const vBarraUtilizada =
          (jsonStr.BARRA != '' ? jsonStr.BARRA : jsonStr.BARRA28) || jsonStr.BARRACLI || '';

        // preços
        const precos = await calculaPrecos(vBrinde, jsonStr.PRECO);
        preencheCamposItemUI(jsonStr, vQtde, precos.sPreco, precos.sPrecoOrig, precos.sPrecoOrigOld);

        if (jsonStr.BLOQ_VENDA  == 'S') {
          msgAlerta(`Produto ${jsonStr.CODIGO} com Status de bloqueio para digitação de venda.`);
          return;
        }

        // regra de igualdade já aplicada (mantido)
        let itemUsaRegraPromocaoIgualdade = false;
        let currentIndex = indexItem;
        if (currentIndex != -1) {
          itemUsaRegraPromocaoIgualdade = await verificaRegraIgualdadeAplicadaNoItem(currentIndex);
          if (itemUsaRegraPromocaoIgualdade) {
            currentIndex = $('#tabelaItens').DataTable().data().toArray()
              .map(item => item[16] + ' - ' + item[31])
              .indexOf(sCodigoValidacao + ' - 0');
          }
        }

        if ((currentIndex >= 0) && bAgrupa) {
          const dataOld = $('#tabelaItens').DataTable().row(currentIndex).data();
          dataOld[2] = parseFloat((dataOld[2] + vQtde).toFixed(2));
          dataOld[7] = parseFloat(dataOld[2] * dataOld[4]).toFixed(2);
          $('#tabelaItens').DataTable().row(currentIndex).data(dataOld);
          SomAlerta();
          return;
        }

        // inclusão de nova linha
        const { soma, total } = calculaTotaisItem(precos.sPreco, vQtde, utilizaImpressoraFiscal);
        let valorDesc = 0;
        if (numeroPed != '') {
          const somaOrig = +(precos.sPrecoOrig * vQtde).toFixed(4);
          const totOrig = calculaTotaisItem(precos.sPrecoOrig, vQtde, utilizaImpressoraFiscal).total;
          valorDesc = totOrig - total;
          if (valorDesc < 0) valorDesc = 0;
        }

        const agrupamentoItem = montaDescricaoAgrupamento(jsonStr, qualidade);
        const descricaoItem = `${jsonStr.CODIGO} - ${jsonStr.DESCRICAO} - ${jsonStr.COR} - ${jsonStr.DESC_COR} - ${jsonStr.TAM}`;
        const itemTemRelacionado = jsonStr.PROD_RELAC

        if (itemTemRelacionado) {
          $('.itemRelacionado').removeClass('d-none').addClass('d-flex');
        }

        SomAlerta();

        return [
          jsonStr.CODIGO,
          descricaoItem,
          vQtde,
          precos.sPrecoOrig,
          precos.sPreco,
          0,
          valorDesc,
          total,
          await retornaBotaoOpcoes(),
          vBarraUtilizada,
          jsonStr.COR,
          jsonStr.TAM,
          jsonStr.DESC_COR,
          jsonStr.QUALIDADE,
          jsonStr.ID_ESTOQUE,
          0,
          agrupamentoItem,
          $('#cb_presente:checked').length > 0,
          jsonStr.LOTE,
          bDepositoEcommerce ? 'E' : jsonStr.TIPO,
          0,
          0,
          0,
          numeroPed,
          ordemPed,
          caixaPed,
          vendedorItem,
          `${formataData(new Date())}T00:00:00Z`,
          jsonStr.UNIDADE,
          jsonStr.PROMOCAO == 'S',
          precos.sPrecoOrig,          // sPrecoOrigOld -> igual neste caso
          codigoRegra,
          codigoRegra == 0 ? "" : "Brinde",
          sDeposito,
          getTabela(),
          itemTemRelacionado,
          '', // lote orig
          jsonStr.TIPO == 'M' ? jsonStr.QTDE_ORIG : 0,
          0   // IPI
        ]
      }

      /* ===========================
        Estorno de item
        =========================== */
      async function estornaItemDaTabela(sCodigoValidacao, sCodigo, semFoco) {
        async function estornaPorCodigo(vCodigo) {
          const itens = $("#tabelaItens").DataTable().data().toArray();
          const indexItem = itens.findIndex(registro => registro[16] == vCodigo);
          if (indexItem == -1) {
            msgAlerta('Barra não encontrada para estorno, verifique.');
            return;
          }

          // proteção adicional — barra removida temp
          const barraJaFoiRemovida = listaBarrasRemovidasTemp.filter(i => i == sCodigo).length > 0;
          if (barraJaFoiRemovida) {
            msgAlerta('Barra já foi estornada, verifique.');
            return;
          }

          // valida barra log se ativado
          if (usaBarraLog()) {
            const retorno = await retornaBarraLogLida(sCodigo);
            if (['barra_log'].includes(retorno)) {
              const barraNaoFoiBipada = listaBarrasBipadas.filter(i => i == sCodigo).length == 0;
              if (barraNaoFoiBipada) {
                msgAlerta('Barra não encontrada para estorno, verifique.');
                return;
              }
            }
          }

          await estornaBarraBipada(sCodigo, numero_venda);

          // quantidade atual versus desejada
          const vQtde = formataNumerico(getQuantidadeRaw());
          const rowData = $("#tabelaItens").DataTable().row(indexItem).data();

          if (rowData[2] === vQtde) {
            $("#tabelaItens").DataTable().row(indexItem).remove().draw(false);
          } else {
            const dataOld = rowData;
            dataOld[2] = dataOld[2] - vQtde;
            dataOld[7] = parseFloat(dataOld[2] * dataOld[4]).toFixed(2);
            if (dataOld[2] < formataNumerico(getQuantidadeRaw())) {
              $("#tabelaItens").DataTable().row(indexItem).remove().draw(false);
            } else {
              $("#tabelaItens").DataTable().row(indexItem).data(dataOld);
            }
          }

          SomAlerta();
          setCodigo('');
          setIdItem('');
          setCodigoEPC('');
          if (!semFoco) focaCampo();

          // regras de promoção ao estornar
          if (((parametrosVenda[29] == 1) && (pegaChave('#txtRegraPromocao'))) || (parametrosVenda[29] == 2)) {
            removeRegraPromocao();
            await eventoClickBtnRecalcularRegra(true);
            if (bAplicaDescMaxTabPrecoVenda || bAplicaDescMaxTabPrecoVendaNotAlterar) {
              await reaplicaDescMax();
            }
          }

          let venda = {};
          venda = await montaJsonVenda(venda, 'create', 'P', false);
          salvaDadosDigitados(venda);
          atualizaTotalVenda();
        }

        if (pedeSenhaExclusao()) {
          const vCodigo = getCodigo();
          await senhaSupervisor(
            'Exclusão de item da venda',
            estornaPorCodigo,
            vCodigo,
            false,
            undefined,
            undefined,
            undefined,
            false,
            'VENDA',
            (numero_venda == 'create' || numero_venda == 'create#') ? localStorage.getItem(`SEQUENCIALVENDAPENDENTE`) : numero_venda,
            pegaChave('#txtCliente'),
            parseFloat($('#saldo_geral').text().replace(/R\$\s*/, '').replaceAll('.', '').replace(',', '.')) || 0
          );
        } else {
          await estornaPorCodigo(sCodigoValidacao);
        }
      }

      /* ===========================
        Pós-processamento comum
        =========================== */

      async function posProcessamentoDepoisDeIncluir(jsonStr, bDepositoEcommerce, semFoco, dataItensRelacionados) {
        if (dataItensRelacionados.length > 0) {
          await validaItensRelacionados();
        }

        let venda = {};
        venda = await montaJsonVenda(venda, numero_venda, 'P', false);
        salvaDadosDigitados(venda);
        atualizaTotalVenda();

        setCodigo('');
        setIdItem('');
        setCodigoEPC('');

        if (!semFoco) focaCampo();

        if ((parametrosVenda[87] == 1) && (jsonStr.TIPO == 'P')) {
          await reservaProduto(jsonStr.ID_ESTOQUE, formataNumerico(getQuantidadeRaw()));
        }
      }

      function selecionaLinhaNaTabelaSeNecessário(indexItem, bAgrupa) {
        // Seleção visual após a inclusão/agrupamento
        if ((indexItem >= 0) && bAgrupa) {
          if (!$(`#tabelaItens tbody tr:eq(${indexItem})`).hasClass('selected')) {
            $(`#tabelaItens tbody tr:eq(${indexItem})`).trigger('click');
            $('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
          }
        } else {
          if (!$('#tabelaItens tbody tr:last-child').hasClass('selected')) {
            $('#tabelaItens tbody tr:last-child').trigger('click');
            $('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));
          }
        }
      }

      /* ===========================
          Função Principal — EPC
      =========================== */
      async function RotinaSaidaCodigoEPC(tipo = 'P',numeroPed = '',ordemPed = 0,caixaPed = '',semFoco = false,codigoMaterial = '',corMaterial = '',vBrinde = 0,codigoRegra = 0, barrasCadastradasPrecoManual = []) {
        async function ValidaDados(jsonStr, vQtde, vQtdeGrid, bEstorno) {
            let passou = true  
            // Preço cadastrado?
            if (!await retornaPrecoCadastrado(jsonStr)) {
              precoNaoCadastrado.push(jsonStr)
              passou = false
            }
            // Checagem de estoque conforme política
            const estoqueOK = await checaEstoqueENotificaSeNecessario(jsonStr, vQtde, vQtdeGrid, bEstorno);
            if (!estoqueOK) {
              mostrouAlerta = true; // segue fluxo de limpeza final
              semEstoque.push(jsonStr);
              passou = false
            }
            // Valida se grupo do produto permite consignado 
            if (!await validaConsignadoSeNecessário(jsonStr)) passou = false

            if (!passou) return passou 
            // BarraLog controle de entrada (força qtde=1 quando adiciona no log)
            const barraLogCtl = await barraLogControleEntradaSaida(sCodigo, bEstorno, !!jsonStr.BARRA_LOG);
            if (!barraLogCtl.ok) {
              passou = false
              barrasJaBipadas.push(jsonStr)
            };
            if (barraLogCtl.vQtdeForcada != null) vQtde = barraLogCtl.vQtdeForcada;
            
            
            return passou
          }
      
        async function retornaDadosEPC() {
            const bDepositoEcommerce = isChecked('#cbDepositoEcommerce') && $('#modalProduto').is(':visible');
            const estorno = bEstorno ? 'S' : 'N';
            const sTabela = pegaChave("#txtTabela");
            const sDeposito = pegaChave("#txtDeposito");
            const iLancamento = $('#txtLancamento').val() != '' ? $('#txtLancamento').val() : 0;
            const sQualidade = pegaChave('#txtQualidade');
            const iIdItem = $('#txtIdItem').val()
            const sNumero = pegaChave('#txtPedido')
            const sPrazo = pegaValor('#rgPrazo')
            const sPrecoSemCadastro = $('#txtPrecoManual').val().replace('.', ',')  != '' ? $('#txtPrecoManual').val().replace('.', ',') : '' 
            const url = `/sisplan/epc/v1/detalhes?`;
            let tipoItem = '';

            if ($('#radioMaterial').is(':checked') || $("#modalMaterial").hasClass("show")) {
              tipoItem = 'M'
            } else if ($('#radioProduto').is(':checked')) {
              tipoItem = 'P'
            }

            const params = new URLSearchParams({
              DEPOSITO: sDeposito,
              LANCAMENTO: iLancamento,
              IDITEM: iIdItem,
              TABPRECO: sTabela,
              QUALIDADE: sQualidade,
              TIPO: tipo,
              PRECOSEMCADASTRO: sPrecoSemCadastro,
              NUMERO: sNumero,
              PRAZO: sPrazo,
              IMPORTAPEDIDO: importaPedido,
              CODVENDA: '',
              DEVOLUCAO: '',
              ESTORNO: estorno,
            });
            let listaFormatada; 
            if (barrasCadastradasPrecoManual.length > 0) {
              listaFormatada = barrasCadastradasPrecoManual.map(epc => `'${epc}'`).join(',');
            } else {
              listaFormatada = epc.listaBarrasForamBipadasEPC.map(epc => `'${epc}'`).join(',');
            }
            const response = await requisicao('POST', url, params.toString(), listaFormatada);

            if (!response) {
              return;
            }
            const jsonStr = await response.json();

            return jsonStr ?? [];
        }
        let mostrouAlerta = false;

        // if (!validaCamposIniciais()) return;
        const bDepositoEcommerce = aplicaDepositoEcommerceSeNecessário();
        const bAgrupa = agrupaItens();
        // Detecta estorno
        const estornoInfo = detectaEstornoOuExclusao();
        if (estornoInfo.cancelado) return;
        const bEstorno = estornoInfo.bEstorno;
        // Extrai "3*barra"
        extraiQuantidadeDoCodigoSeVierNoFormatoMultiplicador();
        // Tabela (mantém)
        const sTabela = getTabela();
        // Parâmetros e contexto
        const dataItensRelacionados = $('#tabelaItens').DataTable().rows(".linha-prodRelac").data().toArray().length > 0;
        const sDeposito = resolveDepositoParaSaida();
        let sCodigo = getCodigo();
        let sIdItem = getIdItem();
        let sCodigoEPC = getCodigoEPC();
        let semEstoque = []
        let barrasJaBipadas = []
        let precoNaoCadastrado = []
        let itens = []
        let temItemComProblema = false
        
        $('.divItensSemEstoqueRFID').addClass('d-none');
        $('.divItensJaBipados').addClass('d-none');
        $('.divItensGrupoNaoPermiteConsig').addClass('d-none');
        $('.divItensSemPreco').addClass('d-none');

        try {
          $.LoadingOverlay('show');
          // Quantidade
          let { ok, vQtde } = await resolveQuantidadeDigitada();
          if (!ok) return;

          // Limite de itens
          if (!checaLimiteMaximoDeItens(bEstorno)) return;

          // KG na primeira linha
          if ($('#tabelaItens').DataTable().rows().count() === 0) {
            await verificaTabelaPrecoKG();
          }

          // Busca dados do EPC/barra/estoque
          const jsonStr = await retornaDadosEPC(
            sCodigo,
            sIdItem,
            tipo == 'M' ? codigoMaterial : '',
            tipo == 'M' ? corMaterial   : '',
            tipo,
            bEstorno,
            sDeposito
          );
          if (jsonStr.length == 0) return;

          for (let index = 0; index < jsonStr.length; index++) {
            sCodigo = !!jsonStr[index].BARRA_LOG ? jsonStr[index].BARRA_LOG : jsonStr[index].BARRA;

            // Agrupamento/index do item idêntico
            const qualidade = jsonStr[index].QUALIDADE;
            const { sCodigoValidacao, indexItem, vQtdeGrid } = coletaInfoAgrupamentoEIndex(jsonStr[index], qualidade);

            // valida preço // estoque // consignado // barraJaLida
            if (!await ValidaDados(jsonStr[index], vQtde, bEstorno )) {
              temItemComProblema = true
              continue
            };
            // Inclusão OU Estorno
            if (!bEstorno) {
              const vendedorItem = $('#txtVendedorItem').val() !== '' ? pegaChave('#txtVendedorItem') : pegaChave('#txtVendedor');

              itens.push(await incluirOuAgruparItemNaTabela({
                jsonStr: jsonStr[index], vQtde, indexItem, sCodigoValidacao, bAgrupa,
                utilizaImpressoraFiscal, numeroPed, ordemPed, caixaPed,   
                vendedorItem, vBrinde, codigoRegra,
                bDepositoEcommerce, sDeposito
              }));

              // regras e pós-processamento
              await posProcessamentoDepoisDeIncluir(jsonStr[index], bDepositoEcommerce, semFoco, dataItensRelacionados);
            } else {
              await estornaItemDaTabela(sCodigoValidacao, sCodigo, semFoco);
            }
          }

          // joga tudo de uma vez pra tabela pois é mais rapido do que linha a linha...
          $('#tabelaItens').DataTable().rows.add(itens).draw(false)

          let venda = {};
          venda = await montaJsonVenda(venda, numero_venda, 'P', false);
          salvaDadosDigitados(venda);
          atualizaTotalVenda();
        
          if (((parametrosVenda[29] == 1) && (getTabela() != '')) || (parametrosVenda[29] == 2)) {
           await eventoClickBtnRecalcularRegra();
          }

          selecionaLinhaNaTabelaSeNecessário(jsonStr.length, bAgrupa);

          $.LoadingOverlay('hide');

          if ($.fn.DataTable.isDataTable('#tabelaItensSemEstoqueRFID')) {
            $('#tabelaItensSemEstoqueRFID').DataTable().destroy();
            $('#tabelaItensSemEstoqueRFID').empty();
          }
          if ($.fn.DataTable.isDataTable('#tabelaItensSemPrecoAgrupados')){
            $('#tabelaItensSemPrecoAgrupados').DataTable().destroy();
            $('#tabelaItensSemPrecoAgrupados').empty();
          }
          if ($.fn.DataTable.isDataTable('#tabelaItensJaBipados')) {
            $('#tabelaItensJaBipados').DataTable().destroy();
            $('#tabelaItensJaBipados').empty();
          }
          if ($.fn.DataTable.isDataTable('#tabelaItensGrupoNaoPermiteConsig')) {
            $('#tabelaItensGrupoNaoPermiteConsig').DataTable().destroy();
            $('#tabelaItensGrupoNaoPermiteConsig').empty();
          }
          const columns = [
            {
              'title': 'Código',
              'data': 'CODIGO'
            }, {
              'title': 'Descrição',
              'data': 'DESCRICAO'
            }, {
              'title': 'Cor',
              'data': 'COR'
            }, {
              'title': 'Descrição Cor',
              'data': 'DESC_COR'
            }, {
              'title': 'Tamanho',
              'data': 'TAM'
            }, {
              'title': 'Barra',
              'data': 'BARRA'
            }, {
              'title': 'Barra Log',
              'data': 'BARRA_LOG'
            }, {
              'title': 'Qtde Estoque',
              'data': 'ESTOQUE'
            },{
              'title': 'EPC',
              'data': 'EPC'
            }
          ];

          // === Mensagens agrupadas ===
          if (semEstoque.length > 0) {
            criaDataTablePadrao('#tabelaItensSemEstoqueRFID', false, false, false, false, true, true, '150px', semEstoque, columns, [8]);
            $('.divItensSemEstoqueRFID').removeClass('d-none');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            setTimeout(() => {
              $('#tabelaItensSemEstoqueRFID').DataTable().columns.adjust().draw(false);
            }, 550);
          }

          if (barrasJaBipadas.length > 0) {
            criaDataTablePadrao('#tabelaItensJaBipados', false, false, false, false, true, true, '150px', barrasJaBipadas, columns, [7, 8]);
            $('.divItensJaBipados').removeClass('d-none');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            setTimeout(() => {
              $('#tabelaItensJaBipados').DataTable().columns.adjust().draw(false);
            }, 550);
          }

          if (naoPermiteConsig.length > 0) {
            criaDataTablePadrao('#tabelaItensGrupoNaoPermiteConsig', false, false, false, false, true, true, '150px', naoPermiteConsig, columns, [7, 8]);
            $('.divItensGrupoNaoPermiteConsig').removeClass('d-none');
            SomAlerta('<?php echo BASE_URI; ?>', true);
            setTimeout(() => {
              $('#tabelaItensGrupoNaoPermiteConsig').DataTable().columns.adjust().draw(false);
            }, 550);
          }

          function retornaInputPreco(data) {
            return `<input type="number" class="input-default focus inputprecoRFID" min="0" value="${data ? data : '0' }">`;
          }

          // Exemplo para preços não cadastrados (se tiver esse array no futuro)
          if (precoNaoCadastrado && precoNaoCadastrado.length > 0) {
            const bUsaPrecoCorTam = usaPrecoCorTam()
            const dados = precoNaoCadastrado.reduce((acc, row) => {
              if (bUsaPrecoCorTam) {
                if (row.CODIGO === acc.find(r => r.CODIGO === row.CODIGO && r.COR === row.COR && r.TAM === row.TAM)?.CODIGO) {
                  return acc; // pula duplicatas
                }
              } else {
                if (row.CODIGO === acc.find(r => r.CODIGO === row.CODIGO)?.CODIGO) {
                  return acc; // pula duplicatas
                }
              }
              acc.push(row);
              return acc;
            }, []);
            $('#tabelaItensSemPrecoAgrupados').DataTable({
              destroy: true,
              select: true,
              keys: false,
              searching: false,
              order: false,
              lengthChange: false,
              scrollX: true,
              scrollY: "150px",
              scrollCollapse: true,
              paging: false,
              "columns": [...columns, { 'title': 'Preço', 'data': 'PRECO' }],
              "data": dados,
              "columnDefs": [{
                  "render": function(data) {
                    return retornaInputPreco(data);
                  },
                  "targets": [9],
                },
                {
                  "visible": false,
                  "targets": [7,8]
                }
              ],
            });
              $('#tabelaItensSemPreco').DataTable({
              destroy: true,
              select: true,
              keys: false,
              searching: false,
              order: false,
              lengthChange: false,
              scrollX: true,
              scrollY: "150px",
              scrollCollapse: true,
              paging: false,
              "columns": [...columns, { 'title': 'Preço', 'data': 'PRECO' }],
              "data": precoNaoCadastrado,
              "columnDefs": [{
                  "render": function(data) {
                    return retornaInputPreco(data);
                  },
                  "targets": [9],
                },
                {
                  "visible": false,
                  "targets": [7,8]
                }
              ],
            });

            $('#btn_confirmar_venda_importada').unbind('click');
            $('#btn_confirmar_venda_importada').on('click', async function() {
              await confirmarImportacaoVenda();
            });

            $('#tabelaItensSemPreco').on('change', 'input.inputprecoRFID', function () {
              const valor = $(this).val();
              const row = $('#tabelaItensSemPreco').DataTable().row($(this).closest('tr')).data();
              console.log('Linha:', row, ' | Preço digitado:', valor);
            });

            $('.divItensSemPreco').removeClass('d-none');
          }
          SomAlerta('<?php echo BASE_URI; ?>', true);


          if (temItemComProblema) {
            $('#modalMensagensRFID').modal('show')
          }

          $.LoadingOverlay('hide');
        } finally {
          $.LoadingOverlay('hide');

          setTimeout(() => {
            if ($.fn.DataTable.isDataTable('#tabelaItensSemEstoqueRFID'))
              $('#tabelaItensSemEstoqueRFID').DataTable().columns.adjust().draw(false);
            if ($.fn.DataTable.isDataTable('#tabelaItensSemPrecoAgrupados'))
              $('#tabelaItensSemPrecoAgrupados').DataTable().columns.adjust().draw(false);
            if ($.fn.DataTable.isDataTable('#tabelaItensJaBipados')) 
              $('#tabelaItensJaBipados').DataTable().columns.adjust().draw(false);
            if ($.fn.DataTable.isDataTable('#tabelaItensGrupoNaoPermiteConsig')) 
              $('#tabelaItensGrupoNaoPermiteConsig').DataTable().columns.adjust().draw(false);
          }, 550);
        }
      }

      $('#btnConfirmarPrecoRFID').on('click', async function() {
        const table = $('#tabelaItensSemPreco').DataTable();
        const tableAgrupadas = $('#tabelaItensSemPrecoAgrupados').DataTable();
        if (tableAgrupadas.rows().count() == 0) {
          msgAlerta('Não existem itens para confirmar preço. Verifique.');
          return;
        }
        const obj = []
        const itensSemPreco = []
        const dadosAgrupados = [];
        tableAgrupadas.rows().every(async function () {
          const rowNode = this.node();
          const inputVal = $(rowNode).find('input.inputprecoRFID').val();
          const rowData = this.data();
          if (inputVal == '' || isNaN(inputVal) || Number(inputVal) <= 0) {
            itensSemPreco.push(rowData);
            return;
          }
        });

        if (itensSemPreco.length > 0) {
          msgAlerta('Existem itens sem preço válido. Verifique.');
          return;
        }

        tableAgrupadas.rows().every(async function () {
          const rowNode = this.node();
          const inputVal = $(rowNode).find('input.inputprecoRFID').val();
          const rowData = this.data();

          rowData.PRECO = Number(inputVal);

          if (rowData.PRECO == '' || isNaN(rowData.PRECO) || Number(rowData.PRECO) <= 0) {
            return;
          }

          obj.push({
            PRECO: Number(inputVal),
            BARRA: !!rowData.BARRA_LOG ? rowData.BARRA_LOG : rowData.BARRA,
            ID_ESTOQUE: rowData.ID_ESTOQUE,
            TABELA: getTabela(),
            CODIGO: rowData.CODIGO,
            COR: rowData.COR,
            TAM: rowData.TAM
          });
        });

        for (let i = 0; i < obj.length; i++) {
          const pPreco = obj[i].PRECO;
          const sBarra = obj[i].BARRA;
          const pIdItem = obj[i].ID_ESTOQUE;
          const sTabela = obj[i].TABELA;
          table.rows().data().toArray().forEach((data) => {
            if (data.CODIGO == obj[i].CODIGO && data.COR == obj[i].COR && data.TAM == obj[i].TAM) dadosAgrupados.push(data)
            })
          await RotinaConfirmarPrecoManualEPC(sTabela, sBarra, pPreco, pIdItem)
        }

        await RotinaSaidaCodigoEPC('P', '', 0, '', true, '', '', 0, 0, dadosAgrupados.map(i => i.EPC))
      });
    });

    $('#spanPorcentagem').html(`${!Math.trunc(localStorage.getItem('zoom')) ? '100%' : Math.trunc(localStorage.getItem('zoom'))}%`);
    document.body.style.zoom = `${!Math.trunc(localStorage.getItem('zoom')) ? '100%' : Math.trunc(localStorage.getItem('zoom'))}%`;

    if ($('body').css('zoom') == '0.8') {
      $('#ZoomOut').attr('disabled', true);
    }

    if ($('body').css('zoom') == '1.2') {
      $('#ZoomIn').attr('disabled', true);
    }

    function mostra2Casas(nr) {
      const og = Math.pow(10, 2);
      return Math.floor(nr * og) / og;
    }

    $('#buscaPedidoOutrasEmpresas').prop('checked', true);

    $('#btnMenosOuMais').on('click', function() {
      const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
      $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
      $('#txtCodigo').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
      $('#txtCodigo').focus();
      $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
      if (estaComoEstorno) {
        $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
      } else {
        $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus');
      }
    });

    $('#btnMenosOuMaisBrinde').on('click', function() {
      const estaComoEstorno = $('#btnMenosOuMaisBrinde>i.fa-minus').length > 0;
      $('#txtBarraBrinde').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
      $('#txtBarraBrinde').focus();
      $('#btnMenosOuMaisBrinde').attr('data-estorno', !estaComoEstorno);
      if (estaComoEstorno) {
        $('#btnMenosOuMaisBrinde>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
      } else {
        $('#btnMenosOuMaisBrinde>i.fa-plus').removeClass('fa-plus').addClass('fa-minus');
      }
    });

    async function buscaClienteUltimaVenda(regiao) {
      try {

        const pesquisa = {
          tabela: 'VENDA',
          camposSelect: ["VENDA.CODCLI", "ENTIDADE.NOME", "VENDA.ATEND_FINALIZADO"],
          innerJoin: [{
            tabela: "ENTIDADE",
            condicao: "ENTIDADE.CODCLI = VENDA.CODCLI"
          }],
          where: [`VENDA.EMP_ID = ${getCookie("emp_id")}`, `ENTIDADE.REG_ESTADO = '${regiao}'`],
          orderby: ["VENDA.DATA DESC", "VENDA.CODVEN DESC"]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length > 0) {
          if (jsonStr[0].ATEND_FINALIZADO != "S") {
            return {
              CODCLI: jsonStr[0].CODCLI,
              NOME: jsonStr[0].NOME
            };
          }
        }

        return "";

      } catch (error) {
        console.error(error);
        return "";
      }
    }

    async function retornaDescMaxTabPreco(codigoItem, tabPreco) {
      try {

        const pesquisa = {
          tabela: 'TABPRECO',
          camposSelect: ["DESC_MAX"],
          where: [`CODIGO = '${codigoItem}'`, `REGIAO = '${tabPreco}'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.str