$(document).ready(async function () {

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtMunicipioNFMod1: {
                required: true,
            },
            txtNotaNFMod1: {
                required: true,
            },
            txtSerieNFMod1: {
                required: true,
            },
            txtCNPJNFMod1: {
                required: true,
            },
            txtUFDestinoNFMod1: {
                required: true,
            },
            txtDataEmissaoNFMod1: {
                required: true,
            },
            txtPesoBrutoNFMod1: {
                required: true,
            },
            txtValorNFMod1: {
                required: true,
            },
            txtMunicipioConheTransp: {
                required: true,
            },
            txtNotaConheTransp: {
                required: true,
            },
            txtSerieConheTransp: {
                required: true,
            },
            txtSubSerieConheTransp: {
                required: true,
            },
            txtDataEmissaoConheTransp: {
                required: true,
            },
            txtPesoBrutoConheTransp: {
                required: true,
            },
            txtValorConheTransp: {
                required: true,
            },
            txtVeiculo: {
                required: true,
            },
            txtMotorista: {
                required: true,
            },
            txtUFCarregamento: {
                required: true,
            },
            txtUFDescarregamento: {
                required: true,
            }
        },
        messages: {
            txtMunicipioNFMod1: {
                required: "Informe o município."
            },
            txtNotaNFMod1: {
                required: "Informe a nota."
            },
            txtSerieNFMod1: {
                required: "Informe a série."
            },
            txtCNPJNFMod1: {
                required: "Informe o CNPJ do emitente."
            },
            txtUFDestinoNFMod1: {
                required: "Informe a UF."
            },
            txtDataEmissaoNFMod1: {
                required: "Informe a data de emissão."
            },
            txtPesoBrutoNFMod1: {
                required: "Informe o peso bruto."
            },
            txtValorNFMod1: {
                required: "Informe o valor."
            },
            txtMunicipioConheTransp: {
                required: "Informe o município",
            },
            txtNotaConheTransp: {
                required: "Informe a nota",
            },
            txtSerieConheTransp: {
                required: "Informe a série",
            },
            txtSubSerieConheTransp: {
                required: "Informe  sub-série",
            },
            txtDataEmissaoConheTransp: {
                required: "Informe a data de emissão",
            },
            txtPesoBrutoConheTransp: {
                required: "Informe o peso bruto",
            },
            txtValorConheTransp: {
                required: "Informe o valor",
            },
            txtVeiculo: {
                required: "Informe o veículo"
            },
            txtMotorista: {
                required: "Informe o motorista"
            },
            txtUFCarregamento: {
                required: "Informe a UF de carregamento"
            },
            txtUFDescarregamento: {
                required: "Informe a UF de descarregamento"
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    mascaraValor();

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    await componentesPesquisa();
    setarDataAtual('txtDtEmissao')

    async function componentesPesquisa() {
        await componenteFiltro('reboque', true);
        // await componenteFiltro('cidade', true, true, 'MunicipiosCarregamento');
        await componenteFiltro('tabuf', true, true, 'UFPercurso');
        await componenteFiltro('motorista', true, true, 'MotoristaVeiculo');
        await componenteFiltro('transportadora', true);
        await componenteFiltro('grupoCli', true);
        await componenteFiltro('veiculo', true, true, 'Placa');

        $('#txtMunicipiosCarregamento').pesquisa_variosServerside(3, `{"tabela":"CIDADE","camposSelect":["COD_UF","NOME","CODIGO"]}`, 'CODIGO', 'NOME');
        $('#btnMunicipiosCarregamento').pesquisa_serversideSel('#txtMunicipiosCarregamento', `{"tabela":"CIDADE","camposSelect":["CODIGO","NOME","COD_UF"]}`, `Pesquisa Cidade`);
        $('#btnLimpaMunicipiosCarregamento').on('click', function () {
            $('#txtMunicipiosCarregamento').empty().trigger('change')
        });

        $('#txtNumCargaConsulta').autocompleta(1, `JSON={ "tabela":"FORMA_CARGA", "camposSelect":[ "CARGA CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $('#btn-NumCargaConsulta').pesquisa('#txtNumCargaConsulta', 'CARGA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FORMA_CARGA", "camposSelect":[ "CARGA", "DESCRICAO"]}`, 'Pesquisa carga', 'FORMA_CARGA');
        $('#btn-limpa-NumCargaConsulta').on('click', function () {
            $('#txtNumCargaConsulta').val('');
        });

        $('#txtVeiculo').autocompleta(1, `JSON={ "tabela":"VEICULO", "camposSelect":[ "placa chave", "modelo descricao"], "where": ["ATIVO = 'S'"]}`);
        $('#btnVeiculo').pesquisa('#txtVeiculo', 'PLACA', 'MODELO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VEICULO", "camposSelect":[ "PLACA", "MODELO"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa veículo', 'VEICULO');
        $('#btnLimpaVeiculo').on('click', function () {
            $('#txtVeiculo').val('');
        });

        $('#txtUFCarregamento').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
        $('#btnUFCarregamento').pesquisa('#txtUFCarregamento', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa UF', 'TABUF');
        $('#btnLimpaUFCarregamento').on('click', function () {
            $('#txtUFCarregamento').val('');
        });

        $('#txtUFDescarregamento').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
        $('#btnUFDescarregamento').pesquisa('#txtUFDescarregamento', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa UF', 'TABUF');
        $('#btnLimpaUFDescarregamento').on('click', function () {
            $('#txtUFDescarregamento').val('');
        });

        $('#txtMotorista').autocompleta(1, `JSON={ "tabela":"MOTORISTA", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
        $('#btnMotorista').pesquisa('#txtMotorista', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOTORISTA", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa motorista', 'MOTORISTA');
        $('#btnLimpaMotorista').on('click', function () {
            $('#txtMotorista').val('');
        });

        $('#txtMunicipioNFMod1').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
        $(`#btn-MunicipioNFMod1`).pesquisa(
            `#txtMunicipioNFMod1`,
            "CODIGO",
            "NOME",
            '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME"], "where": null}',
            "Pesquisa Cidade",
            "CIDADE"
        );
        $('#btn-limpar-MunicipioNFMod1').on('click', function () {
            $('#txtMunicipioNFMod1').val('');
        });

        $('#txtMunicipioConheTransp').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
        $(`#btn-MunicipioConheTransp`).pesquisa(
            `#txtMunicipioConheTransp`,
            "CODIGO",
            "NOME",
            '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME"], "where": null}',
            "Pesquisa Cidade",
            "CIDADE"
        );
        $('#btn-limpar-MunicipioConheTransp').on('click', function () {
            $('#txtMunicipioConheTransp').val('');
        });

        $('#txtCEPCarregamentoProdPredo').autocompleta(1, `JSON={ "tabela":"CADCEP", "camposSelect":[ "CEP CHAVE", "CEP DESCRICAO"], "where": null}`);
        $(`#btn-CEPCarregamentoProdPredo`).pesquisa_serverside(
            [`#txtCEPCarregamentoProdPredo`],
            ["CEP"],
            ["CEP"],
            '{ "tabela":"CADCEP", "camposSelect":[ "CEP", "CEP"], "where": null}',
            "Pesquisa CEP"
        );
        $('#btn-limpar-CEPCarregamentoProdPredo').on('click', function () {
            $('#txtCEPCarregamentoProdPredo').val('');
        });

        $('#txtCEPDescarregamentoProdPredo').autocompleta(1, `JSON={ "tabela":"CADCEP", "camposSelect":[ "CEP CHAVE", "CEP DESCRICAO"], "where": null}`);
        $(`#btn-CEPDescarregamentoProdPredo`).pesquisa_serverside(
            [`#txtCEPDescarregamentoProdPredo`],
            ["CEP"],
            ["CEP"],
            '{ "tabela":"CADCEP", "camposSelect":[ "CEP", "CEP"], "where": null}',
            "Pesquisa CEP"
        );
        $('#btn-limpar-CEPDescarregamentoProdPredo').on('click', function () {
            $('#txtCEPDescarregamentoProdPredo').val('');
        });
    }

    $('input[name="radioTipoTransporte"]').click(function () {
        abasAtivas(this);
    });

    $('#btnIncluirNFMod1').click(function () {
        adicionaNFMod1(
            pegaValor('#txtMunicipioNFMod1'),
            pegaValor('#txtNotaNFMod1'),
            pegaValor('#txtSerieNFMod1'),
            pegaValor('#txtCNPJNFMod1'),
            pegaValor('#txtUFDestinoNFMod1'),
            pegaValor('#txtDataEmissaoNFMod1'),
            pegaValor('#txtPesoBrutoNFMod1'),
            pegaValor('#txtValorNFMod1')
        );
    });

    $('#btnIncluirConheTransp').click(function () {
        adicionaCT(
            pegaValor('#txtMunicipioConheTransp'),
            pegaValor('#txtNotaConheTransp'),
            pegaValor('#txtSerieConheTransp'),
            pegaValor('#txtSubSerieConheTransp'),
            pegaValor('#txtDataEmissaoConheTransp'),
            pegaValor('#txtPesoBrutoConheTransp'),
            pegaValor('#txtValorConheTransp')
        );
    });

    $('#btnSelecionarNFe').click(function () {
        $('#modal-Selecionar').modal('show');
    });

    $('#btnSelecionarCte').click(function () {
        $('#modal-Selecionar').modal('show');
    });

    $('#btnConfirmarDocumentos').click(function () {
        importarDocumentos();
    });

    $('#btnGravar').click(async function () {
        if ((isChecked('#radioTransportadora')) && (pegaValor('#txtDescProdPredomiProdPredo') == '')) {
            msgAlerta('Grupo de informações de produto predominante não informado. Continuar mesmo assim?', () => { },
                () => {
                    $('#tabProdPredo').trigger('click');
                    $('#txtDescProdPredomiProdPredo').focus();
                },
                async () => {
                    await gravaMDFe();
                }
            );
        } else {
            await gravaMDFe();
        }
    });

    $('#modal-Selecionar').on('show.bs.modal', function () {
        const bloquear = isChecked('#radioTransportadora');
        $('#radioTipoDadosNFe').prop('disabled', bloquear);
        $('#radioTipoDadosNFe').prop('checked', !bloquear);
        $('#radioTipoDadosNFeRadar').prop('disabled', bloquear);
        $('#radioTipoDadosCTe').prop('disabled', !bloquear);
        $('#radioTipoDadosCTe').prop('checked', bloquear);

    });

    $('#check_todos').on('change', function () {
        $('.checkDocumento').prop('checked', $('#check_todos').prop('checked'));
        if ($('#checkDocumento').prop('checked')) {
            $('.checkDocumento').addClass('selecionado');
        } else {
            $('.checkDocumento').removeClass('selecionado');
        }
        addSelected($('#check_todos').prop('checked'));
    });

    $("#tabelaDocumentos").on("click", "td", function () {
        selecionarLinhaTabela("#tabelaDocumentos", "checkDocumento", this);
    });

    $('#txtChaveNFe').keydown(function (e) {
        if (e.which == 13) {
            $('#txtChaveNFe').trigger('focusout');
        }
    });

    $('#txtChaveNFe').focusout(async function () {
        if ($(this).val() != '') {
            let codMun = '';
            let peso, valor = 0;

            const pesquisa = {
                tabela: 'NOTA',
                camposSelect: ['NOTA.PESOB', 'NOTA.VALOR', 'CADCEP.CODMUN', 'CIDADE.NOME'],
                leftJoin: [
                    { tabela: 'CADCEP', condicao: 'CADCEP.CEP = NOTA.CLI_CEP' },
                    { tabela: 'CIDADE', condicao: 'CADCEP.CODMUN = CIDADE.CODIGO' }
                ],
                where: [`NOTA.CHAVE_NFE = '${$(this).val()}'`]
            };
            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (jsonStr.length > 0) {
                codMun = `[${jsonStr[0].CODMUN}] - ${jsonStr[0].NOME}`;
                peso = jsonStr[0].PESOB;
                valor = jsonStr[0].VALOR;
            }

            adicionaNFeCTe('#tabelaNFe', $(this).val(), codMun, peso, valor);
            $(this).val('');
            $(this).focus();
            calculaTotais();
        }
    });

    $('#txtChaveCTe').focusout(function () {
        if ($(this).val() != '') {
            adicionaNFeCTe('#tabelaCTe', $(this).val());
            $(this).val('');
            $(this).focus();
            calculaTotais();
        }
    });

    $('#txtNumeroAverbacoes').focusout(function () {
        if ($(this).val() != '') {
            adicionaAverbacao($(this).val());
            $(this).val('');
            $(this).focus();
        }
    });

    $('#checkTodasEmpresas').on('change', function () {
        if ($('#checkTodasEmpresas')[0].checked == true) {
            carregaEmpresasDisponiveis();
        }
    });

    $('#checkCargaPosterior').on('change', function () {
        $('#txtTotValorCarga').prop('disabled', !isChecked(this));
        $('#txtTotPesoBruto').prop('disabled', !isChecked(this));
    });

    abasAtivas('input[name="radioTipoTransporte"]');

    function abasAtivas(componente) {
        if ($(componente).attr('id') === 'radioCargaPropria') {
            $('#tabCTe').addClass('d-none');
            $('#tabConheTransp').addClass('d-none');
            $('#tabNFe').removeClass('d-none');
            $('#tabNFMod1').removeClass('d-none');
            $('#tabNFe').trigger('click');
        } else if ($(componente).attr('id') === 'radioTransportadora') {
            $('#tabCTe').removeClass('d-none');
            $('#tabConheTransp').removeClass('d-none');
            $('#tabNFe').addClass('d-none');
            $('#tabNFMod1').addClass('d-none');
            $('#tabCTe').trigger('click');
        }
    }

    $('#tabelaNFe').on('click', '.btn-excluir', async function () {
        $('#tabelaNFe').DataTable().row($(this).parents('tr')).remove().draw(false);
        calculaTotais();
    });

    $('#tabelaCTe').on('click', '.btn-excluir', async function () {
        $('#tabelaCTe').DataTable().row($(this).parents('tr')).remove().draw(false);
        calculaTotais();
    });

    $('#tabelaNFMod1').on('click', '.btn-excluir', async function () {
        $('#tabelaNFMod1').DataTable().row($(this).parents('tr')).remove().draw(false);
        calculaTotais();
    });

    $('#tabelaConheTransp').on('click', '.btn-excluir', async function () {
        $('#tabelaConheTransp').DataTable().row($(this).parents('tr')).remove().draw(false);
        calculaTotais();
    });

    $('#tabelaAverbacoes').on('click', '.btn-excluir', async function () {
        $('#tabelaAverbacoes').DataTable().row($(this).parents('tr')).remove().draw(false);
        calculaTotais();
    });

    $('#btnConsultarDocumentos').on('click', async function () {
        await consultaDocumentos();
    });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "ObservacoesAba") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "Totais") {
                    if (!$("#multiCollapseExample4").hasClass("show")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                } else if (Element.node.id == "Itens") {
                    if (!$("#multiCollapseExample5").hasClass("show")) {
                        $("#multiCollapseExample5").collapse("show");
                    }

                    if ($('input[name="radioTipoTransporte"]').attr('id') === 'radioCargaPropria') {
                        $('#tabNFe').trigger('click');
                    } else {
                        $('#tabCTe').trigger('click');
                    }
                } else if (Element.node.id == "tabNFMod1") {
                    $('#tabNFMod1').trigger('click');
                } else if (Element.node.id == "tabSeguradora") {
                    $('#tabSeguradora').trigger('click');
                    $('#tabRespSeguro').trigger('click');
                } else if (Element.node.id == "tabAverbacoes") {
                    $('#tabAverbacoes').trigger('click');
                } else if (Element.node.id == "txtNumeroAverbacoes") {
                    $('#tabSeguradora').trigger('click');
                    $('#tabAverbacoes').trigger('click');
                } else if (Element.node.id == "tabProdPredo") {
                    $('#tabProdPredo').trigger('click');
                }
            },
            // onPrevious: (Element) => {
            //     if (
            //         Element.node.id == "documento-tab" ||
            //         Element.node.id == "documentoaba"
            //     ) {
            //         if (!$("#geral>a").hasClass("collapsed")) {
            //             $("#multiCollapseExample2").collapse("show");
            //         }
            //     } else if (Element.node.id == 'VoltarGeral') {
            //         $('#VoltarGeral').trigger('click');
            //     } else if (Element.node.id == "voltarItens") {
            //         $('#voltarItens').trigger('click');
            //     }
            // },
            // onNext: (Element) => {
            //     if ((Element.node.id == 'avancar1')) {
            //         if (pegaChave('#txtFornecedor') == '') {
            //             insereValor('#txtFornecedor', ' ', ' ')
            //         };

            //         $('#avancar1').trigger('click');
            //     } else if ((Element.node.id == 'avancarItens')) {
            //         if (($('#tabelaItensMaterial').DataTable().rows().count() == 0) &&
            //             ($('#tabelaItensProduto').DataTable().rows().count() == 0) &&
            //             ($('#tabelaItensServico').DataTable().rows().count() == 0)) {
            //             insereValor('#txtServico', ' ', ' ');
            //             insereValor('#txtQtdeServico', '1');
            //             insereValor('#txtPrecoServico', '1');
            //             $('#btnAdicionarServico').trigger('click');
            //         };
            //         $('#avancarItens').trigger('click');
            //     }

            // },
        });

        driver.defineSteps([{
            element: "#dadosGerais",
            popover: {
                title: "Dados Gerais",
                description: "Informe os dados gerais, os campos que contém (*) são obrigatórios.",
                position: "top",
            },
        },
        {
            element: "#ObservacoesAba",
            popover: {
                title: "Observações",
                description: "Aqui ficam as observações.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample3",
            popover: {
                title: "Observações",
                description: "Campos para informar as observações do MDF-e.",
                position: "bottom",
            },
        },
        {
            element: "#Totais",
            popover: {
                title: "Totalizadores",
                description: "Aqui ficam os totalizadores.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample4",
            popover: {
                title: "Totalizadores",
                description: "Esses são os totais do MDF-e.",
                position: "top",
            },
        },
        {
            element: "#Itens",
            popover: {
                title: "Documentos vinculados",
                description: "Clique aqui para informar os documentos vinculados.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample5",
            popover: {
                title: "Documentos vinculados",
                description: `Campos para informar os documentos vinculados. Obs: Abas podem ser diferentes conforme a opção "Tipo Transporte".`,
                position: "top",
            },
        },
        {
            element: "#tabNFe",
            popover: {
                title: "Aba NF-e",
                description: "Aba para informar NF-e.",
                position: "top",
            },
        },
        {
            element: "#txtChaveNFe",
            popover: {
                title: "Campo Chave",
                description: "Informar a chave de uma NF-e, na saída do campo irá adicionar um registro na tabela.",
                position: "top",
            },
        },
        {
            element: "#btnSelecionarNFe",
            popover: {
                title: "Botão Selecionar vários",
                description: `Clique neste botão para selecionar várias NF-e's.`,
                position: "top",
            },
        },
        {
            element: "#tabNFMod1",
            popover: {
                title: "Aba NF - Nota fiscal mod. 1/1A",
                description: "Aba para informar NF.",
                position: "top",
            },
        },
        {
            element: "#divNFMod1",
            popover: {
                title: "Campos NF",
                description: "Informar os campos e clicar no botão incluir.",
                position: "top",
            },
        },
        {
            element: "#tabSeguradora",
            popover: {
                title: "Aba Seguradora",
                description: "Aba para informar os dados da seguradora.",
                position: "top",
            },
        },
        {
            element: "#divSeguradora",
            popover: {
                title: "Dados da seguradora",
                description: "Esses são as abas/campos para informar os dados da seguradora.",
                position: "top",
            },
        },
        {
            element: "#tabAverbacoes",
            popover: {
                title: "Aba Averbações",
                description: "Aba para informar a averbação.",
                position: "top",
            },
        },
        {
            element: "#txtNumeroAverbacoes",
            popover: {
                title: "Campo Número",
                description: "Campo para informar o número da averbação. Na saída do campo irá adicionar a averbação na tabela.",
                position: "top",
            },
        },
        {
            element: "#tabProdPredo",
            popover: {
                title: "Aba Prod. Predominante",
                description: "Aba para informar os dados do Prod. Predominante.",
                position: "top",
            },
        },
        {
            element: "#divProdPredo",
            popover: {
                title: "Dados do Prod. Predominante",
                description: "Informar os campos referente o Prod. Predominante.",
                position: "top",
            },
        },
        {
            element: "#btnGravar",
            popover: {
                title: "Botão Gravar",
                description: "Ao clicar nesse botão você grava os dados inseridos.",
                position: "left",
            },
        },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });

    function mascaraValor() {
        $('.maskDecimais').maskMoney({
            decimal: ",",
            thousands: ".",
            precision: 2,
        });
    }

    function adicionaNFeCTe(tabela, chave, municipio = '', peso = 0, valor = 0, validaRegistro = false) {
        const idTabela = tabela.substring(1)
        const titulos = [
            { title: "Chave", data: "CHAVE" },
            { title: "Município", data: "MUNICIPIO" },
            { title: "Peso bruto (kg)", data: "PESOBRUTO" },
            { title: "Valor", data: "VALOR" },
            { title: "Ação", data: "ACAO" }
        ];
        const jsonObject = [];

        let qtdeRegistros = 0;
        if ($.fn.DataTable.isDataTable(tabela)) {
            if (validaRegistro) {
                const registros = $(tabela).DataTable().data().toArray();
                let contemRegistro = false;
                registros.forEach((item, index) => {
                    if (pegaValor(`#chave${idTabela}${index}`) == chave) {
                        contemRegistro = true;
                        return;
                    }
                });

                if (contemRegistro) {
                    return;
                }
            }
            qtdeRegistros = $(tabela).DataTable().rows().count();
            while ($(`#chave${idTabela}${qtdeRegistros}`).length > 0) {
                qtdeRegistros++;
            }

            $(tabela).DataTable().row.add({
                CHAVE: `<input type="text" class="input-default focus form-control classChave${idTabela}" id="chave${idTabela}${qtdeRegistros}" value="${chave}" style="width-min: 320px">`,
                MUNICIPIO: `<input type="text" class="input-default focus form-control classMunicipio${idTabela}" id="municipio${idTabela}${qtdeRegistros}" readonly value="${municipio}">`,
                PESOBRUTO: `<input type="text" class="input-default focus form-control maskDecimais totalizar classPesoBruto${idTabela}" id="pesoBruto${idTabela}${qtdeRegistros}" value="${peso.toFixed(2).replace('.', ',')}">`,
                VALOR: `<input type="text" class="input-default focus form-control maskDecimais totalizar classValor${idTabela}" id="valor${idTabela}${qtdeRegistros}" value="${valor.toFixed(2).replace('.', ',')}">`,
                ACAO: adicionaBotoes()
            }).draw(false);

            $(`#municipio${idTabela}${qtdeRegistros}`).pesquisa(
                `#municipio${idTabela}${qtdeRegistros}`,
                "CODIGO",
                "NOME",
                '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME"], "where": null}',
                "Pesquisa Cidade",
                "CIDADE"
            );

            $('.totalizar').off('focusout');
            $('.totalizar').focusout(() => {
                calculaTotais();
            })

            mascaraValor();
            return;
        }

        jsonObject.push({
            CHAVE: `<input type="text" class="input-default focus form-control classChave${idTabela}" id="chave${idTabela}${qtdeRegistros}" value="${chave}" style="width-min: 320px">`,
            MUNICIPIO: `<input type="text" class="input-default focus form-control classMunicipio${idTabela}" id="municipio${idTabela}${qtdeRegistros}" readonly value="${municipio}">`,
            PESOBRUTO: `<input type="text" class="input-default focus form-control maskDecimais totalizar classPesoBruto${idTabela}" id="pesoBruto${idTabela}${qtdeRegistros}" value="${peso.toFixed(2).replace('.', ',')}">`,
            VALOR: `<input type="text" class="input-default focus form-control maskDecimais totalizar classValor${idTabela}" id="valor${idTabela}${qtdeRegistros}" value="${valor.toFixed(2).replace('.', ',')}">`,
            ACAO: adicionaBotoes()
        });

        $(tabela).DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            autoWidth: true,
            columns: titulos,
            data: jsonObject
        });

        mascaraValor();
        $(`#municipio${idTabela}${qtdeRegistros}`).pesquisa(
            `#municipio${idTabela}${qtdeRegistros}`,
            "CODIGO",
            "NOME",
            '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME"], "where": null}',
            "Pesquisa Cidade",
            "CIDADE"
        );

        $('.totalizar').off('focusout');
        $('.totalizar').focusout(() => {
            calculaTotais();
        })
    }

    function adicionaNFMod1(municipio, nota, serie, cnpj, UFDestino, dtEmissao, pesoB, valor) {
        if (!validaCamposNFMod1()) {
            return;
        }
        const titulos = [
            { title: "Município", data: "MUNICIPIO" },
            { title: "Nota", data: "NOTA" },
            { title: "Série", data: "SERIE" },
            { title: "CNPJ - Emitente", data: "CNPJ" },
            { title: "UF Destino", data: "UF_DESTINO" },
            { title: "Data emissão", data: "DT_EMISSAO" },
            { title: "Peso bruto (kg)", data: "PESOBRUTO" },
            { title: "Valor", data: "VALOR" },
            { title: "Ação", data: "ACAO" }
        ];
        const jsonObject = [];

        if ($.fn.DataTable.isDataTable('#tabelaNFMod1')) {

            $('#tabelaNFMod1').DataTable().row.add({
                MUNICIPIO: municipio,
                NOTA: nota,
                SERIE: serie,
                CNPJ: cnpj,
                UF_DESTINO: UFDestino,
                DT_EMISSAO: dtEmissao,
                PESOBRUTO: pesoB.replace('.', '').replace(',', '.'),
                VALOR: valor.replace('.', '').replace(',', '.'),
                ACAO: adicionaBotoes()
            }).draw(false);

            limpaCamposNFMod1();
            calculaTotais();
            return;
        }

        jsonObject.push({
            MUNICIPIO: municipio,
            NOTA: nota,
            SERIE: serie,
            CNPJ: cnpj,
            UF_DESTINO: UFDestino,
            DT_EMISSAO: dtEmissao,
            PESOBRUTO: pesoB.replace('.', '').replace(',', '.'),
            VALOR: valor.replace('.', '').replace(',', '.'),
            ACAO: adicionaBotoes()
        });


        $("#tabelaNFMod1").DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            autoWidth: true,
            columnDefs: [
                {
                    "type": 'date-br',
                    "targets": 5,
                    "render": function (data) {
                        if (data != undefined) {
                            x = data.slice(0, 10).split('-');
                            return `${x[2]}/${x[1]}/${x[0]}`;
                        } else {
                            return ''
                        }
                    }
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-BR", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    targets: [6, 7],
                    "className": 'pr-4 text-right'
                }
            ],
            columns: titulos,
            data: jsonObject
        });
        limpaCamposNFMod1();
        calculaTotais();
    }

    function adicionaCT(municipio, nota, serie, subSerie, dtEmissao, pesoB, valor) {
        if (!validaCamposCT()) {
            return;
        }
        const titulos = [
            { title: "Município", data: "MUNICIPIO" },
            { title: "Nota", data: "NOTA" },
            { title: "Série", data: "SERIE" },
            { title: "Sub-série", data: "SUBSERIE" },
            { title: "Data emissão", data: "DT_EMISSAO" },
            { title: "Peso bruto (kg)", data: "PESOBRUTO" },
            { title: "Valor", data: "VALOR" },
            { title: "Ação", data: "ACAO" }
        ];
        const jsonObject = [];

        if ($.fn.DataTable.isDataTable('#tabelaConheTransp')) {

            $('#tabelaConheTransp').DataTable().row.add({
                MUNICIPIO: municipio,
                NOTA: nota,
                SERIE: serie,
                SUBSERIE: subSerie,
                DT_EMISSAO: dtEmissao,
                PESOBRUTO: pesoB.replace('.', '').replace(',', '.'),
                VALOR: valor.replace('.', '').replace(',', '.'),
                ACAO: adicionaBotoes()
            }).draw(false);

            limpaCamposCT();
            calculaTotais();
            return;
        }

        jsonObject.push({
            MUNICIPIO: municipio,
            NOTA: nota,
            SERIE: serie,
            SUBSERIE: subSerie,
            DT_EMISSAO: dtEmissao,
            PESOBRUTO: pesoB.replace('.', '').replace(',', '.'),
            VALOR: valor.replace('.', '').replace(',', '.'),
            ACAO: adicionaBotoes()
        });


        $("#tabelaConheTransp").DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            autoWidth: true,
            "columnDefs": [{
                "type": 'date-br',
                "targets": 4,
                "render": function (data) {
                    if (data != undefined) {
                        x = data.slice(0, 10).split('-');
                        return `${x[2]}/${x[1]}/${x[0]}`;
                    } else {
                        return ''
                    }
                }
            },
            {
                render(data) {
                    return parseFloat(data).toLocaleString("pt-BR", {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 2
                    });
                },
                targets: [5, 6],
                "className": 'pr-4 text-right'
            }],
            columns: titulos,
            data: jsonObject
        });
        limpaCamposCT();
        calculaTotais();
    }

    function adicionaAverbacao(numero) {
        const titulos = [
            { title: "Averbação", data: "AVERBACAO" },
            { title: "Ação", data: "ACAO" }
        ];
        const jsonObject = [];

        if ($.fn.DataTable.isDataTable('#tabelaAverbacoes')) {

            $('#tabelaAverbacoes').DataTable().row.add({
                AVERBACAO: numero,
                ACAO: adicionaBotoes()
            }).draw(false);

            return;
        }

        jsonObject.push({
            AVERBACAO: numero,
            ACAO: adicionaBotoes()
        });


        $("#tabelaAverbacoes").DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            scrollX: true,
            serverside: false,
            order: false,
            autoWidth: true,
            columns: titulos,
            data: jsonObject
        });
    }

    function validaCamposNFMod1() {
        let validator = $("#msform").validate();
        let liberado = true;

        validator.element("#txtMunicipioNFMod1");
        validator.element("#txtNotaNFMod1");
        validator.element("#txtSerieNFMod1");
        validator.element("#txtCNPJNFMod1");
        validator.element("#txtUFDestinoNFMod1");
        validator.element("#txtDataEmissaoNFMod1");
        validator.element("#txtPesoBrutoNFMod1");
        validator.element("#txtValorNFMod1");

        if (!(validator.element("#txtMunicipioNFMod1") && validator.element("#txtNotaNFMod1") && validator.element("#txtSerieNFMod1") && validator.element("#txtCNPJNFMod1")
            && validator.element("#txtUFDestinoNFMod1") && validator.element("#txtDataEmissaoNFMod1") && validator.element("#txtPesoBrutoNFMod1") && validator.element("#txtValorNFMod1"))) {
            liberado = false;
        }


        if (!liberado) {
            msgAlerta('Necessário informar os campos obrigatórios!');
            return false;
        } else {
            return true;
        }
    }

    function validaCamposCT() {
        let validator = $("#msform").validate();
        let liberado = true;

        validator.element("#txtMunicipioConheTransp");
        validator.element("#txtNotaConheTransp");
        validator.element("#txtSerieConheTransp");
        validator.element("#txtSubSerieConheTransp");
        validator.element("#txtDataEmissaoConheTransp");
        validator.element("#txtPesoBrutoConheTransp");
        validator.element("#txtValorConheTransp");

        if (!(validator.element("#txtMunicipioConheTransp") && validator.element("#txtNotaConheTransp") && validator.element("#txtSerieConheTransp")
            && validator.element("#txtSubSerieConheTransp") && validator.element("#txtDataEmissaoConheTransp") && validator.element("#txtPesoBrutoConheTransp")
            && validator.element("#txtValorConheTransp"))) {
            liberado = false;
        }


        if (!liberado) {
            msgAlerta('Necessário informar os campos obrigatórios!');
            return false;
        } else {
            return true;
        }
    }

    function limpaCamposNFMod1() {
        $('#txtMunicipioNFMod1').val('');
        $('#txtNotaNFMod1').val('');
        $('#txtSerieNFMod1').val('');
        $('#txtCNPJNFMod1').val('');
        $('#txtUFDestinoNFMod1').val('');
        $('#txtDataEmissaoNFMod1').val('');
        $('#txtPesoBrutoNFMod1').val('');
        $('#txtValorNFMod1').val('');
        $('#txtMunicipioNFMod1').focus();
    }

    function limpaCamposCT() {
        $('#txtMunicipioConheTransp').val('');
        $('#txtNotaConheTransp').val('');
        $('#txtSerieConheTransp').val('');
        $('#txtSubSerieConheTransp').val('');
        $('#txtDataEmissaoConheTransp').val('');
        $('#txtPesoBrutoConheTransp').val('');
        $('#txtValorConheTransp').val('');
        $('#txtMunicipioConheTransp').focus();
    }

    function adicionaBotoes() {
        return '<div class="divBtnOpcoes"> ' +
            '       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '     </div>';
    };

    function botaoSelecionarGrid() {
        return (
            '<div class="form-check">' +
            '<input type="checkbox" class="align-self-center checkDocumento" value"" checked>' +
            '</div>'
        );
    };

    async function gravaMDFe() {
        $.LoadingOverlay('show');
        try {
            if (! await validaCamposMDFe()) {
                return;
            }

            const reboques = $('#txtReboque').val().toString().split(',');
            const Nota_MDFe = {
                IMPRESSO: 'N',
                DT_EMISSAO: pegaValor('#txtDtEmissao'),
                VEICULO: pegaChave('#txtVeiculo'),
                REBOQUE: ((reboques.length == 1) && reboques[0] != '') ? reboques[0] : '',
                MOTORISTA: pegaChave('#txtMotorista'),
                TIPO: isChecked('#radioCargaPropria') ? 0 : 1,
                RNTC: pegaValor('#txtRNTRC'),
                CIOT: pegaValor('#txtCIOT'),
                VALOR_CARGA: parseFloat($('#txtTotValorCarga').val().replace('.', '').replace(',', '.')),
                PESO_BRUTO: parseFloat($('#txtTotPesoBruto').val().replace('.', '').replace(',', '.')),
                INF_FISCO: pegaValor('#txtObsFisco'),
                INF_CONTRIBUINTE: pegaValor('#txtObsContribuinte'),
                UF_CARG: pegaChave('#txtUFCarregamento'),
                UF_DESCARG: pegaChave('#txtUFDescarregamento'),
                TIPO_RESP_SEG: pegaValor('#rgTipoRespSeguro'),
                CNPJ_RESP_SEG: pegaValor('#txtCNPJRespSeguro'),
                CPF_RESP_SEG: pegaValor('#txtCPFRespSeguro'),
                NOME_SEG: pegaValor('#txtNomeInfSeguradora'),
                CNPJ_SEG: pegaValor('#txtCNPJInfSeguradora'),
                APOLICE_SEG: pegaValor('#txtApoliceInfSeguradora'),
                TPTRANSP: isChecked('#radioNenhum') ? 0 : isChecked('#radioECT') ? 1 : isChecked('#radioTAC') ? 2 : 3,
                EMP_ID: getCookie('emp_id'),
                CARGA_POSTERIOR: isChecked('#checkCargaPosterior') ? 'S' : 'N',
                TP_CARGA: pegaValor('#rgTipoCargaProdPredo'),
                DESC_PRODPRED: pegaValor('#txtDescProdPredomiProdPredo'),
                CEP_CARREGA: pegaChave('#txtCEPCarregamentoProdPredo'),
                LATITUDE_CARREGA: pegaValor('#txtLatitudeCarregamentoProdPredo'),
                LONGITUDE_CARREGA: pegaValor('#txtLongitudeCarregamentoProdPredo'),
                CEP_DESCARREGA: pegaChave('#txtCEPDescarregamentoProdPredo'),
                LATITUDE_DESCARREGA: pegaValor('#txtLatitudeDescarregamentoProdPredo'),
                LONGITUDE_DESCARREGA: pegaValor('#txtLongitudeDescarregamentoProdPredo'),
                FEZ_IMPRESSAO: 'N',
                REBOQUES: retornaReboques(),
                NOTAITEN: retornaNotaIten(),
                NOTA_MUN: retornaNotaMun(),
                NOTA_MOT: retornaNotaMot(),
                NOTA_UF: retornaNotaUF(),
                NOTA_AVERB: retornaNotaAverb()
            };

            const response = await requisicao('POST', '/sisplan/mdfe/v1/mdfe?', '', `JSON=${encodeURIComponent(JSON.stringify(Nota_MDFe))}`, 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay('hide');
                msgAlerta(jsonStr.mensagem);
                return;
            }

            criaMensagemSucesso(`MDF-e ${jsonStr.numero} gravada com sucesso! Você está sendo redirecionado para página de impressão.`, async () => { await telaImpressao(); });
        } catch (error) {
            console.error(error);
            msgAlerta(`Não foi possível gravar os dados da MDF-e: ${error}`);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function validaCamposMDFe() {
        let validator = $("#msform").validate();
        let liberado = true;

        validator.element("#txtVeiculo");
        validator.element("#txtMotorista");
        validator.element("#txtUFCarregamento");
        validator.element("#txtUFDescarregamento");

        if (!(validator.element("#txtVeiculo") && validator.element("#txtMotorista") && validator.element("#txtUFCarregamento") && validator.element("#txtUFDescarregamento"))) {
            liberado = false;
        }

        if (pegaValor('#txtCNPJRespSeguro') == '') {
            msgAlerta('CNPJ do responsável pelo seguro não informado, favor verificar. Documentos vinculados > Seguradora > Responsável pelo seguro > CNPJ.')
            return false;
        }

        if (!liberado) {
            msgAlerta('Necessário informar os campos obrigatórios!');
            return false;
        } else {
            const listaMotorista = $('#txtMotoristaVeiculo').val().toString().split(',');
            if (listaMotorista.includes(pegaChave('#txtMotorista'))) {
                msgAlerta('Motorista foi informado também na lista de demais motoristas. Impossível continuar.');
                return false;
            }

            const listaMunicipio = $('#txtMunicipiosCarregamento').val().toString();
            if (listaMunicipio == '') {
                msgAlerta('Necessário informar um município de carregamento. Impossível continuar.');
                return false;
            }

            if (isChecked('#checkCargaPosterior')) {
                if (isChecked('#radioTransportadora')) {
                    msgAlerta(`Opção de carga posterior marcado e tipo de transporte diferente de "Transporte Carga Própria". Impossível continuar.`);
                    return false;
                }

                if (pegaChave('#txtUFCarregamento') != pegaChave('#txtUFDescarregamento')) {
                    msgAlerta(`Opção de carga posterior marcado. Opção somente é permitido para operações internas, ou seja inicio e fim do carregamento deve ser de mesma UF. Impossível continuar.`);
                    return false;
                }

                if (contemRegistroTabela('#tabelaNFe')) {
                    msgAlerta(`Opção de carga posterior marcado. Não deve conter documento NF-e vinculado. Impossível continuar.`);
                    return false;
                }

                if (contemRegistroTabela('#tabelaNFMod1')) {
                    msgAlerta(`Opção de carga posterior marcado. Não deve conter documento NF vinculado. Impossível continuar.`);
                    return false;
                }

                if (contemRegistroTabela('#tabelaCTe')) {
                    msgAlerta(`Opção de carga posterior marcado. Não deve conter documento CT-e vinculado. Impossível continuar.`);
                    return false;
                }

                if (contemRegistroTabela('#tabelaConheTransp')) {
                    msgAlerta(`Opção de carga posterior marcado. Não deve conter documento CT vinculado. Impossível continuar.`);
                    return false;
                }
            }

            if (!isChecked('#checkCargaPosterior')) {
                $('#txtTotValorCarga').val('0,00');
                $('#txtTotPesoBruto').val('0,00');
                calculaTotais();
            }

            if ($.fn.DataTable.isDataTable('#tabelaNFe')) {
                const registros = $('#tabelaNFe').DataTable().data().toArray();
                let bloqueio = false;
                registros.forEach((item, index) => {
                    const chave = pegaValor(`.classChavetabelaNFe:eq(${index})`);
                    if (pegaChave(`.classMunicipiotabelaNFe:eq(${index})`) == '') {
                        $('#tabNFe').trigger('click');
                        msgAlerta('Necessário informar o município da NF-e! Impossível continuar.');
                        $(`.classMunicipiotabelaNFe:eq(${index})`).trigger('click');
                        bloqueio = true;
                        return;
                    } else if ((chave.length < 44) || (modulo11(chave.substring(0, 43)) != chave.charAt(43))) {
                        $('#tabNFe').trigger('click');
                        msgErro('Chave da NF-e inválida! Impossível continuar.');
                        $(`.classChavetabelaNFe:eq(${index})`).focus();
                        bloqueio = true;
                        return;
                    } else if (pegaValor(`.classValortabelaNFe:eq(${index})`) <= 0) {
                        msgAlerta('Necessário informar o Valor da NF-e! Impossível continuar.');
                        $(`.classValortabelaNFe:eq(${index})`).focus();
                        bloqueio = true;
                        return;
                    } else if (pegaValor(`.classPesoBrutotabelaNFe:eq(${index})`) <= 0) {
                        msgAlerta('Necessário informar o Peso da NF-e! Impossível continuar.');
                        $(`.classPesoBrutotabelaNFe:eq(${index})`).focus();
                        bloqueio = true;
                        return;
                    }
                });

                if (bloqueio) {
                    return false;
                }
            }

            if ($.fn.DataTable.isDataTable('#tabelaCTe')) {
                const registros = $('#tabelaCTe').DataTable().data().toArray();
                const chaves = [];
                let bloqueio = false;
                for (const [index, item] of registros.entries()) {
                    const chave = pegaValor(`.classChavetabelaCTe:eq(${index})`);
                    if (pegaChave(`.classMunicipiotabelaCTe:eq(${index})`) == '') {
                        $('#tabCTe').trigger('click');
                        msgAlerta('Necessário informar o município da CT-e! Impossível continuar.', () => { $(`.classMunicipiotabelaCTe:eq(${index})`).trigger('click') });
                        bloqueio = true;
                        return;
                    } else if ((chave.length < 44) || (modulo11(chave.substring(0, 43)) != chave.charAt(43))) {
                        $('#tabCTe').trigger('click');
                        msgAlerta('Chave da CT-e inválida! Impossível continuar.', () => { $(`.classChavetabelaCTe:eq(${index})`).focus() });
                        bloqueio = true;
                        return;
                    } else if (pegaValor(`.classValortabelaCTe:eq(${index})`) <= 0) {
                        msgAlerta('Necessário informar o Valor da CT-e! Impossível continuar.', () => { $(`.classValortabelaCTe:eq(${index})`).focus() });
                        bloqueio = true;
                        return;
                    } else if (pegaValor(`.classPesoBrutotabelaCTe:eq(${index})`) <= 0) {
                        msgAlerta('Necessário informar o Peso da CT-e! Impossível continuar.', () => { $(`.classPesoBrutotabelaCTe:eq(${index})`).focus() });
                        bloqueio = true;
                        return;
                    } else if ((chave != '') || (await buscaValor('NOTA_CTE', 'NUM_AVERBACAO', 'CHAVE_CTE', chave) == '')) {
                        chaves.push(chave);
                    }
                };

                if (chaves.length > 0) {
                    await msgAguardaConfirmacao(`CT-e não possui averbação. Chave(s) CT-e: ${chaves.join(', ')} . Deseja Continuar ?`, () => { bloqueio = false }, () => { bloqueio = true });
                }

                if (bloqueio) {
                    return false;
                }
            }

            if (parseFloat(pegaValor('#txtCapacKG').replace('.', '').replace(',', '.')) > 0) {
                const capacidade = parseFloat(pegaValor('#txtCapacKG').replace('.', '').replace(',', '.'));
                const peso = parseFloat(pegaValor('#txtTotPesoBruto').replace('.', '').replace(',', '.'));
                let bloqueio = false;

                if (peso > capacidade) {
                    await msgAguardaConfirmacao(`Peso bruto da carga excede a capacidade do veículo em ${peso - capacidade} Kg. Deseja continuar?`, () => { bloqueio = false }, () => { bloqueio = true });
                }

                if (bloqueio) {
                    return false;
                }
            }

            return true;
        }
    }

    async function consultaDocumentos() {
        $.LoadingOverlay("show");
        try {
            if ($.fn.DataTable.isDataTable('#tabelaDocumentos')) {
                $('#tabelaDocumentos').DataTable().destroy();
                $('#tabelaDocumentos').empty();
            }
            const url = '/sisplan/mdfe/v1/consultadocumentos?';
            const filtros = await retornaFiltros();
            const response = await requisicao('GET', url, filtros, null, 50000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgErro(jsonStr.mensagem)
                return;
            }

            jsonStr.forEach(function (item) {
                item.SEL = botaoSelecionarGrid();
            });

            if (jsonStr.length == 0) {
                msgAlerta('Nenhum registro encontrado!');
                return;
            }

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            }

            const colunasItens = [
                { title: 'Sel', data: 'SEL' },
                { title: 'Emp', data: 'EMP' },
                { title: 'Tipo dados', data: 'TIPO_DADOS' },
                { title: 'Tipo', data: 'TIPO' },
                { title: 'Tipo natureza', data: 'TP_NATUREZA' },
                { title: 'Chave', data: 'CHAVE' },
                { title: 'Fatura', data: 'FATURA' },
                { title: 'Série', data: 'SERIE' },
                { title: 'Dt. Emissão', data: 'DT_EMISSAO' },
                { title: 'CodCli', data: 'CODCLI' },
                { title: 'Nome', data: 'NOME' },
                { title: 'CNPJ', data: 'CNPJ' },
                { title: 'Valor', data: 'VALOR' },
                { title: 'Peso', data: 'PESO' },
                { title: 'Existe MDF-e', data: 'EXISTE_MDFE' },
                { title: 'Município', data: 'CODMUN' },
                { title: 'Desc. município', data: 'DESCMUN' }
            ]

            $('#tabelaDocumentos').DataTable({
                search: false,
                filter: false,
                order: [],
                sort: true,
                destroy: true,
                paging: false,

                "autoWidth": true,
                "data": jsonStr,
                "columns": colunasItens,
                autoWidth: true,
                "colReorder": true,
                "columnDefs": [{
                    "type": 'date-br',
                    "targets": 8,
                    "render": function (data) {
                        if (data != undefined) {
                            x = data.slice(0, 10).split('-');
                            return `${x[2]}/${x[1]}/${x[0]}`;
                        } else {
                            return ''
                        }
                    }
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-BR", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    targets: [12],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [13],
                    "className": 'pr-4 text-right'
                }]
            });
            addSelected();
            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function retornaFiltros() {
        const dtEmissaoDe = $('#txtDataEmiDe').val();
        const dtEmissaoAte = $('#txtDataEmiAte').val();
        const dtEntradaDe = $('#txtDataEntradaSaidaDe').val();
        const dtEntradaAte = $('#txtDataEntradaSaidaAte').val();
        const transportadora = await formataListas($('#txtTransportadora').val().toString());
        const grupoCli = await formataListas($('#txtGrupoCli').val().toString());
        const placa = await formataListas($('#txtPlaca').val().toString());
        const numeroCarga = pegaChave('#txtNumCargaConsulta');
        const fatura = pegaValor('#txtFaturaConsulta');
        const tipoDados = isChecked('#radioTipoDadosNFe') ? 0 : isChecked('#radioTipoDadosCTe') ? 1 : 2;
        const existeMDFe = isChecked('#radioExiteMDFeTodos') ? 0 : isChecked('#radioExiteMDFeSim') ? 1 : 2;
        const tipoNota = isChecked('#radioTipoNotaTodas') ? 0 : isChecked('#radioTipoNotaEntrada') ? 1 : 2;
        const tipoNatureza = isChecked('#radioTipoNaturezaTodas') ? 0 : isChecked('#radioTipoNaturezaEntrada') ? 1 : 2;
        const empID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];
        const retorno = `DATA_EMI_DE=${dtEmissaoDe}` +
            `&DATA_EMI_ATE=${dtEmissaoAte}` +
            `&DATA_ENTRADA_DE=${dtEntradaDe}` +
            `&DATA_ENTRADA_ATE=${dtEntradaAte}` +
            `&TRANSPORTADORA=${transportadora}` +
            `&GRUPO_CLI=${grupoCli}` +
            `&PLACA=${placa}` +
            `&NUMERO_CARGA=${numeroCarga}` +
            `&FATURA=${fatura}` +
            `&TIPO_DADOS=${tipoDados}` +
            `&EXISTE_MDFE=${existeMDFe}` +
            `&TIPO_NOTA=${tipoNota}` +
            `&TIPO_NATUREZA=${tipoNatureza}` +
            `&EMP_ID=${empID}`;

        return retorno;
    }

    function importarDocumentos() {
        $.LoadingOverlay("show");
        try {
            if (!$.fn.DataTable.isDataTable("#tabelaDocumentos")) {
                msgAlerta('Necessário consultar/selecionar um registro.');
                return;
            }

            const dados = $("#tabelaDocumentos").DataTable().rows(".selected").data().toArray();
            if (dados.length == 0) {
                msgAlerta('Nenhum registro selecionado.');
                return;
            }

            dados.forEach((item) => {
                if (item.TIPO_DADOS == 'NFE') {
                    adicionaNFeCTe('#tabelaNFe', item.CHAVE, `[${item.CODMUN}] - ${item.DESCMUN}`, item.PESO, item.VALOR, true);
                } else if (item.TIPO_DADOS == 'RADAR') {
                    adicionaNFeCTe('#tabelaNFe', item.CHAVE, '', item.PESO, item.VALOR, true);
                } else {
                    adicionaNFeCTe('#tabelaCTe', item.CHAVE, '', item.PESO, item.VALOR, true);
                }
            });
            calculaTotais();
            $('#modal-Selecionar').modal('hide');
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function addSelected(add = true) {
        for (let i = 0; i < $('#tabelaDocumentos').DataTable().rows().data().length; i++) {
            if (add) {
                $($("table#tabelaDocumentos tr")[i + 1]).addClass("selected");
            } else {
                $($("table#tabelaDocumentos tr")[i + 1]).removeClass("selected");
            }
        }
    };

    function contemRegistroTabela(tabela) {
        if ($.fn.DataTable.isDataTable(tabela)) {
            const qtdeRegistros = $(tabela).DataTable().rows().count();
            return qtdeRegistros > 0;
        }
    }

    function retornaReboques() {
        const reboques = $('#txtReboque').val().toString().split(',');
        const arrayObj = [];
        for (const reboque of reboques) {
            if (reboque) {
                arrayObj.push({
                    EMP_ID: getCookie('emp_id'),
                    REBOQUE: reboque
                })
            }
        }

        return arrayObj;
    }

    function retornaNotaMun() {
        const cidades = $('#txtMunicipiosCarregamento').val().toString().split(',');
        const arrayObj = [];
        for (const cidade of cidades) {
            if (cidade) {
                arrayObj.push({
                    TIPO: 'C',
                    CIDADE: cidade,
                    EMP_ID: getCookie('emp_id')
                })
            }
        }

        return arrayObj;
    }

    function retornaNotaMot() {
        const motoristas = $('#txtMotoristaVeiculo').val().toString().split(',');
        const arrayObj = [];
        for (const motorista of motoristas) {
            if (motorista) {
                arrayObj.push({
                    MOTORISTA: motorista,
                    EMP_ID: getCookie('emp_id')
                })
            }
        }

        return arrayObj;
    }

    function retornaNotaUF() {
        const UFs = $('#txtUFPercurso').val().toString().split(',');
        const arrayObj = [];
        for (const UF of UFs) {
            if (UF) {
                arrayObj.push({
                    UF: UF,
                    EMP_ID: getCookie('emp_id')
                })
            }
        }

        return arrayObj;
    }

    function retornaNotaIten() {
        const arrayObj = [];
        const nfe = retornaNotaItenNFe();
        const nf = retornaNotaItenNF();
        const cte = retornaNotaItenCTe();
        const ct = retornaNotaItenCT();

        arrayObj.push(...nfe, ...cte, ...nf, ...ct);

        return arrayObj;
    }

    function retornaNotaAverb() {
        const arrayObj = [];
        if ($.fn.DataTable.isDataTable('#tabelaAverbacoes')) {
            const registros = $('#tabelaAverbacoes').DataTable().data().toArray();
            registros.forEach((item) => {
                arrayObj.push({
                    AVERBACAO: item.AVERBACAO,
                    EMP_ID: getCookie('emp_id')
                });
            });
        }

        return arrayObj;
    }

    function retornaNotaItenNFe() {
        const arrayObj = [];
        if (($.fn.DataTable.isDataTable('#tabelaNFe')) && (!isChecked('#radioTransportadora'))) {
            const registros = $('#tabelaNFe').DataTable().data().toArray();
            registros.forEach((item, index) => {
                arrayObj.push({
                    TIPO: 'N',
                    CIDADE: pegaChave(`.classMunicipiotabelaNFe:eq(${index})`),
                    VALOR: parseFloat($(`.classValortabelaNFe:eq(${index})`).val().replace('.', '').replace(',', '.')),
                    PESO_BRUTO: parseFloat($(`.classPesoBrutotabelaNFe:eq(${index})`).val().replace('.', '').replace(',', '.')),
                    CHAVE_NFE: pegaValor(`.classChavetabelaNFe:eq(${index})`),
                    EMP_ID: getCookie('emp_id')
                });
            });
        }

        return arrayObj;
    }

    function retornaNotaItenCTe() {
        const arrayObj = [];
        if (($.fn.DataTable.isDataTable('#tabelaCTe')) && (isChecked('#radioTransportadora'))) {
            const registros = $('#tabelaCTe').DataTable().data().toArray();
            registros.forEach((item, index) => {
                arrayObj.push({
                    TIPO: 'C',
                    CIDADE: pegaChave(`.classMunicipiotabelaCTe:eq(${index})`),
                    VALOR: parseFloat($(`.classValortabelaCTe:eq(${index})`).val().replace('.', '').replace(',', '.')),
                    PESO_BRUTO: parseFloat($(`.classPesoBrutotabelaCTe:eq(${index})`).val().replace('.', '').replace(',', '.')),
                    CHAVE_CTE: pegaValor(`.classChavetabelaCTe:eq(${index})`),
                    EMP_ID: getCookie('emp_id')
                });
            });
        }

        return arrayObj;
    }

    function retornaNotaItenNF() {
        const arrayObj = [];
        if (($.fn.DataTable.isDataTable('#tabelaNFMod1')) && (!isChecked('#radioTransportadora'))) {
            const registros = $('#tabelaNFMod1').DataTable().data().toArray();
            registros.forEach((item, index) => {
                arrayObj.push({
                    TIPO: 'F',
                    CIDADE: item.MUNICIPIO.substring(1, item.MUNICIPIO.indexOf("]")),
                    NUM_NF: item.NOTA,
                    SERIE_NF: item.SERIE,
                    CNPJ: item.CNPJ,
                    UF_DESTINO: item.UF_DESTINO,
                    DT_EMISSAO: item.DT_EMISSAO,
                    PESO_BRUTO: parseFloat(item.PESOBRUTO),
                    VALOR: parseFloat(item.VALOR),
                    EMP_ID: getCookie('emp_id')
                });
            });
        }

        return arrayObj;
    }

    function retornaNotaItenCT() {
        const arrayObj = [];
        if (($.fn.DataTable.isDataTable('#tabelaConheTransp')) && (isChecked('#radioTransportadora'))) {
            const registros = $('#tabelaConheTransp').DataTable().data().toArray();
            registros.forEach((item, index) => {
                arrayObj.push({
                    TIPO: 'T',
                    CIDADE: item.MUNICIPIO.substring(1, item.MUNICIPIO.indexOf("]")),
                    NUM_NF: item.NOTA,
                    SERIE_NF: item.SERIE,
                    SUB_SERIE: item.SUBSERIE,
                    DT_EMISSAO: item.DT_EMISSAO,
                    PESO_BRUTO: parseFloat(item.PESOBRUTO),
                    VALOR: parseFloat(item.VALOR),
                    EMP_ID: getCookie('emp_id')
                });
            });
        }
        return arrayObj;
    }

    function calculaTotais() {
        let valorNFe = 0;
        let pesoNFe = 0;
        let valorNF = 0;
        let pesoNF = 0;
        let valorCTe = 0;
        let pesoCTe = 0;
        let valorCT = 0;
        let pesoCT = 0;

        if ($.fn.DataTable.isDataTable('#tabelaNFe')) {
            const registros = $('#tabelaNFe').DataTable().data().toArray();
            registros.forEach((item, index) => {
                valorNFe += $(`.classValortabelaNFe:eq(${index})`).val() != '' ? parseFloat($(`.classValortabelaNFe:eq(${index})`).val().replace('.', '').replace(',', '.')) : 0;
                pesoNFe += $(`.classPesoBrutotabelaNFe:eq(${index})`).val() != '' ? parseFloat($(`.classPesoBrutotabelaNFe:eq(${index})`).val().replace('.', '').replace(',', '.')) : 0;
            });
        }

        if ($.fn.DataTable.isDataTable('#tabelaNFMod1')) {
            const registros = $('#tabelaNFMod1').DataTable().data().toArray();
            registros.forEach((item) => {
                valorNF += parseFloat(item.VALOR);
                pesoNF += parseFloat(item.PESOBRUTO);
            });
        }

        if ($.fn.DataTable.isDataTable('#tabelaCTe')) {
            const registros = $('#tabelaCTe').DataTable().data().toArray();
            registros.forEach((item, index) => {
                valorCTe += $(`.classValortabelaCTe:eq(${index})`).val() != '' ? parseFloat($(`.classValortabelaCTe:eq(${index})`).val().replace('.', '').replace(',', '.')) : 0;
                pesoCTe += $(`.classPesoBrutotabelaCTe:eq(${index})`).val() != '' ? parseFloat($(`.classPesoBrutotabelaCTe:eq(${index})`).val().replace('.', '').replace(',', '.')) : 0;
            });
        }

        if ($.fn.DataTable.isDataTable('#tabelaConheTransp')) {
            const registros = $('#tabelaConheTransp').DataTable().data().toArray();
            registros.forEach((item) => {
                valorCT += parseFloat(item.VALOR);
                pesoCT += parseFloat(item.PESOBRUTO);
            });
        }

        $('#txtTotValorCarga').val((valorNFe + valorNF + valorCTe + valorCT).toFixed(2).replace('.', ','));
        $('#txtTotPesoBruto').val((pesoNFe + pesoNF + pesoCTe + pesoCT).toFixed(2).replace('.', ','));
    }

    async function telaImpressao() {
        const abaAtiva = parent.document.querySelector('#listaAbas li.active');
        const telasAbertasStorage = sessionStorage.getItem('@telasAbertas') ? JSON.parse(sessionStorage.getItem('@telasAbertas')) : [];
        const telaJaEstaAberta = telasAbertasStorage.filter(tela => tela.link == `${BASE_URI}/imprimir_mdfe`).length > 0;
        if ((abaAtiva.length !== 0) && (!telaJaEstaAberta)) {
            parent.document.querySelector('#menu_imprimir_mdfe .nav-link').click();
            abaAtiva.children[0].click();
        }

        parent.document.querySelector('#menu_imprimir_mdfe .nav-link').click();
        var iframe = parent.document.querySelector('#panel--sisplan_web-mdfe-create iframe');
        var src = iframe.getAttribute("src");
        iframe.setAttribute("src", src);

        // parent.abirAbaIframe('Impressão MDF-e', `${BASE_URI}/imprimir_mdfe`);
    }
});