function validaGravar() {
    if (($('#tabelaItensMaterial').DataTable().rows().count() == 0) &&
        ($('#tabelaItensProduto').DataTable().rows().count() == 0) &&
        ($('#tabelaItensServico').DataTable().rows().count() == 0)) {
        msgAlerta('Solicitação sem itens, impossível continuar');
        return false;
    } return true;
};

function limpaCamposMaterial() {
    $('#txtPrecoMaterial').val('');
    $('#txtQtdeMaterial').val('');
    $('#txtMaterial').val('');
    $('#txtCorMaterial').val('');
    $('#txtDepositoMaterial').val('');
    $('#txtOCMaterial').val('');
    $('#txtUnidadeMaterial').val('');
    $('#txtUniCompraMaterial').val('');
    $('#txtFatConvMaterial').val('');
    $('#txtValorMaterial').val('');
    $('#txtEspecificacaoMaterial').val('');
    $('#txtContaContMaterial').val('');
    $('#txtObsMaterial').val('')
    $('#txtIndexMat').val('')
};

function limpaCamposProduto() {
    $('#txtPrecoProduto').val('');
    $('#txtQtdeProduto').val('');
    $('#txtProduto').val('');
    $('#txtCorProduto').val('');
    $('#txtDepositoProduto').val('');
    $('#txtUnidadeProduto').val('');
    $('#txtUniCompraProduto').val('');
    $('#txtFatConvProduto').val('');
    $('#txtValorProduto').val('');
    $('#txtTamProduto').val('');
    $('#txtEspecificacaoProduto').val('');
    $('#txtContaContProduto').val('');
    $('#txtObsProduto').val('')
    $('#txtIndexProd').val('')
};

function limpaCamposServico() {
    $('#txtPrecoServico').val('');
    $('#txtQtdeServico').val('');
    $('#txtServico').val('');
    $('#txtCorServico').val('');
    $('#txtDepositoServico').val('');
    $('#txtOCServico').val('');
    $('#txtUnidadeServico').val('');
    $('#txtUniCompraServico').val('');
    $('#txtFatConvServico').val('');
    $('#txtValorServico').val('');
    $('#txtEspecificacaoServico').val('');
    $('#txtContaContServico').val('');
    $('#txtObsServico').val('')
    $('#txtIndexServ').val('')
};

function editaMaterial(item, index) {
    insereValor('#txtMaterial', item[0], item[1]);
    insereValor('#txtCorMaterial', item[2], '');
    insereValor('#txtDepositoMaterial', item[3], '');
    insereValor('#txtOCMaterial', item[5], '');
    insereValor('#txtUnidadeMaterial', item[6]);
    insereValor('#txtUniCompraMaterial', item[7]);
    insereValor('#txtFatConvMaterial', item[8]);
    insereValor('#txtQtdeMaterial', item[9]);
    insereValor('#txtPrecoMaterial', item[10]);
    insereValor('#txtValorMaterial', item[11]);
    insereValor('#txtEspecificacaoMaterial', item[12]);
    insereValor('#txtContaContMaterial', item[13], '');
    insereValor('#txtIndexMat', index);
    insereValor('#txtObsMaterial', item[16])
};

function editaProduto(item, index) {
    insereValor('#txtProduto', item[0], item[1]);
    insereValor('#txtCorProduto', item[2], '');
    insereValor('#txtTamProduto', item[3], '');
    insereValor('#txtDepositoProduto', item[4], '');
    insereValor('#txtUnidadeProduto', item[6]);
    insereValor('#txtUniCompraProduto', item[7]);
    insereValor('#txtQtdeProduto', item[8]);
    insereValor('#txtPrecoProduto', item[9]);
    insereValor('#txtValorProduto', item[10]);
    insereValor('#txtEspecificacaoProduto', item[11]);
    insereValor('#txtContaContProduto', item[12], '');
    insereValor('#txtIndexProd', index);
    insereValor('#txtObsProduto', item[15])
};

function editaServico(item, index) {
    insereValor('#txtServico', item[0], item[1]);
    insereValor('#txtQtdeServico', item[2]);
    insereValor('#txtPrecoServico', item[3]);
    insereValor('#txtValorServico', item[4]);
    insereValor('#txtEspecificacaoServico', item[5]);
    insereValor('#txtContaContServico', item[6], '');
    insereValor('#txtIndexServ', index);
    insereValor('#txtObsServico', item[9])
};

function retornaProximaOrdem() {
    let ordem = 0;

    $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
        ordem = item[15] > ordem ? item[15] : ordem;
    });

    $('#tabelaItensProduto').DataTable().rows().data().map(item => {
        ordem = item[14] > ordem ? item[14] : ordem;
    });

    $('#tabelaItensServico').DataTable().rows().data().map(item => {
        ordem = item[8] > ordem ? item[8] : ordem;
    });

    return ++ordem;
};

$('#tabelaItensMaterial').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
});

$('#tabelaItensProduto').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
});

function totalizarItens() {
    document.querySelector("#labelMaterial").innerHTML = `Material (${$('#tabelaItensMaterial').DataTable().rows().count()})`;
    document.querySelector("#labelProduto").innerHTML = `Produto (${$('#tabelaItensProduto').DataTable().rows().count()})`;
    document.querySelector("#labelServico").innerHTML = `Serviço  (${$('#tabelaItensServico').DataTable().rows().count()})`;
};

function preencheComZero() {
    setTimeout(() => {
        $('.camposGrade').map((index) => {
            if ($($('.camposGrade')[index]).val() == '') {
                $($('.camposGrade')[index]).val('0');
            }
        });
    }, 100);
};

async function buscaFotoProduto(codigo, ordem) {
    const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    try {
        const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
        const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

        if (!response) {
            return;
        }
        const jsonStr = await response.json();
        if (response.status != 200) {
            $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
            return;
        }

        const sBase64 = jsonStr;
        $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
        console.error(error);
        $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
};

function retornaFotoProduto(codigo, ordem) {
    buscaFotoProduto(codigo, ordem);
    const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    return `<img class="imagem" id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="" height="75" width="75"/>`
};

function criptografaCodigo(codigo) {
    return btoa(codigo).replaceAll('=', '');
};

function retornaItens({ efetivar }) {
    let arrItens = [];
    $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
        arrItens.push({
            CODIGO: item[0],
            DESCRICAO: item[1],
            COR: item[2],
            DEPOSITO: item[3],
            ORDEM_COMPRA: item[5],
            UNIDADE: item[6],
            UNI_COM: item[7],
            DIVISOR: item[8],
            QTDE: item[9],
            PRECO: item[10],
            ESPECIFICA: item[12],
            CONTA_CONT: item[13],
            SITUACAO: item[14],
            ORDEM: item[15],
            TP_ITEM: 'M',
            STATUS: efetivar ? 'B' : 'D',
            OBS: item[16],
        })
    });

    $('#tabelaItensProduto').DataTable().rows().data().map(item => {
        arrItens.push({
            CODIGO: item[0],
            DESCRICAO: item[1],
            COR: item[2],
            TAM: item[3],
            DEPOSITO: item[4],
            UNIDADE: item[6],
            UNI_COM: item[7],
            QTDE: item[8],
            PRECO: item[9],
            ESPECIFICA: item[11],
            CONTA_CONT: item[12],
            SITUACAO: item[13],
            ORDEM: item[14],
            TP_ITEM: 'P',
            STATUS: efetivar ? 'B' : 'D',
            OBS: item[15],
        })
    });

    $('#tabelaItensServico').DataTable().rows().data().map(item => {
        arrItens.push({
            CODIGO: item[0],
            DESCRICAO: item[1],
            QTDE: item[2],
            PRECO: item[3],
            ESPECIFICA: item[5],
            CONTA_CONT: item[6],
            SITUACAO: item[7],
            ORDEM: item[8],
            TP_ITEM: 'S',
            STATUS: efetivar ? 'B' : 'D',
            OBS: item[9],
        })
    });
    return arrItens;
};

function adicionaBotoes() {
    return '<div class="divBtnOpcoes"> ' +
        '       <button class="botaoOpcoes btn-editar" type="button" title="Editar"><span class="fas fa-edit" style="color:green"></span>  </button>       ' +
        '       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
        '     </div>';
};

function confirmaItem() {
    try {
        if ($('#tabelaGradeProduto').DataTable().rows().count() == 0) {
            $('#modalItem').modal('hide');
            return;
        };

        if ($('#txtProdutoGrade').val() == '') {
            msgAlerta('Produto não informado, impossível continuar');
            return;
        };
        let ordem = retornaProximaOrdem();
        let grade = [];
        const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
        listaDados.forEach(dado => {
            const objeto = Object.entries(dado);
            let coluna;
            const colunas = objeto.map(prop => prop[0]);

            for (let i = 0; i < colunas.length; i++) {
                if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
                    coluna = RetornaIdTamFormatado(colunas[i], true);
                    const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
                    const idFormatado = idSemFormatacao.split("value=")[0];
                    const retorno = {
                        CODIGO: pegaChave('#txtProdutoGrade'),
                        DESCRICAO: pegaDescricao('#txtProdutoGrade'),
                        COR: dado.COR,
                        TAM: coluna,
                        DEPOSITO: pegaChave('#txtDepositoProduto'),
                        UNIDADE: pegaValor('#txtUnidadeProduto'),
                        UNI_COM: pegaValor('#txtUniCompraProduto'),
                        QTDE: $(`#${idFormatado}`).val(),
                        PRECO: $('#txtPrecoProduto').val(),
                        VALOR: retornaMultiplicacao($(`#${idFormatado}`).val(), pegaValor('#txtPrecoProduto')),
                        ESPECIFICA: pegaValor('#txtEspecificacaoProduto'),
                        CONTA_CONT: pegaChave('#txtContaContProduto'),
                        SITUACAO: 'A',
                        ORDEM: ($(`#${idFormatado}`).val() > 0) && ordem++,
                        TP_ITEM: 'P'
                    };
                    grade.push(retorno);
                }
            }
        });

        grade.map((item) => {
            if (parseFloat(item.QTDE) > 0) {
                addItem(item);
            }
        });

        $('#modalItem').modal('hide');
        limpaCamposProduto();
    } finally {

    }
};

function addItem(sItem) {
    if (sItem.TP_ITEM == 'P') {
        $('#tabelaItensProduto').DataTable().row.add(
            [
                sItem.CODIGO,
                sItem.DESCRICAO,
                sItem.COR,
                sItem.TAM,
                sItem.DEPOSITO,
                retornaFotoProduto(sItem.CODIGO, sItem.ORDEM),
                sItem.UNIDADE,
                sItem.UNI_COM,
                sItem.QTDE,
                sItem.PRECO,
                sItem.VALOR.toFixed(2),
                sItem.ESPECIFICA,
                sItem.CONTA_CONT,
                sItem.SITUACAO,
                sItem.ORDEM,
                sItem.OBS ?? '',
                adicionaBotoes()
            ]).draw(false);
    } else if (sItem.TP_ITEM == 'M') {
        $('#tabelaItensMaterial').DataTable().row.add(
            [
                sItem.CODIGO,
                sItem.DESCRICAO,
                sItem.COR,
                sItem.DEPOSITO,
                retornaFotoProduto(sItem.CODIGO, sItem.ORDEM),
                sItem.ORDEM_COMPRA,
                sItem.UNIDADE,
                sItem.UNI_COM,
                sItem.DIVISOR,
                sItem.QTDE,
                sItem.PRECO,
                sItem.VALOR.toFixed(2),
                sItem.ESPECIFICA,
                sItem.CONTA_CONT,
                sItem.SITUACAO,
                sItem.ORDEM,
                sItem.OBS ?? '',
                adicionaBotoes()
            ]).draw(false);
    } else if (sItem.TP_ITEM == 'S') {
        $('#tabelaItensServico').DataTable().row.add(
            [
                sItem.CODIGO,
                sItem.DESCRICAO,
                sItem.QTDE,
                sItem.PRECO,
                sItem.VALOR.toFixed(2),
                sItem.ESPECIFICA,
                sItem.CONTA_CONT,
                sItem.SITUACAO,
                sItem.ORDEM,
                sItem.OBS ?? '',
                adicionaBotoes()
            ]).draw(false);
    }
};

async function gravaDados({ efetivar }) {
    $.LoadingOverlay('show');
    try {

        const solicitacao = {
            NUMERO: pegaValor('#txtNumero'),
            EMPRESA: pegaValor('#selectEmpresa'),
            DT_INICIO: pegaValor('#txtDataCadastro'),
            USUARIO: pegaValor('#txtUsuario'),
            SOLICITANTE: pegaChave('#txtSolicitante'),
            PRAZO: pegaChave('#txtPrazo'),
            DATA: pegaValor('#txtDataEmissao'),
            ENTREGA: pegaValor('#txtDataEntrega'),
            DT_BAIXA: pegaValor('#txtDataBaixa') != '' ? pegaValor('#txtDataBaixa') : `1899-01-01T00:00:00Z`,
            COLECAO: pegaChave('#txtColecao'),
            MOTIVO: pegaChave('#txtMotivo'),
            ID_TIPO: pegaChave('#txtTipo'),
            TAB_PRECO: pegaChave('#txtTabPreco'),
            CENTRO_CUSTO: pegaChave('#txtCentroCusto'),
            LIBERADO: pegaChave('#txtStatusLib'),
            STATUS: pegaChave('#txtStatus'),
            OBS: pegaValor('#txtObs'),
            ITENS: retornaItens({ efetivar }),
            CODCLI: pegaChave('#txtCliente'),
        };

        const response = await requisicao('POST', '/sisplan/solicitacao_compra/v1/solicitacao_compra?', `ID_USUARIO=${getCookie('id_usuario')}`, JSON.stringify(solicitacao), 90000);

        if (!response) {
            $.LoadingOverlay('hide');
            return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay('hide');
            msgAlerta(jsonStr.mensagem);
            return;
        }

        const itensNaoEfetivados = jsonStr?.retornoGravaItens?.itensNaoEfetivados

        if (itensNaoEfetivados && itensNaoEfetivados.length > 0) {
            ModalItensNaoEfetivados.carregarModal({ itens: itensNaoEfetivados })
            return
        }
        criaMensagemSucesso(`Solicitação ${pegaValor('#txtNumero')} gravada com sucesso!`, () => { window.location.href = `${BASE_URI}/solicitacao_compra`; });
    } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgAlerta(`Não foi possível gravar os dados da solicitação: ${error}`);
    } finally {
        $.LoadingOverlay('hide');
    }
};

function retornaMultiplicacao(value1, value2) {
    let valor = (value1 * value2);
    return valor;
};

function adicionaPaginacao() {
    $(".next").click(async function () {
        let validator = $("#msform").validate();
        let liberado = true;

        if ($(this).attr("id") == "avancar1") {
            validator.element("#txtSolicitante");
            validator.element("#txtTipo");
            validator.element("#txtDataEmissao");
            validator.element("#txtDataEntrega");
            if (!(validator.element("#txtSolicitante") && validator.element("#txtTipo") && validator.element("#txtDataEmissao") && validator.element("#txtDataEntrega"))) {
                liberado = false;
            }
        }

        if (liberado) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();
            $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
            nextFs.show();
            currentFs.animate({
                opacity: 0,
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    nextFs.css({
                        opacity,
                    });
                },
                duration: 600,
            });
            $("#tabelaItensMaterial").DataTable().columns.adjust().draw(false);
            $("#tabelaItensProduto").DataTable().columns.adjust().draw(false);
            $("#tabelaItensServico").DataTable().columns.adjust().draw(false);
        }
    });

    $(".previous").click(async function () {
        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();

        $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");

        previousFs.show();

        currentFs.animate({
            opacity: 0,
        }, {
            step(now) {
                opacity = 1 - now;

                currentFs.css({
                    display: "none",
                    position: "relative",
                });
                previousFs.css({
                    opacity,
                });
            },
            duration: 600,
        });
    });
};

$(document).ready(async function () {

    async function setaDatas() {
        await setarDataAtual('txtDataEmissao');
        await setarDataAtual('txtDataEntrega');
        await setarDataAtual('txtDataCadastro');
    };

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    adicionaPaginacao();
    await adicionaMascaraCampos();
    adicionaValidacoes();
    await setaDatas();

    function bloqueiaCampoNumero() {
        $('#txtNumero').prop('disabled', true);
        $('#txtNumero').prop('readonly', true);
    };

    componenteFiltro('cliente', false, false)

    function adicionaValidacoes() {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtSolicitante: {
                    required: true,
                },
                txtTipo: {
                    required: true,
                },
                txtDataEmissao: {
                    required: true,
                },
                txtDataEntrega: {
                    required: true,
                }
            },
            messages: {
                txtSolicitante: {
                    required: "Informe um solicitante.",
                },
                txtTipo: {
                    required: "Informe um tipo.",
                },
                txtDataEmissao: {
                    required: "Informe uma data.",
                },
                txtDataEntrega: {
                    required: "Informe uma data.",
                }
            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });
    };

    await adicionaEmpresas();
    criaDataTablePadrao('#tabelaItensMaterial', false, false, false, false, true, true, '400px', null, null, [], [], [], [11], {}, 2, '', '', false, [], [9]);
    criaDataTablePadrao('#tabelaItensProduto', false, false, false, false, true, true, '400px', null, null, [], [], [], [10], {}, 2, '', '', false, [], [8]);
    criaDataTablePadrao('#tabelaItensServico', false, false, false, false, true, true, '400px', null, null, [], [], [], [4], {}, 2, '', '', false, [], [2]);
    await validaEdicao();

    if ($('#txtNumero').val() == '') {
        $('#txtNumero').val(await RetornaProximo('SOL_COMPRA', 'SOL_COMPRA', 'NUMERO', 6));
        $('#txtUsuario').val(getCookie("usuario"));
        bloqueiaCampoNumero();
    }

    async function validaEdicao() {
        const sSolicitacao = $(window.location.href.split('/')).get(-1);

        if (sSolicitacao == 'create') {
            return;
        };

        $.LoadingOverlay('show');
        try {
            const dados = await retornaDadosSolicitacao(atob(sSolicitacao));
            if (!dados) {
                return
            }
            const itens = await retornaDadosItens(atob(sSolicitacao));

            insereValor('#txtNumero', dados.NUMERO);
            $('#selectEmpresa').val(dados.EMPRESA).change();
            if (dados.DT_INICIO != null) {
                insereValor('#txtDataCadastro', dados.DT_INICIO.slice(0, 10));
            }
            insereValor('#txtUsuario', dados.USUARIO);
            if (dados.SOLICITANTE != null && dados.NOME != null) {
                insereValor('#txtSolicitante', dados.SOLICITANTE, dados.NOME);
            }
            if (dados.PRAZO != null && dados.DESC_PRAZO != null) {
                insereValor('#txtPrazo', dados.PRAZO, dados.DESC_PRAZO);
            }
            if (dados.DT_EMISSAO != null) {
                insereValor('#txtDataEmissao', dados.EMISSAO.slice(0, 10));
            }
            if (dados.ENTREGA != null) {
                insereValor('#txtDataEntrega', dados.ENTREGA.slice(0, 10));
            }
            if (dados.DT_BAIXA) {
                insereValor('#txtDataBaixa', dados.DT_BAIXA.slice(0, 10));
            }
            if (dados.Colecao != null && dados.DESC_COLECAO != null) {
                insereValor('#txtColecao', dados.COLECAO, dados.DESC_COLECAO);
            }
            if (dados.MOTIVO != null && dados.DESC_MOTIVO != null) {
                insereValor('#txtMotivo', dados.MOTIVO, dados.DESC_MOTIVO);
            }
            if (dados.ID_TIPO != null && dados.DESC_TIPO != null) {
                insereValor('#txtTipo', dados.ID_TIPO, dados.DESC_TIPO);
            }
            if (dados.TAB_PRECO != null && dados.DESC_TABPRECO != null) {
                insereValor('#txtTabPreco', dados.TAB_PRECO, dados.DESC_TABPRECO);
            }
            if (dados.CENTRO_CUSTO != null && dados.DESC_CENTROCUSTO != null) {
                insereValor('#txtCentroCusto', dados.CENTRO_CUSTO, dados.DESC_CENTROCUSTO);
            }
            insereValor('#txtCliente', dados.CODIGO_CLIENTE, dados.NOME_CLIENTE)
            $('#txtStatusLib').val(dados.LIBERADO).change();
            $('#txtStatus').val(dados.STATUS).change();
            insereValor('#txtObs', dados.OBS);
            itens.map(item => { addItem(item) });

            $("#tabelaItensMaterial").DataTable().columns.adjust().draw(false);
            $("#tabelaItensProduto").DataTable().columns.adjust().draw(false);
            $("#tabelaItensServico").DataTable().columns.adjust().draw(false);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function retornaDadosSolicitacao(sNumero) {
        const dadosSelect = {
            tabela: 'SOL_COMPRA',
            camposSelect: [
                'SOL_COMPRA.NUMERO', 'SOL_COMPRA.EMPRESA', 'SOL_COMPRA.DT_INICIO', 'SOL_COMPRA.USUARIO', 'SOL_COMPRA.SOLICITANTE', 'SOL_COMPRA.PRAZO',
                'SOL_COMPRA.DATA EMISSAO', 'SOL_COMPRA.ENTREGA', 'SOL_COMPRA.DT_BAIXA', 'SOL_COMPRA.COLECAO', 'SOL_COMPRA.MOTIVO', 'SOL_COMPRA.ID_TIPO',
                'SOL_COMPRA.TAB_PRECO', 'SOL_COMPRA.CENTRO_CUSTO', 'SOL_COMPRA.LIBERADO', 'SOL_COMPRA.STATUS', 'SOL_COMPRA.OBS', 'PESSOAL.NOME',
                'COLECAO.DESCRICAO DESC_COLECAO', 'MENSAGEM.DESCRICAO DESC_MOTIVO', 'TIPO.DESCRICAO DESC_TIPO', 'REGIAO.DESCRICAO DESC_TABPRECO',
                'CENTROCUSTO.DESCRICAO DESC_CENTROCUSTO, TABPRZ.DESCRICAO DESC_PRAZO, SOL_COMPRA.CODCLI CODIGO_CLIENTE, ENTIDADE.NOME NOME_CLIENTE'
            ],
            leftJoin: [
                { tabela: 'PESSOAL', condicao: 'PESSOAL.CODIGO         = SOL_COMPRA.SOLICITANTE' },
                { tabela: 'COLECAO', condicao: 'COLECAO.CODIGO         = SOL_COMPRA.COLECAO' },
                { tabela: 'MENSAGEM', condicao: 'MENSAGEM.CODMEN       = SOL_COMPRA.MOTIVO' },
                { tabela: 'TIPO', condicao: 'TIPO.ID              = SOL_COMPRA.ID_TIPO' },
                { tabela: 'REGIAO', condicao: 'REGIAO.REGIAO           = SOL_COMPRA.TAB_PRECO' },
                { tabela: 'CENTROCUSTO', condicao: 'CENTROCUSTO.CODIGO = SOL_COMPRA.CENTRO_CUSTO' },
                { tabela: 'TABPRZ', condicao: 'TABPRZ.PRAZO            = SOL_COMPRA.PRAZO ' },
                { tabela: 'ENTIDADE', condicao: 'SOL_COMPRA.CODCLI = ENTIDADE.CODCLI' },
            ],
            where: [`SOL_COMPRA.NUMERO = '${sNumero}'`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            msgAlerta('Não foi possível buscar os dados da solicitação.');
            return;
        }
        return retornoSelect[0];
    };

    async function retornaDadosItens(sNumero) {
        const tipoBanco = await retornaDatabase()

        const camposSelect = [
            'SOL_ITEN.CODIGO',
            'SOL_ITEN.TP_ITEM',
            `CASE SOL_ITEN.TP_ITEM WHEN 'M' THEN MATERIAL.DESCRICAO WHEN 'P' THEN PRODUTO.DESCRICAO WHEN 'S' THEN SERVICO.DESCRICAO END DESCRICAO`,
            'SOL_ITEN.COR',
            'SOL_ITEN.DEPOSITO',
            'SOL_ITEN.ORDEM_COMPRA',
            'SOL_ITEN.UNIDADE',
            'SOL_ITEN.UNI_COM',
            'SOL_ITEN.DIVISOR',
            'SOL_ITEN.TAM',
            'SOL_ITEN.PRECO',
            '(SOL_ITEN.QTDE * UDF_NVL(SOL_ITEN.PRECO)) VALOR',
            'SOL_ITEN.ESPECIFICA',
            'SOL_ITEN.CONTA_CONT',
            'SOL_ITEN.SITUACAO',
            'SOL_ITEN.ORDEM',
            'SOL_ITEN.OBS',
        ]

        switch (tipoBanco.toString().toUpperCase()) {
            case 'FIREBIRD':
                camposSelect.push('(UDF_NVL(SOL_ITEN.QTDE) [SOMA] UDF_NVL(SOL_ITEN.QTDE_B) [SOMA] UDF_NVL(SOL_ITEN.QTDE_CANC)) QTDE')
                break
            case 'ORACLE':
                camposSelect.push('(NVL(SOL_ITEN.QTDE, 0) [SOMA] NVL(SOL_ITEN.QTDE_B, 0) [SOMA] NVL(SOL_ITEN.QTDE_CANC, 0)) QTDE')
                break
            case 'SQLSERVER':
                camposSelect.push('(CAST(ISNULL(SOL_ITEN.QTDE, 0) AS FLOAT) [SOMA] CAST(ISNULL(SOL_ITEN.QTDE_B, 0) AS FLOAT) [SOMA] CAST(ISNULL(SOL_ITEN.QTDE_CANC, 0) AS FLOAT) ) QTDE')
                break
            case 'POSTGRES':
                camposSelect.push('(COALESCE(SOL_ITEN.QTDE, 0) [SOMA] COALESCE(SOL_ITEN.QTDE_B, 0) [SOMA] COALESCE(SOL_ITEN.QTDE_CANC, 0)) QTDE')
                break
            default:
                break
        }
        const dadosSelect = {
            tabela: 'SOL_ITEN',
            camposSelect,
            leftJoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO   = SOL_ITEN.CODIGO' },
            { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = SOL_ITEN.CODIGO' },
            { tabela: 'SERVICO', condicao: 'SERVICO.CODIGO   = SOL_ITEN.CODIGO' }],
            where: [`SOL_ITEN.NUMERO = '${sNumero}'`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            msgAlerta('Não foi possível buscar os dados dos itens.');
            return;
        }
        return retornoSelect;
    };

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
    $('#txtSolicitante').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
    $('#txtPrazo').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "prazo chave", "descricao descricao"], "where": null}`);
    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
    $('#txtCentroCusto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":[ "codmen chave", "descricao descricao"], "where": null}`);
    $('#txtTipo').autocompleta(1, `JSON={ "tabela":"TIPO", "camposSelect":[ "ID chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtServico').autocompleta(1, `JSON={ "tabela":"SERVICO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContaContMaterial').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContaContProduto').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContaContServico').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').on('blur', function () {
        $('#txtCorMaterial').unbind('autocompleta');
        $('#txtCorMaterial').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btn-CorMaterial').off();
        $('#btn-CorMaterial').unbind('pesquisa');
        $('#btn-CorMaterial').pesquisa_array(['#txtCorMaterial'], ['COR'], ['DESCRICAO'],
            `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", 
                                      "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],
                                      "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                                      "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                                      "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
    });
    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtProduto').on('blur', function () {
        $('#txtCorProduto').unbind('autocompleta');
        $('#txtCorProduto').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btn-CorProduto').off();
        $('#btn-CorProduto').unbind('pesquisa');
        $('#btn-CorProduto').pesquisa_array(['#txtCorProduto'], ['COR'], ['DESCRICAO'],
            `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", 
                                      "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],
                                      "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], 
                                      "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], 
                                      "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
    });
    $('#txtProduto').on('blur', function () {
        $('#txtTamProduto').unbind('autocompleta');
        $('#txtTamProduto').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, TAM DESCRICAO"], "where": [] }`, [], [], []);
        $('#btn-TamProduto').off();
        $('#btn-TamProduto').unbind('pesquisa');
        $('#btn-TamProduto').pesquisa_array(['#txtTamProduto'], ['TAM'], ['TAM'],
            `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", 
                                      "camposSelect":[ "PA_ITEN.TAM" ],
                                      "groupBy": ["PA_ITEN.TAM"], 
                                      "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Tamanho', 'TABTAM');
    });
    $('#txtDepositoMaterial').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtDepositoProduto').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtOCMaterial').autocompleta(1, `JSON={ "tabela":"COMPRA", "camposSelect":[ "numero chave", "codfor descricao"], "where": null}`);
    $("#btn-solicitante").pesquisa("#txtSolicitante", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "codigo", "nome"]}`, "Pesquisa Solicitante", "PESSOAL");
    $("#btn-prazo").pesquisa("#txtPrazo", "PRAZO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO"]}`, "Pesquisa Prazo", "TABPRZ");
    $("#btn-Colecao").pesquisa("#txtColecao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COLECAO", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Coleção", "COLECAO");
    $("#btn-TabPreco").pesquisa("#txtTabPreco", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, "Pesquisa Tabela", "regiao");
    $("#btn-CentroCusto").pesquisa("#txtCentroCusto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Centro Custo", "CentroCusto");
    $("#btn-Motivo").pesquisa("#txtMotivo", "CODMEN", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, "Pesquisa Mensagem", "mensagem");
    $("#btn-Tipo").pesquisa("#txtTipo", "ID", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO"]}`, "Pesquisa Tipo", "tipo");
    $("#btn-Material").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Material", "material");
    $("#btn-Servico").pesquisa("#txtServico", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Serviço", "servico");
    $("#btn-Produto").pesquisa("#txtProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Material", "produto");
    $("#btn-DepositoMaterial").pesquisa("#txtDepositoMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "deposito");
    $("#btn-DepositoProduto").pesquisa("#txtDepositoProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "deposito");
    $("#btn-OCMaterial").pesquisa("#txtOCMaterial", "NUMERO", "CODFOR", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COMPRA", "camposSelect":[ "NUMERO", "CODFOR"]}`, "Pesquisa OC", "compra");
    $("#btn-ContaContMaterial").pesquisa("#txtContaContMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa C. Contábil", "conta_cont");
    $("#btn-ContaContProduto").pesquisa("#txtContaContProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa C. Contábil", "conta_cont");
    $("#btn-ContaContServico").pesquisa("#txtContaContServico", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa C. Contábil", "conta_cont");
    $('#txtProdutoGrade').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-ProdutoGrade').pesquisa('#txtProdutoGrade', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Produto', 'PRODUTO');
    $('#btn-limpa-ProdutoGrade').on('click', function () { $('#txtProdutoGrade').val('') });

    $('#btn-limpar-solicitante').on('click', function () {
        $('#txtSolicitante').val('');
    });

    $('#btn-limpar-prazo').on('click', function () {
        $('#txtPrazo').val('');
    });

    $('#btn-limpar-Colecao').on('click', function () {
        $('#txtColecao').val('');
    });

    $("#btn-limpar-TabPreco").on('click', function () {
        $('#txtTabPreco').val('');
    });

    $("#btn-limpar-CentroCusto").on('click', function () {
        $('#txtCentroCusto').val('');
    });

    $("#btn-limpar-Motivo").on('click', function () {
        $('#txtMotivo').val('');
    });

    $("#btn-limpar-Tipo").on('click', function () {
        $('#txtTipo').val('');
    });

    $("#btn-limpar-Material").on('click', function () {
        $('#txtMaterial').val('');
    });

    $("#btn-limpar-Servico").on('click', function () {
        $('#txtServico').val('');
    });

    $("#btn-limpar-Produto").on('click', function () {
        $('#txtProduto').val('');
    });

    $("#btn-limpar-CorMaterial").on('click', function () {
        $('#txtCorMaterial').val('');
    });

    $("#btn-limpar-CorProduto").on('click', function () {
        $('#txtCorProduto').val('');
    });

    $("#btn-limpar-TamProduto").on('click', function () {
        $('#txtTamProduto').val('');
    });

    $("#btn-limpar-DepositoMaterial").on('click', function () {
        $('#txtDepositoMaterial').val('');
    });

    $("#btn-limpar-DepositoProduto").on('click', function () {
        $('#txtDepositoProduto').val('');
    });

    $("#btn-limpar-OCMaterial").on('click', function () {
        $('#txtOCMaterial').val('');
    });

    $("#btn-limpar-ContaContMaterial").on('click', function () {
        $('#txtContaContMaterial').val('');
    });

    $("#btn-limpar-ContaContProduto").on('click', function () {
        $('#txtOCProduto').val('');
    });

    $("#btn-limpar-ContaContServico").on('click', function () {
        $('#txtOCServico').val('');
    });

    $('#btnGravar').click(async function () {
        if (validaGravar()) {
            msgAlerta(
                'Deseja efetivar a solicitação?',
                () => null,
                () => gravaDados({ efetivar: false }),
                () => gravaDados({ efetivar: true }),
                () => null,
                true,
            )
        }
    });

    $('#avancar1').on('click', function () {
        totalizarItens();
    });

    $('#txtProdutoGrade').on('blur', async function () {
        const codigo = pegaChave('#txtProdutoGrade');
        if (codigo == '') {
            return;
        };
        await explodeGradeProduto(codigo);
    });

    $('#modalItem').on('hidden.bs.modal', function (_) {
        $('#txtProdutoGrade').val('');
        if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
            $('#tabelaGradeProduto').DataTable().destroy();
            $('#tabelaGradeProduto').empty();
        };
    });

    async function explodeGradeProduto(codigo) {
        $.LoadingOverlay('show');
        try {
            let tam;
            if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
                $('#tabelaGradeProduto').DataTable().destroy();
                $('#tabelaGradeProduto').empty();
            };

            const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.RESULT[0].mensagem);
            }

            for (let i = 0; i < parseInt(jsonStr.length); i++) {
                const colunas = Object.keys(jsonStr[i]);
                const tamanhos = [];
                colunas.forEach((coluna) => {
                    if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
                        tamanhos.push(coluna);
                    }
                });

                tamanhos.sort();

                const jsonObject = jsonStr.map(obj => {
                    const newObject = { ...obj };
                    delete newObject.CODIGO;
                    delete newObject.POSICAO;
                    Object.keys(obj).forEach(key => {
                        tam = RetornaIdTamFormatado(key);
                        if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
                            newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="${jsonStr[i][tam]}">`;
                            newObject[tam.split('HIFEN')[1]] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="0">`;
                            delete newObject[tam];
                        }
                    });
                    return { ...newObject };
                });

                if (i == 0) {
                    const titulosFixos = ['COR', 'DESC_COR'];
                    const titulosGeral = [...titulosFixos, ...tamanhos];
                    const titulos = titulosGeral.map(titulo => {
                        const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
                        const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
                        return objeto;
                    });
                    criaDataTablePadrao('#tabelaGradeProduto', false, false, false, false, true, false, '250px', jsonObject, titulos);
                }
            }

        } finally {
            $.LoadingOverlay('hide');

            $('.camposGrade').on('blur', function () {
                preencheComZero();
            });

            preencheComZero();
        }
    };

    async function adicionaEmpresas() {
        const pesquisaParam = {
            tabela: 'EMPRESA',
            camposSelect: ['EMP_PAT', 'EMP_NOME'],
            where: ['1 = 1'],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        jsonStr.map(emp => {
            $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
        });
    };

    $("#voltarAcesso").on("click", async function () {
        window.location.href = `${BASE_URI}/solicitacao_compra`;
    });

    async function adicionaMascaraCampos() {
        const bQtdeCasasDecimais = parseFloat(await CopiaParametro('SISTEMA', 1)) + 2;

        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimais').on('blur', function () {
            if ($(this).val() == '') {
                $(this).val('0.00');
            }
        });

        $('#txtPrecoProduto').maskMoney({
            decimal: ".",
            thousands: "",
            precision: parseFloat(bQtdeCasasDecimais),
        });

        $('#txtPrecoMaterial').maskMoney({
            decimal: ".",
            thousands: "",
            precision: parseFloat(bQtdeCasasDecimais),
        });

        $('#txtPrecoServico').maskMoney({
            decimal: ".",
            thousands: "",
            precision: parseFloat(bQtdeCasasDecimais),
        });

    };


    $('#tabelaItensMaterial').on('click', '.btn-excluir', async function () {
        $('#tabelaItensMaterial').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalizarItens();
    });

    $('#tabelaItensProduto').on('click', '.btn-excluir', async function () {
        $('#tabelaItensProduto').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalizarItens();
    });

    $('#tabelaItensServico').on('click', '.btn-excluir', async function () {
        $('#tabelaItensServico').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalizarItens();
    });

    $('#tabelaItensMaterial').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensMaterial').DataTable().row($(this).parents('tr')).data();
        if (itens[14] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaMaterial(itens, index);
    });

    $('#tabelaItensProduto').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensProduto').DataTable().row($(this).parents('tr')).data();
        if (itens[13] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaProduto(itens, index);
    });

    $('#tabelaItensServico').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensServico').DataTable().row($(this).parents('tr')).data();
        if (itens[7] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaServico(itens, index);
    });

    function AdicionarMaterial() {
        const valorUnit = $('#txtPrecoMaterial').val();
        const qtde = $('#txtQtdeMaterial').val();
        const codigo = pegaChave('#txtMaterial');
        const descricao = pegaDescricao('#txtMaterial');
        const cor = pegaChave('#txtCorMaterial');
        const deposito = pegaChave('#txtDepositoMaterial');
        const oc = pegaChave('#txtOCMaterial');
        const unidade = $('#txtUnidadeMaterial').val();
        const uni_compra = $('#txtUniCompraMaterial').val();
        const fator_conv = $('#txtFatConvMaterial').val();
        const valor = $('#txtValorMaterial').val();
        const especificacao = $('#txtEspecificacaoMaterial').val();
        const cContabil = pegaChave('#txtContaContMaterial');
        const indice = pegaValor('#txtIndexMat');
        const ordem = retornaProximaOrdem();
        const obs = $('#txtObsMaterial').val()

        if (codigo == '') {
            msgAlerta('Material não informado, impossível continuar');
            return;
        }

        if (cor == '') {
            msgAlerta('Cor não informada, impossível continuar');
            return;
        }

        if (deposito == '') {
            msgAlerta('Depósito não informado, impossível continuar');
            return;
        }

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        }
        try {
            if (indice == '') {
                $('#tabelaItensMaterial').DataTable().row.add([
                    codigo,
                    descricao,
                    cor,
                    deposito,
                    retornaFotoProduto(codigo, ordem),
                    oc,
                    unidade,
                    uni_compra,
                    fator_conv,
                    qtde,
                    valorUnit,
                    valor,
                    especificacao,
                    cContabil,
                    'A',
                    ordem,
                    obs,
                    adicionaBotoes()
                ]).draw(false);
            } else {
                let data_old = $('#tabelaItensMaterial').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = cor;
                data_old[3] = deposito;
                data_old[4] = retornaFotoProduto(codigo, data_old[15]);
                data_old[5] = oc;
                data_old[6] = unidade;
                data_old[7] = uni_compra;
                data_old[8] = fator_conv;
                data_old[9] = qtde;
                data_old[10] = valorUnit;
                data_old[11] = valor;
                data_old[12] = especificacao;
                data_old[13] = cContabil;
                data_old[16] = obs
                $('#tabelaItensMaterial').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposMaterial();
        }
    };

    function AdicionarProduto() {
        const valorUnit = $('#txtPrecoProduto').val();
        const qtde = $('#txtQtdeProduto').val();
        const codigo = pegaChave('#txtProduto');
        const descricao = pegaDescricao('#txtProduto');
        const cor = pegaChave('#txtCorProduto');
        const tam = pegaChave('#txtTamProduto');
        const deposito = pegaChave('#txtDepositoProduto');
        const unidade = $('#txtUnidadeProduto').val();
        const uni_compra = $('#txtUniCompraProduto').val();
        const valor = $('#txtValorProduto').val();
        const especificacao = $('#txtEspecificacaoProduto').val();
        const cContabil = pegaChave('#txtContaContProduto');
        const indice = pegaValor('#txtIndexProd');
        const ordem = retornaProximaOrdem();
        const obs = $('#txtObsProduto').val()

        if (codigo == '') {
            msgAlerta('Produto não informado, impossível continuar');
            return;
        }

        if (cor == '') {
            msgAlerta('Cor não informada, impossível continuar');
            return;
        }

        if (tam == '') {
            msgAlerta('Tamanho não informado, impossível continuar');
            return;
        }

        if (deposito == '') {
            msgAlerta('Depósito não informado, impossível continuar');
            return;
        }

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        }
        try {
            if (indice == '') {
                $('#tabelaItensProduto').DataTable().row.add([
                    codigo,
                    descricao,
                    cor,
                    tam,
                    deposito,
                    retornaFotoProduto(codigo, ordem),
                    unidade,
                    uni_compra,
                    qtde,
                    valorUnit,
                    valor,
                    especificacao,
                    cContabil,
                    'A',
                    ordem,
                    obs,
                    adicionaBotoes(codigo)
                ]).draw(false);
            } else {
                let data_old = $('#tabelaItensProduto').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = cor;
                data_old[3] = tam;
                data_old[4] = deposito;
                data_old[5] = retornaFotoProduto(codigo, data_old[14]);
                data_old[6] = unidade;
                data_old[7] = uni_compra;
                data_old[8] = qtde;
                data_old[9] = valorUnit;
                data_old[10] = valor;
                data_old[11] = especificacao;
                data_old[12] = cContabil;
                data_old[15] = obs
                $('#tabelaItensProduto').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposProduto();
        }
    };

    function AdicionarServico() {
        const valorUnit = $('#txtPrecoServico').val();
        const qtde = $('#txtQtdeServico').val();
        const codigo = pegaChave('#txtServico');
        const descricao = pegaDescricao('#txtServico');
        const valor = $('#txtValorServico').val();
        const especificacao = $('#txtEspecificacaoServico').val();
        const cContabil = pegaChave('#txtContaContServico');
        const indice = pegaValor('#txtIndexServ');
        const obs = $('#txtObsServico').val()

        if (codigo == '') {
            msgAlerta('Serviço não informado, impossível continuar');
            return;
        }

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        }
        try {
            if (indice == '') {
                $('#tabelaItensServico').DataTable().row.add([
                    codigo,
                    descricao,
                    qtde,
                    valorUnit,
                    valor,
                    especificacao,
                    cContabil,
                    'A',
                    retornaProximaOrdem(),
                    obs,
                    adicionaBotoes()
                ]).draw(false);
            } else {
                let data_old = $('#tabelaItensServico').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = qtde;
                data_old[3] = valorUnit;
                data_old[4] = valor;
                data_old[5] = especificacao;
                data_old[6] = cContabil;
                data_old[9] = obs
                $('#tabelaItensServico').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposServico();
        }
    };

    $('#btnAdicionarMaterial').on('click', async function () {
        AdicionarMaterial();
        totalizarItens();
    });

    $('#btnAdicionarProduto').on('click', async function () {
        AdicionarProduto();
        totalizarItens();
    });

    $('#btnAdicionarServico').on('click', async function () {
        AdicionarServico();
        totalizarItens();
    });

    $("#txtQtdeMaterial").on('blur', function () {
        insereValor('#txtValorMaterial', retornaMultiplicacao(pegaValor('#txtQtdeMaterial'), pegaValor('#txtPrecoMaterial')).toFixed(2));
    });

    $("#txtPrecoMaterial").on('blur', function () {
        insereValor('#txtValorMaterial', retornaMultiplicacao(pegaValor('#txtQtdeMaterial'), pegaValor('#txtPrecoMaterial')).toFixed(2));
    });

    $("#txtValorMaterial").on('blur', function () {
        insereValor('#txtValorMaterial', retornaMultiplicacao(pegaValor('#txtQtdeMaterial'), pegaValor('#txtPrecoMaterial')).toFixed(2));
    });

    $("#txtQtdeProduto").on('blur', function () {
        insereValor('#txtValorProduto', retornaMultiplicacao(pegaValor('#txtQtdeProduto'), pegaValor('#txtPrecoProduto')).toFixed(2));
    });

    $("#txtPrecoProduto").on('blur', function () {
        insereValor('#txtValorProduto', retornaMultiplicacao(pegaValor('#txtQtdeProduto'), pegaValor('#txtPrecoProduto')).toFixed(2));
    });

    $("#txtValorProduto").on('blur', function () {
        insereValor('#txtValorProduto', retornaMultiplicacao(pegaValor('#txtQtdeProduto'), pegaValor('#txtPrecoProduto')).toFixed(2));
    });

    $("#txtQtdeServico").on('blur', function () {
        insereValor('#txtValorServico', retornaMultiplicacao(pegaValor('#txtQtdeServico'), pegaValor('#txtPrecoServico')).toFixed(2));
    });

    $("#txtPrecoServico").on('blur', function () {
        insereValor('#txtValorServico', retornaMultiplicacao(pegaValor('#txtQtdeServico'), pegaValor('#txtPrecoServico')).toFixed(2));
    });

    $("#txtValorServico").on('blur', function () {
        insereValor('#txtValorServico', retornaMultiplicacao(pegaValor('#txtQtdeServico'), pegaValor('#txtPrecoServico')).toFixed(2));
    });

    $('#btnGradeProduto').on('click', async function () {
        if (pegaValor('#txtDepositoProduto') == '') {
            msgAlertaSemConfirmacao('Necessário informar um depósito!');
            return;
        }
        $('#modalItem').modal('show');
    });

    $('#btnConfirmarItem').on('click', async function () {
        confirmaItem();
        totalizarItens();
    });

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");

            $("#tabelaItensMaterial").DataTable().columns.adjust().draw(false);
            $("#tabelaItensProduto").DataTable().columns.adjust().draw(false);
            $("#tabelaItensServico").DataTable().columns.adjust().draw(false);
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "geral") {
                    if (!$("#multiCollapseExample1").hasClass("show"));
                    $("#multiCollapseExample1").collapse("show");
                } else if (Element.node.id == "ObservacoesAba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Observacoes").collapse("show");
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "Itens") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Material").collapse("show");
                        $("#ItensMaterial").collapse("show");
                    }
                } else if (Element.node.id == "produto") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Produto").collapse("show");
                        $("#itensProduto").collapse("show");
                    }
                } else if (Element.node.id == "servico") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Servico").collapse("show");
                        $("#itensServico").collapse("show");
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "documento-tab" ||
                    Element.node.id == "documentoaba"
                ) {
                    if (!$("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == 'VoltarGeral') {
                    $('#VoltarGeral').trigger('click');
                }
            },
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    if (pegaChave('#txtSolicitante') == '') {
                        insereValor('#txtSolicitante', ' ', ' ')
                    };
                    if (pegaChave('#txtTipo') == '') {
                        insereValor('#txtTipo', ' ', ' ')
                    };

                    $('#avancar1').trigger('click');
                }
            },
        });

        driver.defineSteps([{
            element: "#geral-tab",
            popover: {
                title: "Aba Geral",
                description: "Clique aqui para abrir a aba geral.",
                position: "top",
            },
        },
        {
            element: "#geral",
            popover: {
                title: "Cadastro Geral",
                description: "Aqui você pode informar os dados gerais de cadastro da solicitação.",
                position: "bottom",
            },
        },
        {
            element: "#multiCollapseExample1",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados gerais de cadastro.",
                position: "top",
            },
        },
        {
            element: "#txtSolicitante",
            popover: {
                title: "Campo Solicitante",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDataEmissao",
            popover: {
                title: "Campo Emissão",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDataEntrega",
            popover: {
                title: "Campo Entrega",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtTipo",
            popover: {
                title: "Campo Tipo",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#ObservacoesAba",
            popover: {
                title: "Observações",
                description: "Aqui ficam as observações.",
                position: "top",
            },
        },
        {
            element: "#voltarAcesso",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Acesso.",
                position: "top",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para avançar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: "#VoltarGeral",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Geral.",
                position: "top",
            },
        },
        {
            element: "#Itens",
            popover: {
                title: "Itens",
                description: "Clique aqui para abrir os itens.",
                position: "top",
            },
        },
        {
            element: "#MaterialAba",
            popover: {
                title: "Material",
                description: "Clique aqui para abrir os materiais.",
                position: "top",
            },
        },
        {
            element: "#ItensMaterial",
            popover: {
                title: "Campos Material",
                description: "Aqui você pode informar os dados dos materiais.",
                position: "top",
            },
        },
        {
            element: "#txtMaterial",
            popover: {
                title: "Campo Material",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtCorMaterial",
            popover: {
                title: "Campo Cor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDepositoMaterial",
            popover: {
                title: "Campo Depósito",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeMaterial",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarMaterial",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensMaterial_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os materiais da solicitação.',
                position: 'top'
            }
        },
        {
            element: "#produto",
            popover: {
                title: "Produto",
                description: "Clique aqui para abrir os produtos.",
                position: "top",
            },
        },
        {
            element: "#itensProduto",
            popover: {
                title: "Campos Produto",
                description: "Aqui você pode informar os dados dos produtos.",
                position: "top",
            },
        },
        {
            element: "#txtProduto",
            popover: {
                title: "Campo Produto",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtCorProduto",
            popover: {
                title: "Campo Cor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtTamProduto",
            popover: {
                title: "Campo Tamanho",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDepositoProduto",
            popover: {
                title: "Campo Depósito",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeProduto",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarProduto",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensProduto_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os produtos da solicitação.',
                position: 'top'
            }
        },
        {
            element: "#servico",
            popover: {
                title: "Serviço",
                description: "Clique aqui para abrir os serviços.",
                position: "top",
            },
        },
        {
            element: "#itensServico",
            popover: {
                title: "Campos Serviço",
                description: "Aqui você pode informar os dados dos serviços.",
                position: "top",
            },
        },
        {
            element: "#txtServico",
            popover: {
                title: "Campo Serviço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeServico",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarServico",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensServico_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os serviços da solicitação.',
                position: 'top'
            }
        },
        {
            element: "#btnGravar",
            popover: {
                title: "Botão Gravar",
                description: "Ao clicar nesse botão você grava os dados inseridos.",
                position: "left",
            },
        },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });
});