$('#tutorial').on('click', () => {
  $(document).ready(async function() {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoTemplate',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de um novo Tipo Fiscal.',
          position: 'right'
        }
      },
      {
        element: '#tabelaTipoFiscal',
        popover: {
          title: 'Tabela Tipo Fiscal',
          description: 'Aqui estão os dados dos Tipos Fiscais cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
//Grid Acesso//,
$(document).ready(async function() {
  $('#btnFiltros').on('click', () => { $('#modal-filtros').modal('show') });
  $('#btnLimparFiltros').on('click', () => { $('#txtAbreviacao, #txtConsultaCodigo').val('') });

  $('#txtConsultaCodigo').autocompleta(1, `JSON={ "tabela":"TIPO_FISCAL", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
  $('#btnConsultaCodigo').pesquisa('#txtConsultaCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_FISCAL", "camposSelect":["CODIGO", "DESCRICAO", "ABREVI"]}`, 'Consulta Tipo Fiscal', 'TIPO_FISCAL');
  $('#btnLimpaCodigo').on('click', () => { $('#txtConsultaCodigo').val('') });

  $('#btnConsultar').on('click', async function() {
    $('#modal-filtros').modal('hide');
    await fazConsulta();
  });

  $('#btnConsultar').trigger('click');

  async function fazConsulta() {
    try {
      $.LoadingOverlay("show");
      let response;
      let pCodigo = pegaChave('#txtConsultaCodigo') != '' ? ` AND CODIGO = '${pegaChave('#txtConsultaCodigo')}'` : '';

      response = await requisicao(
        'GET',
        '/Sisplan/Funcoes/V1/pesquisa?',
        `JSON={
        "tabela":"TIPO_FISCAL", 
        "camposSelect":["CODIGO", "ABREVI", "DESCRICAO", "EXPORTA", "TIPO_DOC"], 
        "where": ["1=1 ${pCodigo}"]
        }`,
        null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaTipoFiscal").DataTable({
        destroy: true,
        paging: true,
        filter: true,
        info: false,
        autowidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            title: "Código",
            data: "CODIGO",
          },
          {
            title: "Abreviação",
            data: "ABREVI",
          },
          {
            title: "Descrição",
            data: "DESCRICAO",
          },
          {
            title: "Exporta",
            data: "EXPORTA",
          },
          {
            title: "Conhec. Transp.",
            data: "TIPO_DOC",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }


  function retornaBotaoOpcoes(data) {
    let retorno = ''
    retorno = '<div style="text-align:start;"> ' +
      '    <button id="editaOpcoes" class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" > ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#tabelaTipoFiscal').on('click', '#btn-editar', async function() {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipoFiscal').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('TIPO_FISCAL', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `tipo_fiscal/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });


  $('#tabelaTipoFiscal').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipoFiscal').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('TIPO_FISCAL', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `tipo_fiscal/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipoFiscal').on('click', '#btn-excluir', async function() {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $('#tabelaTipoFiscal').DataTable().row($(this).parents('tr')).data();
      msgAlerta(`Você realmente deseja excluir o registro ${data.CODIGO}?`, async function() {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(CODIGO) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/Sisplan/cadastros/V1/tipofiscal?', `CODIGO=${encodeURIComponent(CODIGO.CODIGO)}`, null)
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/tipo_fiscal`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function permissaoAcessos(tela) {
    try {
      $.LoadingOverlay("show");

      let object = new Object();
      object.resultado = true;
      object.mensagem = "";

      if (getCookie("cod_usuario") == "0000") {
        object.ALTERA = "S";
        object.CONSULTA = 'S';
        object.EXCLUI = 'S';
        object.INCLUI = 'S';
        return object;
      }

      try {
        const codusuario = `'${getCookie("cod_usuario")}'`;
        const response = await requisicao(
          "GET",
          `/Sisplan/AcessoMenu/v1/Acesso?`,
          `codusuarios=${codusuario}&telas='${tela}'`,
          null,
          60000
        );

        if (!response) {
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        let valida = await response.json();
        if (response.status != 200) {
          console.error(valida.RESULT[0].mensagem);
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        if (valida.length <= 0) {
          object.ALTERA = "N";
          object.CONSULTA = 'N';
          object.EXCLUI = 'N';
          object.INCLUI = 'N';
          return object;
        }

        return valida[0];
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar permissões da tela.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  const permissaoUsuarioLogado = await permissaoAcessos("TIPO_FISCAL");

  // $('#tabelaItens tbody').on('click', 'tr', async function () {
  //   if (permissaoUsuarioLogado.ALTERA == 'S') {
  //     let data = $('#tabelaTipoFiscal').DataTable().row($(this)).data();
  //     let registroLiberado = await verificarRegistro('TIPO_FISCAL', data[0]);
  //     if (registroLiberado) {
  //       window.location.href = `tipo_fiscal/${data[0]}`;
  //     }
  //   } else {
  //     msgAlertaSemConfirmacao("Sem permissão para alterar!");
  //   }
  // });

});
